var egytcaResource = angular.module('egytcaResource', ['ngResource']);

egytcaResource.factory('egytcaResourceDefaults', [
	function() {

		var defaults = {

			actions: {

				archivate: function(type) {
					return {
						method: 'POST',
						params: { do: RouteConfig.actionFor(type, 'doArchivate') },
						headers: defaults.headers,
						transformRequest: function(data, headersGetter) {
							return 'id='+data.Id;
						},
						transformResponse: defaults.getResponseData
					};
				},

				delete: function(type) {
					return {
						method: 'POST',
						params: { do: RouteConfig.actionFor(type, 'doDelete') },
						headers: defaults.headers,
						transformRequest: function(data, headersGetter) {
							return;
						},
						transformResponse: defaults.getResponseData
					};
				},

				save: function(type) {
					return {
						method: 'POST',
						params: { do: RouteConfig.actionFor(type, 'doEdit') },
						headers: defaults.headers,
						transformRequest: function(data, headersGetter) {
							return param({ params: sanitize(data) });
						},
						transformResponse: defaults.getResponseData
					};
				}
			},

			headers: { 'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8' },

			getResponseData: function(data, headersGetter, status) {

				if (status >= 400)
					return data;

				var parsedData = angular.fromJson(data);
				for (var key in parsedData) {
					if (key != '_debug')
						return parsedData[key]; // asume only one piece of data was returned
				}
			}
		};

		return defaults;
	}
]);

egytcaResource.factory('egytcaResource', ['$resource', 'egytcaResourceDefaults',
	function($resource, egytcaResourceDefaults) {

		return function(type, actionNames, actionsModifier) {

			var actions = [];
			for (var i = 0; i < actionNames.length; i++) {
				var actionName = actionNames[i];
				actions[actionName] = egytcaResourceDefaults.actions[actionName](type);
			}

			if (actionsModifier instanceof Function)
				actionsModifier(actions);

			var EgytcaResource = $resource('Main.php', { id: '@Id' }, actions);
			EgytcaResource.prototype._class = type;

			return EgytcaResource;
		};
	}
]);
