
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- indicators_indicator
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `indicators_indicator`;

CREATE TABLE `indicators_indicator`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(180) NOT NULL COMMENT 'Name',
    `description` VARCHAR(255) COMMENT 'Description',
    `archived` BOOL DEFAULT 0 COMMENT 'Archivado',
    `methodology` MEDIUMTEXT COMMENT 'Metodologia de medicion',
    `decimals` TINYINT DEFAULT 0 COMMENT 'Cantidad de decimales',
    `goal` FLOAT COMMENT 'Value',
    `goalDate` DATETIME COMMENT 'Fecha de publicacion',
    `idealBehavior` TINYINT COMMENT 'Comportamiento ideal',
    `positionId` INTEGER COMMENT 'Encargado de medicion',
    `objectiveId` INTEGER COMMENT 'Objetivo relacionado',
    `dueDate` DATE,
    `finishedDate` DATE,
    `classKey` INTEGER,
    PRIMARY KEY (`id`),
    INDEX `indicators_indicator_FI_1` (`positionId`),
    INDEX `indicators_indicator_FI_2` (`objectiveId`),
    CONSTRAINT `indicators_indicator_FK_1`
        FOREIGN KEY (`positionId`)
        REFERENCES `positions_position` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `indicators_indicator_FK_2`
        FOREIGN KEY (`objectiveId`)
        REFERENCES `objectives_objective` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM COMMENT='Indicators';

-- ---------------------------------------------------------------------
-- indicators_value
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `indicators_value`;

CREATE TABLE `indicators_value`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `value` FLOAT COMMENT 'Value',
    `date` DATE COMMENT 'Date',
    `classKey` INTEGER,
    `numericIndicatorId` INTEGER,
    PRIMARY KEY (`id`),
    INDEX `indicators_value_FI_1` (`numericIndicatorId`),
    CONSTRAINT `indicators_value_FK_1`
        FOREIGN KEY (`numericIndicatorId`)
        REFERENCES `indicators_indicator` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM COMMENT='Indicators values';

-- ---------------------------------------------------------------------
-- indicators_graph
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `indicators_graph`;

CREATE TABLE `indicators_graph`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(180) NOT NULL COMMENT 'Name',
    `graphType` INTEGER(2) COMMENT 'Tipo de Grafico',
    `decimals` INTEGER(2) COMMENT 'Numero de decimales',
    `valueType` INTEGER(2) COMMENT 'Tipo de valor',
    `showValue` INTEGER(2) COMMENT 'Tipo de valor',
    `minX` INTEGER(2) COMMENT 'Menor valor X',
    `maxX` INTEGER(2) COMMENT 'Maximo valor X',
    `minY` INTEGER(2) COMMENT 'Menor valor Y',
    `maxY` INTEGER(2) COMMENT 'Maximo valor Y',
    `description` TEXT COMMENT 'Descripcion',
    `minDate` DATETIME COMMENT 'Menor valor de fecha',
    `maxDate` DATETIME COMMENT 'Maximo valor de fecha',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Indicators graph';

-- ---------------------------------------------------------------------
-- indicators_graphSerie
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `indicators_graphSerie`;

CREATE TABLE `indicators_graphSerie`
(
    `graphId` INTEGER(4) NOT NULL COMMENT 'Id Grafico',
    `indicatorId` INTEGER(5) NOT NULL COMMENT 'Id Serie',
    PRIMARY KEY (`graphId`,`indicatorId`),
    INDEX `indicators_graphSerie_FI_1` (`indicatorId`),
    CONSTRAINT `indicators_graphSerie_FK_1`
        FOREIGN KEY (`indicatorId`)
        REFERENCES `indicators_indicator` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `indicators_graphSerie_FK_2`
        FOREIGN KEY (`graphId`)
        REFERENCES `indicators_graph` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Relacion Graficos y series';

-- ---------------------------------------------------------------------
-- indicators_graphComment
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `indicators_graphComment`;

CREATE TABLE `indicators_graphComment`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `graphId` INTEGER(4) NOT NULL COMMENT 'Id Grafico',
    `commentDate` DATETIME COMMENT 'Menor valor de fecha',
    `comment` TEXT COMMENT 'Descripcion',
    PRIMARY KEY (`id`,`graphId`),
    INDEX `indicators_graphComment_FI_1` (`graphId`),
    CONSTRAINT `indicators_graphComment_FK_1`
        FOREIGN KEY (`graphId`)
        REFERENCES `indicators_graph` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Comentaros de graficos';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
