<?php


/**
 * Base class that represents a query for the 'security_blockedUser' table.
 *
 * Usuarios bloqueados
 *
 * @method BlockedUserQuery orderById($order = Criteria::ASC) Order by the id column
 * @method BlockedUserQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method BlockedUserQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 * @method BlockedUserQuery orderByUnblocked($order = Criteria::ASC) Order by the unBlocked column
 *
 * @method BlockedUserQuery groupById() Group by the id column
 * @method BlockedUserQuery groupByObjecttype() Group by the objectType column
 * @method BlockedUserQuery groupByObjectid() Group by the objectId column
 * @method BlockedUserQuery groupByUnblocked() Group by the unBlocked column
 *
 * @method BlockedUserQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method BlockedUserQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method BlockedUserQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method BlockedUser findOne(PropelPDO $con = null) Return the first BlockedUser matching the query
 * @method BlockedUser findOneOrCreate(PropelPDO $con = null) Return the first BlockedUser matching the query, or a new BlockedUser object populated from the query conditions when no match is found
 *
 * @method BlockedUser findOneById(int $id) Return the first BlockedUser filtered by the id column
 * @method BlockedUser findOneByObjecttype(string $objectType) Return the first BlockedUser filtered by the objectType column
 * @method BlockedUser findOneByObjectid(int $objectId) Return the first BlockedUser filtered by the objectId column
 * @method BlockedUser findOneByUnblocked(boolean $unBlocked) Return the first BlockedUser filtered by the unBlocked column
 *
 * @method array findById(int $id) Return BlockedUser objects filtered by the id column
 * @method array findByObjecttype(string $objectType) Return BlockedUser objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return BlockedUser objects filtered by the objectId column
 * @method array findByUnblocked(boolean $unBlocked) Return BlockedUser objects filtered by the unBlocked column
 *
 * @package    propel.generator.security.classes.om
 */
abstract class BaseBlockedUserQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseBlockedUserQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'BlockedUser', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new BlockedUserQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     BlockedUserQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return BlockedUserQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof BlockedUserQuery) {
            return $criteria;
        }
        $query = new BlockedUserQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   BlockedUser|BlockedUser[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = BlockedUserPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(BlockedUserPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   BlockedUser A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `OBJECTTYPE`, `OBJECTID`, `UNBLOCKED` FROM `security_blockedUser` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new BlockedUser();
            $obj->hydrate($row);
            BlockedUserPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return BlockedUser|BlockedUser[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|BlockedUser[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return BlockedUserQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(BlockedUserPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return BlockedUserQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(BlockedUserPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return BlockedUserQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(BlockedUserPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return BlockedUserQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(BlockedUserPeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return BlockedUserQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(BlockedUserPeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(BlockedUserPeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(BlockedUserPeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query on the unBlocked column
     *
     * Example usage:
     * <code>
     * $query->filterByUnblocked(true); // WHERE unBlocked = true
     * $query->filterByUnblocked('yes'); // WHERE unBlocked = true
     * </code>
     *
     * @param     boolean|string $unblocked The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return BlockedUserQuery The current query, for fluid interface
     */
    public function filterByUnblocked($unblocked = null, $comparison = null)
    {
        if (is_string($unblocked)) {
            $unBlocked = in_array(strtolower($unblocked), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(BlockedUserPeer::UNBLOCKED, $unblocked, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   BlockedUser $blockedUser Object to remove from the list of results
     *
     * @return BlockedUserQuery The current query, for fluid interface
     */
    public function prune($blockedUser = null)
    {
        if ($blockedUser) {
            $this->addUsingAlias(BlockedUserPeer::ID, $blockedUser->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
