<?php

/**
 * SecurityBlockedIpsDoUnblockXAction
 *
 * Desbloqueo de Ip extendiendo BaseListAction
 *
 * @package security
 */

class SecurityBlockedIpsDoUnblockXAction extends BaseListAction {

	function __construct() {
		parent::__construct('BlockedIp');
	}
	
 /**
	* Acciones a ejecutar antes de obtener la coleccion de objetos
	*/
	protected function preList(){
		parent::preList();
		
		$this->filters['ip'] = $_POST['ip'];
		$this->notPaginated = true;

	}
	
 /**
	* Acciones a ejecutar despues de obtener la coleccion de objetos
	*/
	protected function postList(){
		parent::postList();
		
		foreach($this->results as $ip){
			$ip->setUnblockedAt(time());
			$ip->save();
		}
	}
	
}
