<?php

/**
 * SecurityBlockedUsersListAction
 *
 * Listado de usuarios bloquados extendiendo BaseListAction
 *
 * @package    security
 */

class SecurityBlockedAffiliateUsersListAction extends BaseListAction {
	
	function __construct() {
		parent::__construct('AffiliateUser');
	}
	
 /**
	* Acciones a ejecutar antes de obtener la coleccion de objetos
	*/
	protected function preList() {
		parent::preList();

		//aplicar filtro
		$this->filters['selectBlocked'] = true;
		
	}

 /**
	* Acciones a ejecutar despues de obtener la coleccion de objetos
	*/
	protected function postList() {
		parent::postList();
				
	}

}
