<fieldset>
<legend>Region</legend>
|-include file="RegionsMapHelpInclude.tpl"-|
<div id="point_dummy_container">
	<div id="point_dummy">
		<input type="hidden" id="point_dummy_latitude" name="regionPoints[point_dummy][params][latitude]" value="" />
		<input type="hidden" id="point_dummy_longitude" name="regionPoints[point_dummy][params][longitude]" value="" />
		<input type="hidden" id="point_dummy_regionId" name="regionPoints[point_dummy][params][regionId]" value="|-$region->getId()-|" />
	</div>
</div>

<div id="map_canvas"></div>

<script type="text/javascript" src="https://maps.google.com/maps/api/js?sensor=true"></script>
<script type="text/javascript" src="scripts/keydragzoom_packed.js"></script>
<script type="text/javascript" src="scripts/regions-map-base.js"></script>
<script type="text/javascript" src="scripts/regions-map-region.js"></script>

<script type="text/javascript" language="javascript">
	var regionMap = new RegionMap();
	
	regionMap.initializeMap("map_canvas");
	regionMap.markersDraggables = true;
	regionMap.mapClickable = true;
	
	|-foreach from=$regionPoints key=key item=point-|
		var loc = new google.maps.LatLng('|-$point->getLatitude()-|', '|-$point->getLongitude()-|');
		var marker = regionMap.displayMarker('point_|-$key-|', loc, 'pinBlue');
		marker.setIcon('images/pin_blue.png');
		regionMap.polyLine.getPath().push(loc);
	|-/foreach-|
	
	|-if method_exists($region, 'getColor') && $region->getColor() ne ''-|
		regionMap.polygon.setOptions({fillColor:'|-$region->getColor()-|',strokeColor: '|-$region->getColor()-|'});
	|-else-||-$randColor = strtoupper(dechex(rand(0,10000000)))-|
		regionMap.polygon.setOptions({fillColor:'#|-$randColor-|',strokeColor: '#|-$randColor-|'});
	|-/if-|
	|-if $regionPoints|@count > 2-|
		regionMap.closePolygon();
	|-/if-|
	|-$regions = RegionQuery::create()->find()-|
	|-include file="RegionsDrawInclude.tpl" mapJsVarName="regionMap"-|
</script>
</fieldset>