<?php


/**
 * Base class that represents a query for the 'regions_region' table.
 *
 * Regiones
 *
 * @method RegionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method RegionQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method RegionQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method RegionQuery orderByPostalcode($order = Criteria::ASC) Order by the postalCode column
 * @method RegionQuery orderByLatitude($order = Criteria::ASC) Order by the latitude column
 * @method RegionQuery orderByLongitude($order = Criteria::ASC) Order by the longitude column
 * @method RegionQuery orderByPopulation($order = Criteria::ASC) Order by the population column
 * @method RegionQuery orderByPopulationyear($order = Criteria::ASC) Order by the populationYear column
 * @method RegionQuery orderByArea($order = Criteria::ASC) Order by the area column
 * @method RegionQuery orderByCapital($order = Criteria::ASC) Order by the capital column
 * @method RegionQuery orderByTreeLeft($order = Criteria::ASC) Order by the tree_left column
 * @method RegionQuery orderByTreeRight($order = Criteria::ASC) Order by the tree_right column
 * @method RegionQuery orderByTreeLevel($order = Criteria::ASC) Order by the tree_level column
 * @method RegionQuery orderByScope($order = Criteria::ASC) Order by the scope column
 *
 * @method RegionQuery groupById() Group by the id column
 * @method RegionQuery groupByName() Group by the name column
 * @method RegionQuery groupByType() Group by the type column
 * @method RegionQuery groupByPostalcode() Group by the postalCode column
 * @method RegionQuery groupByLatitude() Group by the latitude column
 * @method RegionQuery groupByLongitude() Group by the longitude column
 * @method RegionQuery groupByPopulation() Group by the population column
 * @method RegionQuery groupByPopulationyear() Group by the populationYear column
 * @method RegionQuery groupByArea() Group by the area column
 * @method RegionQuery groupByCapital() Group by the capital column
 * @method RegionQuery groupByTreeLeft() Group by the tree_left column
 * @method RegionQuery groupByTreeRight() Group by the tree_right column
 * @method RegionQuery groupByTreeLevel() Group by the tree_level column
 * @method RegionQuery groupByScope() Group by the scope column
 *
 * @method RegionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method RegionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method RegionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method RegionQuery leftJoinConstruction($relationAlias = null) Adds a LEFT JOIN clause to the query using the Construction relation
 * @method RegionQuery rightJoinConstruction($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Construction relation
 * @method RegionQuery innerJoinConstruction($relationAlias = null) Adds a INNER JOIN clause to the query using the Construction relation
 *
 * @method RegionQuery leftJoinObjectiveRegion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ObjectiveRegion relation
 * @method RegionQuery rightJoinObjectiveRegion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ObjectiveRegion relation
 * @method RegionQuery innerJoinObjectiveRegion($relationAlias = null) Adds a INNER JOIN clause to the query using the ObjectiveRegion relation
 *
 * @method RegionQuery leftJoinProjectRegion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectRegion relation
 * @method RegionQuery rightJoinProjectRegion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectRegion relation
 * @method RegionQuery innerJoinProjectRegion($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectRegion relation
 *
 * @method RegionQuery leftJoinProjectIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectIndicator relation
 * @method RegionQuery rightJoinProjectIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectIndicator relation
 * @method RegionQuery innerJoinProjectIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectIndicator relation
 *
 * @method RegionQuery leftJoinRegionPoint($relationAlias = null) Adds a LEFT JOIN clause to the query using the RegionPoint relation
 * @method RegionQuery rightJoinRegionPoint($relationAlias = null) Adds a RIGHT JOIN clause to the query using the RegionPoint relation
 * @method RegionQuery innerJoinRegionPoint($relationAlias = null) Adds a INNER JOIN clause to the query using the RegionPoint relation
 *
 * @method Region findOne(PropelPDO $con = null) Return the first Region matching the query
 * @method Region findOneOrCreate(PropelPDO $con = null) Return the first Region matching the query, or a new Region object populated from the query conditions when no match is found
 *
 * @method Region findOneById(int $id) Return the first Region filtered by the id column
 * @method Region findOneByName(string $name) Return the first Region filtered by the name column
 * @method Region findOneByType(int $type) Return the first Region filtered by the type column
 * @method Region findOneByPostalcode(int $postalCode) Return the first Region filtered by the postalCode column
 * @method Region findOneByLatitude(string $latitude) Return the first Region filtered by the latitude column
 * @method Region findOneByLongitude(string $longitude) Return the first Region filtered by the longitude column
 * @method Region findOneByPopulation(double $population) Return the first Region filtered by the population column
 * @method Region findOneByPopulationyear(int $populationYear) Return the first Region filtered by the populationYear column
 * @method Region findOneByArea(double $area) Return the first Region filtered by the area column
 * @method Region findOneByCapital(string $capital) Return the first Region filtered by the capital column
 * @method Region findOneByTreeLeft(int $tree_left) Return the first Region filtered by the tree_left column
 * @method Region findOneByTreeRight(int $tree_right) Return the first Region filtered by the tree_right column
 * @method Region findOneByTreeLevel(int $tree_level) Return the first Region filtered by the tree_level column
 * @method Region findOneByScope(int $scope) Return the first Region filtered by the scope column
 *
 * @method array findById(int $id) Return Region objects filtered by the id column
 * @method array findByName(string $name) Return Region objects filtered by the name column
 * @method array findByType(int $type) Return Region objects filtered by the type column
 * @method array findByPostalcode(int $postalCode) Return Region objects filtered by the postalCode column
 * @method array findByLatitude(string $latitude) Return Region objects filtered by the latitude column
 * @method array findByLongitude(string $longitude) Return Region objects filtered by the longitude column
 * @method array findByPopulation(double $population) Return Region objects filtered by the population column
 * @method array findByPopulationyear(int $populationYear) Return Region objects filtered by the populationYear column
 * @method array findByArea(double $area) Return Region objects filtered by the area column
 * @method array findByCapital(string $capital) Return Region objects filtered by the capital column
 * @method array findByTreeLeft(int $tree_left) Return Region objects filtered by the tree_left column
 * @method array findByTreeRight(int $tree_right) Return Region objects filtered by the tree_right column
 * @method array findByTreeLevel(int $tree_level) Return Region objects filtered by the tree_level column
 * @method array findByScope(int $scope) Return Region objects filtered by the scope column
 *
 * @package    propel.generator.regions.classes.om
 */
abstract class BaseRegionQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseRegionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Region', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new RegionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     RegionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return RegionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof RegionQuery) {
            return $criteria;
        }
        $query = new RegionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Region|Region[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = RegionPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(RegionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Region A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `TYPE`, `POSTALCODE`, `LATITUDE`, `LONGITUDE`, `POPULATION`, `POPULATIONYEAR`, `AREA`, `CAPITAL`, `TREE_LEFT`, `TREE_RIGHT`, `TREE_LEVEL`, `SCOPE` FROM `regions_region` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Region();
            $obj->hydrate($row);
            RegionPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Region|Region[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Region[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(RegionPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(RegionPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(RegionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(RegionPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(RegionPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(RegionPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the postalCode column
     *
     * Example usage:
     * <code>
     * $query->filterByPostalcode(1234); // WHERE postalCode = 1234
     * $query->filterByPostalcode(array(12, 34)); // WHERE postalCode IN (12, 34)
     * $query->filterByPostalcode(array('min' => 12)); // WHERE postalCode > 12
     * </code>
     *
     * @param     mixed $postalcode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByPostalcode($postalcode = null, $comparison = null)
    {
        if (is_array($postalcode)) {
            $useMinMax = false;
            if (isset($postalcode['min'])) {
                $this->addUsingAlias(RegionPeer::POSTALCODE, $postalcode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($postalcode['max'])) {
                $this->addUsingAlias(RegionPeer::POSTALCODE, $postalcode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::POSTALCODE, $postalcode, $comparison);
    }

    /**
     * Filter the query on the latitude column
     *
     * Example usage:
     * <code>
     * $query->filterByLatitude(1234); // WHERE latitude = 1234
     * $query->filterByLatitude(array(12, 34)); // WHERE latitude IN (12, 34)
     * $query->filterByLatitude(array('min' => 12)); // WHERE latitude > 12
     * </code>
     *
     * @param     mixed $latitude The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByLatitude($latitude = null, $comparison = null)
    {
        if (is_array($latitude)) {
            $useMinMax = false;
            if (isset($latitude['min'])) {
                $this->addUsingAlias(RegionPeer::LATITUDE, $latitude['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($latitude['max'])) {
                $this->addUsingAlias(RegionPeer::LATITUDE, $latitude['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::LATITUDE, $latitude, $comparison);
    }

    /**
     * Filter the query on the longitude column
     *
     * Example usage:
     * <code>
     * $query->filterByLongitude(1234); // WHERE longitude = 1234
     * $query->filterByLongitude(array(12, 34)); // WHERE longitude IN (12, 34)
     * $query->filterByLongitude(array('min' => 12)); // WHERE longitude > 12
     * </code>
     *
     * @param     mixed $longitude The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByLongitude($longitude = null, $comparison = null)
    {
        if (is_array($longitude)) {
            $useMinMax = false;
            if (isset($longitude['min'])) {
                $this->addUsingAlias(RegionPeer::LONGITUDE, $longitude['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($longitude['max'])) {
                $this->addUsingAlias(RegionPeer::LONGITUDE, $longitude['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::LONGITUDE, $longitude, $comparison);
    }

    /**
     * Filter the query on the population column
     *
     * Example usage:
     * <code>
     * $query->filterByPopulation(1234); // WHERE population = 1234
     * $query->filterByPopulation(array(12, 34)); // WHERE population IN (12, 34)
     * $query->filterByPopulation(array('min' => 12)); // WHERE population > 12
     * </code>
     *
     * @param     mixed $population The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByPopulation($population = null, $comparison = null)
    {
        if (is_array($population)) {
            $useMinMax = false;
            if (isset($population['min'])) {
                $this->addUsingAlias(RegionPeer::POPULATION, $population['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($population['max'])) {
                $this->addUsingAlias(RegionPeer::POPULATION, $population['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::POPULATION, $population, $comparison);
    }

    /**
     * Filter the query on the populationYear column
     *
     * Example usage:
     * <code>
     * $query->filterByPopulationyear(1234); // WHERE populationYear = 1234
     * $query->filterByPopulationyear(array(12, 34)); // WHERE populationYear IN (12, 34)
     * $query->filterByPopulationyear(array('min' => 12)); // WHERE populationYear > 12
     * </code>
     *
     * @param     mixed $populationyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByPopulationyear($populationyear = null, $comparison = null)
    {
        if (is_array($populationyear)) {
            $useMinMax = false;
            if (isset($populationyear['min'])) {
                $this->addUsingAlias(RegionPeer::POPULATIONYEAR, $populationyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($populationyear['max'])) {
                $this->addUsingAlias(RegionPeer::POPULATIONYEAR, $populationyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::POPULATIONYEAR, $populationyear, $comparison);
    }

    /**
     * Filter the query on the area column
     *
     * Example usage:
     * <code>
     * $query->filterByArea(1234); // WHERE area = 1234
     * $query->filterByArea(array(12, 34)); // WHERE area IN (12, 34)
     * $query->filterByArea(array('min' => 12)); // WHERE area > 12
     * </code>
     *
     * @param     mixed $area The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByArea($area = null, $comparison = null)
    {
        if (is_array($area)) {
            $useMinMax = false;
            if (isset($area['min'])) {
                $this->addUsingAlias(RegionPeer::AREA, $area['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($area['max'])) {
                $this->addUsingAlias(RegionPeer::AREA, $area['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::AREA, $area, $comparison);
    }

    /**
     * Filter the query on the capital column
     *
     * Example usage:
     * <code>
     * $query->filterByCapital('fooValue');   // WHERE capital = 'fooValue'
     * $query->filterByCapital('%fooValue%'); // WHERE capital LIKE '%fooValue%'
     * </code>
     *
     * @param     string $capital The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByCapital($capital = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($capital)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $capital)) {
                $capital = str_replace('*', '%', $capital);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(RegionPeer::CAPITAL, $capital, $comparison);
    }

    /**
     * Filter the query on the tree_left column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLeft(1234); // WHERE tree_left = 1234
     * $query->filterByTreeLeft(array(12, 34)); // WHERE tree_left IN (12, 34)
     * $query->filterByTreeLeft(array('min' => 12)); // WHERE tree_left > 12
     * </code>
     *
     * @param     mixed $treeLeft The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByTreeLeft($treeLeft = null, $comparison = null)
    {
        if (is_array($treeLeft)) {
            $useMinMax = false;
            if (isset($treeLeft['min'])) {
                $this->addUsingAlias(RegionPeer::TREE_LEFT, $treeLeft['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLeft['max'])) {
                $this->addUsingAlias(RegionPeer::TREE_LEFT, $treeLeft['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::TREE_LEFT, $treeLeft, $comparison);
    }

    /**
     * Filter the query on the tree_right column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeRight(1234); // WHERE tree_right = 1234
     * $query->filterByTreeRight(array(12, 34)); // WHERE tree_right IN (12, 34)
     * $query->filterByTreeRight(array('min' => 12)); // WHERE tree_right > 12
     * </code>
     *
     * @param     mixed $treeRight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByTreeRight($treeRight = null, $comparison = null)
    {
        if (is_array($treeRight)) {
            $useMinMax = false;
            if (isset($treeRight['min'])) {
                $this->addUsingAlias(RegionPeer::TREE_RIGHT, $treeRight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeRight['max'])) {
                $this->addUsingAlias(RegionPeer::TREE_RIGHT, $treeRight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::TREE_RIGHT, $treeRight, $comparison);
    }

    /**
     * Filter the query on the tree_level column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLevel(1234); // WHERE tree_level = 1234
     * $query->filterByTreeLevel(array(12, 34)); // WHERE tree_level IN (12, 34)
     * $query->filterByTreeLevel(array('min' => 12)); // WHERE tree_level > 12
     * </code>
     *
     * @param     mixed $treeLevel The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByTreeLevel($treeLevel = null, $comparison = null)
    {
        if (is_array($treeLevel)) {
            $useMinMax = false;
            if (isset($treeLevel['min'])) {
                $this->addUsingAlias(RegionPeer::TREE_LEVEL, $treeLevel['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLevel['max'])) {
                $this->addUsingAlias(RegionPeer::TREE_LEVEL, $treeLevel['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::TREE_LEVEL, $treeLevel, $comparison);
    }

    /**
     * Filter the query on the scope column
     *
     * Example usage:
     * <code>
     * $query->filterByScope(1234); // WHERE scope = 1234
     * $query->filterByScope(array(12, 34)); // WHERE scope IN (12, 34)
     * $query->filterByScope(array('min' => 12)); // WHERE scope > 12
     * </code>
     *
     * @param     mixed $scope The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function filterByScope($scope = null, $comparison = null)
    {
        if (is_array($scope)) {
            $useMinMax = false;
            if (isset($scope['min'])) {
                $this->addUsingAlias(RegionPeer::SCOPE, $scope['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($scope['max'])) {
                $this->addUsingAlias(RegionPeer::SCOPE, $scope['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(RegionPeer::SCOPE, $scope, $comparison);
    }

    /**
     * Filter the query by a related Construction object
     *
     * @param   Construction|PropelObjectCollection $construction  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   RegionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByConstruction($construction, $comparison = null)
    {
        if ($construction instanceof Construction) {
            return $this
                ->addUsingAlias(RegionPeer::ID, $construction->getRegionid(), $comparison);
        } elseif ($construction instanceof PropelObjectCollection) {
            return $this
                ->useConstructionQuery()
                ->filterByPrimaryKeys($construction->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByConstruction() only accepts arguments of type Construction or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Construction relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function joinConstruction($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Construction');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Construction');
        }

        return $this;
    }

    /**
     * Use the Construction relation Construction object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ConstructionQuery A secondary query class using the current class as primary query
     */
    public function useConstructionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinConstruction($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Construction', 'ConstructionQuery');
    }

    /**
     * Filter the query by a related ObjectiveRegion object
     *
     * @param   ObjectiveRegion|PropelObjectCollection $objectiveRegion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   RegionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjectiveRegion($objectiveRegion, $comparison = null)
    {
        if ($objectiveRegion instanceof ObjectiveRegion) {
            return $this
                ->addUsingAlias(RegionPeer::ID, $objectiveRegion->getRegionid(), $comparison);
        } elseif ($objectiveRegion instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveRegionQuery()
                ->filterByPrimaryKeys($objectiveRegion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjectiveRegion() only accepts arguments of type ObjectiveRegion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ObjectiveRegion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function joinObjectiveRegion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ObjectiveRegion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ObjectiveRegion');
        }

        return $this;
    }

    /**
     * Use the ObjectiveRegion relation ObjectiveRegion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveRegionQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveRegionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjectiveRegion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ObjectiveRegion', 'ObjectiveRegionQuery');
    }

    /**
     * Filter the query by a related ProjectRegion object
     *
     * @param   ProjectRegion|PropelObjectCollection $projectRegion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   RegionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectRegion($projectRegion, $comparison = null)
    {
        if ($projectRegion instanceof ProjectRegion) {
            return $this
                ->addUsingAlias(RegionPeer::ID, $projectRegion->getRegionid(), $comparison);
        } elseif ($projectRegion instanceof PropelObjectCollection) {
            return $this
                ->useProjectRegionQuery()
                ->filterByPrimaryKeys($projectRegion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectRegion() only accepts arguments of type ProjectRegion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectRegion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function joinProjectRegion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectRegion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectRegion');
        }

        return $this;
    }

    /**
     * Use the ProjectRegion relation ProjectRegion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectRegionQuery A secondary query class using the current class as primary query
     */
    public function useProjectRegionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectRegion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectRegion', 'ProjectRegionQuery');
    }

    /**
     * Filter the query by a related ProjectIndicator object
     *
     * @param   ProjectIndicator|PropelObjectCollection $projectIndicator  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   RegionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectIndicator($projectIndicator, $comparison = null)
    {
        if ($projectIndicator instanceof ProjectIndicator) {
            return $this
                ->addUsingAlias(RegionPeer::ID, $projectIndicator->getRegionid(), $comparison);
        } elseif ($projectIndicator instanceof PropelObjectCollection) {
            return $this
                ->useProjectIndicatorQuery()
                ->filterByPrimaryKeys($projectIndicator->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectIndicator() only accepts arguments of type ProjectIndicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectIndicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function joinProjectIndicator($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectIndicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectIndicator');
        }

        return $this;
    }

    /**
     * Use the ProjectIndicator relation ProjectIndicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectIndicatorQuery A secondary query class using the current class as primary query
     */
    public function useProjectIndicatorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProjectIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectIndicator', 'ProjectIndicatorQuery');
    }

    /**
     * Filter the query by a related RegionPoint object
     *
     * @param   RegionPoint|PropelObjectCollection $regionPoint  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   RegionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByRegionPoint($regionPoint, $comparison = null)
    {
        if ($regionPoint instanceof RegionPoint) {
            return $this
                ->addUsingAlias(RegionPeer::ID, $regionPoint->getRegionid(), $comparison);
        } elseif ($regionPoint instanceof PropelObjectCollection) {
            return $this
                ->useRegionPointQuery()
                ->filterByPrimaryKeys($regionPoint->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByRegionPoint() only accepts arguments of type RegionPoint or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the RegionPoint relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function joinRegionPoint($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('RegionPoint');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'RegionPoint');
        }

        return $this;
    }

    /**
     * Use the RegionPoint relation RegionPoint object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   RegionPointQuery A secondary query class using the current class as primary query
     */
    public function useRegionPointQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinRegionPoint($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'RegionPoint', 'RegionPointQuery');
    }

    /**
     * Filter the query by a related Objective object
     * using the objectives_region table as cross reference
     *
     * @param   Objective $objective the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   RegionQuery The current query, for fluid interface
     */
    public function filterByObjective($objective, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useObjectiveRegionQuery()
            ->filterByObjective($objective, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Project object
     * using the projects_region table as cross reference
     *
     * @param   Project $project the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   RegionQuery The current query, for fluid interface
     */
    public function filterByProject($project, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useProjectRegionQuery()
            ->filterByProject($project, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Region $region Object to remove from the list of results
     *
     * @return RegionQuery The current query, for fluid interface
     */
    public function prune($region = null)
    {
        if ($region) {
            $this->addUsingAlias(RegionPeer::ID, $region->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    // nested_set behavior

    /**
     * Filter the query to restrict the result to root objects
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function treeRoots()
    {
        return $this->addUsingAlias(RegionPeer::LEFT_COL, 1, Criteria::EQUAL);
    }

    /**
     * Returns the objects in a certain tree, from the tree scope
     *
     * @param     int $scope		Scope to determine which objects node to return
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function inTree($scope = null)
    {
        return $this->addUsingAlias(RegionPeer::SCOPE_COL, $scope, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to descendants of an object
     *
     * @param     Region $region The object to use for descendant search
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function descendantsOf($region)
    {
        return $this
            ->inTree($region->getScopeValue())
            ->addUsingAlias(RegionPeer::LEFT_COL, $region->getLeftValue(), Criteria::GREATER_THAN)
            ->addUsingAlias(RegionPeer::LEFT_COL, $region->getRightValue(), Criteria::LESS_THAN);
    }

    /**
     * Filter the query to restrict the result to the branch of an object.
     * Same as descendantsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     Region $region The object to use for branch search
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function branchOf($region)
    {
        return $this
            ->inTree($region->getScopeValue())
            ->addUsingAlias(RegionPeer::LEFT_COL, $region->getLeftValue(), Criteria::GREATER_EQUAL)
            ->addUsingAlias(RegionPeer::LEFT_COL, $region->getRightValue(), Criteria::LESS_EQUAL);
    }

    /**
     * Filter the query to restrict the result to children of an object
     *
     * @param     Region $region The object to use for child search
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function childrenOf($region)
    {
        return $this
            ->descendantsOf($region)
            ->addUsingAlias(RegionPeer::LEVEL_COL, $region->getLevel() + 1, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to siblings of an object.
     * The result does not include the object passed as parameter.
     *
     * @param     Region $region The object to use for sibling search
     * @param      PropelPDO $con Connection to use.
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function siblingsOf($region, PropelPDO $con = null)
    {
        if ($region->isRoot()) {
            return $this->
                add(RegionPeer::LEVEL_COL, '1<>1', Criteria::CUSTOM);
        } else {
            return $this
                ->childrenOf($region->getParent($con))
                ->prune($region);
        }
    }

    /**
     * Filter the query to restrict the result to ancestors of an object
     *
     * @param     Region $region The object to use for ancestors search
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function ancestorsOf($region)
    {
        return $this
            ->inTree($region->getScopeValue())
            ->addUsingAlias(RegionPeer::LEFT_COL, $region->getLeftValue(), Criteria::LESS_THAN)
            ->addUsingAlias(RegionPeer::RIGHT_COL, $region->getRightValue(), Criteria::GREATER_THAN);
    }

    /**
     * Filter the query to restrict the result to roots of an object.
     * Same as ancestorsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     Region $region The object to use for roots search
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function rootsOf($region)
    {
        return $this
            ->inTree($region->getScopeValue())
            ->addUsingAlias(RegionPeer::LEFT_COL, $region->getLeftValue(), Criteria::LESS_EQUAL)
            ->addUsingAlias(RegionPeer::RIGHT_COL, $region->getRightValue(), Criteria::GREATER_EQUAL);
    }

    /**
     * Order the result by branch, i.e. natural tree order
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function orderByBranch($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addDescendingOrderByColumn(RegionPeer::LEFT_COL);
        } else {
            return $this
                ->addAscendingOrderByColumn(RegionPeer::LEFT_COL);
        }
    }

    /**
     * Order the result by level, the closer to the root first
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    RegionQuery The current query, for fluid interface
     */
    public function orderByLevel($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addAscendingOrderByColumn(RegionPeer::RIGHT_COL);
        } else {
            return $this
                ->addDescendingOrderByColumn(RegionPeer::RIGHT_COL);
        }
    }

    /**
     * Returns a root node for the tree
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Region The tree root object
     */
    public function findRoot($scope = null, $con = null)
    {
        return $this
            ->addUsingAlias(RegionPeer::LEFT_COL, 1, Criteria::EQUAL)
            ->inTree($scope)
            ->findOne($con);
    }

    /**
     * Returns the root objects for all trees.
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return    mixed the list of results, formatted by the current formatter
     */
    public function findRoots($con = null)
    {
        return $this
            ->treeRoots()
            ->find($con);
    }

    /**
     * Returns a tree of objects
     *
     * @param      int $scope		Scope to determine which tree node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     mixed the list of results, formatted by the current formatter
     */
    public function findTree($scope = null, $con = null)
    {
        return $this
            ->inTree($scope)
            ->orderByBranch()
            ->find($con);
    }

}
