<?php


/**
 * Base class that represents a row from the 'regions_region' table.
 *
 * Regiones
 *
 * @package    propel.generator.regions.classes.om
 */
abstract class BaseRegion extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'RegionPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        RegionPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the postalcode field.
     * @var        int
     */
    protected $postalcode;

    /**
     * The value for the latitude field.
     * @var        string
     */
    protected $latitude;

    /**
     * The value for the longitude field.
     * @var        string
     */
    protected $longitude;

    /**
     * The value for the population field.
     * @var        double
     */
    protected $population;

    /**
     * The value for the populationyear field.
     * @var        int
     */
    protected $populationyear;

    /**
     * The value for the area field.
     * @var        double
     */
    protected $area;

    /**
     * The value for the capital field.
     * @var        string
     */
    protected $capital;

    /**
     * The value for the tree_left field.
     * @var        int
     */
    protected $tree_left;

    /**
     * The value for the tree_right field.
     * @var        int
     */
    protected $tree_right;

    /**
     * The value for the tree_level field.
     * @var        int
     */
    protected $tree_level;

    /**
     * The value for the scope field.
     * @var        int
     */
    protected $scope;

    /**
     * @var        PropelObjectCollection|Construction[] Collection to store aggregation of Construction objects.
     */
    protected $collConstructions;
    protected $collConstructionsPartial;

    /**
     * @var        PropelObjectCollection|ObjectiveRegion[] Collection to store aggregation of ObjectiveRegion objects.
     */
    protected $collObjectiveRegions;
    protected $collObjectiveRegionsPartial;

    /**
     * @var        PropelObjectCollection|ProjectRegion[] Collection to store aggregation of ProjectRegion objects.
     */
    protected $collProjectRegions;
    protected $collProjectRegionsPartial;

    /**
     * @var        PropelObjectCollection|ProjectIndicator[] Collection to store aggregation of ProjectIndicator objects.
     */
    protected $collProjectIndicators;
    protected $collProjectIndicatorsPartial;

    /**
     * @var        PropelObjectCollection|RegionPoint[] Collection to store aggregation of RegionPoint objects.
     */
    protected $collRegionPoints;
    protected $collRegionPointsPartial;

    /**
     * @var        PropelObjectCollection|Objective[] Collection to store aggregation of Objective objects.
     */
    protected $collObjectives;

    /**
     * @var        PropelObjectCollection|Project[] Collection to store aggregation of Project objects.
     */
    protected $collProjects;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    // nested_set behavior

    /**
     * Queries to be executed in the save transaction
     * @var        array
     */
    protected $nestedSetQueries = array();

    /**
     * Internal cache for children nodes
     * @var        null|PropelObjectCollection
     */
    protected $collNestedSetChildren = null;

    /**
     * Internal cache for parent node
     * @var        null|Region
     */
    protected $aNestedSetParent = null;


    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectivesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $constructionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectiveRegionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectRegionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectIndicatorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $regionPointsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [type] column value.
     * Tipo de Region
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [postalcode] column value.
     * Postal Code
     * @return int
     */
    public function getPostalcode()
    {
        return $this->postalcode;
    }

    /**
     * Get the [latitude] column value.
     * latitud
     * @return string
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Get the [longitude] column value.
     * longitud
     * @return string
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Get the [population] column value.
     * Habitantes
     * @return double
     */
    public function getPopulation()
    {
        return $this->population;
    }

    /**
     * Get the [populationyear] column value.
     * Fecha censo
     * @return int
     */
    public function getPopulationyear()
    {
        return $this->populationyear;
    }

    /**
     * Get the [area] column value.
     * Superficie
     * @return double
     */
    public function getArea()
    {
        return $this->area;
    }

    /**
     * Get the [capital] column value.
     * Capital (si aplica)
     * @return string
     */
    public function getCapital()
    {
        return $this->capital;
    }

    /**
     * Get the [tree_left] column value.
     *
     * @return int
     */
    public function getTreeLeft()
    {
        return $this->tree_left;
    }

    /**
     * Get the [tree_right] column value.
     *
     * @return int
     */
    public function getTreeRight()
    {
        return $this->tree_right;
    }

    /**
     * Get the [tree_level] column value.
     *
     * @return int
     */
    public function getTreeLevel()
    {
        return $this->tree_level;
    }

    /**
     * Get the [scope] column value.
     *
     * @return int
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = RegionPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Name
     * @param string $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = RegionPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [type] column.
     * Tipo de Region
     * @param int $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = RegionPeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Set the value of [postalcode] column.
     * Postal Code
     * @param int $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setPostalcode($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->postalcode !== $v) {
            $this->postalcode = $v;
            $this->modifiedColumns[] = RegionPeer::POSTALCODE;
        }


        return $this;
    } // setPostalcode()

    /**
     * Set the value of [latitude] column.
     * latitud
     * @param string $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setLatitude($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->latitude !== $v) {
            $this->latitude = $v;
            $this->modifiedColumns[] = RegionPeer::LATITUDE;
        }


        return $this;
    } // setLatitude()

    /**
     * Set the value of [longitude] column.
     * longitud
     * @param string $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setLongitude($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->longitude !== $v) {
            $this->longitude = $v;
            $this->modifiedColumns[] = RegionPeer::LONGITUDE;
        }


        return $this;
    } // setLongitude()

    /**
     * Set the value of [population] column.
     * Habitantes
     * @param double $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setPopulation($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->population !== $v) {
            $this->population = $v;
            $this->modifiedColumns[] = RegionPeer::POPULATION;
        }


        return $this;
    } // setPopulation()

    /**
     * Set the value of [populationyear] column.
     * Fecha censo
     * @param int $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setPopulationyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->populationyear !== $v) {
            $this->populationyear = $v;
            $this->modifiedColumns[] = RegionPeer::POPULATIONYEAR;
        }


        return $this;
    } // setPopulationyear()

    /**
     * Set the value of [area] column.
     * Superficie
     * @param double $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setArea($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->area !== $v) {
            $this->area = $v;
            $this->modifiedColumns[] = RegionPeer::AREA;
        }


        return $this;
    } // setArea()

    /**
     * Set the value of [capital] column.
     * Capital (si aplica)
     * @param string $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setCapital($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->capital !== $v) {
            $this->capital = $v;
            $this->modifiedColumns[] = RegionPeer::CAPITAL;
        }


        return $this;
    } // setCapital()

    /**
     * Set the value of [tree_left] column.
     *
     * @param int $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setTreeLeft($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_left !== $v) {
            $this->tree_left = $v;
            $this->modifiedColumns[] = RegionPeer::TREE_LEFT;
        }


        return $this;
    } // setTreeLeft()

    /**
     * Set the value of [tree_right] column.
     *
     * @param int $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setTreeRight($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_right !== $v) {
            $this->tree_right = $v;
            $this->modifiedColumns[] = RegionPeer::TREE_RIGHT;
        }


        return $this;
    } // setTreeRight()

    /**
     * Set the value of [tree_level] column.
     *
     * @param int $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setTreeLevel($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_level !== $v) {
            $this->tree_level = $v;
            $this->modifiedColumns[] = RegionPeer::TREE_LEVEL;
        }


        return $this;
    } // setTreeLevel()

    /**
     * Set the value of [scope] column.
     *
     * @param int $v new value
     * @return Region The current object (for fluent API support)
     */
    public function setScope($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->scope !== $v) {
            $this->scope = $v;
            $this->modifiedColumns[] = RegionPeer::SCOPE;
        }


        return $this;
    } // setScope()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->type = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->postalcode = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->latitude = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->longitude = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->population = ($row[$startcol + 6] !== null) ? (double) $row[$startcol + 6] : null;
            $this->populationyear = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->area = ($row[$startcol + 8] !== null) ? (double) $row[$startcol + 8] : null;
            $this->capital = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->tree_left = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->tree_right = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->tree_level = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->scope = ($row[$startcol + 13] !== null) ? (int) $row[$startcol + 13] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 14; // 14 = RegionPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Region object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(RegionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = RegionPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collConstructions = null;

            $this->collObjectiveRegions = null;

            $this->collProjectRegions = null;

            $this->collProjectIndicators = null;

            $this->collRegionPoints = null;

            $this->collObjectives = null;
            $this->collProjects = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(RegionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = RegionQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // nested_set behavior
            if ($this->isRoot()) {
                throw new PropelException('Deletion of a root node is disabled for nested sets. Use RegionPeer::deleteTree($scope) instead to delete an entire tree');
            }

            if ($this->isInTree()) {
                $this->deleteDescendants($con);
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                // nested_set behavior
                if ($this->isInTree()) {
                    // fill up the room that was used by the node
                    RegionPeer::shiftRLValues(-2, $this->getRightValue() + 1, null, $this->getScopeValue(), $con);
                }

                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(RegionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            // nested_set behavior
            if ($this->isNew() && $this->isRoot()) {
                // check if no other root exist in, the tree
                $nbRoots = RegionQuery::create()
                    ->addUsingAlias(RegionPeer::LEFT_COL, 1, Criteria::EQUAL)
                    ->addUsingAlias(RegionPeer::SCOPE_COL, $this->getScopeValue(), Criteria::EQUAL)
                    ->count($con);
                if ($nbRoots > 0) {
                        throw new PropelException(sprintf('A root node already exists in this tree with scope "%s".', $this->getScopeValue()));
                }
            }
            $this->processNestedSetQueries($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                RegionPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->objectivesScheduledForDeletion !== null) {
                if (!$this->objectivesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->objectivesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    ObjectiveRegionQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->objectivesScheduledForDeletion = null;
                }

                foreach ($this->getObjectives() as $objective) {
                    if ($objective->isModified()) {
                        $objective->save($con);
                    }
                }
            }

            if ($this->projectsScheduledForDeletion !== null) {
                if (!$this->projectsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->projectsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    ProjectRegionQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->projectsScheduledForDeletion = null;
                }

                foreach ($this->getProjects() as $project) {
                    if ($project->isModified()) {
                        $project->save($con);
                    }
                }
            }

            if ($this->constructionsScheduledForDeletion !== null) {
                if (!$this->constructionsScheduledForDeletion->isEmpty()) {
                    foreach ($this->constructionsScheduledForDeletion as $construction) {
                        // need to save related object because we set the relation to null
                        $construction->save($con);
                    }
                    $this->constructionsScheduledForDeletion = null;
                }
            }

            if ($this->collConstructions !== null) {
                foreach ($this->collConstructions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectiveRegionsScheduledForDeletion !== null) {
                if (!$this->objectiveRegionsScheduledForDeletion->isEmpty()) {
                    ObjectiveRegionQuery::create()
                        ->filterByPrimaryKeys($this->objectiveRegionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->objectiveRegionsScheduledForDeletion = null;
                }
            }

            if ($this->collObjectiveRegions !== null) {
                foreach ($this->collObjectiveRegions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectRegionsScheduledForDeletion !== null) {
                if (!$this->projectRegionsScheduledForDeletion->isEmpty()) {
                    ProjectRegionQuery::create()
                        ->filterByPrimaryKeys($this->projectRegionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectRegionsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectRegions !== null) {
                foreach ($this->collProjectRegions as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectIndicatorsScheduledForDeletion !== null) {
                if (!$this->projectIndicatorsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectIndicatorsScheduledForDeletion as $projectIndicator) {
                        // need to save related object because we set the relation to null
                        $projectIndicator->save($con);
                    }
                    $this->projectIndicatorsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectIndicators !== null) {
                foreach ($this->collProjectIndicators as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->regionPointsScheduledForDeletion !== null) {
                if (!$this->regionPointsScheduledForDeletion->isEmpty()) {
                    RegionPointQuery::create()
                        ->filterByPrimaryKeys($this->regionPointsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->regionPointsScheduledForDeletion = null;
                }
            }

            if ($this->collRegionPoints !== null) {
                foreach ($this->collRegionPoints as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = RegionPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . RegionPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(RegionPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(RegionPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(RegionPeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(RegionPeer::POSTALCODE)) {
            $modifiedColumns[':p' . $index++]  = '`POSTALCODE`';
        }
        if ($this->isColumnModified(RegionPeer::LATITUDE)) {
            $modifiedColumns[':p' . $index++]  = '`LATITUDE`';
        }
        if ($this->isColumnModified(RegionPeer::LONGITUDE)) {
            $modifiedColumns[':p' . $index++]  = '`LONGITUDE`';
        }
        if ($this->isColumnModified(RegionPeer::POPULATION)) {
            $modifiedColumns[':p' . $index++]  = '`POPULATION`';
        }
        if ($this->isColumnModified(RegionPeer::POPULATIONYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`POPULATIONYEAR`';
        }
        if ($this->isColumnModified(RegionPeer::AREA)) {
            $modifiedColumns[':p' . $index++]  = '`AREA`';
        }
        if ($this->isColumnModified(RegionPeer::CAPITAL)) {
            $modifiedColumns[':p' . $index++]  = '`CAPITAL`';
        }
        if ($this->isColumnModified(RegionPeer::TREE_LEFT)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_LEFT`';
        }
        if ($this->isColumnModified(RegionPeer::TREE_RIGHT)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_RIGHT`';
        }
        if ($this->isColumnModified(RegionPeer::TREE_LEVEL)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_LEVEL`';
        }
        if ($this->isColumnModified(RegionPeer::SCOPE)) {
            $modifiedColumns[':p' . $index++]  = '`SCOPE`';
        }

        $sql = sprintf(
            'INSERT INTO `regions_region` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`POSTALCODE`':
                        $stmt->bindValue($identifier, $this->postalcode, PDO::PARAM_INT);
                        break;
                    case '`LATITUDE`':
                        $stmt->bindValue($identifier, $this->latitude, PDO::PARAM_INT);
                        break;
                    case '`LONGITUDE`':
                        $stmt->bindValue($identifier, $this->longitude, PDO::PARAM_INT);
                        break;
                    case '`POPULATION`':
                        $stmt->bindValue($identifier, $this->population, PDO::PARAM_STR);
                        break;
                    case '`POPULATIONYEAR`':
                        $stmt->bindValue($identifier, $this->populationyear, PDO::PARAM_INT);
                        break;
                    case '`AREA`':
                        $stmt->bindValue($identifier, $this->area, PDO::PARAM_STR);
                        break;
                    case '`CAPITAL`':
                        $stmt->bindValue($identifier, $this->capital, PDO::PARAM_STR);
                        break;
                    case '`TREE_LEFT`':
                        $stmt->bindValue($identifier, $this->tree_left, PDO::PARAM_INT);
                        break;
                    case '`TREE_RIGHT`':
                        $stmt->bindValue($identifier, $this->tree_right, PDO::PARAM_INT);
                        break;
                    case '`TREE_LEVEL`':
                        $stmt->bindValue($identifier, $this->tree_level, PDO::PARAM_INT);
                        break;
                    case '`SCOPE`':
                        $stmt->bindValue($identifier, $this->scope, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            if (($retval = RegionPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collConstructions !== null) {
                    foreach ($this->collConstructions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectiveRegions !== null) {
                    foreach ($this->collObjectiveRegions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectRegions !== null) {
                    foreach ($this->collProjectRegions as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectIndicators !== null) {
                    foreach ($this->collProjectIndicators as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collRegionPoints !== null) {
                    foreach ($this->collRegionPoints as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = RegionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getType();
                break;
            case 3:
                return $this->getPostalcode();
                break;
            case 4:
                return $this->getLatitude();
                break;
            case 5:
                return $this->getLongitude();
                break;
            case 6:
                return $this->getPopulation();
                break;
            case 7:
                return $this->getPopulationyear();
                break;
            case 8:
                return $this->getArea();
                break;
            case 9:
                return $this->getCapital();
                break;
            case 10:
                return $this->getTreeLeft();
                break;
            case 11:
                return $this->getTreeRight();
                break;
            case 12:
                return $this->getTreeLevel();
                break;
            case 13:
                return $this->getScope();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Region'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Region'][$this->getPrimaryKey()] = true;
        $keys = RegionPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getType(),
            $keys[3] => $this->getPostalcode(),
            $keys[4] => $this->getLatitude(),
            $keys[5] => $this->getLongitude(),
            $keys[6] => $this->getPopulation(),
            $keys[7] => $this->getPopulationyear(),
            $keys[8] => $this->getArea(),
            $keys[9] => $this->getCapital(),
            $keys[10] => $this->getTreeLeft(),
            $keys[11] => $this->getTreeRight(),
            $keys[12] => $this->getTreeLevel(),
            $keys[13] => $this->getScope(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->collConstructions) {
                $result['Constructions'] = $this->collConstructions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectiveRegions) {
                $result['ObjectiveRegions'] = $this->collObjectiveRegions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectRegions) {
                $result['ProjectRegions'] = $this->collProjectRegions->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectIndicators) {
                $result['ProjectIndicators'] = $this->collProjectIndicators->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collRegionPoints) {
                $result['RegionPoints'] = $this->collRegionPoints->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = RegionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setType($value);
                break;
            case 3:
                $this->setPostalcode($value);
                break;
            case 4:
                $this->setLatitude($value);
                break;
            case 5:
                $this->setLongitude($value);
                break;
            case 6:
                $this->setPopulation($value);
                break;
            case 7:
                $this->setPopulationyear($value);
                break;
            case 8:
                $this->setArea($value);
                break;
            case 9:
                $this->setCapital($value);
                break;
            case 10:
                $this->setTreeLeft($value);
                break;
            case 11:
                $this->setTreeRight($value);
                break;
            case 12:
                $this->setTreeLevel($value);
                break;
            case 13:
                $this->setScope($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = RegionPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setType($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setPostalcode($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setLatitude($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setLongitude($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setPopulation($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setPopulationyear($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setArea($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setCapital($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setTreeLeft($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setTreeRight($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setTreeLevel($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setScope($arr[$keys[13]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(RegionPeer::DATABASE_NAME);

        if ($this->isColumnModified(RegionPeer::ID)) $criteria->add(RegionPeer::ID, $this->id);
        if ($this->isColumnModified(RegionPeer::NAME)) $criteria->add(RegionPeer::NAME, $this->name);
        if ($this->isColumnModified(RegionPeer::TYPE)) $criteria->add(RegionPeer::TYPE, $this->type);
        if ($this->isColumnModified(RegionPeer::POSTALCODE)) $criteria->add(RegionPeer::POSTALCODE, $this->postalcode);
        if ($this->isColumnModified(RegionPeer::LATITUDE)) $criteria->add(RegionPeer::LATITUDE, $this->latitude);
        if ($this->isColumnModified(RegionPeer::LONGITUDE)) $criteria->add(RegionPeer::LONGITUDE, $this->longitude);
        if ($this->isColumnModified(RegionPeer::POPULATION)) $criteria->add(RegionPeer::POPULATION, $this->population);
        if ($this->isColumnModified(RegionPeer::POPULATIONYEAR)) $criteria->add(RegionPeer::POPULATIONYEAR, $this->populationyear);
        if ($this->isColumnModified(RegionPeer::AREA)) $criteria->add(RegionPeer::AREA, $this->area);
        if ($this->isColumnModified(RegionPeer::CAPITAL)) $criteria->add(RegionPeer::CAPITAL, $this->capital);
        if ($this->isColumnModified(RegionPeer::TREE_LEFT)) $criteria->add(RegionPeer::TREE_LEFT, $this->tree_left);
        if ($this->isColumnModified(RegionPeer::TREE_RIGHT)) $criteria->add(RegionPeer::TREE_RIGHT, $this->tree_right);
        if ($this->isColumnModified(RegionPeer::TREE_LEVEL)) $criteria->add(RegionPeer::TREE_LEVEL, $this->tree_level);
        if ($this->isColumnModified(RegionPeer::SCOPE)) $criteria->add(RegionPeer::SCOPE, $this->scope);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(RegionPeer::DATABASE_NAME);
        $criteria->add(RegionPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Region (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setType($this->getType());
        $copyObj->setPostalcode($this->getPostalcode());
        $copyObj->setLatitude($this->getLatitude());
        $copyObj->setLongitude($this->getLongitude());
        $copyObj->setPopulation($this->getPopulation());
        $copyObj->setPopulationyear($this->getPopulationyear());
        $copyObj->setArea($this->getArea());
        $copyObj->setCapital($this->getCapital());
        $copyObj->setTreeLeft($this->getTreeLeft());
        $copyObj->setTreeRight($this->getTreeRight());
        $copyObj->setTreeLevel($this->getTreeLevel());
        $copyObj->setScope($this->getScope());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getConstructions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addConstruction($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectiveRegions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjectiveRegion($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectRegions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectRegion($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectIndicators() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectIndicator($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getRegionPoints() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addRegionPoint($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Region Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return RegionPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new RegionPeer();
        }

        return self::$peer;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Construction' == $relationName) {
            $this->initConstructions();
        }
        if ('ObjectiveRegion' == $relationName) {
            $this->initObjectiveRegions();
        }
        if ('ProjectRegion' == $relationName) {
            $this->initProjectRegions();
        }
        if ('ProjectIndicator' == $relationName) {
            $this->initProjectIndicators();
        }
        if ('RegionPoint' == $relationName) {
            $this->initRegionPoints();
        }
    }

    /**
     * Clears out the collConstructions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addConstructions()
     */
    public function clearConstructions()
    {
        $this->collConstructions = null; // important to set this to null since that means it is uninitialized
        $this->collConstructionsPartial = null;
    }

    /**
     * reset is the collConstructions collection loaded partially
     *
     * @return void
     */
    public function resetPartialConstructions($v = true)
    {
        $this->collConstructionsPartial = $v;
    }

    /**
     * Initializes the collConstructions collection.
     *
     * By default this just sets the collConstructions collection to an empty array (like clearcollConstructions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initConstructions($overrideExisting = true)
    {
        if (null !== $this->collConstructions && !$overrideExisting) {
            return;
        }
        $this->collConstructions = new PropelObjectCollection();
        $this->collConstructions->setModel('Construction');
    }

    /**
     * Gets an array of Construction objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Region is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Construction[] List of Construction objects
     * @throws PropelException
     */
    public function getConstructions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collConstructionsPartial && !$this->isNew();
        if (null === $this->collConstructions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collConstructions) {
                // return empty collection
                $this->initConstructions();
            } else {
                $collConstructions = ConstructionQuery::create(null, $criteria)
                    ->filterByRegion($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collConstructionsPartial && count($collConstructions)) {
                      $this->initConstructions(false);

                      foreach($collConstructions as $obj) {
                        if (false == $this->collConstructions->contains($obj)) {
                          $this->collConstructions->append($obj);
                        }
                      }

                      $this->collConstructionsPartial = true;
                    }

                    return $collConstructions;
                }

                if($partial && $this->collConstructions) {
                    foreach($this->collConstructions as $obj) {
                        if($obj->isNew()) {
                            $collConstructions[] = $obj;
                        }
                    }
                }

                $this->collConstructions = $collConstructions;
                $this->collConstructionsPartial = false;
            }
        }

        return $this->collConstructions;
    }

    /**
     * Sets a collection of Construction objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $constructions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setConstructions(PropelCollection $constructions, PropelPDO $con = null)
    {
        $this->constructionsScheduledForDeletion = $this->getConstructions(new Criteria(), $con)->diff($constructions);

        foreach ($this->constructionsScheduledForDeletion as $constructionRemoved) {
            $constructionRemoved->setRegion(null);
        }

        $this->collConstructions = null;
        foreach ($constructions as $construction) {
            $this->addConstruction($construction);
        }

        $this->collConstructions = $constructions;
        $this->collConstructionsPartial = false;
    }

    /**
     * Returns the number of related Construction objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Construction objects.
     * @throws PropelException
     */
    public function countConstructions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collConstructionsPartial && !$this->isNew();
        if (null === $this->collConstructions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collConstructions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getConstructions());
                }
                $query = ConstructionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByRegion($this)
                    ->count($con);
            }
        } else {
            return count($this->collConstructions);
        }
    }

    /**
     * Method called to associate a Construction object to this object
     * through the Construction foreign key attribute.
     *
     * @param    Construction $l Construction
     * @return Region The current object (for fluent API support)
     */
    public function addConstruction(Construction $l)
    {
        if ($this->collConstructions === null) {
            $this->initConstructions();
            $this->collConstructionsPartial = true;
        }
        if (!$this->collConstructions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddConstruction($l);
        }

        return $this;
    }

    /**
     * @param	Construction $construction The construction object to add.
     */
    protected function doAddConstruction($construction)
    {
        $this->collConstructions[]= $construction;
        $construction->setRegion($this);
    }

    /**
     * @param	Construction $construction The construction object to remove.
     */
    public function removeConstruction($construction)
    {
        if ($this->getConstructions()->contains($construction)) {
            $this->collConstructions->remove($this->collConstructions->search($construction));
            if (null === $this->constructionsScheduledForDeletion) {
                $this->constructionsScheduledForDeletion = clone $this->collConstructions;
                $this->constructionsScheduledForDeletion->clear();
            }
            $this->constructionsScheduledForDeletion[]= $construction;
            $construction->setRegion(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Region is new, it will return
     * an empty collection; or if this Region has previously
     * been saved, it will retrieve related Constructions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Region.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Construction[] List of Construction objects
     */
    public function getConstructionsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ConstructionQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getConstructions($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Region is new, it will return
     * an empty collection; or if this Region has previously
     * been saved, it will retrieve related Constructions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Region.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Construction[] List of Construction objects
     */
    public function getConstructionsJoinCategory($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ConstructionQuery::create(null, $criteria);
        $query->joinWith('Category', $join_behavior);

        return $this->getConstructions($query, $con);
    }

    /**
     * Clears out the collObjectiveRegions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectiveRegions()
     */
    public function clearObjectiveRegions()
    {
        $this->collObjectiveRegions = null; // important to set this to null since that means it is uninitialized
        $this->collObjectiveRegionsPartial = null;
    }

    /**
     * reset is the collObjectiveRegions collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectiveRegions($v = true)
    {
        $this->collObjectiveRegionsPartial = $v;
    }

    /**
     * Initializes the collObjectiveRegions collection.
     *
     * By default this just sets the collObjectiveRegions collection to an empty array (like clearcollObjectiveRegions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectiveRegions($overrideExisting = true)
    {
        if (null !== $this->collObjectiveRegions && !$overrideExisting) {
            return;
        }
        $this->collObjectiveRegions = new PropelObjectCollection();
        $this->collObjectiveRegions->setModel('ObjectiveRegion');
    }

    /**
     * Gets an array of ObjectiveRegion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Region is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ObjectiveRegion[] List of ObjectiveRegion objects
     * @throws PropelException
     */
    public function getObjectiveRegions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveRegionsPartial && !$this->isNew();
        if (null === $this->collObjectiveRegions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectiveRegions) {
                // return empty collection
                $this->initObjectiveRegions();
            } else {
                $collObjectiveRegions = ObjectiveRegionQuery::create(null, $criteria)
                    ->filterByRegion($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectiveRegionsPartial && count($collObjectiveRegions)) {
                      $this->initObjectiveRegions(false);

                      foreach($collObjectiveRegions as $obj) {
                        if (false == $this->collObjectiveRegions->contains($obj)) {
                          $this->collObjectiveRegions->append($obj);
                        }
                      }

                      $this->collObjectiveRegionsPartial = true;
                    }

                    return $collObjectiveRegions;
                }

                if($partial && $this->collObjectiveRegions) {
                    foreach($this->collObjectiveRegions as $obj) {
                        if($obj->isNew()) {
                            $collObjectiveRegions[] = $obj;
                        }
                    }
                }

                $this->collObjectiveRegions = $collObjectiveRegions;
                $this->collObjectiveRegionsPartial = false;
            }
        }

        return $this->collObjectiveRegions;
    }

    /**
     * Sets a collection of ObjectiveRegion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectiveRegions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectiveRegions(PropelCollection $objectiveRegions, PropelPDO $con = null)
    {
        $this->objectiveRegionsScheduledForDeletion = $this->getObjectiveRegions(new Criteria(), $con)->diff($objectiveRegions);

        foreach ($this->objectiveRegionsScheduledForDeletion as $objectiveRegionRemoved) {
            $objectiveRegionRemoved->setRegion(null);
        }

        $this->collObjectiveRegions = null;
        foreach ($objectiveRegions as $objectiveRegion) {
            $this->addObjectiveRegion($objectiveRegion);
        }

        $this->collObjectiveRegions = $objectiveRegions;
        $this->collObjectiveRegionsPartial = false;
    }

    /**
     * Returns the number of related ObjectiveRegion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ObjectiveRegion objects.
     * @throws PropelException
     */
    public function countObjectiveRegions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveRegionsPartial && !$this->isNew();
        if (null === $this->collObjectiveRegions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectiveRegions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectiveRegions());
                }
                $query = ObjectiveRegionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByRegion($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectiveRegions);
        }
    }

    /**
     * Method called to associate a ObjectiveRegion object to this object
     * through the ObjectiveRegion foreign key attribute.
     *
     * @param    ObjectiveRegion $l ObjectiveRegion
     * @return Region The current object (for fluent API support)
     */
    public function addObjectiveRegion(ObjectiveRegion $l)
    {
        if ($this->collObjectiveRegions === null) {
            $this->initObjectiveRegions();
            $this->collObjectiveRegionsPartial = true;
        }
        if (!$this->collObjectiveRegions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjectiveRegion($l);
        }

        return $this;
    }

    /**
     * @param	ObjectiveRegion $objectiveRegion The objectiveRegion object to add.
     */
    protected function doAddObjectiveRegion($objectiveRegion)
    {
        $this->collObjectiveRegions[]= $objectiveRegion;
        $objectiveRegion->setRegion($this);
    }

    /**
     * @param	ObjectiveRegion $objectiveRegion The objectiveRegion object to remove.
     */
    public function removeObjectiveRegion($objectiveRegion)
    {
        if ($this->getObjectiveRegions()->contains($objectiveRegion)) {
            $this->collObjectiveRegions->remove($this->collObjectiveRegions->search($objectiveRegion));
            if (null === $this->objectiveRegionsScheduledForDeletion) {
                $this->objectiveRegionsScheduledForDeletion = clone $this->collObjectiveRegions;
                $this->objectiveRegionsScheduledForDeletion->clear();
            }
            $this->objectiveRegionsScheduledForDeletion[]= $objectiveRegion;
            $objectiveRegion->setRegion(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Region is new, it will return
     * an empty collection; or if this Region has previously
     * been saved, it will retrieve related ObjectiveRegions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Region.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveRegion[] List of ObjectiveRegion objects
     */
    public function getObjectiveRegionsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveRegionQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getObjectiveRegions($query, $con);
    }

    /**
     * Clears out the collProjectRegions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectRegions()
     */
    public function clearProjectRegions()
    {
        $this->collProjectRegions = null; // important to set this to null since that means it is uninitialized
        $this->collProjectRegionsPartial = null;
    }

    /**
     * reset is the collProjectRegions collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectRegions($v = true)
    {
        $this->collProjectRegionsPartial = $v;
    }

    /**
     * Initializes the collProjectRegions collection.
     *
     * By default this just sets the collProjectRegions collection to an empty array (like clearcollProjectRegions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectRegions($overrideExisting = true)
    {
        if (null !== $this->collProjectRegions && !$overrideExisting) {
            return;
        }
        $this->collProjectRegions = new PropelObjectCollection();
        $this->collProjectRegions->setModel('ProjectRegion');
    }

    /**
     * Gets an array of ProjectRegion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Region is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectRegion[] List of ProjectRegion objects
     * @throws PropelException
     */
    public function getProjectRegions($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectRegionsPartial && !$this->isNew();
        if (null === $this->collProjectRegions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectRegions) {
                // return empty collection
                $this->initProjectRegions();
            } else {
                $collProjectRegions = ProjectRegionQuery::create(null, $criteria)
                    ->filterByRegion($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectRegionsPartial && count($collProjectRegions)) {
                      $this->initProjectRegions(false);

                      foreach($collProjectRegions as $obj) {
                        if (false == $this->collProjectRegions->contains($obj)) {
                          $this->collProjectRegions->append($obj);
                        }
                      }

                      $this->collProjectRegionsPartial = true;
                    }

                    return $collProjectRegions;
                }

                if($partial && $this->collProjectRegions) {
                    foreach($this->collProjectRegions as $obj) {
                        if($obj->isNew()) {
                            $collProjectRegions[] = $obj;
                        }
                    }
                }

                $this->collProjectRegions = $collProjectRegions;
                $this->collProjectRegionsPartial = false;
            }
        }

        return $this->collProjectRegions;
    }

    /**
     * Sets a collection of ProjectRegion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectRegions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectRegions(PropelCollection $projectRegions, PropelPDO $con = null)
    {
        $this->projectRegionsScheduledForDeletion = $this->getProjectRegions(new Criteria(), $con)->diff($projectRegions);

        foreach ($this->projectRegionsScheduledForDeletion as $projectRegionRemoved) {
            $projectRegionRemoved->setRegion(null);
        }

        $this->collProjectRegions = null;
        foreach ($projectRegions as $projectRegion) {
            $this->addProjectRegion($projectRegion);
        }

        $this->collProjectRegions = $projectRegions;
        $this->collProjectRegionsPartial = false;
    }

    /**
     * Returns the number of related ProjectRegion objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectRegion objects.
     * @throws PropelException
     */
    public function countProjectRegions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectRegionsPartial && !$this->isNew();
        if (null === $this->collProjectRegions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectRegions) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectRegions());
                }
                $query = ProjectRegionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByRegion($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectRegions);
        }
    }

    /**
     * Method called to associate a ProjectRegion object to this object
     * through the ProjectRegion foreign key attribute.
     *
     * @param    ProjectRegion $l ProjectRegion
     * @return Region The current object (for fluent API support)
     */
    public function addProjectRegion(ProjectRegion $l)
    {
        if ($this->collProjectRegions === null) {
            $this->initProjectRegions();
            $this->collProjectRegionsPartial = true;
        }
        if (!$this->collProjectRegions->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectRegion($l);
        }

        return $this;
    }

    /**
     * @param	ProjectRegion $projectRegion The projectRegion object to add.
     */
    protected function doAddProjectRegion($projectRegion)
    {
        $this->collProjectRegions[]= $projectRegion;
        $projectRegion->setRegion($this);
    }

    /**
     * @param	ProjectRegion $projectRegion The projectRegion object to remove.
     */
    public function removeProjectRegion($projectRegion)
    {
        if ($this->getProjectRegions()->contains($projectRegion)) {
            $this->collProjectRegions->remove($this->collProjectRegions->search($projectRegion));
            if (null === $this->projectRegionsScheduledForDeletion) {
                $this->projectRegionsScheduledForDeletion = clone $this->collProjectRegions;
                $this->projectRegionsScheduledForDeletion->clear();
            }
            $this->projectRegionsScheduledForDeletion[]= $projectRegion;
            $projectRegion->setRegion(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Region is new, it will return
     * an empty collection; or if this Region has previously
     * been saved, it will retrieve related ProjectRegions from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Region.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectRegion[] List of ProjectRegion objects
     */
    public function getProjectRegionsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectRegionQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectRegions($query, $con);
    }

    /**
     * Clears out the collProjectIndicators collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectIndicators()
     */
    public function clearProjectIndicators()
    {
        $this->collProjectIndicators = null; // important to set this to null since that means it is uninitialized
        $this->collProjectIndicatorsPartial = null;
    }

    /**
     * reset is the collProjectIndicators collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectIndicators($v = true)
    {
        $this->collProjectIndicatorsPartial = $v;
    }

    /**
     * Initializes the collProjectIndicators collection.
     *
     * By default this just sets the collProjectIndicators collection to an empty array (like clearcollProjectIndicators());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectIndicators($overrideExisting = true)
    {
        if (null !== $this->collProjectIndicators && !$overrideExisting) {
            return;
        }
        $this->collProjectIndicators = new PropelObjectCollection();
        $this->collProjectIndicators->setModel('ProjectIndicator');
    }

    /**
     * Gets an array of ProjectIndicator objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Region is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectIndicator[] List of ProjectIndicator objects
     * @throws PropelException
     */
    public function getProjectIndicators($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectIndicatorsPartial && !$this->isNew();
        if (null === $this->collProjectIndicators || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectIndicators) {
                // return empty collection
                $this->initProjectIndicators();
            } else {
                $collProjectIndicators = ProjectIndicatorQuery::create(null, $criteria)
                    ->filterByRegion($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectIndicatorsPartial && count($collProjectIndicators)) {
                      $this->initProjectIndicators(false);

                      foreach($collProjectIndicators as $obj) {
                        if (false == $this->collProjectIndicators->contains($obj)) {
                          $this->collProjectIndicators->append($obj);
                        }
                      }

                      $this->collProjectIndicatorsPartial = true;
                    }

                    return $collProjectIndicators;
                }

                if($partial && $this->collProjectIndicators) {
                    foreach($this->collProjectIndicators as $obj) {
                        if($obj->isNew()) {
                            $collProjectIndicators[] = $obj;
                        }
                    }
                }

                $this->collProjectIndicators = $collProjectIndicators;
                $this->collProjectIndicatorsPartial = false;
            }
        }

        return $this->collProjectIndicators;
    }

    /**
     * Sets a collection of ProjectIndicator objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectIndicators A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectIndicators(PropelCollection $projectIndicators, PropelPDO $con = null)
    {
        $this->projectIndicatorsScheduledForDeletion = $this->getProjectIndicators(new Criteria(), $con)->diff($projectIndicators);

        foreach ($this->projectIndicatorsScheduledForDeletion as $projectIndicatorRemoved) {
            $projectIndicatorRemoved->setRegion(null);
        }

        $this->collProjectIndicators = null;
        foreach ($projectIndicators as $projectIndicator) {
            $this->addProjectIndicator($projectIndicator);
        }

        $this->collProjectIndicators = $projectIndicators;
        $this->collProjectIndicatorsPartial = false;
    }

    /**
     * Returns the number of related ProjectIndicator objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectIndicator objects.
     * @throws PropelException
     */
    public function countProjectIndicators(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectIndicatorsPartial && !$this->isNew();
        if (null === $this->collProjectIndicators || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectIndicators) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectIndicators());
                }
                $query = ProjectIndicatorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByRegion($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectIndicators);
        }
    }

    /**
     * Method called to associate a ProjectIndicator object to this object
     * through the ProjectIndicator foreign key attribute.
     *
     * @param    ProjectIndicator $l ProjectIndicator
     * @return Region The current object (for fluent API support)
     */
    public function addProjectIndicator(ProjectIndicator $l)
    {
        if ($this->collProjectIndicators === null) {
            $this->initProjectIndicators();
            $this->collProjectIndicatorsPartial = true;
        }
        if (!$this->collProjectIndicators->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectIndicator($l);
        }

        return $this;
    }

    /**
     * @param	ProjectIndicator $projectIndicator The projectIndicator object to add.
     */
    protected function doAddProjectIndicator($projectIndicator)
    {
        $this->collProjectIndicators[]= $projectIndicator;
        $projectIndicator->setRegion($this);
    }

    /**
     * @param	ProjectIndicator $projectIndicator The projectIndicator object to remove.
     */
    public function removeProjectIndicator($projectIndicator)
    {
        if ($this->getProjectIndicators()->contains($projectIndicator)) {
            $this->collProjectIndicators->remove($this->collProjectIndicators->search($projectIndicator));
            if (null === $this->projectIndicatorsScheduledForDeletion) {
                $this->projectIndicatorsScheduledForDeletion = clone $this->collProjectIndicators;
                $this->projectIndicatorsScheduledForDeletion->clear();
            }
            $this->projectIndicatorsScheduledForDeletion[]= $projectIndicator;
            $projectIndicator->setRegion(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Region is new, it will return
     * an empty collection; or if this Region has previously
     * been saved, it will retrieve related ProjectIndicators from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Region.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectIndicator[] List of ProjectIndicator objects
     */
    public function getProjectIndicatorsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectIndicatorQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectIndicators($query, $con);
    }

    /**
     * Clears out the collRegionPoints collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addRegionPoints()
     */
    public function clearRegionPoints()
    {
        $this->collRegionPoints = null; // important to set this to null since that means it is uninitialized
        $this->collRegionPointsPartial = null;
    }

    /**
     * reset is the collRegionPoints collection loaded partially
     *
     * @return void
     */
    public function resetPartialRegionPoints($v = true)
    {
        $this->collRegionPointsPartial = $v;
    }

    /**
     * Initializes the collRegionPoints collection.
     *
     * By default this just sets the collRegionPoints collection to an empty array (like clearcollRegionPoints());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initRegionPoints($overrideExisting = true)
    {
        if (null !== $this->collRegionPoints && !$overrideExisting) {
            return;
        }
        $this->collRegionPoints = new PropelObjectCollection();
        $this->collRegionPoints->setModel('RegionPoint');
    }

    /**
     * Gets an array of RegionPoint objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Region is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|RegionPoint[] List of RegionPoint objects
     * @throws PropelException
     */
    public function getRegionPoints($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collRegionPointsPartial && !$this->isNew();
        if (null === $this->collRegionPoints || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collRegionPoints) {
                // return empty collection
                $this->initRegionPoints();
            } else {
                $collRegionPoints = RegionPointQuery::create(null, $criteria)
                    ->filterByRegion($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collRegionPointsPartial && count($collRegionPoints)) {
                      $this->initRegionPoints(false);

                      foreach($collRegionPoints as $obj) {
                        if (false == $this->collRegionPoints->contains($obj)) {
                          $this->collRegionPoints->append($obj);
                        }
                      }

                      $this->collRegionPointsPartial = true;
                    }

                    return $collRegionPoints;
                }

                if($partial && $this->collRegionPoints) {
                    foreach($this->collRegionPoints as $obj) {
                        if($obj->isNew()) {
                            $collRegionPoints[] = $obj;
                        }
                    }
                }

                $this->collRegionPoints = $collRegionPoints;
                $this->collRegionPointsPartial = false;
            }
        }

        return $this->collRegionPoints;
    }

    /**
     * Sets a collection of RegionPoint objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $regionPoints A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setRegionPoints(PropelCollection $regionPoints, PropelPDO $con = null)
    {
        $this->regionPointsScheduledForDeletion = $this->getRegionPoints(new Criteria(), $con)->diff($regionPoints);

        foreach ($this->regionPointsScheduledForDeletion as $regionPointRemoved) {
            $regionPointRemoved->setRegion(null);
        }

        $this->collRegionPoints = null;
        foreach ($regionPoints as $regionPoint) {
            $this->addRegionPoint($regionPoint);
        }

        $this->collRegionPoints = $regionPoints;
        $this->collRegionPointsPartial = false;
    }

    /**
     * Returns the number of related RegionPoint objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related RegionPoint objects.
     * @throws PropelException
     */
    public function countRegionPoints(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collRegionPointsPartial && !$this->isNew();
        if (null === $this->collRegionPoints || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collRegionPoints) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getRegionPoints());
                }
                $query = RegionPointQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByRegion($this)
                    ->count($con);
            }
        } else {
            return count($this->collRegionPoints);
        }
    }

    /**
     * Method called to associate a RegionPoint object to this object
     * through the RegionPoint foreign key attribute.
     *
     * @param    RegionPoint $l RegionPoint
     * @return Region The current object (for fluent API support)
     */
    public function addRegionPoint(RegionPoint $l)
    {
        if ($this->collRegionPoints === null) {
            $this->initRegionPoints();
            $this->collRegionPointsPartial = true;
        }
        if (!$this->collRegionPoints->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddRegionPoint($l);
        }

        return $this;
    }

    /**
     * @param	RegionPoint $regionPoint The regionPoint object to add.
     */
    protected function doAddRegionPoint($regionPoint)
    {
        $this->collRegionPoints[]= $regionPoint;
        $regionPoint->setRegion($this);
    }

    /**
     * @param	RegionPoint $regionPoint The regionPoint object to remove.
     */
    public function removeRegionPoint($regionPoint)
    {
        if ($this->getRegionPoints()->contains($regionPoint)) {
            $this->collRegionPoints->remove($this->collRegionPoints->search($regionPoint));
            if (null === $this->regionPointsScheduledForDeletion) {
                $this->regionPointsScheduledForDeletion = clone $this->collRegionPoints;
                $this->regionPointsScheduledForDeletion->clear();
            }
            $this->regionPointsScheduledForDeletion[]= $regionPoint;
            $regionPoint->setRegion(null);
        }
    }

    /**
     * Clears out the collObjectives collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectives()
     */
    public function clearObjectives()
    {
        $this->collObjectives = null; // important to set this to null since that means it is uninitialized
        $this->collObjectivesPartial = null;
    }

    /**
     * Initializes the collObjectives collection.
     *
     * By default this just sets the collObjectives collection to an empty collection (like clearObjectives());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initObjectives()
    {
        $this->collObjectives = new PropelObjectCollection();
        $this->collObjectives->setModel('Objective');
    }

    /**
     * Gets a collection of Objective objects related by a many-to-many relationship
     * to the current object by way of the objectives_region cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Region is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectives($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collObjectives || null !== $criteria) {
            if ($this->isNew() && null === $this->collObjectives) {
                // return empty collection
                $this->initObjectives();
            } else {
                $collObjectives = ObjectiveQuery::create(null, $criteria)
                    ->filterByRegion($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collObjectives;
                }
                $this->collObjectives = $collObjectives;
            }
        }

        return $this->collObjectives;
    }

    /**
     * Sets a collection of Objective objects related by a many-to-many relationship
     * to the current object by way of the objectives_region cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectives A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectives(PropelCollection $objectives, PropelPDO $con = null)
    {
        $this->clearObjectives();
        $currentObjectives = $this->getObjectives();

        $this->objectivesScheduledForDeletion = $currentObjectives->diff($objectives);

        foreach ($objectives as $objective) {
            if (!$currentObjectives->contains($objective)) {
                $this->doAddObjective($objective);
            }
        }

        $this->collObjectives = $objectives;
    }

    /**
     * Gets the number of Objective objects related by a many-to-many relationship
     * to the current object by way of the objectives_region cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Objective objects
     */
    public function countObjectives($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collObjectives || null !== $criteria) {
            if ($this->isNew() && null === $this->collObjectives) {
                return 0;
            } else {
                $query = ObjectiveQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByRegion($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectives);
        }
    }

    /**
     * Associate a Objective object to this object
     * through the objectives_region cross reference table.
     *
     * @param  Objective $objective The ObjectiveRegion object to relate
     * @return void
     */
    public function addObjective(Objective $objective)
    {
        if ($this->collObjectives === null) {
            $this->initObjectives();
        }
        if (!$this->collObjectives->contains($objective)) { // only add it if the **same** object is not already associated
            $this->doAddObjective($objective);

            $this->collObjectives[]= $objective;
        }
    }

    /**
     * @param	Objective $objective The objective object to add.
     */
    protected function doAddObjective($objective)
    {
        $objectiveRegion = new ObjectiveRegion();
        $objectiveRegion->setObjective($objective);
        $this->addObjectiveRegion($objectiveRegion);
    }

    /**
     * Remove a Objective object to this object
     * through the objectives_region cross reference table.
     *
     * @param Objective $objective The ObjectiveRegion object to relate
     * @return void
     */
    public function removeObjective(Objective $objective)
    {
        if ($this->getObjectives()->contains($objective)) {
            $this->collObjectives->remove($this->collObjectives->search($objective));
            if (null === $this->objectivesScheduledForDeletion) {
                $this->objectivesScheduledForDeletion = clone $this->collObjectives;
                $this->objectivesScheduledForDeletion->clear();
            }
            $this->objectivesScheduledForDeletion[]= $objective;
        }
    }

    /**
     * Clears out the collProjects collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjects()
     */
    public function clearProjects()
    {
        $this->collProjects = null; // important to set this to null since that means it is uninitialized
        $this->collProjectsPartial = null;
    }

    /**
     * Initializes the collProjects collection.
     *
     * By default this just sets the collProjects collection to an empty collection (like clearProjects());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initProjects()
    {
        $this->collProjects = new PropelObjectCollection();
        $this->collProjects->setModel('Project');
    }

    /**
     * Gets a collection of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_region cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Region is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjects($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collProjects || null !== $criteria) {
            if ($this->isNew() && null === $this->collProjects) {
                // return empty collection
                $this->initProjects();
            } else {
                $collProjects = ProjectQuery::create(null, $criteria)
                    ->filterByRegion($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collProjects;
                }
                $this->collProjects = $collProjects;
            }
        }

        return $this->collProjects;
    }

    /**
     * Sets a collection of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_region cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projects A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjects(PropelCollection $projects, PropelPDO $con = null)
    {
        $this->clearProjects();
        $currentProjects = $this->getProjects();

        $this->projectsScheduledForDeletion = $currentProjects->diff($projects);

        foreach ($projects as $project) {
            if (!$currentProjects->contains($project)) {
                $this->doAddProject($project);
            }
        }

        $this->collProjects = $projects;
    }

    /**
     * Gets the number of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_region cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Project objects
     */
    public function countProjects($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collProjects || null !== $criteria) {
            if ($this->isNew() && null === $this->collProjects) {
                return 0;
            } else {
                $query = ProjectQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByRegion($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjects);
        }
    }

    /**
     * Associate a Project object to this object
     * through the projects_region cross reference table.
     *
     * @param  Project $project The ProjectRegion object to relate
     * @return void
     */
    public function addProject(Project $project)
    {
        if ($this->collProjects === null) {
            $this->initProjects();
        }
        if (!$this->collProjects->contains($project)) { // only add it if the **same** object is not already associated
            $this->doAddProject($project);

            $this->collProjects[]= $project;
        }
    }

    /**
     * @param	Project $project The project object to add.
     */
    protected function doAddProject($project)
    {
        $projectRegion = new ProjectRegion();
        $projectRegion->setProject($project);
        $this->addProjectRegion($projectRegion);
    }

    /**
     * Remove a Project object to this object
     * through the projects_region cross reference table.
     *
     * @param Project $project The ProjectRegion object to relate
     * @return void
     */
    public function removeProject(Project $project)
    {
        if ($this->getProjects()->contains($project)) {
            $this->collProjects->remove($this->collProjects->search($project));
            if (null === $this->projectsScheduledForDeletion) {
                $this->projectsScheduledForDeletion = clone $this->collProjects;
                $this->projectsScheduledForDeletion->clear();
            }
            $this->projectsScheduledForDeletion[]= $project;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->type = null;
        $this->postalcode = null;
        $this->latitude = null;
        $this->longitude = null;
        $this->population = null;
        $this->populationyear = null;
        $this->area = null;
        $this->capital = null;
        $this->tree_left = null;
        $this->tree_right = null;
        $this->tree_level = null;
        $this->scope = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collConstructions) {
                foreach ($this->collConstructions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectiveRegions) {
                foreach ($this->collObjectiveRegions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectRegions) {
                foreach ($this->collProjectRegions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectIndicators) {
                foreach ($this->collProjectIndicators as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collRegionPoints) {
                foreach ($this->collRegionPoints as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectives) {
                foreach ($this->collObjectives as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjects) {
                foreach ($this->collProjects as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        // nested_set behavior
        $this->collNestedSetChildren = null;
        $this->aNestedSetParent = null;
        if ($this->collConstructions instanceof PropelCollection) {
            $this->collConstructions->clearIterator();
        }
        $this->collConstructions = null;
        if ($this->collObjectiveRegions instanceof PropelCollection) {
            $this->collObjectiveRegions->clearIterator();
        }
        $this->collObjectiveRegions = null;
        if ($this->collProjectRegions instanceof PropelCollection) {
            $this->collProjectRegions->clearIterator();
        }
        $this->collProjectRegions = null;
        if ($this->collProjectIndicators instanceof PropelCollection) {
            $this->collProjectIndicators->clearIterator();
        }
        $this->collProjectIndicators = null;
        if ($this->collRegionPoints instanceof PropelCollection) {
            $this->collRegionPoints->clearIterator();
        }
        $this->collRegionPoints = null;
        if ($this->collObjectives instanceof PropelCollection) {
            $this->collObjectives->clearIterator();
        }
        $this->collObjectives = null;
        if ($this->collProjects instanceof PropelCollection) {
            $this->collProjects->clearIterator();
        }
        $this->collProjects = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // nested_set behavior

    /**
     * Execute queries that were saved to be run inside the save transaction
     */
    protected function processNestedSetQueries($con)
    {
        foreach ($this->nestedSetQueries as $query) {
            $query['arguments'][]= $con;
            call_user_func_array($query['callable'], $query['arguments']);
        }
        $this->nestedSetQueries = array();
    }

    /**
     * Proxy getter method for the left value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set left value
     */
    public function getLeftValue()
    {
        return $this->tree_left;
    }

    /**
     * Proxy getter method for the right value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set right value
     */
    public function getRightValue()
    {
        return $this->tree_right;
    }

    /**
     * Proxy getter method for the level value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set level value
     */
    public function getLevel()
    {
        return $this->tree_level;
    }

    /**
     * Proxy getter method for the scope value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set scope value
     */
    public function getScopeValue()
    {
        return $this->scope;
    }

    /**
     * Proxy setter method for the left value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set left value
     * @return     Region The current object (for fluent API support)
     */
    public function setLeftValue($v)
    {
        return $this->setTreeLeft($v);
    }

    /**
     * Proxy setter method for the right value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set right value
     * @return     Region The current object (for fluent API support)
     */
    public function setRightValue($v)
    {
        return $this->setTreeRight($v);
    }

    /**
     * Proxy setter method for the level value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set level value
     * @return     Region The current object (for fluent API support)
     */
    public function setLevel($v)
    {
        return $this->setTreeLevel($v);
    }

    /**
     * Proxy setter method for the scope value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set scope value
     * @return     Region The current object (for fluent API support)
     */
    public function setScopeValue($v)
    {
        return $this->setScope($v);
    }

    /**
     * Creates the supplied node as the root node.
     *
     * @return     Region The current object (for fluent API support)
     * @throws     PropelException
     */
    public function makeRoot()
    {
        if ($this->getLeftValue() || $this->getRightValue()) {
            throw new PropelException('Cannot turn an existing node into a root node.');
        }

        $this->setLeftValue(1);
        $this->setRightValue(2);
        $this->setLevel(0);

        return $this;
    }

    /**
     * Tests if onbject is a node, i.e. if it is inserted in the tree
     *
     * @return     bool
     */
    public function isInTree()
    {
        return $this->getLeftValue() > 0 && $this->getRightValue() > $this->getLeftValue();
    }

    /**
     * Tests if node is a root
     *
     * @return     bool
     */
    public function isRoot()
    {
        return $this->isInTree() && $this->getLeftValue() == 1;
    }

    /**
     * Tests if node is a leaf
     *
     * @return     bool
     */
    public function isLeaf()
    {
        return $this->isInTree() &&  ($this->getRightValue() - $this->getLeftValue()) == 1;
    }

    /**
     * Tests if node is a descendant of another node
     *
     * @param      Region $node Propel node object
     * @return     bool
     */
    public function isDescendantOf($parent)
    {
        if ($this->getScopeValue() !== $parent->getScopeValue()) {
            throw new PropelException('Comparing two nodes of different trees');
        }

        return $this->isInTree() && $this->getLeftValue() > $parent->getLeftValue() && $this->getRightValue() < $parent->getRightValue();
    }

    /**
     * Tests if node is a ancestor of another node
     *
     * @param      Region $node Propel node object
     * @return     bool
     */
    public function isAncestorOf($child)
    {
        return $child->isDescendantOf($this);
    }

    /**
     * Tests if object has an ancestor
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasParent(PropelPDO $con = null)
    {
        return $this->getLevel() > 0;
    }

    /**
     * Sets the cache for parent node of the current object.
     * Warning: this does not move the current object in the tree.
     * Use moveTofirstChildOf() or moveToLastChildOf() for that purpose
     *
     * @param      Region $parent
     * @return     Region The current object, for fluid interface
     */
    public function setParent($parent = null)
    {
        $this->aNestedSetParent = $parent;

        return $this;
    }

    /**
     * Gets parent node for the current object if it exists
     * The result is cached so further calls to the same method don't issue any queries
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getParent(PropelPDO $con = null)
    {
        if ($this->aNestedSetParent === null && $this->hasParent()) {
            $this->aNestedSetParent = RegionQuery::create()
                ->ancestorsOf($this)
                ->orderByLevel(true)
                ->findOne($con);
        }

        return $this->aNestedSetParent;
    }

    /**
     * Determines if the node has previous sibling
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasPrevSibling(PropelPDO $con = null)
    {
        if (!RegionPeer::isValid($this)) {
            return false;
        }

        return RegionQuery::create()
            ->filterByTreeRight($this->getLeftValue() - 1)
            ->inTree($this->getScopeValue())
            ->count($con) > 0;
    }

    /**
     * Gets previous sibling for the given node if it exists
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getPrevSibling(PropelPDO $con = null)
    {
        return RegionQuery::create()
            ->filterByTreeRight($this->getLeftValue() - 1)
            ->inTree($this->getScopeValue())
            ->findOne($con);
    }

    /**
     * Determines if the node has next sibling
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasNextSibling(PropelPDO $con = null)
    {
        if (!RegionPeer::isValid($this)) {
            return false;
        }

        return RegionQuery::create()
            ->filterByTreeLeft($this->getRightValue() + 1)
            ->inTree($this->getScopeValue())
            ->count($con) > 0;
    }

    /**
     * Gets next sibling for the given node if it exists
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getNextSibling(PropelPDO $con = null)
    {
        return RegionQuery::create()
            ->filterByTreeLeft($this->getRightValue() + 1)
            ->inTree($this->getScopeValue())
            ->findOne($con);
    }

    /**
     * Clears out the $collNestedSetChildren collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return     void
     */
    public function clearNestedSetChildren()
    {
        $this->collNestedSetChildren = null;
    }

    /**
     * Initializes the $collNestedSetChildren collection.
     *
     * @return     void
     */
    public function initNestedSetChildren()
    {
        $this->collNestedSetChildren = new PropelObjectCollection();
        $this->collNestedSetChildren->setModel('Region');
    }

    /**
     * Adds an element to the internal $collNestedSetChildren collection.
     * Beware that this doesn't insert a node in the tree.
     * This method is only used to facilitate children hydration.
     *
     * @param      Region $region
     *
     * @return     void
     */
    public function addNestedSetChild($region)
    {
        if ($this->collNestedSetChildren === null) {
            $this->initNestedSetChildren();
        }
        if (!$this->collNestedSetChildren->contains($region)) { // only add it if the **same** object is not already associated
            $this->collNestedSetChildren[]= $region;
            $region->setParent($this);
        }
    }

    /**
     * Tests if node has children
     *
     * @return     bool
     */
    public function hasChildren()
    {
        return ($this->getRightValue() - $this->getLeftValue()) > 1;
    }

    /**
     * Gets the children of the given node
     *
     * @param      Criteria  $criteria Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array     List of Region objects
     */
    public function getChildren($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collNestedSetChildren || null !== $criteria) {
            if ($this->isLeaf() || ($this->isNew() && null === $this->collNestedSetChildren)) {
                // return empty collection
                $this->initNestedSetChildren();
            } else {
                $collNestedSetChildren = RegionQuery::create(null, $criteria)
                  ->childrenOf($this)
                  ->orderByBranch()
                    ->find($con);
                if (null !== $criteria) {
                    return $collNestedSetChildren;
                }
                $this->collNestedSetChildren = $collNestedSetChildren;
            }
        }

        return $this->collNestedSetChildren;
    }

    /**
     * Gets number of children for the given node
     *
     * @param      Criteria  $criteria Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     int       Number of children
     */
    public function countChildren($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collNestedSetChildren || null !== $criteria) {
            if ($this->isLeaf() || ($this->isNew() && null === $this->collNestedSetChildren)) {
                return 0;
            } else {
                return RegionQuery::create(null, $criteria)
                    ->childrenOf($this)
                    ->count($con);
            }
        } else {
            return count($this->collNestedSetChildren);
        }
    }

    /**
     * Gets the first child of the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Region objects
     */
    public function getFirstChild($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return RegionQuery::create(null, $query)
                ->childrenOf($this)
                ->orderByBranch()
                ->findOne($con);
        }
    }

    /**
     * Gets the last child of the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Region objects
     */
    public function getLastChild($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return RegionQuery::create(null, $query)
                ->childrenOf($this)
                ->orderByBranch(true)
                ->findOne($con);
        }
    }

    /**
     * Gets the siblings of the given node
     *
     * @param      bool			$includeNode Whether to include the current node or not
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     *
     * @return     array 		List of Region objects
     */
    public function getSiblings($includeNode = false, $query = null, PropelPDO $con = null)
    {
        if ($this->isRoot()) {
            return array();
        } else {
             $query = RegionQuery::create(null, $query)
                    ->childrenOf($this->getParent($con))
                    ->orderByBranch();
            if (!$includeNode) {
                $query->prune($this);
            }

            return $query->find($con);
        }
    }

    /**
     * Gets descendants for the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Region objects
     */
    public function getDescendants($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return RegionQuery::create(null, $query)
                ->descendantsOf($this)
                ->orderByBranch()
                ->find($con);
        }
    }

    /**
     * Gets number of descendants for the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     int 		Number of descendants
     */
    public function countDescendants($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            // save one query
            return 0;
        } else {
            return RegionQuery::create(null, $query)
                ->descendantsOf($this)
                ->count($con);
        }
    }

    /**
     * Gets descendants for the given node, plus the current node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Region objects
     */
    public function getBranch($query = null, PropelPDO $con = null)
    {
        return RegionQuery::create(null, $query)
            ->branchOf($this)
            ->orderByBranch()
            ->find($con);
    }

    /**
     * Gets ancestors for the given node, starting with the root node
     * Use it for breadcrumb paths for instance
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Region objects
     */
    public function getAncestors($query = null, PropelPDO $con = null)
    {
        if ($this->isRoot()) {
            // save one query
            return array();
        } else {
            return RegionQuery::create(null, $query)
                ->ancestorsOf($this)
                ->orderByBranch()
                ->find($con);
        }
    }

    /**
     * Inserts the given $child node as first child of current
     * The modifications in the current object and the tree
     * are not persisted until the child object is saved.
     *
     * @param      Region $child	Propel object for child node
     *
     * @return     Region The current Propel object
     */
    public function addChild(Region $child)
    {
        if ($this->isNew()) {
            throw new PropelException('A Region object must not be new to accept children.');
        }
        $child->insertAsFirstChildOf($this);

        return $this;
    }

    /**
     * Inserts the current node as first child of given $parent node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      Region $parent	Propel object for parent node
     *
     * @return     Region The current Propel object
     */
    public function insertAsFirstChildOf($parent)
    {
        if ($this->isInTree()) {
            throw new PropelException('A Region object must not already be in the tree to be inserted. Use the moveToFirstChildOf() instead.');
        }
        $left = $parent->getLeftValue() + 1;
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($parent->getLevel() + 1);
        $scope = $parent->getScopeValue();
        $this->setScopeValue($scope);
        // update the children collection of the parent
        $parent->addNestedSetChild($this);

        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('RegionPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as last child of given $parent node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      Region $parent	Propel object for parent node
     *
     * @return     Region The current Propel object
     */
    public function insertAsLastChildOf($parent)
    {
        if ($this->isInTree()) {
            throw new PropelException('A Region object must not already be in the tree to be inserted. Use the moveToLastChildOf() instead.');
        }
        $left = $parent->getRightValue();
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($parent->getLevel() + 1);
        $scope = $parent->getScopeValue();
        $this->setScopeValue($scope);
        // update the children collection of the parent
        $parent->addNestedSetChild($this);

        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('RegionPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as prev sibling given $sibling node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      Region $sibling	Propel object for parent node
     *
     * @return     Region The current Propel object
     */
    public function insertAsPrevSiblingOf($sibling)
    {
        if ($this->isInTree()) {
            throw new PropelException('A Region object must not already be in the tree to be inserted. Use the moveToPrevSiblingOf() instead.');
        }
        $left = $sibling->getLeftValue();
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($sibling->getLevel());
        $scope = $sibling->getScopeValue();
        $this->setScopeValue($scope);
        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('RegionPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as next sibling given $sibling node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      Region $sibling	Propel object for parent node
     *
     * @return     Region The current Propel object
     */
    public function insertAsNextSiblingOf($sibling)
    {
        if ($this->isInTree()) {
            throw new PropelException('A Region object must not already be in the tree to be inserted. Use the moveToNextSiblingOf() instead.');
        }
        $left = $sibling->getRightValue() + 1;
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($sibling->getLevel());
        $scope = $sibling->getScopeValue();
        $this->setScopeValue($scope);
        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('RegionPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Moves current node and its subtree to be the first child of $parent
     * The modifications in the current object and the tree are immediate
     *
     * @param      Region $parent	Propel object for parent node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Region The current Propel object
     */
    public function moveToFirstChildOf($parent, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A Region object must be already in the tree to be moved. Use the insertAsFirstChildOf() instead.');
        }
        if ($parent->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($parent->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as child of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($parent->getLeftValue() + 1, $parent->getLevel() - $this->getLevel() + 1, $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the last child of $parent
     * The modifications in the current object and the tree are immediate
     *
     * @param      Region $parent	Propel object for parent node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Region The current Propel object
     */
    public function moveToLastChildOf($parent, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A Region object must be already in the tree to be moved. Use the insertAsLastChildOf() instead.');
        }
        if ($parent->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($parent->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as child of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($parent->getRightValue(), $parent->getLevel() - $this->getLevel() + 1, $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the previous sibling of $sibling
     * The modifications in the current object and the tree are immediate
     *
     * @param      Region $sibling	Propel object for sibling node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Region The current Propel object
     */
    public function moveToPrevSiblingOf($sibling, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A Region object must be already in the tree to be moved. Use the insertAsPrevSiblingOf() instead.');
        }
        if ($sibling->isRoot()) {
            throw new PropelException('Cannot move to previous sibling of a root node.');
        }
        if ($sibling->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($sibling->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as sibling of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($sibling->getLeftValue(), $sibling->getLevel() - $this->getLevel(), $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the next sibling of $sibling
     * The modifications in the current object and the tree are immediate
     *
     * @param      Region $sibling	Propel object for sibling node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Region The current Propel object
     */
    public function moveToNextSiblingOf($sibling, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A Region object must be already in the tree to be moved. Use the insertAsNextSiblingOf() instead.');
        }
        if ($sibling->isRoot()) {
            throw new PropelException('Cannot move to next sibling of a root node.');
        }
        if ($sibling->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($sibling->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as sibling of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($sibling->getRightValue() + 1, $sibling->getLevel() - $this->getLevel(), $con);

        return $this;
    }

    /**
     * Move current node and its children to location $destLeft and updates rest of tree
     *
     * @param      int	$destLeft Destination left value
     * @param      int	$levelDelta Delta to add to the levels
     * @param      PropelPDO $con		Connection to use.
     */
    protected function moveSubtreeTo($destLeft, $levelDelta, PropelPDO $con = null)
    {
        $left  = $this->getLeftValue();
        $right = $this->getRightValue();
        $scope = $this->getScopeValue();

        $treeSize = $right - $left +1;

        if ($con === null) {
            $con = Propel::getConnection(RegionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            // make room next to the target for the subtree
            RegionPeer::shiftRLValues($treeSize, $destLeft, null, $scope, $con);

            if ($left >= $destLeft) { // src was shifted too?
                $left += $treeSize;
                $right += $treeSize;
            }

            if ($levelDelta) {
                // update the levels of the subtree
                RegionPeer::shiftLevel($levelDelta, $left, $right, $scope, $con);
            }

            // move the subtree to the target
            RegionPeer::shiftRLValues($destLeft - $left, $left, $right, $scope, $con);

            // remove the empty room at the previous location of the subtree
            RegionPeer::shiftRLValues(-$treeSize, $right + 1, null, $scope, $con);

            // update all loaded nodes
            RegionPeer::updateLoadedNodes(null, $con);

            $con->commit();
        } catch (PropelException $e) {
            $con->rollback();
            throw $e;
        }
    }

    /**
     * Deletes all descendants for the given node
     * Instance pooling is wiped out by this command,
     * so existing Region instances are probably invalid (except for the current one)
     *
     * @param      PropelPDO $con Connection to use.
     *
     * @return     int 		number of deleted nodes
     */
    public function deleteDescendants(PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            // save one query
            return;
        }
        if ($con === null) {
            $con = Propel::getConnection(RegionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $left = $this->getLeftValue();
        $right = $this->getRightValue();
        $scope = $this->getScopeValue();
        $con->beginTransaction();
        try {
            // delete descendant nodes (will empty the instance pool)
            $ret = RegionQuery::create()
                ->descendantsOf($this)
                ->delete($con);

            // fill up the room that was used by descendants
            RegionPeer::shiftRLValues($left - $right + 1, $right, null, $scope, $con);

            // fix the right value for the current node, which is now a leaf
            $this->setRightValue($left + 1);

            $con->commit();
        } catch (Exception $e) {
            $con->rollback();
            throw $e;
        }

        return $ret;
    }

    /**
     * Returns a pre-order iterator for this node and its children.
     *
     * @return     RecursiveIterator
     */
    public function getIterator()
    {
        return new NestedSetRecursiveIterator($this);
    }

}
