<link rel="stylesheet" type="text/css" href="css/jsgantt.css" />
<script language="javascript" src="scripts/jsgantt.js"></script>
<script language="javascript" src="scripts/jsgantt-fix.js"></script>

<div style="position:relative" class="gantt" id="gantt-box"></div>
<style>
	#gantt-boxgchartbody {
		overflow-y: hidden;
	}

	.collapse-button {
		margin: 0.5em;
		font-size: x-large;
	}

	.gongoing {
		height: 7px;
		margin-top: 2px;
		background: green url("images/ongoingGantt.png");
	}

	.gmilestonefix-planned {
		width: 16px !important;
		height: 16px;
		/*border: 1px solid black;
		border-radius: 5px;*/
		background: url("images/pentagon-gray.png");
	}

	.gmilestonefix-real {
		width: 16px !important;
		height: 16px;
		/*border: 1px solid black;
		border-radius: 5px;*/
		background:  url("images/ganttReal.png"); /* rgb(58,132,195)*/;
	}

	|-*if $grayBars*-|
		.gongoing, .gtaskblue, .gtaskred {
			background: gray;
		}
	|-*/if*-|

	.bar-green.gtaskblue, .bar-green.gongoing {
		background: green;
	}
	
	/* cuando se solapan */
	.ggroupblack, .gtaskblue, .gtaskred, .gtaskgreen, .gtaskyellow, .gtaskpurple, .gtaskpink {
		height: 13px;
		filter: alpha(opacity=90);
		opacity: 0.9;
		margin-top: 6px;
	}

	.bar-yellow.gtaskblue, .bar-yellow.gongoing {
		background: yellow;
	}

	.bar-red.gtaskblue, .bar-red.gongoing {
		background: red;
	}

	.bar-blue.gtaskblue, .bar-blue.gongoing {
		background: blue;
	}

	.bar-black.gtaskblue, .bar-black.gongoing {
		background: black;
	}

	.bar-white.gtaskblue, .bar-white.gongoing {
		background: gray;
	}
	
	.gTtTitle{
		font-size: 15px;
	}
	
	.gTaskLabel{
		font-size: 12px;
	}
	
	.gTaskText{
		font-size: 12px;
	}
	
	.gTIc{
		display:none;
	}
	
	.gTaskInfo{
		width: 600px;
	}
	
	.gTaskText{
		width:600px;
	}
	
</style>

|-function name="barCombiner" activity=null id=null parentId=0 level=0 ordinal=1 parentOrder=1-|

	var activityWrapper = new JSGantt.TaskItem(
		|-$id-|,
		'|-$activity->getName()|escape:"javascript"-| |-if $activity->getPress()-|[*]|-/if-|', // label
		'', // start
		'', // end
		'ggroupblack', // css class
		'|-$activity|routeTo:"edit"-|', // link
		0, // 0: non-milestone - 1: milestone
		'|-$activity->getResponsible()|position-|', // resource name?
		0, // completion percent
		2, // 0: normal task - 1: standard group - 2: combined group
		|-$parentId-|, // parent id
		1, // group open when chart drawn / 0: closed - 1: open
		'', // dependencies
		'', // caption?
		'', // details
		g // gantt object
	);

	// name column override
	activityWrapper.nameDisplayHtml = '|-$activity->getName()|escape:"javascript"-||-if $activity->getPress()-|&nbsp;&nbsp;<i class="fa fa-asterisk" aria-hidden="true" title="Hito comunicable" style="color: green;"></i>|-/if-|';

	|-for $i=1 to $level-|
		activityWrapper.nameDisplayHtml = "&nbsp;&nbsp;&nbsp;&nbsp;" + activityWrapper.nameDisplayHtml;
	|-/for-|

	// activityWrapper.hasChildren = |-if $activity->countChildrenActivitys() > 0-|true|-else-|false|-/if-|;
	// activityWrapper.hasParentActivity = |-if $activity->getParentActivityId() > 0-|true|-else-|false|-/if-|;

	activityWrapper.customData = |-$activity->toJSON()-|;

	g.AddTaskItem(activityWrapper);

|-/function-|

|-function name="plannedBar" activity=null  activity=null id=null parentId=0-|
	
	|-$plannedStart = $activity->getPlannedStart("Y-m-d")-|
	|-$plannedEnd = $activity->getPlannedEnd("Y-m-d")-|
	|-$realStart = $activity->getRealStart("Y-m-d")-|
	|-$realEnd = $activity->getRealEnd("Y-m-d")-|

	|-if $plannedStart == $plannedEnd-|
		|-$barClass = 'gmilestonefix-planned'-|
	|-else-|
		|-if $realStart-|
			|-$barClass = 'gtaskblue'-|
		|-else-|
			|-$barClass = 'bar-'|cat:$activity->statusColor()|cat:' '|cat:'gtaskblue'-|
		|-/if-|
	|-/if-|

	var plannedBar = new JSGantt.TaskItem(
		|-$id-|,
		'Planificado - |-$activity->getName()|escape:"javascript"-|', // label
		'|-$activity->getPlannedStart("Y-m-d")-|', // start
		'|-$activity->getPlannedEnd("Y-m-d")-|', // end
		'|-$barClass-|', // css class
		'', // link
		0, // 0: non-milestone - 1: milestone
		'|-$activity->getResponsible()|position-|', // resource name?
		0, // completion percent
		0, // 0: normal task - 1: standard group - 2: combined group
		|-$parentId-|, // parent id
		1, // group open when chart drawn / 0: closed - 1: open
		'', // dependencies
		'', // caption?
		'', // details
		g // gantt object
	);

	plannedBar.customData = |-$activity->toJSON()-|;

	g.AddTaskItem(plannedBar);

|-/function-|

|-function name="realBar" activity=null  activity=null id=null parentId=0-|

	|-if $realStart && !$realEnd-|
		|-$barClass = 'gongoing'-|
	|-else-|
		|-if $realStart == $realEnd-|
			|-$barClass = 'gmilestonefix-real'-|
		|-else-|
			|-$barClass = 'gtaskblue'-|
		|-/if-|
	|-/if-|
	
	|-if $realStart == $realEnd-|
		|-$barClass = 'gmilestonefix-real'-|
	|-else-|
		|-$barClass = 'gongoing'-|
	|-/if-|

	|-$barClass = 'bar-'|cat:$activity->statusColor()|cat:' '|cat:$barClass-|

	|-if $realStart || $realEnd-|

		var realBar = new JSGantt.TaskItem(
			|-$id-|,
			'Real - |-$activity->getName()|escape:"javascript"-|', // label
			'|-$realStart-|', // start
			'|-$realEnd-|', // end
			'|-$barClass-|', // css class
			'', // link
			0, // 0: non-milestone - 1: milestone
			'|-$activity->getResponsible()|position-|', // resource name?
			0, // completion percent
			0, // 0: normal task - 1: standard group - 2: combined group
			|-$parentId-|, // parent id
			1, // group open when chart drawn / 0: closed - 1: open
			'', // dependencies
			'', // caption?
			'', // details
			g // gantt object
		);

		realBar.customData = |-$activity->toJSON()-|;

		g.AddTaskItem(realBar);

	|-/if-|

|-/function-|

|-function name="activitiesGroup" activity=null  activity=null id=null parentId=0-|

	var activityGroup = new JSGantt.TaskItem(
		|-$id-|,
		'|-$activity->getName()|escape:"javascript"-| |-if $activity->getPress()-|[*]|-/if-| + Sub', // label
		'', // start
		'', // end
		'ggroupblack', // css class
		'|-$activity|routeTo:"edit"-|', // link
		0, // 0: non-milestone - 1: milestone
		'|-$activity->getResponsible()|position-|', // resource name?
		0, // completion percent
		1, // 0: normal task - 1: standard group - 2: combined group
		|-$parentId-|, //'group-|-$activity->getId()-|', // parent id
		1, // group open when chart drawn / 0: closed - 1: open
		'', // dependencies
		'', // caption?
		'', // details
		g // gantt object
	);

	// name column override
	activityGroup.nameDisplayHtml = '|-$activity->getName()|escape:"javascript"-||-if $activity->getPress()-|&nbsp;&nbsp;<i class="fa fa-asterisk" aria-hidden="true" title="Interés Prensa" style="color: green;"></i>|-/if-|';

	activityGroup.customData = |-$activity->toJSON()-|;

	g.AddTaskItem(activityGroup);

|-/function-|

|-function name="fullActivity" activity="null" parentId=0 level=0 ordinal=1 parentOrder=1-|

	|-$plannedStart = $activity->getPlannedStart("Y-m-d")-|
	|-$plannedEnd = $activity->getPlannedEnd("Y-m-d")-|
	|-$realStart = $activity->getRealStart("Y-m-d")-|
	|-$realEnd = $activity->getRealEnd("Y-m-d")-|

	|-* id - need multiple ids for the same activity. hence the + N *-|

	|-$barCombinerId = $activity->getId() * 1000 + 1-|
	|-$plannedBarId = $activity->getId() * 1000 + 2-|
	|-$realBarId = $activity->getId() * 1000 + 3-|
	|-$activitiesGroupId = $activity->getId() * 1000 + 4-|

	|-if $activity->countChildrenActivitys() > 0-|

		|-activitiesGroup activity=$activity id=$activitiesGroupId parentId=$parentId level=$level-|

		|-barCombiner activity=$activity id=$barCombinerId parentId=$activitiesGroupId level=$level ordinal=$ordinal parentOrder=$parentOrder-|
		|-plannedBar activity=$activity id=$plannedBarId parentId=$barCombinerId-|
		|-realBar activity=$activity id=$realBarId parentId=$barCombinerId-|
		
		|-$ordinalChild = 1-|
		|-foreach $activity->getChildrenActivitysOrderByOrder() as $child-|
			|-fullActivity activity=$child parentId=$activitiesGroupId level=($level + 1) ordinal=$ordinalChild parentOrder=$ordinal-|
			|-$ordinalChild = $ordinalChild + 1-|
		|-/foreach-|

	|-else-|

		|-barCombiner activity=$activity id=$barCombinerId parentId=$parentId level=$level ordinal=$ordinal parentOrder=$parentOrder-|
		|-plannedBar activity=$activity id=$plannedBarId parentId=$barCombinerId-|
		|-realBar activity=$activity id=$realBarId parentId=$barCombinerId-|

	|-/if-|

|-/function-|

<script>

	JSGantt.TaskItem = FixedTaskItem;

	var g = new FixedGanttChart(document.getElementById('gantt-box'), 'month');
		<!--Formato del Gantt-->
		g.setLang('es');
		|-*if $hideDescription*-|
			g.setShowRes(0);
		|-*/if*-|
		g.setChartHead('|-$project|escape:"javascript"-|')
		g.setShowDur(0);
		g.setShowComp(0);
		|-if $hideDates-|
			g.setShowStartDate(0);
			g.setShowEndDate(0);
		|-/if-|
		g.setShowTaskInfoNotes(0);
		g.setShowTaskInfoDur(0);
		g.setUseFade(0);
		g.setFormatArr('Week', 'Month');
		g.setDateTaskDisplayFormat('dd/mm/yyyy');
		g.setRowHeight(25);

	|-$activities = $project->getActivitiesOrderedForGantt()-|
	|-$ordinal = 1-|
	|-foreach $activities as $activity-|

		|-if !$activity->isSubactivity()-|
			|-fullActivity activity=$activity ordinal=$ordinal-|
			|-$ordinal = $ordinal + 1-|
		|-/if-|

	|-/foreach-| |-* / *-|

	g.Draw();
	
	|-* Ocultar el Completo: del tooltips del gantt*-|
	$('.gTIc').hide();
	
</script>
