<?php

use Egytca\Planning\YearFilter as PlanningYearFilter;

/**
 * Skeleton subclass for performing query and update operations on the 'projects_activity' table.
 *
 * Activity
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.projects.classes
 */
class ProjectActivityQuery extends BaseProjectActivityQuery {

	use PlanningYearFilter;

	private $useLoggedUserGroupAutoFilter = false;

	public function __construct($dbName = 'application', $modelName = 'ProjectActivity', $modelAlias = null) {

		parent::__construct($dbName, $modelName, $modelAlias);

		$loggedUser = Common::getLoggedUser();
		if ($loggedUser && !$loggedUser->isSupervisor() && ConfigModule::get('users', 'useFilterByUserGroup')) {
			$this->useLoggedUserGroupAutoFilter = true;
		}

		$this->filterByPlanningYears();

		return $this;
	}

	/**
	 * Agrega filtros por nombre y descripcion.
	 *
	 * @param   type string $filterValue texto a buscar
	 * @return condicion de filtrado por texto a buscar
	 */
	public function searchString($filterValue) {
		return $this->filterByName("%$filterValue%", Criteria::LIKE)
				->_or()
					->filterByDescription("%$filterValue%", Criteria::LIKE);
				//->_or()
				//	->useProjectQuery()
				//		->filterByName("%$filterValue%", Criteria::LIKE)
				//	->endUse();				
	}

	function preSelect() {
		if ($this->useLoggedUserGroupAutoFilter) {
			$this->filterByLoggedUserGroup();
		}
	}

	function setLoggedUserGroupAutoFilter($value) {
		$this->useLoggedUserGroupAutoFilter = $value;
		return $this;
	}

	function filterByLoggedUserGroup() {
		return $this->useProjectQuery()
				->filterByLoggedUserGroup()
			->endUse();
	}
	
	function filterByDelayed2($value) {
		
		$currentTime = date('Y-m-d');
		
		// Si se usa tolerancia en dias
		global $system;
		if ($system["config"]["tablero"]["activities"]["parameterControl"]["value"] == "DAYS") {
			$days = $system["config"]["tablero"]["activities"]["delayed"]; 
			$currentTime = time() - ($days * 24 * 60 * 60);		
		}

		return $this->filterByPlannedstart(null, $value ? Criteria::ISNOTNULL : Criteria::ISNULL)
			->filterByPlannedstart($currentTime, $value ? Criteria::GREATER_THAN : Criteria::LESS_EQUAL)
			->filterByStarted(!$value);
	}
	
	function filterByStarted($value) {
		return $this->filterByRealstart(null, $value ? Criteria::ISNOTNULL : Criteria::ISNULL);
	}

	/**
	 * Devuelve la criteria para filtrar por fecha de finalización planificada a fin de armar un reporte de alertas de actividades.
	 */
	public function filterByPendingEnd($date, $comparison = null) {
		return $this->filterByCompleted(false)
			->filterByPlannedEnd($date, $comparison)
			->filterByRealend(null, Criteria::ISNULL);
	}

	/**
	 * Filtar por estado.
	 * @param array status filtros por estado.
	 * $status['delayed'] == 1 filtar por retrasados.
	 * $status['ended'] == 1 filtra por finalizados
	 * $status['working'] == 1 filtra por en ejecucion
	 *
	 * Los filtros se combinan con OR ya que se puede filtrar por mas de uno a la ves.
	 */
	function filterByStatus($status) {

		$criterion;

		if (array_key_exists('ended', $status)) {

			if ($status['ended']) {

				$criterionEnded = $this->criterionForStatusColor('blue');

				if (empty($criterion))
					$criterion = $criterionEnded;
				else
					$criterion->addOr($criterionEnded);
			}
		}

		if (array_key_exists('ontime', $status)) {

			if ($status['ontime']) {

				$criterionOntime = $this->criterionForStatusColor('green');

				if (empty($criterion))
					$criterion = $criterionOntime;
				else
					$criterion->addOr($criterionOntime);
			}
		}

		if (array_key_exists('delayed', $status)) {

			if ($status['delayed']) {

				$criterionDelayed = $this->criterionForStatusColor('yellow')
					->addOr($this->criterionForStatusColor('red'));

				if (empty($criterion))
					$criterion = $criterionDelayed;
				else
					$criterion->addOr($criterionDelayed);
			}
		}

		$this->add($criterion);

		return $this;
	}

	function criterionForStatusColor($color) {
		$allObjects = static::create()->find();
		$wantedColorIds = [];
		foreach ($allObjects as $object) {
			if ($object->statusColor() == $color) {
				$wantedColorIds[] = $object->getId();
			}
		}
		return new Criterion($this, ProjectActivityPeer::ID, $wantedColorIds, Criteria::IN);
	}

	function filterByStatusColor($color) {
		return $this->add($this->criterionForStatusColor($color));
	}

	function filterByDateFrom($plannedStart) {
		return $this->filterByPlannedStart($plannedStart, CRITERIA::GREATER_EQUAL);		
	}

	function filterByDateTo($plannedStart) {
		return $this->filterByPlannedStart($plannedStart, CRITERIA::LESS_EQUAL);		
	}

} // ProjectActivityQuery

