<?php

/**
 * ProjectsActivitiesBulkEditAction
 *
 * Muestra el formulario de creaci�n de actividades masivas
 *
 * @package projects
 */

class ProjectsActivitiesBulkEditAction extends BaseAction {

	/**
	 * Acciones a ejecutar antes generar el display
	 */
	protected function exec() {
		parent::exec();
		
		$this->smarty->assign('includeJQuery', true);

		if ($_GET["filters"]["projectId"]) {
			
			$parentObject = ProjectQuery::create()->findOneById($_GET["filters"]["projectId"]);
			$activitiesList = $parentObject->getActivitiesOrderedForGantt();
			
			$this->smarty->assign('type', 'activity');

		} elseif ($_GET["filters"]["activityId"]) {
			
			$parentObject = ProjectActivityQuery::create()->findOneById($_GET["filters"]["activityId"]);
			$activitiesList = $parentObject->getChildrenActivitys();

			$this->smarty->assign('type', 'subactivity');
		}

		if (empty($parentObject)) {
			$this->smarty->assign('invalidId', true);
			return;
		}
		$this->smarty->assign('parentObject',$parentObject);
		$this->smarty->assign('activitiesList',$activitiesList);
		
	} //End exec

}
