<?php


/**
 * Base class that represents a row from the 'positions_positionTenure' table.
 *
 * Ejercicio del cargo
 *
 * @package    propel.generator.positions.classes.om
 */
abstract class BasePositionTenure extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'PositionTenurePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        PositionTenurePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the userid field.
     * @var        int
     */
    protected $userid;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the datefrom field.
     * @var        string
     */
    protected $datefrom;

    /**
     * The value for the dateto field.
     * @var        string
     */
    protected $dateto;

    /**
     * The value for the positioncode field.
     * @var        int
     */
    protected $positioncode;

    /**
     * The value for the ownername field.
     * @var        string
     */
    protected $ownername;

    /**
     * The value for the objecttype field.
     * @var        string
     */
    protected $objecttype;

    /**
     * The value for the objectid field.
     * @var        int
     */
    protected $objectid;

    /**
     * @var        Position
     */
    protected $aPosition;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [userid] column value.
     * Id de la persona que ejerce el cargo
     * @return int
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Get the [name] column value.
     * Nombre de la persona que ejerce el cargo
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [optionally formatted] temporal [datefrom] column value.
     * Fecha en que se asumio el cargo
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDatefrom($format = 'Y-m-d H:i:s')
    {
        if ($this->datefrom === null) {
            return null;
        }

        if ($this->datefrom === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->datefrom);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->datefrom, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [dateto] column value.
     * Fecha en que abandono el cargo
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDateto($format = 'Y-m-d H:i:s')
    {
        if ($this->dateto === null) {
            return null;
        }

        if ($this->dateto === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->dateto);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->dateto, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [positioncode] column value.
     * Id del cargo
     * @return int
     */
    public function getPositioncode()
    {
        return $this->positioncode;
    }

    /**
     * Get the [ownername] column value.
     * Titulo de la persona que ocupa el cargo (Presidente)
     * @return string
     */
    public function getOwnername()
    {
        return $this->ownername;
    }

    /**
     * Get the [objecttype] column value.
     * Tipo de tenure
     * @return string
     */
    public function getObjecttype()
    {
        return $this->objecttype;
    }

    /**
     * Get the [objectid] column value.
     * Id del tenure
     * @return int
     */
    public function getObjectid()
    {
        return $this->objectid;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = PositionTenurePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [userid] column.
     * Id de la persona que ejerce el cargo
     * @param int $v new value
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setUserid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userid !== $v) {
            $this->userid = $v;
            $this->modifiedColumns[] = PositionTenurePeer::USERID;
        }


        return $this;
    } // setUserid()

    /**
     * Set the value of [name] column.
     * Nombre de la persona que ejerce el cargo
     * @param string $v new value
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = PositionTenurePeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Sets the value of [datefrom] column to a normalized version of the date/time value specified.
     * Fecha en que se asumio el cargo
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setDatefrom($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datefrom !== null || $dt !== null) {
            $currentDateAsString = ($this->datefrom !== null && $tmpDt = new DateTime($this->datefrom)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->datefrom = $newDateAsString;
                $this->modifiedColumns[] = PositionTenurePeer::DATEFROM;
            }
        } // if either are not null


        return $this;
    } // setDatefrom()

    /**
     * Sets the value of [dateto] column to a normalized version of the date/time value specified.
     * Fecha en que abandono el cargo
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setDateto($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->dateto !== null || $dt !== null) {
            $currentDateAsString = ($this->dateto !== null && $tmpDt = new DateTime($this->dateto)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->dateto = $newDateAsString;
                $this->modifiedColumns[] = PositionTenurePeer::DATETO;
            }
        } // if either are not null


        return $this;
    } // setDateto()

    /**
     * Set the value of [positioncode] column.
     * Id del cargo
     * @param int $v new value
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setPositioncode($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->positioncode !== $v) {
            $this->positioncode = $v;
            $this->modifiedColumns[] = PositionTenurePeer::POSITIONCODE;
        }

        if ($this->aPosition !== null && $this->aPosition->getCode() !== $v) {
            $this->aPosition = null;
        }


        return $this;
    } // setPositioncode()

    /**
     * Set the value of [ownername] column.
     * Titulo de la persona que ocupa el cargo (Presidente)
     * @param string $v new value
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setOwnername($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ownername !== $v) {
            $this->ownername = $v;
            $this->modifiedColumns[] = PositionTenurePeer::OWNERNAME;
        }


        return $this;
    } // setOwnername()

    /**
     * Set the value of [objecttype] column.
     * Tipo de tenure
     * @param string $v new value
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setObjecttype($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->objecttype !== $v) {
            $this->objecttype = $v;
            $this->modifiedColumns[] = PositionTenurePeer::OBJECTTYPE;
        }


        return $this;
    } // setObjecttype()

    /**
     * Set the value of [objectid] column.
     * Id del tenure
     * @param int $v new value
     * @return PositionTenure The current object (for fluent API support)
     */
    public function setObjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectid !== $v) {
            $this->objectid = $v;
            $this->modifiedColumns[] = PositionTenurePeer::OBJECTID;
        }


        return $this;
    } // setObjectid()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->userid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->name = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->datefrom = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->dateto = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->positioncode = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
            $this->ownername = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->objecttype = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->objectid = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 9; // 9 = PositionTenurePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating PositionTenure object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aPosition !== null && $this->positioncode !== $this->aPosition->getCode()) {
            $this->aPosition = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PositionTenurePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = PositionTenurePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aPosition = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PositionTenurePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = PositionTenureQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PositionTenurePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                PositionTenurePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aPosition !== null) {
                if ($this->aPosition->isModified() || $this->aPosition->isNew()) {
                    $affectedRows += $this->aPosition->save($con);
                }
                $this->setPosition($this->aPosition);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = PositionTenurePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . PositionTenurePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(PositionTenurePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(PositionTenurePeer::USERID)) {
            $modifiedColumns[':p' . $index++]  = '`USERID`';
        }
        if ($this->isColumnModified(PositionTenurePeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(PositionTenurePeer::DATEFROM)) {
            $modifiedColumns[':p' . $index++]  = '`DATEFROM`';
        }
        if ($this->isColumnModified(PositionTenurePeer::DATETO)) {
            $modifiedColumns[':p' . $index++]  = '`DATETO`';
        }
        if ($this->isColumnModified(PositionTenurePeer::POSITIONCODE)) {
            $modifiedColumns[':p' . $index++]  = '`POSITIONCODE`';
        }
        if ($this->isColumnModified(PositionTenurePeer::OWNERNAME)) {
            $modifiedColumns[':p' . $index++]  = '`OWNERNAME`';
        }
        if ($this->isColumnModified(PositionTenurePeer::OBJECTTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTTYPE`';
        }
        if ($this->isColumnModified(PositionTenurePeer::OBJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTID`';
        }

        $sql = sprintf(
            'INSERT INTO `positions_positionTenure` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`USERID`':
                        $stmt->bindValue($identifier, $this->userid, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DATEFROM`':
                        $stmt->bindValue($identifier, $this->datefrom, PDO::PARAM_STR);
                        break;
                    case '`DATETO`':
                        $stmt->bindValue($identifier, $this->dateto, PDO::PARAM_STR);
                        break;
                    case '`POSITIONCODE`':
                        $stmt->bindValue($identifier, $this->positioncode, PDO::PARAM_INT);
                        break;
                    case '`OWNERNAME`':
                        $stmt->bindValue($identifier, $this->ownername, PDO::PARAM_STR);
                        break;
                    case '`OBJECTTYPE`':
                        $stmt->bindValue($identifier, $this->objecttype, PDO::PARAM_STR);
                        break;
                    case '`OBJECTID`':
                        $stmt->bindValue($identifier, $this->objectid, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aPosition !== null) {
                if (!$this->aPosition->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPosition->getValidationFailures());
                }
            }


            if (($retval = PositionTenurePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }



            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = PositionTenurePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getUserid();
                break;
            case 2:
                return $this->getName();
                break;
            case 3:
                return $this->getDatefrom();
                break;
            case 4:
                return $this->getDateto();
                break;
            case 5:
                return $this->getPositioncode();
                break;
            case 6:
                return $this->getOwnername();
                break;
            case 7:
                return $this->getObjecttype();
                break;
            case 8:
                return $this->getObjectid();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['PositionTenure'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['PositionTenure'][$this->getPrimaryKey()] = true;
        $keys = PositionTenurePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getUserid(),
            $keys[2] => $this->getName(),
            $keys[3] => $this->getDatefrom(),
            $keys[4] => $this->getDateto(),
            $keys[5] => $this->getPositioncode(),
            $keys[6] => $this->getOwnername(),
            $keys[7] => $this->getObjecttype(),
            $keys[8] => $this->getObjectid(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aPosition) {
                $result['Position'] = $this->aPosition->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = PositionTenurePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setUserid($value);
                break;
            case 2:
                $this->setName($value);
                break;
            case 3:
                $this->setDatefrom($value);
                break;
            case 4:
                $this->setDateto($value);
                break;
            case 5:
                $this->setPositioncode($value);
                break;
            case 6:
                $this->setOwnername($value);
                break;
            case 7:
                $this->setObjecttype($value);
                break;
            case 8:
                $this->setObjectid($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = PositionTenurePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setUserid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setName($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setDatefrom($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setDateto($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setPositioncode($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setOwnername($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setObjecttype($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setObjectid($arr[$keys[8]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(PositionTenurePeer::DATABASE_NAME);

        if ($this->isColumnModified(PositionTenurePeer::ID)) $criteria->add(PositionTenurePeer::ID, $this->id);
        if ($this->isColumnModified(PositionTenurePeer::USERID)) $criteria->add(PositionTenurePeer::USERID, $this->userid);
        if ($this->isColumnModified(PositionTenurePeer::NAME)) $criteria->add(PositionTenurePeer::NAME, $this->name);
        if ($this->isColumnModified(PositionTenurePeer::DATEFROM)) $criteria->add(PositionTenurePeer::DATEFROM, $this->datefrom);
        if ($this->isColumnModified(PositionTenurePeer::DATETO)) $criteria->add(PositionTenurePeer::DATETO, $this->dateto);
        if ($this->isColumnModified(PositionTenurePeer::POSITIONCODE)) $criteria->add(PositionTenurePeer::POSITIONCODE, $this->positioncode);
        if ($this->isColumnModified(PositionTenurePeer::OWNERNAME)) $criteria->add(PositionTenurePeer::OWNERNAME, $this->ownername);
        if ($this->isColumnModified(PositionTenurePeer::OBJECTTYPE)) $criteria->add(PositionTenurePeer::OBJECTTYPE, $this->objecttype);
        if ($this->isColumnModified(PositionTenurePeer::OBJECTID)) $criteria->add(PositionTenurePeer::OBJECTID, $this->objectid);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(PositionTenurePeer::DATABASE_NAME);
        $criteria->add(PositionTenurePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of PositionTenure (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setUserid($this->getUserid());
        $copyObj->setName($this->getName());
        $copyObj->setDatefrom($this->getDatefrom());
        $copyObj->setDateto($this->getDateto());
        $copyObj->setPositioncode($this->getPositioncode());
        $copyObj->setOwnername($this->getOwnername());
        $copyObj->setObjecttype($this->getObjecttype());
        $copyObj->setObjectid($this->getObjectid());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return PositionTenure Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return PositionTenurePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new PositionTenurePeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Position object.
     *
     * @param             Position $v
     * @return PositionTenure The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPosition(Position $v = null)
    {
        if ($v === null) {
            $this->setPositioncode(NULL);
        } else {
            $this->setPositioncode($v->getCode());
        }

        $this->aPosition = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Position object, it will not be re-added.
        if ($v !== null) {
            $v->addPositionTenure($this);
        }


        return $this;
    }


    /**
     * Get the associated Position object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Position The associated Position object.
     * @throws PropelException
     */
    public function getPosition(PropelPDO $con = null)
    {
        if ($this->aPosition === null && ($this->positioncode !== null)) {
            $this->aPosition = PositionQuery::create()
                ->filterByPositionTenure($this) // here
                ->findOne($con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPosition->addPositionTenures($this);
             */
        }

        return $this->aPosition;
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->userid = null;
        $this->name = null;
        $this->datefrom = null;
        $this->dateto = null;
        $this->positioncode = null;
        $this->ownername = null;
        $this->objecttype = null;
        $this->objectid = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aPosition = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(PositionTenurePeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
