<?php


/**
 * Base class that represents a query for the 'panel_resultFrameValue' table.
 *
 * Valores de los indicadores del Marco de Resultados
 *
 * @method ResultFrameValueQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ResultFrameValueQuery orderByResultframeindicatorid($order = Criteria::ASC) Order by the resultFrameIndicatorId column
 * @method ResultFrameValueQuery orderByYear($order = Criteria::ASC) Order by the year column
 * @method ResultFrameValueQuery orderByValue($order = Criteria::ASC) Order by the value column
 * @method ResultFrameValueQuery orderByGoal($order = Criteria::ASC) Order by the goal column
 * @method ResultFrameValueQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ResultFrameValueQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ResultFrameValueQuery groupById() Group by the id column
 * @method ResultFrameValueQuery groupByResultframeindicatorid() Group by the resultFrameIndicatorId column
 * @method ResultFrameValueQuery groupByYear() Group by the year column
 * @method ResultFrameValueQuery groupByValue() Group by the value column
 * @method ResultFrameValueQuery groupByGoal() Group by the goal column
 * @method ResultFrameValueQuery groupByUpdated() Group by the updated column
 * @method ResultFrameValueQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ResultFrameValueQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ResultFrameValueQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ResultFrameValueQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ResultFrameValueQuery leftJoinResultFrameIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the ResultFrameIndicator relation
 * @method ResultFrameValueQuery rightJoinResultFrameIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ResultFrameIndicator relation
 * @method ResultFrameValueQuery innerJoinResultFrameIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the ResultFrameIndicator relation
 *
 * @method ResultFrameValue findOne(PropelPDO $con = null) Return the first ResultFrameValue matching the query
 * @method ResultFrameValue findOneOrCreate(PropelPDO $con = null) Return the first ResultFrameValue matching the query, or a new ResultFrameValue object populated from the query conditions when no match is found
 *
 * @method ResultFrameValue findOneById(int $id) Return the first ResultFrameValue filtered by the id column
 * @method ResultFrameValue findOneByResultframeindicatorid(int $resultFrameIndicatorId) Return the first ResultFrameValue filtered by the resultFrameIndicatorId column
 * @method ResultFrameValue findOneByYear(int $year) Return the first ResultFrameValue filtered by the year column
 * @method ResultFrameValue findOneByValue(string $value) Return the first ResultFrameValue filtered by the value column
 * @method ResultFrameValue findOneByGoal(string $goal) Return the first ResultFrameValue filtered by the goal column
 * @method ResultFrameValue findOneByUpdated(string $updated) Return the first ResultFrameValue filtered by the updated column
 * @method ResultFrameValue findOneByDeletedAt(string $deleted_at) Return the first ResultFrameValue filtered by the deleted_at column
 *
 * @method array findById(int $id) Return ResultFrameValue objects filtered by the id column
 * @method array findByResultframeindicatorid(int $resultFrameIndicatorId) Return ResultFrameValue objects filtered by the resultFrameIndicatorId column
 * @method array findByYear(int $year) Return ResultFrameValue objects filtered by the year column
 * @method array findByValue(string $value) Return ResultFrameValue objects filtered by the value column
 * @method array findByGoal(string $goal) Return ResultFrameValue objects filtered by the goal column
 * @method array findByUpdated(string $updated) Return ResultFrameValue objects filtered by the updated column
 * @method array findByDeletedAt(string $deleted_at) Return ResultFrameValue objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseResultFrameValueQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseResultFrameValueQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ResultFrameValue', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ResultFrameValueQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ResultFrameValueQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ResultFrameValueQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ResultFrameValueQuery) {
            return $criteria;
        }
        $query = new ResultFrameValueQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ResultFrameValue|ResultFrameValue[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ResultFrameValuePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ResultFrameValuePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ResultFrameValue A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `RESULTFRAMEINDICATORID`, `YEAR`, `VALUE`, `GOAL`, `UPDATED`, `DELETED_AT` FROM `panel_resultFrameValue` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ResultFrameValue();
            $obj->hydrate($row);
            ResultFrameValuePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ResultFrameValue|ResultFrameValue[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ResultFrameValue[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ResultFrameValuePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ResultFrameValuePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ResultFrameValuePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the resultFrameIndicatorId column
     *
     * Example usage:
     * <code>
     * $query->filterByResultframeindicatorid(1234); // WHERE resultFrameIndicatorId = 1234
     * $query->filterByResultframeindicatorid(array(12, 34)); // WHERE resultFrameIndicatorId IN (12, 34)
     * $query->filterByResultframeindicatorid(array('min' => 12)); // WHERE resultFrameIndicatorId > 12
     * </code>
     *
     * @see       filterByResultFrameIndicator()
     *
     * @param     mixed $resultframeindicatorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterByResultframeindicatorid($resultframeindicatorid = null, $comparison = null)
    {
        if (is_array($resultframeindicatorid)) {
            $useMinMax = false;
            if (isset($resultframeindicatorid['min'])) {
                $this->addUsingAlias(ResultFrameValuePeer::RESULTFRAMEINDICATORID, $resultframeindicatorid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($resultframeindicatorid['max'])) {
                $this->addUsingAlias(ResultFrameValuePeer::RESULTFRAMEINDICATORID, $resultframeindicatorid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameValuePeer::RESULTFRAMEINDICATORID, $resultframeindicatorid, $comparison);
    }

    /**
     * Filter the query on the year column
     *
     * Example usage:
     * <code>
     * $query->filterByYear(1234); // WHERE year = 1234
     * $query->filterByYear(array(12, 34)); // WHERE year IN (12, 34)
     * $query->filterByYear(array('min' => 12)); // WHERE year > 12
     * </code>
     *
     * @param     mixed $year The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterByYear($year = null, $comparison = null)
    {
        if (is_array($year)) {
            $useMinMax = false;
            if (isset($year['min'])) {
                $this->addUsingAlias(ResultFrameValuePeer::YEAR, $year['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($year['max'])) {
                $this->addUsingAlias(ResultFrameValuePeer::YEAR, $year['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameValuePeer::YEAR, $year, $comparison);
    }

    /**
     * Filter the query on the value column
     *
     * Example usage:
     * <code>
     * $query->filterByValue('fooValue');   // WHERE value = 'fooValue'
     * $query->filterByValue('%fooValue%'); // WHERE value LIKE '%fooValue%'
     * </code>
     *
     * @param     string $value The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterByValue($value = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($value)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $value)) {
                $value = str_replace('*', '%', $value);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ResultFrameValuePeer::VALUE, $value, $comparison);
    }

    /**
     * Filter the query on the goal column
     *
     * Example usage:
     * <code>
     * $query->filterByGoal('fooValue');   // WHERE goal = 'fooValue'
     * $query->filterByGoal('%fooValue%'); // WHERE goal LIKE '%fooValue%'
     * </code>
     *
     * @param     string $goal The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterByGoal($goal = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($goal)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $goal)) {
                $goal = str_replace('*', '%', $goal);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ResultFrameValuePeer::GOAL, $goal, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ResultFrameValuePeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ResultFrameValuePeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameValuePeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ResultFrameValuePeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ResultFrameValuePeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ResultFrameValuePeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related ResultFrameIndicator object
     *
     * @param   ResultFrameIndicator|PropelObjectCollection $resultFrameIndicator The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ResultFrameValueQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByResultFrameIndicator($resultFrameIndicator, $comparison = null)
    {
        if ($resultFrameIndicator instanceof ResultFrameIndicator) {
            return $this
                ->addUsingAlias(ResultFrameValuePeer::RESULTFRAMEINDICATORID, $resultFrameIndicator->getId(), $comparison);
        } elseif ($resultFrameIndicator instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ResultFrameValuePeer::RESULTFRAMEINDICATORID, $resultFrameIndicator->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByResultFrameIndicator() only accepts arguments of type ResultFrameIndicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ResultFrameIndicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function joinResultFrameIndicator($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ResultFrameIndicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ResultFrameIndicator');
        }

        return $this;
    }

    /**
     * Use the ResultFrameIndicator relation ResultFrameIndicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ResultFrameIndicatorQuery A secondary query class using the current class as primary query
     */
    public function useResultFrameIndicatorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinResultFrameIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ResultFrameIndicator', 'ResultFrameIndicatorQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ResultFrameValue $resultFrameValue Object to remove from the list of results
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function prune($resultFrameValue = null)
    {
        if ($resultFrameValue) {
            $this->addUsingAlias(ResultFrameValuePeer::ID, $resultFrameValue->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ResultFrameValueQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ResultFrameValuePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ResultFrameValuePeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ResultFrameValueQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ResultFrameValueQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ResultFrameValueQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ResultFrameValuePeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ResultFrameValuePeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
