<?php


/**
 * Base class that represents a query for the 'panel_reportSection' table.
 *
 * Seccion de reporte al BM
 *
 * @method ReportSectionQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ReportSectionQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method ReportSectionQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ReportSectionQuery orderByVersionid($order = Criteria::ASC) Order by the versionId column
 * @method ReportSectionQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method ReportSectionQuery orderByContent($order = Criteria::ASC) Order by the content column
 * @method ReportSectionQuery orderByEnviromentalsupervision($order = Criteria::ASC) Order by the enviromentalSupervision column
 * @method ReportSectionQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method ReportSectionQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 * @method ReportSectionQuery orderByCompleted($order = Criteria::ASC) Order by the completed column
 * @method ReportSectionQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ReportSectionQuery orderByTreeLeft($order = Criteria::ASC) Order by the tree_left column
 * @method ReportSectionQuery orderByTreeRight($order = Criteria::ASC) Order by the tree_right column
 * @method ReportSectionQuery orderByTreeLevel($order = Criteria::ASC) Order by the tree_level column
 * @method ReportSectionQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ReportSectionQuery groupById() Group by the id column
 * @method ReportSectionQuery groupByCode() Group by the code column
 * @method ReportSectionQuery groupByName() Group by the name column
 * @method ReportSectionQuery groupByVersionid() Group by the versionId column
 * @method ReportSectionQuery groupByType() Group by the type column
 * @method ReportSectionQuery groupByContent() Group by the content column
 * @method ReportSectionQuery groupByEnviromentalsupervision() Group by the enviromentalSupervision column
 * @method ReportSectionQuery groupByObjecttype() Group by the objectType column
 * @method ReportSectionQuery groupByObjectid() Group by the objectId column
 * @method ReportSectionQuery groupByCompleted() Group by the completed column
 * @method ReportSectionQuery groupByUpdated() Group by the updated column
 * @method ReportSectionQuery groupByTreeLeft() Group by the tree_left column
 * @method ReportSectionQuery groupByTreeRight() Group by the tree_right column
 * @method ReportSectionQuery groupByTreeLevel() Group by the tree_level column
 * @method ReportSectionQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ReportSectionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ReportSectionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ReportSectionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ReportSectionQuery leftJoinReportVersion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ReportVersion relation
 * @method ReportSectionQuery rightJoinReportVersion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ReportVersion relation
 * @method ReportSectionQuery innerJoinReportVersion($relationAlias = null) Adds a INNER JOIN clause to the query using the ReportVersion relation
 *
 * @method ReportSectionQuery leftJoinReportSectionDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the ReportSectionDocument relation
 * @method ReportSectionQuery rightJoinReportSectionDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ReportSectionDocument relation
 * @method ReportSectionQuery innerJoinReportSectionDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the ReportSectionDocument relation
 *
 * @method ReportSection findOne(PropelPDO $con = null) Return the first ReportSection matching the query
 * @method ReportSection findOneOrCreate(PropelPDO $con = null) Return the first ReportSection matching the query, or a new ReportSection object populated from the query conditions when no match is found
 *
 * @method ReportSection findOneById(int $id) Return the first ReportSection filtered by the id column
 * @method ReportSection findOneByCode(int $code) Return the first ReportSection filtered by the code column
 * @method ReportSection findOneByName(string $name) Return the first ReportSection filtered by the name column
 * @method ReportSection findOneByVersionid(int $versionId) Return the first ReportSection filtered by the versionId column
 * @method ReportSection findOneByType(int $type) Return the first ReportSection filtered by the type column
 * @method ReportSection findOneByContent(string $content) Return the first ReportSection filtered by the content column
 * @method ReportSection findOneByEnviromentalsupervision(string $enviromentalSupervision) Return the first ReportSection filtered by the enviromentalSupervision column
 * @method ReportSection findOneByObjecttype(string $objectType) Return the first ReportSection filtered by the objectType column
 * @method ReportSection findOneByObjectid(int $objectId) Return the first ReportSection filtered by the objectId column
 * @method ReportSection findOneByCompleted(boolean $completed) Return the first ReportSection filtered by the completed column
 * @method ReportSection findOneByUpdated(string $updated) Return the first ReportSection filtered by the updated column
 * @method ReportSection findOneByTreeLeft(int $tree_left) Return the first ReportSection filtered by the tree_left column
 * @method ReportSection findOneByTreeRight(int $tree_right) Return the first ReportSection filtered by the tree_right column
 * @method ReportSection findOneByTreeLevel(int $tree_level) Return the first ReportSection filtered by the tree_level column
 * @method ReportSection findOneByDeletedAt(string $deleted_at) Return the first ReportSection filtered by the deleted_at column
 *
 * @method array findById(int $id) Return ReportSection objects filtered by the id column
 * @method array findByCode(int $code) Return ReportSection objects filtered by the code column
 * @method array findByName(string $name) Return ReportSection objects filtered by the name column
 * @method array findByVersionid(int $versionId) Return ReportSection objects filtered by the versionId column
 * @method array findByType(int $type) Return ReportSection objects filtered by the type column
 * @method array findByContent(string $content) Return ReportSection objects filtered by the content column
 * @method array findByEnviromentalsupervision(string $enviromentalSupervision) Return ReportSection objects filtered by the enviromentalSupervision column
 * @method array findByObjecttype(string $objectType) Return ReportSection objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return ReportSection objects filtered by the objectId column
 * @method array findByCompleted(boolean $completed) Return ReportSection objects filtered by the completed column
 * @method array findByUpdated(string $updated) Return ReportSection objects filtered by the updated column
 * @method array findByTreeLeft(int $tree_left) Return ReportSection objects filtered by the tree_left column
 * @method array findByTreeRight(int $tree_right) Return ReportSection objects filtered by the tree_right column
 * @method array findByTreeLevel(int $tree_level) Return ReportSection objects filtered by the tree_level column
 * @method array findByDeletedAt(string $deleted_at) Return ReportSection objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseReportSectionQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseReportSectionQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ReportSection', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ReportSectionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ReportSectionQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ReportSectionQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ReportSectionQuery) {
            return $criteria;
        }
        $query = new ReportSectionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ReportSection|ReportSection[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ReportSectionPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ReportSection A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `CODE`, `NAME`, `VERSIONID`, `TYPE`, `CONTENT`, `ENVIROMENTALSUPERVISION`, `OBJECTTYPE`, `OBJECTID`, `COMPLETED`, `UPDATED`, `TREE_LEFT`, `TREE_RIGHT`, `TREE_LEVEL`, `DELETED_AT` FROM `panel_reportSection` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ReportSection();
            $obj->hydrate($row);
            ReportSectionPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ReportSection|ReportSection[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ReportSection[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ReportSectionPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ReportSectionPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ReportSectionPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode(1234); // WHERE code = 1234
     * $query->filterByCode(array(12, 34)); // WHERE code IN (12, 34)
     * $query->filterByCode(array('min' => 12)); // WHERE code > 12
     * </code>
     *
     * @param     mixed $code The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByCode($code = null, $comparison = null)
    {
        if (is_array($code)) {
            $useMinMax = false;
            if (isset($code['min'])) {
                $this->addUsingAlias(ReportSectionPeer::CODE, $code['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($code['max'])) {
                $this->addUsingAlias(ReportSectionPeer::CODE, $code['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::CODE, $code, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the versionId column
     *
     * Example usage:
     * <code>
     * $query->filterByVersionid(1234); // WHERE versionId = 1234
     * $query->filterByVersionid(array(12, 34)); // WHERE versionId IN (12, 34)
     * $query->filterByVersionid(array('min' => 12)); // WHERE versionId > 12
     * </code>
     *
     * @see       filterByReportVersion()
     *
     * @param     mixed $versionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByVersionid($versionid = null, $comparison = null)
    {
        if (is_array($versionid)) {
            $useMinMax = false;
            if (isset($versionid['min'])) {
                $this->addUsingAlias(ReportSectionPeer::VERSIONID, $versionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($versionid['max'])) {
                $this->addUsingAlias(ReportSectionPeer::VERSIONID, $versionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::VERSIONID, $versionid, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(ReportSectionPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(ReportSectionPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the content column
     *
     * Example usage:
     * <code>
     * $query->filterByContent('fooValue');   // WHERE content = 'fooValue'
     * $query->filterByContent('%fooValue%'); // WHERE content LIKE '%fooValue%'
     * </code>
     *
     * @param     string $content The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByContent($content = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($content)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $content)) {
                $content = str_replace('*', '%', $content);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::CONTENT, $content, $comparison);
    }

    /**
     * Filter the query on the enviromentalSupervision column
     *
     * Example usage:
     * <code>
     * $query->filterByEnviromentalsupervision('fooValue');   // WHERE enviromentalSupervision = 'fooValue'
     * $query->filterByEnviromentalsupervision('%fooValue%'); // WHERE enviromentalSupervision LIKE '%fooValue%'
     * </code>
     *
     * @param     string $enviromentalsupervision The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByEnviromentalsupervision($enviromentalsupervision = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($enviromentalsupervision)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $enviromentalsupervision)) {
                $enviromentalsupervision = str_replace('*', '%', $enviromentalsupervision);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::ENVIROMENTALSUPERVISION, $enviromentalsupervision, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(ReportSectionPeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(ReportSectionPeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query on the completed column
     *
     * Example usage:
     * <code>
     * $query->filterByCompleted(true); // WHERE completed = true
     * $query->filterByCompleted('yes'); // WHERE completed = true
     * </code>
     *
     * @param     boolean|string $completed The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByCompleted($completed = null, $comparison = null)
    {
        if (is_string($completed)) {
            $completed = in_array(strtolower($completed), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ReportSectionPeer::COMPLETED, $completed, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ReportSectionPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ReportSectionPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the tree_left column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLeft(1234); // WHERE tree_left = 1234
     * $query->filterByTreeLeft(array(12, 34)); // WHERE tree_left IN (12, 34)
     * $query->filterByTreeLeft(array('min' => 12)); // WHERE tree_left > 12
     * </code>
     *
     * @param     mixed $treeLeft The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByTreeLeft($treeLeft = null, $comparison = null)
    {
        if (is_array($treeLeft)) {
            $useMinMax = false;
            if (isset($treeLeft['min'])) {
                $this->addUsingAlias(ReportSectionPeer::TREE_LEFT, $treeLeft['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLeft['max'])) {
                $this->addUsingAlias(ReportSectionPeer::TREE_LEFT, $treeLeft['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::TREE_LEFT, $treeLeft, $comparison);
    }

    /**
     * Filter the query on the tree_right column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeRight(1234); // WHERE tree_right = 1234
     * $query->filterByTreeRight(array(12, 34)); // WHERE tree_right IN (12, 34)
     * $query->filterByTreeRight(array('min' => 12)); // WHERE tree_right > 12
     * </code>
     *
     * @param     mixed $treeRight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByTreeRight($treeRight = null, $comparison = null)
    {
        if (is_array($treeRight)) {
            $useMinMax = false;
            if (isset($treeRight['min'])) {
                $this->addUsingAlias(ReportSectionPeer::TREE_RIGHT, $treeRight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeRight['max'])) {
                $this->addUsingAlias(ReportSectionPeer::TREE_RIGHT, $treeRight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::TREE_RIGHT, $treeRight, $comparison);
    }

    /**
     * Filter the query on the tree_level column
     *
     * Example usage:
     * <code>
     * $query->filterByTreeLevel(1234); // WHERE tree_level = 1234
     * $query->filterByTreeLevel(array(12, 34)); // WHERE tree_level IN (12, 34)
     * $query->filterByTreeLevel(array('min' => 12)); // WHERE tree_level > 12
     * </code>
     *
     * @param     mixed $treeLevel The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByTreeLevel($treeLevel = null, $comparison = null)
    {
        if (is_array($treeLevel)) {
            $useMinMax = false;
            if (isset($treeLevel['min'])) {
                $this->addUsingAlias(ReportSectionPeer::TREE_LEVEL, $treeLevel['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($treeLevel['max'])) {
                $this->addUsingAlias(ReportSectionPeer::TREE_LEVEL, $treeLevel['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::TREE_LEVEL, $treeLevel, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ReportSectionPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ReportSectionPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ReportSectionPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related ReportVersion object
     *
     * @param   ReportVersion|PropelObjectCollection $reportVersion The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ReportSectionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByReportVersion($reportVersion, $comparison = null)
    {
        if ($reportVersion instanceof ReportVersion) {
            return $this
                ->addUsingAlias(ReportSectionPeer::VERSIONID, $reportVersion->getId(), $comparison);
        } elseif ($reportVersion instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ReportSectionPeer::VERSIONID, $reportVersion->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByReportVersion() only accepts arguments of type ReportVersion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ReportVersion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function joinReportVersion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ReportVersion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ReportVersion');
        }

        return $this;
    }

    /**
     * Use the ReportVersion relation ReportVersion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ReportVersionQuery A secondary query class using the current class as primary query
     */
    public function useReportVersionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinReportVersion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ReportVersion', 'ReportVersionQuery');
    }

    /**
     * Filter the query by a related ReportSectionDocument object
     *
     * @param   ReportSectionDocument|PropelObjectCollection $reportSectionDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ReportSectionQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByReportSectionDocument($reportSectionDocument, $comparison = null)
    {
        if ($reportSectionDocument instanceof ReportSectionDocument) {
            return $this
                ->addUsingAlias(ReportSectionPeer::ID, $reportSectionDocument->getReportsectionid(), $comparison);
        } elseif ($reportSectionDocument instanceof PropelObjectCollection) {
            return $this
                ->useReportSectionDocumentQuery()
                ->filterByPrimaryKeys($reportSectionDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByReportSectionDocument() only accepts arguments of type ReportSectionDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ReportSectionDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function joinReportSectionDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ReportSectionDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ReportSectionDocument');
        }

        return $this;
    }

    /**
     * Use the ReportSectionDocument relation ReportSectionDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ReportSectionDocumentQuery A secondary query class using the current class as primary query
     */
    public function useReportSectionDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinReportSectionDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ReportSectionDocument', 'ReportSectionDocumentQuery');
    }

    /**
     * Filter the query by a related Document object
     * using the panel_reportDocument table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ReportSectionQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useReportSectionDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ReportSection $reportSection Object to remove from the list of results
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function prune($reportSection = null)
    {
        if ($reportSection) {
            $this->addUsingAlias(ReportSectionPeer::ID, $reportSection->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ReportSectionQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ReportSectionPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ReportSectionPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ReportSectionQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // nested_set behavior

    /**
     * Filter the query to restrict the result to root objects
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function treeRoots()
    {
        return $this->addUsingAlias(ReportSectionPeer::LEFT_COL, 1, Criteria::EQUAL);
    }

    /**
     * Returns the objects in a certain tree, from the tree scope
     *
     * @param     int $scope		Scope to determine which objects node to return
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function inTree($scope = null)
    {
        return $this->addUsingAlias(ReportSectionPeer::SCOPE_COL, $scope, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to descendants of an object
     *
     * @param     ReportSection $reportSection The object to use for descendant search
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function descendantsOf($reportSection)
    {
        return $this
            ->inTree($reportSection->getScopeValue())
            ->addUsingAlias(ReportSectionPeer::LEFT_COL, $reportSection->getLeftValue(), Criteria::GREATER_THAN)
            ->addUsingAlias(ReportSectionPeer::LEFT_COL, $reportSection->getRightValue(), Criteria::LESS_THAN);
    }

    /**
     * Filter the query to restrict the result to the branch of an object.
     * Same as descendantsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     ReportSection $reportSection The object to use for branch search
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function branchOf($reportSection)
    {
        return $this
            ->inTree($reportSection->getScopeValue())
            ->addUsingAlias(ReportSectionPeer::LEFT_COL, $reportSection->getLeftValue(), Criteria::GREATER_EQUAL)
            ->addUsingAlias(ReportSectionPeer::LEFT_COL, $reportSection->getRightValue(), Criteria::LESS_EQUAL);
    }

    /**
     * Filter the query to restrict the result to children of an object
     *
     * @param     ReportSection $reportSection The object to use for child search
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function childrenOf($reportSection)
    {
        return $this
            ->descendantsOf($reportSection)
            ->addUsingAlias(ReportSectionPeer::LEVEL_COL, $reportSection->getLevel() + 1, Criteria::EQUAL);
    }

    /**
     * Filter the query to restrict the result to siblings of an object.
     * The result does not include the object passed as parameter.
     *
     * @param     ReportSection $reportSection The object to use for sibling search
     * @param      PropelPDO $con Connection to use.
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function siblingsOf($reportSection, PropelPDO $con = null)
    {
        if ($reportSection->isRoot()) {
            return $this->
                add(ReportSectionPeer::LEVEL_COL, '1<>1', Criteria::CUSTOM);
        } else {
            return $this
                ->childrenOf($reportSection->getParent($con))
                ->prune($reportSection);
        }
    }

    /**
     * Filter the query to restrict the result to ancestors of an object
     *
     * @param     ReportSection $reportSection The object to use for ancestors search
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function ancestorsOf($reportSection)
    {
        return $this
            ->inTree($reportSection->getScopeValue())
            ->addUsingAlias(ReportSectionPeer::LEFT_COL, $reportSection->getLeftValue(), Criteria::LESS_THAN)
            ->addUsingAlias(ReportSectionPeer::RIGHT_COL, $reportSection->getRightValue(), Criteria::GREATER_THAN);
    }

    /**
     * Filter the query to restrict the result to roots of an object.
     * Same as ancestorsOf(), except that it includes the object passed as parameter in the result
     *
     * @param     ReportSection $reportSection The object to use for roots search
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function rootsOf($reportSection)
    {
        return $this
            ->inTree($reportSection->getScopeValue())
            ->addUsingAlias(ReportSectionPeer::LEFT_COL, $reportSection->getLeftValue(), Criteria::LESS_EQUAL)
            ->addUsingAlias(ReportSectionPeer::RIGHT_COL, $reportSection->getRightValue(), Criteria::GREATER_EQUAL);
    }

    /**
     * Order the result by branch, i.e. natural tree order
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function orderByBranch($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addDescendingOrderByColumn(ReportSectionPeer::LEFT_COL);
        } else {
            return $this
                ->addAscendingOrderByColumn(ReportSectionPeer::LEFT_COL);
        }
    }

    /**
     * Order the result by level, the closer to the root first
     *
     * @param     bool $reverse if true, reverses the order
     *
     * @return    ReportSectionQuery The current query, for fluid interface
     */
    public function orderByLevel($reverse = false)
    {
        if ($reverse) {
            return $this
                ->addAscendingOrderByColumn(ReportSectionPeer::RIGHT_COL);
        } else {
            return $this
                ->addDescendingOrderByColumn(ReportSectionPeer::RIGHT_COL);
        }
    }

    /**
     * Returns a root node for the tree
     *
     * @param      int $scope		Scope to determine which root node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     ReportSection The tree root object
     */
    public function findRoot($scope = null, $con = null)
    {
        return $this
            ->addUsingAlias(ReportSectionPeer::LEFT_COL, 1, Criteria::EQUAL)
            ->inTree($scope)
            ->findOne($con);
    }

    /**
     * Returns the root objects for all trees.
     *
     * @param      PropelPDO $con	Connection to use.
     *
     * @return    mixed the list of results, formatted by the current formatter
     */
    public function findRoots($con = null)
    {
        return $this
            ->treeRoots()
            ->find($con);
    }

    /**
     * Returns a tree of objects
     *
     * @param      int $scope		Scope to determine which tree node to return
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     mixed the list of results, formatted by the current formatter
     */
    public function findTree($scope = null, $con = null)
    {
        return $this
            ->inTree($scope)
            ->orderByBranch()
            ->find($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ReportSectionQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ReportSectionQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ReportSectionPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ReportSectionPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
