<?php


/**
 * Base class that represents a query for the 'panel_reportDocument' table.
 *
 *
 *
 * @method ReportSectionDocumentQuery orderByReportsectionid($order = Criteria::ASC) Order by the reportSectionId column
 * @method ReportSectionDocumentQuery orderByDocumentid($order = Criteria::ASC) Order by the documentId column
 *
 * @method ReportSectionDocumentQuery groupByReportsectionid() Group by the reportSectionId column
 * @method ReportSectionDocumentQuery groupByDocumentid() Group by the documentId column
 *
 * @method ReportSectionDocumentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ReportSectionDocumentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ReportSectionDocumentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ReportSectionDocumentQuery leftJoinReportSection($relationAlias = null) Adds a LEFT JOIN clause to the query using the ReportSection relation
 * @method ReportSectionDocumentQuery rightJoinReportSection($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ReportSection relation
 * @method ReportSectionDocumentQuery innerJoinReportSection($relationAlias = null) Adds a INNER JOIN clause to the query using the ReportSection relation
 *
 * @method ReportSectionDocumentQuery leftJoinDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the Document relation
 * @method ReportSectionDocumentQuery rightJoinDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Document relation
 * @method ReportSectionDocumentQuery innerJoinDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the Document relation
 *
 * @method ReportSectionDocument findOne(PropelPDO $con = null) Return the first ReportSectionDocument matching the query
 * @method ReportSectionDocument findOneOrCreate(PropelPDO $con = null) Return the first ReportSectionDocument matching the query, or a new ReportSectionDocument object populated from the query conditions when no match is found
 *
 * @method ReportSectionDocument findOneByReportsectionid(int $reportSectionId) Return the first ReportSectionDocument filtered by the reportSectionId column
 * @method ReportSectionDocument findOneByDocumentid(int $documentId) Return the first ReportSectionDocument filtered by the documentId column
 *
 * @method array findByReportsectionid(int $reportSectionId) Return ReportSectionDocument objects filtered by the reportSectionId column
 * @method array findByDocumentid(int $documentId) Return ReportSectionDocument objects filtered by the documentId column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseReportSectionDocumentQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseReportSectionDocumentQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ReportSectionDocument', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ReportSectionDocumentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ReportSectionDocumentQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ReportSectionDocumentQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ReportSectionDocumentQuery) {
            return $criteria;
        }
        $query = new ReportSectionDocumentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$reportSectionId, $documentId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ReportSectionDocument|ReportSectionDocument[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ReportSectionDocumentPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ReportSectionDocumentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ReportSectionDocument A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `REPORTSECTIONID`, `DOCUMENTID` FROM `panel_reportDocument` WHERE `REPORTSECTIONID` = :p0 AND `DOCUMENTID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ReportSectionDocument();
            $obj->hydrate($row);
            ReportSectionDocumentPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ReportSectionDocument|ReportSectionDocument[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ReportSectionDocument[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ReportSectionDocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ReportSectionDocumentPeer::REPORTSECTIONID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ReportSectionDocumentPeer::DOCUMENTID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ReportSectionDocumentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ReportSectionDocumentPeer::REPORTSECTIONID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ReportSectionDocumentPeer::DOCUMENTID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the reportSectionId column
     *
     * Example usage:
     * <code>
     * $query->filterByReportsectionid(1234); // WHERE reportSectionId = 1234
     * $query->filterByReportsectionid(array(12, 34)); // WHERE reportSectionId IN (12, 34)
     * $query->filterByReportsectionid(array('min' => 12)); // WHERE reportSectionId > 12
     * </code>
     *
     * @see       filterByReportSection()
     *
     * @param     mixed $reportsectionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionDocumentQuery The current query, for fluid interface
     */
    public function filterByReportsectionid($reportsectionid = null, $comparison = null)
    {
        if (is_array($reportsectionid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ReportSectionDocumentPeer::REPORTSECTIONID, $reportsectionid, $comparison);
    }

    /**
     * Filter the query on the documentId column
     *
     * Example usage:
     * <code>
     * $query->filterByDocumentid(1234); // WHERE documentId = 1234
     * $query->filterByDocumentid(array(12, 34)); // WHERE documentId IN (12, 34)
     * $query->filterByDocumentid(array('min' => 12)); // WHERE documentId > 12
     * </code>
     *
     * @see       filterByDocument()
     *
     * @param     mixed $documentid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ReportSectionDocumentQuery The current query, for fluid interface
     */
    public function filterByDocumentid($documentid = null, $comparison = null)
    {
        if (is_array($documentid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ReportSectionDocumentPeer::DOCUMENTID, $documentid, $comparison);
    }

    /**
     * Filter the query by a related ReportSection object
     *
     * @param   ReportSection|PropelObjectCollection $reportSection The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ReportSectionDocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByReportSection($reportSection, $comparison = null)
    {
        if ($reportSection instanceof ReportSection) {
            return $this
                ->addUsingAlias(ReportSectionDocumentPeer::REPORTSECTIONID, $reportSection->getId(), $comparison);
        } elseif ($reportSection instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ReportSectionDocumentPeer::REPORTSECTIONID, $reportSection->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByReportSection() only accepts arguments of type ReportSection or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ReportSection relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ReportSectionDocumentQuery The current query, for fluid interface
     */
    public function joinReportSection($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ReportSection');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ReportSection');
        }

        return $this;
    }

    /**
     * Use the ReportSection relation ReportSection object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ReportSectionQuery A secondary query class using the current class as primary query
     */
    public function useReportSectionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinReportSection($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ReportSection', 'ReportSectionQuery');
    }

    /**
     * Filter the query by a related Document object
     *
     * @param   Document|PropelObjectCollection $document The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ReportSectionDocumentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByDocument($document, $comparison = null)
    {
        if ($document instanceof Document) {
            return $this
                ->addUsingAlias(ReportSectionDocumentPeer::DOCUMENTID, $document->getId(), $comparison);
        } elseif ($document instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ReportSectionDocumentPeer::DOCUMENTID, $document->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByDocument() only accepts arguments of type Document or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Document relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ReportSectionDocumentQuery The current query, for fluid interface
     */
    public function joinDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Document');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Document');
        }

        return $this;
    }

    /**
     * Use the Document relation Document object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   DocumentQuery A secondary query class using the current class as primary query
     */
    public function useDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Document', 'DocumentQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ReportSectionDocument $reportSectionDocument Object to remove from the list of results
     *
     * @return ReportSectionDocumentQuery The current query, for fluid interface
     */
    public function prune($reportSectionDocument = null)
    {
        if ($reportSectionDocument) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ReportSectionDocumentPeer::REPORTSECTIONID), $reportSectionDocument->getReportsectionid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ReportSectionDocumentPeer::DOCUMENTID), $reportSectionDocument->getDocumentid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
