<?php


/**
 * Base class that represents a query for the 'panel_missionCommitment' table.
 *
 * Base de Compromisos de Misiones
 *
 * @method MissionCommitmentQuery orderById($order = Criteria::ASC) Order by the id column
 * @method MissionCommitmentQuery orderByMissionid($order = Criteria::ASC) Order by the missionId column
 * @method MissionCommitmentQuery orderByParticipantid($order = Criteria::ASC) Order by the participantId column
 * @method MissionCommitmentQuery orderByResponsible($order = Criteria::ASC) Order by the responsible column
 * @method MissionCommitmentQuery orderByCommitment($order = Criteria::ASC) Order by the commitment column
 * @method MissionCommitmentQuery orderByAchieved($order = Criteria::ASC) Order by the achieved column
 * @method MissionCommitmentQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method MissionCommitmentQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method MissionCommitmentQuery groupById() Group by the id column
 * @method MissionCommitmentQuery groupByMissionid() Group by the missionId column
 * @method MissionCommitmentQuery groupByParticipantid() Group by the participantId column
 * @method MissionCommitmentQuery groupByResponsible() Group by the responsible column
 * @method MissionCommitmentQuery groupByCommitment() Group by the commitment column
 * @method MissionCommitmentQuery groupByAchieved() Group by the achieved column
 * @method MissionCommitmentQuery groupByDate() Group by the date column
 * @method MissionCommitmentQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method MissionCommitmentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method MissionCommitmentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method MissionCommitmentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method MissionCommitmentQuery leftJoinMission($relationAlias = null) Adds a LEFT JOIN clause to the query using the Mission relation
 * @method MissionCommitmentQuery rightJoinMission($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Mission relation
 * @method MissionCommitmentQuery innerJoinMission($relationAlias = null) Adds a INNER JOIN clause to the query using the Mission relation
 *
 * @method MissionCommitmentQuery leftJoinMissionParticipant($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionParticipant relation
 * @method MissionCommitmentQuery rightJoinMissionParticipant($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionParticipant relation
 * @method MissionCommitmentQuery innerJoinMissionParticipant($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionParticipant relation
 *
 * @method MissionCommitment findOne(PropelPDO $con = null) Return the first MissionCommitment matching the query
 * @method MissionCommitment findOneOrCreate(PropelPDO $con = null) Return the first MissionCommitment matching the query, or a new MissionCommitment object populated from the query conditions when no match is found
 *
 * @method MissionCommitment findOneById(int $id) Return the first MissionCommitment filtered by the id column
 * @method MissionCommitment findOneByMissionid(int $missionId) Return the first MissionCommitment filtered by the missionId column
 * @method MissionCommitment findOneByParticipantid(int $participantId) Return the first MissionCommitment filtered by the participantId column
 * @method MissionCommitment findOneByResponsible(string $responsible) Return the first MissionCommitment filtered by the responsible column
 * @method MissionCommitment findOneByCommitment(string $commitment) Return the first MissionCommitment filtered by the commitment column
 * @method MissionCommitment findOneByAchieved(boolean $achieved) Return the first MissionCommitment filtered by the achieved column
 * @method MissionCommitment findOneByDate(string $date) Return the first MissionCommitment filtered by the date column
 * @method MissionCommitment findOneByDeletedAt(string $deleted_at) Return the first MissionCommitment filtered by the deleted_at column
 *
 * @method array findById(int $id) Return MissionCommitment objects filtered by the id column
 * @method array findByMissionid(int $missionId) Return MissionCommitment objects filtered by the missionId column
 * @method array findByParticipantid(int $participantId) Return MissionCommitment objects filtered by the participantId column
 * @method array findByResponsible(string $responsible) Return MissionCommitment objects filtered by the responsible column
 * @method array findByCommitment(string $commitment) Return MissionCommitment objects filtered by the commitment column
 * @method array findByAchieved(boolean $achieved) Return MissionCommitment objects filtered by the achieved column
 * @method array findByDate(string $date) Return MissionCommitment objects filtered by the date column
 * @method array findByDeletedAt(string $deleted_at) Return MissionCommitment objects filtered by the deleted_at column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseMissionCommitmentQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseMissionCommitmentQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'MissionCommitment', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new MissionCommitmentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     MissionCommitmentQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return MissionCommitmentQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof MissionCommitmentQuery) {
            return $criteria;
        }
        $query = new MissionCommitmentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   MissionCommitment|MissionCommitment[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = MissionCommitmentPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(MissionCommitmentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   MissionCommitment A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `MISSIONID`, `PARTICIPANTID`, `RESPONSIBLE`, `COMMITMENT`, `ACHIEVED`, `DATE`, `DELETED_AT` FROM `panel_missionCommitment` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new MissionCommitment();
            $obj->hydrate($row);
            MissionCommitmentPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return MissionCommitment|MissionCommitment[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|MissionCommitment[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(MissionCommitmentPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(MissionCommitmentPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MissionCommitmentPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the missionId column
     *
     * Example usage:
     * <code>
     * $query->filterByMissionid(1234); // WHERE missionId = 1234
     * $query->filterByMissionid(array(12, 34)); // WHERE missionId IN (12, 34)
     * $query->filterByMissionid(array('min' => 12)); // WHERE missionId > 12
     * </code>
     *
     * @see       filterByMission()
     *
     * @param     mixed $missionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByMissionid($missionid = null, $comparison = null)
    {
        if (is_array($missionid)) {
            $useMinMax = false;
            if (isset($missionid['min'])) {
                $this->addUsingAlias(MissionCommitmentPeer::MISSIONID, $missionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($missionid['max'])) {
                $this->addUsingAlias(MissionCommitmentPeer::MISSIONID, $missionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionCommitmentPeer::MISSIONID, $missionid, $comparison);
    }

    /**
     * Filter the query on the participantId column
     *
     * Example usage:
     * <code>
     * $query->filterByParticipantid(1234); // WHERE participantId = 1234
     * $query->filterByParticipantid(array(12, 34)); // WHERE participantId IN (12, 34)
     * $query->filterByParticipantid(array('min' => 12)); // WHERE participantId > 12
     * </code>
     *
     * @see       filterByMissionParticipant()
     *
     * @param     mixed $participantid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByParticipantid($participantid = null, $comparison = null)
    {
        if (is_array($participantid)) {
            $useMinMax = false;
            if (isset($participantid['min'])) {
                $this->addUsingAlias(MissionCommitmentPeer::PARTICIPANTID, $participantid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($participantid['max'])) {
                $this->addUsingAlias(MissionCommitmentPeer::PARTICIPANTID, $participantid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionCommitmentPeer::PARTICIPANTID, $participantid, $comparison);
    }

    /**
     * Filter the query on the responsible column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsible('fooValue');   // WHERE responsible = 'fooValue'
     * $query->filterByResponsible('%fooValue%'); // WHERE responsible LIKE '%fooValue%'
     * </code>
     *
     * @param     string $responsible The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByResponsible($responsible = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($responsible)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $responsible)) {
                $responsible = str_replace('*', '%', $responsible);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MissionCommitmentPeer::RESPONSIBLE, $responsible, $comparison);
    }

    /**
     * Filter the query on the commitment column
     *
     * Example usage:
     * <code>
     * $query->filterByCommitment('fooValue');   // WHERE commitment = 'fooValue'
     * $query->filterByCommitment('%fooValue%'); // WHERE commitment LIKE '%fooValue%'
     * </code>
     *
     * @param     string $commitment The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByCommitment($commitment = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($commitment)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $commitment)) {
                $commitment = str_replace('*', '%', $commitment);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MissionCommitmentPeer::COMMITMENT, $commitment, $comparison);
    }

    /**
     * Filter the query on the achieved column
     *
     * Example usage:
     * <code>
     * $query->filterByAchieved(true); // WHERE achieved = true
     * $query->filterByAchieved('yes'); // WHERE achieved = true
     * </code>
     *
     * @param     boolean|string $achieved The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByAchieved($achieved = null, $comparison = null)
    {
        if (is_string($achieved)) {
            $achieved = in_array(strtolower($achieved), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(MissionCommitmentPeer::ACHIEVED, $achieved, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(MissionCommitmentPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(MissionCommitmentPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionCommitmentPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(MissionCommitmentPeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(MissionCommitmentPeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionCommitmentPeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related Mission object
     *
     * @param   Mission|PropelObjectCollection $mission The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionCommitmentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMission($mission, $comparison = null)
    {
        if ($mission instanceof Mission) {
            return $this
                ->addUsingAlias(MissionCommitmentPeer::MISSIONID, $mission->getId(), $comparison);
        } elseif ($mission instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionCommitmentPeer::MISSIONID, $mission->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMission() only accepts arguments of type Mission or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Mission relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function joinMission($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Mission');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Mission');
        }

        return $this;
    }

    /**
     * Use the Mission relation Mission object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionQuery A secondary query class using the current class as primary query
     */
    public function useMissionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMission($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Mission', 'MissionQuery');
    }

    /**
     * Filter the query by a related MissionParticipant object
     *
     * @param   MissionParticipant|PropelObjectCollection $missionParticipant The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionCommitmentQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionParticipant($missionParticipant, $comparison = null)
    {
        if ($missionParticipant instanceof MissionParticipant) {
            return $this
                ->addUsingAlias(MissionCommitmentPeer::PARTICIPANTID, $missionParticipant->getId(), $comparison);
        } elseif ($missionParticipant instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionCommitmentPeer::PARTICIPANTID, $missionParticipant->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMissionParticipant() only accepts arguments of type MissionParticipant or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionParticipant relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function joinMissionParticipant($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionParticipant');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionParticipant');
        }

        return $this;
    }

    /**
     * Use the MissionParticipant relation MissionParticipant object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionParticipantQuery A secondary query class using the current class as primary query
     */
    public function useMissionParticipantQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMissionParticipant($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionParticipant', 'MissionParticipantQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   MissionCommitment $missionCommitment Object to remove from the list of results
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function prune($missionCommitment = null)
    {
        if ($missionCommitment) {
            $this->addUsingAlias(MissionCommitmentPeer::ID, $missionCommitment->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (MissionCommitmentQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(MissionCommitmentPeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            MissionCommitmentPeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (MissionCommitmentQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see MissionCommitmentQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return MissionCommitmentQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return MissionCommitmentPeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return MissionCommitmentPeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
