<?php


/**
 * Base class that represents a query for the 'panel_contractorCategoryRelation' table.
 *
 * Relacion Contractistas y Categorias
 *
 * @method ContractorCategoryRelationQuery orderByContractorid($order = Criteria::ASC) Order by the contractorId column
 * @method ContractorCategoryRelationQuery orderByCategoryid($order = Criteria::ASC) Order by the categoryId column
 *
 * @method ContractorCategoryRelationQuery groupByContractorid() Group by the contractorId column
 * @method ContractorCategoryRelationQuery groupByCategoryid() Group by the categoryId column
 *
 * @method ContractorCategoryRelationQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ContractorCategoryRelationQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ContractorCategoryRelationQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ContractorCategoryRelationQuery leftJoinContractor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Contractor relation
 * @method ContractorCategoryRelationQuery rightJoinContractor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Contractor relation
 * @method ContractorCategoryRelationQuery innerJoinContractor($relationAlias = null) Adds a INNER JOIN clause to the query using the Contractor relation
 *
 * @method ContractorCategoryRelationQuery leftJoinContractorCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the ContractorCategory relation
 * @method ContractorCategoryRelationQuery rightJoinContractorCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ContractorCategory relation
 * @method ContractorCategoryRelationQuery innerJoinContractorCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the ContractorCategory relation
 *
 * @method ContractorCategoryRelation findOne(PropelPDO $con = null) Return the first ContractorCategoryRelation matching the query
 * @method ContractorCategoryRelation findOneOrCreate(PropelPDO $con = null) Return the first ContractorCategoryRelation matching the query, or a new ContractorCategoryRelation object populated from the query conditions when no match is found
 *
 * @method ContractorCategoryRelation findOneByContractorid(int $contractorId) Return the first ContractorCategoryRelation filtered by the contractorId column
 * @method ContractorCategoryRelation findOneByCategoryid(int $categoryId) Return the first ContractorCategoryRelation filtered by the categoryId column
 *
 * @method array findByContractorid(int $contractorId) Return ContractorCategoryRelation objects filtered by the contractorId column
 * @method array findByCategoryid(int $categoryId) Return ContractorCategoryRelation objects filtered by the categoryId column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseContractorCategoryRelationQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseContractorCategoryRelationQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ContractorCategoryRelation', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ContractorCategoryRelationQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ContractorCategoryRelationQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ContractorCategoryRelationQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ContractorCategoryRelationQuery) {
            return $criteria;
        }
        $query = new ContractorCategoryRelationQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$contractorId, $categoryId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ContractorCategoryRelation|ContractorCategoryRelation[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ContractorCategoryRelationPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ContractorCategoryRelationPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ContractorCategoryRelation A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `CONTRACTORID`, `CATEGORYID` FROM `panel_contractorCategoryRelation` WHERE `CONTRACTORID` = :p0 AND `CATEGORYID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ContractorCategoryRelation();
            $obj->hydrate($row);
            ContractorCategoryRelationPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ContractorCategoryRelation|ContractorCategoryRelation[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ContractorCategoryRelation[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ContractorCategoryRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ContractorCategoryRelationPeer::CONTRACTORID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ContractorCategoryRelationPeer::CATEGORYID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ContractorCategoryRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ContractorCategoryRelationPeer::CONTRACTORID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ContractorCategoryRelationPeer::CATEGORYID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the contractorId column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorid(1234); // WHERE contractorId = 1234
     * $query->filterByContractorid(array(12, 34)); // WHERE contractorId IN (12, 34)
     * $query->filterByContractorid(array('min' => 12)); // WHERE contractorId > 12
     * </code>
     *
     * @see       filterByContractor()
     *
     * @param     mixed $contractorid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorCategoryRelationQuery The current query, for fluid interface
     */
    public function filterByContractorid($contractorid = null, $comparison = null)
    {
        if (is_array($contractorid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ContractorCategoryRelationPeer::CONTRACTORID, $contractorid, $comparison);
    }

    /**
     * Filter the query on the categoryId column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryid(1234); // WHERE categoryId = 1234
     * $query->filterByCategoryid(array(12, 34)); // WHERE categoryId IN (12, 34)
     * $query->filterByCategoryid(array('min' => 12)); // WHERE categoryId > 12
     * </code>
     *
     * @see       filterByContractorCategory()
     *
     * @param     mixed $categoryid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ContractorCategoryRelationQuery The current query, for fluid interface
     */
    public function filterByCategoryid($categoryid = null, $comparison = null)
    {
        if (is_array($categoryid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ContractorCategoryRelationPeer::CATEGORYID, $categoryid, $comparison);
    }

    /**
     * Filter the query by a related Contractor object
     *
     * @param   Contractor|PropelObjectCollection $contractor The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ContractorCategoryRelationQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByContractor($contractor, $comparison = null)
    {
        if ($contractor instanceof Contractor) {
            return $this
                ->addUsingAlias(ContractorCategoryRelationPeer::CONTRACTORID, $contractor->getId(), $comparison);
        } elseif ($contractor instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ContractorCategoryRelationPeer::CONTRACTORID, $contractor->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByContractor() only accepts arguments of type Contractor or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Contractor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ContractorCategoryRelationQuery The current query, for fluid interface
     */
    public function joinContractor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Contractor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Contractor');
        }

        return $this;
    }

    /**
     * Use the Contractor relation Contractor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ContractorQuery A secondary query class using the current class as primary query
     */
    public function useContractorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContractor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Contractor', 'ContractorQuery');
    }

    /**
     * Filter the query by a related ContractorCategory object
     *
     * @param   ContractorCategory|PropelObjectCollection $contractorCategory The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ContractorCategoryRelationQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByContractorCategory($contractorCategory, $comparison = null)
    {
        if ($contractorCategory instanceof ContractorCategory) {
            return $this
                ->addUsingAlias(ContractorCategoryRelationPeer::CATEGORYID, $contractorCategory->getId(), $comparison);
        } elseif ($contractorCategory instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ContractorCategoryRelationPeer::CATEGORYID, $contractorCategory->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByContractorCategory() only accepts arguments of type ContractorCategory or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ContractorCategory relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ContractorCategoryRelationQuery The current query, for fluid interface
     */
    public function joinContractorCategory($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ContractorCategory');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ContractorCategory');
        }

        return $this;
    }

    /**
     * Use the ContractorCategory relation ContractorCategory object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ContractorCategoryQuery A secondary query class using the current class as primary query
     */
    public function useContractorCategoryQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContractorCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ContractorCategory', 'ContractorCategoryQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ContractorCategoryRelation $contractorCategoryRelation Object to remove from the list of results
     *
     * @return ContractorCategoryRelationQuery The current query, for fluid interface
     */
    public function prune($contractorCategoryRelation = null)
    {
        if ($contractorCategoryRelation) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ContractorCategoryRelationPeer::CONTRACTORID), $contractorCategoryRelation->getContractorid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ContractorCategoryRelationPeer::CATEGORYID), $contractorCategoryRelation->getCategoryid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
