<?php


/**
 * Base class that represents a row from the 'objectives_strategicLog' table.
 *
 * Strategic Objective Log
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BaseStrategicObjectiveLog extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'StrategicObjectiveLogPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        StrategicObjectiveLogPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the strategicid field.
     * @var        int
     */
    protected $strategicid;

    /**
     * The value for the policyguidelineid field.
     * @var        int
     */
    protected $policyguidelineid;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the exchangerate field.
     * @var        double
     */
    protected $exchangerate;

    /**
     * The value for the userid field.
     * @var        int
     */
    protected $userid;

    /**
     * The value for the affiliateid field.
     * @var        int
     */
    protected $affiliateid;

    /**
     * The value for the userbyaffiliatesid field.
     * @var        int
     */
    protected $userbyaffiliatesid;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the oldid field.
     * @var        int
     */
    protected $oldid;

    /**
     * The value for the changes field.
     * @var        int
     */
    protected $changes;

    /**
     * The value for the startingyear field.
     * @var        int
     */
    protected $startingyear;

    /**
     * The value for the endingyear field.
     * @var        int
     */
    protected $endingyear;

    /**
     * @var        StrategicObjective
     */
    protected $aStrategicObjective;

    /**
     * @var        PolicyGuideline
     */
    protected $aPolicyGuideline;

    /**
     * @var        User
     */
    protected $aUser;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Get the [id] column value.
     * Objective Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [strategicid] column value.
     * Strategic Objective Id
     * @return int
     */
    public function getStrategicid()
    {
        return $this->strategicid;
    }

    /**
     * Get the [policyguidelineid] column value.
     * Policy Guideline Id
     * @return int
     */
    public function getPolicyguidelineid()
    {
        return $this->policyguidelineid;
    }

    /**
     * Get the [name] column value.
     * Objective Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [description] column value.
     * Objective Description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [exchangerate] column value.
     * Exchange Rate
     * @return double
     */
    public function getExchangerate()
    {
        return $this->exchangerate;
    }

    /**
     * Get the [userid] column value.
     * User Id
     * @return int
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Get the [affiliateid] column value.
     * Affiliate Id
     * @return int
     */
    public function getAffiliateid()
    {
        return $this->affiliateid;
    }

    /**
     * Get the [userbyaffiliatesid] column value.
     * UserByAffiliates Id
     * @return int
     */
    public function getUserbyaffiliatesid()
    {
        return $this->userbyaffiliatesid;
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Updated
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [oldid] column value.
     * Old Id
     * @return int
     */
    public function getOldid()
    {
        return $this->oldid;
    }

    /**
     * Get the [changes] column value.
     * Cantidad de modificaciones
     * @return int
     */
    public function getChanges()
    {
        return $this->changes;
    }

    /**
     * Get the [startingyear] column value.
     * Starting year
     * @return int
     */
    public function getStartingyear()
    {
        return $this->startingyear;
    }

    /**
     * Get the [endingyear] column value.
     * Ending year
     * @return int
     */
    public function getEndingyear()
    {
        return $this->endingyear;
    }

    /**
     * Set the value of [id] column.
     * Objective Id
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [strategicid] column.
     * Strategic Objective Id
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setStrategicid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->strategicid !== $v) {
            $this->strategicid = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::STRATEGICID;
        }

        if ($this->aStrategicObjective !== null && $this->aStrategicObjective->getId() !== $v) {
            $this->aStrategicObjective = null;
        }


        return $this;
    } // setStrategicid()

    /**
     * Set the value of [policyguidelineid] column.
     * Policy Guideline Id
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setPolicyguidelineid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->policyguidelineid !== $v) {
            $this->policyguidelineid = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::POLICYGUIDELINEID;
        }

        if ($this->aPolicyGuideline !== null && $this->aPolicyGuideline->getId() !== $v) {
            $this->aPolicyGuideline = null;
        }


        return $this;
    } // setPolicyguidelineid()

    /**
     * Set the value of [name] column.
     * Objective Name
     * @param string $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [description] column.
     * Objective Description
     * @param string $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [exchangerate] column.
     * Exchange Rate
     * @param double $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setExchangerate($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->exchangerate !== $v) {
            $this->exchangerate = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::EXCHANGERATE;
        }


        return $this;
    } // setExchangerate()

    /**
     * Set the value of [userid] column.
     * User Id
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setUserid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userid !== $v) {
            $this->userid = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::USERID;
        }

        if ($this->aUser !== null && $this->aUser->getId() !== $v) {
            $this->aUser = null;
        }


        return $this;
    } // setUserid()

    /**
     * Set the value of [affiliateid] column.
     * Affiliate Id
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setAffiliateid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->affiliateid !== $v) {
            $this->affiliateid = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::AFFILIATEID;
        }


        return $this;
    } // setAffiliateid()

    /**
     * Set the value of [userbyaffiliatesid] column.
     * UserByAffiliates Id
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setUserbyaffiliatesid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userbyaffiliatesid !== $v) {
            $this->userbyaffiliatesid = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::USERBYAFFILIATESID;
        }


        return $this;
    } // setUserbyaffiliatesid()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Updated
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = StrategicObjectiveLogPeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Set the value of [oldid] column.
     * Old Id
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setOldid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->oldid !== $v) {
            $this->oldid = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::OLDID;
        }


        return $this;
    } // setOldid()

    /**
     * Set the value of [changes] column.
     * Cantidad de modificaciones
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setChanges($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->changes !== $v) {
            $this->changes = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::CHANGES;
        }


        return $this;
    } // setChanges()

    /**
     * Set the value of [startingyear] column.
     * Starting year
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setStartingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->startingyear !== $v) {
            $this->startingyear = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::STARTINGYEAR;
        }


        return $this;
    } // setStartingyear()

    /**
     * Set the value of [endingyear] column.
     * Ending year
     * @param int $v new value
     * @return StrategicObjectiveLog The current object (for fluent API support)
     */
    public function setEndingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->endingyear !== $v) {
            $this->endingyear = $v;
            $this->modifiedColumns[] = StrategicObjectiveLogPeer::ENDINGYEAR;
        }


        return $this;
    } // setEndingyear()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->strategicid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->policyguidelineid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->name = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->description = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->exchangerate = ($row[$startcol + 5] !== null) ? (double) $row[$startcol + 5] : null;
            $this->userid = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
            $this->affiliateid = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
            $this->userbyaffiliatesid = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->updated = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->oldid = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->changes = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->startingyear = ($row[$startcol + 12] !== null) ? (int) $row[$startcol + 12] : null;
            $this->endingyear = ($row[$startcol + 13] !== null) ? (int) $row[$startcol + 13] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 14; // 14 = StrategicObjectiveLogPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating StrategicObjectiveLog object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aStrategicObjective !== null && $this->strategicid !== $this->aStrategicObjective->getId()) {
            $this->aStrategicObjective = null;
        }
        if ($this->aPolicyGuideline !== null && $this->policyguidelineid !== $this->aPolicyGuideline->getId()) {
            $this->aPolicyGuideline = null;
        }
        if ($this->aUser !== null && $this->userid !== $this->aUser->getId()) {
            $this->aUser = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(StrategicObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = StrategicObjectiveLogPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aStrategicObjective = null;
            $this->aPolicyGuideline = null;
            $this->aUser = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(StrategicObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = StrategicObjectiveLogQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(StrategicObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                StrategicObjectiveLogPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aStrategicObjective !== null) {
                if ($this->aStrategicObjective->isModified() || $this->aStrategicObjective->isNew()) {
                    $affectedRows += $this->aStrategicObjective->save($con);
                }
                $this->setStrategicObjective($this->aStrategicObjective);
            }

            if ($this->aPolicyGuideline !== null) {
                if ($this->aPolicyGuideline->isModified() || $this->aPolicyGuideline->isNew()) {
                    $affectedRows += $this->aPolicyGuideline->save($con);
                }
                $this->setPolicyGuideline($this->aPolicyGuideline);
            }

            if ($this->aUser !== null) {
                if ($this->aUser->isModified() || $this->aUser->isNew()) {
                    $affectedRows += $this->aUser->save($con);
                }
                $this->setUser($this->aUser);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = StrategicObjectiveLogPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . StrategicObjectiveLogPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(StrategicObjectiveLogPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::STRATEGICID)) {
            $modifiedColumns[':p' . $index++]  = '`STRATEGICID`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::POLICYGUIDELINEID)) {
            $modifiedColumns[':p' . $index++]  = '`POLICYGUIDELINEID`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::EXCHANGERATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXCHANGERATE`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::USERID)) {
            $modifiedColumns[':p' . $index++]  = '`USERID`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::AFFILIATEID)) {
            $modifiedColumns[':p' . $index++]  = '`AFFILIATEID`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::USERBYAFFILIATESID)) {
            $modifiedColumns[':p' . $index++]  = '`USERBYAFFILIATESID`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::OLDID)) {
            $modifiedColumns[':p' . $index++]  = '`OLDID`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::CHANGES)) {
            $modifiedColumns[':p' . $index++]  = '`CHANGES`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::STARTINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`STARTINGYEAR`';
        }
        if ($this->isColumnModified(StrategicObjectiveLogPeer::ENDINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`ENDINGYEAR`';
        }

        $sql = sprintf(
            'INSERT INTO `objectives_strategicLog` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`STRATEGICID`':
                        $stmt->bindValue($identifier, $this->strategicid, PDO::PARAM_INT);
                        break;
                    case '`POLICYGUIDELINEID`':
                        $stmt->bindValue($identifier, $this->policyguidelineid, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`EXCHANGERATE`':
                        $stmt->bindValue($identifier, $this->exchangerate, PDO::PARAM_STR);
                        break;
                    case '`USERID`':
                        $stmt->bindValue($identifier, $this->userid, PDO::PARAM_INT);
                        break;
                    case '`AFFILIATEID`':
                        $stmt->bindValue($identifier, $this->affiliateid, PDO::PARAM_INT);
                        break;
                    case '`USERBYAFFILIATESID`':
                        $stmt->bindValue($identifier, $this->userbyaffiliatesid, PDO::PARAM_INT);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`OLDID`':
                        $stmt->bindValue($identifier, $this->oldid, PDO::PARAM_INT);
                        break;
                    case '`CHANGES`':
                        $stmt->bindValue($identifier, $this->changes, PDO::PARAM_INT);
                        break;
                    case '`STARTINGYEAR`':
                        $stmt->bindValue($identifier, $this->startingyear, PDO::PARAM_INT);
                        break;
                    case '`ENDINGYEAR`':
                        $stmt->bindValue($identifier, $this->endingyear, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aStrategicObjective !== null) {
                if (!$this->aStrategicObjective->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aStrategicObjective->getValidationFailures());
                }
            }

            if ($this->aPolicyGuideline !== null) {
                if (!$this->aPolicyGuideline->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPolicyGuideline->getValidationFailures());
                }
            }

            if ($this->aUser !== null) {
                if (!$this->aUser->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aUser->getValidationFailures());
                }
            }


            if (($retval = StrategicObjectiveLogPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }



            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = StrategicObjectiveLogPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getStrategicid();
                break;
            case 2:
                return $this->getPolicyguidelineid();
                break;
            case 3:
                return $this->getName();
                break;
            case 4:
                return $this->getDescription();
                break;
            case 5:
                return $this->getExchangerate();
                break;
            case 6:
                return $this->getUserid();
                break;
            case 7:
                return $this->getAffiliateid();
                break;
            case 8:
                return $this->getUserbyaffiliatesid();
                break;
            case 9:
                return $this->getUpdated();
                break;
            case 10:
                return $this->getOldid();
                break;
            case 11:
                return $this->getChanges();
                break;
            case 12:
                return $this->getStartingyear();
                break;
            case 13:
                return $this->getEndingyear();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['StrategicObjectiveLog'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['StrategicObjectiveLog'][$this->getPrimaryKey()] = true;
        $keys = StrategicObjectiveLogPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getStrategicid(),
            $keys[2] => $this->getPolicyguidelineid(),
            $keys[3] => $this->getName(),
            $keys[4] => $this->getDescription(),
            $keys[5] => $this->getExchangerate(),
            $keys[6] => $this->getUserid(),
            $keys[7] => $this->getAffiliateid(),
            $keys[8] => $this->getUserbyaffiliatesid(),
            $keys[9] => $this->getUpdated(),
            $keys[10] => $this->getOldid(),
            $keys[11] => $this->getChanges(),
            $keys[12] => $this->getStartingyear(),
            $keys[13] => $this->getEndingyear(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aStrategicObjective) {
                $result['StrategicObjective'] = $this->aStrategicObjective->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPolicyGuideline) {
                $result['PolicyGuideline'] = $this->aPolicyGuideline->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aUser) {
                $result['User'] = $this->aUser->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = StrategicObjectiveLogPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setStrategicid($value);
                break;
            case 2:
                $this->setPolicyguidelineid($value);
                break;
            case 3:
                $this->setName($value);
                break;
            case 4:
                $this->setDescription($value);
                break;
            case 5:
                $this->setExchangerate($value);
                break;
            case 6:
                $this->setUserid($value);
                break;
            case 7:
                $this->setAffiliateid($value);
                break;
            case 8:
                $this->setUserbyaffiliatesid($value);
                break;
            case 9:
                $this->setUpdated($value);
                break;
            case 10:
                $this->setOldid($value);
                break;
            case 11:
                $this->setChanges($value);
                break;
            case 12:
                $this->setStartingyear($value);
                break;
            case 13:
                $this->setEndingyear($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = StrategicObjectiveLogPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setStrategicid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setPolicyguidelineid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setName($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setDescription($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setExchangerate($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setUserid($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setAffiliateid($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setUserbyaffiliatesid($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setUpdated($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setOldid($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setChanges($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setStartingyear($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setEndingyear($arr[$keys[13]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(StrategicObjectiveLogPeer::DATABASE_NAME);

        if ($this->isColumnModified(StrategicObjectiveLogPeer::ID)) $criteria->add(StrategicObjectiveLogPeer::ID, $this->id);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::STRATEGICID)) $criteria->add(StrategicObjectiveLogPeer::STRATEGICID, $this->strategicid);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::POLICYGUIDELINEID)) $criteria->add(StrategicObjectiveLogPeer::POLICYGUIDELINEID, $this->policyguidelineid);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::NAME)) $criteria->add(StrategicObjectiveLogPeer::NAME, $this->name);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::DESCRIPTION)) $criteria->add(StrategicObjectiveLogPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::EXCHANGERATE)) $criteria->add(StrategicObjectiveLogPeer::EXCHANGERATE, $this->exchangerate);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::USERID)) $criteria->add(StrategicObjectiveLogPeer::USERID, $this->userid);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::AFFILIATEID)) $criteria->add(StrategicObjectiveLogPeer::AFFILIATEID, $this->affiliateid);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::USERBYAFFILIATESID)) $criteria->add(StrategicObjectiveLogPeer::USERBYAFFILIATESID, $this->userbyaffiliatesid);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::UPDATED)) $criteria->add(StrategicObjectiveLogPeer::UPDATED, $this->updated);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::OLDID)) $criteria->add(StrategicObjectiveLogPeer::OLDID, $this->oldid);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::CHANGES)) $criteria->add(StrategicObjectiveLogPeer::CHANGES, $this->changes);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::STARTINGYEAR)) $criteria->add(StrategicObjectiveLogPeer::STARTINGYEAR, $this->startingyear);
        if ($this->isColumnModified(StrategicObjectiveLogPeer::ENDINGYEAR)) $criteria->add(StrategicObjectiveLogPeer::ENDINGYEAR, $this->endingyear);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(StrategicObjectiveLogPeer::DATABASE_NAME);
        $criteria->add(StrategicObjectiveLogPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of StrategicObjectiveLog (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setStrategicid($this->getStrategicid());
        $copyObj->setPolicyguidelineid($this->getPolicyguidelineid());
        $copyObj->setName($this->getName());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setExchangerate($this->getExchangerate());
        $copyObj->setUserid($this->getUserid());
        $copyObj->setAffiliateid($this->getAffiliateid());
        $copyObj->setUserbyaffiliatesid($this->getUserbyaffiliatesid());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setOldid($this->getOldid());
        $copyObj->setChanges($this->getChanges());
        $copyObj->setStartingyear($this->getStartingyear());
        $copyObj->setEndingyear($this->getEndingyear());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return StrategicObjectiveLog Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return StrategicObjectiveLogPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new StrategicObjectiveLogPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a StrategicObjective object.
     *
     * @param             StrategicObjective $v
     * @return StrategicObjectiveLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setStrategicObjective(StrategicObjective $v = null)
    {
        if ($v === null) {
            $this->setStrategicid(NULL);
        } else {
            $this->setStrategicid($v->getId());
        }

        $this->aStrategicObjective = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the StrategicObjective object, it will not be re-added.
        if ($v !== null) {
            $v->addStrategicObjectiveLog($this);
        }


        return $this;
    }


    /**
     * Get the associated StrategicObjective object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return StrategicObjective The associated StrategicObjective object.
     * @throws PropelException
     */
    public function getStrategicObjective(PropelPDO $con = null)
    {
        if ($this->aStrategicObjective === null && ($this->strategicid !== null)) {
            $this->aStrategicObjective = StrategicObjectiveQuery::create()->findPk($this->strategicid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aStrategicObjective->addStrategicObjectiveLogs($this);
             */
        }

        return $this->aStrategicObjective;
    }

    /**
     * Declares an association between this object and a PolicyGuideline object.
     *
     * @param             PolicyGuideline $v
     * @return StrategicObjectiveLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPolicyGuideline(PolicyGuideline $v = null)
    {
        if ($v === null) {
            $this->setPolicyguidelineid(NULL);
        } else {
            $this->setPolicyguidelineid($v->getId());
        }

        $this->aPolicyGuideline = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the PolicyGuideline object, it will not be re-added.
        if ($v !== null) {
            $v->addStrategicObjectiveLog($this);
        }


        return $this;
    }


    /**
     * Get the associated PolicyGuideline object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return PolicyGuideline The associated PolicyGuideline object.
     * @throws PropelException
     */
    public function getPolicyGuideline(PropelPDO $con = null)
    {
        if ($this->aPolicyGuideline === null && ($this->policyguidelineid !== null)) {
            $this->aPolicyGuideline = PolicyGuidelineQuery::create()->findPk($this->policyguidelineid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPolicyGuideline->addStrategicObjectiveLogs($this);
             */
        }

        return $this->aPolicyGuideline;
    }

    /**
     * Declares an association between this object and a User object.
     *
     * @param             User $v
     * @return StrategicObjectiveLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setUser(User $v = null)
    {
        if ($v === null) {
            $this->setUserid(NULL);
        } else {
            $this->setUserid($v->getId());
        }

        $this->aUser = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the User object, it will not be re-added.
        if ($v !== null) {
            $v->addStrategicObjectiveLog($this);
        }


        return $this;
    }


    /**
     * Get the associated User object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return User The associated User object.
     * @throws PropelException
     */
    public function getUser(PropelPDO $con = null)
    {
        if ($this->aUser === null && ($this->userid !== null)) {
            $this->aUser = UserQuery::create()->findPk($this->userid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aUser->addStrategicObjectiveLogs($this);
             */
        }

        return $this->aUser;
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->strategicid = null;
        $this->policyguidelineid = null;
        $this->name = null;
        $this->description = null;
        $this->exchangerate = null;
        $this->userid = null;
        $this->affiliateid = null;
        $this->userbyaffiliatesid = null;
        $this->updated = null;
        $this->oldid = null;
        $this->changes = null;
        $this->startingyear = null;
        $this->endingyear = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aStrategicObjective = null;
        $this->aPolicyGuideline = null;
        $this->aUser = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
