<?php


/**
 * Base static class for performing query and update operations on the 'objectives_objective' table.
 *
 * Objective
 *
 * @package propel.generator.objectives.classes.om
 */
abstract class BaseObjectivePeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'objectives_objective';

    /** the related Propel class for this table */
    const OM_CLASS = 'Objective';

    /** the related TableMap class for this table */
    const TM_CLASS = 'ObjectiveTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 19;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 19;

    /** the column name for the ID field */
    const ID = 'objectives_objective.ID';

    /** the column name for the NAME field */
    const NAME = 'objectives_objective.NAME';

    /** the column name for the POLICYGUIDELINEID field */
    const POLICYGUIDELINEID = 'objectives_objective.POLICYGUIDELINEID';

    /** the column name for the STRATEGICOBJECTIVEID field */
    const STRATEGICOBJECTIVEID = 'objectives_objective.STRATEGICOBJECTIVEID';

    /** the column name for the AFFILIATEID field */
    const AFFILIATEID = 'objectives_objective.AFFILIATEID';

    /** the column name for the DESCRIPTION field */
    const DESCRIPTION = 'objectives_objective.DESCRIPTION';

    /** the column name for the DATE field */
    const DATE = 'objectives_objective.DATE';

    /** the column name for the EXPIRATIONDATE field */
    const EXPIRATIONDATE = 'objectives_objective.EXPIRATIONDATE';

    /** the column name for the ACHIEVED field */
    const ACHIEVED = 'objectives_objective.ACHIEVED';

    /** the column name for the NOTES field */
    const NOTES = 'objectives_objective.NOTES';

    /** the column name for the RESPONSIBLECODE field */
    const RESPONSIBLECODE = 'objectives_objective.RESPONSIBLECODE';

    /** the column name for the USERID field */
    const USERID = 'objectives_objective.USERID';

    /** the column name for the USERBYAFFILIATESID field */
    const USERBYAFFILIATESID = 'objectives_objective.USERBYAFFILIATESID';

    /** the column name for the UPDATED field */
    const UPDATED = 'objectives_objective.UPDATED';

    /** the column name for the CHANGES field */
    const CHANGES = 'objectives_objective.CHANGES';

    /** the column name for the OLDID field */
    const OLDID = 'objectives_objective.OLDID';

    /** the column name for the STARTINGYEAR field */
    const STARTINGYEAR = 'objectives_objective.STARTINGYEAR';

    /** the column name for the ENDINGYEAR field */
    const ENDINGYEAR = 'objectives_objective.ENDINGYEAR';

    /** the column name for the DELETED_AT field */
    const DELETED_AT = 'objectives_objective.DELETED_AT';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of Objective objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array Objective[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. ObjectivePeer::$fieldNames[ObjectivePeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Name', 'Policyguidelineid', 'Strategicobjectiveid', 'Affiliateid', 'Description', 'Date', 'Expirationdate', 'Achieved', 'Notes', 'Responsiblecode', 'Userid', 'Userbyaffiliatesid', 'Updated', 'Changes', 'Oldid', 'Startingyear', 'Endingyear', 'DeletedAt', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'name', 'policyguidelineid', 'strategicobjectiveid', 'affiliateid', 'description', 'date', 'expirationdate', 'achieved', 'notes', 'responsiblecode', 'userid', 'userbyaffiliatesid', 'updated', 'changes', 'oldid', 'startingyear', 'endingyear', 'deletedAt', ),
        BasePeer::TYPE_COLNAME => array (ObjectivePeer::ID, ObjectivePeer::NAME, ObjectivePeer::POLICYGUIDELINEID, ObjectivePeer::STRATEGICOBJECTIVEID, ObjectivePeer::AFFILIATEID, ObjectivePeer::DESCRIPTION, ObjectivePeer::DATE, ObjectivePeer::EXPIRATIONDATE, ObjectivePeer::ACHIEVED, ObjectivePeer::NOTES, ObjectivePeer::RESPONSIBLECODE, ObjectivePeer::USERID, ObjectivePeer::USERBYAFFILIATESID, ObjectivePeer::UPDATED, ObjectivePeer::CHANGES, ObjectivePeer::OLDID, ObjectivePeer::STARTINGYEAR, ObjectivePeer::ENDINGYEAR, ObjectivePeer::DELETED_AT, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'NAME', 'POLICYGUIDELINEID', 'STRATEGICOBJECTIVEID', 'AFFILIATEID', 'DESCRIPTION', 'DATE', 'EXPIRATIONDATE', 'ACHIEVED', 'NOTES', 'RESPONSIBLECODE', 'USERID', 'USERBYAFFILIATESID', 'UPDATED', 'CHANGES', 'OLDID', 'STARTINGYEAR', 'ENDINGYEAR', 'DELETED_AT', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'name', 'policyGuidelineId', 'strategicObjectiveId', 'affiliateId', 'description', 'date', 'expirationDate', 'achieved', 'notes', 'responsibleCode', 'userId', 'userByAffiliatesId', 'updated', 'changes', 'oldId', 'startingYear', 'endingYear', 'deleted_at', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. ObjectivePeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Name' => 1, 'Policyguidelineid' => 2, 'Strategicobjectiveid' => 3, 'Affiliateid' => 4, 'Description' => 5, 'Date' => 6, 'Expirationdate' => 7, 'Achieved' => 8, 'Notes' => 9, 'Responsiblecode' => 10, 'Userid' => 11, 'Userbyaffiliatesid' => 12, 'Updated' => 13, 'Changes' => 14, 'Oldid' => 15, 'Startingyear' => 16, 'Endingyear' => 17, 'DeletedAt' => 18, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'name' => 1, 'policyguidelineid' => 2, 'strategicobjectiveid' => 3, 'affiliateid' => 4, 'description' => 5, 'date' => 6, 'expirationdate' => 7, 'achieved' => 8, 'notes' => 9, 'responsiblecode' => 10, 'userid' => 11, 'userbyaffiliatesid' => 12, 'updated' => 13, 'changes' => 14, 'oldid' => 15, 'startingyear' => 16, 'endingyear' => 17, 'deletedAt' => 18, ),
        BasePeer::TYPE_COLNAME => array (ObjectivePeer::ID => 0, ObjectivePeer::NAME => 1, ObjectivePeer::POLICYGUIDELINEID => 2, ObjectivePeer::STRATEGICOBJECTIVEID => 3, ObjectivePeer::AFFILIATEID => 4, ObjectivePeer::DESCRIPTION => 5, ObjectivePeer::DATE => 6, ObjectivePeer::EXPIRATIONDATE => 7, ObjectivePeer::ACHIEVED => 8, ObjectivePeer::NOTES => 9, ObjectivePeer::RESPONSIBLECODE => 10, ObjectivePeer::USERID => 11, ObjectivePeer::USERBYAFFILIATESID => 12, ObjectivePeer::UPDATED => 13, ObjectivePeer::CHANGES => 14, ObjectivePeer::OLDID => 15, ObjectivePeer::STARTINGYEAR => 16, ObjectivePeer::ENDINGYEAR => 17, ObjectivePeer::DELETED_AT => 18, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'NAME' => 1, 'POLICYGUIDELINEID' => 2, 'STRATEGICOBJECTIVEID' => 3, 'AFFILIATEID' => 4, 'DESCRIPTION' => 5, 'DATE' => 6, 'EXPIRATIONDATE' => 7, 'ACHIEVED' => 8, 'NOTES' => 9, 'RESPONSIBLECODE' => 10, 'USERID' => 11, 'USERBYAFFILIATESID' => 12, 'UPDATED' => 13, 'CHANGES' => 14, 'OLDID' => 15, 'STARTINGYEAR' => 16, 'ENDINGYEAR' => 17, 'DELETED_AT' => 18, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'name' => 1, 'policyGuidelineId' => 2, 'strategicObjectiveId' => 3, 'affiliateId' => 4, 'description' => 5, 'date' => 6, 'expirationDate' => 7, 'achieved' => 8, 'notes' => 9, 'responsibleCode' => 10, 'userId' => 11, 'userByAffiliatesId' => 12, 'updated' => 13, 'changes' => 14, 'oldId' => 15, 'startingYear' => 16, 'endingYear' => 17, 'deleted_at' => 18, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = ObjectivePeer::getFieldNames($toType);
        $key = isset(ObjectivePeer::$fieldKeys[$fromType][$name]) ? ObjectivePeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(ObjectivePeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, ObjectivePeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return ObjectivePeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. ObjectivePeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(ObjectivePeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ObjectivePeer::ID);
            $criteria->addSelectColumn(ObjectivePeer::NAME);
            $criteria->addSelectColumn(ObjectivePeer::POLICYGUIDELINEID);
            $criteria->addSelectColumn(ObjectivePeer::STRATEGICOBJECTIVEID);
            $criteria->addSelectColumn(ObjectivePeer::AFFILIATEID);
            $criteria->addSelectColumn(ObjectivePeer::DESCRIPTION);
            $criteria->addSelectColumn(ObjectivePeer::DATE);
            $criteria->addSelectColumn(ObjectivePeer::EXPIRATIONDATE);
            $criteria->addSelectColumn(ObjectivePeer::ACHIEVED);
            $criteria->addSelectColumn(ObjectivePeer::NOTES);
            $criteria->addSelectColumn(ObjectivePeer::RESPONSIBLECODE);
            $criteria->addSelectColumn(ObjectivePeer::USERID);
            $criteria->addSelectColumn(ObjectivePeer::USERBYAFFILIATESID);
            $criteria->addSelectColumn(ObjectivePeer::UPDATED);
            $criteria->addSelectColumn(ObjectivePeer::CHANGES);
            $criteria->addSelectColumn(ObjectivePeer::OLDID);
            $criteria->addSelectColumn(ObjectivePeer::STARTINGYEAR);
            $criteria->addSelectColumn(ObjectivePeer::ENDINGYEAR);
            $criteria->addSelectColumn(ObjectivePeer::DELETED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.POLICYGUIDELINEID');
            $criteria->addSelectColumn($alias . '.STRATEGICOBJECTIVEID');
            $criteria->addSelectColumn($alias . '.AFFILIATEID');
            $criteria->addSelectColumn($alias . '.DESCRIPTION');
            $criteria->addSelectColumn($alias . '.DATE');
            $criteria->addSelectColumn($alias . '.EXPIRATIONDATE');
            $criteria->addSelectColumn($alias . '.ACHIEVED');
            $criteria->addSelectColumn($alias . '.NOTES');
            $criteria->addSelectColumn($alias . '.RESPONSIBLECODE');
            $criteria->addSelectColumn($alias . '.USERID');
            $criteria->addSelectColumn($alias . '.USERBYAFFILIATESID');
            $criteria->addSelectColumn($alias . '.UPDATED');
            $criteria->addSelectColumn($alias . '.CHANGES');
            $criteria->addSelectColumn($alias . '.OLDID');
            $criteria->addSelectColumn($alias . '.STARTINGYEAR');
            $criteria->addSelectColumn($alias . '.ENDINGYEAR');
            $criteria->addSelectColumn($alias . '.DELETED_AT');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 Objective
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = ObjectivePeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return ObjectivePeer::populateObjects(ObjectivePeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            ObjectivePeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      Objective $obj A Objective object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            ObjectivePeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A Objective object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof Objective) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or Objective object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(ObjectivePeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   Objective Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(ObjectivePeer::$instances[$key])) {
                return ObjectivePeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        ObjectivePeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to objectives_objective
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in IndicatorPeer instance pool,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        IndicatorPeer::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = ObjectivePeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = ObjectivePeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ObjectivePeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (Objective object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = ObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = ObjectivePeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + ObjectivePeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ObjectivePeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            ObjectivePeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related StrategicObjective table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinStrategicObjective(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related PolicyGuideline table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinPolicyGuideline(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Objective objects pre-filled with their StrategicObjective objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinStrategicObjective(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol = ObjectivePeer::NUM_HYDRATE_COLUMNS;
        StrategicObjectivePeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Objective) to $obj2 (StrategicObjective)
                $obj2->addObjective($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Objective objects pre-filled with their PolicyGuideline objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinPolicyGuideline(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol = ObjectivePeer::NUM_HYDRATE_COLUMNS;
        PolicyGuidelinePeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = PolicyGuidelinePeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PolicyGuidelinePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    PolicyGuidelinePeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Objective) to $obj2 (PolicyGuideline)
                $obj2->addObjective($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Objective objects pre-filled with their User objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol = ObjectivePeer::NUM_HYDRATE_COLUMNS;
        UserPeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = UserPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = UserPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    UserPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Objective) to $obj2 (User)
                $obj2->addObjective($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Objective objects pre-filled with their Position objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol = ObjectivePeer::NUM_HYDRATE_COLUMNS;
        PositionPeer::addSelectColumns($criteria);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = PositionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PositionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    PositionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (Objective) to $obj2 (Position)
                $obj2->addObjective($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of Objective objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol2 = ObjectivePeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol6 = $startcol5 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined StrategicObjective rows

            $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (Objective) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjective($obj1);
            } // if joined row not null

            // Add objects for joined PolicyGuideline rows

            $key3 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol3);
            if ($key3 !== null) {
                $obj3 = PolicyGuidelinePeer::getInstanceFromPool($key3);
                if (!$obj3) {

                    $cls = PolicyGuidelinePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    PolicyGuidelinePeer::addInstanceToPool($obj3, $key3);
                } // if obj3 loaded

                // Add the $obj1 (Objective) to the collection in $obj3 (PolicyGuideline)
                $obj3->addObjective($obj1);
            } // if joined row not null

            // Add objects for joined User rows

            $key4 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol4);
            if ($key4 !== null) {
                $obj4 = UserPeer::getInstanceFromPool($key4);
                if (!$obj4) {

                    $cls = UserPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    UserPeer::addInstanceToPool($obj4, $key4);
                } // if obj4 loaded

                // Add the $obj1 (Objective) to the collection in $obj4 (User)
                $obj4->addObjective($obj1);
            } // if joined row not null

            // Add objects for joined Position rows

            $key5 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol5);
            if ($key5 !== null) {
                $obj5 = PositionPeer::getInstanceFromPool($key5);
                if (!$obj5) {

                    $cls = PositionPeer::getOMClass();

                    $obj5 = new $cls();
                    $obj5->hydrate($row, $startcol5);
                    PositionPeer::addInstanceToPool($obj5, $key5);
                } // if obj5 loaded

                // Add the $obj1 (Objective) to the collection in $obj5 (Position)
                $obj5->addObjective($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining the related StrategicObjective table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptStrategicObjective(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related PolicyGuideline table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptPolicyGuideline(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ObjectivePeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of Objective objects pre-filled with all related objects except StrategicObjective.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptStrategicObjective(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol2 = ObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined PolicyGuideline rows

                $key2 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = PolicyGuidelinePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = PolicyGuidelinePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    PolicyGuidelinePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Objective) to the collection in $obj2 (PolicyGuideline)
                $obj2->addObjective($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key3 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = UserPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = UserPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    UserPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (Objective) to the collection in $obj3 (User)
                $obj3->addObjective($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key4 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = PositionPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = PositionPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PositionPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (Objective) to the collection in $obj4 (Position)
                $obj4->addObjective($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Objective objects pre-filled with all related objects except PolicyGuideline.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptPolicyGuideline(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol2 = ObjectivePeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined StrategicObjective rows

                $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Objective) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjective($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key3 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = UserPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = UserPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    UserPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (Objective) to the collection in $obj3 (User)
                $obj3->addObjective($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key4 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = PositionPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = PositionPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PositionPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (Objective) to the collection in $obj4 (Position)
                $obj4->addObjective($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Objective objects pre-filled with all related objects except User.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol2 = ObjectivePeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined StrategicObjective rows

                $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Objective) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjective($obj1);

            } // if joined row is not null

                // Add objects for joined PolicyGuideline rows

                $key3 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = PolicyGuidelinePeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = PolicyGuidelinePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    PolicyGuidelinePeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (Objective) to the collection in $obj3 (PolicyGuideline)
                $obj3->addObjective($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key4 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = PositionPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = PositionPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PositionPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (Objective) to the collection in $obj4 (Position)
                $obj4->addObjective($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of Objective objects pre-filled with all related objects except Position.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of Objective objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ObjectivePeer::DATABASE_NAME);
        }

        ObjectivePeer::addSelectColumns($criteria);
        $startcol2 = ObjectivePeer::NUM_HYDRATE_COLUMNS;

        StrategicObjectivePeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + StrategicObjectivePeer::NUM_HYDRATE_COLUMNS;

        PolicyGuidelinePeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + PolicyGuidelinePeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + UserPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ObjectivePeer::STRATEGICOBJECTIVEID, StrategicObjectivePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::POLICYGUIDELINEID, PolicyGuidelinePeer::ID, $join_behavior);

        $criteria->addJoin(ObjectivePeer::USERID, UserPeer::ID, $join_behavior);

        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled()) {
            $criteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ObjectivePeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ObjectivePeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ObjectivePeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ObjectivePeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined StrategicObjective rows

                $key2 = StrategicObjectivePeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = StrategicObjectivePeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = StrategicObjectivePeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    StrategicObjectivePeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (Objective) to the collection in $obj2 (StrategicObjective)
                $obj2->addObjective($obj1);

            } // if joined row is not null

                // Add objects for joined PolicyGuideline rows

                $key3 = PolicyGuidelinePeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = PolicyGuidelinePeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = PolicyGuidelinePeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    PolicyGuidelinePeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (Objective) to the collection in $obj3 (PolicyGuideline)
                $obj3->addObjective($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key4 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = UserPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = UserPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    UserPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (Objective) to the collection in $obj4 (User)
                $obj4->addObjective($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(ObjectivePeer::DATABASE_NAME)->getTable(ObjectivePeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseObjectivePeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseObjectivePeer::TABLE_NAME)) {
        $dbMap->addTableObject(new ObjectiveTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return ObjectivePeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a Objective or Criteria object.
     *
     * @param      mixed $values Criteria or Objective object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from Objective object
        }

        if ($criteria->containsKey(ObjectivePeer::ID) && $criteria->keyContainsValue(ObjectivePeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ObjectivePeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a Objective or Criteria object.
     *
     * @param      mixed $values Criteria or Objective object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(ObjectivePeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(ObjectivePeer::ID);
            $value = $criteria->remove(ObjectivePeer::ID);
            if ($value) {
                $selectCriteria->add(ObjectivePeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(ObjectivePeer::TABLE_NAME);
            }

        } else { // $values is Objective object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the objectives_objective table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doForceDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += ObjectivePeer::doOnDeleteCascade(new Criteria(ObjectivePeer::DATABASE_NAME), $con);
            $affectedRows += BasePeer::doDeleteAll(ObjectivePeer::TABLE_NAME, $con, ObjectivePeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ObjectivePeer::clearInstancePool();
            ObjectivePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a Objective or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or Objective object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doForceDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof Objective) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ObjectivePeer::DATABASE_NAME);
            $criteria->add(ObjectivePeer::ID, (array) $values, Criteria::IN);
        }

        // Set the correct dbName
        $criteria->setDbName(ObjectivePeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            // cloning the Criteria in case it's modified by doSelect() or doSelectStmt()
            $c = clone $criteria;
            $affectedRows += ObjectivePeer::doOnDeleteCascade($c, $con);

            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            if ($values instanceof Criteria) {
                ObjectivePeer::clearInstancePool();
            } elseif ($values instanceof Objective) { // it's a model object
                ObjectivePeer::removeInstanceFromPool($values);
            } else { // it's a primary key, or an array of pks
                foreach ((array) $values as $singleval) {
                    ObjectivePeer::removeInstanceFromPool($singleval);
                }
            }

            $affectedRows += BasePeer::doDelete($criteria, $con);
            ObjectivePeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * This is a method for emulating ON DELETE CASCADE for DBs that don't support this
     * feature (like MySQL or SQLite).
     *
     * This method is not very speedy because it must perform a query first to get
     * the implicated records and then perform the deletes by calling those Peer classes.
     *
     * This method should be used within a transaction if possible.
     *
     * @param      Criteria $criteria
     * @param      PropelPDO $con
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    protected static function doOnDeleteCascade(Criteria $criteria, PropelPDO $con)
    {
        // initialize var to track total num of affected rows
        $affectedRows = 0;

        // first find the objects that are implicated by the $criteria
        $objects = ObjectivePeer::doSelect($criteria, $con);
        foreach ($objects as $obj) {


            // delete related Indicator objects
            $criteria = new Criteria(IndicatorPeer::DATABASE_NAME);

            $criteria->add(IndicatorPeer::OBJECTIVEID, $obj->getId());
            $affectedRows += IndicatorPeer::doDelete($criteria, $con);
        }

        return $affectedRows;
    }

    /**
     * Validates all modified columns of given Objective object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      Objective $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(ObjectivePeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(ObjectivePeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(ObjectivePeer::DATABASE_NAME, ObjectivePeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return Objective
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = ObjectivePeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(ObjectivePeer::DATABASE_NAME);
        $criteria->add(ObjectivePeer::ID, $pk);

        $v = ObjectivePeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return Objective[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(ObjectivePeer::DATABASE_NAME);
            $criteria->add(ObjectivePeer::ID, $pks, Criteria::IN);
            $objs = ObjectivePeer::doSelect($criteria, $con);
        }

        return $objs;
    }

    // soft_delete behavior

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        ObjectiveQuery::enableSoftDelete();
        // some soft_deleted objects may be in the instance pool
        ObjectivePeer::clearInstancePool();
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        ObjectiveQuery::disableSoftDelete();
    }

    /**
     * Check the soft_delete behavior for this model
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return ObjectiveQuery::isSoftDeleteEnabled();
    }

    /**
     * Soft delete records, given a Objective or Criteria object OR a primary key value.
     *
     * @param			 mixed $values Criteria or Objective object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDelete($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        if ($values instanceof Criteria) {
            // rename for clarity
            $selectCriteria = clone $values;
         } elseif ($values instanceof Objective) {
            // create criteria based on pk values
            $selectCriteria = $values->buildPkeyCriteria();
        } else {
            // it must be the primary key
            $selectCriteria = new Criteria(self::DATABASE_NAME);
             $selectCriteria->add(ObjectivePeer::ID, (array) $values, Criteria::IN);
        }
        // Set the correct dbName
        $selectCriteria->setDbName(ObjectivePeer::DATABASE_NAME);
        $updateCriteria = new Criteria(self::DATABASE_NAME);
        $updateCriteria->add(ObjectivePeer::DELETED_AT, time());

         return BasePeer::doUpdate($selectCriteria, $updateCriteria, $con);
    }

    /**
     * Delete or soft delete records, depending on ObjectivePeer::$softDelete
     *
     * @param			 mixed $values Criteria or Objective object or primary key or array of primary keys
     *							which is used to create the DELETE statement
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDelete($values, PropelPDO $con = null)
    {
        if (ObjectivePeer::isSoftDeleteEnabled()) {
            return ObjectivePeer::doSoftDelete($values, $con);
        } else {
            return ObjectivePeer::doForceDelete($values, $con);
        }
    }
    /**
     * Method to soft delete all rows from the objectives_objective table.
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doSoftDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $selectCriteria = new Criteria();
        $selectCriteria->add(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        $selectCriteria->setDbName(ObjectivePeer::DATABASE_NAME);
        $modifyCriteria = new Criteria();
        $modifyCriteria->add(ObjectivePeer::DELETED_AT, time());

        return BasePeer::doUpdate($selectCriteria, $modifyCriteria, $con);
    }

    /**
     * Delete or soft delete all records, depending on ObjectivePeer::$softDelete
     *
     * @param			 PropelPDO $con the connection to use
     * @return		 int	The number of affected rows (if supported by underlying database driver).
     * @throws		 PropelException Any exceptions caught during processing will be
     *							rethrown wrapped into a PropelException.
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if (ObjectivePeer::isSoftDeleteEnabled()) {
            return ObjectivePeer::doSoftDeleteAll($con);
        } else {
            return ObjectivePeer::doForceDeleteAll($con);
        }
    }

} // BaseObjectivePeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseObjectivePeer::buildTableMap();

