<?php

/**
 * MediasListAction
 *
 * Listado de medios
 *
 * @package    medias
 */

class MediasListAction extends BaseListAction {

	function __construct() {
		parent::__construct('Media');
	}

/**
 * preList
 * Acciones a ejecutar antes de obtener la coleccion de objetos
 */
	protected function preList() {
		parent::preList();

		$this->filters['filterNonAliases'] = true;

	}

/**
 * postList
 * Acciones a ejecutar despues de obtener la coleccion de objetos
 */
	protected function postList() {

		//Deseteo filtros internos
		unset($this->filters['filterNonAliases']);

		parent::postList();

	}
}