<?php


/**
 * Base class that represents a query for the 'headlines_headline' table.
 *
 * Headline
 *
 * @method HeadlineQuery orderById($order = Criteria::ASC) Order by the id column
 * @method HeadlineQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method HeadlineQuery orderByContent($order = Criteria::ASC) Order by the content column
 * @method HeadlineQuery orderByDatepublished($order = Criteria::ASC) Order by the datePublished column
 * @method HeadlineQuery orderByHeadlinedate($order = Criteria::ASC) Order by the headlineDate column
 * @method HeadlineQuery orderByUrl($order = Criteria::ASC) Order by the url column
 * @method HeadlineQuery orderByTwitts($order = Criteria::ASC) Order by the twitts column
 * @method HeadlineQuery orderByFcb($order = Criteria::ASC) Order by the fcb column
 * @method HeadlineQuery orderByGplus($order = Criteria::ASC) Order by the gplus column
 * @method HeadlineQuery orderByComment($order = Criteria::ASC) Order by the comment column
 * @method HeadlineQuery orderByPicture($order = Criteria::ASC) Order by the picture column
 * @method HeadlineQuery orderByCampaignid($order = Criteria::ASC) Order by the campaignId column
 * @method HeadlineQuery orderByMediaid($order = Criteria::ASC) Order by the mediaId column
 * @method HeadlineQuery orderByValue($order = Criteria::ASC) Order by the value column
 * @method HeadlineQuery orderByRelevance($order = Criteria::ASC) Order by the relevance column
 * @method HeadlineQuery orderByInternalid($order = Criteria::ASC) Order by the internalId column
 * @method HeadlineQuery orderByPage($order = Criteria::ASC) Order by the page column
 * @method HeadlineQuery orderBySection($order = Criteria::ASC) Order by the section column
 * @method HeadlineQuery orderByAuthor($order = Criteria::ASC) Order by the author column
 * @method HeadlineQuery orderBySource($order = Criteria::ASC) Order by the source column
 * @method HeadlineQuery orderBySummary($order = Criteria::ASC) Order by the summary column
 * @method HeadlineQuery orderByCaption($order = Criteria::ASC) Order by the caption column
 * @method HeadlineQuery orderByProgram($order = Criteria::ASC) Order by the program column
 * @method HeadlineQuery orderByStrategy($order = Criteria::ASC) Order by the strategy column
 * @method HeadlineQuery orderByLength($order = Criteria::ASC) Order by the length column
 * @method HeadlineQuery orderByAgenda($order = Criteria::ASC) Order by the agenda column
 * @method HeadlineQuery orderByHeadlinescope($order = Criteria::ASC) Order by the headlineScope column
 * @method HeadlineQuery orderByProcessed($order = Criteria::ASC) Order by the processed column
 * @method HeadlineQuery orderByClassKey($order = Criteria::ASC) Order by the class_key column
 * @method HeadlineQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method HeadlineQuery orderByUpdatedAt($order = Criteria::ASC) Order by the updated_at column
 * @method HeadlineQuery orderByIssuescount($order = Criteria::ASC) Order by the issuesCount column
 *
 * @method HeadlineQuery groupById() Group by the id column
 * @method HeadlineQuery groupByName() Group by the name column
 * @method HeadlineQuery groupByContent() Group by the content column
 * @method HeadlineQuery groupByDatepublished() Group by the datePublished column
 * @method HeadlineQuery groupByHeadlinedate() Group by the headlineDate column
 * @method HeadlineQuery groupByUrl() Group by the url column
 * @method HeadlineQuery groupByTwitts() Group by the twitts column
 * @method HeadlineQuery groupByFcb() Group by the fcb column
 * @method HeadlineQuery groupByGplus() Group by the gplus column
 * @method HeadlineQuery groupByComment() Group by the comment column
 * @method HeadlineQuery groupByPicture() Group by the picture column
 * @method HeadlineQuery groupByCampaignid() Group by the campaignId column
 * @method HeadlineQuery groupByMediaid() Group by the mediaId column
 * @method HeadlineQuery groupByValue() Group by the value column
 * @method HeadlineQuery groupByRelevance() Group by the relevance column
 * @method HeadlineQuery groupByInternalid() Group by the internalId column
 * @method HeadlineQuery groupByPage() Group by the page column
 * @method HeadlineQuery groupBySection() Group by the section column
 * @method HeadlineQuery groupByAuthor() Group by the author column
 * @method HeadlineQuery groupBySource() Group by the source column
 * @method HeadlineQuery groupBySummary() Group by the summary column
 * @method HeadlineQuery groupByCaption() Group by the caption column
 * @method HeadlineQuery groupByProgram() Group by the program column
 * @method HeadlineQuery groupByStrategy() Group by the strategy column
 * @method HeadlineQuery groupByLength() Group by the length column
 * @method HeadlineQuery groupByAgenda() Group by the agenda column
 * @method HeadlineQuery groupByHeadlinescope() Group by the headlineScope column
 * @method HeadlineQuery groupByProcessed() Group by the processed column
 * @method HeadlineQuery groupByClassKey() Group by the class_key column
 * @method HeadlineQuery groupByCreatedAt() Group by the created_at column
 * @method HeadlineQuery groupByUpdatedAt() Group by the updated_at column
 * @method HeadlineQuery groupByIssuescount() Group by the issuesCount column
 *
 * @method HeadlineQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method HeadlineQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method HeadlineQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method HeadlineQuery leftJoinMedia($relationAlias = null) Adds a LEFT JOIN clause to the query using the Media relation
 * @method HeadlineQuery rightJoinMedia($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Media relation
 * @method HeadlineQuery innerJoinMedia($relationAlias = null) Adds a INNER JOIN clause to the query using the Media relation
 *
 * @method HeadlineQuery leftJoinHeadlineActor($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineActor relation
 * @method HeadlineQuery rightJoinHeadlineActor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineActor relation
 * @method HeadlineQuery innerJoinHeadlineActor($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineActor relation
 *
 * @method HeadlineQuery leftJoinHeadlineIssue($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineIssue relation
 * @method HeadlineQuery rightJoinHeadlineIssue($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineIssue relation
 * @method HeadlineQuery innerJoinHeadlineIssue($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineIssue relation
 *
 * @method HeadlineQuery leftJoinHeadlineDocument($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineDocument relation
 * @method HeadlineQuery rightJoinHeadlineDocument($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineDocument relation
 * @method HeadlineQuery innerJoinHeadlineDocument($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineDocument relation
 *
 * @method HeadlineQuery leftJoinHeadlineTagRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the HeadlineTagRelation relation
 * @method HeadlineQuery rightJoinHeadlineTagRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the HeadlineTagRelation relation
 * @method HeadlineQuery innerJoinHeadlineTagRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the HeadlineTagRelation relation
 *
 * @method Headline findOne(PropelPDO $con = null) Return the first Headline matching the query
 * @method Headline findOneOrCreate(PropelPDO $con = null) Return the first Headline matching the query, or a new Headline object populated from the query conditions when no match is found
 *
 * @method Headline findOneById(int $id) Return the first Headline filtered by the id column
 * @method Headline findOneByName(string $name) Return the first Headline filtered by the name column
 * @method Headline findOneByContent(string $content) Return the first Headline filtered by the content column
 * @method Headline findOneByDatepublished(string $datePublished) Return the first Headline filtered by the datePublished column
 * @method Headline findOneByHeadlinedate(string $headlineDate) Return the first Headline filtered by the headlineDate column
 * @method Headline findOneByUrl(string $url) Return the first Headline filtered by the url column
 * @method Headline findOneByTwitts(int $twitts) Return the first Headline filtered by the twitts column
 * @method Headline findOneByFcb(int $fcb) Return the first Headline filtered by the fcb column
 * @method Headline findOneByGplus(int $gplus) Return the first Headline filtered by the gplus column
 * @method Headline findOneByComment(int $comment) Return the first Headline filtered by the comment column
 * @method Headline findOneByPicture(boolean $picture) Return the first Headline filtered by the picture column
 * @method Headline findOneByCampaignid(int $campaignId) Return the first Headline filtered by the campaignId column
 * @method Headline findOneByMediaid(int $mediaId) Return the first Headline filtered by the mediaId column
 * @method Headline findOneByValue(int $value) Return the first Headline filtered by the value column
 * @method Headline findOneByRelevance(int $relevance) Return the first Headline filtered by the relevance column
 * @method Headline findOneByInternalid(string $internalId) Return the first Headline filtered by the internalId column
 * @method Headline findOneByPage(int $page) Return the first Headline filtered by the page column
 * @method Headline findOneBySection(string $section) Return the first Headline filtered by the section column
 * @method Headline findOneByAuthor(string $author) Return the first Headline filtered by the author column
 * @method Headline findOneBySource(string $source) Return the first Headline filtered by the source column
 * @method Headline findOneBySummary(string $summary) Return the first Headline filtered by the summary column
 * @method Headline findOneByCaption(string $caption) Return the first Headline filtered by the caption column
 * @method Headline findOneByProgram(string $program) Return the first Headline filtered by the program column
 * @method Headline findOneByStrategy(string $strategy) Return the first Headline filtered by the strategy column
 * @method Headline findOneByLength(int $length) Return the first Headline filtered by the length column
 * @method Headline findOneByAgenda(int $agenda) Return the first Headline filtered by the agenda column
 * @method Headline findOneByHeadlinescope(int $headlineScope) Return the first Headline filtered by the headlineScope column
 * @method Headline findOneByProcessed(boolean $processed) Return the first Headline filtered by the processed column
 * @method Headline findOneByClassKey(int $class_key) Return the first Headline filtered by the class_key column
 * @method Headline findOneByCreatedAt(string $created_at) Return the first Headline filtered by the created_at column
 * @method Headline findOneByUpdatedAt(string $updated_at) Return the first Headline filtered by the updated_at column
 * @method Headline findOneByIssuescount(int $issuesCount) Return the first Headline filtered by the issuesCount column
 *
 * @method array findById(int $id) Return Headline objects filtered by the id column
 * @method array findByName(string $name) Return Headline objects filtered by the name column
 * @method array findByContent(string $content) Return Headline objects filtered by the content column
 * @method array findByDatepublished(string $datePublished) Return Headline objects filtered by the datePublished column
 * @method array findByHeadlinedate(string $headlineDate) Return Headline objects filtered by the headlineDate column
 * @method array findByUrl(string $url) Return Headline objects filtered by the url column
 * @method array findByTwitts(int $twitts) Return Headline objects filtered by the twitts column
 * @method array findByFcb(int $fcb) Return Headline objects filtered by the fcb column
 * @method array findByGplus(int $gplus) Return Headline objects filtered by the gplus column
 * @method array findByComment(int $comment) Return Headline objects filtered by the comment column
 * @method array findByPicture(boolean $picture) Return Headline objects filtered by the picture column
 * @method array findByCampaignid(int $campaignId) Return Headline objects filtered by the campaignId column
 * @method array findByMediaid(int $mediaId) Return Headline objects filtered by the mediaId column
 * @method array findByValue(int $value) Return Headline objects filtered by the value column
 * @method array findByRelevance(int $relevance) Return Headline objects filtered by the relevance column
 * @method array findByInternalid(string $internalId) Return Headline objects filtered by the internalId column
 * @method array findByPage(int $page) Return Headline objects filtered by the page column
 * @method array findBySection(string $section) Return Headline objects filtered by the section column
 * @method array findByAuthor(string $author) Return Headline objects filtered by the author column
 * @method array findBySource(string $source) Return Headline objects filtered by the source column
 * @method array findBySummary(string $summary) Return Headline objects filtered by the summary column
 * @method array findByCaption(string $caption) Return Headline objects filtered by the caption column
 * @method array findByProgram(string $program) Return Headline objects filtered by the program column
 * @method array findByStrategy(string $strategy) Return Headline objects filtered by the strategy column
 * @method array findByLength(int $length) Return Headline objects filtered by the length column
 * @method array findByAgenda(int $agenda) Return Headline objects filtered by the agenda column
 * @method array findByHeadlinescope(int $headlineScope) Return Headline objects filtered by the headlineScope column
 * @method array findByProcessed(boolean $processed) Return Headline objects filtered by the processed column
 * @method array findByClassKey(int $class_key) Return Headline objects filtered by the class_key column
 * @method array findByCreatedAt(string $created_at) Return Headline objects filtered by the created_at column
 * @method array findByUpdatedAt(string $updated_at) Return Headline objects filtered by the updated_at column
 * @method array findByIssuescount(int $issuesCount) Return Headline objects filtered by the issuesCount column
 *
 * @package    propel.generator.headlines.classes.om
 */
abstract class BaseHeadlineQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseHeadlineQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Headline', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new HeadlineQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     HeadlineQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return HeadlineQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof HeadlineQuery) {
            return $criteria;
        }
        $query = new HeadlineQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Headline|Headline[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = HeadlinePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(HeadlinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Headline A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `CONTENT`, `DATEPUBLISHED`, `HEADLINEDATE`, `URL`, `TWITTS`, `FCB`, `GPLUS`, `COMMENT`, `PICTURE`, `CAMPAIGNID`, `MEDIAID`, `VALUE`, `RELEVANCE`, `INTERNALID`, `PAGE`, `SECTION`, `AUTHOR`, `SOURCE`, `SUMMARY`, `CAPTION`, `PROGRAM`, `STRATEGY`, `LENGTH`, `AGENDA`, `HEADLINESCOPE`, `PROCESSED`, `CLASS_KEY`, `CREATED_AT`, `UPDATED_AT`, `ISSUESCOUNT` FROM `headlines_headline` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $cls = HeadlinePeer::getOMClass($row, 0);
            $obj = new $cls();
            $obj->hydrate($row);
            HeadlinePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Headline|Headline[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Headline[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(HeadlinePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(HeadlinePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(HeadlinePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the content column
     *
     * Example usage:
     * <code>
     * $query->filterByContent('fooValue');   // WHERE content = 'fooValue'
     * $query->filterByContent('%fooValue%'); // WHERE content LIKE '%fooValue%'
     * </code>
     *
     * @param     string $content The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByContent($content = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($content)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $content)) {
                $content = str_replace('*', '%', $content);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::CONTENT, $content, $comparison);
    }

    /**
     * Filter the query on the datePublished column
     *
     * Example usage:
     * <code>
     * $query->filterByDatepublished('2011-03-14'); // WHERE datePublished = '2011-03-14'
     * $query->filterByDatepublished('now'); // WHERE datePublished = '2011-03-14'
     * $query->filterByDatepublished(array('max' => 'yesterday')); // WHERE datePublished > '2011-03-13'
     * </code>
     *
     * @param     mixed $datepublished The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByDatepublished($datepublished = null, $comparison = null)
    {
        if (is_array($datepublished)) {
            $useMinMax = false;
            if (isset($datepublished['min'])) {
                $this->addUsingAlias(HeadlinePeer::DATEPUBLISHED, $datepublished['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datepublished['max'])) {
                $this->addUsingAlias(HeadlinePeer::DATEPUBLISHED, $datepublished['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::DATEPUBLISHED, $datepublished, $comparison);
    }

    /**
     * Filter the query on the headlineDate column
     *
     * Example usage:
     * <code>
     * $query->filterByHeadlinedate('2011-03-14'); // WHERE headlineDate = '2011-03-14'
     * $query->filterByHeadlinedate('now'); // WHERE headlineDate = '2011-03-14'
     * $query->filterByHeadlinedate(array('max' => 'yesterday')); // WHERE headlineDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $headlinedate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByHeadlinedate($headlinedate = null, $comparison = null)
    {
        if (is_array($headlinedate)) {
            $useMinMax = false;
            if (isset($headlinedate['min'])) {
                $this->addUsingAlias(HeadlinePeer::HEADLINEDATE, $headlinedate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($headlinedate['max'])) {
                $this->addUsingAlias(HeadlinePeer::HEADLINEDATE, $headlinedate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::HEADLINEDATE, $headlinedate, $comparison);
    }

    /**
     * Filter the query on the url column
     *
     * Example usage:
     * <code>
     * $query->filterByUrl('fooValue');   // WHERE url = 'fooValue'
     * $query->filterByUrl('%fooValue%'); // WHERE url LIKE '%fooValue%'
     * </code>
     *
     * @param     string $url The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByUrl($url = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($url)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $url)) {
                $url = str_replace('*', '%', $url);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::URL, $url, $comparison);
    }

    /**
     * Filter the query on the twitts column
     *
     * Example usage:
     * <code>
     * $query->filterByTwitts(1234); // WHERE twitts = 1234
     * $query->filterByTwitts(array(12, 34)); // WHERE twitts IN (12, 34)
     * $query->filterByTwitts(array('min' => 12)); // WHERE twitts > 12
     * </code>
     *
     * @param     mixed $twitts The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByTwitts($twitts = null, $comparison = null)
    {
        if (is_array($twitts)) {
            $useMinMax = false;
            if (isset($twitts['min'])) {
                $this->addUsingAlias(HeadlinePeer::TWITTS, $twitts['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($twitts['max'])) {
                $this->addUsingAlias(HeadlinePeer::TWITTS, $twitts['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::TWITTS, $twitts, $comparison);
    }

    /**
     * Filter the query on the fcb column
     *
     * Example usage:
     * <code>
     * $query->filterByFcb(1234); // WHERE fcb = 1234
     * $query->filterByFcb(array(12, 34)); // WHERE fcb IN (12, 34)
     * $query->filterByFcb(array('min' => 12)); // WHERE fcb > 12
     * </code>
     *
     * @param     mixed $fcb The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByFcb($fcb = null, $comparison = null)
    {
        if (is_array($fcb)) {
            $useMinMax = false;
            if (isset($fcb['min'])) {
                $this->addUsingAlias(HeadlinePeer::FCB, $fcb['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($fcb['max'])) {
                $this->addUsingAlias(HeadlinePeer::FCB, $fcb['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::FCB, $fcb, $comparison);
    }

    /**
     * Filter the query on the gplus column
     *
     * Example usage:
     * <code>
     * $query->filterByGplus(1234); // WHERE gplus = 1234
     * $query->filterByGplus(array(12, 34)); // WHERE gplus IN (12, 34)
     * $query->filterByGplus(array('min' => 12)); // WHERE gplus > 12
     * </code>
     *
     * @param     mixed $gplus The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByGplus($gplus = null, $comparison = null)
    {
        if (is_array($gplus)) {
            $useMinMax = false;
            if (isset($gplus['min'])) {
                $this->addUsingAlias(HeadlinePeer::GPLUS, $gplus['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($gplus['max'])) {
                $this->addUsingAlias(HeadlinePeer::GPLUS, $gplus['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::GPLUS, $gplus, $comparison);
    }

    /**
     * Filter the query on the comment column
     *
     * Example usage:
     * <code>
     * $query->filterByComment(1234); // WHERE comment = 1234
     * $query->filterByComment(array(12, 34)); // WHERE comment IN (12, 34)
     * $query->filterByComment(array('min' => 12)); // WHERE comment > 12
     * </code>
     *
     * @param     mixed $comment The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByComment($comment = null, $comparison = null)
    {
        if (is_array($comment)) {
            $useMinMax = false;
            if (isset($comment['min'])) {
                $this->addUsingAlias(HeadlinePeer::COMMENT, $comment['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($comment['max'])) {
                $this->addUsingAlias(HeadlinePeer::COMMENT, $comment['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::COMMENT, $comment, $comparison);
    }

    /**
     * Filter the query on the picture column
     *
     * Example usage:
     * <code>
     * $query->filterByPicture(true); // WHERE picture = true
     * $query->filterByPicture('yes'); // WHERE picture = true
     * </code>
     *
     * @param     boolean|string $picture The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByPicture($picture = null, $comparison = null)
    {
        if (is_string($picture)) {
            $picture = in_array(strtolower($picture), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(HeadlinePeer::PICTURE, $picture, $comparison);
    }

    /**
     * Filter the query on the campaignId column
     *
     * Example usage:
     * <code>
     * $query->filterByCampaignid(1234); // WHERE campaignId = 1234
     * $query->filterByCampaignid(array(12, 34)); // WHERE campaignId IN (12, 34)
     * $query->filterByCampaignid(array('min' => 12)); // WHERE campaignId > 12
     * </code>
     *
     * @param     mixed $campaignid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByCampaignid($campaignid = null, $comparison = null)
    {
        if (is_array($campaignid)) {
            $useMinMax = false;
            if (isset($campaignid['min'])) {
                $this->addUsingAlias(HeadlinePeer::CAMPAIGNID, $campaignid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($campaignid['max'])) {
                $this->addUsingAlias(HeadlinePeer::CAMPAIGNID, $campaignid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::CAMPAIGNID, $campaignid, $comparison);
    }

    /**
     * Filter the query on the mediaId column
     *
     * Example usage:
     * <code>
     * $query->filterByMediaid(1234); // WHERE mediaId = 1234
     * $query->filterByMediaid(array(12, 34)); // WHERE mediaId IN (12, 34)
     * $query->filterByMediaid(array('min' => 12)); // WHERE mediaId > 12
     * </code>
     *
     * @see       filterByMedia()
     *
     * @param     mixed $mediaid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByMediaid($mediaid = null, $comparison = null)
    {
        if (is_array($mediaid)) {
            $useMinMax = false;
            if (isset($mediaid['min'])) {
                $this->addUsingAlias(HeadlinePeer::MEDIAID, $mediaid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($mediaid['max'])) {
                $this->addUsingAlias(HeadlinePeer::MEDIAID, $mediaid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::MEDIAID, $mediaid, $comparison);
    }

    /**
     * Filter the query on the value column
     *
     * Example usage:
     * <code>
     * $query->filterByValue(1234); // WHERE value = 1234
     * $query->filterByValue(array(12, 34)); // WHERE value IN (12, 34)
     * $query->filterByValue(array('min' => 12)); // WHERE value > 12
     * </code>
     *
     * @param     mixed $value The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByValue($value = null, $comparison = null)
    {
        if (is_array($value)) {
            $useMinMax = false;
            if (isset($value['min'])) {
                $this->addUsingAlias(HeadlinePeer::VALUE, $value['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($value['max'])) {
                $this->addUsingAlias(HeadlinePeer::VALUE, $value['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::VALUE, $value, $comparison);
    }

    /**
     * Filter the query on the relevance column
     *
     * Example usage:
     * <code>
     * $query->filterByRelevance(1234); // WHERE relevance = 1234
     * $query->filterByRelevance(array(12, 34)); // WHERE relevance IN (12, 34)
     * $query->filterByRelevance(array('min' => 12)); // WHERE relevance > 12
     * </code>
     *
     * @param     mixed $relevance The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByRelevance($relevance = null, $comparison = null)
    {
        if (is_array($relevance)) {
            $useMinMax = false;
            if (isset($relevance['min'])) {
                $this->addUsingAlias(HeadlinePeer::RELEVANCE, $relevance['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($relevance['max'])) {
                $this->addUsingAlias(HeadlinePeer::RELEVANCE, $relevance['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::RELEVANCE, $relevance, $comparison);
    }

    /**
     * Filter the query on the internalId column
     *
     * Example usage:
     * <code>
     * $query->filterByInternalid('fooValue');   // WHERE internalId = 'fooValue'
     * $query->filterByInternalid('%fooValue%'); // WHERE internalId LIKE '%fooValue%'
     * </code>
     *
     * @param     string $internalid The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByInternalid($internalid = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($internalid)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $internalid)) {
                $internalid = str_replace('*', '%', $internalid);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::INTERNALID, $internalid, $comparison);
    }

    /**
     * Filter the query on the page column
     *
     * Example usage:
     * <code>
     * $query->filterByPage(1234); // WHERE page = 1234
     * $query->filterByPage(array(12, 34)); // WHERE page IN (12, 34)
     * $query->filterByPage(array('min' => 12)); // WHERE page > 12
     * </code>
     *
     * @param     mixed $page The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByPage($page = null, $comparison = null)
    {
        if (is_array($page)) {
            $useMinMax = false;
            if (isset($page['min'])) {
                $this->addUsingAlias(HeadlinePeer::PAGE, $page['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($page['max'])) {
                $this->addUsingAlias(HeadlinePeer::PAGE, $page['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::PAGE, $page, $comparison);
    }

    /**
     * Filter the query on the section column
     *
     * Example usage:
     * <code>
     * $query->filterBySection('fooValue');   // WHERE section = 'fooValue'
     * $query->filterBySection('%fooValue%'); // WHERE section LIKE '%fooValue%'
     * </code>
     *
     * @param     string $section The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterBySection($section = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($section)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $section)) {
                $section = str_replace('*', '%', $section);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::SECTION, $section, $comparison);
    }

    /**
     * Filter the query on the author column
     *
     * Example usage:
     * <code>
     * $query->filterByAuthor('fooValue');   // WHERE author = 'fooValue'
     * $query->filterByAuthor('%fooValue%'); // WHERE author LIKE '%fooValue%'
     * </code>
     *
     * @param     string $author The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByAuthor($author = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($author)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $author)) {
                $author = str_replace('*', '%', $author);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::AUTHOR, $author, $comparison);
    }

    /**
     * Filter the query on the source column
     *
     * Example usage:
     * <code>
     * $query->filterBySource('fooValue');   // WHERE source = 'fooValue'
     * $query->filterBySource('%fooValue%'); // WHERE source LIKE '%fooValue%'
     * </code>
     *
     * @param     string $source The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterBySource($source = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($source)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $source)) {
                $source = str_replace('*', '%', $source);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::SOURCE, $source, $comparison);
    }

    /**
     * Filter the query on the summary column
     *
     * Example usage:
     * <code>
     * $query->filterBySummary('fooValue');   // WHERE summary = 'fooValue'
     * $query->filterBySummary('%fooValue%'); // WHERE summary LIKE '%fooValue%'
     * </code>
     *
     * @param     string $summary The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterBySummary($summary = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($summary)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $summary)) {
                $summary = str_replace('*', '%', $summary);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::SUMMARY, $summary, $comparison);
    }

    /**
     * Filter the query on the caption column
     *
     * Example usage:
     * <code>
     * $query->filterByCaption('fooValue');   // WHERE caption = 'fooValue'
     * $query->filterByCaption('%fooValue%'); // WHERE caption LIKE '%fooValue%'
     * </code>
     *
     * @param     string $caption The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByCaption($caption = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($caption)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $caption)) {
                $caption = str_replace('*', '%', $caption);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::CAPTION, $caption, $comparison);
    }

    /**
     * Filter the query on the program column
     *
     * Example usage:
     * <code>
     * $query->filterByProgram('fooValue');   // WHERE program = 'fooValue'
     * $query->filterByProgram('%fooValue%'); // WHERE program LIKE '%fooValue%'
     * </code>
     *
     * @param     string $program The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByProgram($program = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($program)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $program)) {
                $program = str_replace('*', '%', $program);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::PROGRAM, $program, $comparison);
    }

    /**
     * Filter the query on the strategy column
     *
     * Example usage:
     * <code>
     * $query->filterByStrategy('fooValue');   // WHERE strategy = 'fooValue'
     * $query->filterByStrategy('%fooValue%'); // WHERE strategy LIKE '%fooValue%'
     * </code>
     *
     * @param     string $strategy The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByStrategy($strategy = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($strategy)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $strategy)) {
                $strategy = str_replace('*', '%', $strategy);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::STRATEGY, $strategy, $comparison);
    }

    /**
     * Filter the query on the length column
     *
     * Example usage:
     * <code>
     * $query->filterByLength(1234); // WHERE length = 1234
     * $query->filterByLength(array(12, 34)); // WHERE length IN (12, 34)
     * $query->filterByLength(array('min' => 12)); // WHERE length > 12
     * </code>
     *
     * @param     mixed $length The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByLength($length = null, $comparison = null)
    {
        if (is_array($length)) {
            $useMinMax = false;
            if (isset($length['min'])) {
                $this->addUsingAlias(HeadlinePeer::LENGTH, $length['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($length['max'])) {
                $this->addUsingAlias(HeadlinePeer::LENGTH, $length['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::LENGTH, $length, $comparison);
    }

    /**
     * Filter the query on the agenda column
     *
     * Example usage:
     * <code>
     * $query->filterByAgenda(1234); // WHERE agenda = 1234
     * $query->filterByAgenda(array(12, 34)); // WHERE agenda IN (12, 34)
     * $query->filterByAgenda(array('min' => 12)); // WHERE agenda > 12
     * </code>
     *
     * @param     mixed $agenda The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByAgenda($agenda = null, $comparison = null)
    {
        if (is_array($agenda)) {
            $useMinMax = false;
            if (isset($agenda['min'])) {
                $this->addUsingAlias(HeadlinePeer::AGENDA, $agenda['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($agenda['max'])) {
                $this->addUsingAlias(HeadlinePeer::AGENDA, $agenda['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::AGENDA, $agenda, $comparison);
    }

    /**
     * Filter the query on the headlineScope column
     *
     * Example usage:
     * <code>
     * $query->filterByHeadlinescope(1234); // WHERE headlineScope = 1234
     * $query->filterByHeadlinescope(array(12, 34)); // WHERE headlineScope IN (12, 34)
     * $query->filterByHeadlinescope(array('min' => 12)); // WHERE headlineScope > 12
     * </code>
     *
     * @param     mixed $headlinescope The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByHeadlinescope($headlinescope = null, $comparison = null)
    {
        if (is_array($headlinescope)) {
            $useMinMax = false;
            if (isset($headlinescope['min'])) {
                $this->addUsingAlias(HeadlinePeer::HEADLINESCOPE, $headlinescope['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($headlinescope['max'])) {
                $this->addUsingAlias(HeadlinePeer::HEADLINESCOPE, $headlinescope['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::HEADLINESCOPE, $headlinescope, $comparison);
    }

    /**
     * Filter the query on the processed column
     *
     * Example usage:
     * <code>
     * $query->filterByProcessed(true); // WHERE processed = true
     * $query->filterByProcessed('yes'); // WHERE processed = true
     * </code>
     *
     * @param     boolean|string $processed The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByProcessed($processed = null, $comparison = null)
    {
        if (is_string($processed)) {
            $processed = in_array(strtolower($processed), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(HeadlinePeer::PROCESSED, $processed, $comparison);
    }

    /**
     * Filter the query on the class_key column
     *
     * Example usage:
     * <code>
     * $query->filterByClassKey(1234); // WHERE class_key = 1234
     * $query->filterByClassKey(array(12, 34)); // WHERE class_key IN (12, 34)
     * $query->filterByClassKey(array('min' => 12)); // WHERE class_key > 12
     * </code>
     *
     * @param     mixed $classKey The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByClassKey($classKey = null, $comparison = null)
    {
        if (is_array($classKey)) {
            $useMinMax = false;
            if (isset($classKey['min'])) {
                $this->addUsingAlias(HeadlinePeer::CLASS_KEY, $classKey['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($classKey['max'])) {
                $this->addUsingAlias(HeadlinePeer::CLASS_KEY, $classKey['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::CLASS_KEY, $classKey, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(HeadlinePeer::CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(HeadlinePeer::CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the updated_at column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdatedAt('2011-03-14'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt('now'); // WHERE updated_at = '2011-03-14'
     * $query->filterByUpdatedAt(array('max' => 'yesterday')); // WHERE updated_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $updatedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByUpdatedAt($updatedAt = null, $comparison = null)
    {
        if (is_array($updatedAt)) {
            $useMinMax = false;
            if (isset($updatedAt['min'])) {
                $this->addUsingAlias(HeadlinePeer::UPDATED_AT, $updatedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updatedAt['max'])) {
                $this->addUsingAlias(HeadlinePeer::UPDATED_AT, $updatedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::UPDATED_AT, $updatedAt, $comparison);
    }

    /**
     * Filter the query on the issuesCount column
     *
     * Example usage:
     * <code>
     * $query->filterByIssuescount(1234); // WHERE issuesCount = 1234
     * $query->filterByIssuescount(array(12, 34)); // WHERE issuesCount IN (12, 34)
     * $query->filterByIssuescount(array('min' => 12)); // WHERE issuesCount > 12
     * </code>
     *
     * @param     mixed $issuescount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function filterByIssuescount($issuescount = null, $comparison = null)
    {
        if (is_array($issuescount)) {
            $useMinMax = false;
            if (isset($issuescount['min'])) {
                $this->addUsingAlias(HeadlinePeer::ISSUESCOUNT, $issuescount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($issuescount['max'])) {
                $this->addUsingAlias(HeadlinePeer::ISSUESCOUNT, $issuescount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HeadlinePeer::ISSUESCOUNT, $issuescount, $comparison);
    }

    /**
     * Filter the query by a related Media object
     *
     * @param   Media|PropelObjectCollection $media The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMedia($media, $comparison = null)
    {
        if ($media instanceof Media) {
            return $this
                ->addUsingAlias(HeadlinePeer::MEDIAID, $media->getId(), $comparison);
        } elseif ($media instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(HeadlinePeer::MEDIAID, $media->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMedia() only accepts arguments of type Media or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Media relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function joinMedia($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Media');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Media');
        }

        return $this;
    }

    /**
     * Use the Media relation Media object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MediaQuery A secondary query class using the current class as primary query
     */
    public function useMediaQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMedia($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Media', 'MediaQuery');
    }

    /**
     * Filter the query by a related HeadlineActor object
     *
     * @param   HeadlineActor|PropelObjectCollection $headlineActor  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineActor($headlineActor, $comparison = null)
    {
        if ($headlineActor instanceof HeadlineActor) {
            return $this
                ->addUsingAlias(HeadlinePeer::ID, $headlineActor->getHeadlineid(), $comparison);
        } elseif ($headlineActor instanceof PropelObjectCollection) {
            return $this
                ->useHeadlineActorQuery()
                ->filterByPrimaryKeys($headlineActor->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHeadlineActor() only accepts arguments of type HeadlineActor or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineActor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function joinHeadlineActor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineActor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineActor');
        }

        return $this;
    }

    /**
     * Use the HeadlineActor relation HeadlineActor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineActorQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineActorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineActor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineActor', 'HeadlineActorQuery');
    }

    /**
     * Filter the query by a related HeadlineIssue object
     *
     * @param   HeadlineIssue|PropelObjectCollection $headlineIssue  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineIssue($headlineIssue, $comparison = null)
    {
        if ($headlineIssue instanceof HeadlineIssue) {
            return $this
                ->addUsingAlias(HeadlinePeer::ID, $headlineIssue->getHeadlineid(), $comparison);
        } elseif ($headlineIssue instanceof PropelObjectCollection) {
            return $this
                ->useHeadlineIssueQuery()
                ->filterByPrimaryKeys($headlineIssue->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHeadlineIssue() only accepts arguments of type HeadlineIssue or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineIssue relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function joinHeadlineIssue($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineIssue');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineIssue');
        }

        return $this;
    }

    /**
     * Use the HeadlineIssue relation HeadlineIssue object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineIssueQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineIssueQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineIssue($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineIssue', 'HeadlineIssueQuery');
    }

    /**
     * Filter the query by a related HeadlineDocument object
     *
     * @param   HeadlineDocument|PropelObjectCollection $headlineDocument  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineDocument($headlineDocument, $comparison = null)
    {
        if ($headlineDocument instanceof HeadlineDocument) {
            return $this
                ->addUsingAlias(HeadlinePeer::ID, $headlineDocument->getHeadlineid(), $comparison);
        } elseif ($headlineDocument instanceof PropelObjectCollection) {
            return $this
                ->useHeadlineDocumentQuery()
                ->filterByPrimaryKeys($headlineDocument->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHeadlineDocument() only accepts arguments of type HeadlineDocument or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineDocument relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function joinHeadlineDocument($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineDocument');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineDocument');
        }

        return $this;
    }

    /**
     * Use the HeadlineDocument relation HeadlineDocument object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineDocumentQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineDocumentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineDocument($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineDocument', 'HeadlineDocumentQuery');
    }

    /**
     * Filter the query by a related HeadlineTagRelation object
     *
     * @param   HeadlineTagRelation|PropelObjectCollection $headlineTagRelation  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByHeadlineTagRelation($headlineTagRelation, $comparison = null)
    {
        if ($headlineTagRelation instanceof HeadlineTagRelation) {
            return $this
                ->addUsingAlias(HeadlinePeer::ID, $headlineTagRelation->getHeadlineid(), $comparison);
        } elseif ($headlineTagRelation instanceof PropelObjectCollection) {
            return $this
                ->useHeadlineTagRelationQuery()
                ->filterByPrimaryKeys($headlineTagRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHeadlineTagRelation() only accepts arguments of type HeadlineTagRelation or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the HeadlineTagRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function joinHeadlineTagRelation($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('HeadlineTagRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'HeadlineTagRelation');
        }

        return $this;
    }

    /**
     * Use the HeadlineTagRelation relation HeadlineTagRelation object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   HeadlineTagRelationQuery A secondary query class using the current class as primary query
     */
    public function useHeadlineTagRelationQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinHeadlineTagRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'HeadlineTagRelation', 'HeadlineTagRelationQuery');
    }

    /**
     * Filter the query by a related Actor object
     * using the headlines_actor table as cross reference
     *
     * @param   Actor $actor the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     */
    public function filterByActor($actor, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useHeadlineActorQuery()
            ->filterByActor($actor, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Issue object
     * using the headlines_issue table as cross reference
     *
     * @param   Issue $issue the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     */
    public function filterByIssue($issue, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useHeadlineIssueQuery()
            ->filterByIssue($issue, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related Document object
     * using the headlines_headlineDocument table as cross reference
     *
     * @param   Document $document the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     */
    public function filterByDocument($document, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useHeadlineDocumentQuery()
            ->filterByDocument($document, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related HeadlineTag object
     * using the headlines_headlineTags table as cross reference
     *
     * @param   HeadlineTag $headlineTag the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   HeadlineQuery The current query, for fluid interface
     */
    public function filterByHeadlineTag($headlineTag, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useHeadlineTagRelationQuery()
            ->filterByHeadlineTag($headlineTag, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Headline $headline Object to remove from the list of results
     *
     * @return HeadlineQuery The current query, for fluid interface
     */
    public function prune($headline = null)
    {
        if ($headline) {
            $this->addUsingAlias(HeadlinePeer::ID, $headline->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    // timestampable behavior

    /**
     * Filter by the latest updated
     *
     * @param      int $nbDays Maximum age of the latest update in days
     *
     * @return     HeadlineQuery The current query, for fluid interface
     */
    public function recentlyUpdated($nbDays = 7)
    {
        return $this->addUsingAlias(HeadlinePeer::UPDATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by update date desc
     *
     * @return     HeadlineQuery The current query, for fluid interface
     */
    public function lastUpdatedFirst()
    {
        return $this->addDescendingOrderByColumn(HeadlinePeer::UPDATED_AT);
    }

    /**
     * Order by update date asc
     *
     * @return     HeadlineQuery The current query, for fluid interface
     */
    public function firstUpdatedFirst()
    {
        return $this->addAscendingOrderByColumn(HeadlinePeer::UPDATED_AT);
    }

    /**
     * Filter by the latest created
     *
     * @param      int $nbDays Maximum age of in days
     *
     * @return     HeadlineQuery The current query, for fluid interface
     */
    public function recentlyCreated($nbDays = 7)
    {
        return $this->addUsingAlias(HeadlinePeer::CREATED_AT, time() - $nbDays * 24 * 60 * 60, Criteria::GREATER_EQUAL);
    }

    /**
     * Order by create date desc
     *
     * @return     HeadlineQuery The current query, for fluid interface
     */
    public function lastCreatedFirst()
    {
        return $this->addDescendingOrderByColumn(HeadlinePeer::CREATED_AT);
    }

    /**
     * Order by create date asc
     *
     * @return     HeadlineQuery The current query, for fluid interface
     */
    public function firstCreatedFirst()
    {
        return $this->addAscendingOrderByColumn(HeadlinePeer::CREATED_AT);
    }
}
