<?php


/**
 * Base class that represents a row from the 'common_alertSubscription' table.
 *
 * Suscripciones de alerta
 *
 * @package    propel.generator.common.classes.om
 */
abstract class BaseAlertSubscription extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'AlertSubscriptionPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        AlertSubscriptionPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the entityname field.
     * @var        string
     */
    protected $entityname;

    /**
     * The value for the entityfielduniquename field.
     * @var        string
     */
    protected $entityfielduniquename;

    /**
     * The value for the anticipationdays field.
     * @var        int
     */
    protected $anticipationdays;

    /**
     * The value for the entitynamefielduniquename field.
     * @var        string
     */
    protected $entitynamefielduniquename;

    /**
     * The value for the extrarecipients field.
     * @var        string
     */
    protected $extrarecipients;

    /**
     * @var        ModuleEntity
     */
    protected $aModuleEntity;

    /**
     * @var        ModuleEntityField
     */
    protected $aModuleEntityFieldRelatedByEntityfielduniquename;

    /**
     * @var        ModuleEntityField
     */
    protected $aModuleEntityFieldRelatedByEntitynamefielduniquename;

    /**
     * @var        PropelObjectCollection|AlertSubscriptionUser[] Collection to store aggregation of AlertSubscriptionUser objects.
     */
    protected $collAlertSubscriptionUsers;
    protected $collAlertSubscriptionUsersPartial;

    /**
     * @var        PropelObjectCollection|User[] Collection to store aggregation of User objects.
     */
    protected $collUsers;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $usersScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $alertSubscriptionUsersScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Nombre de la suscripción
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [entityname] column value.
     * Nombre único de la entidad asociada.
     * @return string
     */
    public function getEntityname()
    {
        return $this->entityname;
    }

    /**
     * Get the [entityfielduniquename] column value.
     *
     * @return string
     */
    public function getEntityfielduniquename()
    {
        return $this->entityfielduniquename;
    }

    /**
     * Get the [anticipationdays] column value.
     * Cantidad de dias de anticipación. Se usa para evaluar campos tipo fecha.
     * @return int
     */
    public function getAnticipationdays()
    {
        return $this->anticipationdays;
    }

    /**
     * Get the [entitynamefielduniquename] column value.
     * Campo a imprimir en representación del nombre de cada instancia de la entidad
     * @return string
     */
    public function getEntitynamefielduniquename()
    {
        return $this->entitynamefielduniquename;
    }

    /**
     * Get the [extrarecipients] column value.
     * Destinatarios extra
     * @return string
     */
    public function getExtrarecipients()
    {
        return $this->extrarecipients;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return AlertSubscription The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = AlertSubscriptionPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Nombre de la suscripción
     * @param string $v new value
     * @return AlertSubscription The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = AlertSubscriptionPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [entityname] column.
     * Nombre único de la entidad asociada.
     * @param string $v new value
     * @return AlertSubscription The current object (for fluent API support)
     */
    public function setEntityname($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->entityname !== $v) {
            $this->entityname = $v;
            $this->modifiedColumns[] = AlertSubscriptionPeer::ENTITYNAME;
        }

        if ($this->aModuleEntity !== null && $this->aModuleEntity->getName() !== $v) {
            $this->aModuleEntity = null;
        }


        return $this;
    } // setEntityname()

    /**
     * Set the value of [entityfielduniquename] column.
     *
     * @param string $v new value
     * @return AlertSubscription The current object (for fluent API support)
     */
    public function setEntityfielduniquename($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->entityfielduniquename !== $v) {
            $this->entityfielduniquename = $v;
            $this->modifiedColumns[] = AlertSubscriptionPeer::ENTITYFIELDUNIQUENAME;
        }

        if ($this->aModuleEntityFieldRelatedByEntityfielduniquename !== null && $this->aModuleEntityFieldRelatedByEntityfielduniquename->getUniquename() !== $v) {
            $this->aModuleEntityFieldRelatedByEntityfielduniquename = null;
        }


        return $this;
    } // setEntityfielduniquename()

    /**
     * Set the value of [anticipationdays] column.
     * Cantidad de dias de anticipación. Se usa para evaluar campos tipo fecha.
     * @param int $v new value
     * @return AlertSubscription The current object (for fluent API support)
     */
    public function setAnticipationdays($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->anticipationdays !== $v) {
            $this->anticipationdays = $v;
            $this->modifiedColumns[] = AlertSubscriptionPeer::ANTICIPATIONDAYS;
        }


        return $this;
    } // setAnticipationdays()

    /**
     * Set the value of [entitynamefielduniquename] column.
     * Campo a imprimir en representación del nombre de cada instancia de la entidad
     * @param string $v new value
     * @return AlertSubscription The current object (for fluent API support)
     */
    public function setEntitynamefielduniquename($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->entitynamefielduniquename !== $v) {
            $this->entitynamefielduniquename = $v;
            $this->modifiedColumns[] = AlertSubscriptionPeer::ENTITYNAMEFIELDUNIQUENAME;
        }

        if ($this->aModuleEntityFieldRelatedByEntitynamefielduniquename !== null && $this->aModuleEntityFieldRelatedByEntitynamefielduniquename->getUniquename() !== $v) {
            $this->aModuleEntityFieldRelatedByEntitynamefielduniquename = null;
        }


        return $this;
    } // setEntitynamefielduniquename()

    /**
     * Set the value of [extrarecipients] column.
     * Destinatarios extra
     * @param string $v new value
     * @return AlertSubscription The current object (for fluent API support)
     */
    public function setExtrarecipients($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->extrarecipients !== $v) {
            $this->extrarecipients = $v;
            $this->modifiedColumns[] = AlertSubscriptionPeer::EXTRARECIPIENTS;
        }


        return $this;
    } // setExtrarecipients()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->entityname = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->entityfielduniquename = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->anticipationdays = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->entitynamefielduniquename = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->extrarecipients = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 7; // 7 = AlertSubscriptionPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating AlertSubscription object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aModuleEntity !== null && $this->entityname !== $this->aModuleEntity->getName()) {
            $this->aModuleEntity = null;
        }
        if ($this->aModuleEntityFieldRelatedByEntityfielduniquename !== null && $this->entityfielduniquename !== $this->aModuleEntityFieldRelatedByEntityfielduniquename->getUniquename()) {
            $this->aModuleEntityFieldRelatedByEntityfielduniquename = null;
        }
        if ($this->aModuleEntityFieldRelatedByEntitynamefielduniquename !== null && $this->entitynamefielduniquename !== $this->aModuleEntityFieldRelatedByEntitynamefielduniquename->getUniquename()) {
            $this->aModuleEntityFieldRelatedByEntitynamefielduniquename = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(AlertSubscriptionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = AlertSubscriptionPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aModuleEntity = null;
            $this->aModuleEntityFieldRelatedByEntityfielduniquename = null;
            $this->aModuleEntityFieldRelatedByEntitynamefielduniquename = null;
            $this->collAlertSubscriptionUsers = null;

            $this->collUsers = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(AlertSubscriptionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = AlertSubscriptionQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(AlertSubscriptionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                AlertSubscriptionPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aModuleEntity !== null) {
                if ($this->aModuleEntity->isModified() || $this->aModuleEntity->isNew()) {
                    $affectedRows += $this->aModuleEntity->save($con);
                }
                $this->setModuleEntity($this->aModuleEntity);
            }

            if ($this->aModuleEntityFieldRelatedByEntityfielduniquename !== null) {
                if ($this->aModuleEntityFieldRelatedByEntityfielduniquename->isModified() || $this->aModuleEntityFieldRelatedByEntityfielduniquename->isNew()) {
                    $affectedRows += $this->aModuleEntityFieldRelatedByEntityfielduniquename->save($con);
                }
                $this->setModuleEntityFieldRelatedByEntityfielduniquename($this->aModuleEntityFieldRelatedByEntityfielduniquename);
            }

            if ($this->aModuleEntityFieldRelatedByEntitynamefielduniquename !== null) {
                if ($this->aModuleEntityFieldRelatedByEntitynamefielduniquename->isModified() || $this->aModuleEntityFieldRelatedByEntitynamefielduniquename->isNew()) {
                    $affectedRows += $this->aModuleEntityFieldRelatedByEntitynamefielduniquename->save($con);
                }
                $this->setModuleEntityFieldRelatedByEntitynamefielduniquename($this->aModuleEntityFieldRelatedByEntitynamefielduniquename);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->usersScheduledForDeletion !== null) {
                if (!$this->usersScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->usersScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    AlertSubscriptionUserQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->usersScheduledForDeletion = null;
                }

                foreach ($this->getUsers() as $user) {
                    if ($user->isModified()) {
                        $user->save($con);
                    }
                }
            }

            if ($this->alertSubscriptionUsersScheduledForDeletion !== null) {
                if (!$this->alertSubscriptionUsersScheduledForDeletion->isEmpty()) {
                    AlertSubscriptionUserQuery::create()
                        ->filterByPrimaryKeys($this->alertSubscriptionUsersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->alertSubscriptionUsersScheduledForDeletion = null;
                }
            }

            if ($this->collAlertSubscriptionUsers !== null) {
                foreach ($this->collAlertSubscriptionUsers as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = AlertSubscriptionPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . AlertSubscriptionPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(AlertSubscriptionPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(AlertSubscriptionPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(AlertSubscriptionPeer::ENTITYNAME)) {
            $modifiedColumns[':p' . $index++]  = '`ENTITYNAME`';
        }
        if ($this->isColumnModified(AlertSubscriptionPeer::ENTITYFIELDUNIQUENAME)) {
            $modifiedColumns[':p' . $index++]  = '`ENTITYFIELDUNIQUENAME`';
        }
        if ($this->isColumnModified(AlertSubscriptionPeer::ANTICIPATIONDAYS)) {
            $modifiedColumns[':p' . $index++]  = '`ANTICIPATIONDAYS`';
        }
        if ($this->isColumnModified(AlertSubscriptionPeer::ENTITYNAMEFIELDUNIQUENAME)) {
            $modifiedColumns[':p' . $index++]  = '`ENTITYNAMEFIELDUNIQUENAME`';
        }
        if ($this->isColumnModified(AlertSubscriptionPeer::EXTRARECIPIENTS)) {
            $modifiedColumns[':p' . $index++]  = '`EXTRARECIPIENTS`';
        }

        $sql = sprintf(
            'INSERT INTO `common_alertSubscription` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`ENTITYNAME`':
                        $stmt->bindValue($identifier, $this->entityname, PDO::PARAM_STR);
                        break;
                    case '`ENTITYFIELDUNIQUENAME`':
                        $stmt->bindValue($identifier, $this->entityfielduniquename, PDO::PARAM_STR);
                        break;
                    case '`ANTICIPATIONDAYS`':
                        $stmt->bindValue($identifier, $this->anticipationdays, PDO::PARAM_INT);
                        break;
                    case '`ENTITYNAMEFIELDUNIQUENAME`':
                        $stmt->bindValue($identifier, $this->entitynamefielduniquename, PDO::PARAM_STR);
                        break;
                    case '`EXTRARECIPIENTS`':
                        $stmt->bindValue($identifier, $this->extrarecipients, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aModuleEntity !== null) {
                if (!$this->aModuleEntity->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aModuleEntity->getValidationFailures());
                }
            }

            if ($this->aModuleEntityFieldRelatedByEntityfielduniquename !== null) {
                if (!$this->aModuleEntityFieldRelatedByEntityfielduniquename->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aModuleEntityFieldRelatedByEntityfielduniquename->getValidationFailures());
                }
            }

            if ($this->aModuleEntityFieldRelatedByEntitynamefielduniquename !== null) {
                if (!$this->aModuleEntityFieldRelatedByEntitynamefielduniquename->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aModuleEntityFieldRelatedByEntitynamefielduniquename->getValidationFailures());
                }
            }


            if (($retval = AlertSubscriptionPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collAlertSubscriptionUsers !== null) {
                    foreach ($this->collAlertSubscriptionUsers as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = AlertSubscriptionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getEntityname();
                break;
            case 3:
                return $this->getEntityfielduniquename();
                break;
            case 4:
                return $this->getAnticipationdays();
                break;
            case 5:
                return $this->getEntitynamefielduniquename();
                break;
            case 6:
                return $this->getExtrarecipients();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['AlertSubscription'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['AlertSubscription'][$this->getPrimaryKey()] = true;
        $keys = AlertSubscriptionPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getEntityname(),
            $keys[3] => $this->getEntityfielduniquename(),
            $keys[4] => $this->getAnticipationdays(),
            $keys[5] => $this->getEntitynamefielduniquename(),
            $keys[6] => $this->getExtrarecipients(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aModuleEntity) {
                $result['ModuleEntity'] = $this->aModuleEntity->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aModuleEntityFieldRelatedByEntityfielduniquename) {
                $result['ModuleEntityFieldRelatedByEntityfielduniquename'] = $this->aModuleEntityFieldRelatedByEntityfielduniquename->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aModuleEntityFieldRelatedByEntitynamefielduniquename) {
                $result['ModuleEntityFieldRelatedByEntitynamefielduniquename'] = $this->aModuleEntityFieldRelatedByEntitynamefielduniquename->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collAlertSubscriptionUsers) {
                $result['AlertSubscriptionUsers'] = $this->collAlertSubscriptionUsers->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = AlertSubscriptionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setEntityname($value);
                break;
            case 3:
                $this->setEntityfielduniquename($value);
                break;
            case 4:
                $this->setAnticipationdays($value);
                break;
            case 5:
                $this->setEntitynamefielduniquename($value);
                break;
            case 6:
                $this->setExtrarecipients($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = AlertSubscriptionPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setEntityname($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setEntityfielduniquename($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setAnticipationdays($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setEntitynamefielduniquename($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setExtrarecipients($arr[$keys[6]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(AlertSubscriptionPeer::DATABASE_NAME);

        if ($this->isColumnModified(AlertSubscriptionPeer::ID)) $criteria->add(AlertSubscriptionPeer::ID, $this->id);
        if ($this->isColumnModified(AlertSubscriptionPeer::NAME)) $criteria->add(AlertSubscriptionPeer::NAME, $this->name);
        if ($this->isColumnModified(AlertSubscriptionPeer::ENTITYNAME)) $criteria->add(AlertSubscriptionPeer::ENTITYNAME, $this->entityname);
        if ($this->isColumnModified(AlertSubscriptionPeer::ENTITYFIELDUNIQUENAME)) $criteria->add(AlertSubscriptionPeer::ENTITYFIELDUNIQUENAME, $this->entityfielduniquename);
        if ($this->isColumnModified(AlertSubscriptionPeer::ANTICIPATIONDAYS)) $criteria->add(AlertSubscriptionPeer::ANTICIPATIONDAYS, $this->anticipationdays);
        if ($this->isColumnModified(AlertSubscriptionPeer::ENTITYNAMEFIELDUNIQUENAME)) $criteria->add(AlertSubscriptionPeer::ENTITYNAMEFIELDUNIQUENAME, $this->entitynamefielduniquename);
        if ($this->isColumnModified(AlertSubscriptionPeer::EXTRARECIPIENTS)) $criteria->add(AlertSubscriptionPeer::EXTRARECIPIENTS, $this->extrarecipients);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(AlertSubscriptionPeer::DATABASE_NAME);
        $criteria->add(AlertSubscriptionPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of AlertSubscription (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setEntityname($this->getEntityname());
        $copyObj->setEntityfielduniquename($this->getEntityfielduniquename());
        $copyObj->setAnticipationdays($this->getAnticipationdays());
        $copyObj->setEntitynamefielduniquename($this->getEntitynamefielduniquename());
        $copyObj->setExtrarecipients($this->getExtrarecipients());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getAlertSubscriptionUsers() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addAlertSubscriptionUser($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return AlertSubscription Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return AlertSubscriptionPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new AlertSubscriptionPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a ModuleEntity object.
     *
     * @param             ModuleEntity $v
     * @return AlertSubscription The current object (for fluent API support)
     * @throws PropelException
     */
    public function setModuleEntity(ModuleEntity $v = null)
    {
        if ($v === null) {
            $this->setEntityname(NULL);
        } else {
            $this->setEntityname($v->getName());
        }

        $this->aModuleEntity = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ModuleEntity object, it will not be re-added.
        if ($v !== null) {
            $v->addAlertSubscription($this);
        }


        return $this;
    }


    /**
     * Get the associated ModuleEntity object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return ModuleEntity The associated ModuleEntity object.
     * @throws PropelException
     */
    public function getModuleEntity(PropelPDO $con = null)
    {
        if ($this->aModuleEntity === null && (($this->entityname !== "" && $this->entityname !== null))) {
            $this->aModuleEntity = ModuleEntityQuery::create()->findPk($this->entityname, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aModuleEntity->addAlertSubscriptions($this);
             */
        }

        return $this->aModuleEntity;
    }

    /**
     * Declares an association between this object and a ModuleEntityField object.
     *
     * @param             ModuleEntityField $v
     * @return AlertSubscription The current object (for fluent API support)
     * @throws PropelException
     */
    public function setModuleEntityFieldRelatedByEntityfielduniquename(ModuleEntityField $v = null)
    {
        if ($v === null) {
            $this->setEntityfielduniquename(NULL);
        } else {
            $this->setEntityfielduniquename($v->getUniquename());
        }

        $this->aModuleEntityFieldRelatedByEntityfielduniquename = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ModuleEntityField object, it will not be re-added.
        if ($v !== null) {
            $v->addAlertSubscriptionRelatedByEntityfielduniquename($this);
        }


        return $this;
    }


    /**
     * Get the associated ModuleEntityField object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return ModuleEntityField The associated ModuleEntityField object.
     * @throws PropelException
     */
    public function getModuleEntityFieldRelatedByEntityfielduniquename(PropelPDO $con = null)
    {
        if ($this->aModuleEntityFieldRelatedByEntityfielduniquename === null && (($this->entityfielduniquename !== "" && $this->entityfielduniquename !== null))) {
            $this->aModuleEntityFieldRelatedByEntityfielduniquename = ModuleEntityFieldQuery::create()->findPk($this->entityfielduniquename, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aModuleEntityFieldRelatedByEntityfielduniquename->addAlertSubscriptionsRelatedByEntityfielduniquename($this);
             */
        }

        return $this->aModuleEntityFieldRelatedByEntityfielduniquename;
    }

    /**
     * Declares an association between this object and a ModuleEntityField object.
     *
     * @param             ModuleEntityField $v
     * @return AlertSubscription The current object (for fluent API support)
     * @throws PropelException
     */
    public function setModuleEntityFieldRelatedByEntitynamefielduniquename(ModuleEntityField $v = null)
    {
        if ($v === null) {
            $this->setEntitynamefielduniquename(NULL);
        } else {
            $this->setEntitynamefielduniquename($v->getUniquename());
        }

        $this->aModuleEntityFieldRelatedByEntitynamefielduniquename = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ModuleEntityField object, it will not be re-added.
        if ($v !== null) {
            $v->addAlertSubscriptionRelatedByEntitynamefielduniquename($this);
        }


        return $this;
    }


    /**
     * Get the associated ModuleEntityField object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return ModuleEntityField The associated ModuleEntityField object.
     * @throws PropelException
     */
    public function getModuleEntityFieldRelatedByEntitynamefielduniquename(PropelPDO $con = null)
    {
        if ($this->aModuleEntityFieldRelatedByEntitynamefielduniquename === null && (($this->entitynamefielduniquename !== "" && $this->entitynamefielduniquename !== null))) {
            $this->aModuleEntityFieldRelatedByEntitynamefielduniquename = ModuleEntityFieldQuery::create()->findPk($this->entitynamefielduniquename, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aModuleEntityFieldRelatedByEntitynamefielduniquename->addAlertSubscriptionsRelatedByEntitynamefielduniquename($this);
             */
        }

        return $this->aModuleEntityFieldRelatedByEntitynamefielduniquename;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('AlertSubscriptionUser' == $relationName) {
            $this->initAlertSubscriptionUsers();
        }
    }

    /**
     * Clears out the collAlertSubscriptionUsers collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addAlertSubscriptionUsers()
     */
    public function clearAlertSubscriptionUsers()
    {
        $this->collAlertSubscriptionUsers = null; // important to set this to null since that means it is uninitialized
        $this->collAlertSubscriptionUsersPartial = null;
    }

    /**
     * reset is the collAlertSubscriptionUsers collection loaded partially
     *
     * @return void
     */
    public function resetPartialAlertSubscriptionUsers($v = true)
    {
        $this->collAlertSubscriptionUsersPartial = $v;
    }

    /**
     * Initializes the collAlertSubscriptionUsers collection.
     *
     * By default this just sets the collAlertSubscriptionUsers collection to an empty array (like clearcollAlertSubscriptionUsers());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initAlertSubscriptionUsers($overrideExisting = true)
    {
        if (null !== $this->collAlertSubscriptionUsers && !$overrideExisting) {
            return;
        }
        $this->collAlertSubscriptionUsers = new PropelObjectCollection();
        $this->collAlertSubscriptionUsers->setModel('AlertSubscriptionUser');
    }

    /**
     * Gets an array of AlertSubscriptionUser objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this AlertSubscription is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|AlertSubscriptionUser[] List of AlertSubscriptionUser objects
     * @throws PropelException
     */
    public function getAlertSubscriptionUsers($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collAlertSubscriptionUsersPartial && !$this->isNew();
        if (null === $this->collAlertSubscriptionUsers || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collAlertSubscriptionUsers) {
                // return empty collection
                $this->initAlertSubscriptionUsers();
            } else {
                $collAlertSubscriptionUsers = AlertSubscriptionUserQuery::create(null, $criteria)
                    ->filterByAlertSubscription($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collAlertSubscriptionUsersPartial && count($collAlertSubscriptionUsers)) {
                      $this->initAlertSubscriptionUsers(false);

                      foreach($collAlertSubscriptionUsers as $obj) {
                        if (false == $this->collAlertSubscriptionUsers->contains($obj)) {
                          $this->collAlertSubscriptionUsers->append($obj);
                        }
                      }

                      $this->collAlertSubscriptionUsersPartial = true;
                    }

                    return $collAlertSubscriptionUsers;
                }

                if($partial && $this->collAlertSubscriptionUsers) {
                    foreach($this->collAlertSubscriptionUsers as $obj) {
                        if($obj->isNew()) {
                            $collAlertSubscriptionUsers[] = $obj;
                        }
                    }
                }

                $this->collAlertSubscriptionUsers = $collAlertSubscriptionUsers;
                $this->collAlertSubscriptionUsersPartial = false;
            }
        }

        return $this->collAlertSubscriptionUsers;
    }

    /**
     * Sets a collection of AlertSubscriptionUser objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $alertSubscriptionUsers A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setAlertSubscriptionUsers(PropelCollection $alertSubscriptionUsers, PropelPDO $con = null)
    {
        $this->alertSubscriptionUsersScheduledForDeletion = $this->getAlertSubscriptionUsers(new Criteria(), $con)->diff($alertSubscriptionUsers);

        foreach ($this->alertSubscriptionUsersScheduledForDeletion as $alertSubscriptionUserRemoved) {
            $alertSubscriptionUserRemoved->setAlertSubscription(null);
        }

        $this->collAlertSubscriptionUsers = null;
        foreach ($alertSubscriptionUsers as $alertSubscriptionUser) {
            $this->addAlertSubscriptionUser($alertSubscriptionUser);
        }

        $this->collAlertSubscriptionUsers = $alertSubscriptionUsers;
        $this->collAlertSubscriptionUsersPartial = false;
    }

    /**
     * Returns the number of related AlertSubscriptionUser objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related AlertSubscriptionUser objects.
     * @throws PropelException
     */
    public function countAlertSubscriptionUsers(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collAlertSubscriptionUsersPartial && !$this->isNew();
        if (null === $this->collAlertSubscriptionUsers || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collAlertSubscriptionUsers) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getAlertSubscriptionUsers());
                }
                $query = AlertSubscriptionUserQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByAlertSubscription($this)
                    ->count($con);
            }
        } else {
            return count($this->collAlertSubscriptionUsers);
        }
    }

    /**
     * Method called to associate a AlertSubscriptionUser object to this object
     * through the AlertSubscriptionUser foreign key attribute.
     *
     * @param    AlertSubscriptionUser $l AlertSubscriptionUser
     * @return AlertSubscription The current object (for fluent API support)
     */
    public function addAlertSubscriptionUser(AlertSubscriptionUser $l)
    {
        if ($this->collAlertSubscriptionUsers === null) {
            $this->initAlertSubscriptionUsers();
            $this->collAlertSubscriptionUsersPartial = true;
        }
        if (!$this->collAlertSubscriptionUsers->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddAlertSubscriptionUser($l);
        }

        return $this;
    }

    /**
     * @param	AlertSubscriptionUser $alertSubscriptionUser The alertSubscriptionUser object to add.
     */
    protected function doAddAlertSubscriptionUser($alertSubscriptionUser)
    {
        $this->collAlertSubscriptionUsers[]= $alertSubscriptionUser;
        $alertSubscriptionUser->setAlertSubscription($this);
    }

    /**
     * @param	AlertSubscriptionUser $alertSubscriptionUser The alertSubscriptionUser object to remove.
     */
    public function removeAlertSubscriptionUser($alertSubscriptionUser)
    {
        if ($this->getAlertSubscriptionUsers()->contains($alertSubscriptionUser)) {
            $this->collAlertSubscriptionUsers->remove($this->collAlertSubscriptionUsers->search($alertSubscriptionUser));
            if (null === $this->alertSubscriptionUsersScheduledForDeletion) {
                $this->alertSubscriptionUsersScheduledForDeletion = clone $this->collAlertSubscriptionUsers;
                $this->alertSubscriptionUsersScheduledForDeletion->clear();
            }
            $this->alertSubscriptionUsersScheduledForDeletion[]= $alertSubscriptionUser;
            $alertSubscriptionUser->setAlertSubscription(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this AlertSubscription is new, it will return
     * an empty collection; or if this AlertSubscription has previously
     * been saved, it will retrieve related AlertSubscriptionUsers from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in AlertSubscription.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|AlertSubscriptionUser[] List of AlertSubscriptionUser objects
     */
    public function getAlertSubscriptionUsersJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = AlertSubscriptionUserQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getAlertSubscriptionUsers($query, $con);
    }

    /**
     * Clears out the collUsers collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addUsers()
     */
    public function clearUsers()
    {
        $this->collUsers = null; // important to set this to null since that means it is uninitialized
        $this->collUsersPartial = null;
    }

    /**
     * Initializes the collUsers collection.
     *
     * By default this just sets the collUsers collection to an empty collection (like clearUsers());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initUsers()
    {
        $this->collUsers = new PropelObjectCollection();
        $this->collUsers->setModel('User');
    }

    /**
     * Gets a collection of User objects related by a many-to-many relationship
     * to the current object by way of the common_alertSubscriptionUser cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this AlertSubscription is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|User[] List of User objects
     */
    public function getUsers($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collUsers || null !== $criteria) {
            if ($this->isNew() && null === $this->collUsers) {
                // return empty collection
                $this->initUsers();
            } else {
                $collUsers = UserQuery::create(null, $criteria)
                    ->filterByAlertSubscription($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collUsers;
                }
                $this->collUsers = $collUsers;
            }
        }

        return $this->collUsers;
    }

    /**
     * Sets a collection of User objects related by a many-to-many relationship
     * to the current object by way of the common_alertSubscriptionUser cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $users A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setUsers(PropelCollection $users, PropelPDO $con = null)
    {
        $this->clearUsers();
        $currentUsers = $this->getUsers();

        $this->usersScheduledForDeletion = $currentUsers->diff($users);

        foreach ($users as $user) {
            if (!$currentUsers->contains($user)) {
                $this->doAddUser($user);
            }
        }

        $this->collUsers = $users;
    }

    /**
     * Gets the number of User objects related by a many-to-many relationship
     * to the current object by way of the common_alertSubscriptionUser cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related User objects
     */
    public function countUsers($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collUsers || null !== $criteria) {
            if ($this->isNew() && null === $this->collUsers) {
                return 0;
            } else {
                $query = UserQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByAlertSubscription($this)
                    ->count($con);
            }
        } else {
            return count($this->collUsers);
        }
    }

    /**
     * Associate a User object to this object
     * through the common_alertSubscriptionUser cross reference table.
     *
     * @param  User $user The AlertSubscriptionUser object to relate
     * @return void
     */
    public function addUser(User $user)
    {
        if ($this->collUsers === null) {
            $this->initUsers();
        }
        if (!$this->collUsers->contains($user)) { // only add it if the **same** object is not already associated
            $this->doAddUser($user);

            $this->collUsers[]= $user;
        }
    }

    /**
     * @param	User $user The user object to add.
     */
    protected function doAddUser($user)
    {
        $alertSubscriptionUser = new AlertSubscriptionUser();
        $alertSubscriptionUser->setUser($user);
        $this->addAlertSubscriptionUser($alertSubscriptionUser);
    }

    /**
     * Remove a User object to this object
     * through the common_alertSubscriptionUser cross reference table.
     *
     * @param User $user The AlertSubscriptionUser object to relate
     * @return void
     */
    public function removeUser(User $user)
    {
        if ($this->getUsers()->contains($user)) {
            $this->collUsers->remove($this->collUsers->search($user));
            if (null === $this->usersScheduledForDeletion) {
                $this->usersScheduledForDeletion = clone $this->collUsers;
                $this->usersScheduledForDeletion->clear();
            }
            $this->usersScheduledForDeletion[]= $user;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->entityname = null;
        $this->entityfielduniquename = null;
        $this->anticipationdays = null;
        $this->entitynamefielduniquename = null;
        $this->extrarecipients = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collAlertSubscriptionUsers) {
                foreach ($this->collAlertSubscriptionUsers as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collUsers) {
                foreach ($this->collUsers as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collAlertSubscriptionUsers instanceof PropelCollection) {
            $this->collAlertSubscriptionUsers->clearIterator();
        }
        $this->collAlertSubscriptionUsers = null;
        if ($this->collUsers instanceof PropelCollection) {
            $this->collUsers->clearIterator();
        }
        $this->collUsers = null;
        $this->aModuleEntity = null;
        $this->aModuleEntityFieldRelatedByEntityfielduniquename = null;
        $this->aModuleEntityFieldRelatedByEntitynamefielduniquename = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(AlertSubscriptionPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
