<?php

/**
 * CommonConfigSetAction
 * Muestra el formulario de configuracion del sistema
 * Toma como base la union del config.xml con el config.local.xml
 *
 * @package config
 */

class CommonConfigSetAction extends BaseAction
{

    protected function exec() {
        parent::exec();

        //timezone
        $timezonePeer = new TimezonePeer();
        $this->smarty->assign('timezones', $timezonePeer->getAll());

        $this->smarty->assign('colorCodes', array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10));

        $this->smarty->assign('languages', common::getAllLanguages());

        $this->smarty->assign('selectedModule', $_GET['module']);

        global $system;
        if (!empty($_GET['module']))
            $this->smarty->assign('config', $system['config'][$_GET['module']]);

        if (class_exists('ModuleQuery'))
            $activeModules = ModuleQuery::create()->select('Name')->filterByActive('1')->find()->toArray();
        else
            $activeModules = array();

        $activeModules = array_merge(array('system', 'email'), $activeModules);

        $this->smarty->assign('modules', array_intersect($activeModules, array_keys($system['config'])));

    }

}
