<?php


/**
 * Base class that represents a query for the 'campaigns_campaignParticipant' table.
 *
 * Base de participantes en campaignes
 *
 * @method CampaignParticipantQuery orderById($order = Criteria::ASC) Order by the id column
 * @method CampaignParticipantQuery orderByCampaignid($order = Criteria::ASC) Order by the campaignId column
 * @method CampaignParticipantQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method CampaignParticipantQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 *
 * @method CampaignParticipantQuery groupById() Group by the id column
 * @method CampaignParticipantQuery groupByCampaignid() Group by the campaignId column
 * @method CampaignParticipantQuery groupByObjecttype() Group by the objectType column
 * @method CampaignParticipantQuery groupByObjectid() Group by the objectId column
 *
 * @method CampaignParticipantQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method CampaignParticipantQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method CampaignParticipantQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method CampaignParticipantQuery leftJoinCampaign($relationAlias = null) Adds a LEFT JOIN clause to the query using the Campaign relation
 * @method CampaignParticipantQuery rightJoinCampaign($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Campaign relation
 * @method CampaignParticipantQuery innerJoinCampaign($relationAlias = null) Adds a INNER JOIN clause to the query using the Campaign relation
 *
 * @method CampaignParticipantQuery leftJoinCampaignCommitment($relationAlias = null) Adds a LEFT JOIN clause to the query using the CampaignCommitment relation
 * @method CampaignParticipantQuery rightJoinCampaignCommitment($relationAlias = null) Adds a RIGHT JOIN clause to the query using the CampaignCommitment relation
 * @method CampaignParticipantQuery innerJoinCampaignCommitment($relationAlias = null) Adds a INNER JOIN clause to the query using the CampaignCommitment relation
 *
 * @method CampaignParticipant findOne(PropelPDO $con = null) Return the first CampaignParticipant matching the query
 * @method CampaignParticipant findOneOrCreate(PropelPDO $con = null) Return the first CampaignParticipant matching the query, or a new CampaignParticipant object populated from the query conditions when no match is found
 *
 * @method CampaignParticipant findOneById(int $id) Return the first CampaignParticipant filtered by the id column
 * @method CampaignParticipant findOneByCampaignid(int $campaignId) Return the first CampaignParticipant filtered by the campaignId column
 * @method CampaignParticipant findOneByObjecttype(string $objectType) Return the first CampaignParticipant filtered by the objectType column
 * @method CampaignParticipant findOneByObjectid(int $objectId) Return the first CampaignParticipant filtered by the objectId column
 *
 * @method array findById(int $id) Return CampaignParticipant objects filtered by the id column
 * @method array findByCampaignid(int $campaignId) Return CampaignParticipant objects filtered by the campaignId column
 * @method array findByObjecttype(string $objectType) Return CampaignParticipant objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return CampaignParticipant objects filtered by the objectId column
 *
 * @package    propel.generator.campaigns.classes.om
 */
abstract class BaseCampaignParticipantQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseCampaignParticipantQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'CampaignParticipant', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new CampaignParticipantQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     CampaignParticipantQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return CampaignParticipantQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof CampaignParticipantQuery) {
            return $criteria;
        }
        $query = new CampaignParticipantQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   CampaignParticipant|CampaignParticipant[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = CampaignParticipantPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(CampaignParticipantPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   CampaignParticipant A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `CAMPAIGNID`, `OBJECTTYPE`, `OBJECTID` FROM `campaigns_campaignParticipant` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new CampaignParticipant();
            $obj->hydrate($row);
            CampaignParticipantPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return CampaignParticipant|CampaignParticipant[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|CampaignParticipant[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(CampaignParticipantPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(CampaignParticipantPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(CampaignParticipantPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the campaignId column
     *
     * Example usage:
     * <code>
     * $query->filterByCampaignid(1234); // WHERE campaignId = 1234
     * $query->filterByCampaignid(array(12, 34)); // WHERE campaignId IN (12, 34)
     * $query->filterByCampaignid(array('min' => 12)); // WHERE campaignId > 12
     * </code>
     *
     * @see       filterByCampaign()
     *
     * @param     mixed $campaignid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function filterByCampaignid($campaignid = null, $comparison = null)
    {
        if (is_array($campaignid)) {
            $useMinMax = false;
            if (isset($campaignid['min'])) {
                $this->addUsingAlias(CampaignParticipantPeer::CAMPAIGNID, $campaignid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($campaignid['max'])) {
                $this->addUsingAlias(CampaignParticipantPeer::CAMPAIGNID, $campaignid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignParticipantPeer::CAMPAIGNID, $campaignid, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(CampaignParticipantPeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(CampaignParticipantPeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(CampaignParticipantPeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(CampaignParticipantPeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query by a related Campaign object
     *
     * @param   Campaign|PropelObjectCollection $campaign The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   CampaignParticipantQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCampaign($campaign, $comparison = null)
    {
        if ($campaign instanceof Campaign) {
            return $this
                ->addUsingAlias(CampaignParticipantPeer::CAMPAIGNID, $campaign->getId(), $comparison);
        } elseif ($campaign instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(CampaignParticipantPeer::CAMPAIGNID, $campaign->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCampaign() only accepts arguments of type Campaign or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Campaign relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function joinCampaign($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Campaign');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Campaign');
        }

        return $this;
    }

    /**
     * Use the Campaign relation Campaign object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CampaignQuery A secondary query class using the current class as primary query
     */
    public function useCampaignQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCampaign($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Campaign', 'CampaignQuery');
    }

    /**
     * Filter the query by a related CampaignCommitment object
     *
     * @param   CampaignCommitment|PropelObjectCollection $campaignCommitment  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   CampaignParticipantQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByCampaignCommitment($campaignCommitment, $comparison = null)
    {
        if ($campaignCommitment instanceof CampaignCommitment) {
            return $this
                ->addUsingAlias(CampaignParticipantPeer::ID, $campaignCommitment->getParticipantid(), $comparison);
        } elseif ($campaignCommitment instanceof PropelObjectCollection) {
            return $this
                ->useCampaignCommitmentQuery()
                ->filterByPrimaryKeys($campaignCommitment->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByCampaignCommitment() only accepts arguments of type CampaignCommitment or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the CampaignCommitment relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function joinCampaignCommitment($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('CampaignCommitment');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'CampaignCommitment');
        }

        return $this;
    }

    /**
     * Use the CampaignCommitment relation CampaignCommitment object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   CampaignCommitmentQuery A secondary query class using the current class as primary query
     */
    public function useCampaignCommitmentQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinCampaignCommitment($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'CampaignCommitment', 'CampaignCommitmentQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   CampaignParticipant $campaignParticipant Object to remove from the list of results
     *
     * @return CampaignParticipantQuery The current query, for fluid interface
     */
    public function prune($campaignParticipant = null)
    {
        if ($campaignParticipant) {
            $this->addUsingAlias(CampaignParticipantPeer::ID, $campaignParticipant->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
