<?php


/**
 * Base class that represents a query for the 'actors_relations' table.
 *
 * Tabla de relaciones de actores
 *
 * @method ActorRelationQuery orderByActorfromid($order = Criteria::ASC) Order by the actorFromId column
 * @method ActorRelationQuery orderByActortoid($order = Criteria::ASC) Order by the actorToId column
 * @method ActorRelationQuery orderByQuestionid($order = Criteria::ASC) Order by the questionId column
 * @method ActorRelationQuery orderByDirection($order = Criteria::ASC) Order by the direction column
 * @method ActorRelationQuery orderByCurrent($order = Criteria::ASC) Order by the current column
 * @method ActorRelationQuery orderByPotential($order = Criteria::ASC) Order by the potential column
 *
 * @method ActorRelationQuery groupByActorfromid() Group by the actorFromId column
 * @method ActorRelationQuery groupByActortoid() Group by the actorToId column
 * @method ActorRelationQuery groupByQuestionid() Group by the questionId column
 * @method ActorRelationQuery groupByDirection() Group by the direction column
 * @method ActorRelationQuery groupByCurrent() Group by the current column
 * @method ActorRelationQuery groupByPotential() Group by the potential column
 *
 * @method ActorRelationQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ActorRelationQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ActorRelationQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ActorRelationQuery leftJoinActor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Actor relation
 * @method ActorRelationQuery rightJoinActor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Actor relation
 * @method ActorRelationQuery innerJoinActor($relationAlias = null) Adds a INNER JOIN clause to the query using the Actor relation
 *
 * @method ActorRelationQuery leftJoinProfileForm($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProfileForm relation
 * @method ActorRelationQuery rightJoinProfileForm($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProfileForm relation
 * @method ActorRelationQuery innerJoinProfileForm($relationAlias = null) Adds a INNER JOIN clause to the query using the ProfileForm relation
 *
 * @method ActorRelation findOne(PropelPDO $con = null) Return the first ActorRelation matching the query
 * @method ActorRelation findOneOrCreate(PropelPDO $con = null) Return the first ActorRelation matching the query, or a new ActorRelation object populated from the query conditions when no match is found
 *
 * @method ActorRelation findOneByActorfromid(int $actorFromId) Return the first ActorRelation filtered by the actorFromId column
 * @method ActorRelation findOneByActortoid(int $actorToId) Return the first ActorRelation filtered by the actorToId column
 * @method ActorRelation findOneByQuestionid(int $questionId) Return the first ActorRelation filtered by the questionId column
 * @method ActorRelation findOneByDirection(boolean $direction) Return the first ActorRelation filtered by the direction column
 * @method ActorRelation findOneByCurrent(string $current) Return the first ActorRelation filtered by the current column
 * @method ActorRelation findOneByPotential(string $potential) Return the first ActorRelation filtered by the potential column
 *
 * @method array findByActorfromid(int $actorFromId) Return ActorRelation objects filtered by the actorFromId column
 * @method array findByActortoid(int $actorToId) Return ActorRelation objects filtered by the actorToId column
 * @method array findByQuestionid(int $questionId) Return ActorRelation objects filtered by the questionId column
 * @method array findByDirection(boolean $direction) Return ActorRelation objects filtered by the direction column
 * @method array findByCurrent(string $current) Return ActorRelation objects filtered by the current column
 * @method array findByPotential(string $potential) Return ActorRelation objects filtered by the potential column
 *
 * @package    propel.generator.actors.classes.om
 */
abstract class BaseActorRelationQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseActorRelationQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ActorRelation', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ActorRelationQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ActorRelationQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ActorRelationQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ActorRelationQuery) {
            return $criteria;
        }
        $query = new ActorRelationQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34, 56), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$actorFromId, $actorToId, $questionId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ActorRelation|ActorRelation[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ActorRelationPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1], (string) $key[2]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ActorRelationPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ActorRelation A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ACTORFROMID`, `ACTORTOID`, `QUESTIONID`, `DIRECTION`, `CURRENT`, `POTENTIAL` FROM `actors_relations` WHERE `ACTORFROMID` = :p0 AND `ACTORTOID` = :p1 AND `QUESTIONID` = :p2';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->bindValue(':p2', $key[2], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ActorRelation();
            $obj->hydrate($row);
            ActorRelationPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1], (string) $key[2])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ActorRelation|ActorRelation[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ActorRelation[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ActorRelationPeer::ACTORFROMID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ActorRelationPeer::ACTORTOID, $key[1], Criteria::EQUAL);
        $this->addUsingAlias(ActorRelationPeer::QUESTIONID, $key[2], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ActorRelationPeer::ACTORFROMID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ActorRelationPeer::ACTORTOID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $cton2 = $this->getNewCriterion(ActorRelationPeer::QUESTIONID, $key[2], Criteria::EQUAL);
            $cton0->addAnd($cton2);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the actorFromId column
     *
     * Example usage:
     * <code>
     * $query->filterByActorfromid(1234); // WHERE actorFromId = 1234
     * $query->filterByActorfromid(array(12, 34)); // WHERE actorFromId IN (12, 34)
     * $query->filterByActorfromid(array('min' => 12)); // WHERE actorFromId > 12
     * </code>
     *
     * @see       filterByActor()
     *
     * @param     mixed $actorfromid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function filterByActorfromid($actorfromid = null, $comparison = null)
    {
        if (is_array($actorfromid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActorRelationPeer::ACTORFROMID, $actorfromid, $comparison);
    }

    /**
     * Filter the query on the actorToId column
     *
     * Example usage:
     * <code>
     * $query->filterByActortoid(1234); // WHERE actorToId = 1234
     * $query->filterByActortoid(array(12, 34)); // WHERE actorToId IN (12, 34)
     * $query->filterByActortoid(array('min' => 12)); // WHERE actorToId > 12
     * </code>
     *
     * @see       filterByActor()
     *
     * @param     mixed $actortoid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function filterByActortoid($actortoid = null, $comparison = null)
    {
        if (is_array($actortoid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActorRelationPeer::ACTORTOID, $actortoid, $comparison);
    }

    /**
     * Filter the query on the questionId column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestionid(1234); // WHERE questionId = 1234
     * $query->filterByQuestionid(array(12, 34)); // WHERE questionId IN (12, 34)
     * $query->filterByQuestionid(array('min' => 12)); // WHERE questionId > 12
     * </code>
     *
     * @see       filterByProfileForm()
     *
     * @param     mixed $questionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function filterByQuestionid($questionid = null, $comparison = null)
    {
        if (is_array($questionid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ActorRelationPeer::QUESTIONID, $questionid, $comparison);
    }

    /**
     * Filter the query on the direction column
     *
     * Example usage:
     * <code>
     * $query->filterByDirection(true); // WHERE direction = true
     * $query->filterByDirection('yes'); // WHERE direction = true
     * </code>
     *
     * @param     boolean|string $direction The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function filterByDirection($direction = null, $comparison = null)
    {
        if (is_string($direction)) {
            $direction = in_array(strtolower($direction), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ActorRelationPeer::DIRECTION, $direction, $comparison);
    }

    /**
     * Filter the query on the current column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrent('fooValue');   // WHERE current = 'fooValue'
     * $query->filterByCurrent('%fooValue%'); // WHERE current LIKE '%fooValue%'
     * </code>
     *
     * @param     string $current The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function filterByCurrent($current = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($current)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $current)) {
                $current = str_replace('*', '%', $current);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorRelationPeer::CURRENT, $current, $comparison);
    }

    /**
     * Filter the query on the potential column
     *
     * Example usage:
     * <code>
     * $query->filterByPotential('fooValue');   // WHERE potential = 'fooValue'
     * $query->filterByPotential('%fooValue%'); // WHERE potential LIKE '%fooValue%'
     * </code>
     *
     * @param     string $potential The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function filterByPotential($potential = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($potential)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $potential)) {
                $potential = str_replace('*', '%', $potential);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ActorRelationPeer::POTENTIAL, $potential, $comparison);
    }

    /**
     * Filter the query by a related Actor object
     *
     * @param   Actor $actor The related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorRelationQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByActor($actor, $comparison = null)
    {
        if ($actor instanceof Actor) {
            return $this
                ->addUsingAlias(ActorRelationPeer::ACTORFROMID, $actor->getId(), $comparison)
                ->addUsingAlias(ActorRelationPeer::ACTORTOID, $actor->getId(), $comparison);
        } else {
            throw new PropelException('filterByActor() only accepts arguments of type Actor');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Actor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function joinActor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Actor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Actor');
        }

        return $this;
    }

    /**
     * Use the Actor relation Actor object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ActorQuery A secondary query class using the current class as primary query
     */
    public function useActorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinActor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Actor', 'ActorQuery');
    }

    /**
     * Filter the query by a related ProfileForm object
     *
     * @param   ProfileForm|PropelObjectCollection $profileForm The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ActorRelationQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProfileForm($profileForm, $comparison = null)
    {
        if ($profileForm instanceof ProfileForm) {
            return $this
                ->addUsingAlias(ActorRelationPeer::QUESTIONID, $profileForm->getId(), $comparison);
        } elseif ($profileForm instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ActorRelationPeer::QUESTIONID, $profileForm->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProfileForm() only accepts arguments of type ProfileForm or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProfileForm relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function joinProfileForm($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProfileForm');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProfileForm');
        }

        return $this;
    }

    /**
     * Use the ProfileForm relation ProfileForm object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProfileFormQuery A secondary query class using the current class as primary query
     */
    public function useProfileFormQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProfileForm($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProfileForm', 'ProfileFormQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ActorRelation $actorRelation Object to remove from the list of results
     *
     * @return ActorRelationQuery The current query, for fluid interface
     */
    public function prune($actorRelation = null)
    {
        if ($actorRelation) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ActorRelationPeer::ACTORFROMID), $actorRelation->getActorfromid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ActorRelationPeer::ACTORTOID), $actorRelation->getActortoid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond2', $this->getAliasedColName(ActorRelationPeer::QUESTIONID), $actorRelation->getQuestionid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1', 'pruneCond2'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
