<?php

namespace Egytca\Status\OnTheFly\Query;

use ConfigModule;
use Criteria;
use DateTime;
use Egytca\Statements\StringStatement as StmntString;
use Egytca\Statements\Factory as StmntFactory;

trait FinishedVsDueDateStatusQuery {

	use StatusQuery;

	private function statusUndefinedOnlyPart() {
		$peer = $this->getModelPeerName();
		$dueDateColumn = new StmntString($peer::DUEDATE);
		return StmntFactory::create($dueDateColumn, 'IS NULL');
	}

	function statementForStatusUndefined($comparison = Criteria::EQUAL) {
		$statement = $this->statusUndefinedOnlyPart();
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusUndefined($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusUndefined($comparison)->toString());
	}

	private function statusFinishedOnlyPart() {
		$peer = $this->getModelPeerName();
		$finishedDateColumn = new StmntString($peer::FINISHEDDATE);
		return StmntFactory::create($finishedDateColumn, 'IS NOT NULL');
	}

	function statementForStatusFinished($comparison = Criteria::EQUAL) {
		$statement = $this->statusUndefinedOnlyPart()->invert()
			->andWith($this->statusFinishedOnlyPart());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusFinished($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusFinished($comparison)->toString());
	}

	private function statusPlannedOnlyPart() {
		$peer = $this->getModelPeerName();
		$dueDateColumn = new StmntString($peer::DUEDATE);
		$today = new StmntString(date("'Y-m-d'")); // single quotes included
		return StmntFactory::create($dueDateColumn, '>', $today);
	}

	function statementForStatusPlanned($comparison = Criteria::EQUAL) {
		$statement = $this->statusUndefinedOnlyPart()->invert()
			->andWith($this->statusFinishedOnlyPart()->invert())
			->andWith($this->statusPlannedOnlyPart());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusPlanned($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusPlanned($comparison)->toString());
	}

	private function statusOntimeOnlyPart() {

		$peer = $this->getModelPeerName();
		$dueDateColumn = new StmntString($peer::DUEDATE);

		$today = new DateTime();
		$ontimeTolerance = ConfigModule::get('indicators', 'timeTolerances')['ontime'];
		$todayMinusTolerance = $today->modify(preg_replace('/^\+/', '-', $ontimeTolerance))->format('Y-m-d');
		$todayMinusToleranceSqlString = new StmntString("'$todayMinusTolerance'"); // single quotes included

		return StmntFactory::create($dueDateColumn, '>=', $todayMinusToleranceSqlString);
	}

	function statementForStatusOntime($comparison = Criteria::EQUAL) {
		$statement = $this->statusUndefinedOnlyPart()->invert()
			->andWith($this->statusFinishedOnlyPart()->invert())
			->andWith($this->statusPlannedOnlyPart()->invert())
			->andWith($this->statusOntimeOnlyPart());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusOntime($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusOntime($comparison)->toString());
	}

	private function statusDelayedOnlyPart() {

		$peer = $this->getModelPeerName();
		$dueDateColumn = new StmntString($peer::DUEDATE);

		$today = new DateTime();
		$delayedTolerance = ConfigModule::get('indicators', 'timeTolerances')['delayed'];
		$todayMinusTolerance = $today->modify(preg_replace('/^\+/', '-', $delayedTolerance))->format('Y-m-d');
		$todayMinusToleranceSqlString = new StmntString("'$todayMinusTolerance'"); // single quotes included

		return StmntFactory::create($dueDateColumn, '>=', $todayMinusToleranceSqlString);
	}

	function statementForStatusDelayed($comparison = Criteria::EQUAL) {
		$statement = $this->statusUndefinedOnlyPart()->invert()
			->andWith($this->statusFinishedOnlyPart()->invert())
			->andWith($this->statusPlannedOnlyPart()->invert())
			->andWith($this->statusOntimeOnlyPart()->invert())
			->andWith($this->statusDelayedOnlyPart());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusDelayed($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusDelayed($comparison)->toString());
	}

	function statementForStatusLate($comparison = Criteria::EQUAL) {
		$statement = $this->statusUndefinedOnlyPart()->invert()
			->andWith($this->statusFinishedOnlyPart()->invert())
			->andWith($this->statusPlannedOnlyPart()->invert())
			->andWith($this->statusOntimeOnlyPart()->invert())
			->andWith($this->statusDelayedOnlyPart()->invert());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusLate($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusLate($comparison)->toString());
	}
}
