<?php

namespace Egytca;

use Exception;

trait GlobalObject {

	private static $object;

	static function __callStatic($methodName, $args) {

		if (!self::$object)
			throw new Exception('object needed. Set one with '.__CLASS__.'::setObject()');

		$errorMethodName = get_class(self::$object).'::'.$methodName.'()';
		if (!method_exists(self::$object, $methodName))
			throw new Exception("call to unknown method $errorMethodName");

		return call_user_func([self::$object, $methodName], $args);
	}

	static function getObject() {
		return self::$object;
	}

	static function setObject($object) {
		self::$object = $object;
	}
}