<?php

/**
 * Data object containing the SQL and PHP code to migrate the database
 * up to version 1531760322.
 * Generated on 2018-07-16 16:58:42 by pdigital
 */
class PropelMigration_1531760322
{

    public function preUp($manager)
    {
        // add the pre-migration code here
    }

    public function postUp($manager)
    {
        // add the post-migration code here
    }

    public function preDown($manager)
    {
        // add the pre-migration code here
    }

    public function postDown($manager)
    {
        // add the post-migration code here
    }

    /**
     * Get the SQL statements for the Up migration
     *
     * @return array list of the SQL strings to execute for the Up migration
     *               the keys being the datasources
     */
    public function getUpSQL()
    {
        return array (
  'application' => '
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

ALTER TABLE `actionLogs_log` ADD CONSTRAINT `actionLogs_log_FK_1`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `actionLogs_log` ADD CONSTRAINT `actionLogs_log_FK_2`
    FOREIGN KEY (`action`)
    REFERENCES `security_action` (`action`);

ALTER TABLE `actors_activeQuestions` ADD CONSTRAINT `actors_activeQuestions_FK_1`
    FOREIGN KEY (`actorId`)
    REFERENCES `actors_actor` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_activeQuestions` ADD CONSTRAINT `actors_activeQuestions_FK_2`
    FOREIGN KEY (`questionId`)
    REFERENCES `actors_profileForm` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_activeRelationQuestions` ADD CONSTRAINT `actors_activeRelationQuestions_FK_1`
    FOREIGN KEY (`actorFromId`,`actorToId`)
    REFERENCES `actors_actor` (`id`,`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_activeRelationQuestions` ADD CONSTRAINT `actors_activeRelationQuestions_FK_2`
    FOREIGN KEY (`questionId`)
    REFERENCES `actors_profileForm` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_actorsCategory` ADD CONSTRAINT `actors_actorsCategory_FK_1`
    FOREIGN KEY (`actorId`)
    REFERENCES `actors_actor` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_actorsCategory` ADD CONSTRAINT `actors_actorsCategory_FK_2`
    FOREIGN KEY (`categoryId`)
    REFERENCES `actors_category` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_formAnswer` ADD CONSTRAINT `actors_formAnswer_FK_1`
    FOREIGN KEY (`actorId`)
    REFERENCES `actors_actor` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_formAnswer` ADD CONSTRAINT `actors_formAnswer_FK_2`
    FOREIGN KEY (`questionId`)
    REFERENCES `actors_profileForm` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_profileForm` CHANGE `relationship` `relationship` BOOL DEFAULT 0 NOT NULL COMMENT \'Is this form a relationship form?\';

ALTER TABLE `actors_profileForm` CHANGE `inAnalysis` `inAnalysis` BOOL DEFAULT 0 COMMENT \'Aparece la pregunta en analysis?\';

ALTER TABLE `actors_profileFormQuestionOption` CHANGE `defaultOpc` `defaultOpc` BOOL;

ALTER TABLE `actors_profileFormQuestionOption` ADD CONSTRAINT `actors_profileFormQuestionOption_FK_1`
    FOREIGN KEY (`formId`)
    REFERENCES `actors_profileForm` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_relations` CHANGE `direction` `direction` BOOL NOT NULL COMMENT \'Direccion de la relacion\';

ALTER TABLE `actors_relations` ADD CONSTRAINT `actors_relations_FK_1`
    FOREIGN KEY (`actorFromId`,`actorToId`)
    REFERENCES `actors_actor` (`id`,`id`)
    ON DELETE CASCADE;

ALTER TABLE `actors_relations` ADD CONSTRAINT `actors_relations_FK_2`
    FOREIGN KEY (`questionId`)
    REFERENCES `actors_profileForm` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `campaigns_campaign` CHANGE `searchQueries` `searchQueries` TEXT COMMENT \'Busquedas\';

ALTER TABLE `campaigns_campaignCommitment` CHANGE `achieved` `achieved` BOOL COMMENT \'Logrado\';

ALTER TABLE `campaigns_campaignCommitment` ADD CONSTRAINT `campaigns_campaignCommitment_FK_1`
    FOREIGN KEY (`campaignId`)
    REFERENCES `campaigns_campaign` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `campaigns_campaignCommitment` ADD CONSTRAINT `campaigns_campaignCommitment_FK_2`
    FOREIGN KEY (`participantId`)
    REFERENCES `campaigns_campaignParticipant` (`id`);

ALTER TABLE `campaigns_campaignDocument` ADD CONSTRAINT `campaigns_campaignDocument_FK_1`
    FOREIGN KEY (`campaignId`)
    REFERENCES `campaigns_campaign` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `campaigns_campaignDocument` ADD CONSTRAINT `campaigns_campaignDocument_FK_2`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `campaigns_campaignParticipant` ADD CONSTRAINT `campaigns_campaignParticipant_FK_1`
    FOREIGN KEY (`campaignId`)
    REFERENCES `campaigns_campaign` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `categories_category` CHANGE `isPublic` `isPublic` TINYINT(1) DEFAULT 0 NOT NULL COMMENT \'Is category public?\';

ALTER TABLE `common_alertSubscription` ADD CONSTRAINT `common_alertSubscription_FK_1`
    FOREIGN KEY (`entityName`)
    REFERENCES `modules_entity` (`name`)
    ON DELETE CASCADE;

ALTER TABLE `common_alertSubscription` ADD CONSTRAINT `common_alertSubscription_FK_2`
    FOREIGN KEY (`entityFieldUniqueName`)
    REFERENCES `modules_entityField` (`uniqueName`)
    ON DELETE CASCADE;

ALTER TABLE `common_alertSubscription` ADD CONSTRAINT `common_alertSubscription_FK_3`
    FOREIGN KEY (`entityNameFieldUniqueName`)
    REFERENCES `modules_entityField` (`uniqueName`)
    ON DELETE CASCADE;

ALTER TABLE `common_alertSubscriptionUser` ADD CONSTRAINT `common_alertSubscriptionUser_FK_1`
    FOREIGN KEY (`alertSubscriptionId`)
    REFERENCES `common_alertSubscription` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `common_alertSubscriptionUser` ADD CONSTRAINT `common_alertSubscriptionUser_FK_2`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `common_internalMail` ADD CONSTRAINT `common_internalMail_FK_1`
    FOREIGN KEY (`replyId`)
    REFERENCES `common_internalMail` (`id`);

ALTER TABLE `common_menuItem` CHANGE `newWindow` `newWindow` BOOL DEFAULT 0 NOT NULL COMMENT \'Abrir el enlace en nueva ventana\';

ALTER TABLE `common_menuItemInfo` ADD CONSTRAINT `common_menuItemInfo_FK_1`
    FOREIGN KEY (`menuItemId`)
    REFERENCES `common_menuItem` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_construction` CHANGE `latitude` `latitude` DECIMAL(12,9) COMMENT \'latitud\';

ALTER TABLE `constructions_construction` CHANGE `longitude` `longitude` DECIMAL(12,9) COMMENT \'longitud\';

ALTER TABLE `constructions_construction` CHANGE `stage` `stage` TINYINT COMMENT \'Etapa de obra\';

ALTER TABLE `constructions_construction` CHANGE `inaugurated` `inaugurated` BOOL DEFAULT 0 COMMENT \'Inaugurada\';

ALTER TABLE `constructions_construction` ADD CONSTRAINT `constructions_construction_FK_1`
    FOREIGN KEY (`proyectId`)
    REFERENCES `projects_project` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_construction` ADD CONSTRAINT `constructions_construction_FK_2`
    FOREIGN KEY (`categoryId`)
    REFERENCES `categories_category` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_construction` ADD CONSTRAINT `constructions_construction_FK_3`
    FOREIGN KEY (`regionId`)
    REFERENCES `regions_region` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_inspection` CHANGE `workshop` `workshop` BOOL DEFAULT 0 COMMENT \'Obrador presente\';

ALTER TABLE `constructions_inspection` ADD CONSTRAINT `constructions_inspection_FK_1`
    FOREIGN KEY (`constructionId`)
    REFERENCES `constructions_construction` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_inspection` ADD CONSTRAINT `constructions_inspection_FK_2`
    FOREIGN KEY (`inspectorId`)
    REFERENCES `constructions_inspector` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_inspectionPhoto` ADD CONSTRAINT `constructions_inspectionPhoto_FK_1`
    FOREIGN KEY (`inspectionId`)
    REFERENCES `constructions_inspection` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_inspectionPhoto` ADD CONSTRAINT `constructions_inspectionPhoto_FK_2`
    FOREIGN KEY (`photoId`)
    REFERENCES `resources_resource` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_inspector` ADD CONSTRAINT `constructions_inspector_FK_1`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `constructions_progress` ADD CONSTRAINT `constructions_progress_FK_1`
    FOREIGN KEY (`constructionId`)
    REFERENCES `constructions_construction` (`id`);

ALTER TABLE `documents_document` ADD CONSTRAINT `documents_document_FK_1`
    FOREIGN KEY (`categoryId`)
    REFERENCES `categories_category` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_actor` ADD CONSTRAINT `headlines_actor_FK_1`
    FOREIGN KEY (`headlineId`)
    REFERENCES `headlines_headline` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_actor` ADD CONSTRAINT `headlines_actor_FK_2`
    FOREIGN KEY (`actorId`)
    REFERENCES `actors_actor` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_headline` CHANGE `content` `content` MEDIUMTEXT COMMENT \'Headline content\';

ALTER TABLE `headlines_headline` CHANGE `processed` `processed` BOOL DEFAULT 0 COMMENT \'Indica si esta procesado\';

ALTER TABLE `headlines_headline` ADD CONSTRAINT `headlines_headline_FK_1`
    FOREIGN KEY (`mediaId`)
    REFERENCES `medias_media` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_headlineDocument` ADD CONSTRAINT `headlines_headlineDocument_FK_1`
    FOREIGN KEY (`headlineId`)
    REFERENCES `headlines_headline` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_headlineDocument` ADD CONSTRAINT `headlines_headlineDocument_FK_2`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_headlineTags` ADD CONSTRAINT `headlines_headlineTags_FK_1`
    FOREIGN KEY (`headlineId`)
    REFERENCES `headlines_headline` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_headlineTags` ADD CONSTRAINT `headlines_headlineTags_FK_2`
    FOREIGN KEY (`tagId`)
    REFERENCES `headlines_tag` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_issue` ADD CONSTRAINT `headlines_issue_FK_1`
    FOREIGN KEY (`headlineId`)
    REFERENCES `headlines_headline` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `headlines_issue` ADD CONSTRAINT `headlines_issue_FK_2`
    FOREIGN KEY (`issueId`)
    REFERENCES `issues_issue` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `indicators_graphComment` ADD CONSTRAINT `indicators_graphComment_FK_1`
    FOREIGN KEY (`graphId`)
    REFERENCES `indicators_graph` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `indicators_graphSerie` ADD CONSTRAINT `indicators_graphSerie_FK_1`
    FOREIGN KEY (`indicatorId`)
    REFERENCES `indicators_indicator` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `indicators_graphSerie` ADD CONSTRAINT `indicators_graphSerie_FK_2`
    FOREIGN KEY (`graphId`)
    REFERENCES `indicators_graph` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `indicators_indicator` CHANGE `archived` `archived` BOOL DEFAULT 0 COMMENT \'Archivado\';

ALTER TABLE `indicators_indicator` CHANGE `methodology` `methodology` MEDIUMTEXT COMMENT \'Metodologia de medicion\';

ALTER TABLE `indicators_indicator` ADD CONSTRAINT `indicators_indicator_FK_1`
    FOREIGN KEY (`positionId`)
    REFERENCES `positions_position` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `indicators_indicator` ADD CONSTRAINT `indicators_indicator_FK_2`
    FOREIGN KEY (`objectiveId`)
    REFERENCES `objectives_objective` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `indicators_value` ADD CONSTRAINT `indicators_value_FK_1`
    FOREIGN KEY (`numericIndicatorId`)
    REFERENCES `indicators_indicator` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `issues_actors` ADD CONSTRAINT `issues_actors_FK_1`
    FOREIGN KEY (`issueId`)
    REFERENCES `issues_issue` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `issues_actors` ADD CONSTRAINT `issues_actors_FK_2`
    FOREIGN KEY (`actorId`)
    REFERENCES `actors_actor` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `issues_issue` CHANGE `description` `description` MEDIUMTEXT COMMENT \'Descripcion del issue\';

ALTER TABLE `issues_issueLog` CHANGE `description` `description` MEDIUMTEXT COMMENT \'Descripcion del issue\';

ALTER TABLE `issues_issueLog` ADD CONSTRAINT `issues_issueLog_FK_1`
    FOREIGN KEY (`id`)
    REFERENCES `issues_issue` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `issues_issuesCategory` ADD CONSTRAINT `issues_issuesCategory_FK_1`
    FOREIGN KEY (`issueId`)
    REFERENCES `issues_issue` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `issues_issuesCategory` ADD CONSTRAINT `issues_issuesCategory_FK_2`
    FOREIGN KEY (`categoryId`)
    REFERENCES `issues_category` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `medias_audienceRelation` ADD CONSTRAINT `medias_audienceRelation_FK_1`
    FOREIGN KEY (`mediaId`)
    REFERENCES `medias_media` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `medias_audienceRelation` ADD CONSTRAINT `medias_audienceRelation_FK_2`
    FOREIGN KEY (`mediaAudienceId`)
    REFERENCES `medias_audience` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `medias_marketRelation` ADD CONSTRAINT `medias_marketRelation_FK_1`
    FOREIGN KEY (`mediaId`)
    REFERENCES `medias_media` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `medias_marketRelation` ADD CONSTRAINT `medias_marketRelation_FK_2`
    FOREIGN KEY (`mediaMarketId`)
    REFERENCES `medias_market` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `medias_media` CHANGE `description` `description` MEDIUMTEXT COMMENT \'Descripcion del medio\';

ALTER TABLE `medias_media` ADD CONSTRAINT `medias_media_FK_1`
    FOREIGN KEY (`typeId`)
    REFERENCES `medias_type` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `medias_media` ADD CONSTRAINT `medias_media_FK_2`
    FOREIGN KEY (`groupId`)
    REFERENCES `medias_media` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `medias_media` ADD CONSTRAINT `medias_media_FK_3`
    FOREIGN KEY (`aliasOf`)
    REFERENCES `medias_media` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `modules_dependency` ADD CONSTRAINT `modules_dependency_FK_1`
    FOREIGN KEY (`moduleName`)
    REFERENCES `modules_module` (`name`)
    ON DELETE CASCADE;

ALTER TABLE `modules_entity` CHANGE `softDelete` `softDelete` BOOL COMMENT \'Indica si usa softdelete\';

ALTER TABLE `modules_entity` CHANGE `relation` `relation` BOOL COMMENT \'Indica si es una entidad principal o una relacion de dos entidades\';

ALTER TABLE `modules_entity` CHANGE `saveLog` `saveLog` BOOL COMMENT \'Indica si guarda log de cambios\';

ALTER TABLE `modules_entity` CHANGE `nestedset` `nestedset` BOOL COMMENT \'Indica si es una entidad nestedset\';

ALTER TABLE `modules_entity` ADD CONSTRAINT `modules_entity_FK_1`
    FOREIGN KEY (`moduleName`)
    REFERENCES `modules_module` (`name`);

ALTER TABLE `modules_entity` ADD CONSTRAINT `modules_entity_FK_2`
    FOREIGN KEY (`scopeFieldUniqueName`)
    REFERENCES `modules_entityField` (`uniqueName`);

ALTER TABLE `modules_entityField` CHANGE `isRequired` `isRequired` BOOL COMMENT \'Indica si es obligatorio\';

ALTER TABLE `modules_entityField` CHANGE `isPrimaryKey` `isPrimaryKey` BOOL COMMENT \'Indica si clave primaria\';

ALTER TABLE `modules_entityField` CHANGE `isAutoIncrement` `isAutoIncrement` BOOL COMMENT \'Indica si el campo es autoincremental\';

ALTER TABLE `modules_entityField` CHANGE `unique` `unique` BOOL COMMENT \'Indica si es unica\';

ALTER TABLE `modules_entityField` CHANGE `formFieldUseCalendar` `formFieldUseCalendar` BOOL COMMENT \'Si utiliza o no el calendario en formulario\';

ALTER TABLE `modules_entityField` CHANGE `automatic` `automatic` BOOL COMMENT \'Indica si es una columna autogenerada por un behavior\';

ALTER TABLE `modules_entityField` ADD CONSTRAINT `modules_entityField_FK_1`
    FOREIGN KEY (`entityName`)
    REFERENCES `modules_entity` (`name`)
    ON DELETE CASCADE;

ALTER TABLE `modules_entityField` ADD CONSTRAINT `modules_entityField_FK_2`
    FOREIGN KEY (`foreignKeyTable`)
    REFERENCES `modules_entity` (`name`)
    ON DELETE SET NULL;

ALTER TABLE `modules_entityField` ADD CONSTRAINT `modules_entityField_FK_3`
    FOREIGN KEY (`foreignKeyRemote`)
    REFERENCES `modules_entityField` (`uniqueName`)
    ON DELETE SET NULL;

ALTER TABLE `modules_entityFieldValidation` ADD CONSTRAINT `modules_entityFieldValidation_FK_1`
    FOREIGN KEY (`entityFieldUniqueName`)
    REFERENCES `modules_entityField` (`uniqueName`)
    ON DELETE CASCADE;

ALTER TABLE `modules_label` ADD CONSTRAINT `modules_label_FK_1`
    FOREIGN KEY (`name`)
    REFERENCES `modules_module` (`name`)
    ON DELETE CASCADE;

ALTER TABLE `modules_module` CHANGE `active` `active` TINYINT(1) DEFAULT 0 NOT NULL COMMENT \'Estado del modulo\';

ALTER TABLE `modules_module` CHANGE `alwaysActive` `alwaysActive` TINYINT(1) DEFAULT 0 NOT NULL COMMENT \'Modulo siempre activo\';

ALTER TABLE `modules_module` CHANGE `hasCategories` `hasCategories` TINYINT(1) DEFAULT 0 NOT NULL COMMENT \'El Modulo tiene categorias relacionadas?\';

ALTER TABLE `multilang_text` ADD CONSTRAINT `multilang_text_FK_1`
    FOREIGN KEY (`languageCode`)
    REFERENCES `multilang_language` (`code`)
    ON DELETE CASCADE;

ALTER TABLE `multilang_text` ADD CONSTRAINT `multilang_text_FK_2`
    FOREIGN KEY (`moduleName`)
    REFERENCES `modules_module` (`name`);

ALTER TABLE `objectives_objective` ADD CONSTRAINT `objectives_objective_FK_1`
    FOREIGN KEY (`strategicObjectiveId`)
    REFERENCES `objectives_strategic` (`id`);

ALTER TABLE `objectives_objective` ADD CONSTRAINT `objectives_objective_FK_2`
    FOREIGN KEY (`policyGuidelineId`)
    REFERENCES `objectives_policyGuideline` (`id`);

ALTER TABLE `objectives_objective` ADD CONSTRAINT `objectives_objective_FK_3`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `objectives_objective` ADD CONSTRAINT `objectives_objective_FK_4`
    FOREIGN KEY (`responsibleCode`)
    REFERENCES `positions_position` (`code`);

ALTER TABLE `objectives_objectiveLog` ADD CONSTRAINT `objectives_objectiveLog_FK_1`
    FOREIGN KEY (`strategicObjectiveId`)
    REFERENCES `objectives_strategic` (`id`);

ALTER TABLE `objectives_objectiveLog` ADD CONSTRAINT `objectives_objectiveLog_FK_2`
    FOREIGN KEY (`objectiveId`)
    REFERENCES `objectives_objective` (`id`);

ALTER TABLE `objectives_objectiveLog` ADD CONSTRAINT `objectives_objectiveLog_FK_3`
    FOREIGN KEY (`policyGuidelineId`)
    REFERENCES `objectives_policyGuideline` (`id`);

ALTER TABLE `objectives_objectiveLog` ADD CONSTRAINT `objectives_objectiveLog_FK_4`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `objectives_objectiveLog` ADD CONSTRAINT `objectives_objectiveLog_FK_5`
    FOREIGN KEY (`responsibleCode`)
    REFERENCES `positions_position` (`id`);

ALTER TABLE `objectives_policyGuideline` CHANGE `name` `name` TEXT(255) NOT NULL COMMENT \'Policy Guideline Name\';

ALTER TABLE `objectives_policyGuideline` ADD CONSTRAINT `objectives_policyGuideline_FK_1`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `objectives_policyGuidelineIndicators` ADD CONSTRAINT `objectives_policyGuidelineIndicators_FK_1`
    FOREIGN KEY (`policyGuidelineId`)
    REFERENCES `objectives_policyGuideline` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `objectives_policyGuidelineIndicators` ADD CONSTRAINT `objectives_policyGuidelineIndicators_FK_2`
    FOREIGN KEY (`indicatorId`)
    REFERENCES `indicators_indicator` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `objectives_policyGuidelineLog` CHANGE `name` `name` TEXT(255) NOT NULL COMMENT \'Policy Guideline Name\';

ALTER TABLE `objectives_policyGuidelineLog` ADD CONSTRAINT `objectives_policyGuidelineLog_FK_1`
    FOREIGN KEY (`policyGuidelineId`)
    REFERENCES `objectives_policyGuideline` (`id`);

ALTER TABLE `objectives_policyGuidelineLog` ADD CONSTRAINT `objectives_policyGuidelineLog_FK_2`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `objectives_position` ADD CONSTRAINT `objectives_position_FK_1`
    FOREIGN KEY (`positionId`)
    REFERENCES `positions_position` (`id`);

ALTER TABLE `objectives_position` ADD CONSTRAINT `objectives_position_FK_2`
    FOREIGN KEY (`objectiveId`)
    REFERENCES `objectives_objective` (`id`);

ALTER TABLE `objectives_region` ADD CONSTRAINT `objectives_region_FK_1`
    FOREIGN KEY (`regionId`)
    REFERENCES `regions_region` (`id`);

ALTER TABLE `objectives_region` ADD CONSTRAINT `objectives_region_FK_2`
    FOREIGN KEY (`objectiveId`)
    REFERENCES `objectives_objective` (`id`);

ALTER TABLE `objectives_strategic` CHANGE `name` `name` TEXT(255) NOT NULL COMMENT \'Objective Name\';

ALTER TABLE `objectives_strategic` ADD CONSTRAINT `objectives_strategic_FK_1`
    FOREIGN KEY (`policyGuidelineId`)
    REFERENCES `objectives_policyGuideline` (`id`);

ALTER TABLE `objectives_strategic` ADD CONSTRAINT `objectives_strategic_FK_2`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `objectives_strategicLog` CHANGE `name` `name` TEXT(255) NOT NULL COMMENT \'Objective Name\';

ALTER TABLE `objectives_strategicLog` ADD CONSTRAINT `objectives_strategicLog_FK_1`
    FOREIGN KEY (`strategicId`)
    REFERENCES `objectives_strategic` (`id`);

ALTER TABLE `objectives_strategicLog` ADD CONSTRAINT `objectives_strategicLog_FK_2`
    FOREIGN KEY (`policyGuidelineId`)
    REFERENCES `objectives_policyGuideline` (`id`);

ALTER TABLE `objectives_strategicLog` ADD CONSTRAINT `objectives_strategicLog_FK_3`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `panel_adminActParticipant` ADD CONSTRAINT `panel_adminActParticipant_FK_1`
    FOREIGN KEY (`adminActId`)
    REFERENCES `panel_administrativeAct` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_administrativeAct` ADD CONSTRAINT `panel_administrativeAct_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`)
    ON DELETE SET NULL;

ALTER TABLE `panel_administrativeActDocument` ADD CONSTRAINT `panel_administrativeActDocument_FK_1`
    FOREIGN KEY (`administrativeActId`)
    REFERENCES `panel_administrativeAct` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_administrativeActDocument` ADD CONSTRAINT `panel_administrativeActDocument_FK_2`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_alertDigest` ADD CONSTRAINT `panel_alertDigest_FK_1`
    FOREIGN KEY (`positionCode`)
    REFERENCES `positions_position` (`code`);

ALTER TABLE `panel_contractorCategoryRelation` ADD CONSTRAINT `panel_contractorCategoryRelation_FK_1`
    FOREIGN KEY (`contractorId`)
    REFERENCES `panel_contractor` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_contractorCategoryRelation` ADD CONSTRAINT `panel_contractorCategoryRelation_FK_2`
    FOREIGN KEY (`categoryId`)
    REFERENCES `panel_contractorCategory` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_guarantee` CHANGE `returned` `returned` BOOL COMMENT \'Garantia devuelta\';

ALTER TABLE `panel_guarantee` ADD CONSTRAINT `panel_guarantee_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`)
    ON DELETE SET NULL;

ALTER TABLE `panel_guarantee` ADD CONSTRAINT `panel_guarantee_FK_2`
    FOREIGN KEY (`contractorId`)
    REFERENCES `panel_contractor` (`id`)
    ON DELETE SET NULL;

ALTER TABLE `panel_guaranteeDocument` ADD CONSTRAINT `panel_guaranteeDocument_FK_1`
    FOREIGN KEY (`guaranteeId`)
    REFERENCES `panel_guarantee` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_guaranteeDocument` ADD CONSTRAINT `panel_guaranteeDocument_FK_2`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_mission` ADD CONSTRAINT `panel_mission_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`)
    ON DELETE SET NULL;

ALTER TABLE `panel_mission` ADD CONSTRAINT `panel_mission_FK_2`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`)
    ON DELETE SET NULL;

ALTER TABLE `panel_mission` ADD CONSTRAINT `panel_mission_FK_3`
    FOREIGN KEY (`updaterUserId`)
    REFERENCES `users_user` (`id`)
    ON DELETE SET NULL;

ALTER TABLE `panel_missionCommitment` CHANGE `achieved` `achieved` BOOL COMMENT \'Logrado\';

ALTER TABLE `panel_missionCommitment` ADD CONSTRAINT `panel_missionCommitment_FK_1`
    FOREIGN KEY (`missionId`)
    REFERENCES `panel_mission` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_missionCommitment` ADD CONSTRAINT `panel_missionCommitment_FK_2`
    FOREIGN KEY (`participantId`)
    REFERENCES `panel_missionParticipant` (`id`);

ALTER TABLE `panel_missionDocument` ADD CONSTRAINT `panel_missionDocument_FK_1`
    FOREIGN KEY (`missionId`)
    REFERENCES `panel_mission` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_missionDocument` ADD CONSTRAINT `panel_missionDocument_FK_2`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_missionParticipant` ADD CONSTRAINT `panel_missionParticipant_FK_1`
    FOREIGN KEY (`missionId`)
    REFERENCES `panel_mission` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_missionUpdate` ADD CONSTRAINT `panel_missionUpdate_FK_1`
    FOREIGN KEY (`missionId`)
    REFERENCES `panel_mission` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_missionUpdate` ADD CONSTRAINT `panel_missionUpdate_FK_2`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`)
    ON DELETE SET NULL;

ALTER TABLE `panel_reportDocument` ADD CONSTRAINT `panel_reportDocument_FK_1`
    FOREIGN KEY (`reportSectionId`)
    REFERENCES `panel_reportSection` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_reportDocument` ADD CONSTRAINT `panel_reportDocument_FK_2`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `panel_reportSection` CHANGE `content` `content` MEDIUMTEXT COMMENT \'Content\';

ALTER TABLE `panel_reportSection` CHANGE `enviromentalSupervision` `enviromentalSupervision` MEDIUMTEXT COMMENT \'Supervision Ambiantal\';

ALTER TABLE `panel_reportSection` CHANGE `completed` `completed` BOOL COMMENT \'Completada\';

ALTER TABLE `panel_reportSection` ADD CONSTRAINT `panel_reportSection_FK_1`
    FOREIGN KEY (`versionId`)
    REFERENCES `panel_reportVersion` (`id`);

ALTER TABLE `panel_resultFrameIndicator` CHANGE `useData` `useData` BOOL COMMENT \'Utiliza o no datos de indicador\';

ALTER TABLE `panel_resultFrameIndicator` CHANGE `content` `content` MEDIUMTEXT COMMENT \'Content\';

ALTER TABLE `panel_resultFrameValue` ADD CONSTRAINT `panel_resultFrameValue_FK_1`
    FOREIGN KEY (`resultFrameIndicatorId`)
    REFERENCES `panel_resultFrameIndicator` (`id`);

ALTER TABLE `positions_document` ADD CONSTRAINT `positions_document_FK_1`
    FOREIGN KEY (`positionId`)
    REFERENCES `positions_position` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `positions_document` ADD CONSTRAINT `positions_document_FK_2`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `positions_position` ADD CONSTRAINT `positions_position_FK_1`
    FOREIGN KEY (`userGroupId`)
    REFERENCES `users_group` (`id`);

ALTER TABLE `positions_position` ADD CONSTRAINT `positions_position_FK_2`
    FOREIGN KEY (`versionId`)
    REFERENCES `positions_version` (`id`);

ALTER TABLE `positions_positionTenure` ADD CONSTRAINT `positions_positionTenure_FK_1`
    FOREIGN KEY (`positionCode`)
    REFERENCES `positions_position` (`code`);

ALTER TABLE `projects_activity` CHANGE `press` `press` TINYINT(1) DEFAULT 0 COMMENT \'Interes prensa?\';

ALTER TABLE `projects_activity` ADD CONSTRAINT `projects_activity_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`);

ALTER TABLE `projects_activity` ADD CONSTRAINT `projects_activity_FK_2`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `projects_activity` ADD CONSTRAINT `projects_activity_FK_3`
    FOREIGN KEY (`responsibleCode`)
    REFERENCES `positions_position` (`code`);

ALTER TABLE `projects_activityDocument` ADD CONSTRAINT `projects_activityDocument_FK_1`
    FOREIGN KEY (`activity_id`)
    REFERENCES `projects_activity` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `projects_activityDocument` ADD CONSTRAINT `projects_activityDocument_FK_2`
    FOREIGN KEY (`document_id`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `projects_activityLog` ADD CONSTRAINT `projects_activityLog_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`);

ALTER TABLE `projects_activityLog` ADD CONSTRAINT `projects_activityLog_FK_2`
    FOREIGN KEY (`activityId`)
    REFERENCES `projects_activity` (`id`);

ALTER TABLE `projects_activityLog` ADD CONSTRAINT `projects_activityLog_FK_3`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `projects_activityLog` ADD CONSTRAINT `projects_activityLog_FK_4`
    FOREIGN KEY (`responsibleCode`)
    REFERENCES `positions_position` (`code`);

ALTER TABLE `projects_contractor` ADD CONSTRAINT `projects_contractor_FK_1`
    FOREIGN KEY (`project_id`)
    REFERENCES `projects_project` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `projects_contractor` ADD CONSTRAINT `projects_contractor_FK_2`
    FOREIGN KEY (`contractor_id`)
    REFERENCES `panel_contractor` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `projects_document` ADD CONSTRAINT `projects_document_FK_1`
    FOREIGN KEY (`project_id`)
    REFERENCES `projects_project` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `projects_document` ADD CONSTRAINT `projects_document_FK_2`
    FOREIGN KEY (`document_id`)
    REFERENCES `documents_document` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `projects_indicator` ADD CONSTRAINT `projects_indicator_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`);

ALTER TABLE `projects_indicator` ADD CONSTRAINT `projects_indicator_FK_2`
    FOREIGN KEY (`regionId`)
    REFERENCES `regions_region` (`id`);

ALTER TABLE `projects_milestone` ADD CONSTRAINT `projects_milestone_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`);

ALTER TABLE `projects_milestoneLog` ADD CONSTRAINT `projects_milestoneLog_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`);

ALTER TABLE `projects_milestoneLog` ADD CONSTRAINT `projects_milestoneLog_FK_2`
    FOREIGN KEY (`milestoneId`)
    REFERENCES `projects_milestone` (`id`);

ALTER TABLE `projects_milestoneLog` ADD CONSTRAINT `projects_milestoneLog_FK_3`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `projects_project` ADD CONSTRAINT `projects_project_FK_1`
    FOREIGN KEY (`objectiveId`)
    REFERENCES `objectives_objective` (`id`);

ALTER TABLE `projects_project` ADD CONSTRAINT `projects_project_FK_2`
    FOREIGN KEY (`responsibleCode`)
    REFERENCES `positions_position` (`code`);

ALTER TABLE `projects_project` ADD CONSTRAINT `projects_project_FK_3`
    FOREIGN KEY (`indicatorId`)
    REFERENCES `indicators_indicator` (`id`);

ALTER TABLE `projects_project` ADD CONSTRAINT `projects_project_FK_4`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `projects_projectLog` ADD CONSTRAINT `projects_projectLog_FK_1`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`);

ALTER TABLE `projects_projectLog` ADD CONSTRAINT `projects_projectLog_FK_2`
    FOREIGN KEY (`objectiveId`)
    REFERENCES `objectives_objective` (`id`);

ALTER TABLE `projects_projectLog` ADD CONSTRAINT `projects_projectLog_FK_3`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `projects_projectLog` ADD CONSTRAINT `projects_projectLog_FK_4`
    FOREIGN KEY (`responsibleCode`)
    REFERENCES `positions_position` (`code`);

ALTER TABLE `projects_region` ADD CONSTRAINT `projects_region_FK_1`
    FOREIGN KEY (`regionId`)
    REFERENCES `regions_region` (`id`);

ALTER TABLE `projects_region` ADD CONSTRAINT `projects_region_FK_2`
    FOREIGN KEY (`projectId`)
    REFERENCES `projects_project` (`id`);

ALTER TABLE `regions_point` CHANGE `latitude` `latitude` DECIMAL(12,9) COMMENT \'latitud\';

ALTER TABLE `regions_point` CHANGE `longitude` `longitude` DECIMAL(12,9) COMMENT \'longitud\';

ALTER TABLE `regions_point` ADD CONSTRAINT `regions_point_FK_1`
    FOREIGN KEY (`regionId`)
    REFERENCES `regions_region` (`id`);

ALTER TABLE `regions_region` CHANGE `latitude` `latitude` DECIMAL(12,9) COMMENT \'latitud\';

ALTER TABLE `regions_region` CHANGE `longitude` `longitude` DECIMAL(12,9) COMMENT \'longitud\';

ALTER TABLE `security_action` ADD CONSTRAINT `security_action_FK_1`
    FOREIGN KEY (`module`)
    REFERENCES `security_module` (`module`);

ALTER TABLE `security_blockedUser` CHANGE `unBlocked` `unBlocked` BOOL COMMENT \'Indica si el usuario fue desbloqueado\';

ALTER TABLE `security_loginFailure` CHANGE `blocked` `blocked` BOOL COMMENT \'Indica si el intento fallido resulto en bloqueo\';

ALTER TABLE `security_securityFailure` CHANGE `blocked` `blocked` BOOL COMMENT \'Indica si el intento fallido resulto en bloqueo\';

ALTER TABLE `users_groupCategory` ADD CONSTRAINT `users_groupCategory_FK_1`
    FOREIGN KEY (`groupId`)
    REFERENCES `users_group` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `users_groupCategory` ADD CONSTRAINT `users_groupCategory_FK_2`
    FOREIGN KEY (`categoryId`)
    REFERENCES `categories_category` (`id`)
    ON DELETE CASCADE;

ALTER TABLE `users_user` CHANGE `active` `active` BOOL NOT NULL COMMENT \'Is user active?\';

ALTER TABLE `users_user` ADD CONSTRAINT `users_user_FK_1`
    FOREIGN KEY (`levelId`)
    REFERENCES `users_level` (`id`);

ALTER TABLE `users_userGroup` ADD CONSTRAINT `users_userGroup_FK_1`
    FOREIGN KEY (`userId`)
    REFERENCES `users_user` (`id`);

ALTER TABLE `users_userGroup` ADD CONSTRAINT `users_userGroup_FK_2`
    FOREIGN KEY (`groupId`)
    REFERENCES `users_group` (`id`);

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
',
);
    }

    /**
     * Get the SQL statements for the Down migration
     *
     * @return array list of the SQL strings to execute for the Down migration
     *               the keys being the datasources
     */
    public function getDownSQL()
    {
        return array (
  'application' => '
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

ALTER TABLE `actionLogs_log` DROP FOREIGN KEY `actionLogs_log_FK_1`;

ALTER TABLE `actionLogs_log` DROP FOREIGN KEY `actionLogs_log_FK_2`;

ALTER TABLE `actors_activeQuestions` DROP FOREIGN KEY `actors_activeQuestions_FK_1`;

ALTER TABLE `actors_activeQuestions` DROP FOREIGN KEY `actors_activeQuestions_FK_2`;

ALTER TABLE `actors_activeRelationQuestions` DROP FOREIGN KEY `actors_activeRelationQuestions_FK_1`;

ALTER TABLE `actors_activeRelationQuestions` DROP FOREIGN KEY `actors_activeRelationQuestions_FK_2`;

ALTER TABLE `actors_actorsCategory` DROP FOREIGN KEY `actors_actorsCategory_FK_1`;

ALTER TABLE `actors_actorsCategory` DROP FOREIGN KEY `actors_actorsCategory_FK_2`;

ALTER TABLE `actors_formAnswer` DROP FOREIGN KEY `actors_formAnswer_FK_1`;

ALTER TABLE `actors_formAnswer` DROP FOREIGN KEY `actors_formAnswer_FK_2`;

ALTER TABLE `actors_profileForm` CHANGE `relationship` `relationship` TINYINT(1) DEFAULT 0 NOT NULL;

ALTER TABLE `actors_profileForm` CHANGE `inAnalysis` `inAnalysis` TINYINT(1) DEFAULT 0;

ALTER TABLE `actors_profileFormQuestionOption` DROP FOREIGN KEY `actors_profileFormQuestionOption_FK_1`;

ALTER TABLE `actors_profileFormQuestionOption` CHANGE `defaultOpc` `defaultOpc` TINYINT(1);

ALTER TABLE `actors_relations` DROP FOREIGN KEY `actors_relations_FK_1`;

ALTER TABLE `actors_relations` DROP FOREIGN KEY `actors_relations_FK_2`;

ALTER TABLE `actors_relations` CHANGE `direction` `direction` TINYINT(1) NOT NULL;

ALTER TABLE `campaigns_campaign` CHANGE `searchQueries` `searchQueries` TEXT;

ALTER TABLE `campaigns_campaignCommitment` DROP FOREIGN KEY `campaigns_campaignCommitment_FK_1`;

ALTER TABLE `campaigns_campaignCommitment` DROP FOREIGN KEY `campaigns_campaignCommitment_FK_2`;

ALTER TABLE `campaigns_campaignCommitment` CHANGE `achieved` `achieved` TINYINT(1);

ALTER TABLE `campaigns_campaignDocument` DROP FOREIGN KEY `campaigns_campaignDocument_FK_1`;

ALTER TABLE `campaigns_campaignDocument` DROP FOREIGN KEY `campaigns_campaignDocument_FK_2`;

ALTER TABLE `campaigns_campaignParticipant` DROP FOREIGN KEY `campaigns_campaignParticipant_FK_1`;

ALTER TABLE `categories_category` CHANGE `isPublic` `isPublic` TINYINT(1) DEFAULT 0 NOT NULL;

ALTER TABLE `common_alertSubscription` DROP FOREIGN KEY `common_alertSubscription_FK_1`;

ALTER TABLE `common_alertSubscription` DROP FOREIGN KEY `common_alertSubscription_FK_2`;

ALTER TABLE `common_alertSubscription` DROP FOREIGN KEY `common_alertSubscription_FK_3`;

ALTER TABLE `common_alertSubscriptionUser` DROP FOREIGN KEY `common_alertSubscriptionUser_FK_1`;

ALTER TABLE `common_alertSubscriptionUser` DROP FOREIGN KEY `common_alertSubscriptionUser_FK_2`;

ALTER TABLE `common_internalMail` DROP FOREIGN KEY `common_internalMail_FK_1`;

ALTER TABLE `common_menuItem` CHANGE `newWindow` `newWindow` TINYINT(1) DEFAULT 0 NOT NULL;

ALTER TABLE `common_menuItemInfo` DROP FOREIGN KEY `common_menuItemInfo_FK_1`;

ALTER TABLE `constructions_construction` DROP FOREIGN KEY `constructions_construction_FK_1`;

ALTER TABLE `constructions_construction` DROP FOREIGN KEY `constructions_construction_FK_2`;

ALTER TABLE `constructions_construction` DROP FOREIGN KEY `constructions_construction_FK_3`;

ALTER TABLE `constructions_construction` CHANGE `latitude` `latitude` DECIMAL(12,9);

ALTER TABLE `constructions_construction` CHANGE `longitude` `longitude` DECIMAL(12,9);

ALTER TABLE `constructions_construction` CHANGE `stage` `stage` TINYINT;

ALTER TABLE `constructions_construction` CHANGE `inaugurated` `inaugurated` TINYINT(1) DEFAULT 0;

ALTER TABLE `constructions_inspection` DROP FOREIGN KEY `constructions_inspection_FK_1`;

ALTER TABLE `constructions_inspection` DROP FOREIGN KEY `constructions_inspection_FK_2`;

ALTER TABLE `constructions_inspection` CHANGE `workshop` `workshop` TINYINT(1) DEFAULT 0;

ALTER TABLE `constructions_inspectionPhoto` DROP FOREIGN KEY `constructions_inspectionPhoto_FK_1`;

ALTER TABLE `constructions_inspectionPhoto` DROP FOREIGN KEY `constructions_inspectionPhoto_FK_2`;

ALTER TABLE `constructions_inspector` DROP FOREIGN KEY `constructions_inspector_FK_1`;

ALTER TABLE `constructions_progress` DROP FOREIGN KEY `constructions_progress_FK_1`;

ALTER TABLE `documents_document` DROP FOREIGN KEY `documents_document_FK_1`;

ALTER TABLE `headlines_actor` DROP FOREIGN KEY `headlines_actor_FK_1`;

ALTER TABLE `headlines_actor` DROP FOREIGN KEY `headlines_actor_FK_2`;

ALTER TABLE `headlines_headline` DROP FOREIGN KEY `headlines_headline_FK_1`;

ALTER TABLE `headlines_headline` CHANGE `content` `content` TEXT;

ALTER TABLE `headlines_headline` CHANGE `processed` `processed` TINYINT(1) DEFAULT 0;

ALTER TABLE `headlines_headlineDocument` DROP FOREIGN KEY `headlines_headlineDocument_FK_1`;

ALTER TABLE `headlines_headlineDocument` DROP FOREIGN KEY `headlines_headlineDocument_FK_2`;

ALTER TABLE `headlines_headlineTags` DROP FOREIGN KEY `headlines_headlineTags_FK_1`;

ALTER TABLE `headlines_headlineTags` DROP FOREIGN KEY `headlines_headlineTags_FK_2`;

ALTER TABLE `headlines_issue` DROP FOREIGN KEY `headlines_issue_FK_1`;

ALTER TABLE `headlines_issue` DROP FOREIGN KEY `headlines_issue_FK_2`;

ALTER TABLE `indicators_graphComment` DROP FOREIGN KEY `indicators_graphComment_FK_1`;

ALTER TABLE `indicators_graphSerie` DROP FOREIGN KEY `indicators_graphSerie_FK_1`;

ALTER TABLE `indicators_graphSerie` DROP FOREIGN KEY `indicators_graphSerie_FK_2`;

ALTER TABLE `indicators_indicator` DROP FOREIGN KEY `indicators_indicator_FK_1`;

ALTER TABLE `indicators_indicator` DROP FOREIGN KEY `indicators_indicator_FK_2`;

ALTER TABLE `indicators_indicator` CHANGE `archived` `archived` TINYINT(1) DEFAULT 0;

ALTER TABLE `indicators_indicator` CHANGE `methodology` `methodology` TEXT;

ALTER TABLE `indicators_value` DROP FOREIGN KEY `indicators_value_FK_1`;

ALTER TABLE `issues_actors` DROP FOREIGN KEY `issues_actors_FK_1`;

ALTER TABLE `issues_actors` DROP FOREIGN KEY `issues_actors_FK_2`;

ALTER TABLE `issues_issue` CHANGE `description` `description` TEXT;

ALTER TABLE `issues_issueLog` DROP FOREIGN KEY `issues_issueLog_FK_1`;

ALTER TABLE `issues_issueLog` CHANGE `description` `description` TEXT;

ALTER TABLE `issues_issuesCategory` DROP FOREIGN KEY `issues_issuesCategory_FK_1`;

ALTER TABLE `issues_issuesCategory` DROP FOREIGN KEY `issues_issuesCategory_FK_2`;

ALTER TABLE `medias_audienceRelation` DROP FOREIGN KEY `medias_audienceRelation_FK_1`;

ALTER TABLE `medias_audienceRelation` DROP FOREIGN KEY `medias_audienceRelation_FK_2`;

ALTER TABLE `medias_marketRelation` DROP FOREIGN KEY `medias_marketRelation_FK_1`;

ALTER TABLE `medias_marketRelation` DROP FOREIGN KEY `medias_marketRelation_FK_2`;

ALTER TABLE `medias_media` DROP FOREIGN KEY `medias_media_FK_1`;

ALTER TABLE `medias_media` DROP FOREIGN KEY `medias_media_FK_2`;

ALTER TABLE `medias_media` DROP FOREIGN KEY `medias_media_FK_3`;

ALTER TABLE `medias_media` CHANGE `description` `description` TEXT;

ALTER TABLE `modules_dependency` DROP FOREIGN KEY `modules_dependency_FK_1`;

ALTER TABLE `modules_entity` DROP FOREIGN KEY `modules_entity_FK_1`;

ALTER TABLE `modules_entity` DROP FOREIGN KEY `modules_entity_FK_2`;

ALTER TABLE `modules_entity` CHANGE `softDelete` `softDelete` TINYINT(1);

ALTER TABLE `modules_entity` CHANGE `relation` `relation` TINYINT(1);

ALTER TABLE `modules_entity` CHANGE `saveLog` `saveLog` TINYINT(1);

ALTER TABLE `modules_entity` CHANGE `nestedset` `nestedset` TINYINT(1);

ALTER TABLE `modules_entityField` DROP FOREIGN KEY `modules_entityField_FK_1`;

ALTER TABLE `modules_entityField` DROP FOREIGN KEY `modules_entityField_FK_2`;

ALTER TABLE `modules_entityField` DROP FOREIGN KEY `modules_entityField_FK_3`;

ALTER TABLE `modules_entityField` CHANGE `isRequired` `isRequired` TINYINT(1);

ALTER TABLE `modules_entityField` CHANGE `isPrimaryKey` `isPrimaryKey` TINYINT(1);

ALTER TABLE `modules_entityField` CHANGE `isAutoIncrement` `isAutoIncrement` TINYINT(1);

ALTER TABLE `modules_entityField` CHANGE `unique` `unique` TINYINT(1);

ALTER TABLE `modules_entityField` CHANGE `formFieldUseCalendar` `formFieldUseCalendar` TINYINT(1);

ALTER TABLE `modules_entityField` CHANGE `automatic` `automatic` TINYINT(1);

ALTER TABLE `modules_entityFieldValidation` DROP FOREIGN KEY `modules_entityFieldValidation_FK_1`;

ALTER TABLE `modules_label` DROP FOREIGN KEY `modules_label_FK_1`;

ALTER TABLE `modules_module` CHANGE `active` `active` TINYINT(1) DEFAULT 0 NOT NULL;

ALTER TABLE `modules_module` CHANGE `alwaysActive` `alwaysActive` TINYINT(1) DEFAULT 0 NOT NULL;

ALTER TABLE `modules_module` CHANGE `hasCategories` `hasCategories` TINYINT(1) DEFAULT 0 NOT NULL;

ALTER TABLE `multilang_text` DROP FOREIGN KEY `multilang_text_FK_1`;

ALTER TABLE `multilang_text` DROP FOREIGN KEY `multilang_text_FK_2`;

ALTER TABLE `objectives_objective` DROP FOREIGN KEY `objectives_objective_FK_1`;

ALTER TABLE `objectives_objective` DROP FOREIGN KEY `objectives_objective_FK_2`;

ALTER TABLE `objectives_objective` DROP FOREIGN KEY `objectives_objective_FK_3`;

ALTER TABLE `objectives_objective` DROP FOREIGN KEY `objectives_objective_FK_4`;

ALTER TABLE `objectives_objectiveLog` DROP FOREIGN KEY `objectives_objectiveLog_FK_1`;

ALTER TABLE `objectives_objectiveLog` DROP FOREIGN KEY `objectives_objectiveLog_FK_2`;

ALTER TABLE `objectives_objectiveLog` DROP FOREIGN KEY `objectives_objectiveLog_FK_3`;

ALTER TABLE `objectives_objectiveLog` DROP FOREIGN KEY `objectives_objectiveLog_FK_4`;

ALTER TABLE `objectives_objectiveLog` DROP FOREIGN KEY `objectives_objectiveLog_FK_5`;

ALTER TABLE `objectives_policyGuideline` DROP FOREIGN KEY `objectives_policyGuideline_FK_1`;

ALTER TABLE `objectives_policyGuideline` CHANGE `name` `name` TEXT NOT NULL;

ALTER TABLE `objectives_policyGuidelineIndicators` DROP FOREIGN KEY `objectives_policyGuidelineIndicators_FK_1`;

ALTER TABLE `objectives_policyGuidelineIndicators` DROP FOREIGN KEY `objectives_policyGuidelineIndicators_FK_2`;

ALTER TABLE `objectives_policyGuidelineLog` DROP FOREIGN KEY `objectives_policyGuidelineLog_FK_1`;

ALTER TABLE `objectives_policyGuidelineLog` DROP FOREIGN KEY `objectives_policyGuidelineLog_FK_2`;

ALTER TABLE `objectives_policyGuidelineLog` CHANGE `name` `name` TEXT NOT NULL;

ALTER TABLE `objectives_position` DROP FOREIGN KEY `objectives_position_FK_1`;

ALTER TABLE `objectives_position` DROP FOREIGN KEY `objectives_position_FK_2`;

ALTER TABLE `objectives_region` DROP FOREIGN KEY `objectives_region_FK_1`;

ALTER TABLE `objectives_region` DROP FOREIGN KEY `objectives_region_FK_2`;

ALTER TABLE `objectives_strategic` DROP FOREIGN KEY `objectives_strategic_FK_1`;

ALTER TABLE `objectives_strategic` DROP FOREIGN KEY `objectives_strategic_FK_2`;

ALTER TABLE `objectives_strategic` CHANGE `name` `name` TEXT NOT NULL;

ALTER TABLE `objectives_strategicLog` DROP FOREIGN KEY `objectives_strategicLog_FK_1`;

ALTER TABLE `objectives_strategicLog` DROP FOREIGN KEY `objectives_strategicLog_FK_2`;

ALTER TABLE `objectives_strategicLog` DROP FOREIGN KEY `objectives_strategicLog_FK_3`;

ALTER TABLE `objectives_strategicLog` CHANGE `name` `name` TEXT NOT NULL;

ALTER TABLE `panel_adminActParticipant` DROP FOREIGN KEY `panel_adminActParticipant_FK_1`;

ALTER TABLE `panel_administrativeAct` DROP FOREIGN KEY `panel_administrativeAct_FK_1`;

ALTER TABLE `panel_administrativeActDocument` DROP FOREIGN KEY `panel_administrativeActDocument_FK_1`;

ALTER TABLE `panel_administrativeActDocument` DROP FOREIGN KEY `panel_administrativeActDocument_FK_2`;

ALTER TABLE `panel_alertDigest` DROP FOREIGN KEY `panel_alertDigest_FK_1`;

ALTER TABLE `panel_contractorCategoryRelation` DROP FOREIGN KEY `panel_contractorCategoryRelation_FK_1`;

ALTER TABLE `panel_contractorCategoryRelation` DROP FOREIGN KEY `panel_contractorCategoryRelation_FK_2`;

ALTER TABLE `panel_guarantee` DROP FOREIGN KEY `panel_guarantee_FK_1`;

ALTER TABLE `panel_guarantee` DROP FOREIGN KEY `panel_guarantee_FK_2`;

ALTER TABLE `panel_guarantee` CHANGE `returned` `returned` TINYINT(1);

ALTER TABLE `panel_guaranteeDocument` DROP FOREIGN KEY `panel_guaranteeDocument_FK_1`;

ALTER TABLE `panel_guaranteeDocument` DROP FOREIGN KEY `panel_guaranteeDocument_FK_2`;

ALTER TABLE `panel_mission` DROP FOREIGN KEY `panel_mission_FK_1`;

ALTER TABLE `panel_mission` DROP FOREIGN KEY `panel_mission_FK_2`;

ALTER TABLE `panel_mission` DROP FOREIGN KEY `panel_mission_FK_3`;

ALTER TABLE `panel_missionCommitment` DROP FOREIGN KEY `panel_missionCommitment_FK_1`;

ALTER TABLE `panel_missionCommitment` DROP FOREIGN KEY `panel_missionCommitment_FK_2`;

ALTER TABLE `panel_missionCommitment` CHANGE `achieved` `achieved` TINYINT(1);

ALTER TABLE `panel_missionDocument` DROP FOREIGN KEY `panel_missionDocument_FK_1`;

ALTER TABLE `panel_missionDocument` DROP FOREIGN KEY `panel_missionDocument_FK_2`;

ALTER TABLE `panel_missionParticipant` DROP FOREIGN KEY `panel_missionParticipant_FK_1`;

ALTER TABLE `panel_missionUpdate` DROP FOREIGN KEY `panel_missionUpdate_FK_1`;

ALTER TABLE `panel_missionUpdate` DROP FOREIGN KEY `panel_missionUpdate_FK_2`;

ALTER TABLE `panel_reportDocument` DROP FOREIGN KEY `panel_reportDocument_FK_1`;

ALTER TABLE `panel_reportDocument` DROP FOREIGN KEY `panel_reportDocument_FK_2`;

ALTER TABLE `panel_reportSection` DROP FOREIGN KEY `panel_reportSection_FK_1`;

ALTER TABLE `panel_reportSection` CHANGE `content` `content` TEXT;

ALTER TABLE `panel_reportSection` CHANGE `enviromentalSupervision` `enviromentalSupervision` TEXT;

ALTER TABLE `panel_reportSection` CHANGE `completed` `completed` TINYINT(1);

ALTER TABLE `panel_resultFrameIndicator` CHANGE `useData` `useData` TINYINT(1);

ALTER TABLE `panel_resultFrameIndicator` CHANGE `content` `content` TEXT;

ALTER TABLE `panel_resultFrameValue` DROP FOREIGN KEY `panel_resultFrameValue_FK_1`;

ALTER TABLE `positions_document` DROP FOREIGN KEY `positions_document_FK_1`;

ALTER TABLE `positions_document` DROP FOREIGN KEY `positions_document_FK_2`;

ALTER TABLE `positions_position` DROP FOREIGN KEY `positions_position_FK_1`;

ALTER TABLE `positions_position` DROP FOREIGN KEY `positions_position_FK_2`;

ALTER TABLE `positions_positionTenure` DROP FOREIGN KEY `positions_positionTenure_FK_1`;

ALTER TABLE `projects_activity` DROP FOREIGN KEY `projects_activity_FK_1`;

ALTER TABLE `projects_activity` DROP FOREIGN KEY `projects_activity_FK_2`;

ALTER TABLE `projects_activity` DROP FOREIGN KEY `projects_activity_FK_3`;

ALTER TABLE `projects_activity` CHANGE `press` `press` TINYINT(1) DEFAULT 0;

ALTER TABLE `projects_activityDocument` DROP FOREIGN KEY `projects_activityDocument_FK_1`;

ALTER TABLE `projects_activityDocument` DROP FOREIGN KEY `projects_activityDocument_FK_2`;

ALTER TABLE `projects_activityLog` DROP FOREIGN KEY `projects_activityLog_FK_1`;

ALTER TABLE `projects_activityLog` DROP FOREIGN KEY `projects_activityLog_FK_2`;

ALTER TABLE `projects_activityLog` DROP FOREIGN KEY `projects_activityLog_FK_3`;

ALTER TABLE `projects_activityLog` DROP FOREIGN KEY `projects_activityLog_FK_4`;

ALTER TABLE `projects_contractor` DROP FOREIGN KEY `projects_contractor_FK_1`;

ALTER TABLE `projects_contractor` DROP FOREIGN KEY `projects_contractor_FK_2`;

ALTER TABLE `projects_document` DROP FOREIGN KEY `projects_document_FK_1`;

ALTER TABLE `projects_document` DROP FOREIGN KEY `projects_document_FK_2`;

ALTER TABLE `projects_indicator` DROP FOREIGN KEY `projects_indicator_FK_1`;

ALTER TABLE `projects_indicator` DROP FOREIGN KEY `projects_indicator_FK_2`;

ALTER TABLE `projects_milestone` DROP FOREIGN KEY `projects_milestone_FK_1`;

ALTER TABLE `projects_milestoneLog` DROP FOREIGN KEY `projects_milestoneLog_FK_1`;

ALTER TABLE `projects_milestoneLog` DROP FOREIGN KEY `projects_milestoneLog_FK_2`;

ALTER TABLE `projects_milestoneLog` DROP FOREIGN KEY `projects_milestoneLog_FK_3`;

ALTER TABLE `projects_project` DROP FOREIGN KEY `projects_project_FK_1`;

ALTER TABLE `projects_project` DROP FOREIGN KEY `projects_project_FK_2`;

ALTER TABLE `projects_project` DROP FOREIGN KEY `projects_project_FK_3`;

ALTER TABLE `projects_project` DROP FOREIGN KEY `projects_project_FK_4`;

ALTER TABLE `projects_projectLog` DROP FOREIGN KEY `projects_projectLog_FK_1`;

ALTER TABLE `projects_projectLog` DROP FOREIGN KEY `projects_projectLog_FK_2`;

ALTER TABLE `projects_projectLog` DROP FOREIGN KEY `projects_projectLog_FK_3`;

ALTER TABLE `projects_projectLog` DROP FOREIGN KEY `projects_projectLog_FK_4`;

ALTER TABLE `projects_region` DROP FOREIGN KEY `projects_region_FK_1`;

ALTER TABLE `projects_region` DROP FOREIGN KEY `projects_region_FK_2`;

ALTER TABLE `regions_point` DROP FOREIGN KEY `regions_point_FK_1`;

ALTER TABLE `regions_point` CHANGE `latitude` `latitude` DECIMAL(12,9);

ALTER TABLE `regions_point` CHANGE `longitude` `longitude` DECIMAL(12,9);

ALTER TABLE `regions_region` CHANGE `latitude` `latitude` DECIMAL(12,9);

ALTER TABLE `regions_region` CHANGE `longitude` `longitude` DECIMAL(12,9);

ALTER TABLE `security_action` DROP FOREIGN KEY `security_action_FK_1`;

ALTER TABLE `security_blockedUser` CHANGE `unBlocked` `unBlocked` TINYINT(1);

ALTER TABLE `security_loginFailure` CHANGE `blocked` `blocked` TINYINT(1);

ALTER TABLE `security_securityFailure` CHANGE `blocked` `blocked` TINYINT(1);

ALTER TABLE `users_groupCategory` DROP FOREIGN KEY `users_groupCategory_FK_1`;

ALTER TABLE `users_groupCategory` DROP FOREIGN KEY `users_groupCategory_FK_2`;

ALTER TABLE `users_user` DROP FOREIGN KEY `users_user_FK_1`;

ALTER TABLE `users_user` CHANGE `active` `active` TINYINT(1) NOT NULL;

ALTER TABLE `users_userGroup` DROP FOREIGN KEY `users_userGroup_FK_1`;

ALTER TABLE `users_userGroup` DROP FOREIGN KEY `users_userGroup_FK_2`;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
',
);
    }

}