<?php


/**
 * Base static class for performing query and update operations on the 'projects_activityLog' table.
 *
 * Activity Log
 *
 * @package propel.generator.projects.classes.om
 */
abstract class BaseProjectActivityLogPeer
{

    /** the default database name for this class */
    const DATABASE_NAME = 'application';

    /** the table name for this class */
    const TABLE_NAME = 'projects_activityLog';

    /** the related Propel class for this table */
    const OM_CLASS = 'ProjectActivityLog';

    /** the related TableMap class for this table */
    const TM_CLASS = 'ProjectActivityLogTableMap';

    /** The total number of columns. */
    const NUM_COLUMNS = 26;

    /** The number of lazy-loaded columns. */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /** The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS) */
    const NUM_HYDRATE_COLUMNS = 26;

    /** the column name for the ID field */
    const ID = 'projects_activityLog.ID';

    /** the column name for the ACTIVITYID field */
    const ACTIVITYID = 'projects_activityLog.ACTIVITYID';

    /** the column name for the PROJECTID field */
    const PROJECTID = 'projects_activityLog.PROJECTID';

    /** the column name for the NAME field */
    const NAME = 'projects_activityLog.NAME';

    /** the column name for the DESCRIPTION field */
    const DESCRIPTION = 'projects_activityLog.DESCRIPTION';

    /** the column name for the DATE field */
    const DATE = 'projects_activityLog.DATE';

    /** the column name for the EXPIRATIONDATE field */
    const EXPIRATIONDATE = 'projects_activityLog.EXPIRATIONDATE';

    /** the column name for the COMPLETED field */
    const COMPLETED = 'projects_activityLog.COMPLETED';

    /** the column name for the UNIQUEGOALNUMERIC field */
    const UNIQUEGOALNUMERIC = 'projects_activityLog.UNIQUEGOALNUMERIC';

    /** the column name for the GOALPROGRESS field */
    const GOALPROGRESS = 'projects_activityLog.GOALPROGRESS';

    /** the column name for the NOTES field */
    const NOTES = 'projects_activityLog.NOTES';

    /** the column name for the USERID field */
    const USERID = 'projects_activityLog.USERID';

    /** the column name for the USERBYAFFILIATESID field */
    const USERBYAFFILIATESID = 'projects_activityLog.USERBYAFFILIATESID';

    /** the column name for the UPDATED field */
    const UPDATED = 'projects_activityLog.UPDATED';

    /** the column name for the LASTMODIFICATION field */
    const LASTMODIFICATION = 'projects_activityLog.LASTMODIFICATION';

    /** the column name for the CHANGES field */
    const CHANGES = 'projects_activityLog.CHANGES';

    /** the column name for the PLANNEDSTART field */
    const PLANNEDSTART = 'projects_activityLog.PLANNEDSTART';

    /** the column name for the PLANNEDEND field */
    const PLANNEDEND = 'projects_activityLog.PLANNEDEND';

    /** the column name for the REALSTART field */
    const REALSTART = 'projects_activityLog.REALSTART';

    /** the column name for the REALEND field */
    const REALEND = 'projects_activityLog.REALEND';

    /** the column name for the CANCELLED field */
    const CANCELLED = 'projects_activityLog.CANCELLED';

    /** the column name for the STARTINGYEAR field */
    const STARTINGYEAR = 'projects_activityLog.STARTINGYEAR';

    /** the column name for the ENDINGYEAR field */
    const ENDINGYEAR = 'projects_activityLog.ENDINGYEAR';

    /** the column name for the PRESS field */
    const PRESS = 'projects_activityLog.PRESS';

    /** the column name for the BUDGET field */
    const BUDGET = 'projects_activityLog.BUDGET';

    /** the column name for the RESPONSIBLECODE field */
    const RESPONSIBLECODE = 'projects_activityLog.RESPONSIBLECODE';

    /** The default string format for model objects of the related table **/
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * An identiy map to hold any loaded instances of ProjectActivityLog objects.
     * This must be public so that other peer classes can access this when hydrating from JOIN
     * queries.
     * @var        array ProjectActivityLog[]
     */
    public static $instances = array();


    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. ProjectActivityLogPeer::$fieldNames[ProjectActivityLogPeer::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        BasePeer::TYPE_PHPNAME => array ('Id', 'Activityid', 'Projectid', 'Name', 'Description', 'Date', 'Expirationdate', 'Completed', 'Uniquegoalnumeric', 'Goalprogress', 'Notes', 'Userid', 'Userbyaffiliatesid', 'Updated', 'Lastmodification', 'Changes', 'Plannedstart', 'Plannedend', 'Realstart', 'Realend', 'Cancelled', 'Startingyear', 'Endingyear', 'Press', 'Budget', 'Responsiblecode', ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id', 'activityid', 'projectid', 'name', 'description', 'date', 'expirationdate', 'completed', 'uniquegoalnumeric', 'goalprogress', 'notes', 'userid', 'userbyaffiliatesid', 'updated', 'lastmodification', 'changes', 'plannedstart', 'plannedend', 'realstart', 'realend', 'cancelled', 'startingyear', 'endingyear', 'press', 'budget', 'responsiblecode', ),
        BasePeer::TYPE_COLNAME => array (ProjectActivityLogPeer::ID, ProjectActivityLogPeer::ACTIVITYID, ProjectActivityLogPeer::PROJECTID, ProjectActivityLogPeer::NAME, ProjectActivityLogPeer::DESCRIPTION, ProjectActivityLogPeer::DATE, ProjectActivityLogPeer::EXPIRATIONDATE, ProjectActivityLogPeer::COMPLETED, ProjectActivityLogPeer::UNIQUEGOALNUMERIC, ProjectActivityLogPeer::GOALPROGRESS, ProjectActivityLogPeer::NOTES, ProjectActivityLogPeer::USERID, ProjectActivityLogPeer::USERBYAFFILIATESID, ProjectActivityLogPeer::UPDATED, ProjectActivityLogPeer::LASTMODIFICATION, ProjectActivityLogPeer::CHANGES, ProjectActivityLogPeer::PLANNEDSTART, ProjectActivityLogPeer::PLANNEDEND, ProjectActivityLogPeer::REALSTART, ProjectActivityLogPeer::REALEND, ProjectActivityLogPeer::CANCELLED, ProjectActivityLogPeer::STARTINGYEAR, ProjectActivityLogPeer::ENDINGYEAR, ProjectActivityLogPeer::PRESS, ProjectActivityLogPeer::BUDGET, ProjectActivityLogPeer::RESPONSIBLECODE, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID', 'ACTIVITYID', 'PROJECTID', 'NAME', 'DESCRIPTION', 'DATE', 'EXPIRATIONDATE', 'COMPLETED', 'UNIQUEGOALNUMERIC', 'GOALPROGRESS', 'NOTES', 'USERID', 'USERBYAFFILIATESID', 'UPDATED', 'LASTMODIFICATION', 'CHANGES', 'PLANNEDSTART', 'PLANNEDEND', 'REALSTART', 'REALEND', 'CANCELLED', 'STARTINGYEAR', 'ENDINGYEAR', 'PRESS', 'BUDGET', 'RESPONSIBLECODE', ),
        BasePeer::TYPE_FIELDNAME => array ('id', 'activityId', 'projectId', 'name', 'description', 'date', 'expirationDate', 'completed', 'uniqueGoalNumeric', 'goalProgress', 'notes', 'userId', 'userByAffiliatesId', 'updated', 'lastModification', 'changes', 'plannedStart', 'plannedEnd', 'realStart', 'realEnd', 'cancelled', 'startingYear', 'endingYear', 'press', 'budget', 'responsibleCode', ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. ProjectActivityLogPeer::$fieldNames[BasePeer::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Activityid' => 1, 'Projectid' => 2, 'Name' => 3, 'Description' => 4, 'Date' => 5, 'Expirationdate' => 6, 'Completed' => 7, 'Uniquegoalnumeric' => 8, 'Goalprogress' => 9, 'Notes' => 10, 'Userid' => 11, 'Userbyaffiliatesid' => 12, 'Updated' => 13, 'Lastmodification' => 14, 'Changes' => 15, 'Plannedstart' => 16, 'Plannedend' => 17, 'Realstart' => 18, 'Realend' => 19, 'Cancelled' => 20, 'Startingyear' => 21, 'Endingyear' => 22, 'Press' => 23, 'Budget' => 24, 'Responsiblecode' => 25, ),
        BasePeer::TYPE_STUDLYPHPNAME => array ('id' => 0, 'activityid' => 1, 'projectid' => 2, 'name' => 3, 'description' => 4, 'date' => 5, 'expirationdate' => 6, 'completed' => 7, 'uniquegoalnumeric' => 8, 'goalprogress' => 9, 'notes' => 10, 'userid' => 11, 'userbyaffiliatesid' => 12, 'updated' => 13, 'lastmodification' => 14, 'changes' => 15, 'plannedstart' => 16, 'plannedend' => 17, 'realstart' => 18, 'realend' => 19, 'cancelled' => 20, 'startingyear' => 21, 'endingyear' => 22, 'press' => 23, 'budget' => 24, 'responsiblecode' => 25, ),
        BasePeer::TYPE_COLNAME => array (ProjectActivityLogPeer::ID => 0, ProjectActivityLogPeer::ACTIVITYID => 1, ProjectActivityLogPeer::PROJECTID => 2, ProjectActivityLogPeer::NAME => 3, ProjectActivityLogPeer::DESCRIPTION => 4, ProjectActivityLogPeer::DATE => 5, ProjectActivityLogPeer::EXPIRATIONDATE => 6, ProjectActivityLogPeer::COMPLETED => 7, ProjectActivityLogPeer::UNIQUEGOALNUMERIC => 8, ProjectActivityLogPeer::GOALPROGRESS => 9, ProjectActivityLogPeer::NOTES => 10, ProjectActivityLogPeer::USERID => 11, ProjectActivityLogPeer::USERBYAFFILIATESID => 12, ProjectActivityLogPeer::UPDATED => 13, ProjectActivityLogPeer::LASTMODIFICATION => 14, ProjectActivityLogPeer::CHANGES => 15, ProjectActivityLogPeer::PLANNEDSTART => 16, ProjectActivityLogPeer::PLANNEDEND => 17, ProjectActivityLogPeer::REALSTART => 18, ProjectActivityLogPeer::REALEND => 19, ProjectActivityLogPeer::CANCELLED => 20, ProjectActivityLogPeer::STARTINGYEAR => 21, ProjectActivityLogPeer::ENDINGYEAR => 22, ProjectActivityLogPeer::PRESS => 23, ProjectActivityLogPeer::BUDGET => 24, ProjectActivityLogPeer::RESPONSIBLECODE => 25, ),
        BasePeer::TYPE_RAW_COLNAME => array ('ID' => 0, 'ACTIVITYID' => 1, 'PROJECTID' => 2, 'NAME' => 3, 'DESCRIPTION' => 4, 'DATE' => 5, 'EXPIRATIONDATE' => 6, 'COMPLETED' => 7, 'UNIQUEGOALNUMERIC' => 8, 'GOALPROGRESS' => 9, 'NOTES' => 10, 'USERID' => 11, 'USERBYAFFILIATESID' => 12, 'UPDATED' => 13, 'LASTMODIFICATION' => 14, 'CHANGES' => 15, 'PLANNEDSTART' => 16, 'PLANNEDEND' => 17, 'REALSTART' => 18, 'REALEND' => 19, 'CANCELLED' => 20, 'STARTINGYEAR' => 21, 'ENDINGYEAR' => 22, 'PRESS' => 23, 'BUDGET' => 24, 'RESPONSIBLECODE' => 25, ),
        BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'activityId' => 1, 'projectId' => 2, 'name' => 3, 'description' => 4, 'date' => 5, 'expirationDate' => 6, 'completed' => 7, 'uniqueGoalNumeric' => 8, 'goalProgress' => 9, 'notes' => 10, 'userId' => 11, 'userByAffiliatesId' => 12, 'updated' => 13, 'lastModification' => 14, 'changes' => 15, 'plannedStart' => 16, 'plannedEnd' => 17, 'realStart' => 18, 'realEnd' => 19, 'cancelled' => 20, 'startingYear' => 21, 'endingYear' => 22, 'press' => 23, 'budget' => 24, 'responsibleCode' => 25, ),
        BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, )
    );

    /**
     * Translates a fieldname to another type
     *
     * @param      string $name field name
     * @param      string $fromType One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                         BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @param      string $toType   One of the class type constants
     * @return string          translated name of the field.
     * @throws PropelException - if the specified name could not be found in the fieldname mappings.
     */
    public static function translateFieldName($name, $fromType, $toType)
    {
        $toNames = ProjectActivityLogPeer::getFieldNames($toType);
        $key = isset(ProjectActivityLogPeer::$fieldKeys[$fromType][$name]) ? ProjectActivityLogPeer::$fieldKeys[$fromType][$name] : null;
        if ($key === null) {
            throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(ProjectActivityLogPeer::$fieldKeys[$fromType], true));
        }

        return $toNames[$key];
    }

    /**
     * Returns an array of field names.
     *
     * @param      string $type The type of fieldnames to return:
     *                      One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                      BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
     * @return array           A list of field names
     * @throws PropelException - if the type is not valid.
     */
    public static function getFieldNames($type = BasePeer::TYPE_PHPNAME)
    {
        if (!array_key_exists($type, ProjectActivityLogPeer::$fieldNames)) {
            throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME, BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. ' . $type . ' was given.');
        }

        return ProjectActivityLogPeer::$fieldNames[$type];
    }

    /**
     * Convenience method which changes table.column to alias.column.
     *
     * Using this method you can maintain SQL abstraction while using column aliases.
     * <code>
     *		$c->addAlias("alias1", TablePeer::TABLE_NAME);
     *		$c->addJoin(TablePeer::alias("alias1", TablePeer::PRIMARY_KEY_COLUMN), TablePeer::PRIMARY_KEY_COLUMN);
     * </code>
     * @param      string $alias The alias for the current table.
     * @param      string $column The column name for current table. (i.e. ProjectActivityLogPeer::COLUMN_NAME).
     * @return string
     */
    public static function alias($alias, $column)
    {
        return str_replace(ProjectActivityLogPeer::TABLE_NAME.'.', $alias.'.', $column);
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param      Criteria $criteria object containing the columns to add.
     * @param      string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ProjectActivityLogPeer::ID);
            $criteria->addSelectColumn(ProjectActivityLogPeer::ACTIVITYID);
            $criteria->addSelectColumn(ProjectActivityLogPeer::PROJECTID);
            $criteria->addSelectColumn(ProjectActivityLogPeer::NAME);
            $criteria->addSelectColumn(ProjectActivityLogPeer::DESCRIPTION);
            $criteria->addSelectColumn(ProjectActivityLogPeer::DATE);
            $criteria->addSelectColumn(ProjectActivityLogPeer::EXPIRATIONDATE);
            $criteria->addSelectColumn(ProjectActivityLogPeer::COMPLETED);
            $criteria->addSelectColumn(ProjectActivityLogPeer::UNIQUEGOALNUMERIC);
            $criteria->addSelectColumn(ProjectActivityLogPeer::GOALPROGRESS);
            $criteria->addSelectColumn(ProjectActivityLogPeer::NOTES);
            $criteria->addSelectColumn(ProjectActivityLogPeer::USERID);
            $criteria->addSelectColumn(ProjectActivityLogPeer::USERBYAFFILIATESID);
            $criteria->addSelectColumn(ProjectActivityLogPeer::UPDATED);
            $criteria->addSelectColumn(ProjectActivityLogPeer::LASTMODIFICATION);
            $criteria->addSelectColumn(ProjectActivityLogPeer::CHANGES);
            $criteria->addSelectColumn(ProjectActivityLogPeer::PLANNEDSTART);
            $criteria->addSelectColumn(ProjectActivityLogPeer::PLANNEDEND);
            $criteria->addSelectColumn(ProjectActivityLogPeer::REALSTART);
            $criteria->addSelectColumn(ProjectActivityLogPeer::REALEND);
            $criteria->addSelectColumn(ProjectActivityLogPeer::CANCELLED);
            $criteria->addSelectColumn(ProjectActivityLogPeer::STARTINGYEAR);
            $criteria->addSelectColumn(ProjectActivityLogPeer::ENDINGYEAR);
            $criteria->addSelectColumn(ProjectActivityLogPeer::PRESS);
            $criteria->addSelectColumn(ProjectActivityLogPeer::BUDGET);
            $criteria->addSelectColumn(ProjectActivityLogPeer::RESPONSIBLECODE);
        } else {
            $criteria->addSelectColumn($alias . '.ID');
            $criteria->addSelectColumn($alias . '.ACTIVITYID');
            $criteria->addSelectColumn($alias . '.PROJECTID');
            $criteria->addSelectColumn($alias . '.NAME');
            $criteria->addSelectColumn($alias . '.DESCRIPTION');
            $criteria->addSelectColumn($alias . '.DATE');
            $criteria->addSelectColumn($alias . '.EXPIRATIONDATE');
            $criteria->addSelectColumn($alias . '.COMPLETED');
            $criteria->addSelectColumn($alias . '.UNIQUEGOALNUMERIC');
            $criteria->addSelectColumn($alias . '.GOALPROGRESS');
            $criteria->addSelectColumn($alias . '.NOTES');
            $criteria->addSelectColumn($alias . '.USERID');
            $criteria->addSelectColumn($alias . '.USERBYAFFILIATESID');
            $criteria->addSelectColumn($alias . '.UPDATED');
            $criteria->addSelectColumn($alias . '.LASTMODIFICATION');
            $criteria->addSelectColumn($alias . '.CHANGES');
            $criteria->addSelectColumn($alias . '.PLANNEDSTART');
            $criteria->addSelectColumn($alias . '.PLANNEDEND');
            $criteria->addSelectColumn($alias . '.REALSTART');
            $criteria->addSelectColumn($alias . '.REALEND');
            $criteria->addSelectColumn($alias . '.CANCELLED');
            $criteria->addSelectColumn($alias . '.STARTINGYEAR');
            $criteria->addSelectColumn($alias . '.ENDINGYEAR');
            $criteria->addSelectColumn($alias . '.PRESS');
            $criteria->addSelectColumn($alias . '.BUDGET');
            $criteria->addSelectColumn($alias . '.RESPONSIBLECODE');
        }
    }

    /**
     * Returns the number of rows matching criteria.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @return int Number of matching rows.
     */
    public static function doCount(Criteria $criteria, $distinct = false, PropelPDO $con = null)
    {
        // we may modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME); // Set the correct dbName

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        // BasePeer returns a PDOStatement
        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }
    /**
     * Selects one object from the DB.
     *
     * @param      Criteria $criteria object used to create the SELECT statement.
     * @param      PropelPDO $con
     * @return                 ProjectActivityLog
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectOne(Criteria $criteria, PropelPDO $con = null)
    {
        $critcopy = clone $criteria;
        $critcopy->setLimit(1);
        $objects = ProjectActivityLogPeer::doSelect($critcopy, $con);
        if ($objects) {
            return $objects[0];
        }

        return null;
    }
    /**
     * Selects several row from the DB.
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con
     * @return array           Array of selected Objects
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelect(Criteria $criteria, PropelPDO $con = null)
    {
        return ProjectActivityLogPeer::populateObjects(ProjectActivityLogPeer::doSelectStmt($criteria, $con));
    }
    /**
     * Prepares the Criteria object and uses the parent doSelect() method to execute a PDOStatement.
     *
     * Use this method directly if you want to work with an executed statement durirectly (for example
     * to perform your own object hydration).
     *
     * @param      Criteria $criteria The Criteria object used to build the SELECT statement.
     * @param      PropelPDO $con The connection to use
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return PDOStatement The executed PDOStatement object.
     * @see        BasePeer::doSelect()
     */
    public static function doSelectStmt(Criteria $criteria, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        if (!$criteria->hasSelectClause()) {
            $criteria = clone $criteria;
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        // BasePeer returns a PDOStatement
        return BasePeer::doSelect($criteria, $con);
    }
    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doSelect*()
     * methods in your stub classes -- you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by doSelect*()
     * and retrieveByPK*() calls.
     *
     * @param      ProjectActivityLog $obj A ProjectActivityLog object.
     * @param      string $key (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if ($key === null) {
                $key = (string) $obj->getId();
            } // if key === null
            ProjectActivityLogPeer::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param      mixed $value A ProjectActivityLog object or a primary key value.
     *
     * @return void
     * @throws PropelException - if the value is invalid.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && $value !== null) {
            if (is_object($value) && $value instanceof ProjectActivityLog) {
                $key = (string) $value->getId();
            } elseif (is_scalar($value)) {
                // assume we've been passed a primary key
                $key = (string) $value;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or ProjectActivityLog object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value,true)));
                throw $e;
            }

            unset(ProjectActivityLogPeer::$instances[$key]);
        }
    } // removeInstanceFromPool()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      string $key The key (@see getPrimaryKeyHash()) for this instance.
     * @return   ProjectActivityLog Found object or null if 1) no instance exists for specified key or 2) instance pooling has been disabled.
     * @see        getPrimaryKeyHash()
     */
    public static function getInstanceFromPool($key)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (isset(ProjectActivityLogPeer::$instances[$key])) {
                return ProjectActivityLogPeer::$instances[$key];
            }
        }

        return null; // just to be explicit
    }

    /**
     * Clear the instance pool.
     *
     * @return void
     */
    public static function clearInstancePool()
    {
        ProjectActivityLogPeer::$instances = array();
    }

    /**
     * Method to invalidate the instance pool of all tables related to projects_activityLog
     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return string A string version of PK or null if the components of primary key in result array are all null.
     */
    public static function getPrimaryKeyHashFromRow($row, $startcol = 0)
    {
        // If the PK cannot be derived from the row, return null.
        if ($row[$startcol] === null) {
            return null;
        }

        return (string) $row[$startcol];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $startcol = 0)
    {

        return (int) $row[$startcol];
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function populateObjects(PDOStatement $stmt)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = ProjectActivityLogPeer::getOMClass();
        // populate the object(s)
        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj = ProjectActivityLogPeer::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ProjectActivityLogPeer::addInstanceToPool($obj, $key);
            } // if key exists
        }
        $stmt->closeCursor();

        return $results;
    }
    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param      array $row PropelPDO resultset row.
     * @param      int $startcol The 0-based offset for reading from the resultset row.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     * @return array (ProjectActivityLog object, last column rank)
     */
    public static function populateObject($row, $startcol = 0)
    {
        $key = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, $startcol);
        if (null !== ($obj = ProjectActivityLogPeer::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $startcol, true); // rehydrate
            $col = $startcol + ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ProjectActivityLogPeer::OM_CLASS;
            $obj = new $cls();
            $col = $obj->hydrate($row, $startcol);
            ProjectActivityLogPeer::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }


    /**
     * Returns the number of rows matching criteria, joining the related Project table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinProject(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related ProjectActivity table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinProjectActivity(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with their Project objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinProject(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;
        ProjectPeer::addSelectColumns($criteria);

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ProjectPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ProjectActivityLog) to $obj2 (Project)
                $obj2->addProjectActivityLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with their ProjectActivity objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinProjectActivity(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;
        ProjectActivityPeer::addSelectColumns($criteria);

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = ProjectActivityPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ProjectActivityPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    ProjectActivityPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ProjectActivityLog) to $obj2 (ProjectActivity)
                $obj2->addProjectActivityLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with their User objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;
        UserPeer::addSelectColumns($criteria);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = UserPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = UserPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    UserPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ProjectActivityLog) to $obj2 (User)
                $obj2->addProjectActivityLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with their Position objects.
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;
        PositionPeer::addSelectColumns($criteria);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {

                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if $obj1 already loaded

            $key2 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol);
            if ($key2 !== null) {
                $obj2 = PositionPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = PositionPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol);
                    PositionPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 already loaded

                // Add the $obj1 (ProjectActivityLog) to $obj2 (Position)
                $obj2->addProjectActivityLog($obj1);

            } // if joined row was not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining all related tables
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAll(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY won't ever affect the count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }

    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with all related objects.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAll(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ProjectActivityPeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol6 = $startcol5 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

            // Add objects for joined Project rows

            $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
            if ($key2 !== null) {
                $obj2 = ProjectPeer::getInstanceFromPool($key2);
                if (!$obj2) {

                    $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if obj2 loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj2 (Project)
                $obj2->addProjectActivityLog($obj1);
            } // if joined row not null

            // Add objects for joined ProjectActivity rows

            $key3 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, $startcol3);
            if ($key3 !== null) {
                $obj3 = ProjectActivityPeer::getInstanceFromPool($key3);
                if (!$obj3) {

                    $cls = ProjectActivityPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ProjectActivityPeer::addInstanceToPool($obj3, $key3);
                } // if obj3 loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj3 (ProjectActivity)
                $obj3->addProjectActivityLog($obj1);
            } // if joined row not null

            // Add objects for joined User rows

            $key4 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol4);
            if ($key4 !== null) {
                $obj4 = UserPeer::getInstanceFromPool($key4);
                if (!$obj4) {

                    $cls = UserPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    UserPeer::addInstanceToPool($obj4, $key4);
                } // if obj4 loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj4 (User)
                $obj4->addProjectActivityLog($obj1);
            } // if joined row not null

            // Add objects for joined Position rows

            $key5 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol5);
            if ($key5 !== null) {
                $obj5 = PositionPeer::getInstanceFromPool($key5);
                if (!$obj5) {

                    $cls = PositionPeer::getOMClass();

                    $obj5 = new $cls();
                    $obj5->hydrate($row, $startcol5);
                    PositionPeer::addInstanceToPool($obj5, $key5);
                } // if obj5 loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj5 (Position)
                $obj5->addProjectActivityLog($obj1);
            } // if joined row not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Project table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptProject(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related ProjectActivity table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptProjectActivity(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related User table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptUser(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Returns the number of rows matching criteria, joining the related Position table
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct Whether to select only distinct columns; deprecated: use Criteria->setDistinct() instead.
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return int Number of matching rows.
     */
    public static function doCountJoinAllExceptPosition(Criteria $criteria, $distinct = false, PropelPDO $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        // we're going to modify criteria, so copy it first
        $criteria = clone $criteria;

        // We need to set the primary table name, since in the case that there are no WHERE columns
        // it will be impossible for the BasePeer::createSelectSql() method to determine which
        // tables go into the FROM clause.
        $criteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);

        if ($distinct && !in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
            $criteria->setDistinct();
        }

        if (!$criteria->hasSelectClause()) {
            ProjectActivityLogPeer::addSelectColumns($criteria);
        }

        $criteria->clearOrderByColumns(); // ORDER BY should not affect count

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $stmt = BasePeer::doCount($criteria, $con);

        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $count = (int) $row[0];
        } else {
            $count = 0; // no rows returned; we infer that means 0 matches.
        }
        $stmt->closeCursor();

        return $count;
    }


    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with all related objects except Project.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptProject(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectActivityPeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined ProjectActivity rows

                $key2 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ProjectActivityPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ProjectActivityPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectActivityPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj2 (ProjectActivity)
                $obj2->addProjectActivityLog($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key3 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = UserPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = UserPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    UserPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj3 (User)
                $obj3->addProjectActivityLog($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key4 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = PositionPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = PositionPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PositionPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj4 (Position)
                $obj4->addProjectActivityLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with all related objects except ProjectActivity.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptProjectActivity(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + UserPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Project rows

                $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ProjectPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj2 (Project)
                $obj2->addProjectActivityLog($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key3 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = UserPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = UserPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    UserPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj3 (User)
                $obj3->addProjectActivityLog($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key4 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = PositionPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = PositionPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PositionPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj4 (Position)
                $obj4->addProjectActivityLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with all related objects except User.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptUser(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ProjectActivityPeer::NUM_HYDRATE_COLUMNS;

        PositionPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + PositionPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::RESPONSIBLECODE, PositionPeer::CODE, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Project rows

                $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ProjectPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj2 (Project)
                $obj2->addProjectActivityLog($obj1);

            } // if joined row is not null

                // Add objects for joined ProjectActivity rows

                $key3 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = ProjectActivityPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = ProjectActivityPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ProjectActivityPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj3 (ProjectActivity)
                $obj3->addProjectActivityLog($obj1);

            } // if joined row is not null

                // Add objects for joined Position rows

                $key4 = PositionPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = PositionPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = PositionPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    PositionPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj4 (Position)
                $obj4->addProjectActivityLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }


    /**
     * Selects a collection of ProjectActivityLog objects pre-filled with all related objects except Position.
     *
     * @param      Criteria  $criteria
     * @param      PropelPDO $con
     * @param      String    $join_behavior the type of joins to use, defaults to Criteria::LEFT_JOIN
     * @return array           Array of ProjectActivityLog objects.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doSelectJoinAllExceptPosition(Criteria $criteria, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $criteria = clone $criteria;

        // Set the correct dbName if it has not been overridden
        // $criteria->getDbName() will return the same object if not set to another value
        // so == check is okay and faster
        if ($criteria->getDbName() == Propel::getDefaultDB()) {
            $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);
        }

        ProjectActivityLogPeer::addSelectColumns($criteria);
        $startcol2 = ProjectActivityLogPeer::NUM_HYDRATE_COLUMNS;

        ProjectPeer::addSelectColumns($criteria);
        $startcol3 = $startcol2 + ProjectPeer::NUM_HYDRATE_COLUMNS;

        ProjectActivityPeer::addSelectColumns($criteria);
        $startcol4 = $startcol3 + ProjectActivityPeer::NUM_HYDRATE_COLUMNS;

        UserPeer::addSelectColumns($criteria);
        $startcol5 = $startcol4 + UserPeer::NUM_HYDRATE_COLUMNS;

        $criteria->addJoin(ProjectActivityLogPeer::PROJECTID, ProjectPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::ACTIVITYID, ProjectActivityPeer::ID, $join_behavior);

        $criteria->addJoin(ProjectActivityLogPeer::USERID, UserPeer::ID, $join_behavior);


        $stmt = BasePeer::doSelect($criteria, $con);
        $results = array();

        while ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $key1 = ProjectActivityLogPeer::getPrimaryKeyHashFromRow($row, 0);
            if (null !== ($obj1 = ProjectActivityLogPeer::getInstanceFromPool($key1))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj1->hydrate($row, 0, true); // rehydrate
            } else {
                $cls = ProjectActivityLogPeer::getOMClass();

                $obj1 = new $cls();
                $obj1->hydrate($row);
                ProjectActivityLogPeer::addInstanceToPool($obj1, $key1);
            } // if obj1 already loaded

                // Add objects for joined Project rows

                $key2 = ProjectPeer::getPrimaryKeyHashFromRow($row, $startcol2);
                if ($key2 !== null) {
                    $obj2 = ProjectPeer::getInstanceFromPool($key2);
                    if (!$obj2) {

                        $cls = ProjectPeer::getOMClass();

                    $obj2 = new $cls();
                    $obj2->hydrate($row, $startcol2);
                    ProjectPeer::addInstanceToPool($obj2, $key2);
                } // if $obj2 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj2 (Project)
                $obj2->addProjectActivityLog($obj1);

            } // if joined row is not null

                // Add objects for joined ProjectActivity rows

                $key3 = ProjectActivityPeer::getPrimaryKeyHashFromRow($row, $startcol3);
                if ($key3 !== null) {
                    $obj3 = ProjectActivityPeer::getInstanceFromPool($key3);
                    if (!$obj3) {

                        $cls = ProjectActivityPeer::getOMClass();

                    $obj3 = new $cls();
                    $obj3->hydrate($row, $startcol3);
                    ProjectActivityPeer::addInstanceToPool($obj3, $key3);
                } // if $obj3 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj3 (ProjectActivity)
                $obj3->addProjectActivityLog($obj1);

            } // if joined row is not null

                // Add objects for joined User rows

                $key4 = UserPeer::getPrimaryKeyHashFromRow($row, $startcol4);
                if ($key4 !== null) {
                    $obj4 = UserPeer::getInstanceFromPool($key4);
                    if (!$obj4) {

                        $cls = UserPeer::getOMClass();

                    $obj4 = new $cls();
                    $obj4->hydrate($row, $startcol4);
                    UserPeer::addInstanceToPool($obj4, $key4);
                } // if $obj4 already loaded

                // Add the $obj1 (ProjectActivityLog) to the collection in $obj4 (User)
                $obj4->addProjectActivityLog($obj1);

            } // if joined row is not null

            $results[] = $obj1;
        }
        $stmt->closeCursor();

        return $results;
    }

    /**
     * Returns the TableMap related to this peer.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getDatabaseMap(ProjectActivityLogPeer::DATABASE_NAME)->getTable(ProjectActivityLogPeer::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this peer class.
     */
    public static function buildTableMap()
    {
      $dbMap = Propel::getDatabaseMap(BaseProjectActivityLogPeer::DATABASE_NAME);
      if (!$dbMap->hasTable(BaseProjectActivityLogPeer::TABLE_NAME)) {
        $dbMap->addTableObject(new ProjectActivityLogTableMap());
      }
    }

    /**
     * The class that the Peer will make instances of.
     *
     *
     * @return string ClassName
     */
    public static function getOMClass()
    {
        return ProjectActivityLogPeer::OM_CLASS;
    }

    /**
     * Performs an INSERT on the database, given a ProjectActivityLog or Criteria object.
     *
     * @param      mixed $values Criteria or ProjectActivityLog object containing data that is used to create the INSERT statement.
     * @param      PropelPDO $con the PropelPDO connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doInsert($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity
        } else {
            $criteria = $values->buildCriteria(); // build Criteria from ProjectActivityLog object
        }

        if ($criteria->containsKey(ProjectActivityLogPeer::ID) && $criteria->keyContainsValue(ProjectActivityLogPeer::ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ProjectActivityLogPeer::ID.')');
        }


        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        try {
            // use transaction because $criteria could contain info
            // for more than one table (I guess, conceivably)
            $con->beginTransaction();
            $pk = BasePeer::doInsert($criteria, $con);
            $con->commit();
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }

        return $pk;
    }

    /**
     * Performs an UPDATE on the database, given a ProjectActivityLog or Criteria object.
     *
     * @param      mixed $values Criteria or ProjectActivityLog object containing data that is used to create the UPDATE statement.
     * @param      PropelPDO $con The connection to use (specify PropelPDO connection object to exert more control over transactions).
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function doUpdate($values, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $selectCriteria = new Criteria(ProjectActivityLogPeer::DATABASE_NAME);

        if ($values instanceof Criteria) {
            $criteria = clone $values; // rename for clarity

            $comparison = $criteria->getComparison(ProjectActivityLogPeer::ID);
            $value = $criteria->remove(ProjectActivityLogPeer::ID);
            if ($value) {
                $selectCriteria->add(ProjectActivityLogPeer::ID, $value, $comparison);
            } else {
                $selectCriteria->setPrimaryTableName(ProjectActivityLogPeer::TABLE_NAME);
            }

        } else { // $values is ProjectActivityLog object
            $criteria = $values->buildCriteria(); // gets full criteria
            $selectCriteria = $values->buildPkeyCriteria(); // gets criteria w/ primary key(s)
        }

        // set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        return BasePeer::doUpdate($selectCriteria, $criteria, $con);
    }

    /**
     * Deletes all rows from the projects_activityLog table.
     *
     * @param      PropelPDO $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).
     * @throws PropelException
     */
    public static function doDeleteAll(PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }
        $affectedRows = 0; // initialize var to track total num of affected rows
        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();
            $affectedRows += BasePeer::doDeleteAll(ProjectActivityLogPeer::TABLE_NAME, $con, ProjectActivityLogPeer::DATABASE_NAME);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ProjectActivityLogPeer::clearInstancePool();
            ProjectActivityLogPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs a DELETE on the database, given a ProjectActivityLog or Criteria object OR a primary key value.
     *
     * @param      mixed $values Criteria or ProjectActivityLog object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param      PropelPDO $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *				if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, PropelPDO $con = null)
     {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        if ($values instanceof Criteria) {
            // invalidate the cache for all objects of this type, since we have no
            // way of knowing (without running a query) what objects should be invalidated
            // from the cache based on this Criteria.
            ProjectActivityLogPeer::clearInstancePool();
            // rename for clarity
            $criteria = clone $values;
        } elseif ($values instanceof ProjectActivityLog) { // it's a model object
            // invalidate the cache for this single object
            ProjectActivityLogPeer::removeInstanceFromPool($values);
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ProjectActivityLogPeer::DATABASE_NAME);
            $criteria->add(ProjectActivityLogPeer::ID, (array) $values, Criteria::IN);
            // invalidate the cache for this object(s)
            foreach ((array) $values as $singleval) {
                ProjectActivityLogPeer::removeInstanceFromPool($singleval);
            }
        }

        // Set the correct dbName
        $criteria->setDbName(ProjectActivityLogPeer::DATABASE_NAME);

        $affectedRows = 0; // initialize var to track total num of affected rows

        try {
            // use transaction because $criteria could contain info
            // for more than one table or we could emulating ON DELETE CASCADE, etc.
            $con->beginTransaction();

            $affectedRows += BasePeer::doDelete($criteria, $con);
            ProjectActivityLogPeer::clearRelatedInstancePool();
            $con->commit();

            return $affectedRows;
        } catch (PropelException $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Validates all modified columns of given ProjectActivityLog object.
     * If parameter $columns is either a single column name or an array of column names
     * than only those columns are validated.
     *
     * NOTICE: This does not apply to primary or foreign keys for now.
     *
     * @param      ProjectActivityLog $obj The object to validate.
     * @param      mixed $cols Column name or array of column names.
     *
     * @return mixed TRUE if all columns are valid or the error message of the first invalid column.
     */
    public static function doValidate($obj, $cols = null)
    {
        $columns = array();

        if ($cols) {
            $dbMap = Propel::getDatabaseMap(ProjectActivityLogPeer::DATABASE_NAME);
            $tableMap = $dbMap->getTable(ProjectActivityLogPeer::TABLE_NAME);

            if (! is_array($cols)) {
                $cols = array($cols);
            }

            foreach ($cols as $colName) {
                if ($tableMap->hasColumn($colName)) {
                    $get = 'get' . $tableMap->getColumn($colName)->getPhpName();
                    $columns[$colName] = $obj->$get();
                }
            }
        } else {

        }

        return BasePeer::doValidate(ProjectActivityLogPeer::DATABASE_NAME, ProjectActivityLogPeer::TABLE_NAME, $columns);
    }

    /**
     * Retrieve a single object by pkey.
     *
     * @param      int $pk the primary key.
     * @param      PropelPDO $con the connection to use
     * @return ProjectActivityLog
     */
    public static function retrieveByPK($pk, PropelPDO $con = null)
    {

        if (null !== ($obj = ProjectActivityLogPeer::getInstanceFromPool((string) $pk))) {
            return $obj;
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $criteria = new Criteria(ProjectActivityLogPeer::DATABASE_NAME);
        $criteria->add(ProjectActivityLogPeer::ID, $pk);

        $v = ProjectActivityLogPeer::doSelect($criteria, $con);

        return !empty($v) > 0 ? $v[0] : null;
    }

    /**
     * Retrieve multiple objects by pkey.
     *
     * @param      array $pks List of primary keys
     * @param      PropelPDO $con the connection to use
     * @return ProjectActivityLog[]
     * @throws PropelException Any exceptions caught during processing will be
     *		 rethrown wrapped into a PropelException.
     */
    public static function retrieveByPKs($pks, PropelPDO $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection(ProjectActivityLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        $objs = null;
        if (empty($pks)) {
            $objs = array();
        } else {
            $criteria = new Criteria(ProjectActivityLogPeer::DATABASE_NAME);
            $criteria->add(ProjectActivityLogPeer::ID, $pks, Criteria::IN);
            $objs = ProjectActivityLogPeer::doSelect($criteria, $con);
        }

        return $objs;
    }

} // BaseProjectActivityLogPeer

// This is the static code needed to register the TableMap for this table with the main Propel class.
//
BaseProjectActivityLogPeer::buildTableMap();

