<?php


/**
 * Base class that represents a query for the 'panel_notification' table.
 *
 *
 *
 * @method NotificationQuery orderById($order = Criteria::ASC) Order by the id column
 * @method NotificationQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method NotificationQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 * @method NotificationQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method NotificationQuery orderByDeliveredon($order = Criteria::ASC) Order by the deliveredOn column
 * @method NotificationQuery orderByMailaddress($order = Criteria::ASC) Order by the mailAddress column
 * @method NotificationQuery orderByMailbody($order = Criteria::ASC) Order by the mailBody column
 * @method NotificationQuery orderByResult($order = Criteria::ASC) Order by the result column
 *
 * @method NotificationQuery groupById() Group by the id column
 * @method NotificationQuery groupByObjecttype() Group by the objectType column
 * @method NotificationQuery groupByObjectid() Group by the objectId column
 * @method NotificationQuery groupByType() Group by the type column
 * @method NotificationQuery groupByDeliveredon() Group by the deliveredOn column
 * @method NotificationQuery groupByMailaddress() Group by the mailAddress column
 * @method NotificationQuery groupByMailbody() Group by the mailBody column
 * @method NotificationQuery groupByResult() Group by the result column
 *
 * @method NotificationQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method NotificationQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method NotificationQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method Notification findOne(PropelPDO $con = null) Return the first Notification matching the query
 * @method Notification findOneOrCreate(PropelPDO $con = null) Return the first Notification matching the query, or a new Notification object populated from the query conditions when no match is found
 *
 * @method Notification findOneById(int $id) Return the first Notification filtered by the id column
 * @method Notification findOneByObjecttype(string $objectType) Return the first Notification filtered by the objectType column
 * @method Notification findOneByObjectid(int $objectId) Return the first Notification filtered by the objectId column
 * @method Notification findOneByType(int $type) Return the first Notification filtered by the type column
 * @method Notification findOneByDeliveredon(string $deliveredOn) Return the first Notification filtered by the deliveredOn column
 * @method Notification findOneByMailaddress(string $mailAddress) Return the first Notification filtered by the mailAddress column
 * @method Notification findOneByMailbody(string $mailBody) Return the first Notification filtered by the mailBody column
 * @method Notification findOneByResult(int $result) Return the first Notification filtered by the result column
 *
 * @method array findById(int $id) Return Notification objects filtered by the id column
 * @method array findByObjecttype(string $objectType) Return Notification objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return Notification objects filtered by the objectId column
 * @method array findByType(int $type) Return Notification objects filtered by the type column
 * @method array findByDeliveredon(string $deliveredOn) Return Notification objects filtered by the deliveredOn column
 * @method array findByMailaddress(string $mailAddress) Return Notification objects filtered by the mailAddress column
 * @method array findByMailbody(string $mailBody) Return Notification objects filtered by the mailBody column
 * @method array findByResult(int $result) Return Notification objects filtered by the result column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseNotificationQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseNotificationQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Notification', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new NotificationQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     NotificationQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return NotificationQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof NotificationQuery) {
            return $criteria;
        }
        $query = new NotificationQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Notification|Notification[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = NotificationPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(NotificationPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Notification A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `OBJECTTYPE`, `OBJECTID`, `TYPE`, `DELIVEREDON`, `MAILADDRESS`, `MAILBODY`, `RESULT` FROM `panel_notification` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Notification();
            $obj->hydrate($row);
            NotificationPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Notification|Notification[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Notification[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(NotificationPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(NotificationPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(NotificationPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(NotificationPeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(NotificationPeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(NotificationPeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(NotificationPeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType(1234); // WHERE type = 1234
     * $query->filterByType(array(12, 34)); // WHERE type IN (12, 34)
     * $query->filterByType(array('min' => 12)); // WHERE type > 12
     * </code>
     *
     * @param     mixed $type The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (is_array($type)) {
            $useMinMax = false;
            if (isset($type['min'])) {
                $this->addUsingAlias(NotificationPeer::TYPE, $type['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($type['max'])) {
                $this->addUsingAlias(NotificationPeer::TYPE, $type['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(NotificationPeer::TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the deliveredOn column
     *
     * Example usage:
     * <code>
     * $query->filterByDeliveredon('2011-03-14'); // WHERE deliveredOn = '2011-03-14'
     * $query->filterByDeliveredon('now'); // WHERE deliveredOn = '2011-03-14'
     * $query->filterByDeliveredon(array('max' => 'yesterday')); // WHERE deliveredOn > '2011-03-13'
     * </code>
     *
     * @param     mixed $deliveredon The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByDeliveredon($deliveredon = null, $comparison = null)
    {
        if (is_array($deliveredon)) {
            $useMinMax = false;
            if (isset($deliveredon['min'])) {
                $this->addUsingAlias(NotificationPeer::DELIVEREDON, $deliveredon['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deliveredon['max'])) {
                $this->addUsingAlias(NotificationPeer::DELIVEREDON, $deliveredon['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(NotificationPeer::DELIVEREDON, $deliveredon, $comparison);
    }

    /**
     * Filter the query on the mailAddress column
     *
     * Example usage:
     * <code>
     * $query->filterByMailaddress('fooValue');   // WHERE mailAddress = 'fooValue'
     * $query->filterByMailaddress('%fooValue%'); // WHERE mailAddress LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mailaddress The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByMailaddress($mailaddress = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mailaddress)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $mailaddress)) {
                $mailaddress = str_replace('*', '%', $mailaddress);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(NotificationPeer::MAILADDRESS, $mailaddress, $comparison);
    }

    /**
     * Filter the query on the mailBody column
     *
     * Example usage:
     * <code>
     * $query->filterByMailbody('fooValue');   // WHERE mailBody = 'fooValue'
     * $query->filterByMailbody('%fooValue%'); // WHERE mailBody LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mailbody The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByMailbody($mailbody = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mailbody)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $mailbody)) {
                $mailbody = str_replace('*', '%', $mailbody);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(NotificationPeer::MAILBODY, $mailbody, $comparison);
    }

    /**
     * Filter the query on the result column
     *
     * Example usage:
     * <code>
     * $query->filterByResult(1234); // WHERE result = 1234
     * $query->filterByResult(array(12, 34)); // WHERE result IN (12, 34)
     * $query->filterByResult(array('min' => 12)); // WHERE result > 12
     * </code>
     *
     * @param     mixed $result The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function filterByResult($result = null, $comparison = null)
    {
        if (is_array($result)) {
            $useMinMax = false;
            if (isset($result['min'])) {
                $this->addUsingAlias(NotificationPeer::RESULT, $result['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($result['max'])) {
                $this->addUsingAlias(NotificationPeer::RESULT, $result['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(NotificationPeer::RESULT, $result, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   Notification $notification Object to remove from the list of results
     *
     * @return NotificationQuery The current query, for fluid interface
     */
    public function prune($notification = null)
    {
        if ($notification) {
            $this->addUsingAlias(NotificationPeer::ID, $notification->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
