<?php



/**
 * Skeleton subclass for representing a row from the 'panel_mission' table.
 *
 * Base de Misiones
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.panel.classes
 */
class Mission extends BaseMission {

	/** the default item name for this class */
	const ITEM_NAME = 'Mission';

	function preSave() {
		if (!parent::preSave()) return false;
		$user = Common::getLoggedUser();
		$this->setUpdaterUserId($user->getId());
		return true;
	}

	function postSave() {
		parent::postSave();
		MissionUpdateQuery::create()
			->filterByMissionId($this->getId())
			->findOneOrCreate()
			->update()
			->save();
	}

	/**
	* Obtiene el nombre traducido del tipo de acto.
	*
	* @return string nombre del tipo
	*/
	function getTypeTranslated() {
		$type = $this->getType();
		$types = MissionPeer::getMissionTypes();
		$typeName = $types[$type];
		$typeNameTranslated = Common::getTranslation($typeName,'panel');
		return $typeNameTranslated;
	}

	function getUpdaterUser() {
		return $this->getUserRelatedByUpdaterUserId();
	}

	function hasParticipantUser($user) {
		return MissionQuery::create()
			->filterById($this->getId())
			->filterByParticipantUser($user)
			->count() > 0;
	}

	function userHasReadAccess($user) {
		return $user->isSupervisor() || $this->hasParticipantUser($user);
	}

	function userHasWriteAccess($user) {
		return $user->isSupervisor() || $this->hasParticipantUser($user);
	}

	function addUser($user) {
		$participant = new MissionParticipant();
		$participant->setMission($this)
			->setObjectType('User')
			->setObjectId($user->getId());
		return $this;
	}

} // Mission
