<?php

require_once 'EmailManagement.php';

class AlertDigestMail {

	private $body;
	private $mailFrom;
	private $mailTo;
	private $subject;

	static function create($alertBodies, $upcomingAlertMinMax = null, $delayedAlertMinMax = null) {

		$digestMail = new self();

		$system = Common::getModuleConfiguration("system");
		$panelConfig = Common::getModuleConfiguration("panel");

		$digestMail->mailFrom = $system["parameters"]["fromEmail"];
		$digestMail->mailTo = explode(",", $panelConfig["alertMailCopies"]);
		$digestMail->subject = "Tablero de Gestión - Alerta General"; //Common::getTranslation('Alert','panel') . " - " . $system['parameters']['siteDescription'];

		$smarty = new SmartyML();
		$smarty->assign('alertBodies', $alertBodies);
		$smarty->assign('upcomingAlertMinMax', $upcomingAlertMinMax);
		$smarty->assign('delayedAlertMinMax', $delayedAlertMinMax);
		$digestMail->body = $smarty->fetch('PanelAlertDigestBody.tpl');

		return $digestMail;
	}

	function getBody() {
		return $this->body;
	}

	function getMailFrom() {
		return $this->mailFrom;
	}

	function getMailTo() {
		return $this->mailTo;
	}

	function getSubject() {
		return $this->subject;
	}

	function setMailTo($mailTo) {
		$this->mailTo = $mailTo;
	}

	function send() {

		$manager = new EmailManagement();

		// Descomentar la siguiente linea si se desea redirigir los mails al debugMail.
		//$manager->setTestMode();

		$message = $manager->createHTMLMessage($this->subject, $this->body);
		$result = $manager->sendMessage($this->mailTo, $this->mailFrom, $message);

		// Se guarda en historico de envios las alertas entregadas
		$notification = new Notification();
		$notificationParams = [
			'mailAddress' => implode(',', $this->mailTo),
			'mailBody' => $this->body,
			'type' => NotificationPeer::DIGEST,
			'result' => $result,
			'deliveredOn' => new DateTime()
		];
		Common::setObjectFromParams($notification, $notificationParams);
		$notification->save();

		return $result;
	}
}
