<?php


/**
 * Base class that represents a row from the 'objectives_strategic' table.
 *
 * Strategic Objective
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BaseStrategicObjective extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'StrategicObjectivePeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        StrategicObjectivePeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the policyguidelineid field.
     * @var        int
     */
    protected $policyguidelineid;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the userid field.
     * @var        int
     */
    protected $userid;

    /**
     * The value for the affiliateid field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $affiliateid;

    /**
     * The value for the userbyaffiliatesid field.
     * @var        int
     */
    protected $userbyaffiliatesid;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the changes field.
     * @var        int
     */
    protected $changes;

    /**
     * The value for the oldid field.
     * @var        int
     */
    protected $oldid;

    /**
     * The value for the startingyear field.
     * @var        int
     */
    protected $startingyear;

    /**
     * The value for the endingyear field.
     * @var        int
     */
    protected $endingyear;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        PolicyGuideline
     */
    protected $aPolicyGuideline;

    /**
     * @var        User
     */
    protected $aUser;

    /**
     * @var        PropelObjectCollection|Objective[] Collection to store aggregation of Objective objects.
     */
    protected $collObjectives;
    protected $collObjectivesPartial;

    /**
     * @var        PropelObjectCollection|StrategicObjectiveLog[] Collection to store aggregation of StrategicObjectiveLog objects.
     */
    protected $collStrategicObjectiveLogs;
    protected $collStrategicObjectiveLogsPartial;

    /**
     * @var        PropelObjectCollection|ObjectiveLog[] Collection to store aggregation of ObjectiveLog objects.
     */
    protected $collObjectiveLogs;
    protected $collObjectiveLogsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectivesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $strategicObjectiveLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectiveLogsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->affiliateid = 0;
    }

    /**
     * Initializes internal state of BaseStrategicObjective object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     * Objective Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [policyguidelineid] column value.
     * Policy Guideline Id
     * @return int
     */
    public function getPolicyguidelineid()
    {
        return $this->policyguidelineid;
    }

    /**
     * Get the [name] column value.
     * Objective Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [description] column value.
     * Objective Description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [userid] column value.
     * User Id
     * @return int
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Get the [affiliateid] column value.
     * Affiliate Id
     * @return int
     */
    public function getAffiliateid()
    {
        return $this->affiliateid;
    }

    /**
     * Get the [userbyaffiliatesid] column value.
     * UserByAffiliates Id
     * @return int
     */
    public function getUserbyaffiliatesid()
    {
        return $this->userbyaffiliatesid;
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Updated
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [changes] column value.
     * Cantidad de modificaciones
     * @return int
     */
    public function getChanges()
    {
        return $this->changes;
    }

    /**
     * Get the [oldid] column value.
     * Old Id
     * @return int
     */
    public function getOldid()
    {
        return $this->oldid;
    }

    /**
     * Get the [startingyear] column value.
     * Starting year
     * @return int
     */
    public function getStartingyear()
    {
        return $this->startingyear;
    }

    /**
     * Get the [endingyear] column value.
     * Ending year
     * @return int
     */
    public function getEndingyear()
    {
        return $this->endingyear;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Objective Id
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [policyguidelineid] column.
     * Policy Guideline Id
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setPolicyguidelineid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->policyguidelineid !== $v) {
            $this->policyguidelineid = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::POLICYGUIDELINEID;
        }

        if ($this->aPolicyGuideline !== null && $this->aPolicyGuideline->getId() !== $v) {
            $this->aPolicyGuideline = null;
        }


        return $this;
    } // setPolicyguidelineid()

    /**
     * Set the value of [name] column.
     * Objective Name
     * @param string $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [description] column.
     * Objective Description
     * @param string $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [userid] column.
     * User Id
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setUserid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userid !== $v) {
            $this->userid = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::USERID;
        }

        if ($this->aUser !== null && $this->aUser->getId() !== $v) {
            $this->aUser = null;
        }


        return $this;
    } // setUserid()

    /**
     * Set the value of [affiliateid] column.
     * Affiliate Id
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setAffiliateid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->affiliateid !== $v) {
            $this->affiliateid = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::AFFILIATEID;
        }


        return $this;
    } // setAffiliateid()

    /**
     * Set the value of [userbyaffiliatesid] column.
     * UserByAffiliates Id
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setUserbyaffiliatesid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userbyaffiliatesid !== $v) {
            $this->userbyaffiliatesid = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::USERBYAFFILIATESID;
        }


        return $this;
    } // setUserbyaffiliatesid()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Updated
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = StrategicObjectivePeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Set the value of [changes] column.
     * Cantidad de modificaciones
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setChanges($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->changes !== $v) {
            $this->changes = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::CHANGES;
        }


        return $this;
    } // setChanges()

    /**
     * Set the value of [oldid] column.
     * Old Id
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setOldid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->oldid !== $v) {
            $this->oldid = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::OLDID;
        }


        return $this;
    } // setOldid()

    /**
     * Set the value of [startingyear] column.
     * Starting year
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setStartingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->startingyear !== $v) {
            $this->startingyear = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::STARTINGYEAR;
        }


        return $this;
    } // setStartingyear()

    /**
     * Set the value of [endingyear] column.
     * Ending year
     * @param int $v new value
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setEndingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->endingyear !== $v) {
            $this->endingyear = $v;
            $this->modifiedColumns[] = StrategicObjectivePeer::ENDINGYEAR;
        }


        return $this;
    } // setEndingyear()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = StrategicObjectivePeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->affiliateid !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->policyguidelineid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->name = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->description = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->userid = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->affiliateid = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
            $this->userbyaffiliatesid = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
            $this->updated = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->changes = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->oldid = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
            $this->startingyear = ($row[$startcol + 10] !== null) ? (int) $row[$startcol + 10] : null;
            $this->endingyear = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->deleted_at = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 13; // 13 = StrategicObjectivePeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating StrategicObjective object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aPolicyGuideline !== null && $this->policyguidelineid !== $this->aPolicyGuideline->getId()) {
            $this->aPolicyGuideline = null;
        }
        if ($this->aUser !== null && $this->userid !== $this->aUser->getId()) {
            $this->aUser = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(StrategicObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = StrategicObjectivePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aPolicyGuideline = null;
            $this->aUser = null;
            $this->collObjectives = null;

            $this->collStrategicObjectiveLogs = null;

            $this->collObjectiveLogs = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(StrategicObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = StrategicObjectiveQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && StrategicObjectiveQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                StrategicObjectivePeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(StrategicObjectivePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                StrategicObjectivePeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aPolicyGuideline !== null) {
                if ($this->aPolicyGuideline->isModified() || $this->aPolicyGuideline->isNew()) {
                    $affectedRows += $this->aPolicyGuideline->save($con);
                }
                $this->setPolicyGuideline($this->aPolicyGuideline);
            }

            if ($this->aUser !== null) {
                if ($this->aUser->isModified() || $this->aUser->isNew()) {
                    $affectedRows += $this->aUser->save($con);
                }
                $this->setUser($this->aUser);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->objectivesScheduledForDeletion !== null) {
                if (!$this->objectivesScheduledForDeletion->isEmpty()) {
                    ObjectiveQuery::create()
                        ->filterByPrimaryKeys($this->objectivesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->objectivesScheduledForDeletion = null;
                }
            }

            if ($this->collObjectives !== null) {
                foreach ($this->collObjectives as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->strategicObjectiveLogsScheduledForDeletion !== null) {
                if (!$this->strategicObjectiveLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->strategicObjectiveLogsScheduledForDeletion as $strategicObjectiveLog) {
                        // need to save related object because we set the relation to null
                        $strategicObjectiveLog->save($con);
                    }
                    $this->strategicObjectiveLogsScheduledForDeletion = null;
                }
            }

            if ($this->collStrategicObjectiveLogs !== null) {
                foreach ($this->collStrategicObjectiveLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectiveLogsScheduledForDeletion !== null) {
                if (!$this->objectiveLogsScheduledForDeletion->isEmpty()) {
                    ObjectiveLogQuery::create()
                        ->filterByPrimaryKeys($this->objectiveLogsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->objectiveLogsScheduledForDeletion = null;
                }
            }

            if ($this->collObjectiveLogs !== null) {
                foreach ($this->collObjectiveLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = StrategicObjectivePeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . StrategicObjectivePeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(StrategicObjectivePeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::POLICYGUIDELINEID)) {
            $modifiedColumns[':p' . $index++]  = '`POLICYGUIDELINEID`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::USERID)) {
            $modifiedColumns[':p' . $index++]  = '`USERID`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::AFFILIATEID)) {
            $modifiedColumns[':p' . $index++]  = '`AFFILIATEID`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::USERBYAFFILIATESID)) {
            $modifiedColumns[':p' . $index++]  = '`USERBYAFFILIATESID`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::CHANGES)) {
            $modifiedColumns[':p' . $index++]  = '`CHANGES`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::OLDID)) {
            $modifiedColumns[':p' . $index++]  = '`OLDID`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::STARTINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`STARTINGYEAR`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::ENDINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`ENDINGYEAR`';
        }
        if ($this->isColumnModified(StrategicObjectivePeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `objectives_strategic` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`POLICYGUIDELINEID`':
                        $stmt->bindValue($identifier, $this->policyguidelineid, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`USERID`':
                        $stmt->bindValue($identifier, $this->userid, PDO::PARAM_INT);
                        break;
                    case '`AFFILIATEID`':
                        $stmt->bindValue($identifier, $this->affiliateid, PDO::PARAM_INT);
                        break;
                    case '`USERBYAFFILIATESID`':
                        $stmt->bindValue($identifier, $this->userbyaffiliatesid, PDO::PARAM_INT);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`CHANGES`':
                        $stmt->bindValue($identifier, $this->changes, PDO::PARAM_INT);
                        break;
                    case '`OLDID`':
                        $stmt->bindValue($identifier, $this->oldid, PDO::PARAM_INT);
                        break;
                    case '`STARTINGYEAR`':
                        $stmt->bindValue($identifier, $this->startingyear, PDO::PARAM_INT);
                        break;
                    case '`ENDINGYEAR`':
                        $stmt->bindValue($identifier, $this->endingyear, PDO::PARAM_INT);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aPolicyGuideline !== null) {
                if (!$this->aPolicyGuideline->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPolicyGuideline->getValidationFailures());
                }
            }

            if ($this->aUser !== null) {
                if (!$this->aUser->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aUser->getValidationFailures());
                }
            }


            if (($retval = StrategicObjectivePeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collObjectives !== null) {
                    foreach ($this->collObjectives as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collStrategicObjectiveLogs !== null) {
                    foreach ($this->collStrategicObjectiveLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectiveLogs !== null) {
                    foreach ($this->collObjectiveLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = StrategicObjectivePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getPolicyguidelineid();
                break;
            case 2:
                return $this->getName();
                break;
            case 3:
                return $this->getDescription();
                break;
            case 4:
                return $this->getUserid();
                break;
            case 5:
                return $this->getAffiliateid();
                break;
            case 6:
                return $this->getUserbyaffiliatesid();
                break;
            case 7:
                return $this->getUpdated();
                break;
            case 8:
                return $this->getChanges();
                break;
            case 9:
                return $this->getOldid();
                break;
            case 10:
                return $this->getStartingyear();
                break;
            case 11:
                return $this->getEndingyear();
                break;
            case 12:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['StrategicObjective'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['StrategicObjective'][$this->getPrimaryKey()] = true;
        $keys = StrategicObjectivePeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getPolicyguidelineid(),
            $keys[2] => $this->getName(),
            $keys[3] => $this->getDescription(),
            $keys[4] => $this->getUserid(),
            $keys[5] => $this->getAffiliateid(),
            $keys[6] => $this->getUserbyaffiliatesid(),
            $keys[7] => $this->getUpdated(),
            $keys[8] => $this->getChanges(),
            $keys[9] => $this->getOldid(),
            $keys[10] => $this->getStartingyear(),
            $keys[11] => $this->getEndingyear(),
            $keys[12] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aPolicyGuideline) {
                $result['PolicyGuideline'] = $this->aPolicyGuideline->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aUser) {
                $result['User'] = $this->aUser->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collObjectives) {
                $result['Objectives'] = $this->collObjectives->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collStrategicObjectiveLogs) {
                $result['StrategicObjectiveLogs'] = $this->collStrategicObjectiveLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectiveLogs) {
                $result['ObjectiveLogs'] = $this->collObjectiveLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = StrategicObjectivePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setPolicyguidelineid($value);
                break;
            case 2:
                $this->setName($value);
                break;
            case 3:
                $this->setDescription($value);
                break;
            case 4:
                $this->setUserid($value);
                break;
            case 5:
                $this->setAffiliateid($value);
                break;
            case 6:
                $this->setUserbyaffiliatesid($value);
                break;
            case 7:
                $this->setUpdated($value);
                break;
            case 8:
                $this->setChanges($value);
                break;
            case 9:
                $this->setOldid($value);
                break;
            case 10:
                $this->setStartingyear($value);
                break;
            case 11:
                $this->setEndingyear($value);
                break;
            case 12:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = StrategicObjectivePeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setPolicyguidelineid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setName($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setDescription($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setUserid($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setAffiliateid($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setUserbyaffiliatesid($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setUpdated($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setChanges($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setOldid($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setStartingyear($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setEndingyear($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setDeletedAt($arr[$keys[12]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(StrategicObjectivePeer::DATABASE_NAME);

        if ($this->isColumnModified(StrategicObjectivePeer::ID)) $criteria->add(StrategicObjectivePeer::ID, $this->id);
        if ($this->isColumnModified(StrategicObjectivePeer::POLICYGUIDELINEID)) $criteria->add(StrategicObjectivePeer::POLICYGUIDELINEID, $this->policyguidelineid);
        if ($this->isColumnModified(StrategicObjectivePeer::NAME)) $criteria->add(StrategicObjectivePeer::NAME, $this->name);
        if ($this->isColumnModified(StrategicObjectivePeer::DESCRIPTION)) $criteria->add(StrategicObjectivePeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(StrategicObjectivePeer::USERID)) $criteria->add(StrategicObjectivePeer::USERID, $this->userid);
        if ($this->isColumnModified(StrategicObjectivePeer::AFFILIATEID)) $criteria->add(StrategicObjectivePeer::AFFILIATEID, $this->affiliateid);
        if ($this->isColumnModified(StrategicObjectivePeer::USERBYAFFILIATESID)) $criteria->add(StrategicObjectivePeer::USERBYAFFILIATESID, $this->userbyaffiliatesid);
        if ($this->isColumnModified(StrategicObjectivePeer::UPDATED)) $criteria->add(StrategicObjectivePeer::UPDATED, $this->updated);
        if ($this->isColumnModified(StrategicObjectivePeer::CHANGES)) $criteria->add(StrategicObjectivePeer::CHANGES, $this->changes);
        if ($this->isColumnModified(StrategicObjectivePeer::OLDID)) $criteria->add(StrategicObjectivePeer::OLDID, $this->oldid);
        if ($this->isColumnModified(StrategicObjectivePeer::STARTINGYEAR)) $criteria->add(StrategicObjectivePeer::STARTINGYEAR, $this->startingyear);
        if ($this->isColumnModified(StrategicObjectivePeer::ENDINGYEAR)) $criteria->add(StrategicObjectivePeer::ENDINGYEAR, $this->endingyear);
        if ($this->isColumnModified(StrategicObjectivePeer::DELETED_AT)) $criteria->add(StrategicObjectivePeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(StrategicObjectivePeer::DATABASE_NAME);
        $criteria->add(StrategicObjectivePeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of StrategicObjective (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setPolicyguidelineid($this->getPolicyguidelineid());
        $copyObj->setName($this->getName());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setUserid($this->getUserid());
        $copyObj->setAffiliateid($this->getAffiliateid());
        $copyObj->setUserbyaffiliatesid($this->getUserbyaffiliatesid());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setChanges($this->getChanges());
        $copyObj->setOldid($this->getOldid());
        $copyObj->setStartingyear($this->getStartingyear());
        $copyObj->setEndingyear($this->getEndingyear());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getObjectives() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjective($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getStrategicObjectiveLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addStrategicObjectiveLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectiveLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjectiveLog($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return StrategicObjective Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return StrategicObjectivePeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new StrategicObjectivePeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a PolicyGuideline object.
     *
     * @param             PolicyGuideline $v
     * @return StrategicObjective The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPolicyGuideline(PolicyGuideline $v = null)
    {
        if ($v === null) {
            $this->setPolicyguidelineid(NULL);
        } else {
            $this->setPolicyguidelineid($v->getId());
        }

        $this->aPolicyGuideline = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the PolicyGuideline object, it will not be re-added.
        if ($v !== null) {
            $v->addStrategicObjective($this);
        }


        return $this;
    }


    /**
     * Get the associated PolicyGuideline object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return PolicyGuideline The associated PolicyGuideline object.
     * @throws PropelException
     */
    public function getPolicyGuideline(PropelPDO $con = null)
    {
        if ($this->aPolicyGuideline === null && ($this->policyguidelineid !== null)) {
            $this->aPolicyGuideline = PolicyGuidelineQuery::create()->findPk($this->policyguidelineid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPolicyGuideline->addStrategicObjectives($this);
             */
        }

        return $this->aPolicyGuideline;
    }

    /**
     * Declares an association between this object and a User object.
     *
     * @param             User $v
     * @return StrategicObjective The current object (for fluent API support)
     * @throws PropelException
     */
    public function setUser(User $v = null)
    {
        if ($v === null) {
            $this->setUserid(NULL);
        } else {
            $this->setUserid($v->getId());
        }

        $this->aUser = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the User object, it will not be re-added.
        if ($v !== null) {
            $v->addStrategicObjective($this);
        }


        return $this;
    }


    /**
     * Get the associated User object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return User The associated User object.
     * @throws PropelException
     */
    public function getUser(PropelPDO $con = null)
    {
        if ($this->aUser === null && ($this->userid !== null)) {
            $this->aUser = UserQuery::create()->findPk($this->userid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aUser->addStrategicObjectives($this);
             */
        }

        return $this->aUser;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Objective' == $relationName) {
            $this->initObjectives();
        }
        if ('StrategicObjectiveLog' == $relationName) {
            $this->initStrategicObjectiveLogs();
        }
        if ('ObjectiveLog' == $relationName) {
            $this->initObjectiveLogs();
        }
    }

    /**
     * Clears out the collObjectives collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectives()
     */
    public function clearObjectives()
    {
        $this->collObjectives = null; // important to set this to null since that means it is uninitialized
        $this->collObjectivesPartial = null;
    }

    /**
     * reset is the collObjectives collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectives($v = true)
    {
        $this->collObjectivesPartial = $v;
    }

    /**
     * Initializes the collObjectives collection.
     *
     * By default this just sets the collObjectives collection to an empty array (like clearcollObjectives());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectives($overrideExisting = true)
    {
        if (null !== $this->collObjectives && !$overrideExisting) {
            return;
        }
        $this->collObjectives = new PropelObjectCollection();
        $this->collObjectives->setModel('Objective');
    }

    /**
     * Gets an array of Objective objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this StrategicObjective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Objective[] List of Objective objects
     * @throws PropelException
     */
    public function getObjectives($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectivesPartial && !$this->isNew();
        if (null === $this->collObjectives || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectives) {
                // return empty collection
                $this->initObjectives();
            } else {
                $collObjectives = ObjectiveQuery::create(null, $criteria)
                    ->filterByStrategicObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectivesPartial && count($collObjectives)) {
                      $this->initObjectives(false);

                      foreach($collObjectives as $obj) {
                        if (false == $this->collObjectives->contains($obj)) {
                          $this->collObjectives->append($obj);
                        }
                      }

                      $this->collObjectivesPartial = true;
                    }

                    return $collObjectives;
                }

                if($partial && $this->collObjectives) {
                    foreach($this->collObjectives as $obj) {
                        if($obj->isNew()) {
                            $collObjectives[] = $obj;
                        }
                    }
                }

                $this->collObjectives = $collObjectives;
                $this->collObjectivesPartial = false;
            }
        }

        return $this->collObjectives;
    }

    /**
     * Sets a collection of Objective objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectives A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectives(PropelCollection $objectives, PropelPDO $con = null)
    {
        $this->objectivesScheduledForDeletion = $this->getObjectives(new Criteria(), $con)->diff($objectives);

        foreach ($this->objectivesScheduledForDeletion as $objectiveRemoved) {
            $objectiveRemoved->setStrategicObjective(null);
        }

        $this->collObjectives = null;
        foreach ($objectives as $objective) {
            $this->addObjective($objective);
        }

        $this->collObjectives = $objectives;
        $this->collObjectivesPartial = false;
    }

    /**
     * Returns the number of related Objective objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Objective objects.
     * @throws PropelException
     */
    public function countObjectives(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectivesPartial && !$this->isNew();
        if (null === $this->collObjectives || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectives) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectives());
                }
                $query = ObjectiveQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByStrategicObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectives);
        }
    }

    /**
     * Method called to associate a Objective object to this object
     * through the Objective foreign key attribute.
     *
     * @param    Objective $l Objective
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function addObjective(Objective $l)
    {
        if ($this->collObjectives === null) {
            $this->initObjectives();
            $this->collObjectivesPartial = true;
        }
        if (!$this->collObjectives->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjective($l);
        }

        return $this;
    }

    /**
     * @param	Objective $objective The objective object to add.
     */
    protected function doAddObjective($objective)
    {
        $this->collObjectives[]= $objective;
        $objective->setStrategicObjective($this);
    }

    /**
     * @param	Objective $objective The objective object to remove.
     */
    public function removeObjective($objective)
    {
        if ($this->getObjectives()->contains($objective)) {
            $this->collObjectives->remove($this->collObjectives->search($objective));
            if (null === $this->objectivesScheduledForDeletion) {
                $this->objectivesScheduledForDeletion = clone $this->collObjectives;
                $this->objectivesScheduledForDeletion->clear();
            }
            $this->objectivesScheduledForDeletion[]= $objective;
            $objective->setStrategicObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getObjectives($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getObjectives($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getObjectives($query, $con);
    }

    /**
     * Clears out the collStrategicObjectiveLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addStrategicObjectiveLogs()
     */
    public function clearStrategicObjectiveLogs()
    {
        $this->collStrategicObjectiveLogs = null; // important to set this to null since that means it is uninitialized
        $this->collStrategicObjectiveLogsPartial = null;
    }

    /**
     * reset is the collStrategicObjectiveLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialStrategicObjectiveLogs($v = true)
    {
        $this->collStrategicObjectiveLogsPartial = $v;
    }

    /**
     * Initializes the collStrategicObjectiveLogs collection.
     *
     * By default this just sets the collStrategicObjectiveLogs collection to an empty array (like clearcollStrategicObjectiveLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initStrategicObjectiveLogs($overrideExisting = true)
    {
        if (null !== $this->collStrategicObjectiveLogs && !$overrideExisting) {
            return;
        }
        $this->collStrategicObjectiveLogs = new PropelObjectCollection();
        $this->collStrategicObjectiveLogs->setModel('StrategicObjectiveLog');
    }

    /**
     * Gets an array of StrategicObjectiveLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this StrategicObjective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     * @throws PropelException
     */
    public function getStrategicObjectiveLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collStrategicObjectiveLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectiveLogs) {
                // return empty collection
                $this->initStrategicObjectiveLogs();
            } else {
                $collStrategicObjectiveLogs = StrategicObjectiveLogQuery::create(null, $criteria)
                    ->filterByStrategicObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collStrategicObjectiveLogsPartial && count($collStrategicObjectiveLogs)) {
                      $this->initStrategicObjectiveLogs(false);

                      foreach($collStrategicObjectiveLogs as $obj) {
                        if (false == $this->collStrategicObjectiveLogs->contains($obj)) {
                          $this->collStrategicObjectiveLogs->append($obj);
                        }
                      }

                      $this->collStrategicObjectiveLogsPartial = true;
                    }

                    return $collStrategicObjectiveLogs;
                }

                if($partial && $this->collStrategicObjectiveLogs) {
                    foreach($this->collStrategicObjectiveLogs as $obj) {
                        if($obj->isNew()) {
                            $collStrategicObjectiveLogs[] = $obj;
                        }
                    }
                }

                $this->collStrategicObjectiveLogs = $collStrategicObjectiveLogs;
                $this->collStrategicObjectiveLogsPartial = false;
            }
        }

        return $this->collStrategicObjectiveLogs;
    }

    /**
     * Sets a collection of StrategicObjectiveLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $strategicObjectiveLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setStrategicObjectiveLogs(PropelCollection $strategicObjectiveLogs, PropelPDO $con = null)
    {
        $this->strategicObjectiveLogsScheduledForDeletion = $this->getStrategicObjectiveLogs(new Criteria(), $con)->diff($strategicObjectiveLogs);

        foreach ($this->strategicObjectiveLogsScheduledForDeletion as $strategicObjectiveLogRemoved) {
            $strategicObjectiveLogRemoved->setStrategicObjective(null);
        }

        $this->collStrategicObjectiveLogs = null;
        foreach ($strategicObjectiveLogs as $strategicObjectiveLog) {
            $this->addStrategicObjectiveLog($strategicObjectiveLog);
        }

        $this->collStrategicObjectiveLogs = $strategicObjectiveLogs;
        $this->collStrategicObjectiveLogsPartial = false;
    }

    /**
     * Returns the number of related StrategicObjectiveLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related StrategicObjectiveLog objects.
     * @throws PropelException
     */
    public function countStrategicObjectiveLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collStrategicObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collStrategicObjectiveLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collStrategicObjectiveLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getStrategicObjectiveLogs());
                }
                $query = StrategicObjectiveLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByStrategicObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collStrategicObjectiveLogs);
        }
    }

    /**
     * Method called to associate a StrategicObjectiveLog object to this object
     * through the StrategicObjectiveLog foreign key attribute.
     *
     * @param    StrategicObjectiveLog $l StrategicObjectiveLog
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function addStrategicObjectiveLog(StrategicObjectiveLog $l)
    {
        if ($this->collStrategicObjectiveLogs === null) {
            $this->initStrategicObjectiveLogs();
            $this->collStrategicObjectiveLogsPartial = true;
        }
        if (!$this->collStrategicObjectiveLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddStrategicObjectiveLog($l);
        }

        return $this;
    }

    /**
     * @param	StrategicObjectiveLog $strategicObjectiveLog The strategicObjectiveLog object to add.
     */
    protected function doAddStrategicObjectiveLog($strategicObjectiveLog)
    {
        $this->collStrategicObjectiveLogs[]= $strategicObjectiveLog;
        $strategicObjectiveLog->setStrategicObjective($this);
    }

    /**
     * @param	StrategicObjectiveLog $strategicObjectiveLog The strategicObjectiveLog object to remove.
     */
    public function removeStrategicObjectiveLog($strategicObjectiveLog)
    {
        if ($this->getStrategicObjectiveLogs()->contains($strategicObjectiveLog)) {
            $this->collStrategicObjectiveLogs->remove($this->collStrategicObjectiveLogs->search($strategicObjectiveLog));
            if (null === $this->strategicObjectiveLogsScheduledForDeletion) {
                $this->strategicObjectiveLogsScheduledForDeletion = clone $this->collStrategicObjectiveLogs;
                $this->strategicObjectiveLogsScheduledForDeletion->clear();
            }
            $this->strategicObjectiveLogsScheduledForDeletion[]= $strategicObjectiveLog;
            $strategicObjectiveLog->setStrategicObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related StrategicObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     */
    public function getStrategicObjectiveLogsJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = StrategicObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getStrategicObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related StrategicObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|StrategicObjectiveLog[] List of StrategicObjectiveLog objects
     */
    public function getStrategicObjectiveLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = StrategicObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getStrategicObjectiveLogs($query, $con);
    }

    /**
     * Clears out the collObjectiveLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectiveLogs()
     */
    public function clearObjectiveLogs()
    {
        $this->collObjectiveLogs = null; // important to set this to null since that means it is uninitialized
        $this->collObjectiveLogsPartial = null;
    }

    /**
     * reset is the collObjectiveLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectiveLogs($v = true)
    {
        $this->collObjectiveLogsPartial = $v;
    }

    /**
     * Initializes the collObjectiveLogs collection.
     *
     * By default this just sets the collObjectiveLogs collection to an empty array (like clearcollObjectiveLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectiveLogs($overrideExisting = true)
    {
        if (null !== $this->collObjectiveLogs && !$overrideExisting) {
            return;
        }
        $this->collObjectiveLogs = new PropelObjectCollection();
        $this->collObjectiveLogs->setModel('ObjectiveLog');
    }

    /**
     * Gets an array of ObjectiveLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this StrategicObjective is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     * @throws PropelException
     */
    public function getObjectiveLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                // return empty collection
                $this->initObjectiveLogs();
            } else {
                $collObjectiveLogs = ObjectiveLogQuery::create(null, $criteria)
                    ->filterByStrategicObjective($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectiveLogsPartial && count($collObjectiveLogs)) {
                      $this->initObjectiveLogs(false);

                      foreach($collObjectiveLogs as $obj) {
                        if (false == $this->collObjectiveLogs->contains($obj)) {
                          $this->collObjectiveLogs->append($obj);
                        }
                      }

                      $this->collObjectiveLogsPartial = true;
                    }

                    return $collObjectiveLogs;
                }

                if($partial && $this->collObjectiveLogs) {
                    foreach($this->collObjectiveLogs as $obj) {
                        if($obj->isNew()) {
                            $collObjectiveLogs[] = $obj;
                        }
                    }
                }

                $this->collObjectiveLogs = $collObjectiveLogs;
                $this->collObjectiveLogsPartial = false;
            }
        }

        return $this->collObjectiveLogs;
    }

    /**
     * Sets a collection of ObjectiveLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectiveLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectiveLogs(PropelCollection $objectiveLogs, PropelPDO $con = null)
    {
        $this->objectiveLogsScheduledForDeletion = $this->getObjectiveLogs(new Criteria(), $con)->diff($objectiveLogs);

        foreach ($this->objectiveLogsScheduledForDeletion as $objectiveLogRemoved) {
            $objectiveLogRemoved->setStrategicObjective(null);
        }

        $this->collObjectiveLogs = null;
        foreach ($objectiveLogs as $objectiveLog) {
            $this->addObjectiveLog($objectiveLog);
        }

        $this->collObjectiveLogs = $objectiveLogs;
        $this->collObjectiveLogsPartial = false;
    }

    /**
     * Returns the number of related ObjectiveLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ObjectiveLog objects.
     * @throws PropelException
     */
    public function countObjectiveLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectiveLogs());
                }
                $query = ObjectiveLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByStrategicObjective($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectiveLogs);
        }
    }

    /**
     * Method called to associate a ObjectiveLog object to this object
     * through the ObjectiveLog foreign key attribute.
     *
     * @param    ObjectiveLog $l ObjectiveLog
     * @return StrategicObjective The current object (for fluent API support)
     */
    public function addObjectiveLog(ObjectiveLog $l)
    {
        if ($this->collObjectiveLogs === null) {
            $this->initObjectiveLogs();
            $this->collObjectiveLogsPartial = true;
        }
        if (!$this->collObjectiveLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjectiveLog($l);
        }

        return $this;
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to add.
     */
    protected function doAddObjectiveLog($objectiveLog)
    {
        $this->collObjectiveLogs[]= $objectiveLog;
        $objectiveLog->setStrategicObjective($this);
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to remove.
     */
    public function removeObjectiveLog($objectiveLog)
    {
        if ($this->getObjectiveLogs()->contains($objectiveLog)) {
            $this->collObjectiveLogs->remove($this->collObjectiveLogs->search($objectiveLog));
            if (null === $this->objectiveLogsScheduledForDeletion) {
                $this->objectiveLogsScheduledForDeletion = clone $this->collObjectiveLogs;
                $this->objectiveLogsScheduledForDeletion->clear();
            }
            $this->objectiveLogsScheduledForDeletion[]= $objectiveLog;
            $objectiveLog->setStrategicObjective(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this StrategicObjective is new, it will return
     * an empty collection; or if this StrategicObjective has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in StrategicObjective.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->policyguidelineid = null;
        $this->name = null;
        $this->description = null;
        $this->userid = null;
        $this->affiliateid = null;
        $this->userbyaffiliatesid = null;
        $this->updated = null;
        $this->changes = null;
        $this->oldid = null;
        $this->startingyear = null;
        $this->endingyear = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collObjectives) {
                foreach ($this->collObjectives as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collStrategicObjectiveLogs) {
                foreach ($this->collStrategicObjectiveLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectiveLogs) {
                foreach ($this->collObjectiveLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collObjectives instanceof PropelCollection) {
            $this->collObjectives->clearIterator();
        }
        $this->collObjectives = null;
        if ($this->collStrategicObjectiveLogs instanceof PropelCollection) {
            $this->collStrategicObjectiveLogs->clearIterator();
        }
        $this->collStrategicObjectiveLogs = null;
        if ($this->collObjectiveLogs instanceof PropelCollection) {
            $this->collObjectiveLogs->clearIterator();
        }
        $this->collObjectiveLogs = null;
        $this->aPolicyGuideline = null;
        $this->aUser = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = StrategicObjectivePeer::isSoftDeleteEnabled()) {
            StrategicObjectivePeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            StrategicObjectivePeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
