<?php


/**
 * Base class that represents a query for the 'indicators_graph' table.
 *
 * Indicators graph
 *
 * @method IndicatorGraphQuery orderById($order = Criteria::ASC) Order by the id column
 * @method IndicatorGraphQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method IndicatorGraphQuery orderByGraphtype($order = Criteria::ASC) Order by the graphType column
 * @method IndicatorGraphQuery orderByDecimals($order = Criteria::ASC) Order by the decimals column
 * @method IndicatorGraphQuery orderByValuetype($order = Criteria::ASC) Order by the valueType column
 * @method IndicatorGraphQuery orderByShowvalue($order = Criteria::ASC) Order by the showValue column
 * @method IndicatorGraphQuery orderByMinx($order = Criteria::ASC) Order by the minX column
 * @method IndicatorGraphQuery orderByMaxx($order = Criteria::ASC) Order by the maxX column
 * @method IndicatorGraphQuery orderByMiny($order = Criteria::ASC) Order by the minY column
 * @method IndicatorGraphQuery orderByMaxy($order = Criteria::ASC) Order by the maxY column
 * @method IndicatorGraphQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method IndicatorGraphQuery orderByMindate($order = Criteria::ASC) Order by the minDate column
 * @method IndicatorGraphQuery orderByMaxdate($order = Criteria::ASC) Order by the maxDate column
 *
 * @method IndicatorGraphQuery groupById() Group by the id column
 * @method IndicatorGraphQuery groupByName() Group by the name column
 * @method IndicatorGraphQuery groupByGraphtype() Group by the graphType column
 * @method IndicatorGraphQuery groupByDecimals() Group by the decimals column
 * @method IndicatorGraphQuery groupByValuetype() Group by the valueType column
 * @method IndicatorGraphQuery groupByShowvalue() Group by the showValue column
 * @method IndicatorGraphQuery groupByMinx() Group by the minX column
 * @method IndicatorGraphQuery groupByMaxx() Group by the maxX column
 * @method IndicatorGraphQuery groupByMiny() Group by the minY column
 * @method IndicatorGraphQuery groupByMaxy() Group by the maxY column
 * @method IndicatorGraphQuery groupByDescription() Group by the description column
 * @method IndicatorGraphQuery groupByMindate() Group by the minDate column
 * @method IndicatorGraphQuery groupByMaxdate() Group by the maxDate column
 *
 * @method IndicatorGraphQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IndicatorGraphQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IndicatorGraphQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IndicatorGraphQuery leftJoinIndicatorGraphSerie($relationAlias = null) Adds a LEFT JOIN clause to the query using the IndicatorGraphSerie relation
 * @method IndicatorGraphQuery rightJoinIndicatorGraphSerie($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IndicatorGraphSerie relation
 * @method IndicatorGraphQuery innerJoinIndicatorGraphSerie($relationAlias = null) Adds a INNER JOIN clause to the query using the IndicatorGraphSerie relation
 *
 * @method IndicatorGraphQuery leftJoinIndicatorGraphComment($relationAlias = null) Adds a LEFT JOIN clause to the query using the IndicatorGraphComment relation
 * @method IndicatorGraphQuery rightJoinIndicatorGraphComment($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IndicatorGraphComment relation
 * @method IndicatorGraphQuery innerJoinIndicatorGraphComment($relationAlias = null) Adds a INNER JOIN clause to the query using the IndicatorGraphComment relation
 *
 * @method IndicatorGraph findOne(PropelPDO $con = null) Return the first IndicatorGraph matching the query
 * @method IndicatorGraph findOneOrCreate(PropelPDO $con = null) Return the first IndicatorGraph matching the query, or a new IndicatorGraph object populated from the query conditions when no match is found
 *
 * @method IndicatorGraph findOneById(int $id) Return the first IndicatorGraph filtered by the id column
 * @method IndicatorGraph findOneByName(string $name) Return the first IndicatorGraph filtered by the name column
 * @method IndicatorGraph findOneByGraphtype(int $graphType) Return the first IndicatorGraph filtered by the graphType column
 * @method IndicatorGraph findOneByDecimals(int $decimals) Return the first IndicatorGraph filtered by the decimals column
 * @method IndicatorGraph findOneByValuetype(int $valueType) Return the first IndicatorGraph filtered by the valueType column
 * @method IndicatorGraph findOneByShowvalue(int $showValue) Return the first IndicatorGraph filtered by the showValue column
 * @method IndicatorGraph findOneByMinx(int $minX) Return the first IndicatorGraph filtered by the minX column
 * @method IndicatorGraph findOneByMaxx(int $maxX) Return the first IndicatorGraph filtered by the maxX column
 * @method IndicatorGraph findOneByMiny(int $minY) Return the first IndicatorGraph filtered by the minY column
 * @method IndicatorGraph findOneByMaxy(int $maxY) Return the first IndicatorGraph filtered by the maxY column
 * @method IndicatorGraph findOneByDescription(string $description) Return the first IndicatorGraph filtered by the description column
 * @method IndicatorGraph findOneByMindate(string $minDate) Return the first IndicatorGraph filtered by the minDate column
 * @method IndicatorGraph findOneByMaxdate(string $maxDate) Return the first IndicatorGraph filtered by the maxDate column
 *
 * @method array findById(int $id) Return IndicatorGraph objects filtered by the id column
 * @method array findByName(string $name) Return IndicatorGraph objects filtered by the name column
 * @method array findByGraphtype(int $graphType) Return IndicatorGraph objects filtered by the graphType column
 * @method array findByDecimals(int $decimals) Return IndicatorGraph objects filtered by the decimals column
 * @method array findByValuetype(int $valueType) Return IndicatorGraph objects filtered by the valueType column
 * @method array findByShowvalue(int $showValue) Return IndicatorGraph objects filtered by the showValue column
 * @method array findByMinx(int $minX) Return IndicatorGraph objects filtered by the minX column
 * @method array findByMaxx(int $maxX) Return IndicatorGraph objects filtered by the maxX column
 * @method array findByMiny(int $minY) Return IndicatorGraph objects filtered by the minY column
 * @method array findByMaxy(int $maxY) Return IndicatorGraph objects filtered by the maxY column
 * @method array findByDescription(string $description) Return IndicatorGraph objects filtered by the description column
 * @method array findByMindate(string $minDate) Return IndicatorGraph objects filtered by the minDate column
 * @method array findByMaxdate(string $maxDate) Return IndicatorGraph objects filtered by the maxDate column
 *
 * @package    propel.generator.indicators.classes.om
 */
abstract class BaseIndicatorGraphQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseIndicatorGraphQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'IndicatorGraph', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IndicatorGraphQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IndicatorGraphQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IndicatorGraphQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IndicatorGraphQuery) {
            return $criteria;
        }
        $query = new IndicatorGraphQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   IndicatorGraph|IndicatorGraph[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IndicatorGraphPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IndicatorGraphPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   IndicatorGraph A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `GRAPHTYPE`, `DECIMALS`, `VALUETYPE`, `SHOWVALUE`, `MINX`, `MAXX`, `MINY`, `MAXY`, `DESCRIPTION`, `MINDATE`, `MAXDATE` FROM `indicators_graph` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new IndicatorGraph();
            $obj->hydrate($row);
            IndicatorGraphPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return IndicatorGraph|IndicatorGraph[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|IndicatorGraph[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(IndicatorGraphPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(IndicatorGraphPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IndicatorGraphPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the graphType column
     *
     * Example usage:
     * <code>
     * $query->filterByGraphtype(1234); // WHERE graphType = 1234
     * $query->filterByGraphtype(array(12, 34)); // WHERE graphType IN (12, 34)
     * $query->filterByGraphtype(array('min' => 12)); // WHERE graphType > 12
     * </code>
     *
     * @param     mixed $graphtype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByGraphtype($graphtype = null, $comparison = null)
    {
        if (is_array($graphtype)) {
            $useMinMax = false;
            if (isset($graphtype['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::GRAPHTYPE, $graphtype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($graphtype['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::GRAPHTYPE, $graphtype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::GRAPHTYPE, $graphtype, $comparison);
    }

    /**
     * Filter the query on the decimals column
     *
     * Example usage:
     * <code>
     * $query->filterByDecimals(1234); // WHERE decimals = 1234
     * $query->filterByDecimals(array(12, 34)); // WHERE decimals IN (12, 34)
     * $query->filterByDecimals(array('min' => 12)); // WHERE decimals > 12
     * </code>
     *
     * @param     mixed $decimals The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByDecimals($decimals = null, $comparison = null)
    {
        if (is_array($decimals)) {
            $useMinMax = false;
            if (isset($decimals['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::DECIMALS, $decimals['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($decimals['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::DECIMALS, $decimals['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::DECIMALS, $decimals, $comparison);
    }

    /**
     * Filter the query on the valueType column
     *
     * Example usage:
     * <code>
     * $query->filterByValuetype(1234); // WHERE valueType = 1234
     * $query->filterByValuetype(array(12, 34)); // WHERE valueType IN (12, 34)
     * $query->filterByValuetype(array('min' => 12)); // WHERE valueType > 12
     * </code>
     *
     * @param     mixed $valuetype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByValuetype($valuetype = null, $comparison = null)
    {
        if (is_array($valuetype)) {
            $useMinMax = false;
            if (isset($valuetype['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::VALUETYPE, $valuetype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($valuetype['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::VALUETYPE, $valuetype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::VALUETYPE, $valuetype, $comparison);
    }

    /**
     * Filter the query on the showValue column
     *
     * Example usage:
     * <code>
     * $query->filterByShowvalue(1234); // WHERE showValue = 1234
     * $query->filterByShowvalue(array(12, 34)); // WHERE showValue IN (12, 34)
     * $query->filterByShowvalue(array('min' => 12)); // WHERE showValue > 12
     * </code>
     *
     * @param     mixed $showvalue The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByShowvalue($showvalue = null, $comparison = null)
    {
        if (is_array($showvalue)) {
            $useMinMax = false;
            if (isset($showvalue['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::SHOWVALUE, $showvalue['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($showvalue['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::SHOWVALUE, $showvalue['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::SHOWVALUE, $showvalue, $comparison);
    }

    /**
     * Filter the query on the minX column
     *
     * Example usage:
     * <code>
     * $query->filterByMinx(1234); // WHERE minX = 1234
     * $query->filterByMinx(array(12, 34)); // WHERE minX IN (12, 34)
     * $query->filterByMinx(array('min' => 12)); // WHERE minX > 12
     * </code>
     *
     * @param     mixed $minx The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByMinx($minx = null, $comparison = null)
    {
        if (is_array($minx)) {
            $useMinMax = false;
            if (isset($minx['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MINX, $minx['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($minx['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MINX, $minx['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::MINX, $minx, $comparison);
    }

    /**
     * Filter the query on the maxX column
     *
     * Example usage:
     * <code>
     * $query->filterByMaxx(1234); // WHERE maxX = 1234
     * $query->filterByMaxx(array(12, 34)); // WHERE maxX IN (12, 34)
     * $query->filterByMaxx(array('min' => 12)); // WHERE maxX > 12
     * </code>
     *
     * @param     mixed $maxx The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByMaxx($maxx = null, $comparison = null)
    {
        if (is_array($maxx)) {
            $useMinMax = false;
            if (isset($maxx['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MAXX, $maxx['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($maxx['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MAXX, $maxx['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::MAXX, $maxx, $comparison);
    }

    /**
     * Filter the query on the minY column
     *
     * Example usage:
     * <code>
     * $query->filterByMiny(1234); // WHERE minY = 1234
     * $query->filterByMiny(array(12, 34)); // WHERE minY IN (12, 34)
     * $query->filterByMiny(array('min' => 12)); // WHERE minY > 12
     * </code>
     *
     * @param     mixed $miny The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByMiny($miny = null, $comparison = null)
    {
        if (is_array($miny)) {
            $useMinMax = false;
            if (isset($miny['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MINY, $miny['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($miny['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MINY, $miny['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::MINY, $miny, $comparison);
    }

    /**
     * Filter the query on the maxY column
     *
     * Example usage:
     * <code>
     * $query->filterByMaxy(1234); // WHERE maxY = 1234
     * $query->filterByMaxy(array(12, 34)); // WHERE maxY IN (12, 34)
     * $query->filterByMaxy(array('min' => 12)); // WHERE maxY > 12
     * </code>
     *
     * @param     mixed $maxy The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByMaxy($maxy = null, $comparison = null)
    {
        if (is_array($maxy)) {
            $useMinMax = false;
            if (isset($maxy['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MAXY, $maxy['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($maxy['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MAXY, $maxy['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::MAXY, $maxy, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the minDate column
     *
     * Example usage:
     * <code>
     * $query->filterByMindate('2011-03-14'); // WHERE minDate = '2011-03-14'
     * $query->filterByMindate('now'); // WHERE minDate = '2011-03-14'
     * $query->filterByMindate(array('max' => 'yesterday')); // WHERE minDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $mindate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByMindate($mindate = null, $comparison = null)
    {
        if (is_array($mindate)) {
            $useMinMax = false;
            if (isset($mindate['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MINDATE, $mindate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($mindate['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MINDATE, $mindate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::MINDATE, $mindate, $comparison);
    }

    /**
     * Filter the query on the maxDate column
     *
     * Example usage:
     * <code>
     * $query->filterByMaxdate('2011-03-14'); // WHERE maxDate = '2011-03-14'
     * $query->filterByMaxdate('now'); // WHERE maxDate = '2011-03-14'
     * $query->filterByMaxdate(array('max' => 'yesterday')); // WHERE maxDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $maxdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByMaxdate($maxdate = null, $comparison = null)
    {
        if (is_array($maxdate)) {
            $useMinMax = false;
            if (isset($maxdate['min'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MAXDATE, $maxdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($maxdate['max'])) {
                $this->addUsingAlias(IndicatorGraphPeer::MAXDATE, $maxdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorGraphPeer::MAXDATE, $maxdate, $comparison);
    }

    /**
     * Filter the query by a related IndicatorGraphSerie object
     *
     * @param   IndicatorGraphSerie|PropelObjectCollection $indicatorGraphSerie  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorGraphQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicatorGraphSerie($indicatorGraphSerie, $comparison = null)
    {
        if ($indicatorGraphSerie instanceof IndicatorGraphSerie) {
            return $this
                ->addUsingAlias(IndicatorGraphPeer::ID, $indicatorGraphSerie->getGraphid(), $comparison);
        } elseif ($indicatorGraphSerie instanceof PropelObjectCollection) {
            return $this
                ->useIndicatorGraphSerieQuery()
                ->filterByPrimaryKeys($indicatorGraphSerie->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIndicatorGraphSerie() only accepts arguments of type IndicatorGraphSerie or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IndicatorGraphSerie relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function joinIndicatorGraphSerie($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IndicatorGraphSerie');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IndicatorGraphSerie');
        }

        return $this;
    }

    /**
     * Use the IndicatorGraphSerie relation IndicatorGraphSerie object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorGraphSerieQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorGraphSerieQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIndicatorGraphSerie($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IndicatorGraphSerie', 'IndicatorGraphSerieQuery');
    }

    /**
     * Filter the query by a related IndicatorGraphComment object
     *
     * @param   IndicatorGraphComment|PropelObjectCollection $indicatorGraphComment  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorGraphQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicatorGraphComment($indicatorGraphComment, $comparison = null)
    {
        if ($indicatorGraphComment instanceof IndicatorGraphComment) {
            return $this
                ->addUsingAlias(IndicatorGraphPeer::ID, $indicatorGraphComment->getGraphid(), $comparison);
        } elseif ($indicatorGraphComment instanceof PropelObjectCollection) {
            return $this
                ->useIndicatorGraphCommentQuery()
                ->filterByPrimaryKeys($indicatorGraphComment->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIndicatorGraphComment() only accepts arguments of type IndicatorGraphComment or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IndicatorGraphComment relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function joinIndicatorGraphComment($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IndicatorGraphComment');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IndicatorGraphComment');
        }

        return $this;
    }

    /**
     * Use the IndicatorGraphComment relation IndicatorGraphComment object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorGraphCommentQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorGraphCommentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIndicatorGraphComment($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IndicatorGraphComment', 'IndicatorGraphCommentQuery');
    }

    /**
     * Filter the query by a related Indicator object
     * using the indicators_graphSerie table as cross reference
     *
     * @param   Indicator $indicator the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorGraphQuery The current query, for fluid interface
     */
    public function filterByIndicator($indicator, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useIndicatorGraphSerieQuery()
            ->filterByIndicator($indicator, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   IndicatorGraph $indicatorGraph Object to remove from the list of results
     *
     * @return IndicatorGraphQuery The current query, for fluid interface
     */
    public function prune($indicatorGraph = null)
    {
        if ($indicatorGraph) {
            $this->addUsingAlias(IndicatorGraphPeer::ID, $indicatorGraph->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
