<?php



/**
 * Skeleton subclass for performing query and update operations on the 'headlines_headline' table.
 *
 * Headline
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.headlines.classes
 */
class HeadlineQuery extends BaseHeadlineQuery {

 /**
	* Agrega filtros por nombre o contenido del Headline
	*
	* @param   type string $searchString texto a buscar
	* @return condicion de filtrado por texto a buscar
	*/
	public function searchString($searchString) {
		return $this->where("Headline.Name LIKE ?", "%$searchString%")
							->_or()
								->where("Headline.Content LIKE ?", "%$searchString%")
							->_or()
								->where("Headline.Author LIKE ?", "%$searchString%");
	}

 /**
	* Agrega filtros por ocndicion de procesado Headline
	*
	* @param   type string $value condicion de procesado
	* @return condicion de filtrado por condicion de procesado
	*/
	public function processed($value = true) {
		
		if ($value) {
			$this->filterByHeadlinescope(0, Criteria::NOT_EQUAL) // se inicializa en 0. sino: filterByXxx(null, Criteria::ISNOTNULL)
				->filterByRelevance(0, Criteria::NOT_EQUAL)
				->filterByAgenda(0, Criteria::NOT_EQUAL)
				->filterByValue(0, Criteria::NOT_EQUAL)
				->groupBy('Headline.Id')
			;
		} else {
			$this
				->filterByHeadlinescope(0) // se inicializa en 0. sino: filterByXxx(null, Criteria::ISNULL)
			->_or()
				->filterByValue(0)
			->_or()
				->filterByRelevance(0)
			->_or()
				->filterByAgenda(0)
			->_or()
				->where("Headline.Id NOT IN (SELECT `Headlineid` FROM `headlines_issue`)")
			->groupBy('Headline.Id')
			;
	    }
	    return $this;
    }

 /**
	* Agrega filtros por fecha de publicacion del  Headline
	*
	* @param   type array $range array con rango de fechas
	* @return condicion de filtrado por rango de fecha de publicacion
	*/
	public function rangePublished($range) {
			return $this->filterByDatepublished($range);
	}

 /**
	* Agrega filtros por tipo de medio
	*
	* @param   type integer $mediaTypeId id del tipo de medio
	* @return condicion de filtrado por tipo de medio
	*/
	public function mediaTypeId($mediaTypeId) {
			return $this->useMediaQuery()
										->filterByTypeid($mediaTypeId)
									->endUse();
	}

 /**
	* Agrega filtros por issue y sus descendientes
	*
	* @param   type integer $issueId id del Issue
	* @return condicion de filtrado por issue y descendientes
	*/
	public function broodIssues($issueId) {
		$issue = IssueQuery::create()->findOneById($issueId);
		return $this->useHeadlineIssueQuery()
									->filterByIssue($issue->getThisAndBrood())
								->endUse();
	}

 /**
	* Agrega orden especifico para reportes
	*
	* @return condicion de ordenamiento de los datos para reporte
	*/
	public function setReportOrder() {
		return $this->orderByDatepublished('asc')
									->useHeadlineIssueQuery()
										->useIssueQuery()
											->orderByName()
										->endUse()
									->endUse()
									->useMediaQuery()
										->orderByName()
									->endUse();
	}

	/**
	 * Agrega filtro por actor y tipo de actor
	 *
	 * @param   int $actorId Id del actor
	 * @param   int $role Rol que desempenia el actor asociado
	 * @return  ModelCriteria
	 */
	public function filterByActorAndType($actorId,$role) {
		return $this->useHeadlineActorQuery()
									->filterByActorid($actorId)
									->filterByRole($role)
								->endUse();
	}



 /** Aplica los filtros basicos requeridos para los reportes
	 * 
	 **/
	public function applyReportFilters($filters){
		
		$personal = $filters['personalized'];
		if(empty($filters['type'])) 
			$filters['type'] = 0;
		
		return $this->filterByCampaignid($filters['campaignId'])
					->filterByCreatedat(array('min' => $filters['from'], 'max' => $filters['to']))
//					->filterByStatus(TwitterTweet::ACCEPTED)
//					->filterByText("%$personal%", Criteria::LIKE)
//					->getByType($filters['type'])
					->_if(!empty($filters['photo']))
						->filterByPicture($filters['photo'])
					->_endif();
					
	}

	public function countByRelevance($filters, $totalCount = false){
		
		$highlyRelevant = 1;
		$relevant = 2;
		$neutrallyRelevant = 3;
		$irrelevant = 4;
		$veryIrrelevant = 5;
		
		return $this->_if(!empty($filters['value']))
										->filterByValue($filters['value'])
									->_endif()
									->_if(!empty($filters['relevance']))
										->filterByRelevance($filters['relevance'])
									->_endif()
									->withColumn('sum(if(headlines_headline.Relevance = '. $highlyRelevant .', 1, 0))', 'highlyRelevant')
									->withColumn('sum(if(headlines_headline.Relevance = '. $relevant .', 1, 0))', 'relevant')
									->withColumn('sum(if(headlines_headline.Relevance = '. $neutrallyRelevant .', 1, 0))', 'neutrallyRelevant')
									->withColumn('sum(if(headlines_headline.Relevance = '. $irrelevant .', 1, 0))', 'irrelevant')
									->withColumn('sum(if(headlines_headline.Relevance = '. $veryIrrelevant .', 1, 0))', 'veryIrrelevant')
									->_if($totalCount)
										->select(array('highlyRelevant', 'relevant', 'neutrallyRelevant', 'irrelevant', 'veryIrrelevant'))
									->_else()
										->select(array('date', 'highlyRelevant', 'relevant', 'neutrallyRelevant', 'irrelevant', 'veryIrrelevant'))
									->_endif();
	}

 /**
	 * Agrupa la cantidad de titulares por valor
	 * 
	 **/
	public function countByValue($filters, $totalCount = false){
		
		$highlyPositive = 1;
		$positive = 2;
		$neutral = 3;
		$negative = 4;
		$highlyNegative = 5;
		
		return $this->_if(!empty($filters['relevance']))
										->filterByRelevance($filters['relevance'])
									->_endif()
									->_if(!empty($filters['value']))
										->filterByValue($filters['value'])
									->_endif()
									->withColumn('sum(if(headlines_headline.Value = '. $highlyPositive .', 1, 0))', 'highlyPositive')
									->withColumn('sum(if(headlines_headline.Value = '. $positive .', 1, 0))', 'positive')
									->withColumn('sum(if(headlines_headline.Value = '. $neutral .', 1, 0))', 'neutral')
									->withColumn('sum(if(headlines_headline.Value = '. $negative .', 1, 0))', 'negative')
									->withColumn('sum(if(headlines_headline.Value = '. $highlyNegative .', 1, 0))', 'highlyNegative')
									->_if($totalCount)
										->select(array('highlyPositive', 'positive', 'neutral', 'negative', 'highlyNegative'))
									->_else()
										->select(array('date', 'highlyPositive', 'positive', 'neutral', 'negative', 'highlyNegative'))
									->_endif();

	}



} // HeadlineQuery
