<?php


/**
 * Base class that represents a row from the 'documents_document' table.
 *
 * Documentos del sistema
 *
 * @package    propel.generator.documents.classes.om
 */
abstract class BaseDocument extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'DocumentPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        DocumentPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     * @var        string
     */
    protected $title;

    /**
     * The value for the realfilename field.
     * @var        string
     */
    protected $realfilename;

    /**
     * The value for the date field.
     * @var        string
     */
    protected $date;

    /**
     * The value for the categoryid field.
     * @var        int
     */
    protected $categoryid;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the document_date field.
     * @var        string
     */
    protected $document_date;

    /**
     * The value for the password field.
     * @var        string
     */
    protected $password;

    /**
     * The value for the author field.
     * @var        string
     */
    protected $author;

    /**
     * The value for the keywords field.
     * @var        string
     */
    protected $keywords;

    /**
     * The value for the number field.
     * @var        string
     */
    protected $number;

    /**
     * The value for the size field.
     * @var        int
     */
    protected $size;

    /**
     * The value for the fulltextcontent field.
     * @var        string
     */
    protected $fulltextcontent;

    /**
     * @var        Category
     */
    protected $aCategory;

    /**
     * @var        PropelObjectCollection|CampaignDocument[] Collection to store aggregation of CampaignDocument objects.
     */
    protected $collCampaignDocuments;
    protected $collCampaignDocumentsPartial;

    /**
     * @var        PropelObjectCollection|HeadlineDocument[] Collection to store aggregation of HeadlineDocument objects.
     */
    protected $collHeadlineDocuments;
    protected $collHeadlineDocumentsPartial;

    /**
     * @var        PropelObjectCollection|GuaranteeDocument[] Collection to store aggregation of GuaranteeDocument objects.
     */
    protected $collGuaranteeDocuments;
    protected $collGuaranteeDocumentsPartial;

    /**
     * @var        PropelObjectCollection|AdministrativeActDocument[] Collection to store aggregation of AdministrativeActDocument objects.
     */
    protected $collAdministrativeActDocuments;
    protected $collAdministrativeActDocumentsPartial;

    /**
     * @var        PropelObjectCollection|MissionDocument[] Collection to store aggregation of MissionDocument objects.
     */
    protected $collMissionDocuments;
    protected $collMissionDocumentsPartial;

    /**
     * @var        PropelObjectCollection|ReportSectionDocument[] Collection to store aggregation of ReportSectionDocument objects.
     */
    protected $collReportSectionDocuments;
    protected $collReportSectionDocumentsPartial;

    /**
     * @var        PropelObjectCollection|PositionDocument[] Collection to store aggregation of PositionDocument objects.
     */
    protected $collPositionDocuments;
    protected $collPositionDocumentsPartial;

    /**
     * @var        PropelObjectCollection|ProjectDocument[] Collection to store aggregation of ProjectDocument objects.
     */
    protected $collProjectDocuments;
    protected $collProjectDocumentsPartial;

    /**
     * @var        PropelObjectCollection|ActivityDocument[] Collection to store aggregation of ActivityDocument objects.
     */
    protected $collActivityDocuments;
    protected $collActivityDocumentsPartial;

    /**
     * @var        PropelObjectCollection|Campaign[] Collection to store aggregation of Campaign objects.
     */
    protected $collCampaigns;

    /**
     * @var        PropelObjectCollection|Headline[] Collection to store aggregation of Headline objects.
     */
    protected $collHeadlines;

    /**
     * @var        PropelObjectCollection|Guarantee[] Collection to store aggregation of Guarantee objects.
     */
    protected $collGuarantees;

    /**
     * @var        PropelObjectCollection|AdministrativeAct[] Collection to store aggregation of AdministrativeAct objects.
     */
    protected $collAdministrativeActs;

    /**
     * @var        PropelObjectCollection|Mission[] Collection to store aggregation of Mission objects.
     */
    protected $collMissions;

    /**
     * @var        PropelObjectCollection|ReportSection[] Collection to store aggregation of ReportSection objects.
     */
    protected $collReportSections;

    /**
     * @var        PropelObjectCollection|Position[] Collection to store aggregation of Position objects.
     */
    protected $collPositions;

    /**
     * @var        PropelObjectCollection|Project[] Collection to store aggregation of Project objects.
     */
    protected $collProjects;

    /**
     * @var        PropelObjectCollection|ProjectActivity[] Collection to store aggregation of ProjectActivity objects.
     */
    protected $collProjectActivitys;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $campaignsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlinesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $guaranteesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $administrativeActsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $missionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $reportSectionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $positionsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectActivitysScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $campaignDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $headlineDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $guaranteeDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $administrativeActDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $missionDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $reportSectionDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $positionDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $activityDocumentsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Id documento
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     * El titulo del archivo
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [realfilename] column value.
     * El nombre real del archivo
     * @return string
     */
    public function getRealfilename()
    {
        return $this->realfilename;
    }

    /**
     * Get the [optionally formatted] temporal [date] column value.
     * Fecha
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDate($format = '%Y/%m/%d')
    {
        if ($this->date === null) {
            return null;
        }

        if ($this->date === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->date);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->date, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [categoryid] column value.
     * Numero de tipo de archivo
     * @return int
     */
    public function getCategoryid()
    {
        return $this->categoryid;
    }

    /**
     * Get the [description] column value.
     * Descripcion del archivo
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [optionally formatted] temporal [document_date] column value.
     * Fecha del documento
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDocumentDate($format = '%Y/%m/%d')
    {
        if ($this->document_date === null) {
            return null;
        }

        if ($this->document_date === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->document_date);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->document_date, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [password] column value.
     * Clave del archivo
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Get the [author] column value.
     * Autor(es)
     * @return string
     */
    public function getAuthor()
    {
        return $this->author;
    }

    /**
     * Get the [keywords] column value.
     * Palabras clave
     * @return string
     */
    public function getKeywords()
    {
        return $this->keywords;
    }

    /**
     * Get the [number] column value.
     * Numero de Publicacion
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * Get the [size] column value.
     * Tamano de archivo
     * @return int
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Get the [fulltextcontent] column value.
     * Contenido del archivo
     * @return string
     */
    public function getFulltextcontent()
    {
        return $this->fulltextcontent;
    }

    /**
     * Set the value of [id] column.
     * Id documento
     * @param int $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = DocumentPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [title] column.
     * El titulo del archivo
     * @param string $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[] = DocumentPeer::TITLE;
        }


        return $this;
    } // setTitle()

    /**
     * Set the value of [realfilename] column.
     * El nombre real del archivo
     * @param string $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setRealfilename($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->realfilename !== $v) {
            $this->realfilename = $v;
            $this->modifiedColumns[] = DocumentPeer::REALFILENAME;
        }


        return $this;
    } // setRealfilename()

    /**
     * Sets the value of [date] column to a normalized version of the date/time value specified.
     * Fecha
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Document The current object (for fluent API support)
     */
    public function setDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->date !== null || $dt !== null) {
            $currentDateAsString = ($this->date !== null && $tmpDt = new DateTime($this->date)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->date = $newDateAsString;
                $this->modifiedColumns[] = DocumentPeer::DATE;
            }
        } // if either are not null


        return $this;
    } // setDate()

    /**
     * Set the value of [categoryid] column.
     * Numero de tipo de archivo
     * @param int $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setCategoryid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->categoryid !== $v) {
            $this->categoryid = $v;
            $this->modifiedColumns[] = DocumentPeer::CATEGORYID;
        }

        if ($this->aCategory !== null && $this->aCategory->getId() !== $v) {
            $this->aCategory = null;
        }


        return $this;
    } // setCategoryid()

    /**
     * Set the value of [description] column.
     * Descripcion del archivo
     * @param string $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = DocumentPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Sets the value of [document_date] column to a normalized version of the date/time value specified.
     * Fecha del documento
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return Document The current object (for fluent API support)
     */
    public function setDocumentDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->document_date !== null || $dt !== null) {
            $currentDateAsString = ($this->document_date !== null && $tmpDt = new DateTime($this->document_date)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->document_date = $newDateAsString;
                $this->modifiedColumns[] = DocumentPeer::DOCUMENT_DATE;
            }
        } // if either are not null


        return $this;
    } // setDocumentDate()

    /**
     * Set the value of [password] column.
     * Clave del archivo
     * @param string $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setPassword($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->password !== $v) {
            $this->password = $v;
            $this->modifiedColumns[] = DocumentPeer::PASSWORD;
        }


        return $this;
    } // setPassword()

    /**
     * Set the value of [author] column.
     * Autor(es)
     * @param string $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setAuthor($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->author !== $v) {
            $this->author = $v;
            $this->modifiedColumns[] = DocumentPeer::AUTHOR;
        }


        return $this;
    } // setAuthor()

    /**
     * Set the value of [keywords] column.
     * Palabras clave
     * @param string $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setKeywords($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->keywords !== $v) {
            $this->keywords = $v;
            $this->modifiedColumns[] = DocumentPeer::KEYWORDS;
        }


        return $this;
    } // setKeywords()

    /**
     * Set the value of [number] column.
     * Numero de Publicacion
     * @param string $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setNumber($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->number !== $v) {
            $this->number = $v;
            $this->modifiedColumns[] = DocumentPeer::NUMBER;
        }


        return $this;
    } // setNumber()

    /**
     * Set the value of [size] column.
     * Tamano de archivo
     * @param int $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setSize($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->size !== $v) {
            $this->size = $v;
            $this->modifiedColumns[] = DocumentPeer::SIZE;
        }


        return $this;
    } // setSize()

    /**
     * Set the value of [fulltextcontent] column.
     * Contenido del archivo
     * @param string $v new value
     * @return Document The current object (for fluent API support)
     */
    public function setFulltextcontent($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->fulltextcontent !== $v) {
            $this->fulltextcontent = $v;
            $this->modifiedColumns[] = DocumentPeer::FULLTEXTCONTENT;
        }


        return $this;
    } // setFulltextcontent()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->title = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->realfilename = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->date = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->categoryid = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->description = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->document_date = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->password = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->author = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
            $this->keywords = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->number = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->size = ($row[$startcol + 11] !== null) ? (int) $row[$startcol + 11] : null;
            $this->fulltextcontent = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 13; // 13 = DocumentPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Document object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aCategory !== null && $this->categoryid !== $this->aCategory->getId()) {
            $this->aCategory = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(DocumentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = DocumentPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aCategory = null;
            $this->collCampaignDocuments = null;

            $this->collHeadlineDocuments = null;

            $this->collGuaranteeDocuments = null;

            $this->collAdministrativeActDocuments = null;

            $this->collMissionDocuments = null;

            $this->collReportSectionDocuments = null;

            $this->collPositionDocuments = null;

            $this->collProjectDocuments = null;

            $this->collActivityDocuments = null;

            $this->collCampaigns = null;
            $this->collHeadlines = null;
            $this->collGuarantees = null;
            $this->collAdministrativeActs = null;
            $this->collMissions = null;
            $this->collReportSections = null;
            $this->collPositions = null;
            $this->collProjects = null;
            $this->collProjectActivitys = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(DocumentPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = DocumentQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(DocumentPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                DocumentPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCategory !== null) {
                if ($this->aCategory->isModified() || $this->aCategory->isNew()) {
                    $affectedRows += $this->aCategory->save($con);
                }
                $this->setCategory($this->aCategory);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->campaignsScheduledForDeletion !== null) {
                if (!$this->campaignsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->campaignsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    CampaignDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->campaignsScheduledForDeletion = null;
                }

                foreach ($this->getCampaigns() as $campaign) {
                    if ($campaign->isModified()) {
                        $campaign->save($con);
                    }
                }
            }

            if ($this->headlinesScheduledForDeletion !== null) {
                if (!$this->headlinesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->headlinesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    HeadlineDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->headlinesScheduledForDeletion = null;
                }

                foreach ($this->getHeadlines() as $headline) {
                    if ($headline->isModified()) {
                        $headline->save($con);
                    }
                }
            }

            if ($this->guaranteesScheduledForDeletion !== null) {
                if (!$this->guaranteesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->guaranteesScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    GuaranteeDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->guaranteesScheduledForDeletion = null;
                }

                foreach ($this->getGuarantees() as $guarantee) {
                    if ($guarantee->isModified()) {
                        $guarantee->save($con);
                    }
                }
            }

            if ($this->administrativeActsScheduledForDeletion !== null) {
                if (!$this->administrativeActsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->administrativeActsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    AdministrativeActDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->administrativeActsScheduledForDeletion = null;
                }

                foreach ($this->getAdministrativeActs() as $administrativeAct) {
                    if ($administrativeAct->isModified()) {
                        $administrativeAct->save($con);
                    }
                }
            }

            if ($this->missionsScheduledForDeletion !== null) {
                if (!$this->missionsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->missionsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    MissionDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->missionsScheduledForDeletion = null;
                }

                foreach ($this->getMissions() as $mission) {
                    if ($mission->isModified()) {
                        $mission->save($con);
                    }
                }
            }

            if ($this->reportSectionsScheduledForDeletion !== null) {
                if (!$this->reportSectionsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->reportSectionsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    ReportSectionDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->reportSectionsScheduledForDeletion = null;
                }

                foreach ($this->getReportSections() as $reportSection) {
                    if ($reportSection->isModified()) {
                        $reportSection->save($con);
                    }
                }
            }

            if ($this->positionsScheduledForDeletion !== null) {
                if (!$this->positionsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->positionsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    PositionDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->positionsScheduledForDeletion = null;
                }

                foreach ($this->getPositions() as $position) {
                    if ($position->isModified()) {
                        $position->save($con);
                    }
                }
            }

            if ($this->projectsScheduledForDeletion !== null) {
                if (!$this->projectsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->projectsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    ProjectDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->projectsScheduledForDeletion = null;
                }

                foreach ($this->getProjects() as $project) {
                    if ($project->isModified()) {
                        $project->save($con);
                    }
                }
            }

            if ($this->projectActivitysScheduledForDeletion !== null) {
                if (!$this->projectActivitysScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->projectActivitysScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($remotePk, $pk);
                    }
                    ActivityDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->projectActivitysScheduledForDeletion = null;
                }

                foreach ($this->getProjectActivitys() as $projectActivity) {
                    if ($projectActivity->isModified()) {
                        $projectActivity->save($con);
                    }
                }
            }

            if ($this->campaignDocumentsScheduledForDeletion !== null) {
                if (!$this->campaignDocumentsScheduledForDeletion->isEmpty()) {
                    CampaignDocumentQuery::create()
                        ->filterByPrimaryKeys($this->campaignDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->campaignDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collCampaignDocuments !== null) {
                foreach ($this->collCampaignDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->headlineDocumentsScheduledForDeletion !== null) {
                if (!$this->headlineDocumentsScheduledForDeletion->isEmpty()) {
                    HeadlineDocumentQuery::create()
                        ->filterByPrimaryKeys($this->headlineDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->headlineDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collHeadlineDocuments !== null) {
                foreach ($this->collHeadlineDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->guaranteeDocumentsScheduledForDeletion !== null) {
                if (!$this->guaranteeDocumentsScheduledForDeletion->isEmpty()) {
                    GuaranteeDocumentQuery::create()
                        ->filterByPrimaryKeys($this->guaranteeDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->guaranteeDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collGuaranteeDocuments !== null) {
                foreach ($this->collGuaranteeDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->administrativeActDocumentsScheduledForDeletion !== null) {
                if (!$this->administrativeActDocumentsScheduledForDeletion->isEmpty()) {
                    AdministrativeActDocumentQuery::create()
                        ->filterByPrimaryKeys($this->administrativeActDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->administrativeActDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collAdministrativeActDocuments !== null) {
                foreach ($this->collAdministrativeActDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->missionDocumentsScheduledForDeletion !== null) {
                if (!$this->missionDocumentsScheduledForDeletion->isEmpty()) {
                    MissionDocumentQuery::create()
                        ->filterByPrimaryKeys($this->missionDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->missionDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collMissionDocuments !== null) {
                foreach ($this->collMissionDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->reportSectionDocumentsScheduledForDeletion !== null) {
                if (!$this->reportSectionDocumentsScheduledForDeletion->isEmpty()) {
                    ReportSectionDocumentQuery::create()
                        ->filterByPrimaryKeys($this->reportSectionDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->reportSectionDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collReportSectionDocuments !== null) {
                foreach ($this->collReportSectionDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->positionDocumentsScheduledForDeletion !== null) {
                if (!$this->positionDocumentsScheduledForDeletion->isEmpty()) {
                    PositionDocumentQuery::create()
                        ->filterByPrimaryKeys($this->positionDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->positionDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collPositionDocuments !== null) {
                foreach ($this->collPositionDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectDocumentsScheduledForDeletion !== null) {
                if (!$this->projectDocumentsScheduledForDeletion->isEmpty()) {
                    ProjectDocumentQuery::create()
                        ->filterByPrimaryKeys($this->projectDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectDocuments !== null) {
                foreach ($this->collProjectDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->activityDocumentsScheduledForDeletion !== null) {
                if (!$this->activityDocumentsScheduledForDeletion->isEmpty()) {
                    ActivityDocumentQuery::create()
                        ->filterByPrimaryKeys($this->activityDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->activityDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collActivityDocuments !== null) {
                foreach ($this->collActivityDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = DocumentPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . DocumentPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(DocumentPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(DocumentPeer::TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`TITLE`';
        }
        if ($this->isColumnModified(DocumentPeer::REALFILENAME)) {
            $modifiedColumns[':p' . $index++]  = '`REALFILENAME`';
        }
        if ($this->isColumnModified(DocumentPeer::DATE)) {
            $modifiedColumns[':p' . $index++]  = '`DATE`';
        }
        if ($this->isColumnModified(DocumentPeer::CATEGORYID)) {
            $modifiedColumns[':p' . $index++]  = '`CATEGORYID`';
        }
        if ($this->isColumnModified(DocumentPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(DocumentPeer::DOCUMENT_DATE)) {
            $modifiedColumns[':p' . $index++]  = '`DOCUMENT_DATE`';
        }
        if ($this->isColumnModified(DocumentPeer::PASSWORD)) {
            $modifiedColumns[':p' . $index++]  = '`PASSWORD`';
        }
        if ($this->isColumnModified(DocumentPeer::AUTHOR)) {
            $modifiedColumns[':p' . $index++]  = '`AUTHOR`';
        }
        if ($this->isColumnModified(DocumentPeer::KEYWORDS)) {
            $modifiedColumns[':p' . $index++]  = '`KEYWORDS`';
        }
        if ($this->isColumnModified(DocumentPeer::NUMBER)) {
            $modifiedColumns[':p' . $index++]  = '`NUMBER`';
        }
        if ($this->isColumnModified(DocumentPeer::SIZE)) {
            $modifiedColumns[':p' . $index++]  = '`SIZE`';
        }
        if ($this->isColumnModified(DocumentPeer::FULLTEXTCONTENT)) {
            $modifiedColumns[':p' . $index++]  = '`FULLTEXTCONTENT`';
        }

        $sql = sprintf(
            'INSERT INTO `documents_document` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`TITLE`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`REALFILENAME`':
                        $stmt->bindValue($identifier, $this->realfilename, PDO::PARAM_STR);
                        break;
                    case '`DATE`':
                        $stmt->bindValue($identifier, $this->date, PDO::PARAM_STR);
                        break;
                    case '`CATEGORYID`':
                        $stmt->bindValue($identifier, $this->categoryid, PDO::PARAM_INT);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`DOCUMENT_DATE`':
                        $stmt->bindValue($identifier, $this->document_date, PDO::PARAM_STR);
                        break;
                    case '`PASSWORD`':
                        $stmt->bindValue($identifier, $this->password, PDO::PARAM_STR);
                        break;
                    case '`AUTHOR`':
                        $stmt->bindValue($identifier, $this->author, PDO::PARAM_STR);
                        break;
                    case '`KEYWORDS`':
                        $stmt->bindValue($identifier, $this->keywords, PDO::PARAM_STR);
                        break;
                    case '`NUMBER`':
                        $stmt->bindValue($identifier, $this->number, PDO::PARAM_STR);
                        break;
                    case '`SIZE`':
                        $stmt->bindValue($identifier, $this->size, PDO::PARAM_INT);
                        break;
                    case '`FULLTEXTCONTENT`':
                        $stmt->bindValue($identifier, $this->fulltextcontent, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCategory !== null) {
                if (!$this->aCategory->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aCategory->getValidationFailures());
                }
            }


            if (($retval = DocumentPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collCampaignDocuments !== null) {
                    foreach ($this->collCampaignDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collHeadlineDocuments !== null) {
                    foreach ($this->collHeadlineDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collGuaranteeDocuments !== null) {
                    foreach ($this->collGuaranteeDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collAdministrativeActDocuments !== null) {
                    foreach ($this->collAdministrativeActDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collMissionDocuments !== null) {
                    foreach ($this->collMissionDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collReportSectionDocuments !== null) {
                    foreach ($this->collReportSectionDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collPositionDocuments !== null) {
                    foreach ($this->collPositionDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectDocuments !== null) {
                    foreach ($this->collProjectDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collActivityDocuments !== null) {
                    foreach ($this->collActivityDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = DocumentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getTitle();
                break;
            case 2:
                return $this->getRealfilename();
                break;
            case 3:
                return $this->getDate();
                break;
            case 4:
                return $this->getCategoryid();
                break;
            case 5:
                return $this->getDescription();
                break;
            case 6:
                return $this->getDocumentDate();
                break;
            case 7:
                return $this->getPassword();
                break;
            case 8:
                return $this->getAuthor();
                break;
            case 9:
                return $this->getKeywords();
                break;
            case 10:
                return $this->getNumber();
                break;
            case 11:
                return $this->getSize();
                break;
            case 12:
                return $this->getFulltextcontent();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Document'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Document'][$this->getPrimaryKey()] = true;
        $keys = DocumentPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getRealfilename(),
            $keys[3] => $this->getDate(),
            $keys[4] => $this->getCategoryid(),
            $keys[5] => $this->getDescription(),
            $keys[6] => $this->getDocumentDate(),
            $keys[7] => $this->getPassword(),
            $keys[8] => $this->getAuthor(),
            $keys[9] => $this->getKeywords(),
            $keys[10] => $this->getNumber(),
            $keys[11] => $this->getSize(),
            $keys[12] => $this->getFulltextcontent(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aCategory) {
                $result['Category'] = $this->aCategory->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collCampaignDocuments) {
                $result['CampaignDocuments'] = $this->collCampaignDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collHeadlineDocuments) {
                $result['HeadlineDocuments'] = $this->collHeadlineDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collGuaranteeDocuments) {
                $result['GuaranteeDocuments'] = $this->collGuaranteeDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collAdministrativeActDocuments) {
                $result['AdministrativeActDocuments'] = $this->collAdministrativeActDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collMissionDocuments) {
                $result['MissionDocuments'] = $this->collMissionDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collReportSectionDocuments) {
                $result['ReportSectionDocuments'] = $this->collReportSectionDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPositionDocuments) {
                $result['PositionDocuments'] = $this->collPositionDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectDocuments) {
                $result['ProjectDocuments'] = $this->collProjectDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collActivityDocuments) {
                $result['ActivityDocuments'] = $this->collActivityDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = DocumentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setRealfilename($value);
                break;
            case 3:
                $this->setDate($value);
                break;
            case 4:
                $this->setCategoryid($value);
                break;
            case 5:
                $this->setDescription($value);
                break;
            case 6:
                $this->setDocumentDate($value);
                break;
            case 7:
                $this->setPassword($value);
                break;
            case 8:
                $this->setAuthor($value);
                break;
            case 9:
                $this->setKeywords($value);
                break;
            case 10:
                $this->setNumber($value);
                break;
            case 11:
                $this->setSize($value);
                break;
            case 12:
                $this->setFulltextcontent($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = DocumentPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setTitle($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setRealfilename($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setDate($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setCategoryid($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setDescription($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setDocumentDate($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setPassword($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setAuthor($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setKeywords($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setNumber($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setSize($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setFulltextcontent($arr[$keys[12]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(DocumentPeer::DATABASE_NAME);

        if ($this->isColumnModified(DocumentPeer::ID)) $criteria->add(DocumentPeer::ID, $this->id);
        if ($this->isColumnModified(DocumentPeer::TITLE)) $criteria->add(DocumentPeer::TITLE, $this->title);
        if ($this->isColumnModified(DocumentPeer::REALFILENAME)) $criteria->add(DocumentPeer::REALFILENAME, $this->realfilename);
        if ($this->isColumnModified(DocumentPeer::DATE)) $criteria->add(DocumentPeer::DATE, $this->date);
        if ($this->isColumnModified(DocumentPeer::CATEGORYID)) $criteria->add(DocumentPeer::CATEGORYID, $this->categoryid);
        if ($this->isColumnModified(DocumentPeer::DESCRIPTION)) $criteria->add(DocumentPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(DocumentPeer::DOCUMENT_DATE)) $criteria->add(DocumentPeer::DOCUMENT_DATE, $this->document_date);
        if ($this->isColumnModified(DocumentPeer::PASSWORD)) $criteria->add(DocumentPeer::PASSWORD, $this->password);
        if ($this->isColumnModified(DocumentPeer::AUTHOR)) $criteria->add(DocumentPeer::AUTHOR, $this->author);
        if ($this->isColumnModified(DocumentPeer::KEYWORDS)) $criteria->add(DocumentPeer::KEYWORDS, $this->keywords);
        if ($this->isColumnModified(DocumentPeer::NUMBER)) $criteria->add(DocumentPeer::NUMBER, $this->number);
        if ($this->isColumnModified(DocumentPeer::SIZE)) $criteria->add(DocumentPeer::SIZE, $this->size);
        if ($this->isColumnModified(DocumentPeer::FULLTEXTCONTENT)) $criteria->add(DocumentPeer::FULLTEXTCONTENT, $this->fulltextcontent);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(DocumentPeer::DATABASE_NAME);
        $criteria->add(DocumentPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Document (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setRealfilename($this->getRealfilename());
        $copyObj->setDate($this->getDate());
        $copyObj->setCategoryid($this->getCategoryid());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setDocumentDate($this->getDocumentDate());
        $copyObj->setPassword($this->getPassword());
        $copyObj->setAuthor($this->getAuthor());
        $copyObj->setKeywords($this->getKeywords());
        $copyObj->setNumber($this->getNumber());
        $copyObj->setSize($this->getSize());
        $copyObj->setFulltextcontent($this->getFulltextcontent());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getCampaignDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addCampaignDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getHeadlineDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHeadlineDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getGuaranteeDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addGuaranteeDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getAdministrativeActDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addAdministrativeActDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getMissionDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMissionDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getReportSectionDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addReportSectionDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPositionDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPositionDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getActivityDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addActivityDocument($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Document Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return DocumentPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new DocumentPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Category object.
     *
     * @param             Category $v
     * @return Document The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCategory(Category $v = null)
    {
        if ($v === null) {
            $this->setCategoryid(NULL);
        } else {
            $this->setCategoryid($v->getId());
        }

        $this->aCategory = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Category object, it will not be re-added.
        if ($v !== null) {
            $v->addDocument($this);
        }


        return $this;
    }


    /**
     * Get the associated Category object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Category The associated Category object.
     * @throws PropelException
     */
    public function getCategory(PropelPDO $con = null)
    {
        if ($this->aCategory === null && ($this->categoryid !== null)) {
            $this->aCategory = CategoryQuery::create()->findPk($this->categoryid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCategory->addDocuments($this);
             */
        }

        return $this->aCategory;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('CampaignDocument' == $relationName) {
            $this->initCampaignDocuments();
        }
        if ('HeadlineDocument' == $relationName) {
            $this->initHeadlineDocuments();
        }
        if ('GuaranteeDocument' == $relationName) {
            $this->initGuaranteeDocuments();
        }
        if ('AdministrativeActDocument' == $relationName) {
            $this->initAdministrativeActDocuments();
        }
        if ('MissionDocument' == $relationName) {
            $this->initMissionDocuments();
        }
        if ('ReportSectionDocument' == $relationName) {
            $this->initReportSectionDocuments();
        }
        if ('PositionDocument' == $relationName) {
            $this->initPositionDocuments();
        }
        if ('ProjectDocument' == $relationName) {
            $this->initProjectDocuments();
        }
        if ('ActivityDocument' == $relationName) {
            $this->initActivityDocuments();
        }
    }

    /**
     * Clears out the collCampaignDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addCampaignDocuments()
     */
    public function clearCampaignDocuments()
    {
        $this->collCampaignDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collCampaignDocumentsPartial = null;
    }

    /**
     * reset is the collCampaignDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialCampaignDocuments($v = true)
    {
        $this->collCampaignDocumentsPartial = $v;
    }

    /**
     * Initializes the collCampaignDocuments collection.
     *
     * By default this just sets the collCampaignDocuments collection to an empty array (like clearcollCampaignDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initCampaignDocuments($overrideExisting = true)
    {
        if (null !== $this->collCampaignDocuments && !$overrideExisting) {
            return;
        }
        $this->collCampaignDocuments = new PropelObjectCollection();
        $this->collCampaignDocuments->setModel('CampaignDocument');
    }

    /**
     * Gets an array of CampaignDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|CampaignDocument[] List of CampaignDocument objects
     * @throws PropelException
     */
    public function getCampaignDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collCampaignDocumentsPartial && !$this->isNew();
        if (null === $this->collCampaignDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collCampaignDocuments) {
                // return empty collection
                $this->initCampaignDocuments();
            } else {
                $collCampaignDocuments = CampaignDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collCampaignDocumentsPartial && count($collCampaignDocuments)) {
                      $this->initCampaignDocuments(false);

                      foreach($collCampaignDocuments as $obj) {
                        if (false == $this->collCampaignDocuments->contains($obj)) {
                          $this->collCampaignDocuments->append($obj);
                        }
                      }

                      $this->collCampaignDocumentsPartial = true;
                    }

                    return $collCampaignDocuments;
                }

                if($partial && $this->collCampaignDocuments) {
                    foreach($this->collCampaignDocuments as $obj) {
                        if($obj->isNew()) {
                            $collCampaignDocuments[] = $obj;
                        }
                    }
                }

                $this->collCampaignDocuments = $collCampaignDocuments;
                $this->collCampaignDocumentsPartial = false;
            }
        }

        return $this->collCampaignDocuments;
    }

    /**
     * Sets a collection of CampaignDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $campaignDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setCampaignDocuments(PropelCollection $campaignDocuments, PropelPDO $con = null)
    {
        $this->campaignDocumentsScheduledForDeletion = $this->getCampaignDocuments(new Criteria(), $con)->diff($campaignDocuments);

        foreach ($this->campaignDocumentsScheduledForDeletion as $campaignDocumentRemoved) {
            $campaignDocumentRemoved->setDocument(null);
        }

        $this->collCampaignDocuments = null;
        foreach ($campaignDocuments as $campaignDocument) {
            $this->addCampaignDocument($campaignDocument);
        }

        $this->collCampaignDocuments = $campaignDocuments;
        $this->collCampaignDocumentsPartial = false;
    }

    /**
     * Returns the number of related CampaignDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related CampaignDocument objects.
     * @throws PropelException
     */
    public function countCampaignDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collCampaignDocumentsPartial && !$this->isNew();
        if (null === $this->collCampaignDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collCampaignDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getCampaignDocuments());
                }
                $query = CampaignDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collCampaignDocuments);
        }
    }

    /**
     * Method called to associate a CampaignDocument object to this object
     * through the CampaignDocument foreign key attribute.
     *
     * @param    CampaignDocument $l CampaignDocument
     * @return Document The current object (for fluent API support)
     */
    public function addCampaignDocument(CampaignDocument $l)
    {
        if ($this->collCampaignDocuments === null) {
            $this->initCampaignDocuments();
            $this->collCampaignDocumentsPartial = true;
        }
        if (!$this->collCampaignDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddCampaignDocument($l);
        }

        return $this;
    }

    /**
     * @param	CampaignDocument $campaignDocument The campaignDocument object to add.
     */
    protected function doAddCampaignDocument($campaignDocument)
    {
        $this->collCampaignDocuments[]= $campaignDocument;
        $campaignDocument->setDocument($this);
    }

    /**
     * @param	CampaignDocument $campaignDocument The campaignDocument object to remove.
     */
    public function removeCampaignDocument($campaignDocument)
    {
        if ($this->getCampaignDocuments()->contains($campaignDocument)) {
            $this->collCampaignDocuments->remove($this->collCampaignDocuments->search($campaignDocument));
            if (null === $this->campaignDocumentsScheduledForDeletion) {
                $this->campaignDocumentsScheduledForDeletion = clone $this->collCampaignDocuments;
                $this->campaignDocumentsScheduledForDeletion->clear();
            }
            $this->campaignDocumentsScheduledForDeletion[]= $campaignDocument;
            $campaignDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related CampaignDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|CampaignDocument[] List of CampaignDocument objects
     */
    public function getCampaignDocumentsJoinCampaign($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = CampaignDocumentQuery::create(null, $criteria);
        $query->joinWith('Campaign', $join_behavior);

        return $this->getCampaignDocuments($query, $con);
    }

    /**
     * Clears out the collHeadlineDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlineDocuments()
     */
    public function clearHeadlineDocuments()
    {
        $this->collHeadlineDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlineDocumentsPartial = null;
    }

    /**
     * reset is the collHeadlineDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialHeadlineDocuments($v = true)
    {
        $this->collHeadlineDocumentsPartial = $v;
    }

    /**
     * Initializes the collHeadlineDocuments collection.
     *
     * By default this just sets the collHeadlineDocuments collection to an empty array (like clearcollHeadlineDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHeadlineDocuments($overrideExisting = true)
    {
        if (null !== $this->collHeadlineDocuments && !$overrideExisting) {
            return;
        }
        $this->collHeadlineDocuments = new PropelObjectCollection();
        $this->collHeadlineDocuments->setModel('HeadlineDocument');
    }

    /**
     * Gets an array of HeadlineDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|HeadlineDocument[] List of HeadlineDocument objects
     * @throws PropelException
     */
    public function getHeadlineDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineDocumentsPartial && !$this->isNew();
        if (null === $this->collHeadlineDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHeadlineDocuments) {
                // return empty collection
                $this->initHeadlineDocuments();
            } else {
                $collHeadlineDocuments = HeadlineDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collHeadlineDocumentsPartial && count($collHeadlineDocuments)) {
                      $this->initHeadlineDocuments(false);

                      foreach($collHeadlineDocuments as $obj) {
                        if (false == $this->collHeadlineDocuments->contains($obj)) {
                          $this->collHeadlineDocuments->append($obj);
                        }
                      }

                      $this->collHeadlineDocumentsPartial = true;
                    }

                    return $collHeadlineDocuments;
                }

                if($partial && $this->collHeadlineDocuments) {
                    foreach($this->collHeadlineDocuments as $obj) {
                        if($obj->isNew()) {
                            $collHeadlineDocuments[] = $obj;
                        }
                    }
                }

                $this->collHeadlineDocuments = $collHeadlineDocuments;
                $this->collHeadlineDocumentsPartial = false;
            }
        }

        return $this->collHeadlineDocuments;
    }

    /**
     * Sets a collection of HeadlineDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlineDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlineDocuments(PropelCollection $headlineDocuments, PropelPDO $con = null)
    {
        $this->headlineDocumentsScheduledForDeletion = $this->getHeadlineDocuments(new Criteria(), $con)->diff($headlineDocuments);

        foreach ($this->headlineDocumentsScheduledForDeletion as $headlineDocumentRemoved) {
            $headlineDocumentRemoved->setDocument(null);
        }

        $this->collHeadlineDocuments = null;
        foreach ($headlineDocuments as $headlineDocument) {
            $this->addHeadlineDocument($headlineDocument);
        }

        $this->collHeadlineDocuments = $headlineDocuments;
        $this->collHeadlineDocumentsPartial = false;
    }

    /**
     * Returns the number of related HeadlineDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related HeadlineDocument objects.
     * @throws PropelException
     */
    public function countHeadlineDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collHeadlineDocumentsPartial && !$this->isNew();
        if (null === $this->collHeadlineDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHeadlineDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getHeadlineDocuments());
                }
                $query = HeadlineDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlineDocuments);
        }
    }

    /**
     * Method called to associate a HeadlineDocument object to this object
     * through the HeadlineDocument foreign key attribute.
     *
     * @param    HeadlineDocument $l HeadlineDocument
     * @return Document The current object (for fluent API support)
     */
    public function addHeadlineDocument(HeadlineDocument $l)
    {
        if ($this->collHeadlineDocuments === null) {
            $this->initHeadlineDocuments();
            $this->collHeadlineDocumentsPartial = true;
        }
        if (!$this->collHeadlineDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddHeadlineDocument($l);
        }

        return $this;
    }

    /**
     * @param	HeadlineDocument $headlineDocument The headlineDocument object to add.
     */
    protected function doAddHeadlineDocument($headlineDocument)
    {
        $this->collHeadlineDocuments[]= $headlineDocument;
        $headlineDocument->setDocument($this);
    }

    /**
     * @param	HeadlineDocument $headlineDocument The headlineDocument object to remove.
     */
    public function removeHeadlineDocument($headlineDocument)
    {
        if ($this->getHeadlineDocuments()->contains($headlineDocument)) {
            $this->collHeadlineDocuments->remove($this->collHeadlineDocuments->search($headlineDocument));
            if (null === $this->headlineDocumentsScheduledForDeletion) {
                $this->headlineDocumentsScheduledForDeletion = clone $this->collHeadlineDocuments;
                $this->headlineDocumentsScheduledForDeletion->clear();
            }
            $this->headlineDocumentsScheduledForDeletion[]= $headlineDocument;
            $headlineDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related HeadlineDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|HeadlineDocument[] List of HeadlineDocument objects
     */
    public function getHeadlineDocumentsJoinHeadline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = HeadlineDocumentQuery::create(null, $criteria);
        $query->joinWith('Headline', $join_behavior);

        return $this->getHeadlineDocuments($query, $con);
    }

    /**
     * Clears out the collGuaranteeDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addGuaranteeDocuments()
     */
    public function clearGuaranteeDocuments()
    {
        $this->collGuaranteeDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collGuaranteeDocumentsPartial = null;
    }

    /**
     * reset is the collGuaranteeDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialGuaranteeDocuments($v = true)
    {
        $this->collGuaranteeDocumentsPartial = $v;
    }

    /**
     * Initializes the collGuaranteeDocuments collection.
     *
     * By default this just sets the collGuaranteeDocuments collection to an empty array (like clearcollGuaranteeDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initGuaranteeDocuments($overrideExisting = true)
    {
        if (null !== $this->collGuaranteeDocuments && !$overrideExisting) {
            return;
        }
        $this->collGuaranteeDocuments = new PropelObjectCollection();
        $this->collGuaranteeDocuments->setModel('GuaranteeDocument');
    }

    /**
     * Gets an array of GuaranteeDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|GuaranteeDocument[] List of GuaranteeDocument objects
     * @throws PropelException
     */
    public function getGuaranteeDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collGuaranteeDocumentsPartial && !$this->isNew();
        if (null === $this->collGuaranteeDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collGuaranteeDocuments) {
                // return empty collection
                $this->initGuaranteeDocuments();
            } else {
                $collGuaranteeDocuments = GuaranteeDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collGuaranteeDocumentsPartial && count($collGuaranteeDocuments)) {
                      $this->initGuaranteeDocuments(false);

                      foreach($collGuaranteeDocuments as $obj) {
                        if (false == $this->collGuaranteeDocuments->contains($obj)) {
                          $this->collGuaranteeDocuments->append($obj);
                        }
                      }

                      $this->collGuaranteeDocumentsPartial = true;
                    }

                    return $collGuaranteeDocuments;
                }

                if($partial && $this->collGuaranteeDocuments) {
                    foreach($this->collGuaranteeDocuments as $obj) {
                        if($obj->isNew()) {
                            $collGuaranteeDocuments[] = $obj;
                        }
                    }
                }

                $this->collGuaranteeDocuments = $collGuaranteeDocuments;
                $this->collGuaranteeDocumentsPartial = false;
            }
        }

        return $this->collGuaranteeDocuments;
    }

    /**
     * Sets a collection of GuaranteeDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $guaranteeDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setGuaranteeDocuments(PropelCollection $guaranteeDocuments, PropelPDO $con = null)
    {
        $this->guaranteeDocumentsScheduledForDeletion = $this->getGuaranteeDocuments(new Criteria(), $con)->diff($guaranteeDocuments);

        foreach ($this->guaranteeDocumentsScheduledForDeletion as $guaranteeDocumentRemoved) {
            $guaranteeDocumentRemoved->setDocument(null);
        }

        $this->collGuaranteeDocuments = null;
        foreach ($guaranteeDocuments as $guaranteeDocument) {
            $this->addGuaranteeDocument($guaranteeDocument);
        }

        $this->collGuaranteeDocuments = $guaranteeDocuments;
        $this->collGuaranteeDocumentsPartial = false;
    }

    /**
     * Returns the number of related GuaranteeDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related GuaranteeDocument objects.
     * @throws PropelException
     */
    public function countGuaranteeDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collGuaranteeDocumentsPartial && !$this->isNew();
        if (null === $this->collGuaranteeDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collGuaranteeDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getGuaranteeDocuments());
                }
                $query = GuaranteeDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collGuaranteeDocuments);
        }
    }

    /**
     * Method called to associate a GuaranteeDocument object to this object
     * through the GuaranteeDocument foreign key attribute.
     *
     * @param    GuaranteeDocument $l GuaranteeDocument
     * @return Document The current object (for fluent API support)
     */
    public function addGuaranteeDocument(GuaranteeDocument $l)
    {
        if ($this->collGuaranteeDocuments === null) {
            $this->initGuaranteeDocuments();
            $this->collGuaranteeDocumentsPartial = true;
        }
        if (!$this->collGuaranteeDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddGuaranteeDocument($l);
        }

        return $this;
    }

    /**
     * @param	GuaranteeDocument $guaranteeDocument The guaranteeDocument object to add.
     */
    protected function doAddGuaranteeDocument($guaranteeDocument)
    {
        $this->collGuaranteeDocuments[]= $guaranteeDocument;
        $guaranteeDocument->setDocument($this);
    }

    /**
     * @param	GuaranteeDocument $guaranteeDocument The guaranteeDocument object to remove.
     */
    public function removeGuaranteeDocument($guaranteeDocument)
    {
        if ($this->getGuaranteeDocuments()->contains($guaranteeDocument)) {
            $this->collGuaranteeDocuments->remove($this->collGuaranteeDocuments->search($guaranteeDocument));
            if (null === $this->guaranteeDocumentsScheduledForDeletion) {
                $this->guaranteeDocumentsScheduledForDeletion = clone $this->collGuaranteeDocuments;
                $this->guaranteeDocumentsScheduledForDeletion->clear();
            }
            $this->guaranteeDocumentsScheduledForDeletion[]= $guaranteeDocument;
            $guaranteeDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related GuaranteeDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|GuaranteeDocument[] List of GuaranteeDocument objects
     */
    public function getGuaranteeDocumentsJoinGuarantee($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = GuaranteeDocumentQuery::create(null, $criteria);
        $query->joinWith('Guarantee', $join_behavior);

        return $this->getGuaranteeDocuments($query, $con);
    }

    /**
     * Clears out the collAdministrativeActDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addAdministrativeActDocuments()
     */
    public function clearAdministrativeActDocuments()
    {
        $this->collAdministrativeActDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collAdministrativeActDocumentsPartial = null;
    }

    /**
     * reset is the collAdministrativeActDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialAdministrativeActDocuments($v = true)
    {
        $this->collAdministrativeActDocumentsPartial = $v;
    }

    /**
     * Initializes the collAdministrativeActDocuments collection.
     *
     * By default this just sets the collAdministrativeActDocuments collection to an empty array (like clearcollAdministrativeActDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initAdministrativeActDocuments($overrideExisting = true)
    {
        if (null !== $this->collAdministrativeActDocuments && !$overrideExisting) {
            return;
        }
        $this->collAdministrativeActDocuments = new PropelObjectCollection();
        $this->collAdministrativeActDocuments->setModel('AdministrativeActDocument');
    }

    /**
     * Gets an array of AdministrativeActDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|AdministrativeActDocument[] List of AdministrativeActDocument objects
     * @throws PropelException
     */
    public function getAdministrativeActDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collAdministrativeActDocumentsPartial && !$this->isNew();
        if (null === $this->collAdministrativeActDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collAdministrativeActDocuments) {
                // return empty collection
                $this->initAdministrativeActDocuments();
            } else {
                $collAdministrativeActDocuments = AdministrativeActDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collAdministrativeActDocumentsPartial && count($collAdministrativeActDocuments)) {
                      $this->initAdministrativeActDocuments(false);

                      foreach($collAdministrativeActDocuments as $obj) {
                        if (false == $this->collAdministrativeActDocuments->contains($obj)) {
                          $this->collAdministrativeActDocuments->append($obj);
                        }
                      }

                      $this->collAdministrativeActDocumentsPartial = true;
                    }

                    return $collAdministrativeActDocuments;
                }

                if($partial && $this->collAdministrativeActDocuments) {
                    foreach($this->collAdministrativeActDocuments as $obj) {
                        if($obj->isNew()) {
                            $collAdministrativeActDocuments[] = $obj;
                        }
                    }
                }

                $this->collAdministrativeActDocuments = $collAdministrativeActDocuments;
                $this->collAdministrativeActDocumentsPartial = false;
            }
        }

        return $this->collAdministrativeActDocuments;
    }

    /**
     * Sets a collection of AdministrativeActDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $administrativeActDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setAdministrativeActDocuments(PropelCollection $administrativeActDocuments, PropelPDO $con = null)
    {
        $this->administrativeActDocumentsScheduledForDeletion = $this->getAdministrativeActDocuments(new Criteria(), $con)->diff($administrativeActDocuments);

        foreach ($this->administrativeActDocumentsScheduledForDeletion as $administrativeActDocumentRemoved) {
            $administrativeActDocumentRemoved->setDocument(null);
        }

        $this->collAdministrativeActDocuments = null;
        foreach ($administrativeActDocuments as $administrativeActDocument) {
            $this->addAdministrativeActDocument($administrativeActDocument);
        }

        $this->collAdministrativeActDocuments = $administrativeActDocuments;
        $this->collAdministrativeActDocumentsPartial = false;
    }

    /**
     * Returns the number of related AdministrativeActDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related AdministrativeActDocument objects.
     * @throws PropelException
     */
    public function countAdministrativeActDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collAdministrativeActDocumentsPartial && !$this->isNew();
        if (null === $this->collAdministrativeActDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collAdministrativeActDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getAdministrativeActDocuments());
                }
                $query = AdministrativeActDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collAdministrativeActDocuments);
        }
    }

    /**
     * Method called to associate a AdministrativeActDocument object to this object
     * through the AdministrativeActDocument foreign key attribute.
     *
     * @param    AdministrativeActDocument $l AdministrativeActDocument
     * @return Document The current object (for fluent API support)
     */
    public function addAdministrativeActDocument(AdministrativeActDocument $l)
    {
        if ($this->collAdministrativeActDocuments === null) {
            $this->initAdministrativeActDocuments();
            $this->collAdministrativeActDocumentsPartial = true;
        }
        if (!$this->collAdministrativeActDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddAdministrativeActDocument($l);
        }

        return $this;
    }

    /**
     * @param	AdministrativeActDocument $administrativeActDocument The administrativeActDocument object to add.
     */
    protected function doAddAdministrativeActDocument($administrativeActDocument)
    {
        $this->collAdministrativeActDocuments[]= $administrativeActDocument;
        $administrativeActDocument->setDocument($this);
    }

    /**
     * @param	AdministrativeActDocument $administrativeActDocument The administrativeActDocument object to remove.
     */
    public function removeAdministrativeActDocument($administrativeActDocument)
    {
        if ($this->getAdministrativeActDocuments()->contains($administrativeActDocument)) {
            $this->collAdministrativeActDocuments->remove($this->collAdministrativeActDocuments->search($administrativeActDocument));
            if (null === $this->administrativeActDocumentsScheduledForDeletion) {
                $this->administrativeActDocumentsScheduledForDeletion = clone $this->collAdministrativeActDocuments;
                $this->administrativeActDocumentsScheduledForDeletion->clear();
            }
            $this->administrativeActDocumentsScheduledForDeletion[]= $administrativeActDocument;
            $administrativeActDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related AdministrativeActDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|AdministrativeActDocument[] List of AdministrativeActDocument objects
     */
    public function getAdministrativeActDocumentsJoinAdministrativeAct($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = AdministrativeActDocumentQuery::create(null, $criteria);
        $query->joinWith('AdministrativeAct', $join_behavior);

        return $this->getAdministrativeActDocuments($query, $con);
    }

    /**
     * Clears out the collMissionDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMissionDocuments()
     */
    public function clearMissionDocuments()
    {
        $this->collMissionDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collMissionDocumentsPartial = null;
    }

    /**
     * reset is the collMissionDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialMissionDocuments($v = true)
    {
        $this->collMissionDocumentsPartial = $v;
    }

    /**
     * Initializes the collMissionDocuments collection.
     *
     * By default this just sets the collMissionDocuments collection to an empty array (like clearcollMissionDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMissionDocuments($overrideExisting = true)
    {
        if (null !== $this->collMissionDocuments && !$overrideExisting) {
            return;
        }
        $this->collMissionDocuments = new PropelObjectCollection();
        $this->collMissionDocuments->setModel('MissionDocument');
    }

    /**
     * Gets an array of MissionDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|MissionDocument[] List of MissionDocument objects
     * @throws PropelException
     */
    public function getMissionDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collMissionDocumentsPartial && !$this->isNew();
        if (null === $this->collMissionDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collMissionDocuments) {
                // return empty collection
                $this->initMissionDocuments();
            } else {
                $collMissionDocuments = MissionDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collMissionDocumentsPartial && count($collMissionDocuments)) {
                      $this->initMissionDocuments(false);

                      foreach($collMissionDocuments as $obj) {
                        if (false == $this->collMissionDocuments->contains($obj)) {
                          $this->collMissionDocuments->append($obj);
                        }
                      }

                      $this->collMissionDocumentsPartial = true;
                    }

                    return $collMissionDocuments;
                }

                if($partial && $this->collMissionDocuments) {
                    foreach($this->collMissionDocuments as $obj) {
                        if($obj->isNew()) {
                            $collMissionDocuments[] = $obj;
                        }
                    }
                }

                $this->collMissionDocuments = $collMissionDocuments;
                $this->collMissionDocumentsPartial = false;
            }
        }

        return $this->collMissionDocuments;
    }

    /**
     * Sets a collection of MissionDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $missionDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMissionDocuments(PropelCollection $missionDocuments, PropelPDO $con = null)
    {
        $this->missionDocumentsScheduledForDeletion = $this->getMissionDocuments(new Criteria(), $con)->diff($missionDocuments);

        foreach ($this->missionDocumentsScheduledForDeletion as $missionDocumentRemoved) {
            $missionDocumentRemoved->setDocument(null);
        }

        $this->collMissionDocuments = null;
        foreach ($missionDocuments as $missionDocument) {
            $this->addMissionDocument($missionDocument);
        }

        $this->collMissionDocuments = $missionDocuments;
        $this->collMissionDocumentsPartial = false;
    }

    /**
     * Returns the number of related MissionDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related MissionDocument objects.
     * @throws PropelException
     */
    public function countMissionDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collMissionDocumentsPartial && !$this->isNew();
        if (null === $this->collMissionDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMissionDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getMissionDocuments());
                }
                $query = MissionDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collMissionDocuments);
        }
    }

    /**
     * Method called to associate a MissionDocument object to this object
     * through the MissionDocument foreign key attribute.
     *
     * @param    MissionDocument $l MissionDocument
     * @return Document The current object (for fluent API support)
     */
    public function addMissionDocument(MissionDocument $l)
    {
        if ($this->collMissionDocuments === null) {
            $this->initMissionDocuments();
            $this->collMissionDocumentsPartial = true;
        }
        if (!$this->collMissionDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddMissionDocument($l);
        }

        return $this;
    }

    /**
     * @param	MissionDocument $missionDocument The missionDocument object to add.
     */
    protected function doAddMissionDocument($missionDocument)
    {
        $this->collMissionDocuments[]= $missionDocument;
        $missionDocument->setDocument($this);
    }

    /**
     * @param	MissionDocument $missionDocument The missionDocument object to remove.
     */
    public function removeMissionDocument($missionDocument)
    {
        if ($this->getMissionDocuments()->contains($missionDocument)) {
            $this->collMissionDocuments->remove($this->collMissionDocuments->search($missionDocument));
            if (null === $this->missionDocumentsScheduledForDeletion) {
                $this->missionDocumentsScheduledForDeletion = clone $this->collMissionDocuments;
                $this->missionDocumentsScheduledForDeletion->clear();
            }
            $this->missionDocumentsScheduledForDeletion[]= $missionDocument;
            $missionDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related MissionDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|MissionDocument[] List of MissionDocument objects
     */
    public function getMissionDocumentsJoinMission($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = MissionDocumentQuery::create(null, $criteria);
        $query->joinWith('Mission', $join_behavior);

        return $this->getMissionDocuments($query, $con);
    }

    /**
     * Clears out the collReportSectionDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addReportSectionDocuments()
     */
    public function clearReportSectionDocuments()
    {
        $this->collReportSectionDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collReportSectionDocumentsPartial = null;
    }

    /**
     * reset is the collReportSectionDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialReportSectionDocuments($v = true)
    {
        $this->collReportSectionDocumentsPartial = $v;
    }

    /**
     * Initializes the collReportSectionDocuments collection.
     *
     * By default this just sets the collReportSectionDocuments collection to an empty array (like clearcollReportSectionDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initReportSectionDocuments($overrideExisting = true)
    {
        if (null !== $this->collReportSectionDocuments && !$overrideExisting) {
            return;
        }
        $this->collReportSectionDocuments = new PropelObjectCollection();
        $this->collReportSectionDocuments->setModel('ReportSectionDocument');
    }

    /**
     * Gets an array of ReportSectionDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ReportSectionDocument[] List of ReportSectionDocument objects
     * @throws PropelException
     */
    public function getReportSectionDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collReportSectionDocumentsPartial && !$this->isNew();
        if (null === $this->collReportSectionDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collReportSectionDocuments) {
                // return empty collection
                $this->initReportSectionDocuments();
            } else {
                $collReportSectionDocuments = ReportSectionDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collReportSectionDocumentsPartial && count($collReportSectionDocuments)) {
                      $this->initReportSectionDocuments(false);

                      foreach($collReportSectionDocuments as $obj) {
                        if (false == $this->collReportSectionDocuments->contains($obj)) {
                          $this->collReportSectionDocuments->append($obj);
                        }
                      }

                      $this->collReportSectionDocumentsPartial = true;
                    }

                    return $collReportSectionDocuments;
                }

                if($partial && $this->collReportSectionDocuments) {
                    foreach($this->collReportSectionDocuments as $obj) {
                        if($obj->isNew()) {
                            $collReportSectionDocuments[] = $obj;
                        }
                    }
                }

                $this->collReportSectionDocuments = $collReportSectionDocuments;
                $this->collReportSectionDocumentsPartial = false;
            }
        }

        return $this->collReportSectionDocuments;
    }

    /**
     * Sets a collection of ReportSectionDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $reportSectionDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setReportSectionDocuments(PropelCollection $reportSectionDocuments, PropelPDO $con = null)
    {
        $this->reportSectionDocumentsScheduledForDeletion = $this->getReportSectionDocuments(new Criteria(), $con)->diff($reportSectionDocuments);

        foreach ($this->reportSectionDocumentsScheduledForDeletion as $reportSectionDocumentRemoved) {
            $reportSectionDocumentRemoved->setDocument(null);
        }

        $this->collReportSectionDocuments = null;
        foreach ($reportSectionDocuments as $reportSectionDocument) {
            $this->addReportSectionDocument($reportSectionDocument);
        }

        $this->collReportSectionDocuments = $reportSectionDocuments;
        $this->collReportSectionDocumentsPartial = false;
    }

    /**
     * Returns the number of related ReportSectionDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ReportSectionDocument objects.
     * @throws PropelException
     */
    public function countReportSectionDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collReportSectionDocumentsPartial && !$this->isNew();
        if (null === $this->collReportSectionDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collReportSectionDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getReportSectionDocuments());
                }
                $query = ReportSectionDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collReportSectionDocuments);
        }
    }

    /**
     * Method called to associate a ReportSectionDocument object to this object
     * through the ReportSectionDocument foreign key attribute.
     *
     * @param    ReportSectionDocument $l ReportSectionDocument
     * @return Document The current object (for fluent API support)
     */
    public function addReportSectionDocument(ReportSectionDocument $l)
    {
        if ($this->collReportSectionDocuments === null) {
            $this->initReportSectionDocuments();
            $this->collReportSectionDocumentsPartial = true;
        }
        if (!$this->collReportSectionDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddReportSectionDocument($l);
        }

        return $this;
    }

    /**
     * @param	ReportSectionDocument $reportSectionDocument The reportSectionDocument object to add.
     */
    protected function doAddReportSectionDocument($reportSectionDocument)
    {
        $this->collReportSectionDocuments[]= $reportSectionDocument;
        $reportSectionDocument->setDocument($this);
    }

    /**
     * @param	ReportSectionDocument $reportSectionDocument The reportSectionDocument object to remove.
     */
    public function removeReportSectionDocument($reportSectionDocument)
    {
        if ($this->getReportSectionDocuments()->contains($reportSectionDocument)) {
            $this->collReportSectionDocuments->remove($this->collReportSectionDocuments->search($reportSectionDocument));
            if (null === $this->reportSectionDocumentsScheduledForDeletion) {
                $this->reportSectionDocumentsScheduledForDeletion = clone $this->collReportSectionDocuments;
                $this->reportSectionDocumentsScheduledForDeletion->clear();
            }
            $this->reportSectionDocumentsScheduledForDeletion[]= $reportSectionDocument;
            $reportSectionDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related ReportSectionDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ReportSectionDocument[] List of ReportSectionDocument objects
     */
    public function getReportSectionDocumentsJoinReportSection($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ReportSectionDocumentQuery::create(null, $criteria);
        $query->joinWith('ReportSection', $join_behavior);

        return $this->getReportSectionDocuments($query, $con);
    }

    /**
     * Clears out the collPositionDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPositionDocuments()
     */
    public function clearPositionDocuments()
    {
        $this->collPositionDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collPositionDocumentsPartial = null;
    }

    /**
     * reset is the collPositionDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialPositionDocuments($v = true)
    {
        $this->collPositionDocumentsPartial = $v;
    }

    /**
     * Initializes the collPositionDocuments collection.
     *
     * By default this just sets the collPositionDocuments collection to an empty array (like clearcollPositionDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPositionDocuments($overrideExisting = true)
    {
        if (null !== $this->collPositionDocuments && !$overrideExisting) {
            return;
        }
        $this->collPositionDocuments = new PropelObjectCollection();
        $this->collPositionDocuments->setModel('PositionDocument');
    }

    /**
     * Gets an array of PositionDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|PositionDocument[] List of PositionDocument objects
     * @throws PropelException
     */
    public function getPositionDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collPositionDocumentsPartial && !$this->isNew();
        if (null === $this->collPositionDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPositionDocuments) {
                // return empty collection
                $this->initPositionDocuments();
            } else {
                $collPositionDocuments = PositionDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collPositionDocumentsPartial && count($collPositionDocuments)) {
                      $this->initPositionDocuments(false);

                      foreach($collPositionDocuments as $obj) {
                        if (false == $this->collPositionDocuments->contains($obj)) {
                          $this->collPositionDocuments->append($obj);
                        }
                      }

                      $this->collPositionDocumentsPartial = true;
                    }

                    return $collPositionDocuments;
                }

                if($partial && $this->collPositionDocuments) {
                    foreach($this->collPositionDocuments as $obj) {
                        if($obj->isNew()) {
                            $collPositionDocuments[] = $obj;
                        }
                    }
                }

                $this->collPositionDocuments = $collPositionDocuments;
                $this->collPositionDocumentsPartial = false;
            }
        }

        return $this->collPositionDocuments;
    }

    /**
     * Sets a collection of PositionDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $positionDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPositionDocuments(PropelCollection $positionDocuments, PropelPDO $con = null)
    {
        $this->positionDocumentsScheduledForDeletion = $this->getPositionDocuments(new Criteria(), $con)->diff($positionDocuments);

        foreach ($this->positionDocumentsScheduledForDeletion as $positionDocumentRemoved) {
            $positionDocumentRemoved->setDocument(null);
        }

        $this->collPositionDocuments = null;
        foreach ($positionDocuments as $positionDocument) {
            $this->addPositionDocument($positionDocument);
        }

        $this->collPositionDocuments = $positionDocuments;
        $this->collPositionDocumentsPartial = false;
    }

    /**
     * Returns the number of related PositionDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related PositionDocument objects.
     * @throws PropelException
     */
    public function countPositionDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collPositionDocumentsPartial && !$this->isNew();
        if (null === $this->collPositionDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPositionDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getPositionDocuments());
                }
                $query = PositionDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collPositionDocuments);
        }
    }

    /**
     * Method called to associate a PositionDocument object to this object
     * through the PositionDocument foreign key attribute.
     *
     * @param    PositionDocument $l PositionDocument
     * @return Document The current object (for fluent API support)
     */
    public function addPositionDocument(PositionDocument $l)
    {
        if ($this->collPositionDocuments === null) {
            $this->initPositionDocuments();
            $this->collPositionDocumentsPartial = true;
        }
        if (!$this->collPositionDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddPositionDocument($l);
        }

        return $this;
    }

    /**
     * @param	PositionDocument $positionDocument The positionDocument object to add.
     */
    protected function doAddPositionDocument($positionDocument)
    {
        $this->collPositionDocuments[]= $positionDocument;
        $positionDocument->setDocument($this);
    }

    /**
     * @param	PositionDocument $positionDocument The positionDocument object to remove.
     */
    public function removePositionDocument($positionDocument)
    {
        if ($this->getPositionDocuments()->contains($positionDocument)) {
            $this->collPositionDocuments->remove($this->collPositionDocuments->search($positionDocument));
            if (null === $this->positionDocumentsScheduledForDeletion) {
                $this->positionDocumentsScheduledForDeletion = clone $this->collPositionDocuments;
                $this->positionDocumentsScheduledForDeletion->clear();
            }
            $this->positionDocumentsScheduledForDeletion[]= $positionDocument;
            $positionDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related PositionDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|PositionDocument[] List of PositionDocument objects
     */
    public function getPositionDocumentsJoinPosition($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = PositionDocumentQuery::create(null, $criteria);
        $query->joinWith('Position', $join_behavior);

        return $this->getPositionDocuments($query, $con);
    }

    /**
     * Clears out the collProjectDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectDocuments()
     */
    public function clearProjectDocuments()
    {
        $this->collProjectDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collProjectDocumentsPartial = null;
    }

    /**
     * reset is the collProjectDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectDocuments($v = true)
    {
        $this->collProjectDocumentsPartial = $v;
    }

    /**
     * Initializes the collProjectDocuments collection.
     *
     * By default this just sets the collProjectDocuments collection to an empty array (like clearcollProjectDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectDocuments($overrideExisting = true)
    {
        if (null !== $this->collProjectDocuments && !$overrideExisting) {
            return;
        }
        $this->collProjectDocuments = new PropelObjectCollection();
        $this->collProjectDocuments->setModel('ProjectDocument');
    }

    /**
     * Gets an array of ProjectDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectDocument[] List of ProjectDocument objects
     * @throws PropelException
     */
    public function getProjectDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectDocumentsPartial && !$this->isNew();
        if (null === $this->collProjectDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectDocuments) {
                // return empty collection
                $this->initProjectDocuments();
            } else {
                $collProjectDocuments = ProjectDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectDocumentsPartial && count($collProjectDocuments)) {
                      $this->initProjectDocuments(false);

                      foreach($collProjectDocuments as $obj) {
                        if (false == $this->collProjectDocuments->contains($obj)) {
                          $this->collProjectDocuments->append($obj);
                        }
                      }

                      $this->collProjectDocumentsPartial = true;
                    }

                    return $collProjectDocuments;
                }

                if($partial && $this->collProjectDocuments) {
                    foreach($this->collProjectDocuments as $obj) {
                        if($obj->isNew()) {
                            $collProjectDocuments[] = $obj;
                        }
                    }
                }

                $this->collProjectDocuments = $collProjectDocuments;
                $this->collProjectDocumentsPartial = false;
            }
        }

        return $this->collProjectDocuments;
    }

    /**
     * Sets a collection of ProjectDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectDocuments(PropelCollection $projectDocuments, PropelPDO $con = null)
    {
        $this->projectDocumentsScheduledForDeletion = $this->getProjectDocuments(new Criteria(), $con)->diff($projectDocuments);

        foreach ($this->projectDocumentsScheduledForDeletion as $projectDocumentRemoved) {
            $projectDocumentRemoved->setDocument(null);
        }

        $this->collProjectDocuments = null;
        foreach ($projectDocuments as $projectDocument) {
            $this->addProjectDocument($projectDocument);
        }

        $this->collProjectDocuments = $projectDocuments;
        $this->collProjectDocumentsPartial = false;
    }

    /**
     * Returns the number of related ProjectDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectDocument objects.
     * @throws PropelException
     */
    public function countProjectDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectDocumentsPartial && !$this->isNew();
        if (null === $this->collProjectDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectDocuments());
                }
                $query = ProjectDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectDocuments);
        }
    }

    /**
     * Method called to associate a ProjectDocument object to this object
     * through the ProjectDocument foreign key attribute.
     *
     * @param    ProjectDocument $l ProjectDocument
     * @return Document The current object (for fluent API support)
     */
    public function addProjectDocument(ProjectDocument $l)
    {
        if ($this->collProjectDocuments === null) {
            $this->initProjectDocuments();
            $this->collProjectDocumentsPartial = true;
        }
        if (!$this->collProjectDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectDocument($l);
        }

        return $this;
    }

    /**
     * @param	ProjectDocument $projectDocument The projectDocument object to add.
     */
    protected function doAddProjectDocument($projectDocument)
    {
        $this->collProjectDocuments[]= $projectDocument;
        $projectDocument->setDocument($this);
    }

    /**
     * @param	ProjectDocument $projectDocument The projectDocument object to remove.
     */
    public function removeProjectDocument($projectDocument)
    {
        if ($this->getProjectDocuments()->contains($projectDocument)) {
            $this->collProjectDocuments->remove($this->collProjectDocuments->search($projectDocument));
            if (null === $this->projectDocumentsScheduledForDeletion) {
                $this->projectDocumentsScheduledForDeletion = clone $this->collProjectDocuments;
                $this->projectDocumentsScheduledForDeletion->clear();
            }
            $this->projectDocumentsScheduledForDeletion[]= $projectDocument;
            $projectDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related ProjectDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectDocument[] List of ProjectDocument objects
     */
    public function getProjectDocumentsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectDocumentQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectDocuments($query, $con);
    }

    /**
     * Clears out the collActivityDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addActivityDocuments()
     */
    public function clearActivityDocuments()
    {
        $this->collActivityDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collActivityDocumentsPartial = null;
    }

    /**
     * reset is the collActivityDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialActivityDocuments($v = true)
    {
        $this->collActivityDocumentsPartial = $v;
    }

    /**
     * Initializes the collActivityDocuments collection.
     *
     * By default this just sets the collActivityDocuments collection to an empty array (like clearcollActivityDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initActivityDocuments($overrideExisting = true)
    {
        if (null !== $this->collActivityDocuments && !$overrideExisting) {
            return;
        }
        $this->collActivityDocuments = new PropelObjectCollection();
        $this->collActivityDocuments->setModel('ActivityDocument');
    }

    /**
     * Gets an array of ActivityDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ActivityDocument[] List of ActivityDocument objects
     * @throws PropelException
     */
    public function getActivityDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collActivityDocumentsPartial && !$this->isNew();
        if (null === $this->collActivityDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collActivityDocuments) {
                // return empty collection
                $this->initActivityDocuments();
            } else {
                $collActivityDocuments = ActivityDocumentQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collActivityDocumentsPartial && count($collActivityDocuments)) {
                      $this->initActivityDocuments(false);

                      foreach($collActivityDocuments as $obj) {
                        if (false == $this->collActivityDocuments->contains($obj)) {
                          $this->collActivityDocuments->append($obj);
                        }
                      }

                      $this->collActivityDocumentsPartial = true;
                    }

                    return $collActivityDocuments;
                }

                if($partial && $this->collActivityDocuments) {
                    foreach($this->collActivityDocuments as $obj) {
                        if($obj->isNew()) {
                            $collActivityDocuments[] = $obj;
                        }
                    }
                }

                $this->collActivityDocuments = $collActivityDocuments;
                $this->collActivityDocumentsPartial = false;
            }
        }

        return $this->collActivityDocuments;
    }

    /**
     * Sets a collection of ActivityDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $activityDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setActivityDocuments(PropelCollection $activityDocuments, PropelPDO $con = null)
    {
        $this->activityDocumentsScheduledForDeletion = $this->getActivityDocuments(new Criteria(), $con)->diff($activityDocuments);

        foreach ($this->activityDocumentsScheduledForDeletion as $activityDocumentRemoved) {
            $activityDocumentRemoved->setDocument(null);
        }

        $this->collActivityDocuments = null;
        foreach ($activityDocuments as $activityDocument) {
            $this->addActivityDocument($activityDocument);
        }

        $this->collActivityDocuments = $activityDocuments;
        $this->collActivityDocumentsPartial = false;
    }

    /**
     * Returns the number of related ActivityDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ActivityDocument objects.
     * @throws PropelException
     */
    public function countActivityDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collActivityDocumentsPartial && !$this->isNew();
        if (null === $this->collActivityDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collActivityDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getActivityDocuments());
                }
                $query = ActivityDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collActivityDocuments);
        }
    }

    /**
     * Method called to associate a ActivityDocument object to this object
     * through the ActivityDocument foreign key attribute.
     *
     * @param    ActivityDocument $l ActivityDocument
     * @return Document The current object (for fluent API support)
     */
    public function addActivityDocument(ActivityDocument $l)
    {
        if ($this->collActivityDocuments === null) {
            $this->initActivityDocuments();
            $this->collActivityDocumentsPartial = true;
        }
        if (!$this->collActivityDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddActivityDocument($l);
        }

        return $this;
    }

    /**
     * @param	ActivityDocument $activityDocument The activityDocument object to add.
     */
    protected function doAddActivityDocument($activityDocument)
    {
        $this->collActivityDocuments[]= $activityDocument;
        $activityDocument->setDocument($this);
    }

    /**
     * @param	ActivityDocument $activityDocument The activityDocument object to remove.
     */
    public function removeActivityDocument($activityDocument)
    {
        if ($this->getActivityDocuments()->contains($activityDocument)) {
            $this->collActivityDocuments->remove($this->collActivityDocuments->search($activityDocument));
            if (null === $this->activityDocumentsScheduledForDeletion) {
                $this->activityDocumentsScheduledForDeletion = clone $this->collActivityDocuments;
                $this->activityDocumentsScheduledForDeletion->clear();
            }
            $this->activityDocumentsScheduledForDeletion[]= $activityDocument;
            $activityDocument->setDocument(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Document is new, it will return
     * an empty collection; or if this Document has previously
     * been saved, it will retrieve related ActivityDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Document.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ActivityDocument[] List of ActivityDocument objects
     */
    public function getActivityDocumentsJoinProjectActivity($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ActivityDocumentQuery::create(null, $criteria);
        $query->joinWith('ProjectActivity', $join_behavior);

        return $this->getActivityDocuments($query, $con);
    }

    /**
     * Clears out the collCampaigns collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addCampaigns()
     */
    public function clearCampaigns()
    {
        $this->collCampaigns = null; // important to set this to null since that means it is uninitialized
        $this->collCampaignsPartial = null;
    }

    /**
     * Initializes the collCampaigns collection.
     *
     * By default this just sets the collCampaigns collection to an empty collection (like clearCampaigns());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initCampaigns()
    {
        $this->collCampaigns = new PropelObjectCollection();
        $this->collCampaigns->setModel('Campaign');
    }

    /**
     * Gets a collection of Campaign objects related by a many-to-many relationship
     * to the current object by way of the campaigns_campaignDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Campaign[] List of Campaign objects
     */
    public function getCampaigns($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collCampaigns || null !== $criteria) {
            if ($this->isNew() && null === $this->collCampaigns) {
                // return empty collection
                $this->initCampaigns();
            } else {
                $collCampaigns = CampaignQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collCampaigns;
                }
                $this->collCampaigns = $collCampaigns;
            }
        }

        return $this->collCampaigns;
    }

    /**
     * Sets a collection of Campaign objects related by a many-to-many relationship
     * to the current object by way of the campaigns_campaignDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $campaigns A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setCampaigns(PropelCollection $campaigns, PropelPDO $con = null)
    {
        $this->clearCampaigns();
        $currentCampaigns = $this->getCampaigns();

        $this->campaignsScheduledForDeletion = $currentCampaigns->diff($campaigns);

        foreach ($campaigns as $campaign) {
            if (!$currentCampaigns->contains($campaign)) {
                $this->doAddCampaign($campaign);
            }
        }

        $this->collCampaigns = $campaigns;
    }

    /**
     * Gets the number of Campaign objects related by a many-to-many relationship
     * to the current object by way of the campaigns_campaignDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Campaign objects
     */
    public function countCampaigns($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collCampaigns || null !== $criteria) {
            if ($this->isNew() && null === $this->collCampaigns) {
                return 0;
            } else {
                $query = CampaignQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collCampaigns);
        }
    }

    /**
     * Associate a Campaign object to this object
     * through the campaigns_campaignDocument cross reference table.
     *
     * @param  Campaign $campaign The CampaignDocument object to relate
     * @return void
     */
    public function addCampaign(Campaign $campaign)
    {
        if ($this->collCampaigns === null) {
            $this->initCampaigns();
        }
        if (!$this->collCampaigns->contains($campaign)) { // only add it if the **same** object is not already associated
            $this->doAddCampaign($campaign);

            $this->collCampaigns[]= $campaign;
        }
    }

    /**
     * @param	Campaign $campaign The campaign object to add.
     */
    protected function doAddCampaign($campaign)
    {
        $campaignDocument = new CampaignDocument();
        $campaignDocument->setCampaign($campaign);
        $this->addCampaignDocument($campaignDocument);
    }

    /**
     * Remove a Campaign object to this object
     * through the campaigns_campaignDocument cross reference table.
     *
     * @param Campaign $campaign The CampaignDocument object to relate
     * @return void
     */
    public function removeCampaign(Campaign $campaign)
    {
        if ($this->getCampaigns()->contains($campaign)) {
            $this->collCampaigns->remove($this->collCampaigns->search($campaign));
            if (null === $this->campaignsScheduledForDeletion) {
                $this->campaignsScheduledForDeletion = clone $this->collCampaigns;
                $this->campaignsScheduledForDeletion->clear();
            }
            $this->campaignsScheduledForDeletion[]= $campaign;
        }
    }

    /**
     * Clears out the collHeadlines collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHeadlines()
     */
    public function clearHeadlines()
    {
        $this->collHeadlines = null; // important to set this to null since that means it is uninitialized
        $this->collHeadlinesPartial = null;
    }

    /**
     * Initializes the collHeadlines collection.
     *
     * By default this just sets the collHeadlines collection to an empty collection (like clearHeadlines());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initHeadlines()
    {
        $this->collHeadlines = new PropelObjectCollection();
        $this->collHeadlines->setModel('Headline');
    }

    /**
     * Gets a collection of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Headline[] List of Headline objects
     */
    public function getHeadlines($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collHeadlines || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlines) {
                // return empty collection
                $this->initHeadlines();
            } else {
                $collHeadlines = HeadlineQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collHeadlines;
                }
                $this->collHeadlines = $collHeadlines;
            }
        }

        return $this->collHeadlines;
    }

    /**
     * Sets a collection of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $headlines A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setHeadlines(PropelCollection $headlines, PropelPDO $con = null)
    {
        $this->clearHeadlines();
        $currentHeadlines = $this->getHeadlines();

        $this->headlinesScheduledForDeletion = $currentHeadlines->diff($headlines);

        foreach ($headlines as $headline) {
            if (!$currentHeadlines->contains($headline)) {
                $this->doAddHeadline($headline);
            }
        }

        $this->collHeadlines = $headlines;
    }

    /**
     * Gets the number of Headline objects related by a many-to-many relationship
     * to the current object by way of the headlines_headlineDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Headline objects
     */
    public function countHeadlines($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collHeadlines || null !== $criteria) {
            if ($this->isNew() && null === $this->collHeadlines) {
                return 0;
            } else {
                $query = HeadlineQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collHeadlines);
        }
    }

    /**
     * Associate a Headline object to this object
     * through the headlines_headlineDocument cross reference table.
     *
     * @param  Headline $headline The HeadlineDocument object to relate
     * @return void
     */
    public function addHeadline(Headline $headline)
    {
        if ($this->collHeadlines === null) {
            $this->initHeadlines();
        }
        if (!$this->collHeadlines->contains($headline)) { // only add it if the **same** object is not already associated
            $this->doAddHeadline($headline);

            $this->collHeadlines[]= $headline;
        }
    }

    /**
     * @param	Headline $headline The headline object to add.
     */
    protected function doAddHeadline($headline)
    {
        $headlineDocument = new HeadlineDocument();
        $headlineDocument->setHeadline($headline);
        $this->addHeadlineDocument($headlineDocument);
    }

    /**
     * Remove a Headline object to this object
     * through the headlines_headlineDocument cross reference table.
     *
     * @param Headline $headline The HeadlineDocument object to relate
     * @return void
     */
    public function removeHeadline(Headline $headline)
    {
        if ($this->getHeadlines()->contains($headline)) {
            $this->collHeadlines->remove($this->collHeadlines->search($headline));
            if (null === $this->headlinesScheduledForDeletion) {
                $this->headlinesScheduledForDeletion = clone $this->collHeadlines;
                $this->headlinesScheduledForDeletion->clear();
            }
            $this->headlinesScheduledForDeletion[]= $headline;
        }
    }

    /**
     * Clears out the collGuarantees collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addGuarantees()
     */
    public function clearGuarantees()
    {
        $this->collGuarantees = null; // important to set this to null since that means it is uninitialized
        $this->collGuaranteesPartial = null;
    }

    /**
     * Initializes the collGuarantees collection.
     *
     * By default this just sets the collGuarantees collection to an empty collection (like clearGuarantees());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initGuarantees()
    {
        $this->collGuarantees = new PropelObjectCollection();
        $this->collGuarantees->setModel('Guarantee');
    }

    /**
     * Gets a collection of Guarantee objects related by a many-to-many relationship
     * to the current object by way of the panel_guaranteeDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Guarantee[] List of Guarantee objects
     */
    public function getGuarantees($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collGuarantees || null !== $criteria) {
            if ($this->isNew() && null === $this->collGuarantees) {
                // return empty collection
                $this->initGuarantees();
            } else {
                $collGuarantees = GuaranteeQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collGuarantees;
                }
                $this->collGuarantees = $collGuarantees;
            }
        }

        return $this->collGuarantees;
    }

    /**
     * Sets a collection of Guarantee objects related by a many-to-many relationship
     * to the current object by way of the panel_guaranteeDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $guarantees A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setGuarantees(PropelCollection $guarantees, PropelPDO $con = null)
    {
        $this->clearGuarantees();
        $currentGuarantees = $this->getGuarantees();

        $this->guaranteesScheduledForDeletion = $currentGuarantees->diff($guarantees);

        foreach ($guarantees as $guarantee) {
            if (!$currentGuarantees->contains($guarantee)) {
                $this->doAddGuarantee($guarantee);
            }
        }

        $this->collGuarantees = $guarantees;
    }

    /**
     * Gets the number of Guarantee objects related by a many-to-many relationship
     * to the current object by way of the panel_guaranteeDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Guarantee objects
     */
    public function countGuarantees($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collGuarantees || null !== $criteria) {
            if ($this->isNew() && null === $this->collGuarantees) {
                return 0;
            } else {
                $query = GuaranteeQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collGuarantees);
        }
    }

    /**
     * Associate a Guarantee object to this object
     * through the panel_guaranteeDocument cross reference table.
     *
     * @param  Guarantee $guarantee The GuaranteeDocument object to relate
     * @return void
     */
    public function addGuarantee(Guarantee $guarantee)
    {
        if ($this->collGuarantees === null) {
            $this->initGuarantees();
        }
        if (!$this->collGuarantees->contains($guarantee)) { // only add it if the **same** object is not already associated
            $this->doAddGuarantee($guarantee);

            $this->collGuarantees[]= $guarantee;
        }
    }

    /**
     * @param	Guarantee $guarantee The guarantee object to add.
     */
    protected function doAddGuarantee($guarantee)
    {
        $guaranteeDocument = new GuaranteeDocument();
        $guaranteeDocument->setGuarantee($guarantee);
        $this->addGuaranteeDocument($guaranteeDocument);
    }

    /**
     * Remove a Guarantee object to this object
     * through the panel_guaranteeDocument cross reference table.
     *
     * @param Guarantee $guarantee The GuaranteeDocument object to relate
     * @return void
     */
    public function removeGuarantee(Guarantee $guarantee)
    {
        if ($this->getGuarantees()->contains($guarantee)) {
            $this->collGuarantees->remove($this->collGuarantees->search($guarantee));
            if (null === $this->guaranteesScheduledForDeletion) {
                $this->guaranteesScheduledForDeletion = clone $this->collGuarantees;
                $this->guaranteesScheduledForDeletion->clear();
            }
            $this->guaranteesScheduledForDeletion[]= $guarantee;
        }
    }

    /**
     * Clears out the collAdministrativeActs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addAdministrativeActs()
     */
    public function clearAdministrativeActs()
    {
        $this->collAdministrativeActs = null; // important to set this to null since that means it is uninitialized
        $this->collAdministrativeActsPartial = null;
    }

    /**
     * Initializes the collAdministrativeActs collection.
     *
     * By default this just sets the collAdministrativeActs collection to an empty collection (like clearAdministrativeActs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initAdministrativeActs()
    {
        $this->collAdministrativeActs = new PropelObjectCollection();
        $this->collAdministrativeActs->setModel('AdministrativeAct');
    }

    /**
     * Gets a collection of AdministrativeAct objects related by a many-to-many relationship
     * to the current object by way of the panel_administrativeActDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|AdministrativeAct[] List of AdministrativeAct objects
     */
    public function getAdministrativeActs($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collAdministrativeActs || null !== $criteria) {
            if ($this->isNew() && null === $this->collAdministrativeActs) {
                // return empty collection
                $this->initAdministrativeActs();
            } else {
                $collAdministrativeActs = AdministrativeActQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collAdministrativeActs;
                }
                $this->collAdministrativeActs = $collAdministrativeActs;
            }
        }

        return $this->collAdministrativeActs;
    }

    /**
     * Sets a collection of AdministrativeAct objects related by a many-to-many relationship
     * to the current object by way of the panel_administrativeActDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $administrativeActs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setAdministrativeActs(PropelCollection $administrativeActs, PropelPDO $con = null)
    {
        $this->clearAdministrativeActs();
        $currentAdministrativeActs = $this->getAdministrativeActs();

        $this->administrativeActsScheduledForDeletion = $currentAdministrativeActs->diff($administrativeActs);

        foreach ($administrativeActs as $administrativeAct) {
            if (!$currentAdministrativeActs->contains($administrativeAct)) {
                $this->doAddAdministrativeAct($administrativeAct);
            }
        }

        $this->collAdministrativeActs = $administrativeActs;
    }

    /**
     * Gets the number of AdministrativeAct objects related by a many-to-many relationship
     * to the current object by way of the panel_administrativeActDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related AdministrativeAct objects
     */
    public function countAdministrativeActs($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collAdministrativeActs || null !== $criteria) {
            if ($this->isNew() && null === $this->collAdministrativeActs) {
                return 0;
            } else {
                $query = AdministrativeActQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collAdministrativeActs);
        }
    }

    /**
     * Associate a AdministrativeAct object to this object
     * through the panel_administrativeActDocument cross reference table.
     *
     * @param  AdministrativeAct $administrativeAct The AdministrativeActDocument object to relate
     * @return void
     */
    public function addAdministrativeAct(AdministrativeAct $administrativeAct)
    {
        if ($this->collAdministrativeActs === null) {
            $this->initAdministrativeActs();
        }
        if (!$this->collAdministrativeActs->contains($administrativeAct)) { // only add it if the **same** object is not already associated
            $this->doAddAdministrativeAct($administrativeAct);

            $this->collAdministrativeActs[]= $administrativeAct;
        }
    }

    /**
     * @param	AdministrativeAct $administrativeAct The administrativeAct object to add.
     */
    protected function doAddAdministrativeAct($administrativeAct)
    {
        $administrativeActDocument = new AdministrativeActDocument();
        $administrativeActDocument->setAdministrativeAct($administrativeAct);
        $this->addAdministrativeActDocument($administrativeActDocument);
    }

    /**
     * Remove a AdministrativeAct object to this object
     * through the panel_administrativeActDocument cross reference table.
     *
     * @param AdministrativeAct $administrativeAct The AdministrativeActDocument object to relate
     * @return void
     */
    public function removeAdministrativeAct(AdministrativeAct $administrativeAct)
    {
        if ($this->getAdministrativeActs()->contains($administrativeAct)) {
            $this->collAdministrativeActs->remove($this->collAdministrativeActs->search($administrativeAct));
            if (null === $this->administrativeActsScheduledForDeletion) {
                $this->administrativeActsScheduledForDeletion = clone $this->collAdministrativeActs;
                $this->administrativeActsScheduledForDeletion->clear();
            }
            $this->administrativeActsScheduledForDeletion[]= $administrativeAct;
        }
    }

    /**
     * Clears out the collMissions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addMissions()
     */
    public function clearMissions()
    {
        $this->collMissions = null; // important to set this to null since that means it is uninitialized
        $this->collMissionsPartial = null;
    }

    /**
     * Initializes the collMissions collection.
     *
     * By default this just sets the collMissions collection to an empty collection (like clearMissions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initMissions()
    {
        $this->collMissions = new PropelObjectCollection();
        $this->collMissions->setModel('Mission');
    }

    /**
     * Gets a collection of Mission objects related by a many-to-many relationship
     * to the current object by way of the panel_missionDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Mission[] List of Mission objects
     */
    public function getMissions($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collMissions || null !== $criteria) {
            if ($this->isNew() && null === $this->collMissions) {
                // return empty collection
                $this->initMissions();
            } else {
                $collMissions = MissionQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collMissions;
                }
                $this->collMissions = $collMissions;
            }
        }

        return $this->collMissions;
    }

    /**
     * Sets a collection of Mission objects related by a many-to-many relationship
     * to the current object by way of the panel_missionDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $missions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setMissions(PropelCollection $missions, PropelPDO $con = null)
    {
        $this->clearMissions();
        $currentMissions = $this->getMissions();

        $this->missionsScheduledForDeletion = $currentMissions->diff($missions);

        foreach ($missions as $mission) {
            if (!$currentMissions->contains($mission)) {
                $this->doAddMission($mission);
            }
        }

        $this->collMissions = $missions;
    }

    /**
     * Gets the number of Mission objects related by a many-to-many relationship
     * to the current object by way of the panel_missionDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Mission objects
     */
    public function countMissions($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collMissions || null !== $criteria) {
            if ($this->isNew() && null === $this->collMissions) {
                return 0;
            } else {
                $query = MissionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collMissions);
        }
    }

    /**
     * Associate a Mission object to this object
     * through the panel_missionDocument cross reference table.
     *
     * @param  Mission $mission The MissionDocument object to relate
     * @return void
     */
    public function addMission(Mission $mission)
    {
        if ($this->collMissions === null) {
            $this->initMissions();
        }
        if (!$this->collMissions->contains($mission)) { // only add it if the **same** object is not already associated
            $this->doAddMission($mission);

            $this->collMissions[]= $mission;
        }
    }

    /**
     * @param	Mission $mission The mission object to add.
     */
    protected function doAddMission($mission)
    {
        $missionDocument = new MissionDocument();
        $missionDocument->setMission($mission);
        $this->addMissionDocument($missionDocument);
    }

    /**
     * Remove a Mission object to this object
     * through the panel_missionDocument cross reference table.
     *
     * @param Mission $mission The MissionDocument object to relate
     * @return void
     */
    public function removeMission(Mission $mission)
    {
        if ($this->getMissions()->contains($mission)) {
            $this->collMissions->remove($this->collMissions->search($mission));
            if (null === $this->missionsScheduledForDeletion) {
                $this->missionsScheduledForDeletion = clone $this->collMissions;
                $this->missionsScheduledForDeletion->clear();
            }
            $this->missionsScheduledForDeletion[]= $mission;
        }
    }

    /**
     * Clears out the collReportSections collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addReportSections()
     */
    public function clearReportSections()
    {
        $this->collReportSections = null; // important to set this to null since that means it is uninitialized
        $this->collReportSectionsPartial = null;
    }

    /**
     * Initializes the collReportSections collection.
     *
     * By default this just sets the collReportSections collection to an empty collection (like clearReportSections());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initReportSections()
    {
        $this->collReportSections = new PropelObjectCollection();
        $this->collReportSections->setModel('ReportSection');
    }

    /**
     * Gets a collection of ReportSection objects related by a many-to-many relationship
     * to the current object by way of the panel_reportDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|ReportSection[] List of ReportSection objects
     */
    public function getReportSections($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collReportSections || null !== $criteria) {
            if ($this->isNew() && null === $this->collReportSections) {
                // return empty collection
                $this->initReportSections();
            } else {
                $collReportSections = ReportSectionQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collReportSections;
                }
                $this->collReportSections = $collReportSections;
            }
        }

        return $this->collReportSections;
    }

    /**
     * Sets a collection of ReportSection objects related by a many-to-many relationship
     * to the current object by way of the panel_reportDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $reportSections A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setReportSections(PropelCollection $reportSections, PropelPDO $con = null)
    {
        $this->clearReportSections();
        $currentReportSections = $this->getReportSections();

        $this->reportSectionsScheduledForDeletion = $currentReportSections->diff($reportSections);

        foreach ($reportSections as $reportSection) {
            if (!$currentReportSections->contains($reportSection)) {
                $this->doAddReportSection($reportSection);
            }
        }

        $this->collReportSections = $reportSections;
    }

    /**
     * Gets the number of ReportSection objects related by a many-to-many relationship
     * to the current object by way of the panel_reportDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related ReportSection objects
     */
    public function countReportSections($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collReportSections || null !== $criteria) {
            if ($this->isNew() && null === $this->collReportSections) {
                return 0;
            } else {
                $query = ReportSectionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collReportSections);
        }
    }

    /**
     * Associate a ReportSection object to this object
     * through the panel_reportDocument cross reference table.
     *
     * @param  ReportSection $reportSection The ReportSectionDocument object to relate
     * @return void
     */
    public function addReportSection(ReportSection $reportSection)
    {
        if ($this->collReportSections === null) {
            $this->initReportSections();
        }
        if (!$this->collReportSections->contains($reportSection)) { // only add it if the **same** object is not already associated
            $this->doAddReportSection($reportSection);

            $this->collReportSections[]= $reportSection;
        }
    }

    /**
     * @param	ReportSection $reportSection The reportSection object to add.
     */
    protected function doAddReportSection($reportSection)
    {
        $reportSectionDocument = new ReportSectionDocument();
        $reportSectionDocument->setReportSection($reportSection);
        $this->addReportSectionDocument($reportSectionDocument);
    }

    /**
     * Remove a ReportSection object to this object
     * through the panel_reportDocument cross reference table.
     *
     * @param ReportSection $reportSection The ReportSectionDocument object to relate
     * @return void
     */
    public function removeReportSection(ReportSection $reportSection)
    {
        if ($this->getReportSections()->contains($reportSection)) {
            $this->collReportSections->remove($this->collReportSections->search($reportSection));
            if (null === $this->reportSectionsScheduledForDeletion) {
                $this->reportSectionsScheduledForDeletion = clone $this->collReportSections;
                $this->reportSectionsScheduledForDeletion->clear();
            }
            $this->reportSectionsScheduledForDeletion[]= $reportSection;
        }
    }

    /**
     * Clears out the collPositions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPositions()
     */
    public function clearPositions()
    {
        $this->collPositions = null; // important to set this to null since that means it is uninitialized
        $this->collPositionsPartial = null;
    }

    /**
     * Initializes the collPositions collection.
     *
     * By default this just sets the collPositions collection to an empty collection (like clearPositions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initPositions()
    {
        $this->collPositions = new PropelObjectCollection();
        $this->collPositions->setModel('Position');
    }

    /**
     * Gets a collection of Position objects related by a many-to-many relationship
     * to the current object by way of the positions_document cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Position[] List of Position objects
     */
    public function getPositions($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collPositions || null !== $criteria) {
            if ($this->isNew() && null === $this->collPositions) {
                // return empty collection
                $this->initPositions();
            } else {
                $collPositions = PositionQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collPositions;
                }
                $this->collPositions = $collPositions;
            }
        }

        return $this->collPositions;
    }

    /**
     * Sets a collection of Position objects related by a many-to-many relationship
     * to the current object by way of the positions_document cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $positions A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPositions(PropelCollection $positions, PropelPDO $con = null)
    {
        $this->clearPositions();
        $currentPositions = $this->getPositions();

        $this->positionsScheduledForDeletion = $currentPositions->diff($positions);

        foreach ($positions as $position) {
            if (!$currentPositions->contains($position)) {
                $this->doAddPosition($position);
            }
        }

        $this->collPositions = $positions;
    }

    /**
     * Gets the number of Position objects related by a many-to-many relationship
     * to the current object by way of the positions_document cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Position objects
     */
    public function countPositions($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collPositions || null !== $criteria) {
            if ($this->isNew() && null === $this->collPositions) {
                return 0;
            } else {
                $query = PositionQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collPositions);
        }
    }

    /**
     * Associate a Position object to this object
     * through the positions_document cross reference table.
     *
     * @param  Position $position The PositionDocument object to relate
     * @return void
     */
    public function addPosition(Position $position)
    {
        if ($this->collPositions === null) {
            $this->initPositions();
        }
        if (!$this->collPositions->contains($position)) { // only add it if the **same** object is not already associated
            $this->doAddPosition($position);

            $this->collPositions[]= $position;
        }
    }

    /**
     * @param	Position $position The position object to add.
     */
    protected function doAddPosition($position)
    {
        $positionDocument = new PositionDocument();
        $positionDocument->setPosition($position);
        $this->addPositionDocument($positionDocument);
    }

    /**
     * Remove a Position object to this object
     * through the positions_document cross reference table.
     *
     * @param Position $position The PositionDocument object to relate
     * @return void
     */
    public function removePosition(Position $position)
    {
        if ($this->getPositions()->contains($position)) {
            $this->collPositions->remove($this->collPositions->search($position));
            if (null === $this->positionsScheduledForDeletion) {
                $this->positionsScheduledForDeletion = clone $this->collPositions;
                $this->positionsScheduledForDeletion->clear();
            }
            $this->positionsScheduledForDeletion[]= $position;
        }
    }

    /**
     * Clears out the collProjects collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjects()
     */
    public function clearProjects()
    {
        $this->collProjects = null; // important to set this to null since that means it is uninitialized
        $this->collProjectsPartial = null;
    }

    /**
     * Initializes the collProjects collection.
     *
     * By default this just sets the collProjects collection to an empty collection (like clearProjects());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initProjects()
    {
        $this->collProjects = new PropelObjectCollection();
        $this->collProjects->setModel('Project');
    }

    /**
     * Gets a collection of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_document cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjects($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collProjects || null !== $criteria) {
            if ($this->isNew() && null === $this->collProjects) {
                // return empty collection
                $this->initProjects();
            } else {
                $collProjects = ProjectQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collProjects;
                }
                $this->collProjects = $collProjects;
            }
        }

        return $this->collProjects;
    }

    /**
     * Sets a collection of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_document cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projects A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjects(PropelCollection $projects, PropelPDO $con = null)
    {
        $this->clearProjects();
        $currentProjects = $this->getProjects();

        $this->projectsScheduledForDeletion = $currentProjects->diff($projects);

        foreach ($projects as $project) {
            if (!$currentProjects->contains($project)) {
                $this->doAddProject($project);
            }
        }

        $this->collProjects = $projects;
    }

    /**
     * Gets the number of Project objects related by a many-to-many relationship
     * to the current object by way of the projects_document cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Project objects
     */
    public function countProjects($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collProjects || null !== $criteria) {
            if ($this->isNew() && null === $this->collProjects) {
                return 0;
            } else {
                $query = ProjectQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjects);
        }
    }

    /**
     * Associate a Project object to this object
     * through the projects_document cross reference table.
     *
     * @param  Project $project The ProjectDocument object to relate
     * @return void
     */
    public function addProject(Project $project)
    {
        if ($this->collProjects === null) {
            $this->initProjects();
        }
        if (!$this->collProjects->contains($project)) { // only add it if the **same** object is not already associated
            $this->doAddProject($project);

            $this->collProjects[]= $project;
        }
    }

    /**
     * @param	Project $project The project object to add.
     */
    protected function doAddProject($project)
    {
        $projectDocument = new ProjectDocument();
        $projectDocument->setProject($project);
        $this->addProjectDocument($projectDocument);
    }

    /**
     * Remove a Project object to this object
     * through the projects_document cross reference table.
     *
     * @param Project $project The ProjectDocument object to relate
     * @return void
     */
    public function removeProject(Project $project)
    {
        if ($this->getProjects()->contains($project)) {
            $this->collProjects->remove($this->collProjects->search($project));
            if (null === $this->projectsScheduledForDeletion) {
                $this->projectsScheduledForDeletion = clone $this->collProjects;
                $this->projectsScheduledForDeletion->clear();
            }
            $this->projectsScheduledForDeletion[]= $project;
        }
    }

    /**
     * Clears out the collProjectActivitys collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectActivitys()
     */
    public function clearProjectActivitys()
    {
        $this->collProjectActivitys = null; // important to set this to null since that means it is uninitialized
        $this->collProjectActivitysPartial = null;
    }

    /**
     * Initializes the collProjectActivitys collection.
     *
     * By default this just sets the collProjectActivitys collection to an empty collection (like clearProjectActivitys());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initProjectActivitys()
    {
        $this->collProjectActivitys = new PropelObjectCollection();
        $this->collProjectActivitys->setModel('ProjectActivity');
    }

    /**
     * Gets a collection of ProjectActivity objects related by a many-to-many relationship
     * to the current object by way of the projects_activityDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Document is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     */
    public function getProjectActivitys($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collProjectActivitys || null !== $criteria) {
            if ($this->isNew() && null === $this->collProjectActivitys) {
                // return empty collection
                $this->initProjectActivitys();
            } else {
                $collProjectActivitys = ProjectActivityQuery::create(null, $criteria)
                    ->filterByDocument($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collProjectActivitys;
                }
                $this->collProjectActivitys = $collProjectActivitys;
            }
        }

        return $this->collProjectActivitys;
    }

    /**
     * Sets a collection of ProjectActivity objects related by a many-to-many relationship
     * to the current object by way of the projects_activityDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectActivitys A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectActivitys(PropelCollection $projectActivitys, PropelPDO $con = null)
    {
        $this->clearProjectActivitys();
        $currentProjectActivitys = $this->getProjectActivitys();

        $this->projectActivitysScheduledForDeletion = $currentProjectActivitys->diff($projectActivitys);

        foreach ($projectActivitys as $projectActivity) {
            if (!$currentProjectActivitys->contains($projectActivity)) {
                $this->doAddProjectActivity($projectActivity);
            }
        }

        $this->collProjectActivitys = $projectActivitys;
    }

    /**
     * Gets the number of ProjectActivity objects related by a many-to-many relationship
     * to the current object by way of the projects_activityDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related ProjectActivity objects
     */
    public function countProjectActivitys($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collProjectActivitys || null !== $criteria) {
            if ($this->isNew() && null === $this->collProjectActivitys) {
                return 0;
            } else {
                $query = ProjectActivityQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByDocument($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectActivitys);
        }
    }

    /**
     * Associate a ProjectActivity object to this object
     * through the projects_activityDocument cross reference table.
     *
     * @param  ProjectActivity $projectActivity The ActivityDocument object to relate
     * @return void
     */
    public function addProjectActivity(ProjectActivity $projectActivity)
    {
        if ($this->collProjectActivitys === null) {
            $this->initProjectActivitys();
        }
        if (!$this->collProjectActivitys->contains($projectActivity)) { // only add it if the **same** object is not already associated
            $this->doAddProjectActivity($projectActivity);

            $this->collProjectActivitys[]= $projectActivity;
        }
    }

    /**
     * @param	ProjectActivity $projectActivity The projectActivity object to add.
     */
    protected function doAddProjectActivity($projectActivity)
    {
        $activityDocument = new ActivityDocument();
        $activityDocument->setProjectActivity($projectActivity);
        $this->addActivityDocument($activityDocument);
    }

    /**
     * Remove a ProjectActivity object to this object
     * through the projects_activityDocument cross reference table.
     *
     * @param ProjectActivity $projectActivity The ActivityDocument object to relate
     * @return void
     */
    public function removeProjectActivity(ProjectActivity $projectActivity)
    {
        if ($this->getProjectActivitys()->contains($projectActivity)) {
            $this->collProjectActivitys->remove($this->collProjectActivitys->search($projectActivity));
            if (null === $this->projectActivitysScheduledForDeletion) {
                $this->projectActivitysScheduledForDeletion = clone $this->collProjectActivitys;
                $this->projectActivitysScheduledForDeletion->clear();
            }
            $this->projectActivitysScheduledForDeletion[]= $projectActivity;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->title = null;
        $this->realfilename = null;
        $this->date = null;
        $this->categoryid = null;
        $this->description = null;
        $this->document_date = null;
        $this->password = null;
        $this->author = null;
        $this->keywords = null;
        $this->number = null;
        $this->size = null;
        $this->fulltextcontent = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collCampaignDocuments) {
                foreach ($this->collCampaignDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlineDocuments) {
                foreach ($this->collHeadlineDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collGuaranteeDocuments) {
                foreach ($this->collGuaranteeDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collAdministrativeActDocuments) {
                foreach ($this->collAdministrativeActDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMissionDocuments) {
                foreach ($this->collMissionDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collReportSectionDocuments) {
                foreach ($this->collReportSectionDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPositionDocuments) {
                foreach ($this->collPositionDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectDocuments) {
                foreach ($this->collProjectDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collActivityDocuments) {
                foreach ($this->collActivityDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collCampaigns) {
                foreach ($this->collCampaigns as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHeadlines) {
                foreach ($this->collHeadlines as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collGuarantees) {
                foreach ($this->collGuarantees as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collAdministrativeActs) {
                foreach ($this->collAdministrativeActs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collMissions) {
                foreach ($this->collMissions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collReportSections) {
                foreach ($this->collReportSections as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPositions) {
                foreach ($this->collPositions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjects) {
                foreach ($this->collProjects as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectActivitys) {
                foreach ($this->collProjectActivitys as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collCampaignDocuments instanceof PropelCollection) {
            $this->collCampaignDocuments->clearIterator();
        }
        $this->collCampaignDocuments = null;
        if ($this->collHeadlineDocuments instanceof PropelCollection) {
            $this->collHeadlineDocuments->clearIterator();
        }
        $this->collHeadlineDocuments = null;
        if ($this->collGuaranteeDocuments instanceof PropelCollection) {
            $this->collGuaranteeDocuments->clearIterator();
        }
        $this->collGuaranteeDocuments = null;
        if ($this->collAdministrativeActDocuments instanceof PropelCollection) {
            $this->collAdministrativeActDocuments->clearIterator();
        }
        $this->collAdministrativeActDocuments = null;
        if ($this->collMissionDocuments instanceof PropelCollection) {
            $this->collMissionDocuments->clearIterator();
        }
        $this->collMissionDocuments = null;
        if ($this->collReportSectionDocuments instanceof PropelCollection) {
            $this->collReportSectionDocuments->clearIterator();
        }
        $this->collReportSectionDocuments = null;
        if ($this->collPositionDocuments instanceof PropelCollection) {
            $this->collPositionDocuments->clearIterator();
        }
        $this->collPositionDocuments = null;
        if ($this->collProjectDocuments instanceof PropelCollection) {
            $this->collProjectDocuments->clearIterator();
        }
        $this->collProjectDocuments = null;
        if ($this->collActivityDocuments instanceof PropelCollection) {
            $this->collActivityDocuments->clearIterator();
        }
        $this->collActivityDocuments = null;
        if ($this->collCampaigns instanceof PropelCollection) {
            $this->collCampaigns->clearIterator();
        }
        $this->collCampaigns = null;
        if ($this->collHeadlines instanceof PropelCollection) {
            $this->collHeadlines->clearIterator();
        }
        $this->collHeadlines = null;
        if ($this->collGuarantees instanceof PropelCollection) {
            $this->collGuarantees->clearIterator();
        }
        $this->collGuarantees = null;
        if ($this->collAdministrativeActs instanceof PropelCollection) {
            $this->collAdministrativeActs->clearIterator();
        }
        $this->collAdministrativeActs = null;
        if ($this->collMissions instanceof PropelCollection) {
            $this->collMissions->clearIterator();
        }
        $this->collMissions = null;
        if ($this->collReportSections instanceof PropelCollection) {
            $this->collReportSections->clearIterator();
        }
        $this->collReportSections = null;
        if ($this->collPositions instanceof PropelCollection) {
            $this->collPositions->clearIterator();
        }
        $this->collPositions = null;
        if ($this->collProjects instanceof PropelCollection) {
            $this->collProjects->clearIterator();
        }
        $this->collProjects = null;
        if ($this->collProjectActivitys instanceof PropelCollection) {
            $this->collProjectActivitys->clearIterator();
        }
        $this->collProjectActivitys = null;
        $this->aCategory = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(DocumentPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
