<?php

class CommonFieldHistoryViewAction extends BaseAction {

	const PER_PAGE = 3;

	function exec() {

		if (parent::exec() === false) {
			return false;
		}

		$this->template->template = 'TemplatePlain.tpl';

		if ( empty($_GET['type']) || empty($_GET['id']) || empty($_GET['field']) ) {
			return false;
		}

		$class = $_GET['type'];
		$id = $_GET['id'];
		$column = $_GET['field'];
		$page = empty($_GET['page']) ? 1 : $_GET['page'];

		$queryClass = $class.'LogQuery';
		$filterByObjectId = 'filterBy'.$class.'Id';

		$logs = $queryClass::create()
			->$filterByObjectId($id)
			->withColumn($column, 'wantedLogField')
			->orderByUpdated(Criteria::DESC)
			->groupBy($column)
			->paginate($page, self::PER_PAGE);

		$this->smarty->assign('logs', $logs);
		$this->smarty->assign('type', $class);
		$this->smarty->assign('id', $id);
		$this->smarty->assign('field', $column);

		$className = $class . 'Peer';
		$tableMap = $className::getTableMap();

		$logColumn = $tableMap->getColumn(ucfirst(strtolower($column)));
		$this->smarty->assign('fieldType', $logColumn->getType());

	}
}
