<?php


/**
 * Base class that represents a row from the 'campaigns_campaignCommitment' table.
 *
 * Base de Compromisos de Campaigns
 *
 * @package    propel.generator.campaigns.classes.om
 */
abstract class BaseCampaignCommitment extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'CampaignCommitmentPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        CampaignCommitmentPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the campaignid field.
     * @var        int
     */
    protected $campaignid;

    /**
     * The value for the participantid field.
     * @var        int
     */
    protected $participantid;

    /**
     * The value for the responsible field.
     * @var        string
     */
    protected $responsible;

    /**
     * The value for the commitment field.
     * @var        string
     */
    protected $commitment;

    /**
     * The value for the achieved field.
     * @var        boolean
     */
    protected $achieved;

    /**
     * The value for the date field.
     * @var        string
     */
    protected $date;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        Campaign
     */
    protected $aCampaign;

    /**
     * @var        CampaignParticipant
     */
    protected $aCampaignParticipant;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Get the [id] column value.
     * Identificacion de Compromiso de la Campaign
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [campaignid] column value.
     * Id de la Campaign
     * @return int
     */
    public function getCampaignid()
    {
        return $this->campaignid;
    }

    /**
     * Get the [participantid] column value.
     * Id del participante
     * @return int
     */
    public function getParticipantid()
    {
        return $this->participantid;
    }

    /**
     * Get the [responsible] column value.
     * Responsables
     * @return string
     */
    public function getResponsible()
    {
        return $this->responsible;
    }

    /**
     * Get the [commitment] column value.
     * Descripcion del Compromiso
     * @return string
     */
    public function getCommitment()
    {
        return $this->commitment;
    }

    /**
     * Get the [achieved] column value.
     * Logrado
     * @return boolean
     */
    public function getAchieved()
    {
        return $this->achieved;
    }

    /**
     * Get the [optionally formatted] temporal [date] column value.
     * Fecha del compromiso
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDate($format = '%Y/%m/%d')
    {
        if ($this->date === null) {
            return null;
        }

        if ($this->date === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->date);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->date, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Identificacion de Compromiso de la Campaign
     * @param int $v new value
     * @return CampaignCommitment The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = CampaignCommitmentPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [campaignid] column.
     * Id de la Campaign
     * @param int $v new value
     * @return CampaignCommitment The current object (for fluent API support)
     */
    public function setCampaignid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->campaignid !== $v) {
            $this->campaignid = $v;
            $this->modifiedColumns[] = CampaignCommitmentPeer::CAMPAIGNID;
        }

        if ($this->aCampaign !== null && $this->aCampaign->getId() !== $v) {
            $this->aCampaign = null;
        }


        return $this;
    } // setCampaignid()

    /**
     * Set the value of [participantid] column.
     * Id del participante
     * @param int $v new value
     * @return CampaignCommitment The current object (for fluent API support)
     */
    public function setParticipantid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->participantid !== $v) {
            $this->participantid = $v;
            $this->modifiedColumns[] = CampaignCommitmentPeer::PARTICIPANTID;
        }

        if ($this->aCampaignParticipant !== null && $this->aCampaignParticipant->getId() !== $v) {
            $this->aCampaignParticipant = null;
        }


        return $this;
    } // setParticipantid()

    /**
     * Set the value of [responsible] column.
     * Responsables
     * @param string $v new value
     * @return CampaignCommitment The current object (for fluent API support)
     */
    public function setResponsible($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->responsible !== $v) {
            $this->responsible = $v;
            $this->modifiedColumns[] = CampaignCommitmentPeer::RESPONSIBLE;
        }


        return $this;
    } // setResponsible()

    /**
     * Set the value of [commitment] column.
     * Descripcion del Compromiso
     * @param string $v new value
     * @return CampaignCommitment The current object (for fluent API support)
     */
    public function setCommitment($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->commitment !== $v) {
            $this->commitment = $v;
            $this->modifiedColumns[] = CampaignCommitmentPeer::COMMITMENT;
        }


        return $this;
    } // setCommitment()

    /**
     * Sets the value of the [achieved] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Logrado
     * @param boolean|integer|string $v The new value
     * @return CampaignCommitment The current object (for fluent API support)
     */
    public function setAchieved($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->achieved !== $v) {
            $this->achieved = $v;
            $this->modifiedColumns[] = CampaignCommitmentPeer::ACHIEVED;
        }


        return $this;
    } // setAchieved()

    /**
     * Sets the value of [date] column to a normalized version of the date/time value specified.
     * Fecha del compromiso
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return CampaignCommitment The current object (for fluent API support)
     */
    public function setDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->date !== null || $dt !== null) {
            $currentDateAsString = ($this->date !== null && $tmpDt = new DateTime($this->date)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->date = $newDateAsString;
                $this->modifiedColumns[] = CampaignCommitmentPeer::DATE;
            }
        } // if either are not null


        return $this;
    } // setDate()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return CampaignCommitment The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = CampaignCommitmentPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->campaignid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->participantid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->responsible = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->commitment = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->achieved = ($row[$startcol + 5] !== null) ? (boolean) $row[$startcol + 5] : null;
            $this->date = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->deleted_at = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 8; // 8 = CampaignCommitmentPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating CampaignCommitment object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aCampaign !== null && $this->campaignid !== $this->aCampaign->getId()) {
            $this->aCampaign = null;
        }
        if ($this->aCampaignParticipant !== null && $this->participantid !== $this->aCampaignParticipant->getId()) {
            $this->aCampaignParticipant = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignCommitmentPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = CampaignCommitmentPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aCampaign = null;
            $this->aCampaignParticipant = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignCommitmentPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = CampaignCommitmentQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && CampaignCommitmentQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                CampaignCommitmentPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(CampaignCommitmentPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                CampaignCommitmentPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCampaign !== null) {
                if ($this->aCampaign->isModified() || $this->aCampaign->isNew()) {
                    $affectedRows += $this->aCampaign->save($con);
                }
                $this->setCampaign($this->aCampaign);
            }

            if ($this->aCampaignParticipant !== null) {
                if ($this->aCampaignParticipant->isModified() || $this->aCampaignParticipant->isNew()) {
                    $affectedRows += $this->aCampaignParticipant->save($con);
                }
                $this->setCampaignParticipant($this->aCampaignParticipant);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = CampaignCommitmentPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . CampaignCommitmentPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(CampaignCommitmentPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(CampaignCommitmentPeer::CAMPAIGNID)) {
            $modifiedColumns[':p' . $index++]  = '`CAMPAIGNID`';
        }
        if ($this->isColumnModified(CampaignCommitmentPeer::PARTICIPANTID)) {
            $modifiedColumns[':p' . $index++]  = '`PARTICIPANTID`';
        }
        if ($this->isColumnModified(CampaignCommitmentPeer::RESPONSIBLE)) {
            $modifiedColumns[':p' . $index++]  = '`RESPONSIBLE`';
        }
        if ($this->isColumnModified(CampaignCommitmentPeer::COMMITMENT)) {
            $modifiedColumns[':p' . $index++]  = '`COMMITMENT`';
        }
        if ($this->isColumnModified(CampaignCommitmentPeer::ACHIEVED)) {
            $modifiedColumns[':p' . $index++]  = '`ACHIEVED`';
        }
        if ($this->isColumnModified(CampaignCommitmentPeer::DATE)) {
            $modifiedColumns[':p' . $index++]  = '`DATE`';
        }
        if ($this->isColumnModified(CampaignCommitmentPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `campaigns_campaignCommitment` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`CAMPAIGNID`':
                        $stmt->bindValue($identifier, $this->campaignid, PDO::PARAM_INT);
                        break;
                    case '`PARTICIPANTID`':
                        $stmt->bindValue($identifier, $this->participantid, PDO::PARAM_INT);
                        break;
                    case '`RESPONSIBLE`':
                        $stmt->bindValue($identifier, $this->responsible, PDO::PARAM_STR);
                        break;
                    case '`COMMITMENT`':
                        $stmt->bindValue($identifier, $this->commitment, PDO::PARAM_STR);
                        break;
                    case '`ACHIEVED`':
                        $stmt->bindValue($identifier, (int) $this->achieved, PDO::PARAM_INT);
                        break;
                    case '`DATE`':
                        $stmt->bindValue($identifier, $this->date, PDO::PARAM_STR);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCampaign !== null) {
                if (!$this->aCampaign->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aCampaign->getValidationFailures());
                }
            }

            if ($this->aCampaignParticipant !== null) {
                if (!$this->aCampaignParticipant->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aCampaignParticipant->getValidationFailures());
                }
            }


            if (($retval = CampaignCommitmentPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }



            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = CampaignCommitmentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getCampaignid();
                break;
            case 2:
                return $this->getParticipantid();
                break;
            case 3:
                return $this->getResponsible();
                break;
            case 4:
                return $this->getCommitment();
                break;
            case 5:
                return $this->getAchieved();
                break;
            case 6:
                return $this->getDate();
                break;
            case 7:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['CampaignCommitment'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['CampaignCommitment'][$this->getPrimaryKey()] = true;
        $keys = CampaignCommitmentPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getCampaignid(),
            $keys[2] => $this->getParticipantid(),
            $keys[3] => $this->getResponsible(),
            $keys[4] => $this->getCommitment(),
            $keys[5] => $this->getAchieved(),
            $keys[6] => $this->getDate(),
            $keys[7] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aCampaign) {
                $result['Campaign'] = $this->aCampaign->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aCampaignParticipant) {
                $result['CampaignParticipant'] = $this->aCampaignParticipant->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = CampaignCommitmentPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setCampaignid($value);
                break;
            case 2:
                $this->setParticipantid($value);
                break;
            case 3:
                $this->setResponsible($value);
                break;
            case 4:
                $this->setCommitment($value);
                break;
            case 5:
                $this->setAchieved($value);
                break;
            case 6:
                $this->setDate($value);
                break;
            case 7:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = CampaignCommitmentPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setCampaignid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setParticipantid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setResponsible($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setCommitment($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setAchieved($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setDate($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setDeletedAt($arr[$keys[7]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(CampaignCommitmentPeer::DATABASE_NAME);

        if ($this->isColumnModified(CampaignCommitmentPeer::ID)) $criteria->add(CampaignCommitmentPeer::ID, $this->id);
        if ($this->isColumnModified(CampaignCommitmentPeer::CAMPAIGNID)) $criteria->add(CampaignCommitmentPeer::CAMPAIGNID, $this->campaignid);
        if ($this->isColumnModified(CampaignCommitmentPeer::PARTICIPANTID)) $criteria->add(CampaignCommitmentPeer::PARTICIPANTID, $this->participantid);
        if ($this->isColumnModified(CampaignCommitmentPeer::RESPONSIBLE)) $criteria->add(CampaignCommitmentPeer::RESPONSIBLE, $this->responsible);
        if ($this->isColumnModified(CampaignCommitmentPeer::COMMITMENT)) $criteria->add(CampaignCommitmentPeer::COMMITMENT, $this->commitment);
        if ($this->isColumnModified(CampaignCommitmentPeer::ACHIEVED)) $criteria->add(CampaignCommitmentPeer::ACHIEVED, $this->achieved);
        if ($this->isColumnModified(CampaignCommitmentPeer::DATE)) $criteria->add(CampaignCommitmentPeer::DATE, $this->date);
        if ($this->isColumnModified(CampaignCommitmentPeer::DELETED_AT)) $criteria->add(CampaignCommitmentPeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(CampaignCommitmentPeer::DATABASE_NAME);
        $criteria->add(CampaignCommitmentPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of CampaignCommitment (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setCampaignid($this->getCampaignid());
        $copyObj->setParticipantid($this->getParticipantid());
        $copyObj->setResponsible($this->getResponsible());
        $copyObj->setCommitment($this->getCommitment());
        $copyObj->setAchieved($this->getAchieved());
        $copyObj->setDate($this->getDate());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return CampaignCommitment Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return CampaignCommitmentPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new CampaignCommitmentPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Campaign object.
     *
     * @param             Campaign $v
     * @return CampaignCommitment The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCampaign(Campaign $v = null)
    {
        if ($v === null) {
            $this->setCampaignid(NULL);
        } else {
            $this->setCampaignid($v->getId());
        }

        $this->aCampaign = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Campaign object, it will not be re-added.
        if ($v !== null) {
            $v->addCampaignCommitment($this);
        }


        return $this;
    }


    /**
     * Get the associated Campaign object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Campaign The associated Campaign object.
     * @throws PropelException
     */
    public function getCampaign(PropelPDO $con = null)
    {
        if ($this->aCampaign === null && ($this->campaignid !== null)) {
            $this->aCampaign = CampaignQuery::create()->findPk($this->campaignid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCampaign->addCampaignCommitments($this);
             */
        }

        return $this->aCampaign;
    }

    /**
     * Declares an association between this object and a CampaignParticipant object.
     *
     * @param             CampaignParticipant $v
     * @return CampaignCommitment The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCampaignParticipant(CampaignParticipant $v = null)
    {
        if ($v === null) {
            $this->setParticipantid(NULL);
        } else {
            $this->setParticipantid($v->getId());
        }

        $this->aCampaignParticipant = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the CampaignParticipant object, it will not be re-added.
        if ($v !== null) {
            $v->addCampaignCommitment($this);
        }


        return $this;
    }


    /**
     * Get the associated CampaignParticipant object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return CampaignParticipant The associated CampaignParticipant object.
     * @throws PropelException
     */
    public function getCampaignParticipant(PropelPDO $con = null)
    {
        if ($this->aCampaignParticipant === null && ($this->participantid !== null)) {
            $this->aCampaignParticipant = CampaignParticipantQuery::create()->findPk($this->participantid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCampaignParticipant->addCampaignCommitments($this);
             */
        }

        return $this->aCampaignParticipant;
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->campaignid = null;
        $this->participantid = null;
        $this->responsible = null;
        $this->commitment = null;
        $this->achieved = null;
        $this->date = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aCampaign = null;
        $this->aCampaignParticipant = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(CampaignCommitmentPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = CampaignCommitmentPeer::isSoftDeleteEnabled()) {
            CampaignCommitmentPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            CampaignCommitmentPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
