<?php



/**
 * This class defines the structure of the 'actors_profileForm' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.actors.classes.map
 */
class ProfileFormTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'actors.classes.map.ProfileFormTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('actors_profileForm');
        $this->setPhpName('ProfileForm');
        $this->setClassname('ProfileForm');
        $this->setPackage('actors.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('NAME', 'Name', 'CHAR', false, 90, null);
        $this->addColumn('RELATIONSHIP', 'Relationship', 'BOOLEAN', true, 1, false);
        $this->addColumn('TYPE', 'Type', 'INTEGER', true, 2, null);
        $this->addColumn('QUESTION', 'Question', 'VARCHAR', false, 255, null);
        $this->addColumn('QUESTIONTYPE', 'Questiontype', 'SMALLINT', true, null, null);
        $this->addColumn('LABEL', 'Label', 'VARCHAR', false, 80, null);
        $this->addColumn('INANALYSIS', 'Inanalysis', 'BOOLEAN', false, 1, false);
        $this->addColumn('TREE_LEFT', 'TreeLeft', 'INTEGER', false, null, null);
        $this->addColumn('TREE_RIGHT', 'TreeRight', 'INTEGER', false, null, null);
        $this->addColumn('TREE_LEVEL', 'TreeLevel', 'INTEGER', false, null, null);
        $this->addColumn('SCOPE', 'Scope', 'INTEGER', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('QuestionOption', 'QuestionOption', RelationMap::ONE_TO_MANY, array('id' => 'formId', ), 'CASCADE', null, 'QuestionOptions');
        $this->addRelation('ActorRelation', 'ActorRelation', RelationMap::ONE_TO_MANY, array('id' => 'questionId', ), 'CASCADE', null, 'ActorRelations');
        $this->addRelation('ActorActiveQuestion', 'ActorActiveQuestion', RelationMap::ONE_TO_MANY, array('id' => 'questionId', ), 'CASCADE', null, 'ActorActiveQuestions');
        $this->addRelation('ActorActiveRelationQuestion', 'ActorActiveRelationQuestion', RelationMap::ONE_TO_MANY, array('id' => 'questionId', ), 'CASCADE', null, 'ActorActiveRelationQuestions');
        $this->addRelation('ActorFormAnswer', 'ActorFormAnswer', RelationMap::ONE_TO_MANY, array('id' => 'questionId', ), 'CASCADE', null, 'ActorFormAnswers');
        $this->addRelation('Actor', 'Actor', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'Actors');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'nested_set' => array('left_column' => 'tree_left', 'right_column' => 'tree_right', 'level_column' => 'tree_level', 'use_scope' => 'true', 'scope_column' => 'scope', 'method_proxies' => 'false', ),
        );
    } // getBehaviors()

} // ProfileFormTableMap
