<?php

namespace Egytca\Statements;

class UnaryStatement extends Statement {

	protected $operand;
	protected $operatorMap = [
		'IS NULL' => 'IS NOT NULL',
		'IS NOT NULL' => 'IS NULL'
	];

	function __construct($operator, Statement $operand) {
		parent::__construct($operator, $this->operatorMap);
		$this->operand = $operand;
	}

	function toString() {
		return '(' . $this->operand->toString() . ' ' .$this->getOperator() . ')';
	}

	function invert() {
		$this->invertOperator();
		return $this;
	}
}
