<?php

namespace Egytca\Planning;

use Egytca\HTTPError;


trait YearsFilteredSelectAction {

	protected function fetch(&$entity) {
		$parentFecth = parent::fetch($entity);
		if ($parentFecth === null) return null;

		// Object wasn't found. Try disabling planning years filter
		$id = $_GET['id'];

		$objectOutOfYearsRange = $this->createYearsUnfilteredQuery()->findOneById($id);

		if (is_null($objectOutOfYearsRange)) {
			// object not found
			return $parentFecth;
		} else {
			// object out of years range
			$this->errors->add($this->entityClassName . ' with id "' . $id
				. '" out of year range');
			if ($this->isAjax()) {
				return $this->forwardConfigEnd(
					'success',
					HTTPError::NOT_FOUND
				);
			} else {
				return $this->templateEnd(
					$this->getOutOfYearsRangeErrorTemplate(),
					HTTPError::NOT_FOUND
				);
			}
		}
	}

	protected function getOutOfYearsRangeErrorTemplate() {
		return 'errors/OutOfYearsRange.tpl';
	}

	abstract protected function createYearsUnfilteredQuery();
}
