var FixedGanttChart = function() {

	JSGantt.GanttChart.apply(this, arguments);

	// override
	var parentDraw = this.Draw;
	this.Draw = function() {
		parentDraw.apply(this, arguments);
		this.OverrideName();
		this.OverrideDates();
		this.OrderBars();
	};
};

FixedGanttChart.prototype = JSGantt.GanttChart.prototype;

FixedGanttChart.prototype.GetTaskItem = function(id) {
	var list = this.getList();
	for (var i = 0; i < list.length; i++) {
		if (list[i].getID() == id)
			return list[i];
	}
	return null;
};

FixedGanttChart.prototype.OverrideDates = function() {
	var g = this;
	var activities = $('.gname.glineitem');
	activities.each(function() {

		var idEnd = '2'; // 2: planned dates - 3: real dates

		var taskItemId = this.id.replace(/^gantt-boxchild_([0-9]+)1$/, '$1' + idEnd);
		var taskItem = g.GetTaskItem(taskItemId);

		var startDate = taskItem === null ? '' : JSGantt.formatDateStr(taskItem.getStart(), g.getDateTaskDisplayFormat(), 'es');
		var endDate = taskItem === null ? '' : JSGantt.formatDateStr(taskItem.getEnd(), g.getDateTaskDisplayFormat(), 'es');

		var startDateDiv = $(this).find('.gstartdate div');
		var endDateDiv = $(this).find('.genddate div');
		startDateDiv.html(startDate);
		endDateDiv.html(endDate);
	});
};

FixedGanttChart.prototype.OverrideName = function() {
	var g = this;
	var activities = $('.gname.glineitem');
	activities.each(function() {

		var taskItemId = this.id.replace(/^gantt-boxchild_([0-9]+)$/, '$1');
		var taskItem = g.GetTaskItem(taskItemId);

		if (taskItem.nameDisplayHtml) {
			var nameDiv = $(this).find('.gtaskname div');
			nameDiv.html(taskItem.nameDisplayHtml);
		}
	});
}

FixedGanttChart.prototype.OrderBars = function() {
	$('.gtaskred').each(function() {
		var plannedBarWrapper = $(this).parent();
		var parent = plannedBarWrapper.parent();
		plannedBarWrapper.detach().prependTo(parent);
	});
}

/* **************************************************************************************** */

var AuxTaskItem = JSGantt.TaskItem; // need to reuse variable name
var FixedTaskItem = function() {
	AuxTaskItem.apply(this, arguments);
};

FixedTaskItem.prototype = AuxTaskItem.prototype;

/* **************************************************************************************** */

var oldJSGanttShowToolTip = JSGantt.showToolTip;
JSGantt.showToolTip = function(pGanttChartObj, e, pContents, pWidth, pTimer) {

	var tooltip = $(pContents);
	var taskItemId = tooltip.attr('id').replace(/^gantt-boxtt([0-9]+)$/, '$1');
	var type = taskItemId.charAt(taskItemId.length - 1);
	var taskItem = pGanttChartObj.GetTaskItem(taskItemId);

	if (type == 3) { // real bar

		if (taskItem.customData.Realend === null) {
			var endDateDiv = tooltip.find('.gTIed .gTaskText');
			endDateDiv.html('');
		}
	}

	oldJSGanttShowToolTip.apply(this, arguments);
}
