// the only part making usage of the prototype library is at the bottom

var drawGauge = function(box, percent, options) {

	if (!options)
		options = {};

	options = {
		width: options.width || 150,
		height: options.height || 150,
		radius: options.radius || 75,
		barWidth: options.barWidth || 25,
	};

	var Needle, arc, arcEndRad, arcStartRad, barWidth, chart, chartInset,
		degToRad, el, endPadRad, height, margin, needle, numSections, padRad,
		percToDeg, percToRad, percent, radius, sectionIndx, sectionPerc,
		startPadRad, svg, totalPercent, width, _i;

	percent = percent / 100;
	barWidth = options.barWidth;
	numSections = 10;
	sectionPerc = 1 / numSections / 2;
	padRad = 0.05;
	chartInset = 0;
	totalPercent = .75;

	el = d3.select(box);

	margin = {
		top: options.height * 0.9,
		right: 0,
		bottom: 0,
		left: 0
	};

	width = options.width,
	height = options.height;
	//width = el[0][0].offsetWidth + margin.left;
	//height = el[0][0].offsetWidth + margin.top;
	//radius = Math.min(width, height) / 2;
	radius = options.radius;

	percToDeg = function(perc) {
		return perc * 360;
	};

	percToRad = function(perc) {
		return degToRad(percToDeg(perc));
	};

	degToRad = function(deg) {
		return deg * Math.PI / 180;
	};

	svg = el.append('svg').attr('width', width + margin.left + margin.right).attr('height', height);

	chart = svg.append('g').attr('transform', "translate(" + ((width / 2) + margin.left) + ", " + margin.top + ")");

	for (sectionIndx = _i = 1; 1 <= numSections ? _i <= numSections : _i >= numSections; sectionIndx = 1 <= numSections ? ++_i : --_i) {
		arcStartRad = percToRad(totalPercent);
		arcEndRad = arcStartRad + percToRad(sectionPerc);
		totalPercent += sectionPerc;
		startPadRad = sectionIndx === 0 ? 0 : padRad / 2;
		endPadRad = sectionIndx === numSections ? 0 : padRad / 2;
		arc = d3.svg.arc().outerRadius(radius - chartInset).innerRadius(radius - chartInset - barWidth).startAngle(arcStartRad + startPadRad).endAngle(arcEndRad - endPadRad);
		chart.append('path').attr('class', "arc chart-color" + sectionIndx).attr('d', arc);
	}

	Needle = (function() {

		function Needle(len, radius) {
			this.len = len;
			this.radius = radius;
		}

		Needle.prototype.drawOn = function(el, perc) {
			el.append('circle').attr('class', 'needle-center').attr('cx', 0).attr('cy', 0).attr('r', this.radius);
			return el.append('path').attr('class', 'needle').attr('d', this.mkCmd(perc));
		};

		Needle.prototype.animateOn = function(el, perc) {
			var self;
			self = this;
			return el.transition().delay(500).ease('elastic').duration(4000).selectAll('.needle').tween('progress', function() {
				return function(percentOfPercent) {
					var progress;
					progress = percentOfPercent * perc;
					return d3.select(this).attr('d', self.mkCmd(progress));
				};
			});
		};

		Needle.prototype.mkCmd = function(perc) {
			var centerX, centerY, leftX, leftY, rightX, rightY, thetaRad, topX, topY;
			thetaRad = percToRad(perc / 2);
			centerX = 0;
			centerY = 0;
			topX = centerX - this.len * Math.cos(thetaRad);
			topY = centerY - this.len * Math.sin(thetaRad);
			leftX = centerX - this.radius * Math.cos(thetaRad - Math.PI / 2);
			leftY = centerY - this.radius * Math.sin(thetaRad - Math.PI / 2);
			rightX = centerX - this.radius * Math.cos(thetaRad + Math.PI / 2);
			rightY = centerY - this.radius * Math.sin(thetaRad + Math.PI / 2);
			return "M " + leftX + " " + leftY + " L " + topX + " " + topY + " L " + rightX + " " + rightY;
		};

		return Needle;

	})();

	needleLength = options.width * 0.5;
	needle = new Needle(needleLength, needleLength / 10);

	needle.drawOn(chart, 0);

	needle.animateOn(chart, percent);

};

// this is the only part making usage of the prototype library
Event.observe(window, 'load', function() {

	var size = function(gauge) {

		var coef = gauge.hasClassName('small') ? 0.28 : 1.5;

		var classPrefix = 'gauge-';
		var regexp = new RegExp('(^|\\s)' + classPrefix + '([0-9]+)(\\s|$)');
		var matches = gauge.className.match(regexp);
		if (matches) {
			var percentage = +matches[2];
			coef = coef * percentage / 100;
		}

		return { width: 150 * coef, height: 100 * coef, radius: 75 * coef, barWidth: 25 * coef + (.5 / coef)};
	};

	var gauges = $$('[data-egtc-gauge]');
	for (var i = 0; i < gauges.length; i++) {
		var gauge = gauges[i];
		var perc = gauge.getAttribute("data-egtc-gauge");
		var options = size(gauge);
		drawGauge(gauge, perc, options);
	}
});
