
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- documents_document
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `documents_document`;

CREATE TABLE `documents_document`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id documento',
    `title` VARCHAR(255) COMMENT 'El titulo del archivo',
    `realFilename` VARCHAR(255) COMMENT 'El nombre real del archivo',
    `date` DATE COMMENT 'Fecha',
    `categoryId` INTEGER COMMENT 'Numero de tipo de archivo',
    `description` VARCHAR(255) COMMENT 'Descripcion del archivo',
    `document_date` DATE COMMENT 'Fecha del documento',
    `password` VARCHAR(32) COMMENT 'Clave del archivo',
    `author` VARCHAR(255) COMMENT 'Autor(es)',
    `keyWords` VARCHAR(255) COMMENT 'Palabras clave',
    `number` VARCHAR(10) COMMENT 'Numero de Publicacion',
    `size` INTEGER COMMENT 'Tamano de archivo',
    `fullTextContent` TEXT COMMENT 'Contenido del archivo',
    PRIMARY KEY (`id`),
    INDEX `documents_document_FI_1` (`categoryId`),
    CONSTRAINT `documents_document_FK_1`
        FOREIGN KEY (`categoryId`)
        REFERENCES `categories_category` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM COMMENT='Documentos del sistema';

-- ---------------------------------------------------------------------
-- documents_keyWord
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `documents_keyWord`;

CREATE TABLE `documents_keyWord`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Id palabra clave',
    `keyWord` VARCHAR(255) COMMENT 'Palabra clave',
    PRIMARY KEY (`id`)
) ENGINE=MyISAM COMMENT='Palabras clave de documentos';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
