
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- actors_actor
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_actor`;

CREATE TABLE `actors_actor`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion del actor',
    `title` CHAR(15) COMMENT 'Titulo',
    `name` CHAR(90) COMMENT 'Nombre',
    `surname` CHAR(90) COMMENT 'Apellido',
    `institution` CHAR(200) COMMENT 'Institucion',
    `mailAddress` VARCHAR(90) COMMENT 'Direccion electronica',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Actores';

-- ---------------------------------------------------------------------
-- actors_category
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_category`;

CREATE TABLE `actors_category`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Category Id',
    `name` VARCHAR(100) NOT NULL COMMENT 'Category Name',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    `scope` INTEGER,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Categorias de Actores';

-- ---------------------------------------------------------------------
-- actors_actorsCategory
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_actorsCategory`;

CREATE TABLE `actors_actorsCategory`
(
    `actorId` INTEGER(5) NOT NULL COMMENT 'Actor Id',
    `categoryId` INTEGER(5) NOT NULL COMMENT 'Category Id',
    PRIMARY KEY (`actorId`,`categoryId`),
    INDEX `actors_actorsCategory_FI_2` (`categoryId`),
    CONSTRAINT `actors_actorsCategory_FK_1`
        FOREIGN KEY (`actorId`)
        REFERENCES `actors_actor` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `actors_actorsCategory_FK_2`
        FOREIGN KEY (`categoryId`)
        REFERENCES `actors_category` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Relacion Actores y Categorias';

-- ---------------------------------------------------------------------
-- actors_profileForm
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_profileForm`;

CREATE TABLE `actors_profileForm`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion del formulario de perfil',
    `name` CHAR(90) COMMENT 'Nombre',
    `relationship` BOOL DEFAULT 0 NOT NULL COMMENT 'Is this form a relationship form?',
    `type` INTEGER(2) NOT NULL COMMENT 'Tipo de elemento ',
    `question` VARCHAR(255) COMMENT 'Texto de la pregunta',
    `questionType` SMALLINT NOT NULL COMMENT 'Tipo de pregunta',
    `label` VARCHAR(80) COMMENT 'Label de la pregunta',
    `inAnalysis` BOOL DEFAULT 0 COMMENT 'Aparece la pregunta en analysis?',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    `scope` INTEGER,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Formularios de Perfiles';

-- ---------------------------------------------------------------------
-- actors_profileFormQuestionOption
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_profileFormQuestionOption`;

CREATE TABLE `actors_profileFormQuestionOption`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion de la opcion',
    `formId` INTEGER NOT NULL COMMENT 'Identificacion de la pregunta',
    `order` INTEGER NOT NULL,
    `value` VARCHAR(255) NOT NULL,
    `text` VARCHAR(255) NOT NULL,
    `defaultOpc` BOOL,
    PRIMARY KEY (`id`,`order`),
    INDEX `actors_profileFormQuestionOption_FI_1` (`formId`),
    CONSTRAINT `actors_profileFormQuestionOption_FK_1`
        FOREIGN KEY (`formId`)
        REFERENCES `actors_profileForm` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Options for select questions';

-- ---------------------------------------------------------------------
-- actors_relations
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_relations`;

CREATE TABLE `actors_relations`
(
    `actorFromId` INTEGER NOT NULL COMMENT 'Identificacion Actor origen',
    `actorToId` INTEGER NOT NULL COMMENT 'Identificacion Actor destino',
    `questionId` INTEGER NOT NULL COMMENT 'Pregunta',
    `direction` BOOL NOT NULL COMMENT 'Direccion de la relacion',
    `current` VARCHAR(255) NOT NULL COMMENT 'Current relationship',
    `potential` VARCHAR(255) NOT NULL COMMENT 'Potential relationship',
    PRIMARY KEY (`actorFromId`,`actorToId`,`questionId`),
    INDEX `actors_relations_FI_2` (`questionId`),
    CONSTRAINT `actors_relations_FK_1`
        FOREIGN KEY (`actorFromId`,`actorToId`)
        REFERENCES `actors_actor` (`id`,`id`)
        ON DELETE CASCADE,
    CONSTRAINT `actors_relations_FK_2`
        FOREIGN KEY (`questionId`)
        REFERENCES `actors_profileForm` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Tabla de relaciones de actores';

-- ---------------------------------------------------------------------
-- actors_activeQuestions
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_activeQuestions`;

CREATE TABLE `actors_activeQuestions`
(
    `actorId` INTEGER NOT NULL,
    `questionId` INTEGER NOT NULL,
    PRIMARY KEY (`actorId`,`questionId`),
    INDEX `actors_activeQuestions_FI_2` (`questionId`),
    CONSTRAINT `actors_activeQuestions_FK_1`
        FOREIGN KEY (`actorId`)
        REFERENCES `actors_actor` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `actors_activeQuestions_FK_2`
        FOREIGN KEY (`questionId`)
        REFERENCES `actors_profileForm` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Tabla de preguntas activas';

-- ---------------------------------------------------------------------
-- actors_activeRelationQuestions
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_activeRelationQuestions`;

CREATE TABLE `actors_activeRelationQuestions`
(
    `actorFromId` INTEGER NOT NULL,
    `actorToId` INTEGER NOT NULL,
    `questionId` INTEGER NOT NULL,
    PRIMARY KEY (`actorFromId`,`actorToId`,`questionId`),
    INDEX `actors_activeRelationQuestions_FI_2` (`questionId`),
    CONSTRAINT `actors_activeRelationQuestions_FK_1`
        FOREIGN KEY (`actorFromId`,`actorToId`)
        REFERENCES `actors_actor` (`id`,`id`)
        ON DELETE CASCADE,
    CONSTRAINT `actors_activeRelationQuestions_FK_2`
        FOREIGN KEY (`questionId`)
        REFERENCES `actors_profileForm` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Tabla de preguntas activas de relacion';

-- ---------------------------------------------------------------------
-- actors_formAnswer
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `actors_formAnswer`;

CREATE TABLE `actors_formAnswer`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion de la respuesta',
    `actorId` INTEGER NOT NULL,
    `questionId` INTEGER NOT NULL,
    `answer` VARCHAR(255) NOT NULL,
    `judgement` VARCHAR(255) COMMENT 'Juicio',
    `current` INTEGER COMMENT 'Indica si el juicio esta vigente o no',
    `updated` DATETIME COMMENT 'Ultima actualizacion',
    PRIMARY KEY (`id`),
    INDEX `actors_formAnswer_FI_1` (`actorId`),
    INDEX `actors_formAnswer_FI_2` (`questionId`),
    CONSTRAINT `actors_formAnswer_FK_1`
        FOREIGN KEY (`actorId`)
        REFERENCES `actors_actor` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `actors_formAnswer_FK_2`
        FOREIGN KEY (`questionId`)
        REFERENCES `actors_profileForm` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Tabla de respuestas';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
