<?php


/**
 * Base class that represents a query for the 'security_blockedIp' table.
 *
 * IPs bloqueadas
 *
 * @method BlockedIpQuery orderById($order = Criteria::ASC) Order by the id column
 * @method BlockedIpQuery orderByIp($order = Criteria::ASC) Order by the ip column
 * @method BlockedIpQuery orderByBlockedat($order = Criteria::ASC) Order by the blockedAt column
 * @method BlockedIpQuery orderByUnblockedat($order = Criteria::ASC) Order by the unBlockedAt column
 *
 * @method BlockedIpQuery groupById() Group by the id column
 * @method BlockedIpQuery groupByIp() Group by the ip column
 * @method BlockedIpQuery groupByBlockedat() Group by the blockedAt column
 * @method BlockedIpQuery groupByUnblockedat() Group by the unBlockedAt column
 *
 * @method BlockedIpQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method BlockedIpQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method BlockedIpQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method BlockedIp findOne(PropelPDO $con = null) Return the first BlockedIp matching the query
 * @method BlockedIp findOneOrCreate(PropelPDO $con = null) Return the first BlockedIp matching the query, or a new BlockedIp object populated from the query conditions when no match is found
 *
 * @method BlockedIp findOneById(int $id) Return the first BlockedIp filtered by the id column
 * @method BlockedIp findOneByIp(string $ip) Return the first BlockedIp filtered by the ip column
 * @method BlockedIp findOneByBlockedat(string $blockedAt) Return the first BlockedIp filtered by the blockedAt column
 * @method BlockedIp findOneByUnblockedat(string $unBlockedAt) Return the first BlockedIp filtered by the unBlockedAt column
 *
 * @method array findById(int $id) Return BlockedIp objects filtered by the id column
 * @method array findByIp(string $ip) Return BlockedIp objects filtered by the ip column
 * @method array findByBlockedat(string $blockedAt) Return BlockedIp objects filtered by the blockedAt column
 * @method array findByUnblockedat(string $unBlockedAt) Return BlockedIp objects filtered by the unBlockedAt column
 *
 * @package    propel.generator.security.classes.om
 */
abstract class BaseBlockedIpQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseBlockedIpQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'BlockedIp', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new BlockedIpQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     BlockedIpQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return BlockedIpQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof BlockedIpQuery) {
            return $criteria;
        }
        $query = new BlockedIpQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   BlockedIp|BlockedIp[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = BlockedIpPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(BlockedIpPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   BlockedIp A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `IP`, `BLOCKEDAT`, `UNBLOCKEDAT` FROM `security_blockedIp` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new BlockedIp();
            $obj->hydrate($row);
            BlockedIpPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return BlockedIp|BlockedIp[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|BlockedIp[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return BlockedIpQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(BlockedIpPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return BlockedIpQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(BlockedIpPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return BlockedIpQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(BlockedIpPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the ip column
     *
     * Example usage:
     * <code>
     * $query->filterByIp('fooValue');   // WHERE ip = 'fooValue'
     * $query->filterByIp('%fooValue%'); // WHERE ip LIKE '%fooValue%'
     * </code>
     *
     * @param     string $ip The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return BlockedIpQuery The current query, for fluid interface
     */
    public function filterByIp($ip = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ip)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $ip)) {
                $ip = str_replace('*', '%', $ip);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(BlockedIpPeer::IP, $ip, $comparison);
    }

    /**
     * Filter the query on the blockedAt column
     *
     * Example usage:
     * <code>
     * $query->filterByBlockedat('2011-03-14'); // WHERE blockedAt = '2011-03-14'
     * $query->filterByBlockedat('now'); // WHERE blockedAt = '2011-03-14'
     * $query->filterByBlockedat(array('max' => 'yesterday')); // WHERE blockedAt > '2011-03-13'
     * </code>
     *
     * @param     mixed $blockedat The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return BlockedIpQuery The current query, for fluid interface
     */
    public function filterByBlockedat($blockedat = null, $comparison = null)
    {
        if (is_array($blockedat)) {
            $useMinMax = false;
            if (isset($blockedat['min'])) {
                $this->addUsingAlias(BlockedIpPeer::BLOCKEDAT, $blockedat['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($blockedat['max'])) {
                $this->addUsingAlias(BlockedIpPeer::BLOCKEDAT, $blockedat['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(BlockedIpPeer::BLOCKEDAT, $blockedat, $comparison);
    }

    /**
     * Filter the query on the unBlockedAt column
     *
     * Example usage:
     * <code>
     * $query->filterByUnblockedat('2011-03-14'); // WHERE unBlockedAt = '2011-03-14'
     * $query->filterByUnblockedat('now'); // WHERE unBlockedAt = '2011-03-14'
     * $query->filterByUnblockedat(array('max' => 'yesterday')); // WHERE unBlockedAt > '2011-03-13'
     * </code>
     *
     * @param     mixed $unblockedat The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return BlockedIpQuery The current query, for fluid interface
     */
    public function filterByUnblockedat($unblockedat = null, $comparison = null)
    {
        if (is_array($unblockedat)) {
            $useMinMax = false;
            if (isset($unblockedat['min'])) {
                $this->addUsingAlias(BlockedIpPeer::UNBLOCKEDAT, $unblockedat['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($unblockedat['max'])) {
                $this->addUsingAlias(BlockedIpPeer::UNBLOCKEDAT, $unblockedat['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(BlockedIpPeer::UNBLOCKEDAT, $unblockedat, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   BlockedIp $blockedIp Object to remove from the list of results
     *
     * @return BlockedIpQuery The current query, for fluid interface
     */
    public function prune($blockedIp = null)
    {
        if ($blockedIp) {
            $this->addUsingAlias(BlockedIpPeer::ID, $blockedIp->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
