<?php

/**
 * RegionsDoEditAction
 *
 * Crear o modificar region extendiendo BaseDoEditAction
 *
 * @package regions
 */

class RegionsDoEditAction extends BaseDoEditAction {

	function __construct($entityClassName = 'Region') {
		parent::__construct($entityClassName);
	}

 /**
	* Acciones previas al actualizar del objeto (update de datos sin guardarlos)
	*/
	protected function preUpdate() {

		// Convertir unidades de medida
		if (isset($this->entityParams['latitude']))
			$this->entityParams['latitude'] = Common::convertToMysqlNumericFormat($_POST['params']['latitude']);
		if (isset($this->entityParams['longitude']))
			$this->entityParams['longitude'] = Common::convertToMysqlNumericFormat($_POST['params']['longitude']);
		if (isset($this->entityParams['population']))
			$this->entityParams['population'] = Common::convertToMysqlNumericFormat($_POST['params']['population']);
		if (isset($this->entityParams['populationYear']))
			$this->entityParams['populationYear'] = Common::convertToMysqlNumericFormat($_POST['params']['populationYear']);
		if (isset($this->entityParams['area']))
			$this->entityParams['area'] = Common::convertToMysqlNumericFormat($_POST['params']['area']);

		parent::preUpdate();
	}

 /**
	* Acciones a tomar despues de actualizar el objeto pero antes de guardarlo
	* En este action se verifican las relaciones de nested_set, si existe root, parent, etc.
	*/
	protected function preSave() {
		parent::preSave();

		//Busco el root, si no existe, se crea con el elemento enviado
		$root = RegionQuery::create()->findRoot();
		if (empty($root))
			$this->entity->makeRoot();
		else {
			//Si no se envia parentId y no es root, se setea el root como desiredParent
			if (empty($_POST['params']['parentId'])) {
				if ($root->getId() == $this->entity->getId())
					return true;
				else
					$desiredParent = $root;
			}
			else {
				// Se busca padre solicitado por parentId
				$desiredParent = RegionQuery::create()->findOneById($_POST['params']['parentId']);
				if (empty($desiredParent))
					throw new Exception('Region ID "' . $_POST['params']['parentId'] . '" not found.');
			}

			if ($desiredParent->getId() != $this->entity->getParentId()) {
				if ($this->entity->isNew())
					$this->entity->insertAsLastChildOf($desiredParent);
				else
					$this->entity->moveToLastChildOf($desiredParent);
			}
		}

	}//End preSave

}
