<script type="text/javascript" src="scripts/lightbox.js"></script> 			
<div id="lightbox1" class="leightbox" style="position:absolute;">
	<p align="right">
		<a href="#" class="lbAction blackNoDecoration" rel="deactivate">Cerrar formulario <input type="button" class="icon iconClose" /></a>
	</p>
	<div id="listViewShowWorking"></div>
	<div class="innerLighbox">
		<div id="listViewShowDiv"></div>
	</div>
</div>

|-assign var=key value="AIzaSyCEbhsOnYkbTJmnozA-QZMEDeMp6XWHcbw"-|
<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=true&key=|-$key-|"></script>
<script type="text/javascript" src="scripts/keydragzoom_packed.js"></script>
<script type="text/javascript" src="scripts/map-base.js"></script>
<script type="text/javascript" src="scripts/entity-map.js"></script>

<script>

	var center = new google.maps.LatLng('|-$parameters.map.latitude|default:'-37.1833'-|', '|-$parameters.map.longitude|default:'-67.3667'-|');
	
	var icons = |-$icons|default:'
		{
			"default": "images/icon_marker_black.png",
			"red": "images/icon_marker_red.png",
			"yellow": "images/icon_marker_yellow.png",
			"green": "images/icon_marker_green.png",
			"blue": "images/icon_marker_blue.png",
			"white": "images/icon_marker_white.png",
			"orange": "images/icon_marker_orange.png"
		}
	'-|
	
	var MapProject = function() {
		this.markerInfoFn = function() {
			return '<strong>Proyecto: </strong>'+this.Name+' <a href="#lightbox1" rel="lightbox1" class="lbOn" onClick="displayLightbox(this, '+this.Id+')">Ver</a>';
		}
	}

	/* -- Map Group -- */
	var MapProjectGroup = function(id, lat, lon) {
		
		this.mapProjects = [];
		
		this.Id = id;
		this.Latitude = lat;
		this.Longitude = lon;
		this.Markertype = "orange";
		
		this.markerInfoFn = function() {
			var html = '';
			this.mapProjects.each(function(d, i) {
				html += '<p><img src="'+d.LittleMarkerUri+'">'+d.markerInfoFn()+'</p>';
			});
			return html;
		}
		
		this.addMapProject = function(mapProject) {
			this.mapProjects.push(mapProject);
		}
	}


	var loadProjects = function() {
		
		var projects = [];
		|-foreach from=$projects key="key" item="project"-| {
		
			var project = new MapProject();
			Object.extend(project, JSON.parse(|-$project->toJSON()|json_encode-|));			
			project.Markertype = "|-$project->statusColor()-|";
			project.LittleMarkerUri = 'images/icon_marker_|-$project->statusColor()-|.png';
			project.Latitude = |-$project->getConstruction()->getLatitude()-|;
			project.Longitude = |-$project->getConstruction()->getLongitude()-|;

			projects.push(project);
		
		}
		|-/foreach-|
		
		return projects;
	}
	
	var mustGroup = function(a, b) {
		var r = 0.0005;
		return Math.abs(a.Latitude - b.Latitude) < r && Math.abs(a.Longitude - b.Longitude) < r;
	}
	
	var groupProjects = function(projects) {
		
		// sort by latitude and longitude (in case of latitude equality)
		projects.sort(function(a, b) {
			var diff = a.Latitude - b.Latitude;
			return diff || a.Longitude - b.Longitude;
		});
		
		var groupedProjects = [];
		
		var group = null;
		for (var i = 0; i < projects.length; i++) {
			
			if (i === projects.length - 1) { // last iteration
				
				if (group === null) // projects[i] is not inside group
					groupedProjects.push(projects[i]);
				else // projects[i] is inside group
					groupedProjects.push(group);
				
				continue;
			}
			
			if (group === null) {
				
				if (mustGroup(projects[i], projects[i+1])) {
					group = new MapProjectGroup(projects[i].Id, projects[i].Latitude, projects[i].Longitude);
					group.addMapProject(projects[i]);
					group.addMapProject(projects[i+1]);
					// leave group as it is. it will be pushed to groupedProjects when it's complete.
				}
				else {
					groupedProjects.push(projects[i]);
				}
			}
			else { // unclosed group exists
				if (mustGroup(group, projects[i+1])) {
					group.addMapProject(projects[i+1]);
					// leave group as it is. it will be pushed to groupedProjects when it's complete.
				}
				else { // group is complete
					groupedProjects.push(group);
					group = null;
				}
			}
			
		}
		
		return groupedProjects;
	}
	
	var mapInit = function() {
		
		var groupedProjects = groupProjects(loadProjects());

		map = new EventsMap({
			canvasId: "graph",
			entities: groupedProjects,
			center: center,
			zoom: |-$parameters.map.zoom|default:'6'-|,
			icons: icons,
			markerInfoFn: function(project) {
				return project.markerInfoFn();
			}
		});
	}
	
	var displayLightbox = function(a, id) {
		$("listViewShowWorking").innerHTML = '<span class="inProgress">buscando ##projects,4,proyecto##...</span>';
		
		new Ajax.Updater(
			"listViewShowDiv",
			"Main.php?do=projectsViewX&id="+id,
			{
				method: "post",
				parameters: { id: id },
				evalScripts: true
			}
		);

		new lightbox(a);

		a.click();
	}
	
	|-if $library eq "prototype"-|
		Event.observe(window, "load", mapInit);
	|-elseif $library eq "jquery"-|
		$(mapInit);
	|-else-|
		throw "unknown library";
	|-/if-|

</script>
