<?php


/**
 * Base class that represents a query for the 'projects_projectLog' table.
 *
 * ProjectLog
 *
 * @method ProjectLogQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ProjectLogQuery orderByProjectid($order = Criteria::ASC) Order by the projectId column
 * @method ProjectLogQuery orderByObjectiveid($order = Criteria::ASC) Order by the objectiveId column
 * @method ProjectLogQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method ProjectLogQuery orderByCodeaux($order = Criteria::ASC) Order by the codeAux column
 * @method ProjectLogQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ProjectLogQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method ProjectLogQuery orderByImpact($order = Criteria::ASC) Order by the impact column
 * @method ProjectLogQuery orderByUniquegoal($order = Criteria::ASC) Order by the uniqueGoal column
 * @method ProjectLogQuery orderByGoalexpirationdate($order = Criteria::ASC) Order by the goalExpirationDate column
 * @method ProjectLogQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method ProjectLogQuery orderByBudget($order = Criteria::ASC) Order by the budget column
 * @method ProjectLogQuery orderByExchangerate($order = Criteria::ASC) Order by the exchangeRate column
 * @method ProjectLogQuery orderByVisibility($order = Criteria::ASC) Order by the visibility column
 * @method ProjectLogQuery orderByCoordinateneed($order = Criteria::ASC) Order by the coordinateNeed column
 * @method ProjectLogQuery orderByFrequency($order = Criteria::ASC) Order by the frequency column
 * @method ProjectLogQuery orderByFinished($order = Criteria::ASC) Order by the finished column
 * @method ProjectLogQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 * @method ProjectLogQuery orderByPostalcode($order = Criteria::ASC) Order by the postalCode column
 * @method ProjectLogQuery orderByUniquegoalnumeric($order = Criteria::ASC) Order by the uniqueGoalNumeric column
 * @method ProjectLogQuery orderByGoalprogress($order = Criteria::ASC) Order by the goalProgress column
 * @method ProjectLogQuery orderByLatitude($order = Criteria::ASC) Order by the latitude column
 * @method ProjectLogQuery orderByLongitude($order = Criteria::ASC) Order by the longitude column
 * @method ProjectLogQuery orderByOldid($order = Criteria::ASC) Order by the oldId column
 * @method ProjectLogQuery orderByRegionid($order = Criteria::ASC) Order by the regionId column
 * @method ProjectLogQuery orderByOldregionid($order = Criteria::ASC) Order by the oldRegionId column
 * @method ProjectLogQuery orderByLastmodification($order = Criteria::ASC) Order by the lastModification column
 * @method ProjectLogQuery orderByAddress($order = Criteria::ASC) Order by the address column
 * @method ProjectLogQuery orderByPriority($order = Criteria::ASC) Order by the priority column
 * @method ProjectLogQuery orderByModifications($order = Criteria::ASC) Order by the modifications column
 * @method ProjectLogQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 * @method ProjectLogQuery orderByPlannedstart($order = Criteria::ASC) Order by the plannedStart column
 * @method ProjectLogQuery orderByPlannedend($order = Criteria::ASC) Order by the plannedEnd column
 * @method ProjectLogQuery orderByRealstart($order = Criteria::ASC) Order by the realStart column
 * @method ProjectLogQuery orderByRealend($order = Criteria::ASC) Order by the realEnd column
 * @method ProjectLogQuery orderByCancelled($order = Criteria::ASC) Order by the cancelled column
 * @method ProjectLogQuery orderByIsconstruction($order = Criteria::ASC) Order by the isConstruction column
 * @method ProjectLogQuery orderByRelevance($order = Criteria::ASC) Order by the relevance column
 * @method ProjectLogQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method ProjectLogQuery orderByUserbyaffiliatesid($order = Criteria::ASC) Order by the userByAffiliatesId column
 * @method ProjectLogQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ProjectLogQuery orderByResponsiblecode($order = Criteria::ASC) Order by the responsibleCode column
 * @method ProjectLogQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method ProjectLogQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 * @method ProjectLogQuery orderBySubproject($order = Criteria::ASC) Order by the subproject column
 * @method ProjectLogQuery orderByOngoing($order = Criteria::ASC) Order by the ongoing column
 * @method ProjectLogQuery orderByRelatedareas($order = Criteria::ASC) Order by the relatedAreas column
 * @method ProjectLogQuery orderByGoal($order = Criteria::ASC) Order by the goal column
 * @method ProjectLogQuery orderByLegal($order = Criteria::ASC) Order by the legal column
 * @method ProjectLogQuery orderByExecresp($order = Criteria::ASC) Order by the execResp column
 * @method ProjectLogQuery orderByExectenure($order = Criteria::ASC) Order by the execTenure column
 * @method ProjectLogQuery orderByExecdependency($order = Criteria::ASC) Order by the execDependency column
 * @method ProjectLogQuery orderByExeccontact($order = Criteria::ASC) Order by the execContact column
 * @method ProjectLogQuery orderBySubsecretary($order = Criteria::ASC) Order by the subsecretary column
 * @method ProjectLogQuery orderByBudgetrequested($order = Criteria::ASC) Order by the budgetRequested column
 * @method ProjectLogQuery orderByBudgetsanctioned($order = Criteria::ASC) Order by the budgetSanctioned column
 * @method ProjectLogQuery orderByBeneficiario($order = Criteria::ASC) Order by the beneficiario column
 * @method ProjectLogQuery orderByRequirecontractor($order = Criteria::ASC) Order by the requireContractor column
 * @method ProjectLogQuery orderByPurchasetype($order = Criteria::ASC) Order by the purchaseType column
 * @method ProjectLogQuery orderByConstructiontype($order = Criteria::ASC) Order by the constructionType column
 * @method ProjectLogQuery orderByRequireexraresources($order = Criteria::ASC) Order by the requireExraResources column
 * @method ProjectLogQuery orderByImplementationpartner($order = Criteria::ASC) Order by the implementationPartner column
 * @method ProjectLogQuery orderByRiskfactors($order = Criteria::ASC) Order by the riskFactors column
 * @method ProjectLogQuery orderByOwnfinance($order = Criteria::ASC) Order by the ownFinance column
 * @method ProjectLogQuery orderByProvincefinance($order = Criteria::ASC) Order by the provinceFinance column
 * @method ProjectLogQuery orderByNationfinance($order = Criteria::ASC) Order by the nationFinance column
 * @method ProjectLogQuery orderByOtherfinance($order = Criteria::ASC) Order by the otherFinance column
 * @method ProjectLogQuery orderByFinancedetail($order = Criteria::ASC) Order by the financeDetail column
 * @method ProjectLogQuery orderByFinanceprogram($order = Criteria::ASC) Order by the financeProgram column
 *
 * @method ProjectLogQuery groupById() Group by the id column
 * @method ProjectLogQuery groupByProjectid() Group by the projectId column
 * @method ProjectLogQuery groupByObjectiveid() Group by the objectiveId column
 * @method ProjectLogQuery groupByCode() Group by the code column
 * @method ProjectLogQuery groupByCodeaux() Group by the codeAux column
 * @method ProjectLogQuery groupByName() Group by the name column
 * @method ProjectLogQuery groupByDescription() Group by the description column
 * @method ProjectLogQuery groupByImpact() Group by the impact column
 * @method ProjectLogQuery groupByUniquegoal() Group by the uniqueGoal column
 * @method ProjectLogQuery groupByGoalexpirationdate() Group by the goalExpirationDate column
 * @method ProjectLogQuery groupByDate() Group by the date column
 * @method ProjectLogQuery groupByBudget() Group by the budget column
 * @method ProjectLogQuery groupByExchangerate() Group by the exchangeRate column
 * @method ProjectLogQuery groupByVisibility() Group by the visibility column
 * @method ProjectLogQuery groupByCoordinateneed() Group by the coordinateNeed column
 * @method ProjectLogQuery groupByFrequency() Group by the frequency column
 * @method ProjectLogQuery groupByFinished() Group by the finished column
 * @method ProjectLogQuery groupByNotes() Group by the notes column
 * @method ProjectLogQuery groupByPostalcode() Group by the postalCode column
 * @method ProjectLogQuery groupByUniquegoalnumeric() Group by the uniqueGoalNumeric column
 * @method ProjectLogQuery groupByGoalprogress() Group by the goalProgress column
 * @method ProjectLogQuery groupByLatitude() Group by the latitude column
 * @method ProjectLogQuery groupByLongitude() Group by the longitude column
 * @method ProjectLogQuery groupByOldid() Group by the oldId column
 * @method ProjectLogQuery groupByRegionid() Group by the regionId column
 * @method ProjectLogQuery groupByOldregionid() Group by the oldRegionId column
 * @method ProjectLogQuery groupByLastmodification() Group by the lastModification column
 * @method ProjectLogQuery groupByAddress() Group by the address column
 * @method ProjectLogQuery groupByPriority() Group by the priority column
 * @method ProjectLogQuery groupByModifications() Group by the modifications column
 * @method ProjectLogQuery groupByChanges() Group by the changes column
 * @method ProjectLogQuery groupByPlannedstart() Group by the plannedStart column
 * @method ProjectLogQuery groupByPlannedend() Group by the plannedEnd column
 * @method ProjectLogQuery groupByRealstart() Group by the realStart column
 * @method ProjectLogQuery groupByRealend() Group by the realEnd column
 * @method ProjectLogQuery groupByCancelled() Group by the cancelled column
 * @method ProjectLogQuery groupByIsconstruction() Group by the isConstruction column
 * @method ProjectLogQuery groupByRelevance() Group by the relevance column
 * @method ProjectLogQuery groupByUserid() Group by the userId column
 * @method ProjectLogQuery groupByUserbyaffiliatesid() Group by the userByAffiliatesId column
 * @method ProjectLogQuery groupByUpdated() Group by the updated column
 * @method ProjectLogQuery groupByResponsiblecode() Group by the responsibleCode column
 * @method ProjectLogQuery groupByStartingyear() Group by the startingYear column
 * @method ProjectLogQuery groupByEndingyear() Group by the endingYear column
 * @method ProjectLogQuery groupBySubproject() Group by the subproject column
 * @method ProjectLogQuery groupByOngoing() Group by the ongoing column
 * @method ProjectLogQuery groupByRelatedareas() Group by the relatedAreas column
 * @method ProjectLogQuery groupByGoal() Group by the goal column
 * @method ProjectLogQuery groupByLegal() Group by the legal column
 * @method ProjectLogQuery groupByExecresp() Group by the execResp column
 * @method ProjectLogQuery groupByExectenure() Group by the execTenure column
 * @method ProjectLogQuery groupByExecdependency() Group by the execDependency column
 * @method ProjectLogQuery groupByExeccontact() Group by the execContact column
 * @method ProjectLogQuery groupBySubsecretary() Group by the subsecretary column
 * @method ProjectLogQuery groupByBudgetrequested() Group by the budgetRequested column
 * @method ProjectLogQuery groupByBudgetsanctioned() Group by the budgetSanctioned column
 * @method ProjectLogQuery groupByBeneficiario() Group by the beneficiario column
 * @method ProjectLogQuery groupByRequirecontractor() Group by the requireContractor column
 * @method ProjectLogQuery groupByPurchasetype() Group by the purchaseType column
 * @method ProjectLogQuery groupByConstructiontype() Group by the constructionType column
 * @method ProjectLogQuery groupByRequireexraresources() Group by the requireExraResources column
 * @method ProjectLogQuery groupByImplementationpartner() Group by the implementationPartner column
 * @method ProjectLogQuery groupByRiskfactors() Group by the riskFactors column
 * @method ProjectLogQuery groupByOwnfinance() Group by the ownFinance column
 * @method ProjectLogQuery groupByProvincefinance() Group by the provinceFinance column
 * @method ProjectLogQuery groupByNationfinance() Group by the nationFinance column
 * @method ProjectLogQuery groupByOtherfinance() Group by the otherFinance column
 * @method ProjectLogQuery groupByFinancedetail() Group by the financeDetail column
 * @method ProjectLogQuery groupByFinanceprogram() Group by the financeProgram column
 *
 * @method ProjectLogQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ProjectLogQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ProjectLogQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ProjectLogQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method ProjectLogQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method ProjectLogQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method ProjectLogQuery leftJoinObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the Objective relation
 * @method ProjectLogQuery rightJoinObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Objective relation
 * @method ProjectLogQuery innerJoinObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the Objective relation
 *
 * @method ProjectLogQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method ProjectLogQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method ProjectLogQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method ProjectLogQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method ProjectLogQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method ProjectLogQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method ProjectLog findOne(PropelPDO $con = null) Return the first ProjectLog matching the query
 * @method ProjectLog findOneOrCreate(PropelPDO $con = null) Return the first ProjectLog matching the query, or a new ProjectLog object populated from the query conditions when no match is found
 *
 * @method ProjectLog findOneById(int $id) Return the first ProjectLog filtered by the id column
 * @method ProjectLog findOneByProjectid(int $projectId) Return the first ProjectLog filtered by the projectId column
 * @method ProjectLog findOneByObjectiveid(int $objectiveId) Return the first ProjectLog filtered by the objectiveId column
 * @method ProjectLog findOneByCode(string $code) Return the first ProjectLog filtered by the code column
 * @method ProjectLog findOneByCodeaux(string $codeAux) Return the first ProjectLog filtered by the codeAux column
 * @method ProjectLog findOneByName(string $name) Return the first ProjectLog filtered by the name column
 * @method ProjectLog findOneByDescription(string $description) Return the first ProjectLog filtered by the description column
 * @method ProjectLog findOneByImpact(string $impact) Return the first ProjectLog filtered by the impact column
 * @method ProjectLog findOneByUniquegoal(string $uniqueGoal) Return the first ProjectLog filtered by the uniqueGoal column
 * @method ProjectLog findOneByGoalexpirationdate(string $goalExpirationDate) Return the first ProjectLog filtered by the goalExpirationDate column
 * @method ProjectLog findOneByDate(string $date) Return the first ProjectLog filtered by the date column
 * @method ProjectLog findOneByBudget(double $budget) Return the first ProjectLog filtered by the budget column
 * @method ProjectLog findOneByExchangerate(double $exchangeRate) Return the first ProjectLog filtered by the exchangeRate column
 * @method ProjectLog findOneByVisibility(int $visibility) Return the first ProjectLog filtered by the visibility column
 * @method ProjectLog findOneByCoordinateneed(string $coordinateNeed) Return the first ProjectLog filtered by the coordinateNeed column
 * @method ProjectLog findOneByFrequency(string $frequency) Return the first ProjectLog filtered by the frequency column
 * @method ProjectLog findOneByFinished(boolean $finished) Return the first ProjectLog filtered by the finished column
 * @method ProjectLog findOneByNotes(string $notes) Return the first ProjectLog filtered by the notes column
 * @method ProjectLog findOneByPostalcode(string $postalCode) Return the first ProjectLog filtered by the postalCode column
 * @method ProjectLog findOneByUniquegoalnumeric(int $uniqueGoalNumeric) Return the first ProjectLog filtered by the uniqueGoalNumeric column
 * @method ProjectLog findOneByGoalprogress(int $goalProgress) Return the first ProjectLog filtered by the goalProgress column
 * @method ProjectLog findOneByLatitude(double $latitude) Return the first ProjectLog filtered by the latitude column
 * @method ProjectLog findOneByLongitude(double $longitude) Return the first ProjectLog filtered by the longitude column
 * @method ProjectLog findOneByOldid(int $oldId) Return the first ProjectLog filtered by the oldId column
 * @method ProjectLog findOneByRegionid(int $regionId) Return the first ProjectLog filtered by the regionId column
 * @method ProjectLog findOneByOldregionid(int $oldRegionId) Return the first ProjectLog filtered by the oldRegionId column
 * @method ProjectLog findOneByLastmodification(string $lastModification) Return the first ProjectLog filtered by the lastModification column
 * @method ProjectLog findOneByAddress(string $address) Return the first ProjectLog filtered by the address column
 * @method ProjectLog findOneByPriority(int $priority) Return the first ProjectLog filtered by the priority column
 * @method ProjectLog findOneByModifications(int $modifications) Return the first ProjectLog filtered by the modifications column
 * @method ProjectLog findOneByChanges(int $changes) Return the first ProjectLog filtered by the changes column
 * @method ProjectLog findOneByPlannedstart(string $plannedStart) Return the first ProjectLog filtered by the plannedStart column
 * @method ProjectLog findOneByPlannedend(string $plannedEnd) Return the first ProjectLog filtered by the plannedEnd column
 * @method ProjectLog findOneByRealstart(string $realStart) Return the first ProjectLog filtered by the realStart column
 * @method ProjectLog findOneByRealend(string $realEnd) Return the first ProjectLog filtered by the realEnd column
 * @method ProjectLog findOneByCancelled(boolean $cancelled) Return the first ProjectLog filtered by the cancelled column
 * @method ProjectLog findOneByIsconstruction(boolean $isConstruction) Return the first ProjectLog filtered by the isConstruction column
 * @method ProjectLog findOneByRelevance(string $relevance) Return the first ProjectLog filtered by the relevance column
 * @method ProjectLog findOneByUserid(int $userId) Return the first ProjectLog filtered by the userId column
 * @method ProjectLog findOneByUserbyaffiliatesid(int $userByAffiliatesId) Return the first ProjectLog filtered by the userByAffiliatesId column
 * @method ProjectLog findOneByUpdated(string $updated) Return the first ProjectLog filtered by the updated column
 * @method ProjectLog findOneByResponsiblecode(int $responsibleCode) Return the first ProjectLog filtered by the responsibleCode column
 * @method ProjectLog findOneByStartingyear(int $startingYear) Return the first ProjectLog filtered by the startingYear column
 * @method ProjectLog findOneByEndingyear(int $endingYear) Return the first ProjectLog filtered by the endingYear column
 * @method ProjectLog findOneBySubproject(string $subproject) Return the first ProjectLog filtered by the subproject column
 * @method ProjectLog findOneByOngoing(string $ongoing) Return the first ProjectLog filtered by the ongoing column
 * @method ProjectLog findOneByRelatedareas(string $relatedAreas) Return the first ProjectLog filtered by the relatedAreas column
 * @method ProjectLog findOneByGoal(string $goal) Return the first ProjectLog filtered by the goal column
 * @method ProjectLog findOneByLegal(string $legal) Return the first ProjectLog filtered by the legal column
 * @method ProjectLog findOneByExecresp(string $execResp) Return the first ProjectLog filtered by the execResp column
 * @method ProjectLog findOneByExectenure(string $execTenure) Return the first ProjectLog filtered by the execTenure column
 * @method ProjectLog findOneByExecdependency(string $execDependency) Return the first ProjectLog filtered by the execDependency column
 * @method ProjectLog findOneByExeccontact(string $execContact) Return the first ProjectLog filtered by the execContact column
 * @method ProjectLog findOneBySubsecretary(string $subsecretary) Return the first ProjectLog filtered by the subsecretary column
 * @method ProjectLog findOneByBudgetrequested(double $budgetRequested) Return the first ProjectLog filtered by the budgetRequested column
 * @method ProjectLog findOneByBudgetsanctioned(double $budgetSanctioned) Return the first ProjectLog filtered by the budgetSanctioned column
 * @method ProjectLog findOneByBeneficiario(string $beneficiario) Return the first ProjectLog filtered by the beneficiario column
 * @method ProjectLog findOneByRequirecontractor(boolean $requireContractor) Return the first ProjectLog filtered by the requireContractor column
 * @method ProjectLog findOneByPurchasetype(int $purchaseType) Return the first ProjectLog filtered by the purchaseType column
 * @method ProjectLog findOneByConstructiontype(int $constructionType) Return the first ProjectLog filtered by the constructionType column
 * @method ProjectLog findOneByRequireexraresources(boolean $requireExraResources) Return the first ProjectLog filtered by the requireExraResources column
 * @method ProjectLog findOneByImplementationpartner(string $implementationPartner) Return the first ProjectLog filtered by the implementationPartner column
 * @method ProjectLog findOneByRiskfactors(string $riskFactors) Return the first ProjectLog filtered by the riskFactors column
 * @method ProjectLog findOneByOwnfinance(boolean $ownFinance) Return the first ProjectLog filtered by the ownFinance column
 * @method ProjectLog findOneByProvincefinance(boolean $provinceFinance) Return the first ProjectLog filtered by the provinceFinance column
 * @method ProjectLog findOneByNationfinance(boolean $nationFinance) Return the first ProjectLog filtered by the nationFinance column
 * @method ProjectLog findOneByOtherfinance(boolean $otherFinance) Return the first ProjectLog filtered by the otherFinance column
 * @method ProjectLog findOneByFinancedetail(string $financeDetail) Return the first ProjectLog filtered by the financeDetail column
 * @method ProjectLog findOneByFinanceprogram(string $financeProgram) Return the first ProjectLog filtered by the financeProgram column
 *
 * @method array findById(int $id) Return ProjectLog objects filtered by the id column
 * @method array findByProjectid(int $projectId) Return ProjectLog objects filtered by the projectId column
 * @method array findByObjectiveid(int $objectiveId) Return ProjectLog objects filtered by the objectiveId column
 * @method array findByCode(string $code) Return ProjectLog objects filtered by the code column
 * @method array findByCodeaux(string $codeAux) Return ProjectLog objects filtered by the codeAux column
 * @method array findByName(string $name) Return ProjectLog objects filtered by the name column
 * @method array findByDescription(string $description) Return ProjectLog objects filtered by the description column
 * @method array findByImpact(string $impact) Return ProjectLog objects filtered by the impact column
 * @method array findByUniquegoal(string $uniqueGoal) Return ProjectLog objects filtered by the uniqueGoal column
 * @method array findByGoalexpirationdate(string $goalExpirationDate) Return ProjectLog objects filtered by the goalExpirationDate column
 * @method array findByDate(string $date) Return ProjectLog objects filtered by the date column
 * @method array findByBudget(double $budget) Return ProjectLog objects filtered by the budget column
 * @method array findByExchangerate(double $exchangeRate) Return ProjectLog objects filtered by the exchangeRate column
 * @method array findByVisibility(int $visibility) Return ProjectLog objects filtered by the visibility column
 * @method array findByCoordinateneed(string $coordinateNeed) Return ProjectLog objects filtered by the coordinateNeed column
 * @method array findByFrequency(string $frequency) Return ProjectLog objects filtered by the frequency column
 * @method array findByFinished(boolean $finished) Return ProjectLog objects filtered by the finished column
 * @method array findByNotes(string $notes) Return ProjectLog objects filtered by the notes column
 * @method array findByPostalcode(string $postalCode) Return ProjectLog objects filtered by the postalCode column
 * @method array findByUniquegoalnumeric(int $uniqueGoalNumeric) Return ProjectLog objects filtered by the uniqueGoalNumeric column
 * @method array findByGoalprogress(int $goalProgress) Return ProjectLog objects filtered by the goalProgress column
 * @method array findByLatitude(double $latitude) Return ProjectLog objects filtered by the latitude column
 * @method array findByLongitude(double $longitude) Return ProjectLog objects filtered by the longitude column
 * @method array findByOldid(int $oldId) Return ProjectLog objects filtered by the oldId column
 * @method array findByRegionid(int $regionId) Return ProjectLog objects filtered by the regionId column
 * @method array findByOldregionid(int $oldRegionId) Return ProjectLog objects filtered by the oldRegionId column
 * @method array findByLastmodification(string $lastModification) Return ProjectLog objects filtered by the lastModification column
 * @method array findByAddress(string $address) Return ProjectLog objects filtered by the address column
 * @method array findByPriority(int $priority) Return ProjectLog objects filtered by the priority column
 * @method array findByModifications(int $modifications) Return ProjectLog objects filtered by the modifications column
 * @method array findByChanges(int $changes) Return ProjectLog objects filtered by the changes column
 * @method array findByPlannedstart(string $plannedStart) Return ProjectLog objects filtered by the plannedStart column
 * @method array findByPlannedend(string $plannedEnd) Return ProjectLog objects filtered by the plannedEnd column
 * @method array findByRealstart(string $realStart) Return ProjectLog objects filtered by the realStart column
 * @method array findByRealend(string $realEnd) Return ProjectLog objects filtered by the realEnd column
 * @method array findByCancelled(boolean $cancelled) Return ProjectLog objects filtered by the cancelled column
 * @method array findByIsconstruction(boolean $isConstruction) Return ProjectLog objects filtered by the isConstruction column
 * @method array findByRelevance(string $relevance) Return ProjectLog objects filtered by the relevance column
 * @method array findByUserid(int $userId) Return ProjectLog objects filtered by the userId column
 * @method array findByUserbyaffiliatesid(int $userByAffiliatesId) Return ProjectLog objects filtered by the userByAffiliatesId column
 * @method array findByUpdated(string $updated) Return ProjectLog objects filtered by the updated column
 * @method array findByResponsiblecode(int $responsibleCode) Return ProjectLog objects filtered by the responsibleCode column
 * @method array findByStartingyear(int $startingYear) Return ProjectLog objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return ProjectLog objects filtered by the endingYear column
 * @method array findBySubproject(string $subproject) Return ProjectLog objects filtered by the subproject column
 * @method array findByOngoing(string $ongoing) Return ProjectLog objects filtered by the ongoing column
 * @method array findByRelatedareas(string $relatedAreas) Return ProjectLog objects filtered by the relatedAreas column
 * @method array findByGoal(string $goal) Return ProjectLog objects filtered by the goal column
 * @method array findByLegal(string $legal) Return ProjectLog objects filtered by the legal column
 * @method array findByExecresp(string $execResp) Return ProjectLog objects filtered by the execResp column
 * @method array findByExectenure(string $execTenure) Return ProjectLog objects filtered by the execTenure column
 * @method array findByExecdependency(string $execDependency) Return ProjectLog objects filtered by the execDependency column
 * @method array findByExeccontact(string $execContact) Return ProjectLog objects filtered by the execContact column
 * @method array findBySubsecretary(string $subsecretary) Return ProjectLog objects filtered by the subsecretary column
 * @method array findByBudgetrequested(double $budgetRequested) Return ProjectLog objects filtered by the budgetRequested column
 * @method array findByBudgetsanctioned(double $budgetSanctioned) Return ProjectLog objects filtered by the budgetSanctioned column
 * @method array findByBeneficiario(string $beneficiario) Return ProjectLog objects filtered by the beneficiario column
 * @method array findByRequirecontractor(boolean $requireContractor) Return ProjectLog objects filtered by the requireContractor column
 * @method array findByPurchasetype(int $purchaseType) Return ProjectLog objects filtered by the purchaseType column
 * @method array findByConstructiontype(int $constructionType) Return ProjectLog objects filtered by the constructionType column
 * @method array findByRequireexraresources(boolean $requireExraResources) Return ProjectLog objects filtered by the requireExraResources column
 * @method array findByImplementationpartner(string $implementationPartner) Return ProjectLog objects filtered by the implementationPartner column
 * @method array findByRiskfactors(string $riskFactors) Return ProjectLog objects filtered by the riskFactors column
 * @method array findByOwnfinance(boolean $ownFinance) Return ProjectLog objects filtered by the ownFinance column
 * @method array findByProvincefinance(boolean $provinceFinance) Return ProjectLog objects filtered by the provinceFinance column
 * @method array findByNationfinance(boolean $nationFinance) Return ProjectLog objects filtered by the nationFinance column
 * @method array findByOtherfinance(boolean $otherFinance) Return ProjectLog objects filtered by the otherFinance column
 * @method array findByFinancedetail(string $financeDetail) Return ProjectLog objects filtered by the financeDetail column
 * @method array findByFinanceprogram(string $financeProgram) Return ProjectLog objects filtered by the financeProgram column
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectLogQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseProjectLogQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ProjectLog', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ProjectLogQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ProjectLogQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ProjectLogQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ProjectLogQuery) {
            return $criteria;
        }
        $query = new ProjectLogQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ProjectLog|ProjectLog[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ProjectLogPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ProjectLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ProjectLog A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `PROJECTID`, `OBJECTIVEID`, `CODE`, `CODEAUX`, `NAME`, `DESCRIPTION`, `IMPACT`, `UNIQUEGOAL`, `GOALEXPIRATIONDATE`, `DATE`, `BUDGET`, `EXCHANGERATE`, `VISIBILITY`, `COORDINATENEED`, `FREQUENCY`, `FINISHED`, `NOTES`, `POSTALCODE`, `UNIQUEGOALNUMERIC`, `GOALPROGRESS`, `LATITUDE`, `LONGITUDE`, `OLDID`, `REGIONID`, `OLDREGIONID`, `LASTMODIFICATION`, `ADDRESS`, `PRIORITY`, `MODIFICATIONS`, `CHANGES`, `PLANNEDSTART`, `PLANNEDEND`, `REALSTART`, `REALEND`, `CANCELLED`, `ISCONSTRUCTION`, `RELEVANCE`, `USERID`, `USERBYAFFILIATESID`, `UPDATED`, `RESPONSIBLECODE`, `STARTINGYEAR`, `ENDINGYEAR`, `SUBPROJECT`, `ONGOING`, `RELATEDAREAS`, `GOAL`, `LEGAL`, `EXECRESP`, `EXECTENURE`, `EXECDEPENDENCY`, `EXECCONTACT`, `SUBSECRETARY`, `BUDGETREQUESTED`, `BUDGETSANCTIONED`, `BENEFICIARIO`, `REQUIRECONTRACTOR`, `PURCHASETYPE`, `CONSTRUCTIONTYPE`, `REQUIREEXRARESOURCES`, `IMPLEMENTATIONPARTNER`, `RISKFACTORS`, `OWNFINANCE`, `PROVINCEFINANCE`, `NATIONFINANCE`, `OTHERFINANCE`, `FINANCEDETAIL`, `FINANCEPROGRAM` FROM `projects_projectLog` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ProjectLog();
            $obj->hydrate($row);
            ProjectLogPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ProjectLog|ProjectLog[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ProjectLog[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProjectLogPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProjectLogPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ProjectLogPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the projectId column
     *
     * Example usage:
     * <code>
     * $query->filterByProjectid(1234); // WHERE projectId = 1234
     * $query->filterByProjectid(array(12, 34)); // WHERE projectId IN (12, 34)
     * $query->filterByProjectid(array('min' => 12)); // WHERE projectId > 12
     * </code>
     *
     * @see       filterByProject()
     *
     * @param     mixed $projectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByProjectid($projectid = null, $comparison = null)
    {
        if (is_array($projectid)) {
            $useMinMax = false;
            if (isset($projectid['min'])) {
                $this->addUsingAlias(ProjectLogPeer::PROJECTID, $projectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($projectid['max'])) {
                $this->addUsingAlias(ProjectLogPeer::PROJECTID, $projectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::PROJECTID, $projectid, $comparison);
    }

    /**
     * Filter the query on the objectiveId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectiveid(1234); // WHERE objectiveId = 1234
     * $query->filterByObjectiveid(array(12, 34)); // WHERE objectiveId IN (12, 34)
     * $query->filterByObjectiveid(array('min' => 12)); // WHERE objectiveId > 12
     * </code>
     *
     * @see       filterByObjective()
     *
     * @param     mixed $objectiveid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByObjectiveid($objectiveid = null, $comparison = null)
    {
        if (is_array($objectiveid)) {
            $useMinMax = false;
            if (isset($objectiveid['min'])) {
                $this->addUsingAlias(ProjectLogPeer::OBJECTIVEID, $objectiveid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectiveid['max'])) {
                $this->addUsingAlias(ProjectLogPeer::OBJECTIVEID, $objectiveid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::OBJECTIVEID, $objectiveid, $comparison);
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode('fooValue');   // WHERE code = 'fooValue'
     * $query->filterByCode('%fooValue%'); // WHERE code LIKE '%fooValue%'
     * </code>
     *
     * @param     string $code The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByCode($code = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($code)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $code)) {
                $code = str_replace('*', '%', $code);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::CODE, $code, $comparison);
    }

    /**
     * Filter the query on the codeAux column
     *
     * Example usage:
     * <code>
     * $query->filterByCodeaux('fooValue');   // WHERE codeAux = 'fooValue'
     * $query->filterByCodeaux('%fooValue%'); // WHERE codeAux LIKE '%fooValue%'
     * </code>
     *
     * @param     string $codeaux The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByCodeaux($codeaux = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($codeaux)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $codeaux)) {
                $codeaux = str_replace('*', '%', $codeaux);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::CODEAUX, $codeaux, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the impact column
     *
     * Example usage:
     * <code>
     * $query->filterByImpact('fooValue');   // WHERE impact = 'fooValue'
     * $query->filterByImpact('%fooValue%'); // WHERE impact LIKE '%fooValue%'
     * </code>
     *
     * @param     string $impact The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByImpact($impact = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($impact)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $impact)) {
                $impact = str_replace('*', '%', $impact);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::IMPACT, $impact, $comparison);
    }

    /**
     * Filter the query on the uniqueGoal column
     *
     * Example usage:
     * <code>
     * $query->filterByUniquegoal('fooValue');   // WHERE uniqueGoal = 'fooValue'
     * $query->filterByUniquegoal('%fooValue%'); // WHERE uniqueGoal LIKE '%fooValue%'
     * </code>
     *
     * @param     string $uniquegoal The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByUniquegoal($uniquegoal = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($uniquegoal)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $uniquegoal)) {
                $uniquegoal = str_replace('*', '%', $uniquegoal);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::UNIQUEGOAL, $uniquegoal, $comparison);
    }

    /**
     * Filter the query on the goalExpirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByGoalexpirationdate('2011-03-14'); // WHERE goalExpirationDate = '2011-03-14'
     * $query->filterByGoalexpirationdate('now'); // WHERE goalExpirationDate = '2011-03-14'
     * $query->filterByGoalexpirationdate(array('max' => 'yesterday')); // WHERE goalExpirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $goalexpirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByGoalexpirationdate($goalexpirationdate = null, $comparison = null)
    {
        if (is_array($goalexpirationdate)) {
            $useMinMax = false;
            if (isset($goalexpirationdate['min'])) {
                $this->addUsingAlias(ProjectLogPeer::GOALEXPIRATIONDATE, $goalexpirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($goalexpirationdate['max'])) {
                $this->addUsingAlias(ProjectLogPeer::GOALEXPIRATIONDATE, $goalexpirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::GOALEXPIRATIONDATE, $goalexpirationdate, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(ProjectLogPeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(ProjectLogPeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the budget column
     *
     * Example usage:
     * <code>
     * $query->filterByBudget(1234); // WHERE budget = 1234
     * $query->filterByBudget(array(12, 34)); // WHERE budget IN (12, 34)
     * $query->filterByBudget(array('min' => 12)); // WHERE budget > 12
     * </code>
     *
     * @param     mixed $budget The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByBudget($budget = null, $comparison = null)
    {
        if (is_array($budget)) {
            $useMinMax = false;
            if (isset($budget['min'])) {
                $this->addUsingAlias(ProjectLogPeer::BUDGET, $budget['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budget['max'])) {
                $this->addUsingAlias(ProjectLogPeer::BUDGET, $budget['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::BUDGET, $budget, $comparison);
    }

    /**
     * Filter the query on the exchangeRate column
     *
     * Example usage:
     * <code>
     * $query->filterByExchangerate(1234); // WHERE exchangeRate = 1234
     * $query->filterByExchangerate(array(12, 34)); // WHERE exchangeRate IN (12, 34)
     * $query->filterByExchangerate(array('min' => 12)); // WHERE exchangeRate > 12
     * </code>
     *
     * @param     mixed $exchangerate The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByExchangerate($exchangerate = null, $comparison = null)
    {
        if (is_array($exchangerate)) {
            $useMinMax = false;
            if (isset($exchangerate['min'])) {
                $this->addUsingAlias(ProjectLogPeer::EXCHANGERATE, $exchangerate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($exchangerate['max'])) {
                $this->addUsingAlias(ProjectLogPeer::EXCHANGERATE, $exchangerate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::EXCHANGERATE, $exchangerate, $comparison);
    }

    /**
     * Filter the query on the visibility column
     *
     * Example usage:
     * <code>
     * $query->filterByVisibility(1234); // WHERE visibility = 1234
     * $query->filterByVisibility(array(12, 34)); // WHERE visibility IN (12, 34)
     * $query->filterByVisibility(array('min' => 12)); // WHERE visibility > 12
     * </code>
     *
     * @param     mixed $visibility The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByVisibility($visibility = null, $comparison = null)
    {
        if (is_array($visibility)) {
            $useMinMax = false;
            if (isset($visibility['min'])) {
                $this->addUsingAlias(ProjectLogPeer::VISIBILITY, $visibility['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($visibility['max'])) {
                $this->addUsingAlias(ProjectLogPeer::VISIBILITY, $visibility['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::VISIBILITY, $visibility, $comparison);
    }

    /**
     * Filter the query on the coordinateNeed column
     *
     * Example usage:
     * <code>
     * $query->filterByCoordinateneed('fooValue');   // WHERE coordinateNeed = 'fooValue'
     * $query->filterByCoordinateneed('%fooValue%'); // WHERE coordinateNeed LIKE '%fooValue%'
     * </code>
     *
     * @param     string $coordinateneed The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByCoordinateneed($coordinateneed = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($coordinateneed)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $coordinateneed)) {
                $coordinateneed = str_replace('*', '%', $coordinateneed);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::COORDINATENEED, $coordinateneed, $comparison);
    }

    /**
     * Filter the query on the frequency column
     *
     * Example usage:
     * <code>
     * $query->filterByFrequency('fooValue');   // WHERE frequency = 'fooValue'
     * $query->filterByFrequency('%fooValue%'); // WHERE frequency LIKE '%fooValue%'
     * </code>
     *
     * @param     string $frequency The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByFrequency($frequency = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($frequency)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $frequency)) {
                $frequency = str_replace('*', '%', $frequency);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::FREQUENCY, $frequency, $comparison);
    }

    /**
     * Filter the query on the finished column
     *
     * Example usage:
     * <code>
     * $query->filterByFinished(true); // WHERE finished = true
     * $query->filterByFinished('yes'); // WHERE finished = true
     * </code>
     *
     * @param     boolean|string $finished The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByFinished($finished = null, $comparison = null)
    {
        if (is_string($finished)) {
            $finished = in_array(strtolower($finished), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::FINISHED, $finished, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query on the postalCode column
     *
     * Example usage:
     * <code>
     * $query->filterByPostalcode('fooValue');   // WHERE postalCode = 'fooValue'
     * $query->filterByPostalcode('%fooValue%'); // WHERE postalCode LIKE '%fooValue%'
     * </code>
     *
     * @param     string $postalcode The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByPostalcode($postalcode = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($postalcode)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $postalcode)) {
                $postalcode = str_replace('*', '%', $postalcode);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::POSTALCODE, $postalcode, $comparison);
    }

    /**
     * Filter the query on the uniqueGoalNumeric column
     *
     * Example usage:
     * <code>
     * $query->filterByUniquegoalnumeric(1234); // WHERE uniqueGoalNumeric = 1234
     * $query->filterByUniquegoalnumeric(array(12, 34)); // WHERE uniqueGoalNumeric IN (12, 34)
     * $query->filterByUniquegoalnumeric(array('min' => 12)); // WHERE uniqueGoalNumeric > 12
     * </code>
     *
     * @param     mixed $uniquegoalnumeric The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByUniquegoalnumeric($uniquegoalnumeric = null, $comparison = null)
    {
        if (is_array($uniquegoalnumeric)) {
            $useMinMax = false;
            if (isset($uniquegoalnumeric['min'])) {
                $this->addUsingAlias(ProjectLogPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($uniquegoalnumeric['max'])) {
                $this->addUsingAlias(ProjectLogPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::UNIQUEGOALNUMERIC, $uniquegoalnumeric, $comparison);
    }

    /**
     * Filter the query on the goalProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByGoalprogress(1234); // WHERE goalProgress = 1234
     * $query->filterByGoalprogress(array(12, 34)); // WHERE goalProgress IN (12, 34)
     * $query->filterByGoalprogress(array('min' => 12)); // WHERE goalProgress > 12
     * </code>
     *
     * @param     mixed $goalprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByGoalprogress($goalprogress = null, $comparison = null)
    {
        if (is_array($goalprogress)) {
            $useMinMax = false;
            if (isset($goalprogress['min'])) {
                $this->addUsingAlias(ProjectLogPeer::GOALPROGRESS, $goalprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($goalprogress['max'])) {
                $this->addUsingAlias(ProjectLogPeer::GOALPROGRESS, $goalprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::GOALPROGRESS, $goalprogress, $comparison);
    }

    /**
     * Filter the query on the latitude column
     *
     * Example usage:
     * <code>
     * $query->filterByLatitude(1234); // WHERE latitude = 1234
     * $query->filterByLatitude(array(12, 34)); // WHERE latitude IN (12, 34)
     * $query->filterByLatitude(array('min' => 12)); // WHERE latitude > 12
     * </code>
     *
     * @param     mixed $latitude The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByLatitude($latitude = null, $comparison = null)
    {
        if (is_array($latitude)) {
            $useMinMax = false;
            if (isset($latitude['min'])) {
                $this->addUsingAlias(ProjectLogPeer::LATITUDE, $latitude['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($latitude['max'])) {
                $this->addUsingAlias(ProjectLogPeer::LATITUDE, $latitude['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::LATITUDE, $latitude, $comparison);
    }

    /**
     * Filter the query on the longitude column
     *
     * Example usage:
     * <code>
     * $query->filterByLongitude(1234); // WHERE longitude = 1234
     * $query->filterByLongitude(array(12, 34)); // WHERE longitude IN (12, 34)
     * $query->filterByLongitude(array('min' => 12)); // WHERE longitude > 12
     * </code>
     *
     * @param     mixed $longitude The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByLongitude($longitude = null, $comparison = null)
    {
        if (is_array($longitude)) {
            $useMinMax = false;
            if (isset($longitude['min'])) {
                $this->addUsingAlias(ProjectLogPeer::LONGITUDE, $longitude['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($longitude['max'])) {
                $this->addUsingAlias(ProjectLogPeer::LONGITUDE, $longitude['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::LONGITUDE, $longitude, $comparison);
    }

    /**
     * Filter the query on the oldId column
     *
     * Example usage:
     * <code>
     * $query->filterByOldid(1234); // WHERE oldId = 1234
     * $query->filterByOldid(array(12, 34)); // WHERE oldId IN (12, 34)
     * $query->filterByOldid(array('min' => 12)); // WHERE oldId > 12
     * </code>
     *
     * @param     mixed $oldid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByOldid($oldid = null, $comparison = null)
    {
        if (is_array($oldid)) {
            $useMinMax = false;
            if (isset($oldid['min'])) {
                $this->addUsingAlias(ProjectLogPeer::OLDID, $oldid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldid['max'])) {
                $this->addUsingAlias(ProjectLogPeer::OLDID, $oldid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::OLDID, $oldid, $comparison);
    }

    /**
     * Filter the query on the regionId column
     *
     * Example usage:
     * <code>
     * $query->filterByRegionid(1234); // WHERE regionId = 1234
     * $query->filterByRegionid(array(12, 34)); // WHERE regionId IN (12, 34)
     * $query->filterByRegionid(array('min' => 12)); // WHERE regionId > 12
     * </code>
     *
     * @param     mixed $regionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByRegionid($regionid = null, $comparison = null)
    {
        if (is_array($regionid)) {
            $useMinMax = false;
            if (isset($regionid['min'])) {
                $this->addUsingAlias(ProjectLogPeer::REGIONID, $regionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($regionid['max'])) {
                $this->addUsingAlias(ProjectLogPeer::REGIONID, $regionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::REGIONID, $regionid, $comparison);
    }

    /**
     * Filter the query on the oldRegionId column
     *
     * Example usage:
     * <code>
     * $query->filterByOldregionid(1234); // WHERE oldRegionId = 1234
     * $query->filterByOldregionid(array(12, 34)); // WHERE oldRegionId IN (12, 34)
     * $query->filterByOldregionid(array('min' => 12)); // WHERE oldRegionId > 12
     * </code>
     *
     * @param     mixed $oldregionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByOldregionid($oldregionid = null, $comparison = null)
    {
        if (is_array($oldregionid)) {
            $useMinMax = false;
            if (isset($oldregionid['min'])) {
                $this->addUsingAlias(ProjectLogPeer::OLDREGIONID, $oldregionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldregionid['max'])) {
                $this->addUsingAlias(ProjectLogPeer::OLDREGIONID, $oldregionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::OLDREGIONID, $oldregionid, $comparison);
    }

    /**
     * Filter the query on the lastModification column
     *
     * Example usage:
     * <code>
     * $query->filterByLastmodification('2011-03-14'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification('now'); // WHERE lastModification = '2011-03-14'
     * $query->filterByLastmodification(array('max' => 'yesterday')); // WHERE lastModification > '2011-03-13'
     * </code>
     *
     * @param     mixed $lastmodification The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByLastmodification($lastmodification = null, $comparison = null)
    {
        if (is_array($lastmodification)) {
            $useMinMax = false;
            if (isset($lastmodification['min'])) {
                $this->addUsingAlias(ProjectLogPeer::LASTMODIFICATION, $lastmodification['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($lastmodification['max'])) {
                $this->addUsingAlias(ProjectLogPeer::LASTMODIFICATION, $lastmodification['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::LASTMODIFICATION, $lastmodification, $comparison);
    }

    /**
     * Filter the query on the address column
     *
     * Example usage:
     * <code>
     * $query->filterByAddress('fooValue');   // WHERE address = 'fooValue'
     * $query->filterByAddress('%fooValue%'); // WHERE address LIKE '%fooValue%'
     * </code>
     *
     * @param     string $address The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByAddress($address = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($address)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $address)) {
                $address = str_replace('*', '%', $address);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::ADDRESS, $address, $comparison);
    }

    /**
     * Filter the query on the priority column
     *
     * Example usage:
     * <code>
     * $query->filterByPriority(1234); // WHERE priority = 1234
     * $query->filterByPriority(array(12, 34)); // WHERE priority IN (12, 34)
     * $query->filterByPriority(array('min' => 12)); // WHERE priority > 12
     * </code>
     *
     * @param     mixed $priority The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByPriority($priority = null, $comparison = null)
    {
        if (is_array($priority)) {
            $useMinMax = false;
            if (isset($priority['min'])) {
                $this->addUsingAlias(ProjectLogPeer::PRIORITY, $priority['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($priority['max'])) {
                $this->addUsingAlias(ProjectLogPeer::PRIORITY, $priority['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::PRIORITY, $priority, $comparison);
    }

    /**
     * Filter the query on the modifications column
     *
     * Example usage:
     * <code>
     * $query->filterByModifications(1234); // WHERE modifications = 1234
     * $query->filterByModifications(array(12, 34)); // WHERE modifications IN (12, 34)
     * $query->filterByModifications(array('min' => 12)); // WHERE modifications > 12
     * </code>
     *
     * @param     mixed $modifications The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByModifications($modifications = null, $comparison = null)
    {
        if (is_array($modifications)) {
            $useMinMax = false;
            if (isset($modifications['min'])) {
                $this->addUsingAlias(ProjectLogPeer::MODIFICATIONS, $modifications['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($modifications['max'])) {
                $this->addUsingAlias(ProjectLogPeer::MODIFICATIONS, $modifications['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::MODIFICATIONS, $modifications, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(ProjectLogPeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(ProjectLogPeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query on the plannedStart column
     *
     * Example usage:
     * <code>
     * $query->filterByPlannedstart('2011-03-14'); // WHERE plannedStart = '2011-03-14'
     * $query->filterByPlannedstart('now'); // WHERE plannedStart = '2011-03-14'
     * $query->filterByPlannedstart(array('max' => 'yesterday')); // WHERE plannedStart > '2011-03-13'
     * </code>
     *
     * @param     mixed $plannedstart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByPlannedstart($plannedstart = null, $comparison = null)
    {
        if (is_array($plannedstart)) {
            $useMinMax = false;
            if (isset($plannedstart['min'])) {
                $this->addUsingAlias(ProjectLogPeer::PLANNEDSTART, $plannedstart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($plannedstart['max'])) {
                $this->addUsingAlias(ProjectLogPeer::PLANNEDSTART, $plannedstart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::PLANNEDSTART, $plannedstart, $comparison);
    }

    /**
     * Filter the query on the plannedEnd column
     *
     * Example usage:
     * <code>
     * $query->filterByPlannedend('2011-03-14'); // WHERE plannedEnd = '2011-03-14'
     * $query->filterByPlannedend('now'); // WHERE plannedEnd = '2011-03-14'
     * $query->filterByPlannedend(array('max' => 'yesterday')); // WHERE plannedEnd > '2011-03-13'
     * </code>
     *
     * @param     mixed $plannedend The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByPlannedend($plannedend = null, $comparison = null)
    {
        if (is_array($plannedend)) {
            $useMinMax = false;
            if (isset($plannedend['min'])) {
                $this->addUsingAlias(ProjectLogPeer::PLANNEDEND, $plannedend['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($plannedend['max'])) {
                $this->addUsingAlias(ProjectLogPeer::PLANNEDEND, $plannedend['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::PLANNEDEND, $plannedend, $comparison);
    }

    /**
     * Filter the query on the realStart column
     *
     * Example usage:
     * <code>
     * $query->filterByRealstart('2011-03-14'); // WHERE realStart = '2011-03-14'
     * $query->filterByRealstart('now'); // WHERE realStart = '2011-03-14'
     * $query->filterByRealstart(array('max' => 'yesterday')); // WHERE realStart > '2011-03-13'
     * </code>
     *
     * @param     mixed $realstart The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByRealstart($realstart = null, $comparison = null)
    {
        if (is_array($realstart)) {
            $useMinMax = false;
            if (isset($realstart['min'])) {
                $this->addUsingAlias(ProjectLogPeer::REALSTART, $realstart['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realstart['max'])) {
                $this->addUsingAlias(ProjectLogPeer::REALSTART, $realstart['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::REALSTART, $realstart, $comparison);
    }

    /**
     * Filter the query on the realEnd column
     *
     * Example usage:
     * <code>
     * $query->filterByRealend('2011-03-14'); // WHERE realEnd = '2011-03-14'
     * $query->filterByRealend('now'); // WHERE realEnd = '2011-03-14'
     * $query->filterByRealend(array('max' => 'yesterday')); // WHERE realEnd > '2011-03-13'
     * </code>
     *
     * @param     mixed $realend The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByRealend($realend = null, $comparison = null)
    {
        if (is_array($realend)) {
            $useMinMax = false;
            if (isset($realend['min'])) {
                $this->addUsingAlias(ProjectLogPeer::REALEND, $realend['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realend['max'])) {
                $this->addUsingAlias(ProjectLogPeer::REALEND, $realend['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::REALEND, $realend, $comparison);
    }

    /**
     * Filter the query on the cancelled column
     *
     * Example usage:
     * <code>
     * $query->filterByCancelled(true); // WHERE cancelled = true
     * $query->filterByCancelled('yes'); // WHERE cancelled = true
     * </code>
     *
     * @param     boolean|string $cancelled The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByCancelled($cancelled = null, $comparison = null)
    {
        if (is_string($cancelled)) {
            $cancelled = in_array(strtolower($cancelled), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::CANCELLED, $cancelled, $comparison);
    }

    /**
     * Filter the query on the isConstruction column
     *
     * Example usage:
     * <code>
     * $query->filterByIsconstruction(true); // WHERE isConstruction = true
     * $query->filterByIsconstruction('yes'); // WHERE isConstruction = true
     * </code>
     *
     * @param     boolean|string $isconstruction The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByIsconstruction($isconstruction = null, $comparison = null)
    {
        if (is_string($isconstruction)) {
            $isConstruction = in_array(strtolower($isconstruction), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::ISCONSTRUCTION, $isconstruction, $comparison);
    }

    /**
     * Filter the query on the relevance column
     *
     * Example usage:
     * <code>
     * $query->filterByRelevance('fooValue');   // WHERE relevance = 'fooValue'
     * $query->filterByRelevance('%fooValue%'); // WHERE relevance LIKE '%fooValue%'
     * </code>
     *
     * @param     string $relevance The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByRelevance($relevance = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($relevance)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $relevance)) {
                $relevance = str_replace('*', '%', $relevance);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::RELEVANCE, $relevance, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(ProjectLogPeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(ProjectLogPeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the userByAffiliatesId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserbyaffiliatesid(1234); // WHERE userByAffiliatesId = 1234
     * $query->filterByUserbyaffiliatesid(array(12, 34)); // WHERE userByAffiliatesId IN (12, 34)
     * $query->filterByUserbyaffiliatesid(array('min' => 12)); // WHERE userByAffiliatesId > 12
     * </code>
     *
     * @param     mixed $userbyaffiliatesid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByUserbyaffiliatesid($userbyaffiliatesid = null, $comparison = null)
    {
        if (is_array($userbyaffiliatesid)) {
            $useMinMax = false;
            if (isset($userbyaffiliatesid['min'])) {
                $this->addUsingAlias(ProjectLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userbyaffiliatesid['max'])) {
                $this->addUsingAlias(ProjectLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ProjectLogPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ProjectLogPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the responsibleCode column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsiblecode(1234); // WHERE responsibleCode = 1234
     * $query->filterByResponsiblecode(array(12, 34)); // WHERE responsibleCode IN (12, 34)
     * $query->filterByResponsiblecode(array('min' => 12)); // WHERE responsibleCode > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $responsiblecode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByResponsiblecode($responsiblecode = null, $comparison = null)
    {
        if (is_array($responsiblecode)) {
            $useMinMax = false;
            if (isset($responsiblecode['min'])) {
                $this->addUsingAlias(ProjectLogPeer::RESPONSIBLECODE, $responsiblecode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($responsiblecode['max'])) {
                $this->addUsingAlias(ProjectLogPeer::RESPONSIBLECODE, $responsiblecode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::RESPONSIBLECODE, $responsiblecode, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(ProjectLogPeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(ProjectLogPeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(ProjectLogPeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(ProjectLogPeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query on the subproject column
     *
     * Example usage:
     * <code>
     * $query->filterBySubproject('fooValue');   // WHERE subproject = 'fooValue'
     * $query->filterBySubproject('%fooValue%'); // WHERE subproject LIKE '%fooValue%'
     * </code>
     *
     * @param     string $subproject The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterBySubproject($subproject = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($subproject)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $subproject)) {
                $subproject = str_replace('*', '%', $subproject);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::SUBPROJECT, $subproject, $comparison);
    }

    /**
     * Filter the query on the ongoing column
     *
     * Example usage:
     * <code>
     * $query->filterByOngoing('fooValue');   // WHERE ongoing = 'fooValue'
     * $query->filterByOngoing('%fooValue%'); // WHERE ongoing LIKE '%fooValue%'
     * </code>
     *
     * @param     string $ongoing The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByOngoing($ongoing = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ongoing)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $ongoing)) {
                $ongoing = str_replace('*', '%', $ongoing);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::ONGOING, $ongoing, $comparison);
    }

    /**
     * Filter the query on the relatedAreas column
     *
     * Example usage:
     * <code>
     * $query->filterByRelatedareas('fooValue');   // WHERE relatedAreas = 'fooValue'
     * $query->filterByRelatedareas('%fooValue%'); // WHERE relatedAreas LIKE '%fooValue%'
     * </code>
     *
     * @param     string $relatedareas The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByRelatedareas($relatedareas = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($relatedareas)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $relatedareas)) {
                $relatedareas = str_replace('*', '%', $relatedareas);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::RELATEDAREAS, $relatedareas, $comparison);
    }

    /**
     * Filter the query on the goal column
     *
     * Example usage:
     * <code>
     * $query->filterByGoal('fooValue');   // WHERE goal = 'fooValue'
     * $query->filterByGoal('%fooValue%'); // WHERE goal LIKE '%fooValue%'
     * </code>
     *
     * @param     string $goal The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByGoal($goal = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($goal)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $goal)) {
                $goal = str_replace('*', '%', $goal);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::GOAL, $goal, $comparison);
    }

    /**
     * Filter the query on the legal column
     *
     * Example usage:
     * <code>
     * $query->filterByLegal('fooValue');   // WHERE legal = 'fooValue'
     * $query->filterByLegal('%fooValue%'); // WHERE legal LIKE '%fooValue%'
     * </code>
     *
     * @param     string $legal The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByLegal($legal = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($legal)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $legal)) {
                $legal = str_replace('*', '%', $legal);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::LEGAL, $legal, $comparison);
    }

    /**
     * Filter the query on the execResp column
     *
     * Example usage:
     * <code>
     * $query->filterByExecresp('fooValue');   // WHERE execResp = 'fooValue'
     * $query->filterByExecresp('%fooValue%'); // WHERE execResp LIKE '%fooValue%'
     * </code>
     *
     * @param     string $execresp The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByExecresp($execresp = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($execresp)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $execresp)) {
                $execresp = str_replace('*', '%', $execresp);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::EXECRESP, $execresp, $comparison);
    }

    /**
     * Filter the query on the execTenure column
     *
     * Example usage:
     * <code>
     * $query->filterByExectenure('fooValue');   // WHERE execTenure = 'fooValue'
     * $query->filterByExectenure('%fooValue%'); // WHERE execTenure LIKE '%fooValue%'
     * </code>
     *
     * @param     string $exectenure The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByExectenure($exectenure = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($exectenure)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $exectenure)) {
                $exectenure = str_replace('*', '%', $exectenure);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::EXECTENURE, $exectenure, $comparison);
    }

    /**
     * Filter the query on the execDependency column
     *
     * Example usage:
     * <code>
     * $query->filterByExecdependency('fooValue');   // WHERE execDependency = 'fooValue'
     * $query->filterByExecdependency('%fooValue%'); // WHERE execDependency LIKE '%fooValue%'
     * </code>
     *
     * @param     string $execdependency The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByExecdependency($execdependency = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($execdependency)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $execdependency)) {
                $execdependency = str_replace('*', '%', $execdependency);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::EXECDEPENDENCY, $execdependency, $comparison);
    }

    /**
     * Filter the query on the execContact column
     *
     * Example usage:
     * <code>
     * $query->filterByExeccontact('fooValue');   // WHERE execContact = 'fooValue'
     * $query->filterByExeccontact('%fooValue%'); // WHERE execContact LIKE '%fooValue%'
     * </code>
     *
     * @param     string $execcontact The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByExeccontact($execcontact = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($execcontact)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $execcontact)) {
                $execcontact = str_replace('*', '%', $execcontact);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::EXECCONTACT, $execcontact, $comparison);
    }

    /**
     * Filter the query on the subsecretary column
     *
     * Example usage:
     * <code>
     * $query->filterBySubsecretary('fooValue');   // WHERE subsecretary = 'fooValue'
     * $query->filterBySubsecretary('%fooValue%'); // WHERE subsecretary LIKE '%fooValue%'
     * </code>
     *
     * @param     string $subsecretary The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterBySubsecretary($subsecretary = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($subsecretary)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $subsecretary)) {
                $subsecretary = str_replace('*', '%', $subsecretary);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::SUBSECRETARY, $subsecretary, $comparison);
    }

    /**
     * Filter the query on the budgetRequested column
     *
     * Example usage:
     * <code>
     * $query->filterByBudgetrequested(1234); // WHERE budgetRequested = 1234
     * $query->filterByBudgetrequested(array(12, 34)); // WHERE budgetRequested IN (12, 34)
     * $query->filterByBudgetrequested(array('min' => 12)); // WHERE budgetRequested > 12
     * </code>
     *
     * @param     mixed $budgetrequested The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByBudgetrequested($budgetrequested = null, $comparison = null)
    {
        if (is_array($budgetrequested)) {
            $useMinMax = false;
            if (isset($budgetrequested['min'])) {
                $this->addUsingAlias(ProjectLogPeer::BUDGETREQUESTED, $budgetrequested['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budgetrequested['max'])) {
                $this->addUsingAlias(ProjectLogPeer::BUDGETREQUESTED, $budgetrequested['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::BUDGETREQUESTED, $budgetrequested, $comparison);
    }

    /**
     * Filter the query on the budgetSanctioned column
     *
     * Example usage:
     * <code>
     * $query->filterByBudgetsanctioned(1234); // WHERE budgetSanctioned = 1234
     * $query->filterByBudgetsanctioned(array(12, 34)); // WHERE budgetSanctioned IN (12, 34)
     * $query->filterByBudgetsanctioned(array('min' => 12)); // WHERE budgetSanctioned > 12
     * </code>
     *
     * @param     mixed $budgetsanctioned The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByBudgetsanctioned($budgetsanctioned = null, $comparison = null)
    {
        if (is_array($budgetsanctioned)) {
            $useMinMax = false;
            if (isset($budgetsanctioned['min'])) {
                $this->addUsingAlias(ProjectLogPeer::BUDGETSANCTIONED, $budgetsanctioned['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($budgetsanctioned['max'])) {
                $this->addUsingAlias(ProjectLogPeer::BUDGETSANCTIONED, $budgetsanctioned['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::BUDGETSANCTIONED, $budgetsanctioned, $comparison);
    }

    /**
     * Filter the query on the beneficiario column
     *
     * Example usage:
     * <code>
     * $query->filterByBeneficiario('fooValue');   // WHERE beneficiario = 'fooValue'
     * $query->filterByBeneficiario('%fooValue%'); // WHERE beneficiario LIKE '%fooValue%'
     * </code>
     *
     * @param     string $beneficiario The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByBeneficiario($beneficiario = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($beneficiario)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $beneficiario)) {
                $beneficiario = str_replace('*', '%', $beneficiario);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::BENEFICIARIO, $beneficiario, $comparison);
    }

    /**
     * Filter the query on the requireContractor column
     *
     * Example usage:
     * <code>
     * $query->filterByRequirecontractor(true); // WHERE requireContractor = true
     * $query->filterByRequirecontractor('yes'); // WHERE requireContractor = true
     * </code>
     *
     * @param     boolean|string $requirecontractor The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByRequirecontractor($requirecontractor = null, $comparison = null)
    {
        if (is_string($requirecontractor)) {
            $requireContractor = in_array(strtolower($requirecontractor), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::REQUIRECONTRACTOR, $requirecontractor, $comparison);
    }

    /**
     * Filter the query on the purchaseType column
     *
     * Example usage:
     * <code>
     * $query->filterByPurchasetype(1234); // WHERE purchaseType = 1234
     * $query->filterByPurchasetype(array(12, 34)); // WHERE purchaseType IN (12, 34)
     * $query->filterByPurchasetype(array('min' => 12)); // WHERE purchaseType > 12
     * </code>
     *
     * @param     mixed $purchasetype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByPurchasetype($purchasetype = null, $comparison = null)
    {
        if (is_array($purchasetype)) {
            $useMinMax = false;
            if (isset($purchasetype['min'])) {
                $this->addUsingAlias(ProjectLogPeer::PURCHASETYPE, $purchasetype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($purchasetype['max'])) {
                $this->addUsingAlias(ProjectLogPeer::PURCHASETYPE, $purchasetype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::PURCHASETYPE, $purchasetype, $comparison);
    }

    /**
     * Filter the query on the constructionType column
     *
     * Example usage:
     * <code>
     * $query->filterByConstructiontype(1234); // WHERE constructionType = 1234
     * $query->filterByConstructiontype(array(12, 34)); // WHERE constructionType IN (12, 34)
     * $query->filterByConstructiontype(array('min' => 12)); // WHERE constructionType > 12
     * </code>
     *
     * @param     mixed $constructiontype The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByConstructiontype($constructiontype = null, $comparison = null)
    {
        if (is_array($constructiontype)) {
            $useMinMax = false;
            if (isset($constructiontype['min'])) {
                $this->addUsingAlias(ProjectLogPeer::CONSTRUCTIONTYPE, $constructiontype['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($constructiontype['max'])) {
                $this->addUsingAlias(ProjectLogPeer::CONSTRUCTIONTYPE, $constructiontype['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::CONSTRUCTIONTYPE, $constructiontype, $comparison);
    }

    /**
     * Filter the query on the requireExraResources column
     *
     * Example usage:
     * <code>
     * $query->filterByRequireexraresources(true); // WHERE requireExraResources = true
     * $query->filterByRequireexraresources('yes'); // WHERE requireExraResources = true
     * </code>
     *
     * @param     boolean|string $requireexraresources The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByRequireexraresources($requireexraresources = null, $comparison = null)
    {
        if (is_string($requireexraresources)) {
            $requireExraResources = in_array(strtolower($requireexraresources), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::REQUIREEXRARESOURCES, $requireexraresources, $comparison);
    }

    /**
     * Filter the query on the implementationPartner column
     *
     * Example usage:
     * <code>
     * $query->filterByImplementationpartner('fooValue');   // WHERE implementationPartner = 'fooValue'
     * $query->filterByImplementationpartner('%fooValue%'); // WHERE implementationPartner LIKE '%fooValue%'
     * </code>
     *
     * @param     string $implementationpartner The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByImplementationpartner($implementationpartner = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($implementationpartner)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $implementationpartner)) {
                $implementationpartner = str_replace('*', '%', $implementationpartner);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::IMPLEMENTATIONPARTNER, $implementationpartner, $comparison);
    }

    /**
     * Filter the query on the riskFactors column
     *
     * Example usage:
     * <code>
     * $query->filterByRiskfactors('fooValue');   // WHERE riskFactors = 'fooValue'
     * $query->filterByRiskfactors('%fooValue%'); // WHERE riskFactors LIKE '%fooValue%'
     * </code>
     *
     * @param     string $riskfactors The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByRiskfactors($riskfactors = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($riskfactors)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $riskfactors)) {
                $riskfactors = str_replace('*', '%', $riskfactors);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::RISKFACTORS, $riskfactors, $comparison);
    }

    /**
     * Filter the query on the ownFinance column
     *
     * Example usage:
     * <code>
     * $query->filterByOwnfinance(true); // WHERE ownFinance = true
     * $query->filterByOwnfinance('yes'); // WHERE ownFinance = true
     * </code>
     *
     * @param     boolean|string $ownfinance The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByOwnfinance($ownfinance = null, $comparison = null)
    {
        if (is_string($ownfinance)) {
            $ownFinance = in_array(strtolower($ownfinance), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::OWNFINANCE, $ownfinance, $comparison);
    }

    /**
     * Filter the query on the provinceFinance column
     *
     * Example usage:
     * <code>
     * $query->filterByProvincefinance(true); // WHERE provinceFinance = true
     * $query->filterByProvincefinance('yes'); // WHERE provinceFinance = true
     * </code>
     *
     * @param     boolean|string $provincefinance The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByProvincefinance($provincefinance = null, $comparison = null)
    {
        if (is_string($provincefinance)) {
            $provinceFinance = in_array(strtolower($provincefinance), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::PROVINCEFINANCE, $provincefinance, $comparison);
    }

    /**
     * Filter the query on the nationFinance column
     *
     * Example usage:
     * <code>
     * $query->filterByNationfinance(true); // WHERE nationFinance = true
     * $query->filterByNationfinance('yes'); // WHERE nationFinance = true
     * </code>
     *
     * @param     boolean|string $nationfinance The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByNationfinance($nationfinance = null, $comparison = null)
    {
        if (is_string($nationfinance)) {
            $nationFinance = in_array(strtolower($nationfinance), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::NATIONFINANCE, $nationfinance, $comparison);
    }

    /**
     * Filter the query on the otherFinance column
     *
     * Example usage:
     * <code>
     * $query->filterByOtherfinance(true); // WHERE otherFinance = true
     * $query->filterByOtherfinance('yes'); // WHERE otherFinance = true
     * </code>
     *
     * @param     boolean|string $otherfinance The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByOtherfinance($otherfinance = null, $comparison = null)
    {
        if (is_string($otherfinance)) {
            $otherFinance = in_array(strtolower($otherfinance), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ProjectLogPeer::OTHERFINANCE, $otherfinance, $comparison);
    }

    /**
     * Filter the query on the financeDetail column
     *
     * Example usage:
     * <code>
     * $query->filterByFinancedetail('fooValue');   // WHERE financeDetail = 'fooValue'
     * $query->filterByFinancedetail('%fooValue%'); // WHERE financeDetail LIKE '%fooValue%'
     * </code>
     *
     * @param     string $financedetail The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByFinancedetail($financedetail = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($financedetail)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $financedetail)) {
                $financedetail = str_replace('*', '%', $financedetail);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::FINANCEDETAIL, $financedetail, $comparison);
    }

    /**
     * Filter the query on the financeProgram column
     *
     * Example usage:
     * <code>
     * $query->filterByFinanceprogram('fooValue');   // WHERE financeProgram = 'fooValue'
     * $query->filterByFinanceprogram('%fooValue%'); // WHERE financeProgram LIKE '%fooValue%'
     * </code>
     *
     * @param     string $financeprogram The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function filterByFinanceprogram($financeprogram = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($financeprogram)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $financeprogram)) {
                $financeprogram = str_replace('*', '%', $financeprogram);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ProjectLogPeer::FINANCEPROGRAM, $financeprogram, $comparison);
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(ProjectLogPeer::PROJECTID, $project->getId(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectLogPeer::PROJECTID, $project->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related Objective object
     *
     * @param   Objective|PropelObjectCollection $objective The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjective($objective, $comparison = null)
    {
        if ($objective instanceof Objective) {
            return $this
                ->addUsingAlias(ProjectLogPeer::OBJECTIVEID, $objective->getId(), $comparison);
        } elseif ($objective instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectLogPeer::OBJECTIVEID, $objective->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByObjective() only accepts arguments of type Objective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Objective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function joinObjective($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Objective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Objective');
        }

        return $this;
    }

    /**
     * Use the Objective relation Objective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Objective', 'ObjectiveQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(ProjectLogPeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectLogPeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ProjectLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(ProjectLogPeer::RESPONSIBLECODE, $position->getCode(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProjectLogPeer::RESPONSIBLECODE, $position->toKeyValue('PrimaryKey', 'Code'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ProjectLog $projectLog Object to remove from the list of results
     *
     * @return ProjectLogQuery The current query, for fluid interface
     */
    public function prune($projectLog = null)
    {
        if ($projectLog) {
            $this->addUsingAlias(ProjectLogPeer::ID, $projectLog->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
