<?php


/**
 * Base class that represents a row from the 'projects_projectLog' table.
 *
 * ProjectLog
 *
 * @package    propel.generator.projects.classes.om
 */
abstract class BaseProjectLog extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ProjectLogPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ProjectLogPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the projectid field.
     * @var        int
     */
    protected $projectid;

    /**
     * The value for the objectiveid field.
     * @var        int
     */
    protected $objectiveid;

    /**
     * The value for the code field.
     * @var        string
     */
    protected $code;

    /**
     * The value for the codeaux field.
     * @var        string
     */
    protected $codeaux;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the impact field.
     * @var        string
     */
    protected $impact;

    /**
     * The value for the uniquegoal field.
     * @var        string
     */
    protected $uniquegoal;

    /**
     * The value for the goalexpirationdate field.
     * @var        string
     */
    protected $goalexpirationdate;

    /**
     * The value for the date field.
     * @var        string
     */
    protected $date;

    /**
     * The value for the budget field.
     * @var        double
     */
    protected $budget;

    /**
     * The value for the exchangerate field.
     * @var        double
     */
    protected $exchangerate;

    /**
     * The value for the visibility field.
     * @var        int
     */
    protected $visibility;

    /**
     * The value for the coordinateneed field.
     * @var        string
     */
    protected $coordinateneed;

    /**
     * The value for the frequency field.
     * @var        string
     */
    protected $frequency;

    /**
     * The value for the finished field.
     * @var        boolean
     */
    protected $finished;

    /**
     * The value for the notes field.
     * @var        string
     */
    protected $notes;

    /**
     * The value for the postalcode field.
     * @var        string
     */
    protected $postalcode;

    /**
     * The value for the uniquegoalnumeric field.
     * @var        int
     */
    protected $uniquegoalnumeric;

    /**
     * The value for the goalprogress field.
     * @var        int
     */
    protected $goalprogress;

    /**
     * The value for the latitude field.
     * @var        double
     */
    protected $latitude;

    /**
     * The value for the longitude field.
     * @var        double
     */
    protected $longitude;

    /**
     * The value for the oldid field.
     * @var        int
     */
    protected $oldid;

    /**
     * The value for the regionid field.
     * @var        int
     */
    protected $regionid;

    /**
     * The value for the oldregionid field.
     * @var        int
     */
    protected $oldregionid;

    /**
     * The value for the lastmodification field.
     * @var        string
     */
    protected $lastmodification;

    /**
     * The value for the address field.
     * @var        string
     */
    protected $address;

    /**
     * The value for the priority field.
     * @var        int
     */
    protected $priority;

    /**
     * The value for the modifications field.
     * @var        int
     */
    protected $modifications;

    /**
     * The value for the changes field.
     * @var        int
     */
    protected $changes;

    /**
     * The value for the plannedstart field.
     * @var        string
     */
    protected $plannedstart;

    /**
     * The value for the plannedend field.
     * @var        string
     */
    protected $plannedend;

    /**
     * The value for the realstart field.
     * @var        string
     */
    protected $realstart;

    /**
     * The value for the realend field.
     * @var        string
     */
    protected $realend;

    /**
     * The value for the cancelled field.
     * @var        boolean
     */
    protected $cancelled;

    /**
     * The value for the isconstruction field.
     * @var        boolean
     */
    protected $isconstruction;

    /**
     * The value for the relevance field.
     * @var        string
     */
    protected $relevance;

    /**
     * The value for the userid field.
     * @var        int
     */
    protected $userid;

    /**
     * The value for the userbyaffiliatesid field.
     * @var        int
     */
    protected $userbyaffiliatesid;

    /**
     * The value for the updated field.
     * @var        string
     */
    protected $updated;

    /**
     * The value for the responsiblecode field.
     * @var        int
     */
    protected $responsiblecode;

    /**
     * The value for the startingyear field.
     * @var        int
     */
    protected $startingyear;

    /**
     * The value for the endingyear field.
     * @var        int
     */
    protected $endingyear;

    /**
     * The value for the subproject field.
     * @var        string
     */
    protected $subproject;

    /**
     * The value for the ongoing field.
     * @var        string
     */
    protected $ongoing;

    /**
     * The value for the relatedareas field.
     * @var        string
     */
    protected $relatedareas;

    /**
     * The value for the goal field.
     * @var        string
     */
    protected $goal;

    /**
     * The value for the legal field.
     * @var        string
     */
    protected $legal;

    /**
     * The value for the execresp field.
     * @var        string
     */
    protected $execresp;

    /**
     * The value for the exectenure field.
     * @var        string
     */
    protected $exectenure;

    /**
     * The value for the execdependency field.
     * @var        string
     */
    protected $execdependency;

    /**
     * The value for the execcontact field.
     * @var        string
     */
    protected $execcontact;

    /**
     * The value for the subsecretary field.
     * @var        string
     */
    protected $subsecretary;

    /**
     * The value for the budgetrequested field.
     * @var        double
     */
    protected $budgetrequested;

    /**
     * The value for the budgetsanctioned field.
     * @var        double
     */
    protected $budgetsanctioned;

    /**
     * The value for the beneficiario field.
     * @var        string
     */
    protected $beneficiario;

    /**
     * The value for the requirecontractor field.
     * @var        boolean
     */
    protected $requirecontractor;

    /**
     * The value for the purchasetype field.
     * @var        int
     */
    protected $purchasetype;

    /**
     * The value for the constructiontype field.
     * @var        int
     */
    protected $constructiontype;

    /**
     * The value for the requireexraresources field.
     * @var        boolean
     */
    protected $requireexraresources;

    /**
     * The value for the implementationpartner field.
     * @var        string
     */
    protected $implementationpartner;

    /**
     * The value for the riskfactors field.
     * @var        string
     */
    protected $riskfactors;

    /**
     * The value for the ownfinance field.
     * @var        boolean
     */
    protected $ownfinance;

    /**
     * The value for the provincefinance field.
     * @var        boolean
     */
    protected $provincefinance;

    /**
     * The value for the nationfinance field.
     * @var        boolean
     */
    protected $nationfinance;

    /**
     * The value for the otherfinance field.
     * @var        boolean
     */
    protected $otherfinance;

    /**
     * The value for the financedetail field.
     * @var        string
     */
    protected $financedetail;

    /**
     * The value for the financeprogram field.
     * @var        string
     */
    protected $financeprogram;

    /**
     * @var        Project
     */
    protected $aProject;

    /**
     * @var        Objective
     */
    protected $aObjective;

    /**
     * @var        User
     */
    protected $aUser;

    /**
     * @var        Position
     */
    protected $aPosition;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Get the [id] column value.
     * Project Log Id
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [projectid] column value.
     * Project Id
     * @return int
     */
    public function getProjectid()
    {
        return $this->projectid;
    }

    /**
     * Get the [objectiveid] column value.
     * Objective Id
     * @return int
     */
    public function getObjectiveid()
    {
        return $this->objectiveid;
    }

    /**
     * Get the [code] column value.
     * Project Code
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Get the [codeaux] column value.
     * Project Code Auxiliary code
     * @return string
     */
    public function getCodeaux()
    {
        return $this->codeaux;
    }

    /**
     * Get the [name] column value.
     * Project Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [description] column value.
     * Project Description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [impact] column value.
     * Project Impact
     * @return string
     */
    public function getImpact()
    {
        return $this->impact;
    }

    /**
     * Get the [uniquegoal] column value.
     * Project Unique Goal
     * @return string
     */
    public function getUniquegoal()
    {
        return $this->uniquegoal;
    }

    /**
     * Get the [optionally formatted] temporal [goalexpirationdate] column value.
     * Project Goal Expiration Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getGoalexpirationdate($format = '%Y/%m/%d')
    {
        if ($this->goalexpirationdate === null) {
            return null;
        }

        if ($this->goalexpirationdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->goalexpirationdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->goalexpirationdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [date] column value.
     * Project Creation Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDate($format = 'Y-m-d H:i:s')
    {
        if ($this->date === null) {
            return null;
        }

        if ($this->date === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->date);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->date, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [budget] column value.
     * Project Budget (Presupuesto)
     * @return double
     */
    public function getBudget()
    {
        return $this->budget;
    }

    /**
     * Get the [exchangerate] column value.
     * Exchange Rate
     * @return double
     */
    public function getExchangerate()
    {
        return $this->exchangerate;
    }

    /**
     * Get the [visibility] column value.
     * Visibility
     * @return int
     */
    public function getVisibility()
    {
        return $this->visibility;
    }

    /**
     * Get the [coordinateneed] column value.
     * Project Coordinate Need
     * @return string
     */
    public function getCoordinateneed()
    {
        return $this->coordinateneed;
    }

    /**
     * Get the [frequency] column value.
     * Project Frequency
     * @return string
     */
    public function getFrequency()
    {
        return $this->frequency;
    }

    /**
     * Get the [finished] column value.
     * is Project Finished?
     * @return boolean
     */
    public function getFinished()
    {
        return $this->finished;
    }

    /**
     * Get the [notes] column value.
     * Project Notes
     * @return string
     */
    public function getNotes()
    {
        return $this->notes;
    }

    /**
     * Get the [postalcode] column value.
     * Project Postal Code
     * @return string
     */
    public function getPostalcode()
    {
        return $this->postalcode;
    }

    /**
     * Get the [uniquegoalnumeric] column value.
     * Project Unique Goal Numeric
     * @return int
     */
    public function getUniquegoalnumeric()
    {
        return $this->uniquegoalnumeric;
    }

    /**
     * Get the [goalprogress] column value.
     * Project Goal Progress
     * @return int
     */
    public function getGoalprogress()
    {
        return $this->goalprogress;
    }

    /**
     * Get the [latitude] column value.
     * latitud del proyecto
     * @return double
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Get the [longitude] column value.
     * longitud del proyecto
     * @return double
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Get the [oldid] column value.
     * Old Id
     * @return int
     */
    public function getOldid()
    {
        return $this->oldid;
    }

    /**
     * Get the [regionid] column value.
     * Region Id
     * @return int
     */
    public function getRegionid()
    {
        return $this->regionid;
    }

    /**
     * Get the [oldregionid] column value.
     * Old Region Id
     * @return int
     */
    public function getOldregionid()
    {
        return $this->oldregionid;
    }

    /**
     * Get the [optionally formatted] temporal [lastmodification] column value.
     * Ultima modificacion Date
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getLastmodification($format = 'Y-m-d H:i:s')
    {
        if ($this->lastmodification === null) {
            return null;
        }

        if ($this->lastmodification === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->lastmodification);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->lastmodification, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [address] column value.
     * Direccion del proyecto
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Get the [priority] column value.
     * Prioridad Id
     * @return int
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * Get the [modifications] column value.
     * Cantidad de modificaciones
     * @return int
     */
    public function getModifications()
    {
        return $this->modifications;
    }

    /**
     * Get the [changes] column value.
     * Cantidad de modificaciones
     * @return int
     */
    public function getChanges()
    {
        return $this->changes;
    }

    /**
     * Get the [optionally formatted] temporal [plannedstart] column value.
     * Project planned start
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getPlannedstart($format = '%Y/%m/%d')
    {
        if ($this->plannedstart === null) {
            return null;
        }

        if ($this->plannedstart === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->plannedstart);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->plannedstart, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [plannedend] column value.
     * Project planned End
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getPlannedend($format = '%Y/%m/%d')
    {
        if ($this->plannedend === null) {
            return null;
        }

        if ($this->plannedend === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->plannedend);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->plannedend, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [realstart] column value.
     * Project real start
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getRealstart($format = '%Y/%m/%d')
    {
        if ($this->realstart === null) {
            return null;
        }

        if ($this->realstart === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->realstart);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->realstart, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [optionally formatted] temporal [realend] column value.
     * Project real end
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getRealend($format = '%Y/%m/%d')
    {
        if ($this->realend === null) {
            return null;
        }

        if ($this->realend === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->realend);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->realend, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [cancelled] column value.
     * is project cancelled?
     * @return boolean
     */
    public function getCancelled()
    {
        return $this->cancelled;
    }

    /**
     * Get the [isconstruction] column value.
     * is a construction?
     * @return boolean
     */
    public function getIsconstruction()
    {
        return $this->isconstruction;
    }

    /**
     * Get the [relevance] column value.
     * Importancia
     * @return string
     */
    public function getRelevance()
    {
        return $this->relevance;
    }

    /**
     * Get the [userid] column value.
     * User Id
     * @return int
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Get the [userbyaffiliatesid] column value.
     * UserByAffiliates Id
     * @return int
     */
    public function getUserbyaffiliatesid()
    {
        return $this->userbyaffiliatesid;
    }

    /**
     * Get the [optionally formatted] temporal [updated] column value.
     * Updated
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getUpdated($format = 'Y-m-d H:i:s')
    {
        if ($this->updated === null) {
            return null;
        }

        if ($this->updated === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->updated);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->updated, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [responsiblecode] column value.
     * Codigo del responsable
     * @return int
     */
    public function getResponsiblecode()
    {
        return $this->responsiblecode;
    }

    /**
     * Get the [startingyear] column value.
     * Starting year
     * @return int
     */
    public function getStartingyear()
    {
        return $this->startingyear;
    }

    /**
     * Get the [endingyear] column value.
     * Ending year
     * @return int
     */
    public function getEndingyear()
    {
        return $this->endingyear;
    }

    /**
     * Get the [subproject] column value.
     * is subproject?
     * @return string
     */
    public function getSubproject()
    {
        return $this->subproject;
    }

    /**
     * Get the [ongoing] column value.
     * Nombre del programa en desarrollo
     * @return string
     */
    public function getOngoing()
    {
        return $this->ongoing;
    }

    /**
     * Get the [relatedareas] column value.
     * Areas relacionadas
     * @return string
     */
    public function getRelatedareas()
    {
        return $this->relatedareas;
    }

    /**
     * Get the [goal] column value.
     * Meta producto
     * @return string
     */
    public function getGoal()
    {
        return $this->goal;
    }

    /**
     * Get the [legal] column value.
     * Marco legal
     * @return string
     */
    public function getLegal()
    {
        return $this->legal;
    }

    /**
     * Get the [execresp] column value.
     * Responsable
     * @return string
     */
    public function getExecresp()
    {
        return $this->execresp;
    }

    /**
     * Get the [exectenure] column value.
     * Cargo
     * @return string
     */
    public function getExectenure()
    {
        return $this->exectenure;
    }

    /**
     * Get the [execdependency] column value.
     * Dependencia
     * @return string
     */
    public function getExecdependency()
    {
        return $this->execdependency;
    }

    /**
     * Get the [execcontact] column value.
     * Contacto
     * @return string
     */
    public function getExeccontact()
    {
        return $this->execcontact;
    }

    /**
     * Get the [subsecretary] column value.
     * Subsecretaria
     * @return string
     */
    public function getSubsecretary()
    {
        return $this->subsecretary;
    }

    /**
     * Get the [budgetrequested] column value.
     * Presupuesto solicitado
     * @return double
     */
    public function getBudgetrequested()
    {
        return $this->budgetrequested;
    }

    /**
     * Get the [budgetsanctioned] column value.
     * Presupuesto sancionado
     * @return double
     */
    public function getBudgetsanctioned()
    {
        return $this->budgetsanctioned;
    }

    /**
     * Get the [beneficiario] column value.
     * Grupo / Sector se va a beneficiar con este proyecto
     * @return string
     */
    public function getBeneficiario()
    {
        return $this->beneficiario;
    }

    /**
     * Get the [requirecontractor] column value.
     * Requiere Contratacion?
     * @return boolean
     */
    public function getRequirecontractor()
    {
        return $this->requirecontractor;
    }

    /**
     * Get the [purchasetype] column value.
     * Tipo de compra
     * @return int
     */
    public function getPurchasetype()
    {
        return $this->purchasetype;
    }

    /**
     * Get the [constructiontype] column value.
     * Tipo de Obra
     * @return int
     */
    public function getConstructiontype()
    {
        return $this->constructiontype;
    }

    /**
     * Get the [requireexraresources] column value.
     * Requiere personal extra?
     * @return boolean
     */
    public function getRequireexraresources()
    {
        return $this->requireexraresources;
    }

    /**
     * Get the [implementationpartner] column value.
     * Socios en la implementación
     * @return string
     */
    public function getImplementationpartner()
    {
        return $this->implementationpartner;
    }

    /**
     * Get the [riskfactors] column value.
     * Factores de riesgo
     * @return string
     */
    public function getRiskfactors()
    {
        return $this->riskfactors;
    }

    /**
     * Get the [ownfinance] column value.
     * Financiamiento propio?
     * @return boolean
     */
    public function getOwnfinance()
    {
        return $this->ownfinance;
    }

    /**
     * Get the [provincefinance] column value.
     * Financiamiento Provincial?
     * @return boolean
     */
    public function getProvincefinance()
    {
        return $this->provincefinance;
    }

    /**
     * Get the [nationfinance] column value.
     * Financiamiento Nacional?
     * @return boolean
     */
    public function getNationfinance()
    {
        return $this->nationfinance;
    }

    /**
     * Get the [otherfinance] column value.
     * Otro Financiamiento?
     * @return boolean
     */
    public function getOtherfinance()
    {
        return $this->otherfinance;
    }

    /**
     * Get the [financedetail] column value.
     * Detalle de financiamiento
     * @return string
     */
    public function getFinancedetail()
    {
        return $this->financedetail;
    }

    /**
     * Get the [financeprogram] column value.
     * Programa destino financiamiento
     * @return string
     */
    public function getFinanceprogram()
    {
        return $this->financeprogram;
    }

    /**
     * Set the value of [id] column.
     * Project Log Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ProjectLogPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [projectid] column.
     * Project Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setProjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->projectid !== $v) {
            $this->projectid = $v;
            $this->modifiedColumns[] = ProjectLogPeer::PROJECTID;
        }

        if ($this->aProject !== null && $this->aProject->getId() !== $v) {
            $this->aProject = null;
        }


        return $this;
    } // setProjectid()

    /**
     * Set the value of [objectiveid] column.
     * Objective Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setObjectiveid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->objectiveid !== $v) {
            $this->objectiveid = $v;
            $this->modifiedColumns[] = ProjectLogPeer::OBJECTIVEID;
        }

        if ($this->aObjective !== null && $this->aObjective->getId() !== $v) {
            $this->aObjective = null;
        }


        return $this;
    } // setObjectiveid()

    /**
     * Set the value of [code] column.
     * Project Code
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setCode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->code !== $v) {
            $this->code = $v;
            $this->modifiedColumns[] = ProjectLogPeer::CODE;
        }


        return $this;
    } // setCode()

    /**
     * Set the value of [codeaux] column.
     * Project Code Auxiliary code
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setCodeaux($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->codeaux !== $v) {
            $this->codeaux = $v;
            $this->modifiedColumns[] = ProjectLogPeer::CODEAUX;
        }


        return $this;
    } // setCodeaux()

    /**
     * Set the value of [name] column.
     * Project Name
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = ProjectLogPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [description] column.
     * Project Description
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = ProjectLogPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [impact] column.
     * Project Impact
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setImpact($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->impact !== $v) {
            $this->impact = $v;
            $this->modifiedColumns[] = ProjectLogPeer::IMPACT;
        }


        return $this;
    } // setImpact()

    /**
     * Set the value of [uniquegoal] column.
     * Project Unique Goal
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setUniquegoal($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->uniquegoal !== $v) {
            $this->uniquegoal = $v;
            $this->modifiedColumns[] = ProjectLogPeer::UNIQUEGOAL;
        }


        return $this;
    } // setUniquegoal()

    /**
     * Sets the value of [goalexpirationdate] column to a normalized version of the date/time value specified.
     * Project Goal Expiration Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setGoalexpirationdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->goalexpirationdate !== null || $dt !== null) {
            $currentDateAsString = ($this->goalexpirationdate !== null && $tmpDt = new DateTime($this->goalexpirationdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->goalexpirationdate = $newDateAsString;
                $this->modifiedColumns[] = ProjectLogPeer::GOALEXPIRATIONDATE;
            }
        } // if either are not null


        return $this;
    } // setGoalexpirationdate()

    /**
     * Sets the value of [date] column to a normalized version of the date/time value specified.
     * Project Creation Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->date !== null || $dt !== null) {
            $currentDateAsString = ($this->date !== null && $tmpDt = new DateTime($this->date)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->date = $newDateAsString;
                $this->modifiedColumns[] = ProjectLogPeer::DATE;
            }
        } // if either are not null


        return $this;
    } // setDate()

    /**
     * Set the value of [budget] column.
     * Project Budget (Presupuesto)
     * @param double $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setBudget($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->budget !== $v) {
            $this->budget = $v;
            $this->modifiedColumns[] = ProjectLogPeer::BUDGET;
        }


        return $this;
    } // setBudget()

    /**
     * Set the value of [exchangerate] column.
     * Exchange Rate
     * @param double $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setExchangerate($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->exchangerate !== $v) {
            $this->exchangerate = $v;
            $this->modifiedColumns[] = ProjectLogPeer::EXCHANGERATE;
        }


        return $this;
    } // setExchangerate()

    /**
     * Set the value of [visibility] column.
     * Visibility
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setVisibility($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->visibility !== $v) {
            $this->visibility = $v;
            $this->modifiedColumns[] = ProjectLogPeer::VISIBILITY;
        }


        return $this;
    } // setVisibility()

    /**
     * Set the value of [coordinateneed] column.
     * Project Coordinate Need
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setCoordinateneed($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->coordinateneed !== $v) {
            $this->coordinateneed = $v;
            $this->modifiedColumns[] = ProjectLogPeer::COORDINATENEED;
        }


        return $this;
    } // setCoordinateneed()

    /**
     * Set the value of [frequency] column.
     * Project Frequency
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setFrequency($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->frequency !== $v) {
            $this->frequency = $v;
            $this->modifiedColumns[] = ProjectLogPeer::FREQUENCY;
        }


        return $this;
    } // setFrequency()

    /**
     * Sets the value of the [finished] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is Project Finished?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setFinished($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->finished !== $v) {
            $this->finished = $v;
            $this->modifiedColumns[] = ProjectLogPeer::FINISHED;
        }


        return $this;
    } // setFinished()

    /**
     * Set the value of [notes] column.
     * Project Notes
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setNotes($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notes !== $v) {
            $this->notes = $v;
            $this->modifiedColumns[] = ProjectLogPeer::NOTES;
        }


        return $this;
    } // setNotes()

    /**
     * Set the value of [postalcode] column.
     * Project Postal Code
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setPostalcode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->postalcode !== $v) {
            $this->postalcode = $v;
            $this->modifiedColumns[] = ProjectLogPeer::POSTALCODE;
        }


        return $this;
    } // setPostalcode()

    /**
     * Set the value of [uniquegoalnumeric] column.
     * Project Unique Goal Numeric
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setUniquegoalnumeric($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->uniquegoalnumeric !== $v) {
            $this->uniquegoalnumeric = $v;
            $this->modifiedColumns[] = ProjectLogPeer::UNIQUEGOALNUMERIC;
        }


        return $this;
    } // setUniquegoalnumeric()

    /**
     * Set the value of [goalprogress] column.
     * Project Goal Progress
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setGoalprogress($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->goalprogress !== $v) {
            $this->goalprogress = $v;
            $this->modifiedColumns[] = ProjectLogPeer::GOALPROGRESS;
        }


        return $this;
    } // setGoalprogress()

    /**
     * Set the value of [latitude] column.
     * latitud del proyecto
     * @param double $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setLatitude($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->latitude !== $v) {
            $this->latitude = $v;
            $this->modifiedColumns[] = ProjectLogPeer::LATITUDE;
        }


        return $this;
    } // setLatitude()

    /**
     * Set the value of [longitude] column.
     * longitud del proyecto
     * @param double $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setLongitude($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->longitude !== $v) {
            $this->longitude = $v;
            $this->modifiedColumns[] = ProjectLogPeer::LONGITUDE;
        }


        return $this;
    } // setLongitude()

    /**
     * Set the value of [oldid] column.
     * Old Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setOldid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->oldid !== $v) {
            $this->oldid = $v;
            $this->modifiedColumns[] = ProjectLogPeer::OLDID;
        }


        return $this;
    } // setOldid()

    /**
     * Set the value of [regionid] column.
     * Region Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setRegionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->regionid !== $v) {
            $this->regionid = $v;
            $this->modifiedColumns[] = ProjectLogPeer::REGIONID;
        }


        return $this;
    } // setRegionid()

    /**
     * Set the value of [oldregionid] column.
     * Old Region Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setOldregionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->oldregionid !== $v) {
            $this->oldregionid = $v;
            $this->modifiedColumns[] = ProjectLogPeer::OLDREGIONID;
        }


        return $this;
    } // setOldregionid()

    /**
     * Sets the value of [lastmodification] column to a normalized version of the date/time value specified.
     * Ultima modificacion Date
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setLastmodification($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->lastmodification !== null || $dt !== null) {
            $currentDateAsString = ($this->lastmodification !== null && $tmpDt = new DateTime($this->lastmodification)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->lastmodification = $newDateAsString;
                $this->modifiedColumns[] = ProjectLogPeer::LASTMODIFICATION;
            }
        } // if either are not null


        return $this;
    } // setLastmodification()

    /**
     * Set the value of [address] column.
     * Direccion del proyecto
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setAddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->address !== $v) {
            $this->address = $v;
            $this->modifiedColumns[] = ProjectLogPeer::ADDRESS;
        }


        return $this;
    } // setAddress()

    /**
     * Set the value of [priority] column.
     * Prioridad Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setPriority($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->priority !== $v) {
            $this->priority = $v;
            $this->modifiedColumns[] = ProjectLogPeer::PRIORITY;
        }


        return $this;
    } // setPriority()

    /**
     * Set the value of [modifications] column.
     * Cantidad de modificaciones
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setModifications($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->modifications !== $v) {
            $this->modifications = $v;
            $this->modifiedColumns[] = ProjectLogPeer::MODIFICATIONS;
        }


        return $this;
    } // setModifications()

    /**
     * Set the value of [changes] column.
     * Cantidad de modificaciones
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setChanges($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->changes !== $v) {
            $this->changes = $v;
            $this->modifiedColumns[] = ProjectLogPeer::CHANGES;
        }


        return $this;
    } // setChanges()

    /**
     * Sets the value of [plannedstart] column to a normalized version of the date/time value specified.
     * Project planned start
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setPlannedstart($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->plannedstart !== null || $dt !== null) {
            $currentDateAsString = ($this->plannedstart !== null && $tmpDt = new DateTime($this->plannedstart)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->plannedstart = $newDateAsString;
                $this->modifiedColumns[] = ProjectLogPeer::PLANNEDSTART;
            }
        } // if either are not null


        return $this;
    } // setPlannedstart()

    /**
     * Sets the value of [plannedend] column to a normalized version of the date/time value specified.
     * Project planned End
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setPlannedend($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->plannedend !== null || $dt !== null) {
            $currentDateAsString = ($this->plannedend !== null && $tmpDt = new DateTime($this->plannedend)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->plannedend = $newDateAsString;
                $this->modifiedColumns[] = ProjectLogPeer::PLANNEDEND;
            }
        } // if either are not null


        return $this;
    } // setPlannedend()

    /**
     * Sets the value of [realstart] column to a normalized version of the date/time value specified.
     * Project real start
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setRealstart($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->realstart !== null || $dt !== null) {
            $currentDateAsString = ($this->realstart !== null && $tmpDt = new DateTime($this->realstart)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->realstart = $newDateAsString;
                $this->modifiedColumns[] = ProjectLogPeer::REALSTART;
            }
        } // if either are not null


        return $this;
    } // setRealstart()

    /**
     * Sets the value of [realend] column to a normalized version of the date/time value specified.
     * Project real end
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setRealend($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->realend !== null || $dt !== null) {
            $currentDateAsString = ($this->realend !== null && $tmpDt = new DateTime($this->realend)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->realend = $newDateAsString;
                $this->modifiedColumns[] = ProjectLogPeer::REALEND;
            }
        } // if either are not null


        return $this;
    } // setRealend()

    /**
     * Sets the value of the [cancelled] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is project cancelled?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setCancelled($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->cancelled !== $v) {
            $this->cancelled = $v;
            $this->modifiedColumns[] = ProjectLogPeer::CANCELLED;
        }


        return $this;
    } // setCancelled()

    /**
     * Sets the value of the [isconstruction] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * is a construction?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setIsconstruction($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->isconstruction !== $v) {
            $this->isconstruction = $v;
            $this->modifiedColumns[] = ProjectLogPeer::ISCONSTRUCTION;
        }


        return $this;
    } // setIsconstruction()

    /**
     * Set the value of [relevance] column.
     * Importancia
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setRelevance($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->relevance !== $v) {
            $this->relevance = $v;
            $this->modifiedColumns[] = ProjectLogPeer::RELEVANCE;
        }


        return $this;
    } // setRelevance()

    /**
     * Set the value of [userid] column.
     * User Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setUserid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userid !== $v) {
            $this->userid = $v;
            $this->modifiedColumns[] = ProjectLogPeer::USERID;
        }

        if ($this->aUser !== null && $this->aUser->getId() !== $v) {
            $this->aUser = null;
        }


        return $this;
    } // setUserid()

    /**
     * Set the value of [userbyaffiliatesid] column.
     * UserByAffiliates Id
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setUserbyaffiliatesid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->userbyaffiliatesid !== $v) {
            $this->userbyaffiliatesid = $v;
            $this->modifiedColumns[] = ProjectLogPeer::USERBYAFFILIATESID;
        }


        return $this;
    } // setUserbyaffiliatesid()

    /**
     * Sets the value of [updated] column to a normalized version of the date/time value specified.
     * Updated
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setUpdated($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->updated !== null || $dt !== null) {
            $currentDateAsString = ($this->updated !== null && $tmpDt = new DateTime($this->updated)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->updated = $newDateAsString;
                $this->modifiedColumns[] = ProjectLogPeer::UPDATED;
            }
        } // if either are not null


        return $this;
    } // setUpdated()

    /**
     * Set the value of [responsiblecode] column.
     * Codigo del responsable
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setResponsiblecode($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->responsiblecode !== $v) {
            $this->responsiblecode = $v;
            $this->modifiedColumns[] = ProjectLogPeer::RESPONSIBLECODE;
        }

        if ($this->aPosition !== null && $this->aPosition->getCode() !== $v) {
            $this->aPosition = null;
        }


        return $this;
    } // setResponsiblecode()

    /**
     * Set the value of [startingyear] column.
     * Starting year
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setStartingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->startingyear !== $v) {
            $this->startingyear = $v;
            $this->modifiedColumns[] = ProjectLogPeer::STARTINGYEAR;
        }


        return $this;
    } // setStartingyear()

    /**
     * Set the value of [endingyear] column.
     * Ending year
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setEndingyear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->endingyear !== $v) {
            $this->endingyear = $v;
            $this->modifiedColumns[] = ProjectLogPeer::ENDINGYEAR;
        }


        return $this;
    } // setEndingyear()

    /**
     * Set the value of [subproject] column.
     * is subproject?
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setSubproject($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->subproject !== $v) {
            $this->subproject = $v;
            $this->modifiedColumns[] = ProjectLogPeer::SUBPROJECT;
        }


        return $this;
    } // setSubproject()

    /**
     * Set the value of [ongoing] column.
     * Nombre del programa en desarrollo
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setOngoing($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ongoing !== $v) {
            $this->ongoing = $v;
            $this->modifiedColumns[] = ProjectLogPeer::ONGOING;
        }


        return $this;
    } // setOngoing()

    /**
     * Set the value of [relatedareas] column.
     * Areas relacionadas
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setRelatedareas($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->relatedareas !== $v) {
            $this->relatedareas = $v;
            $this->modifiedColumns[] = ProjectLogPeer::RELATEDAREAS;
        }


        return $this;
    } // setRelatedareas()

    /**
     * Set the value of [goal] column.
     * Meta producto
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setGoal($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->goal !== $v) {
            $this->goal = $v;
            $this->modifiedColumns[] = ProjectLogPeer::GOAL;
        }


        return $this;
    } // setGoal()

    /**
     * Set the value of [legal] column.
     * Marco legal
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setLegal($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->legal !== $v) {
            $this->legal = $v;
            $this->modifiedColumns[] = ProjectLogPeer::LEGAL;
        }


        return $this;
    } // setLegal()

    /**
     * Set the value of [execresp] column.
     * Responsable
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setExecresp($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->execresp !== $v) {
            $this->execresp = $v;
            $this->modifiedColumns[] = ProjectLogPeer::EXECRESP;
        }


        return $this;
    } // setExecresp()

    /**
     * Set the value of [exectenure] column.
     * Cargo
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setExectenure($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->exectenure !== $v) {
            $this->exectenure = $v;
            $this->modifiedColumns[] = ProjectLogPeer::EXECTENURE;
        }


        return $this;
    } // setExectenure()

    /**
     * Set the value of [execdependency] column.
     * Dependencia
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setExecdependency($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->execdependency !== $v) {
            $this->execdependency = $v;
            $this->modifiedColumns[] = ProjectLogPeer::EXECDEPENDENCY;
        }


        return $this;
    } // setExecdependency()

    /**
     * Set the value of [execcontact] column.
     * Contacto
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setExeccontact($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->execcontact !== $v) {
            $this->execcontact = $v;
            $this->modifiedColumns[] = ProjectLogPeer::EXECCONTACT;
        }


        return $this;
    } // setExeccontact()

    /**
     * Set the value of [subsecretary] column.
     * Subsecretaria
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setSubsecretary($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->subsecretary !== $v) {
            $this->subsecretary = $v;
            $this->modifiedColumns[] = ProjectLogPeer::SUBSECRETARY;
        }


        return $this;
    } // setSubsecretary()

    /**
     * Set the value of [budgetrequested] column.
     * Presupuesto solicitado
     * @param double $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setBudgetrequested($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->budgetrequested !== $v) {
            $this->budgetrequested = $v;
            $this->modifiedColumns[] = ProjectLogPeer::BUDGETREQUESTED;
        }


        return $this;
    } // setBudgetrequested()

    /**
     * Set the value of [budgetsanctioned] column.
     * Presupuesto sancionado
     * @param double $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setBudgetsanctioned($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->budgetsanctioned !== $v) {
            $this->budgetsanctioned = $v;
            $this->modifiedColumns[] = ProjectLogPeer::BUDGETSANCTIONED;
        }


        return $this;
    } // setBudgetsanctioned()

    /**
     * Set the value of [beneficiario] column.
     * Grupo / Sector se va a beneficiar con este proyecto
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setBeneficiario($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->beneficiario !== $v) {
            $this->beneficiario = $v;
            $this->modifiedColumns[] = ProjectLogPeer::BENEFICIARIO;
        }


        return $this;
    } // setBeneficiario()

    /**
     * Sets the value of the [requirecontractor] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Requiere Contratacion?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setRequirecontractor($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->requirecontractor !== $v) {
            $this->requirecontractor = $v;
            $this->modifiedColumns[] = ProjectLogPeer::REQUIRECONTRACTOR;
        }


        return $this;
    } // setRequirecontractor()

    /**
     * Set the value of [purchasetype] column.
     * Tipo de compra
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setPurchasetype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->purchasetype !== $v) {
            $this->purchasetype = $v;
            $this->modifiedColumns[] = ProjectLogPeer::PURCHASETYPE;
        }


        return $this;
    } // setPurchasetype()

    /**
     * Set the value of [constructiontype] column.
     * Tipo de Obra
     * @param int $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setConstructiontype($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->constructiontype !== $v) {
            $this->constructiontype = $v;
            $this->modifiedColumns[] = ProjectLogPeer::CONSTRUCTIONTYPE;
        }


        return $this;
    } // setConstructiontype()

    /**
     * Sets the value of the [requireexraresources] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Requiere personal extra?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setRequireexraresources($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->requireexraresources !== $v) {
            $this->requireexraresources = $v;
            $this->modifiedColumns[] = ProjectLogPeer::REQUIREEXRARESOURCES;
        }


        return $this;
    } // setRequireexraresources()

    /**
     * Set the value of [implementationpartner] column.
     * Socios en la implementación
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setImplementationpartner($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->implementationpartner !== $v) {
            $this->implementationpartner = $v;
            $this->modifiedColumns[] = ProjectLogPeer::IMPLEMENTATIONPARTNER;
        }


        return $this;
    } // setImplementationpartner()

    /**
     * Set the value of [riskfactors] column.
     * Factores de riesgo
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setRiskfactors($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->riskfactors !== $v) {
            $this->riskfactors = $v;
            $this->modifiedColumns[] = ProjectLogPeer::RISKFACTORS;
        }


        return $this;
    } // setRiskfactors()

    /**
     * Sets the value of the [ownfinance] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Financiamiento propio?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setOwnfinance($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->ownfinance !== $v) {
            $this->ownfinance = $v;
            $this->modifiedColumns[] = ProjectLogPeer::OWNFINANCE;
        }


        return $this;
    } // setOwnfinance()

    /**
     * Sets the value of the [provincefinance] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Financiamiento Provincial?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setProvincefinance($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->provincefinance !== $v) {
            $this->provincefinance = $v;
            $this->modifiedColumns[] = ProjectLogPeer::PROVINCEFINANCE;
        }


        return $this;
    } // setProvincefinance()

    /**
     * Sets the value of the [nationfinance] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Financiamiento Nacional?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setNationfinance($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->nationfinance !== $v) {
            $this->nationfinance = $v;
            $this->modifiedColumns[] = ProjectLogPeer::NATIONFINANCE;
        }


        return $this;
    } // setNationfinance()

    /**
     * Sets the value of the [otherfinance] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Otro Financiamiento?
     * @param boolean|integer|string $v The new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setOtherfinance($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->otherfinance !== $v) {
            $this->otherfinance = $v;
            $this->modifiedColumns[] = ProjectLogPeer::OTHERFINANCE;
        }


        return $this;
    } // setOtherfinance()

    /**
     * Set the value of [financedetail] column.
     * Detalle de financiamiento
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setFinancedetail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->financedetail !== $v) {
            $this->financedetail = $v;
            $this->modifiedColumns[] = ProjectLogPeer::FINANCEDETAIL;
        }


        return $this;
    } // setFinancedetail()

    /**
     * Set the value of [financeprogram] column.
     * Programa destino financiamiento
     * @param string $v new value
     * @return ProjectLog The current object (for fluent API support)
     */
    public function setFinanceprogram($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->financeprogram !== $v) {
            $this->financeprogram = $v;
            $this->modifiedColumns[] = ProjectLogPeer::FINANCEPROGRAM;
        }


        return $this;
    } // setFinanceprogram()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->projectid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->objectiveid = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->code = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->codeaux = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->name = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->description = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->impact = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->uniquegoal = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
            $this->goalexpirationdate = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->date = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->budget = ($row[$startcol + 11] !== null) ? (double) $row[$startcol + 11] : null;
            $this->exchangerate = ($row[$startcol + 12] !== null) ? (double) $row[$startcol + 12] : null;
            $this->visibility = ($row[$startcol + 13] !== null) ? (int) $row[$startcol + 13] : null;
            $this->coordinateneed = ($row[$startcol + 14] !== null) ? (string) $row[$startcol + 14] : null;
            $this->frequency = ($row[$startcol + 15] !== null) ? (string) $row[$startcol + 15] : null;
            $this->finished = ($row[$startcol + 16] !== null) ? (boolean) $row[$startcol + 16] : null;
            $this->notes = ($row[$startcol + 17] !== null) ? (string) $row[$startcol + 17] : null;
            $this->postalcode = ($row[$startcol + 18] !== null) ? (string) $row[$startcol + 18] : null;
            $this->uniquegoalnumeric = ($row[$startcol + 19] !== null) ? (int) $row[$startcol + 19] : null;
            $this->goalprogress = ($row[$startcol + 20] !== null) ? (int) $row[$startcol + 20] : null;
            $this->latitude = ($row[$startcol + 21] !== null) ? (double) $row[$startcol + 21] : null;
            $this->longitude = ($row[$startcol + 22] !== null) ? (double) $row[$startcol + 22] : null;
            $this->oldid = ($row[$startcol + 23] !== null) ? (int) $row[$startcol + 23] : null;
            $this->regionid = ($row[$startcol + 24] !== null) ? (int) $row[$startcol + 24] : null;
            $this->oldregionid = ($row[$startcol + 25] !== null) ? (int) $row[$startcol + 25] : null;
            $this->lastmodification = ($row[$startcol + 26] !== null) ? (string) $row[$startcol + 26] : null;
            $this->address = ($row[$startcol + 27] !== null) ? (string) $row[$startcol + 27] : null;
            $this->priority = ($row[$startcol + 28] !== null) ? (int) $row[$startcol + 28] : null;
            $this->modifications = ($row[$startcol + 29] !== null) ? (int) $row[$startcol + 29] : null;
            $this->changes = ($row[$startcol + 30] !== null) ? (int) $row[$startcol + 30] : null;
            $this->plannedstart = ($row[$startcol + 31] !== null) ? (string) $row[$startcol + 31] : null;
            $this->plannedend = ($row[$startcol + 32] !== null) ? (string) $row[$startcol + 32] : null;
            $this->realstart = ($row[$startcol + 33] !== null) ? (string) $row[$startcol + 33] : null;
            $this->realend = ($row[$startcol + 34] !== null) ? (string) $row[$startcol + 34] : null;
            $this->cancelled = ($row[$startcol + 35] !== null) ? (boolean) $row[$startcol + 35] : null;
            $this->isconstruction = ($row[$startcol + 36] !== null) ? (boolean) $row[$startcol + 36] : null;
            $this->relevance = ($row[$startcol + 37] !== null) ? (string) $row[$startcol + 37] : null;
            $this->userid = ($row[$startcol + 38] !== null) ? (int) $row[$startcol + 38] : null;
            $this->userbyaffiliatesid = ($row[$startcol + 39] !== null) ? (int) $row[$startcol + 39] : null;
            $this->updated = ($row[$startcol + 40] !== null) ? (string) $row[$startcol + 40] : null;
            $this->responsiblecode = ($row[$startcol + 41] !== null) ? (int) $row[$startcol + 41] : null;
            $this->startingyear = ($row[$startcol + 42] !== null) ? (int) $row[$startcol + 42] : null;
            $this->endingyear = ($row[$startcol + 43] !== null) ? (int) $row[$startcol + 43] : null;
            $this->subproject = ($row[$startcol + 44] !== null) ? (string) $row[$startcol + 44] : null;
            $this->ongoing = ($row[$startcol + 45] !== null) ? (string) $row[$startcol + 45] : null;
            $this->relatedareas = ($row[$startcol + 46] !== null) ? (string) $row[$startcol + 46] : null;
            $this->goal = ($row[$startcol + 47] !== null) ? (string) $row[$startcol + 47] : null;
            $this->legal = ($row[$startcol + 48] !== null) ? (string) $row[$startcol + 48] : null;
            $this->execresp = ($row[$startcol + 49] !== null) ? (string) $row[$startcol + 49] : null;
            $this->exectenure = ($row[$startcol + 50] !== null) ? (string) $row[$startcol + 50] : null;
            $this->execdependency = ($row[$startcol + 51] !== null) ? (string) $row[$startcol + 51] : null;
            $this->execcontact = ($row[$startcol + 52] !== null) ? (string) $row[$startcol + 52] : null;
            $this->subsecretary = ($row[$startcol + 53] !== null) ? (string) $row[$startcol + 53] : null;
            $this->budgetrequested = ($row[$startcol + 54] !== null) ? (double) $row[$startcol + 54] : null;
            $this->budgetsanctioned = ($row[$startcol + 55] !== null) ? (double) $row[$startcol + 55] : null;
            $this->beneficiario = ($row[$startcol + 56] !== null) ? (string) $row[$startcol + 56] : null;
            $this->requirecontractor = ($row[$startcol + 57] !== null) ? (boolean) $row[$startcol + 57] : null;
            $this->purchasetype = ($row[$startcol + 58] !== null) ? (int) $row[$startcol + 58] : null;
            $this->constructiontype = ($row[$startcol + 59] !== null) ? (int) $row[$startcol + 59] : null;
            $this->requireexraresources = ($row[$startcol + 60] !== null) ? (boolean) $row[$startcol + 60] : null;
            $this->implementationpartner = ($row[$startcol + 61] !== null) ? (string) $row[$startcol + 61] : null;
            $this->riskfactors = ($row[$startcol + 62] !== null) ? (string) $row[$startcol + 62] : null;
            $this->ownfinance = ($row[$startcol + 63] !== null) ? (boolean) $row[$startcol + 63] : null;
            $this->provincefinance = ($row[$startcol + 64] !== null) ? (boolean) $row[$startcol + 64] : null;
            $this->nationfinance = ($row[$startcol + 65] !== null) ? (boolean) $row[$startcol + 65] : null;
            $this->otherfinance = ($row[$startcol + 66] !== null) ? (boolean) $row[$startcol + 66] : null;
            $this->financedetail = ($row[$startcol + 67] !== null) ? (string) $row[$startcol + 67] : null;
            $this->financeprogram = ($row[$startcol + 68] !== null) ? (string) $row[$startcol + 68] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 69; // 69 = ProjectLogPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating ProjectLog object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aProject !== null && $this->projectid !== $this->aProject->getId()) {
            $this->aProject = null;
        }
        if ($this->aObjective !== null && $this->objectiveid !== $this->aObjective->getId()) {
            $this->aObjective = null;
        }
        if ($this->aUser !== null && $this->userid !== $this->aUser->getId()) {
            $this->aUser = null;
        }
        if ($this->aPosition !== null && $this->responsiblecode !== $this->aPosition->getCode()) {
            $this->aPosition = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ProjectLogPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aProject = null;
            $this->aObjective = null;
            $this->aUser = null;
            $this->aPosition = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ProjectLogQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ProjectLogPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ProjectLogPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if ($this->aProject->isModified() || $this->aProject->isNew()) {
                    $affectedRows += $this->aProject->save($con);
                }
                $this->setProject($this->aProject);
            }

            if ($this->aObjective !== null) {
                if ($this->aObjective->isModified() || $this->aObjective->isNew()) {
                    $affectedRows += $this->aObjective->save($con);
                }
                $this->setObjective($this->aObjective);
            }

            if ($this->aUser !== null) {
                if ($this->aUser->isModified() || $this->aUser->isNew()) {
                    $affectedRows += $this->aUser->save($con);
                }
                $this->setUser($this->aUser);
            }

            if ($this->aPosition !== null) {
                if ($this->aPosition->isModified() || $this->aPosition->isNew()) {
                    $affectedRows += $this->aPosition->save($con);
                }
                $this->setPosition($this->aPosition);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ProjectLogPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ProjectLogPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ProjectLogPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ProjectLogPeer::PROJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`PROJECTID`';
        }
        if ($this->isColumnModified(ProjectLogPeer::OBJECTIVEID)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECTIVEID`';
        }
        if ($this->isColumnModified(ProjectLogPeer::CODE)) {
            $modifiedColumns[':p' . $index++]  = '`CODE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::CODEAUX)) {
            $modifiedColumns[':p' . $index++]  = '`CODEAUX`';
        }
        if ($this->isColumnModified(ProjectLogPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(ProjectLogPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(ProjectLogPeer::IMPACT)) {
            $modifiedColumns[':p' . $index++]  = '`IMPACT`';
        }
        if ($this->isColumnModified(ProjectLogPeer::UNIQUEGOAL)) {
            $modifiedColumns[':p' . $index++]  = '`UNIQUEGOAL`';
        }
        if ($this->isColumnModified(ProjectLogPeer::GOALEXPIRATIONDATE)) {
            $modifiedColumns[':p' . $index++]  = '`GOALEXPIRATIONDATE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::DATE)) {
            $modifiedColumns[':p' . $index++]  = '`DATE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::BUDGET)) {
            $modifiedColumns[':p' . $index++]  = '`BUDGET`';
        }
        if ($this->isColumnModified(ProjectLogPeer::EXCHANGERATE)) {
            $modifiedColumns[':p' . $index++]  = '`EXCHANGERATE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::VISIBILITY)) {
            $modifiedColumns[':p' . $index++]  = '`VISIBILITY`';
        }
        if ($this->isColumnModified(ProjectLogPeer::COORDINATENEED)) {
            $modifiedColumns[':p' . $index++]  = '`COORDINATENEED`';
        }
        if ($this->isColumnModified(ProjectLogPeer::FREQUENCY)) {
            $modifiedColumns[':p' . $index++]  = '`FREQUENCY`';
        }
        if ($this->isColumnModified(ProjectLogPeer::FINISHED)) {
            $modifiedColumns[':p' . $index++]  = '`FINISHED`';
        }
        if ($this->isColumnModified(ProjectLogPeer::NOTES)) {
            $modifiedColumns[':p' . $index++]  = '`NOTES`';
        }
        if ($this->isColumnModified(ProjectLogPeer::POSTALCODE)) {
            $modifiedColumns[':p' . $index++]  = '`POSTALCODE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::UNIQUEGOALNUMERIC)) {
            $modifiedColumns[':p' . $index++]  = '`UNIQUEGOALNUMERIC`';
        }
        if ($this->isColumnModified(ProjectLogPeer::GOALPROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`GOALPROGRESS`';
        }
        if ($this->isColumnModified(ProjectLogPeer::LATITUDE)) {
            $modifiedColumns[':p' . $index++]  = '`LATITUDE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::LONGITUDE)) {
            $modifiedColumns[':p' . $index++]  = '`LONGITUDE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::OLDID)) {
            $modifiedColumns[':p' . $index++]  = '`OLDID`';
        }
        if ($this->isColumnModified(ProjectLogPeer::REGIONID)) {
            $modifiedColumns[':p' . $index++]  = '`REGIONID`';
        }
        if ($this->isColumnModified(ProjectLogPeer::OLDREGIONID)) {
            $modifiedColumns[':p' . $index++]  = '`OLDREGIONID`';
        }
        if ($this->isColumnModified(ProjectLogPeer::LASTMODIFICATION)) {
            $modifiedColumns[':p' . $index++]  = '`LASTMODIFICATION`';
        }
        if ($this->isColumnModified(ProjectLogPeer::ADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`ADDRESS`';
        }
        if ($this->isColumnModified(ProjectLogPeer::PRIORITY)) {
            $modifiedColumns[':p' . $index++]  = '`PRIORITY`';
        }
        if ($this->isColumnModified(ProjectLogPeer::MODIFICATIONS)) {
            $modifiedColumns[':p' . $index++]  = '`MODIFICATIONS`';
        }
        if ($this->isColumnModified(ProjectLogPeer::CHANGES)) {
            $modifiedColumns[':p' . $index++]  = '`CHANGES`';
        }
        if ($this->isColumnModified(ProjectLogPeer::PLANNEDSTART)) {
            $modifiedColumns[':p' . $index++]  = '`PLANNEDSTART`';
        }
        if ($this->isColumnModified(ProjectLogPeer::PLANNEDEND)) {
            $modifiedColumns[':p' . $index++]  = '`PLANNEDEND`';
        }
        if ($this->isColumnModified(ProjectLogPeer::REALSTART)) {
            $modifiedColumns[':p' . $index++]  = '`REALSTART`';
        }
        if ($this->isColumnModified(ProjectLogPeer::REALEND)) {
            $modifiedColumns[':p' . $index++]  = '`REALEND`';
        }
        if ($this->isColumnModified(ProjectLogPeer::CANCELLED)) {
            $modifiedColumns[':p' . $index++]  = '`CANCELLED`';
        }
        if ($this->isColumnModified(ProjectLogPeer::ISCONSTRUCTION)) {
            $modifiedColumns[':p' . $index++]  = '`ISCONSTRUCTION`';
        }
        if ($this->isColumnModified(ProjectLogPeer::RELEVANCE)) {
            $modifiedColumns[':p' . $index++]  = '`RELEVANCE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::USERID)) {
            $modifiedColumns[':p' . $index++]  = '`USERID`';
        }
        if ($this->isColumnModified(ProjectLogPeer::USERBYAFFILIATESID)) {
            $modifiedColumns[':p' . $index++]  = '`USERBYAFFILIATESID`';
        }
        if ($this->isColumnModified(ProjectLogPeer::UPDATED)) {
            $modifiedColumns[':p' . $index++]  = '`UPDATED`';
        }
        if ($this->isColumnModified(ProjectLogPeer::RESPONSIBLECODE)) {
            $modifiedColumns[':p' . $index++]  = '`RESPONSIBLECODE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::STARTINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`STARTINGYEAR`';
        }
        if ($this->isColumnModified(ProjectLogPeer::ENDINGYEAR)) {
            $modifiedColumns[':p' . $index++]  = '`ENDINGYEAR`';
        }
        if ($this->isColumnModified(ProjectLogPeer::SUBPROJECT)) {
            $modifiedColumns[':p' . $index++]  = '`SUBPROJECT`';
        }
        if ($this->isColumnModified(ProjectLogPeer::ONGOING)) {
            $modifiedColumns[':p' . $index++]  = '`ONGOING`';
        }
        if ($this->isColumnModified(ProjectLogPeer::RELATEDAREAS)) {
            $modifiedColumns[':p' . $index++]  = '`RELATEDAREAS`';
        }
        if ($this->isColumnModified(ProjectLogPeer::GOAL)) {
            $modifiedColumns[':p' . $index++]  = '`GOAL`';
        }
        if ($this->isColumnModified(ProjectLogPeer::LEGAL)) {
            $modifiedColumns[':p' . $index++]  = '`LEGAL`';
        }
        if ($this->isColumnModified(ProjectLogPeer::EXECRESP)) {
            $modifiedColumns[':p' . $index++]  = '`EXECRESP`';
        }
        if ($this->isColumnModified(ProjectLogPeer::EXECTENURE)) {
            $modifiedColumns[':p' . $index++]  = '`EXECTENURE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::EXECDEPENDENCY)) {
            $modifiedColumns[':p' . $index++]  = '`EXECDEPENDENCY`';
        }
        if ($this->isColumnModified(ProjectLogPeer::EXECCONTACT)) {
            $modifiedColumns[':p' . $index++]  = '`EXECCONTACT`';
        }
        if ($this->isColumnModified(ProjectLogPeer::SUBSECRETARY)) {
            $modifiedColumns[':p' . $index++]  = '`SUBSECRETARY`';
        }
        if ($this->isColumnModified(ProjectLogPeer::BUDGETREQUESTED)) {
            $modifiedColumns[':p' . $index++]  = '`BUDGETREQUESTED`';
        }
        if ($this->isColumnModified(ProjectLogPeer::BUDGETSANCTIONED)) {
            $modifiedColumns[':p' . $index++]  = '`BUDGETSANCTIONED`';
        }
        if ($this->isColumnModified(ProjectLogPeer::BENEFICIARIO)) {
            $modifiedColumns[':p' . $index++]  = '`BENEFICIARIO`';
        }
        if ($this->isColumnModified(ProjectLogPeer::REQUIRECONTRACTOR)) {
            $modifiedColumns[':p' . $index++]  = '`REQUIRECONTRACTOR`';
        }
        if ($this->isColumnModified(ProjectLogPeer::PURCHASETYPE)) {
            $modifiedColumns[':p' . $index++]  = '`PURCHASETYPE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::CONSTRUCTIONTYPE)) {
            $modifiedColumns[':p' . $index++]  = '`CONSTRUCTIONTYPE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::REQUIREEXRARESOURCES)) {
            $modifiedColumns[':p' . $index++]  = '`REQUIREEXRARESOURCES`';
        }
        if ($this->isColumnModified(ProjectLogPeer::IMPLEMENTATIONPARTNER)) {
            $modifiedColumns[':p' . $index++]  = '`IMPLEMENTATIONPARTNER`';
        }
        if ($this->isColumnModified(ProjectLogPeer::RISKFACTORS)) {
            $modifiedColumns[':p' . $index++]  = '`RISKFACTORS`';
        }
        if ($this->isColumnModified(ProjectLogPeer::OWNFINANCE)) {
            $modifiedColumns[':p' . $index++]  = '`OWNFINANCE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::PROVINCEFINANCE)) {
            $modifiedColumns[':p' . $index++]  = '`PROVINCEFINANCE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::NATIONFINANCE)) {
            $modifiedColumns[':p' . $index++]  = '`NATIONFINANCE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::OTHERFINANCE)) {
            $modifiedColumns[':p' . $index++]  = '`OTHERFINANCE`';
        }
        if ($this->isColumnModified(ProjectLogPeer::FINANCEDETAIL)) {
            $modifiedColumns[':p' . $index++]  = '`FINANCEDETAIL`';
        }
        if ($this->isColumnModified(ProjectLogPeer::FINANCEPROGRAM)) {
            $modifiedColumns[':p' . $index++]  = '`FINANCEPROGRAM`';
        }

        $sql = sprintf(
            'INSERT INTO `projects_projectLog` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`PROJECTID`':
                        $stmt->bindValue($identifier, $this->projectid, PDO::PARAM_INT);
                        break;
                    case '`OBJECTIVEID`':
                        $stmt->bindValue($identifier, $this->objectiveid, PDO::PARAM_INT);
                        break;
                    case '`CODE`':
                        $stmt->bindValue($identifier, $this->code, PDO::PARAM_STR);
                        break;
                    case '`CODEAUX`':
                        $stmt->bindValue($identifier, $this->codeaux, PDO::PARAM_STR);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`IMPACT`':
                        $stmt->bindValue($identifier, $this->impact, PDO::PARAM_STR);
                        break;
                    case '`UNIQUEGOAL`':
                        $stmt->bindValue($identifier, $this->uniquegoal, PDO::PARAM_STR);
                        break;
                    case '`GOALEXPIRATIONDATE`':
                        $stmt->bindValue($identifier, $this->goalexpirationdate, PDO::PARAM_STR);
                        break;
                    case '`DATE`':
                        $stmt->bindValue($identifier, $this->date, PDO::PARAM_STR);
                        break;
                    case '`BUDGET`':
                        $stmt->bindValue($identifier, $this->budget, PDO::PARAM_STR);
                        break;
                    case '`EXCHANGERATE`':
                        $stmt->bindValue($identifier, $this->exchangerate, PDO::PARAM_STR);
                        break;
                    case '`VISIBILITY`':
                        $stmt->bindValue($identifier, $this->visibility, PDO::PARAM_INT);
                        break;
                    case '`COORDINATENEED`':
                        $stmt->bindValue($identifier, $this->coordinateneed, PDO::PARAM_STR);
                        break;
                    case '`FREQUENCY`':
                        $stmt->bindValue($identifier, $this->frequency, PDO::PARAM_STR);
                        break;
                    case '`FINISHED`':
                        $stmt->bindValue($identifier, (int) $this->finished, PDO::PARAM_INT);
                        break;
                    case '`NOTES`':
                        $stmt->bindValue($identifier, $this->notes, PDO::PARAM_STR);
                        break;
                    case '`POSTALCODE`':
                        $stmt->bindValue($identifier, $this->postalcode, PDO::PARAM_STR);
                        break;
                    case '`UNIQUEGOALNUMERIC`':
                        $stmt->bindValue($identifier, $this->uniquegoalnumeric, PDO::PARAM_INT);
                        break;
                    case '`GOALPROGRESS`':
                        $stmt->bindValue($identifier, $this->goalprogress, PDO::PARAM_INT);
                        break;
                    case '`LATITUDE`':
                        $stmt->bindValue($identifier, $this->latitude, PDO::PARAM_STR);
                        break;
                    case '`LONGITUDE`':
                        $stmt->bindValue($identifier, $this->longitude, PDO::PARAM_STR);
                        break;
                    case '`OLDID`':
                        $stmt->bindValue($identifier, $this->oldid, PDO::PARAM_INT);
                        break;
                    case '`REGIONID`':
                        $stmt->bindValue($identifier, $this->regionid, PDO::PARAM_INT);
                        break;
                    case '`OLDREGIONID`':
                        $stmt->bindValue($identifier, $this->oldregionid, PDO::PARAM_INT);
                        break;
                    case '`LASTMODIFICATION`':
                        $stmt->bindValue($identifier, $this->lastmodification, PDO::PARAM_STR);
                        break;
                    case '`ADDRESS`':
                        $stmt->bindValue($identifier, $this->address, PDO::PARAM_STR);
                        break;
                    case '`PRIORITY`':
                        $stmt->bindValue($identifier, $this->priority, PDO::PARAM_INT);
                        break;
                    case '`MODIFICATIONS`':
                        $stmt->bindValue($identifier, $this->modifications, PDO::PARAM_INT);
                        break;
                    case '`CHANGES`':
                        $stmt->bindValue($identifier, $this->changes, PDO::PARAM_INT);
                        break;
                    case '`PLANNEDSTART`':
                        $stmt->bindValue($identifier, $this->plannedstart, PDO::PARAM_STR);
                        break;
                    case '`PLANNEDEND`':
                        $stmt->bindValue($identifier, $this->plannedend, PDO::PARAM_STR);
                        break;
                    case '`REALSTART`':
                        $stmt->bindValue($identifier, $this->realstart, PDO::PARAM_STR);
                        break;
                    case '`REALEND`':
                        $stmt->bindValue($identifier, $this->realend, PDO::PARAM_STR);
                        break;
                    case '`CANCELLED`':
                        $stmt->bindValue($identifier, (int) $this->cancelled, PDO::PARAM_INT);
                        break;
                    case '`ISCONSTRUCTION`':
                        $stmt->bindValue($identifier, (int) $this->isconstruction, PDO::PARAM_INT);
                        break;
                    case '`RELEVANCE`':
                        $stmt->bindValue($identifier, $this->relevance, PDO::PARAM_STR);
                        break;
                    case '`USERID`':
                        $stmt->bindValue($identifier, $this->userid, PDO::PARAM_INT);
                        break;
                    case '`USERBYAFFILIATESID`':
                        $stmt->bindValue($identifier, $this->userbyaffiliatesid, PDO::PARAM_INT);
                        break;
                    case '`UPDATED`':
                        $stmt->bindValue($identifier, $this->updated, PDO::PARAM_STR);
                        break;
                    case '`RESPONSIBLECODE`':
                        $stmt->bindValue($identifier, $this->responsiblecode, PDO::PARAM_INT);
                        break;
                    case '`STARTINGYEAR`':
                        $stmt->bindValue($identifier, $this->startingyear, PDO::PARAM_INT);
                        break;
                    case '`ENDINGYEAR`':
                        $stmt->bindValue($identifier, $this->endingyear, PDO::PARAM_INT);
                        break;
                    case '`SUBPROJECT`':
                        $stmt->bindValue($identifier, $this->subproject, PDO::PARAM_STR);
                        break;
                    case '`ONGOING`':
                        $stmt->bindValue($identifier, $this->ongoing, PDO::PARAM_STR);
                        break;
                    case '`RELATEDAREAS`':
                        $stmt->bindValue($identifier, $this->relatedareas, PDO::PARAM_STR);
                        break;
                    case '`GOAL`':
                        $stmt->bindValue($identifier, $this->goal, PDO::PARAM_STR);
                        break;
                    case '`LEGAL`':
                        $stmt->bindValue($identifier, $this->legal, PDO::PARAM_STR);
                        break;
                    case '`EXECRESP`':
                        $stmt->bindValue($identifier, $this->execresp, PDO::PARAM_STR);
                        break;
                    case '`EXECTENURE`':
                        $stmt->bindValue($identifier, $this->exectenure, PDO::PARAM_STR);
                        break;
                    case '`EXECDEPENDENCY`':
                        $stmt->bindValue($identifier, $this->execdependency, PDO::PARAM_STR);
                        break;
                    case '`EXECCONTACT`':
                        $stmt->bindValue($identifier, $this->execcontact, PDO::PARAM_STR);
                        break;
                    case '`SUBSECRETARY`':
                        $stmt->bindValue($identifier, $this->subsecretary, PDO::PARAM_STR);
                        break;
                    case '`BUDGETREQUESTED`':
                        $stmt->bindValue($identifier, $this->budgetrequested, PDO::PARAM_STR);
                        break;
                    case '`BUDGETSANCTIONED`':
                        $stmt->bindValue($identifier, $this->budgetsanctioned, PDO::PARAM_STR);
                        break;
                    case '`BENEFICIARIO`':
                        $stmt->bindValue($identifier, $this->beneficiario, PDO::PARAM_STR);
                        break;
                    case '`REQUIRECONTRACTOR`':
                        $stmt->bindValue($identifier, (int) $this->requirecontractor, PDO::PARAM_INT);
                        break;
                    case '`PURCHASETYPE`':
                        $stmt->bindValue($identifier, $this->purchasetype, PDO::PARAM_INT);
                        break;
                    case '`CONSTRUCTIONTYPE`':
                        $stmt->bindValue($identifier, $this->constructiontype, PDO::PARAM_INT);
                        break;
                    case '`REQUIREEXRARESOURCES`':
                        $stmt->bindValue($identifier, (int) $this->requireexraresources, PDO::PARAM_INT);
                        break;
                    case '`IMPLEMENTATIONPARTNER`':
                        $stmt->bindValue($identifier, $this->implementationpartner, PDO::PARAM_STR);
                        break;
                    case '`RISKFACTORS`':
                        $stmt->bindValue($identifier, $this->riskfactors, PDO::PARAM_STR);
                        break;
                    case '`OWNFINANCE`':
                        $stmt->bindValue($identifier, (int) $this->ownfinance, PDO::PARAM_INT);
                        break;
                    case '`PROVINCEFINANCE`':
                        $stmt->bindValue($identifier, (int) $this->provincefinance, PDO::PARAM_INT);
                        break;
                    case '`NATIONFINANCE`':
                        $stmt->bindValue($identifier, (int) $this->nationfinance, PDO::PARAM_INT);
                        break;
                    case '`OTHERFINANCE`':
                        $stmt->bindValue($identifier, (int) $this->otherfinance, PDO::PARAM_INT);
                        break;
                    case '`FINANCEDETAIL`':
                        $stmt->bindValue($identifier, $this->financedetail, PDO::PARAM_STR);
                        break;
                    case '`FINANCEPROGRAM`':
                        $stmt->bindValue($identifier, $this->financeprogram, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if (!$this->aProject->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aProject->getValidationFailures());
                }
            }

            if ($this->aObjective !== null) {
                if (!$this->aObjective->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aObjective->getValidationFailures());
                }
            }

            if ($this->aUser !== null) {
                if (!$this->aUser->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aUser->getValidationFailures());
                }
            }

            if ($this->aPosition !== null) {
                if (!$this->aPosition->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPosition->getValidationFailures());
                }
            }


            if (($retval = ProjectLogPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }



            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectLogPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getProjectid();
                break;
            case 2:
                return $this->getObjectiveid();
                break;
            case 3:
                return $this->getCode();
                break;
            case 4:
                return $this->getCodeaux();
                break;
            case 5:
                return $this->getName();
                break;
            case 6:
                return $this->getDescription();
                break;
            case 7:
                return $this->getImpact();
                break;
            case 8:
                return $this->getUniquegoal();
                break;
            case 9:
                return $this->getGoalexpirationdate();
                break;
            case 10:
                return $this->getDate();
                break;
            case 11:
                return $this->getBudget();
                break;
            case 12:
                return $this->getExchangerate();
                break;
            case 13:
                return $this->getVisibility();
                break;
            case 14:
                return $this->getCoordinateneed();
                break;
            case 15:
                return $this->getFrequency();
                break;
            case 16:
                return $this->getFinished();
                break;
            case 17:
                return $this->getNotes();
                break;
            case 18:
                return $this->getPostalcode();
                break;
            case 19:
                return $this->getUniquegoalnumeric();
                break;
            case 20:
                return $this->getGoalprogress();
                break;
            case 21:
                return $this->getLatitude();
                break;
            case 22:
                return $this->getLongitude();
                break;
            case 23:
                return $this->getOldid();
                break;
            case 24:
                return $this->getRegionid();
                break;
            case 25:
                return $this->getOldregionid();
                break;
            case 26:
                return $this->getLastmodification();
                break;
            case 27:
                return $this->getAddress();
                break;
            case 28:
                return $this->getPriority();
                break;
            case 29:
                return $this->getModifications();
                break;
            case 30:
                return $this->getChanges();
                break;
            case 31:
                return $this->getPlannedstart();
                break;
            case 32:
                return $this->getPlannedend();
                break;
            case 33:
                return $this->getRealstart();
                break;
            case 34:
                return $this->getRealend();
                break;
            case 35:
                return $this->getCancelled();
                break;
            case 36:
                return $this->getIsconstruction();
                break;
            case 37:
                return $this->getRelevance();
                break;
            case 38:
                return $this->getUserid();
                break;
            case 39:
                return $this->getUserbyaffiliatesid();
                break;
            case 40:
                return $this->getUpdated();
                break;
            case 41:
                return $this->getResponsiblecode();
                break;
            case 42:
                return $this->getStartingyear();
                break;
            case 43:
                return $this->getEndingyear();
                break;
            case 44:
                return $this->getSubproject();
                break;
            case 45:
                return $this->getOngoing();
                break;
            case 46:
                return $this->getRelatedareas();
                break;
            case 47:
                return $this->getGoal();
                break;
            case 48:
                return $this->getLegal();
                break;
            case 49:
                return $this->getExecresp();
                break;
            case 50:
                return $this->getExectenure();
                break;
            case 51:
                return $this->getExecdependency();
                break;
            case 52:
                return $this->getExeccontact();
                break;
            case 53:
                return $this->getSubsecretary();
                break;
            case 54:
                return $this->getBudgetrequested();
                break;
            case 55:
                return $this->getBudgetsanctioned();
                break;
            case 56:
                return $this->getBeneficiario();
                break;
            case 57:
                return $this->getRequirecontractor();
                break;
            case 58:
                return $this->getPurchasetype();
                break;
            case 59:
                return $this->getConstructiontype();
                break;
            case 60:
                return $this->getRequireexraresources();
                break;
            case 61:
                return $this->getImplementationpartner();
                break;
            case 62:
                return $this->getRiskfactors();
                break;
            case 63:
                return $this->getOwnfinance();
                break;
            case 64:
                return $this->getProvincefinance();
                break;
            case 65:
                return $this->getNationfinance();
                break;
            case 66:
                return $this->getOtherfinance();
                break;
            case 67:
                return $this->getFinancedetail();
                break;
            case 68:
                return $this->getFinanceprogram();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['ProjectLog'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['ProjectLog'][$this->getPrimaryKey()] = true;
        $keys = ProjectLogPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getProjectid(),
            $keys[2] => $this->getObjectiveid(),
            $keys[3] => $this->getCode(),
            $keys[4] => $this->getCodeaux(),
            $keys[5] => $this->getName(),
            $keys[6] => $this->getDescription(),
            $keys[7] => $this->getImpact(),
            $keys[8] => $this->getUniquegoal(),
            $keys[9] => $this->getGoalexpirationdate(),
            $keys[10] => $this->getDate(),
            $keys[11] => $this->getBudget(),
            $keys[12] => $this->getExchangerate(),
            $keys[13] => $this->getVisibility(),
            $keys[14] => $this->getCoordinateneed(),
            $keys[15] => $this->getFrequency(),
            $keys[16] => $this->getFinished(),
            $keys[17] => $this->getNotes(),
            $keys[18] => $this->getPostalcode(),
            $keys[19] => $this->getUniquegoalnumeric(),
            $keys[20] => $this->getGoalprogress(),
            $keys[21] => $this->getLatitude(),
            $keys[22] => $this->getLongitude(),
            $keys[23] => $this->getOldid(),
            $keys[24] => $this->getRegionid(),
            $keys[25] => $this->getOldregionid(),
            $keys[26] => $this->getLastmodification(),
            $keys[27] => $this->getAddress(),
            $keys[28] => $this->getPriority(),
            $keys[29] => $this->getModifications(),
            $keys[30] => $this->getChanges(),
            $keys[31] => $this->getPlannedstart(),
            $keys[32] => $this->getPlannedend(),
            $keys[33] => $this->getRealstart(),
            $keys[34] => $this->getRealend(),
            $keys[35] => $this->getCancelled(),
            $keys[36] => $this->getIsconstruction(),
            $keys[37] => $this->getRelevance(),
            $keys[38] => $this->getUserid(),
            $keys[39] => $this->getUserbyaffiliatesid(),
            $keys[40] => $this->getUpdated(),
            $keys[41] => $this->getResponsiblecode(),
            $keys[42] => $this->getStartingyear(),
            $keys[43] => $this->getEndingyear(),
            $keys[44] => $this->getSubproject(),
            $keys[45] => $this->getOngoing(),
            $keys[46] => $this->getRelatedareas(),
            $keys[47] => $this->getGoal(),
            $keys[48] => $this->getLegal(),
            $keys[49] => $this->getExecresp(),
            $keys[50] => $this->getExectenure(),
            $keys[51] => $this->getExecdependency(),
            $keys[52] => $this->getExeccontact(),
            $keys[53] => $this->getSubsecretary(),
            $keys[54] => $this->getBudgetrequested(),
            $keys[55] => $this->getBudgetsanctioned(),
            $keys[56] => $this->getBeneficiario(),
            $keys[57] => $this->getRequirecontractor(),
            $keys[58] => $this->getPurchasetype(),
            $keys[59] => $this->getConstructiontype(),
            $keys[60] => $this->getRequireexraresources(),
            $keys[61] => $this->getImplementationpartner(),
            $keys[62] => $this->getRiskfactors(),
            $keys[63] => $this->getOwnfinance(),
            $keys[64] => $this->getProvincefinance(),
            $keys[65] => $this->getNationfinance(),
            $keys[66] => $this->getOtherfinance(),
            $keys[67] => $this->getFinancedetail(),
            $keys[68] => $this->getFinanceprogram(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aProject) {
                $result['Project'] = $this->aProject->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aObjective) {
                $result['Objective'] = $this->aObjective->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aUser) {
                $result['User'] = $this->aUser->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPosition) {
                $result['Position'] = $this->aPosition->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ProjectLogPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setProjectid($value);
                break;
            case 2:
                $this->setObjectiveid($value);
                break;
            case 3:
                $this->setCode($value);
                break;
            case 4:
                $this->setCodeaux($value);
                break;
            case 5:
                $this->setName($value);
                break;
            case 6:
                $this->setDescription($value);
                break;
            case 7:
                $this->setImpact($value);
                break;
            case 8:
                $this->setUniquegoal($value);
                break;
            case 9:
                $this->setGoalexpirationdate($value);
                break;
            case 10:
                $this->setDate($value);
                break;
            case 11:
                $this->setBudget($value);
                break;
            case 12:
                $this->setExchangerate($value);
                break;
            case 13:
                $this->setVisibility($value);
                break;
            case 14:
                $this->setCoordinateneed($value);
                break;
            case 15:
                $this->setFrequency($value);
                break;
            case 16:
                $this->setFinished($value);
                break;
            case 17:
                $this->setNotes($value);
                break;
            case 18:
                $this->setPostalcode($value);
                break;
            case 19:
                $this->setUniquegoalnumeric($value);
                break;
            case 20:
                $this->setGoalprogress($value);
                break;
            case 21:
                $this->setLatitude($value);
                break;
            case 22:
                $this->setLongitude($value);
                break;
            case 23:
                $this->setOldid($value);
                break;
            case 24:
                $this->setRegionid($value);
                break;
            case 25:
                $this->setOldregionid($value);
                break;
            case 26:
                $this->setLastmodification($value);
                break;
            case 27:
                $this->setAddress($value);
                break;
            case 28:
                $this->setPriority($value);
                break;
            case 29:
                $this->setModifications($value);
                break;
            case 30:
                $this->setChanges($value);
                break;
            case 31:
                $this->setPlannedstart($value);
                break;
            case 32:
                $this->setPlannedend($value);
                break;
            case 33:
                $this->setRealstart($value);
                break;
            case 34:
                $this->setRealend($value);
                break;
            case 35:
                $this->setCancelled($value);
                break;
            case 36:
                $this->setIsconstruction($value);
                break;
            case 37:
                $this->setRelevance($value);
                break;
            case 38:
                $this->setUserid($value);
                break;
            case 39:
                $this->setUserbyaffiliatesid($value);
                break;
            case 40:
                $this->setUpdated($value);
                break;
            case 41:
                $this->setResponsiblecode($value);
                break;
            case 42:
                $this->setStartingyear($value);
                break;
            case 43:
                $this->setEndingyear($value);
                break;
            case 44:
                $this->setSubproject($value);
                break;
            case 45:
                $this->setOngoing($value);
                break;
            case 46:
                $this->setRelatedareas($value);
                break;
            case 47:
                $this->setGoal($value);
                break;
            case 48:
                $this->setLegal($value);
                break;
            case 49:
                $this->setExecresp($value);
                break;
            case 50:
                $this->setExectenure($value);
                break;
            case 51:
                $this->setExecdependency($value);
                break;
            case 52:
                $this->setExeccontact($value);
                break;
            case 53:
                $this->setSubsecretary($value);
                break;
            case 54:
                $this->setBudgetrequested($value);
                break;
            case 55:
                $this->setBudgetsanctioned($value);
                break;
            case 56:
                $this->setBeneficiario($value);
                break;
            case 57:
                $this->setRequirecontractor($value);
                break;
            case 58:
                $this->setPurchasetype($value);
                break;
            case 59:
                $this->setConstructiontype($value);
                break;
            case 60:
                $this->setRequireexraresources($value);
                break;
            case 61:
                $this->setImplementationpartner($value);
                break;
            case 62:
                $this->setRiskfactors($value);
                break;
            case 63:
                $this->setOwnfinance($value);
                break;
            case 64:
                $this->setProvincefinance($value);
                break;
            case 65:
                $this->setNationfinance($value);
                break;
            case 66:
                $this->setOtherfinance($value);
                break;
            case 67:
                $this->setFinancedetail($value);
                break;
            case 68:
                $this->setFinanceprogram($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ProjectLogPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setProjectid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setObjectiveid($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setCode($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setCodeaux($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setName($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setDescription($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setImpact($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setUniquegoal($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setGoalexpirationdate($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setDate($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setBudget($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setExchangerate($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setVisibility($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setCoordinateneed($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setFrequency($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setFinished($arr[$keys[16]]);
        if (array_key_exists($keys[17], $arr)) $this->setNotes($arr[$keys[17]]);
        if (array_key_exists($keys[18], $arr)) $this->setPostalcode($arr[$keys[18]]);
        if (array_key_exists($keys[19], $arr)) $this->setUniquegoalnumeric($arr[$keys[19]]);
        if (array_key_exists($keys[20], $arr)) $this->setGoalprogress($arr[$keys[20]]);
        if (array_key_exists($keys[21], $arr)) $this->setLatitude($arr[$keys[21]]);
        if (array_key_exists($keys[22], $arr)) $this->setLongitude($arr[$keys[22]]);
        if (array_key_exists($keys[23], $arr)) $this->setOldid($arr[$keys[23]]);
        if (array_key_exists($keys[24], $arr)) $this->setRegionid($arr[$keys[24]]);
        if (array_key_exists($keys[25], $arr)) $this->setOldregionid($arr[$keys[25]]);
        if (array_key_exists($keys[26], $arr)) $this->setLastmodification($arr[$keys[26]]);
        if (array_key_exists($keys[27], $arr)) $this->setAddress($arr[$keys[27]]);
        if (array_key_exists($keys[28], $arr)) $this->setPriority($arr[$keys[28]]);
        if (array_key_exists($keys[29], $arr)) $this->setModifications($arr[$keys[29]]);
        if (array_key_exists($keys[30], $arr)) $this->setChanges($arr[$keys[30]]);
        if (array_key_exists($keys[31], $arr)) $this->setPlannedstart($arr[$keys[31]]);
        if (array_key_exists($keys[32], $arr)) $this->setPlannedend($arr[$keys[32]]);
        if (array_key_exists($keys[33], $arr)) $this->setRealstart($arr[$keys[33]]);
        if (array_key_exists($keys[34], $arr)) $this->setRealend($arr[$keys[34]]);
        if (array_key_exists($keys[35], $arr)) $this->setCancelled($arr[$keys[35]]);
        if (array_key_exists($keys[36], $arr)) $this->setIsconstruction($arr[$keys[36]]);
        if (array_key_exists($keys[37], $arr)) $this->setRelevance($arr[$keys[37]]);
        if (array_key_exists($keys[38], $arr)) $this->setUserid($arr[$keys[38]]);
        if (array_key_exists($keys[39], $arr)) $this->setUserbyaffiliatesid($arr[$keys[39]]);
        if (array_key_exists($keys[40], $arr)) $this->setUpdated($arr[$keys[40]]);
        if (array_key_exists($keys[41], $arr)) $this->setResponsiblecode($arr[$keys[41]]);
        if (array_key_exists($keys[42], $arr)) $this->setStartingyear($arr[$keys[42]]);
        if (array_key_exists($keys[43], $arr)) $this->setEndingyear($arr[$keys[43]]);
        if (array_key_exists($keys[44], $arr)) $this->setSubproject($arr[$keys[44]]);
        if (array_key_exists($keys[45], $arr)) $this->setOngoing($arr[$keys[45]]);
        if (array_key_exists($keys[46], $arr)) $this->setRelatedareas($arr[$keys[46]]);
        if (array_key_exists($keys[47], $arr)) $this->setGoal($arr[$keys[47]]);
        if (array_key_exists($keys[48], $arr)) $this->setLegal($arr[$keys[48]]);
        if (array_key_exists($keys[49], $arr)) $this->setExecresp($arr[$keys[49]]);
        if (array_key_exists($keys[50], $arr)) $this->setExectenure($arr[$keys[50]]);
        if (array_key_exists($keys[51], $arr)) $this->setExecdependency($arr[$keys[51]]);
        if (array_key_exists($keys[52], $arr)) $this->setExeccontact($arr[$keys[52]]);
        if (array_key_exists($keys[53], $arr)) $this->setSubsecretary($arr[$keys[53]]);
        if (array_key_exists($keys[54], $arr)) $this->setBudgetrequested($arr[$keys[54]]);
        if (array_key_exists($keys[55], $arr)) $this->setBudgetsanctioned($arr[$keys[55]]);
        if (array_key_exists($keys[56], $arr)) $this->setBeneficiario($arr[$keys[56]]);
        if (array_key_exists($keys[57], $arr)) $this->setRequirecontractor($arr[$keys[57]]);
        if (array_key_exists($keys[58], $arr)) $this->setPurchasetype($arr[$keys[58]]);
        if (array_key_exists($keys[59], $arr)) $this->setConstructiontype($arr[$keys[59]]);
        if (array_key_exists($keys[60], $arr)) $this->setRequireexraresources($arr[$keys[60]]);
        if (array_key_exists($keys[61], $arr)) $this->setImplementationpartner($arr[$keys[61]]);
        if (array_key_exists($keys[62], $arr)) $this->setRiskfactors($arr[$keys[62]]);
        if (array_key_exists($keys[63], $arr)) $this->setOwnfinance($arr[$keys[63]]);
        if (array_key_exists($keys[64], $arr)) $this->setProvincefinance($arr[$keys[64]]);
        if (array_key_exists($keys[65], $arr)) $this->setNationfinance($arr[$keys[65]]);
        if (array_key_exists($keys[66], $arr)) $this->setOtherfinance($arr[$keys[66]]);
        if (array_key_exists($keys[67], $arr)) $this->setFinancedetail($arr[$keys[67]]);
        if (array_key_exists($keys[68], $arr)) $this->setFinanceprogram($arr[$keys[68]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ProjectLogPeer::DATABASE_NAME);

        if ($this->isColumnModified(ProjectLogPeer::ID)) $criteria->add(ProjectLogPeer::ID, $this->id);
        if ($this->isColumnModified(ProjectLogPeer::PROJECTID)) $criteria->add(ProjectLogPeer::PROJECTID, $this->projectid);
        if ($this->isColumnModified(ProjectLogPeer::OBJECTIVEID)) $criteria->add(ProjectLogPeer::OBJECTIVEID, $this->objectiveid);
        if ($this->isColumnModified(ProjectLogPeer::CODE)) $criteria->add(ProjectLogPeer::CODE, $this->code);
        if ($this->isColumnModified(ProjectLogPeer::CODEAUX)) $criteria->add(ProjectLogPeer::CODEAUX, $this->codeaux);
        if ($this->isColumnModified(ProjectLogPeer::NAME)) $criteria->add(ProjectLogPeer::NAME, $this->name);
        if ($this->isColumnModified(ProjectLogPeer::DESCRIPTION)) $criteria->add(ProjectLogPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(ProjectLogPeer::IMPACT)) $criteria->add(ProjectLogPeer::IMPACT, $this->impact);
        if ($this->isColumnModified(ProjectLogPeer::UNIQUEGOAL)) $criteria->add(ProjectLogPeer::UNIQUEGOAL, $this->uniquegoal);
        if ($this->isColumnModified(ProjectLogPeer::GOALEXPIRATIONDATE)) $criteria->add(ProjectLogPeer::GOALEXPIRATIONDATE, $this->goalexpirationdate);
        if ($this->isColumnModified(ProjectLogPeer::DATE)) $criteria->add(ProjectLogPeer::DATE, $this->date);
        if ($this->isColumnModified(ProjectLogPeer::BUDGET)) $criteria->add(ProjectLogPeer::BUDGET, $this->budget);
        if ($this->isColumnModified(ProjectLogPeer::EXCHANGERATE)) $criteria->add(ProjectLogPeer::EXCHANGERATE, $this->exchangerate);
        if ($this->isColumnModified(ProjectLogPeer::VISIBILITY)) $criteria->add(ProjectLogPeer::VISIBILITY, $this->visibility);
        if ($this->isColumnModified(ProjectLogPeer::COORDINATENEED)) $criteria->add(ProjectLogPeer::COORDINATENEED, $this->coordinateneed);
        if ($this->isColumnModified(ProjectLogPeer::FREQUENCY)) $criteria->add(ProjectLogPeer::FREQUENCY, $this->frequency);
        if ($this->isColumnModified(ProjectLogPeer::FINISHED)) $criteria->add(ProjectLogPeer::FINISHED, $this->finished);
        if ($this->isColumnModified(ProjectLogPeer::NOTES)) $criteria->add(ProjectLogPeer::NOTES, $this->notes);
        if ($this->isColumnModified(ProjectLogPeer::POSTALCODE)) $criteria->add(ProjectLogPeer::POSTALCODE, $this->postalcode);
        if ($this->isColumnModified(ProjectLogPeer::UNIQUEGOALNUMERIC)) $criteria->add(ProjectLogPeer::UNIQUEGOALNUMERIC, $this->uniquegoalnumeric);
        if ($this->isColumnModified(ProjectLogPeer::GOALPROGRESS)) $criteria->add(ProjectLogPeer::GOALPROGRESS, $this->goalprogress);
        if ($this->isColumnModified(ProjectLogPeer::LATITUDE)) $criteria->add(ProjectLogPeer::LATITUDE, $this->latitude);
        if ($this->isColumnModified(ProjectLogPeer::LONGITUDE)) $criteria->add(ProjectLogPeer::LONGITUDE, $this->longitude);
        if ($this->isColumnModified(ProjectLogPeer::OLDID)) $criteria->add(ProjectLogPeer::OLDID, $this->oldid);
        if ($this->isColumnModified(ProjectLogPeer::REGIONID)) $criteria->add(ProjectLogPeer::REGIONID, $this->regionid);
        if ($this->isColumnModified(ProjectLogPeer::OLDREGIONID)) $criteria->add(ProjectLogPeer::OLDREGIONID, $this->oldregionid);
        if ($this->isColumnModified(ProjectLogPeer::LASTMODIFICATION)) $criteria->add(ProjectLogPeer::LASTMODIFICATION, $this->lastmodification);
        if ($this->isColumnModified(ProjectLogPeer::ADDRESS)) $criteria->add(ProjectLogPeer::ADDRESS, $this->address);
        if ($this->isColumnModified(ProjectLogPeer::PRIORITY)) $criteria->add(ProjectLogPeer::PRIORITY, $this->priority);
        if ($this->isColumnModified(ProjectLogPeer::MODIFICATIONS)) $criteria->add(ProjectLogPeer::MODIFICATIONS, $this->modifications);
        if ($this->isColumnModified(ProjectLogPeer::CHANGES)) $criteria->add(ProjectLogPeer::CHANGES, $this->changes);
        if ($this->isColumnModified(ProjectLogPeer::PLANNEDSTART)) $criteria->add(ProjectLogPeer::PLANNEDSTART, $this->plannedstart);
        if ($this->isColumnModified(ProjectLogPeer::PLANNEDEND)) $criteria->add(ProjectLogPeer::PLANNEDEND, $this->plannedend);
        if ($this->isColumnModified(ProjectLogPeer::REALSTART)) $criteria->add(ProjectLogPeer::REALSTART, $this->realstart);
        if ($this->isColumnModified(ProjectLogPeer::REALEND)) $criteria->add(ProjectLogPeer::REALEND, $this->realend);
        if ($this->isColumnModified(ProjectLogPeer::CANCELLED)) $criteria->add(ProjectLogPeer::CANCELLED, $this->cancelled);
        if ($this->isColumnModified(ProjectLogPeer::ISCONSTRUCTION)) $criteria->add(ProjectLogPeer::ISCONSTRUCTION, $this->isconstruction);
        if ($this->isColumnModified(ProjectLogPeer::RELEVANCE)) $criteria->add(ProjectLogPeer::RELEVANCE, $this->relevance);
        if ($this->isColumnModified(ProjectLogPeer::USERID)) $criteria->add(ProjectLogPeer::USERID, $this->userid);
        if ($this->isColumnModified(ProjectLogPeer::USERBYAFFILIATESID)) $criteria->add(ProjectLogPeer::USERBYAFFILIATESID, $this->userbyaffiliatesid);
        if ($this->isColumnModified(ProjectLogPeer::UPDATED)) $criteria->add(ProjectLogPeer::UPDATED, $this->updated);
        if ($this->isColumnModified(ProjectLogPeer::RESPONSIBLECODE)) $criteria->add(ProjectLogPeer::RESPONSIBLECODE, $this->responsiblecode);
        if ($this->isColumnModified(ProjectLogPeer::STARTINGYEAR)) $criteria->add(ProjectLogPeer::STARTINGYEAR, $this->startingyear);
        if ($this->isColumnModified(ProjectLogPeer::ENDINGYEAR)) $criteria->add(ProjectLogPeer::ENDINGYEAR, $this->endingyear);
        if ($this->isColumnModified(ProjectLogPeer::SUBPROJECT)) $criteria->add(ProjectLogPeer::SUBPROJECT, $this->subproject);
        if ($this->isColumnModified(ProjectLogPeer::ONGOING)) $criteria->add(ProjectLogPeer::ONGOING, $this->ongoing);
        if ($this->isColumnModified(ProjectLogPeer::RELATEDAREAS)) $criteria->add(ProjectLogPeer::RELATEDAREAS, $this->relatedareas);
        if ($this->isColumnModified(ProjectLogPeer::GOAL)) $criteria->add(ProjectLogPeer::GOAL, $this->goal);
        if ($this->isColumnModified(ProjectLogPeer::LEGAL)) $criteria->add(ProjectLogPeer::LEGAL, $this->legal);
        if ($this->isColumnModified(ProjectLogPeer::EXECRESP)) $criteria->add(ProjectLogPeer::EXECRESP, $this->execresp);
        if ($this->isColumnModified(ProjectLogPeer::EXECTENURE)) $criteria->add(ProjectLogPeer::EXECTENURE, $this->exectenure);
        if ($this->isColumnModified(ProjectLogPeer::EXECDEPENDENCY)) $criteria->add(ProjectLogPeer::EXECDEPENDENCY, $this->execdependency);
        if ($this->isColumnModified(ProjectLogPeer::EXECCONTACT)) $criteria->add(ProjectLogPeer::EXECCONTACT, $this->execcontact);
        if ($this->isColumnModified(ProjectLogPeer::SUBSECRETARY)) $criteria->add(ProjectLogPeer::SUBSECRETARY, $this->subsecretary);
        if ($this->isColumnModified(ProjectLogPeer::BUDGETREQUESTED)) $criteria->add(ProjectLogPeer::BUDGETREQUESTED, $this->budgetrequested);
        if ($this->isColumnModified(ProjectLogPeer::BUDGETSANCTIONED)) $criteria->add(ProjectLogPeer::BUDGETSANCTIONED, $this->budgetsanctioned);
        if ($this->isColumnModified(ProjectLogPeer::BENEFICIARIO)) $criteria->add(ProjectLogPeer::BENEFICIARIO, $this->beneficiario);
        if ($this->isColumnModified(ProjectLogPeer::REQUIRECONTRACTOR)) $criteria->add(ProjectLogPeer::REQUIRECONTRACTOR, $this->requirecontractor);
        if ($this->isColumnModified(ProjectLogPeer::PURCHASETYPE)) $criteria->add(ProjectLogPeer::PURCHASETYPE, $this->purchasetype);
        if ($this->isColumnModified(ProjectLogPeer::CONSTRUCTIONTYPE)) $criteria->add(ProjectLogPeer::CONSTRUCTIONTYPE, $this->constructiontype);
        if ($this->isColumnModified(ProjectLogPeer::REQUIREEXRARESOURCES)) $criteria->add(ProjectLogPeer::REQUIREEXRARESOURCES, $this->requireexraresources);
        if ($this->isColumnModified(ProjectLogPeer::IMPLEMENTATIONPARTNER)) $criteria->add(ProjectLogPeer::IMPLEMENTATIONPARTNER, $this->implementationpartner);
        if ($this->isColumnModified(ProjectLogPeer::RISKFACTORS)) $criteria->add(ProjectLogPeer::RISKFACTORS, $this->riskfactors);
        if ($this->isColumnModified(ProjectLogPeer::OWNFINANCE)) $criteria->add(ProjectLogPeer::OWNFINANCE, $this->ownfinance);
        if ($this->isColumnModified(ProjectLogPeer::PROVINCEFINANCE)) $criteria->add(ProjectLogPeer::PROVINCEFINANCE, $this->provincefinance);
        if ($this->isColumnModified(ProjectLogPeer::NATIONFINANCE)) $criteria->add(ProjectLogPeer::NATIONFINANCE, $this->nationfinance);
        if ($this->isColumnModified(ProjectLogPeer::OTHERFINANCE)) $criteria->add(ProjectLogPeer::OTHERFINANCE, $this->otherfinance);
        if ($this->isColumnModified(ProjectLogPeer::FINANCEDETAIL)) $criteria->add(ProjectLogPeer::FINANCEDETAIL, $this->financedetail);
        if ($this->isColumnModified(ProjectLogPeer::FINANCEPROGRAM)) $criteria->add(ProjectLogPeer::FINANCEPROGRAM, $this->financeprogram);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ProjectLogPeer::DATABASE_NAME);
        $criteria->add(ProjectLogPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of ProjectLog (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setProjectid($this->getProjectid());
        $copyObj->setObjectiveid($this->getObjectiveid());
        $copyObj->setCode($this->getCode());
        $copyObj->setCodeaux($this->getCodeaux());
        $copyObj->setName($this->getName());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setImpact($this->getImpact());
        $copyObj->setUniquegoal($this->getUniquegoal());
        $copyObj->setGoalexpirationdate($this->getGoalexpirationdate());
        $copyObj->setDate($this->getDate());
        $copyObj->setBudget($this->getBudget());
        $copyObj->setExchangerate($this->getExchangerate());
        $copyObj->setVisibility($this->getVisibility());
        $copyObj->setCoordinateneed($this->getCoordinateneed());
        $copyObj->setFrequency($this->getFrequency());
        $copyObj->setFinished($this->getFinished());
        $copyObj->setNotes($this->getNotes());
        $copyObj->setPostalcode($this->getPostalcode());
        $copyObj->setUniquegoalnumeric($this->getUniquegoalnumeric());
        $copyObj->setGoalprogress($this->getGoalprogress());
        $copyObj->setLatitude($this->getLatitude());
        $copyObj->setLongitude($this->getLongitude());
        $copyObj->setOldid($this->getOldid());
        $copyObj->setRegionid($this->getRegionid());
        $copyObj->setOldregionid($this->getOldregionid());
        $copyObj->setLastmodification($this->getLastmodification());
        $copyObj->setAddress($this->getAddress());
        $copyObj->setPriority($this->getPriority());
        $copyObj->setModifications($this->getModifications());
        $copyObj->setChanges($this->getChanges());
        $copyObj->setPlannedstart($this->getPlannedstart());
        $copyObj->setPlannedend($this->getPlannedend());
        $copyObj->setRealstart($this->getRealstart());
        $copyObj->setRealend($this->getRealend());
        $copyObj->setCancelled($this->getCancelled());
        $copyObj->setIsconstruction($this->getIsconstruction());
        $copyObj->setRelevance($this->getRelevance());
        $copyObj->setUserid($this->getUserid());
        $copyObj->setUserbyaffiliatesid($this->getUserbyaffiliatesid());
        $copyObj->setUpdated($this->getUpdated());
        $copyObj->setResponsiblecode($this->getResponsiblecode());
        $copyObj->setStartingyear($this->getStartingyear());
        $copyObj->setEndingyear($this->getEndingyear());
        $copyObj->setSubproject($this->getSubproject());
        $copyObj->setOngoing($this->getOngoing());
        $copyObj->setRelatedareas($this->getRelatedareas());
        $copyObj->setGoal($this->getGoal());
        $copyObj->setLegal($this->getLegal());
        $copyObj->setExecresp($this->getExecresp());
        $copyObj->setExectenure($this->getExectenure());
        $copyObj->setExecdependency($this->getExecdependency());
        $copyObj->setExeccontact($this->getExeccontact());
        $copyObj->setSubsecretary($this->getSubsecretary());
        $copyObj->setBudgetrequested($this->getBudgetrequested());
        $copyObj->setBudgetsanctioned($this->getBudgetsanctioned());
        $copyObj->setBeneficiario($this->getBeneficiario());
        $copyObj->setRequirecontractor($this->getRequirecontractor());
        $copyObj->setPurchasetype($this->getPurchasetype());
        $copyObj->setConstructiontype($this->getConstructiontype());
        $copyObj->setRequireexraresources($this->getRequireexraresources());
        $copyObj->setImplementationpartner($this->getImplementationpartner());
        $copyObj->setRiskfactors($this->getRiskfactors());
        $copyObj->setOwnfinance($this->getOwnfinance());
        $copyObj->setProvincefinance($this->getProvincefinance());
        $copyObj->setNationfinance($this->getNationfinance());
        $copyObj->setOtherfinance($this->getOtherfinance());
        $copyObj->setFinancedetail($this->getFinancedetail());
        $copyObj->setFinanceprogram($this->getFinanceprogram());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return ProjectLog Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ProjectLogPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ProjectLogPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Project object.
     *
     * @param             Project $v
     * @return ProjectLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProject(Project $v = null)
    {
        if ($v === null) {
            $this->setProjectid(NULL);
        } else {
            $this->setProjectid($v->getId());
        }

        $this->aProject = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Project object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectLog($this);
        }


        return $this;
    }


    /**
     * Get the associated Project object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Project The associated Project object.
     * @throws PropelException
     */
    public function getProject(PropelPDO $con = null)
    {
        if ($this->aProject === null && ($this->projectid !== null)) {
            $this->aProject = ProjectQuery::create()->findPk($this->projectid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProject->addProjectLogs($this);
             */
        }

        return $this->aProject;
    }

    /**
     * Declares an association between this object and a Objective object.
     *
     * @param             Objective $v
     * @return ProjectLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setObjective(Objective $v = null)
    {
        if ($v === null) {
            $this->setObjectiveid(NULL);
        } else {
            $this->setObjectiveid($v->getId());
        }

        $this->aObjective = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Objective object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectLog($this);
        }


        return $this;
    }


    /**
     * Get the associated Objective object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Objective The associated Objective object.
     * @throws PropelException
     */
    public function getObjective(PropelPDO $con = null)
    {
        if ($this->aObjective === null && ($this->objectiveid !== null)) {
            $this->aObjective = ObjectiveQuery::create()->findPk($this->objectiveid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aObjective->addProjectLogs($this);
             */
        }

        return $this->aObjective;
    }

    /**
     * Declares an association between this object and a User object.
     *
     * @param             User $v
     * @return ProjectLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setUser(User $v = null)
    {
        if ($v === null) {
            $this->setUserid(NULL);
        } else {
            $this->setUserid($v->getId());
        }

        $this->aUser = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the User object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectLog($this);
        }


        return $this;
    }


    /**
     * Get the associated User object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return User The associated User object.
     * @throws PropelException
     */
    public function getUser(PropelPDO $con = null)
    {
        if ($this->aUser === null && ($this->userid !== null)) {
            $this->aUser = UserQuery::create()->findPk($this->userid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aUser->addProjectLogs($this);
             */
        }

        return $this->aUser;
    }

    /**
     * Declares an association between this object and a Position object.
     *
     * @param             Position $v
     * @return ProjectLog The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPosition(Position $v = null)
    {
        if ($v === null) {
            $this->setResponsiblecode(NULL);
        } else {
            $this->setResponsiblecode($v->getCode());
        }

        $this->aPosition = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Position object, it will not be re-added.
        if ($v !== null) {
            $v->addProjectLog($this);
        }


        return $this;
    }


    /**
     * Get the associated Position object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Position The associated Position object.
     * @throws PropelException
     */
    public function getPosition(PropelPDO $con = null)
    {
        if ($this->aPosition === null && ($this->responsiblecode !== null)) {
            $this->aPosition = PositionQuery::create()
                ->filterByProjectLog($this) // here
                ->findOne($con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPosition->addProjectLogs($this);
             */
        }

        return $this->aPosition;
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->projectid = null;
        $this->objectiveid = null;
        $this->code = null;
        $this->codeaux = null;
        $this->name = null;
        $this->description = null;
        $this->impact = null;
        $this->uniquegoal = null;
        $this->goalexpirationdate = null;
        $this->date = null;
        $this->budget = null;
        $this->exchangerate = null;
        $this->visibility = null;
        $this->coordinateneed = null;
        $this->frequency = null;
        $this->finished = null;
        $this->notes = null;
        $this->postalcode = null;
        $this->uniquegoalnumeric = null;
        $this->goalprogress = null;
        $this->latitude = null;
        $this->longitude = null;
        $this->oldid = null;
        $this->regionid = null;
        $this->oldregionid = null;
        $this->lastmodification = null;
        $this->address = null;
        $this->priority = null;
        $this->modifications = null;
        $this->changes = null;
        $this->plannedstart = null;
        $this->plannedend = null;
        $this->realstart = null;
        $this->realend = null;
        $this->cancelled = null;
        $this->isconstruction = null;
        $this->relevance = null;
        $this->userid = null;
        $this->userbyaffiliatesid = null;
        $this->updated = null;
        $this->responsiblecode = null;
        $this->startingyear = null;
        $this->endingyear = null;
        $this->subproject = null;
        $this->ongoing = null;
        $this->relatedareas = null;
        $this->goal = null;
        $this->legal = null;
        $this->execresp = null;
        $this->exectenure = null;
        $this->execdependency = null;
        $this->execcontact = null;
        $this->subsecretary = null;
        $this->budgetrequested = null;
        $this->budgetsanctioned = null;
        $this->beneficiario = null;
        $this->requirecontractor = null;
        $this->purchasetype = null;
        $this->constructiontype = null;
        $this->requireexraresources = null;
        $this->implementationpartner = null;
        $this->riskfactors = null;
        $this->ownfinance = null;
        $this->provincefinance = null;
        $this->nationfinance = null;
        $this->otherfinance = null;
        $this->financedetail = null;
        $this->financeprogram = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aProject = null;
        $this->aObjective = null;
        $this->aUser = null;
        $this->aPosition = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
